<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class t_trip_info_view extends t_trip_info
{

	// Page ID
	public $PageID = "view";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 't_trip_info';

	// Page object name
	public $PageObjName = "t_trip_info_view";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (t_trip_info)
		if (!isset($GLOBALS["t_trip_info"]) || get_class($GLOBALS["t_trip_info"]) == PROJECT_NAMESPACE . "t_trip_info") {
			$GLOBALS["t_trip_info"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["t_trip_info"];
		}
		$keyUrl = "";
		if (Get("id") !== NULL) {
			$this->RecKey["id"] = Get("id");
			$keyUrl .= "&amp;id=" . urlencode($this->RecKey["id"]);
		}
		$this->ExportPrintUrl = $this->pageUrl() . "export=print" . $keyUrl;
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html" . $keyUrl;
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel" . $keyUrl;
		$this->ExportWordUrl = $this->pageUrl() . "export=word" . $keyUrl;
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml" . $keyUrl;
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv" . $keyUrl;
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf" . $keyUrl;
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'view');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 't_trip_info');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $t_trip_info;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($t_trip_info);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "t_trip_infoview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $ExportOptions; // Export options
	public $OtherOptions; // Other options
	public $DisplayRecs = 1;
	public $DbMasterFilter;
	public $DbDetailFilter;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $RecCnt;
	public $RecKey = array();
	public $IsModal = FALSE;
	public $MultiPages; // Multi pages object

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SkipHeaderFooter, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canView()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("t_trip_infolist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->vehicle_type->setVisibility();
		$this->vehicle->setVisibility();
		$this->_route->setVisibility();
		$this->route_name->setVisibility();
		$this->reports_to->setVisibility();
		$this->buyer->setVisibility();
		$this->b_consignor->setVisibility();
		$this->b_consignee->setVisibility();
		$this->load_date->setVisibility();
		$this->load_weight->setVisibility();
		$this->unload_date->setVisibility();
		$this->unload_weight->setVisibility();
		$this->invoice_no->setVisibility();
		$this->invoice_date->setVisibility();
		$this->amount->setVisibility();
		$this->delivery_pod->setVisibility();
		$this->status->setVisibility();
		$this->days->setVisibility();
		$this->driver->setVisibility();
		$this->driver_name->setVisibility();
		$this->agent->setVisibility();
		$this->comm->setVisibility();
		$this->material->setVisibility();
		$this->packing_type->setVisibility();
		$this->m_hsn->setVisibility();
		$this->_40->setVisibility();
		$this->lr_no->setVisibility();
		$this->km->setVisibility();
		$this->freight_type->setVisibility();
		$this->freight->setVisibility();
		$this->ded_det->setVisibility();
		$this->ded_det_remarks->setVisibility();
		$this->gst_percent->setVisibility();
		$this->gst_amount->setVisibility();
		$this->final_amount->setVisibility();
		$this->load_km->setVisibility();
		$this->unload_km->setVisibility();
		$this->delivery_receipt->setVisibility();
		$this->delivery_docket->setVisibility();
		$this->diesal_op_b->setVisibility();
		$this->diesal_required->setVisibility();
		$this->diesal_fill->setVisibility();
		$this->diesal_amount->setVisibility();
		$this->diesal_cl_balance->setVisibility();
		$this->vehicle_average->setVisibility();
		$this->cash_required->setVisibility();
		$this->cash_op_b->setVisibility();
		$this->cash_paid->setVisibility();
		$this->cash_expenses->setVisibility();
		$this->cash_cl_balance->setVisibility();
		$this->fasttag_op_b->setVisibility();
		$this->fasttag_recharge->setVisibility();
		$this->fasttag_expenses->setVisibility();
		$this->toll_expenses_cash->setVisibility();
		$this->fasttag_cl_balance->setVisibility();
		$this->remarks->setVisibility();
		$this->uploads->setVisibility();
		$this->consignor->setVisibility();
		$this->vehicle_freight_comm->setVisibility();
		$this->vehicle_freight_type->setVisibility();
		$this->vehicle_freight_amount->setVisibility();
		$this->vehicle_freight_final->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->expenses_id->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Set up multi page object
		$this->setupMultiPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->vehicle);
		$this->setupLookupOptions($this->_route);
		$this->setupLookupOptions($this->reports_to);
		$this->setupLookupOptions($this->buyer);
		$this->setupLookupOptions($this->b_consignor);
		$this->setupLookupOptions($this->b_consignee);
		$this->setupLookupOptions($this->driver);
		$this->setupLookupOptions($this->agent);
		$this->setupLookupOptions($this->consignor);
		$this->setupLookupOptions($this->operator);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;

		// Load current record
		$loadCurrentRecord = FALSE;
		$returnUrl = "";
		$matchRecord = FALSE;
		if ($this->isPageRequest()) { // Validate request
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->RecKey["id"] = $this->id->QueryStringValue;
			} elseif (IsApi() && Key(0) != NULL) {
				$this->id->setQueryStringValue(Key(0));
				$this->RecKey["id"] = $this->id->QueryStringValue;
			} elseif (Post("id") !== NULL) {
				$this->id->setFormValue(Post("id"));
				$this->RecKey["id"] = $this->id->FormValue;
			} elseif (IsApi() && Route(2) != NULL) {
				$this->id->setFormValue(Route(2));
				$this->RecKey["id"] = $this->id->FormValue;
			} else {
				$returnUrl = "t_trip_infolist.php"; // Return to list
			}

			// Get action
			$this->CurrentAction = "show"; // Display
			switch ($this->CurrentAction) {
				case "show": // Get a record to display

					// Load record based on key
					if (IsApi()) {
						$filter = $this->getRecordFilter();
						$this->CurrentFilter = $filter;
						$sql = $this->getCurrentSql();
						$conn = &$this->getConnection();
						$this->Recordset = LoadRecordset($sql, $conn);
						$res = $this->Recordset && !$this->Recordset->EOF;
					} else {
						$res = $this->loadRow();
					}
					if (!$res) { // Load record based on key
						if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
							$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
						$returnUrl = "t_trip_infolist.php"; // No matching record, return to list
					}
			}
		} else {
			$returnUrl = "t_trip_infolist.php"; // Not page request, return to list
		}
		if ($returnUrl <> "") {
			$this->terminate($returnUrl);
			return;
		}

		// Set up Breadcrumb
		if (!$this->isExport())
			$this->setupBreadcrumb();

		// Render row
		$this->RowType = ROWTYPE_VIEW;
		$this->resetAttributes();
		$this->renderRow();

		// Set up detail parameters
		$this->setupDetailParms();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset, TRUE); // Get current record only
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows]);
			$this->terminate(TRUE);
		}
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = &$options["action"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("ViewPageAddLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"javascript:void(0);\" onclick=\"ew.modalDialogShow({lnk:this,url:'" . HtmlEncode($this->AddUrl) . "'});\">" . $Language->phrase("ViewPageAddLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("ViewPageAddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->canAdd());

		// Edit
		$item = &$option->add("edit");
		$editcaption = HtmlTitle($Language->phrase("ViewPageEditLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"javascript:void(0);\" onclick=\"ew.modalDialogShow({lnk:this,url:'" . HtmlEncode($this->EditUrl) . "'});\">" . $Language->phrase("ViewPageEditLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("ViewPageEditLink") . "</a>";
		$item->Visible = ($this->EditUrl <> "" && $Security->canEdit());
		$option = &$options["detail"];
		$detailTableLink = "";
		$detailViewTblVar = "";
		$detailCopyTblVar = "";
		$detailEditTblVar = "";

		// "detail_t_expenses_o"
		$item = &$option->add("detail_t_expenses_o");
		$body = $Language->phrase("ViewPageDetailLink") . $Language->TablePhrase("t_expenses_o", "TblCaption");
		$body = "<a class=\"btn btn-default ew-row-link ew-detail\" data-action=\"list\" href=\"" . HtmlEncode("t_expenses_olist.php?" . TABLE_SHOW_MASTER . "=t_trip_info&fk_id=" . urlencode(strval($this->id->CurrentValue)) . "") . "\">" . $body . "</a>";
		$links = "";
		if (!isset($GLOBALS["t_expenses_o_grid"]))
			$GLOBALS["t_expenses_o_grid"] = new t_expenses_o_grid();
		if ($GLOBALS["t_expenses_o_grid"]->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 't_expenses_o')) {
			$links .= "<li><a class=\"ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailViewLink")) . "\" href=\"" . HtmlEncode($this->getViewUrl(TABLE_SHOW_DETAIL . "=t_expenses_o")) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailViewLink")) . "</a></li>";
			if ($detailViewTblVar <> "")
				$detailViewTblVar .= ",";
			$detailViewTblVar .= "t_expenses_o";
		}
		if ($GLOBALS["t_expenses_o_grid"]->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 't_expenses_o')) {
			$links .= "<li><a class=\"ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailEditLink")) . "\" href=\"" . HtmlEncode($this->getEditUrl(TABLE_SHOW_DETAIL . "=t_expenses_o")) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailEditLink")) . "</a></li>";
			if ($detailEditTblVar <> "")
				$detailEditTblVar .= ",";
			$detailEditTblVar .= "t_expenses_o";
		}
		if ($links <> "") {
			$body .= "<button class=\"dropdown-toggle btn btn-default ew-detail\" data-toggle=\"dropdown\"></button>";
			$body .= "<ul class=\"dropdown-menu\">". $links . "</ul>";
		}
		$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
		$item->Body = $body;
		$item->Visible = $Security->allowList(CurrentProjectID() . 't_expenses_o');
		if ($item->Visible) {
			if ($detailTableLink <> "")
				$detailTableLink .= ",";
			$detailTableLink .= "t_expenses_o";
		}
		if ($this->ShowMultipleDetails)
			$item->Visible = FALSE;

		// "detail_t_receipt_d"
		$item = &$option->add("detail_t_receipt_d");
		$body = $Language->phrase("ViewPageDetailLink") . $Language->TablePhrase("t_receipt_d", "TblCaption");
		$body = "<a class=\"btn btn-default ew-row-link ew-detail\" data-action=\"list\" href=\"" . HtmlEncode("t_receipt_dlist.php?" . TABLE_SHOW_MASTER . "=t_trip_info&fk_id=" . urlencode(strval($this->id->CurrentValue)) . "") . "\">" . $body . "</a>";
		$links = "";
		if (!isset($GLOBALS["t_receipt_d_grid"]))
			$GLOBALS["t_receipt_d_grid"] = new t_receipt_d_grid();
		if ($GLOBALS["t_receipt_d_grid"]->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 't_receipt_d')) {
			$links .= "<li><a class=\"ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailViewLink")) . "\" href=\"" . HtmlEncode($this->getViewUrl(TABLE_SHOW_DETAIL . "=t_receipt_d")) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailViewLink")) . "</a></li>";
			if ($detailViewTblVar <> "")
				$detailViewTblVar .= ",";
			$detailViewTblVar .= "t_receipt_d";
		}
		if ($GLOBALS["t_receipt_d_grid"]->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 't_receipt_d')) {
			$links .= "<li><a class=\"ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailEditLink")) . "\" href=\"" . HtmlEncode($this->getEditUrl(TABLE_SHOW_DETAIL . "=t_receipt_d")) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailEditLink")) . "</a></li>";
			if ($detailEditTblVar <> "")
				$detailEditTblVar .= ",";
			$detailEditTblVar .= "t_receipt_d";
		}
		if ($links <> "") {
			$body .= "<button class=\"dropdown-toggle btn btn-default ew-detail\" data-toggle=\"dropdown\"></button>";
			$body .= "<ul class=\"dropdown-menu\">". $links . "</ul>";
		}
		$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
		$item->Body = $body;
		$item->Visible = $Security->allowList(CurrentProjectID() . 't_receipt_d');
		if ($item->Visible) {
			if ($detailTableLink <> "")
				$detailTableLink .= ",";
			$detailTableLink .= "t_receipt_d";
		}
		if ($this->ShowMultipleDetails)
			$item->Visible = FALSE;

		// "detail_t_diesal_expenses"
		$item = &$option->add("detail_t_diesal_expenses");
		$body = $Language->phrase("ViewPageDetailLink") . $Language->TablePhrase("t_diesal_expenses", "TblCaption");
		$body = "<a class=\"btn btn-default ew-row-link ew-detail\" data-action=\"list\" href=\"" . HtmlEncode("t_diesal_expenseslist.php?" . TABLE_SHOW_MASTER . "=t_trip_info&fk_id=" . urlencode(strval($this->id->CurrentValue)) . "") . "\">" . $body . "</a>";
		$links = "";
		if (!isset($GLOBALS["t_diesal_expenses_grid"]))
			$GLOBALS["t_diesal_expenses_grid"] = new t_diesal_expenses_grid();
		if ($GLOBALS["t_diesal_expenses_grid"]->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 't_diesal_expenses')) {
			$links .= "<li><a class=\"ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailViewLink")) . "\" href=\"" . HtmlEncode($this->getViewUrl(TABLE_SHOW_DETAIL . "=t_diesal_expenses")) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailViewLink")) . "</a></li>";
			if ($detailViewTblVar <> "")
				$detailViewTblVar .= ",";
			$detailViewTblVar .= "t_diesal_expenses";
		}
		if ($GLOBALS["t_diesal_expenses_grid"]->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 't_diesal_expenses')) {
			$links .= "<li><a class=\"ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailEditLink")) . "\" href=\"" . HtmlEncode($this->getEditUrl(TABLE_SHOW_DETAIL . "=t_diesal_expenses")) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailEditLink")) . "</a></li>";
			if ($detailEditTblVar <> "")
				$detailEditTblVar .= ",";
			$detailEditTblVar .= "t_diesal_expenses";
		}
		if ($links <> "") {
			$body .= "<button class=\"dropdown-toggle btn btn-default ew-detail\" data-toggle=\"dropdown\"></button>";
			$body .= "<ul class=\"dropdown-menu\">". $links . "</ul>";
		}
		$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
		$item->Body = $body;
		$item->Visible = $Security->allowList(CurrentProjectID() . 't_diesal_expenses');
		if ($item->Visible) {
			if ($detailTableLink <> "")
				$detailTableLink .= ",";
			$detailTableLink .= "t_diesal_expenses";
		}
		if ($this->ShowMultipleDetails)
			$item->Visible = FALSE;

		// "detail_t_route_info"
		$item = &$option->add("detail_t_route_info");
		$body = $Language->phrase("ViewPageDetailLink") . $Language->TablePhrase("t_route_info", "TblCaption");
		$body = "<a class=\"btn btn-default ew-row-link ew-detail\" data-action=\"list\" href=\"" . HtmlEncode("t_route_infolist.php?" . TABLE_SHOW_MASTER . "=t_trip_info&fk__route=" . urlencode(strval($this->_route->CurrentValue)) . "") . "\">" . $body . "</a>";
		$links = "";
		if (!isset($GLOBALS["t_route_info_grid"]))
			$GLOBALS["t_route_info_grid"] = new t_route_info_grid();
		if ($GLOBALS["t_route_info_grid"]->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 't_route_info')) {
			$links .= "<li><a class=\"ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailViewLink")) . "\" href=\"" . HtmlEncode($this->getViewUrl(TABLE_SHOW_DETAIL . "=t_route_info")) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailViewLink")) . "</a></li>";
			if ($detailViewTblVar <> "")
				$detailViewTblVar .= ",";
			$detailViewTblVar .= "t_route_info";
		}
		if ($GLOBALS["t_route_info_grid"]->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 't_route_info')) {
			$links .= "<li><a class=\"ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailEditLink")) . "\" href=\"" . HtmlEncode($this->getEditUrl(TABLE_SHOW_DETAIL . "=t_route_info")) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailEditLink")) . "</a></li>";
			if ($detailEditTblVar <> "")
				$detailEditTblVar .= ",";
			$detailEditTblVar .= "t_route_info";
		}
		if ($links <> "") {
			$body .= "<button class=\"dropdown-toggle btn btn-default ew-detail\" data-toggle=\"dropdown\"></button>";
			$body .= "<ul class=\"dropdown-menu\">". $links . "</ul>";
		}
		$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
		$item->Body = $body;
		$item->Visible = $Security->allowList(CurrentProjectID() . 't_route_info');
		if ($item->Visible) {
			if ($detailTableLink <> "")
				$detailTableLink .= ",";
			$detailTableLink .= "t_route_info";
		}
		if ($this->ShowMultipleDetails)
			$item->Visible = FALSE;

		// Multiple details
		if ($this->ShowMultipleDetails) {
			$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">";
			$links = "";
			if ($detailViewTblVar <> "") {
				$links .= "<li><a class=\"ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailViewLink")) . "\" href=\"" . HtmlEncode($this->getViewUrl(TABLE_SHOW_DETAIL . "=" . $detailViewTblVar)) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailViewLink")) . "</a></li>";
			}
			if ($detailEditTblVar <> "") {
				$links .= "<li><a class=\"ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailEditLink")) . "\" href=\"" . HtmlEncode($this->getEditUrl(TABLE_SHOW_DETAIL . "=" . $detailEditTblVar)) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailEditLink")) . "</a></li>";
			}
			if ($detailCopyTblVar <> "") {
				$links .= "<li><a class=\"ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailCopyLink")) . "\" href=\"" . HtmlEncode($this->getCopyUrl(TABLE_SHOW_DETAIL . "=" . $detailCopyTblVar)) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailCopyLink")) . "</a></li>";
			}
			if ($links <> "") {
				$body .= "<button class=\"dropdown-toggle btn btn-default ew-master-detail\" title=\"" . HtmlTitle($Language->phrase("MultipleMasterDetails")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("MultipleMasterDetails") . "</button>";
				$body .= "<ul class=\"dropdown-menu ew-menu\">". $links . "</ul>";
			}
			$body .= "</div>";

			// Multiple details
			$opt = &$option->add("details");
			$opt->Body = $body;
		}

		// Set up detail default
		$option = &$options["detail"];
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$ar = explode(",", $detailTableLink);
		$cnt = count($ar);
		$option->UseDropDownButton = ($cnt > 1);
		$option->UseButtonGroup = TRUE;
		$item = &$option->add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Set up action default
		$option = &$options["action"];
		$option->DropDownButtonPhrase = $Language->phrase("ButtonActions");
		$option->UseDropDownButton = FALSE;
		$option->UseButtonGroup = TRUE;
		$item = &$option->add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->vehicle_type->setDbValue($row['vehicle_type']);
		$this->vehicle->setDbValue($row['vehicle']);
		$this->_route->setDbValue($row['route']);
		$this->route_name->setDbValue($row['route_name']);
		$this->reports_to->setDbValue($row['reports_to']);
		$this->buyer->setDbValue($row['buyer']);
		$this->b_consignor->setDbValue($row['b_consignor']);
		$this->b_consignee->setDbValue($row['b_consignee']);
		$this->load_date->setDbValue($row['load_date']);
		$this->load_weight->setDbValue($row['load_weight']);
		$this->unload_date->setDbValue($row['unload_date']);
		$this->unload_weight->setDbValue($row['unload_weight']);
		$this->invoice_no->setDbValue($row['invoice_no']);
		$this->invoice_date->setDbValue($row['invoice_date']);
		$this->amount->setDbValue($row['amount']);
		$this->delivery_pod->setDbValue($row['delivery_pod']);
		$this->status->setDbValue($row['status']);
		$this->days->setDbValue($row['days']);
		$this->driver->setDbValue($row['driver']);
		$this->driver_name->setDbValue($row['driver_name']);
		$this->agent->setDbValue($row['agent']);
		if (array_key_exists('EV__agent', $rs->fields)) {
			$this->agent->VirtualValue = $rs->fields('EV__agent'); // Set up virtual field value
		} else {
			$this->agent->VirtualValue = ""; // Clear value
		}
		$this->comm->setDbValue($row['comm']);
		$this->material->setDbValue($row['material']);
		$this->packing_type->setDbValue($row['packing_type']);
		$this->m_hsn->setDbValue($row['m_hsn']);
		$this->_40->setDbValue($row['@']);
		$this->lr_no->setDbValue($row['lr_no']);
		$this->km->setDbValue($row['km']);
		$this->freight_type->setDbValue($row['freight_type']);
		$this->freight->setDbValue($row['freight']);
		$this->ded_det->setDbValue($row['ded_det']);
		$this->ded_det_remarks->setDbValue($row['ded_det_remarks']);
		$this->gst_percent->setDbValue($row['gst_percent']);
		$this->gst_amount->setDbValue($row['gst_amount']);
		$this->final_amount->setDbValue($row['final_amount']);
		$this->load_km->setDbValue($row['load_km']);
		$this->unload_km->setDbValue($row['unload_km']);
		$this->delivery_receipt->Upload->DbValue = $row['delivery_receipt'];
		$this->delivery_receipt->setDbValue($this->delivery_receipt->Upload->DbValue);
		$this->delivery_docket->setDbValue($row['delivery_docket']);
		$this->diesal_op_b->setDbValue($row['diesal_op_b']);
		$this->diesal_required->setDbValue($row['diesal_required']);
		$this->diesal_fill->setDbValue($row['diesal_fill']);
		$this->diesal_amount->setDbValue($row['diesal_amount']);
		$this->diesal_cl_balance->setDbValue($row['diesal_cl_balance']);
		$this->vehicle_average->setDbValue($row['vehicle_average']);
		$this->cash_required->setDbValue($row['cash_required']);
		$this->cash_op_b->setDbValue($row['cash_op_b']);
		$this->cash_paid->setDbValue($row['cash_paid']);
		$this->cash_expenses->setDbValue($row['cash_expenses']);
		$this->cash_cl_balance->setDbValue($row['cash_cl_balance']);
		$this->fasttag_op_b->setDbValue($row['fasttag_op_b']);
		$this->fasttag_recharge->setDbValue($row['fasttag_recharge']);
		$this->fasttag_expenses->setDbValue($row['fasttag_expenses']);
		$this->toll_expenses_cash->setDbValue($row['toll_expenses_cash']);
		$this->fasttag_cl_balance->setDbValue($row['fasttag_cl_balance']);
		$this->remarks->setDbValue($row['remarks']);
		$this->uploads->Upload->DbValue = $row['uploads'];
		$this->uploads->setDbValue($this->uploads->Upload->DbValue);
		$this->consignor->setDbValue($row['consignor']);
		$this->vehicle_freight_comm->setDbValue($row['vehicle_freight_comm']);
		$this->vehicle_freight_type->setDbValue($row['vehicle_freight_type']);
		$this->vehicle_freight_amount->setDbValue($row['vehicle_freight_amount']);
		$this->vehicle_freight_final->setDbValue($row['vehicle_freight_final']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->expenses_id->setDbValue($row['expenses_id']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['vehicle_type'] = NULL;
		$row['vehicle'] = NULL;
		$row['route'] = NULL;
		$row['route_name'] = NULL;
		$row['reports_to'] = NULL;
		$row['buyer'] = NULL;
		$row['b_consignor'] = NULL;
		$row['b_consignee'] = NULL;
		$row['load_date'] = NULL;
		$row['load_weight'] = NULL;
		$row['unload_date'] = NULL;
		$row['unload_weight'] = NULL;
		$row['invoice_no'] = NULL;
		$row['invoice_date'] = NULL;
		$row['amount'] = NULL;
		$row['delivery_pod'] = NULL;
		$row['status'] = NULL;
		$row['days'] = NULL;
		$row['driver'] = NULL;
		$row['driver_name'] = NULL;
		$row['agent'] = NULL;
		$row['comm'] = NULL;
		$row['material'] = NULL;
		$row['packing_type'] = NULL;
		$row['m_hsn'] = NULL;
		$row['@'] = NULL;
		$row['lr_no'] = NULL;
		$row['km'] = NULL;
		$row['freight_type'] = NULL;
		$row['freight'] = NULL;
		$row['ded_det'] = NULL;
		$row['ded_det_remarks'] = NULL;
		$row['gst_percent'] = NULL;
		$row['gst_amount'] = NULL;
		$row['final_amount'] = NULL;
		$row['load_km'] = NULL;
		$row['unload_km'] = NULL;
		$row['delivery_receipt'] = NULL;
		$row['delivery_docket'] = NULL;
		$row['diesal_op_b'] = NULL;
		$row['diesal_required'] = NULL;
		$row['diesal_fill'] = NULL;
		$row['diesal_amount'] = NULL;
		$row['diesal_cl_balance'] = NULL;
		$row['vehicle_average'] = NULL;
		$row['cash_required'] = NULL;
		$row['cash_op_b'] = NULL;
		$row['cash_paid'] = NULL;
		$row['cash_expenses'] = NULL;
		$row['cash_cl_balance'] = NULL;
		$row['fasttag_op_b'] = NULL;
		$row['fasttag_recharge'] = NULL;
		$row['fasttag_expenses'] = NULL;
		$row['toll_expenses_cash'] = NULL;
		$row['fasttag_cl_balance'] = NULL;
		$row['remarks'] = NULL;
		$row['uploads'] = NULL;
		$row['consignor'] = NULL;
		$row['vehicle_freight_comm'] = NULL;
		$row['vehicle_freight_type'] = NULL;
		$row['vehicle_freight_amount'] = NULL;
		$row['vehicle_freight_final'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['expenses_id'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->AddUrl = $this->getAddUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();
		$this->ListUrl = $this->getListUrl();
		$this->setupOtherOptions();

		// Convert decimal values if posted back
		if ($this->amount->FormValue == $this->amount->CurrentValue && is_numeric(ConvertToFloatString($this->amount->CurrentValue)))
			$this->amount->CurrentValue = ConvertToFloatString($this->amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->comm->FormValue == $this->comm->CurrentValue && is_numeric(ConvertToFloatString($this->comm->CurrentValue)))
			$this->comm->CurrentValue = ConvertToFloatString($this->comm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->_40->FormValue == $this->_40->CurrentValue && is_numeric(ConvertToFloatString($this->_40->CurrentValue)))
			$this->_40->CurrentValue = ConvertToFloatString($this->_40->CurrentValue);

		// Convert decimal values if posted back
		if ($this->km->FormValue == $this->km->CurrentValue && is_numeric(ConvertToFloatString($this->km->CurrentValue)))
			$this->km->CurrentValue = ConvertToFloatString($this->km->CurrentValue);

		// Convert decimal values if posted back
		if ($this->freight->FormValue == $this->freight->CurrentValue && is_numeric(ConvertToFloatString($this->freight->CurrentValue)))
			$this->freight->CurrentValue = ConvertToFloatString($this->freight->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ded_det->FormValue == $this->ded_det->CurrentValue && is_numeric(ConvertToFloatString($this->ded_det->CurrentValue)))
			$this->ded_det->CurrentValue = ConvertToFloatString($this->ded_det->CurrentValue);

		// Convert decimal values if posted back
		if ($this->gst_percent->FormValue == $this->gst_percent->CurrentValue && is_numeric(ConvertToFloatString($this->gst_percent->CurrentValue)))
			$this->gst_percent->CurrentValue = ConvertToFloatString($this->gst_percent->CurrentValue);

		// Convert decimal values if posted back
		if ($this->gst_amount->FormValue == $this->gst_amount->CurrentValue && is_numeric(ConvertToFloatString($this->gst_amount->CurrentValue)))
			$this->gst_amount->CurrentValue = ConvertToFloatString($this->gst_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->final_amount->FormValue == $this->final_amount->CurrentValue && is_numeric(ConvertToFloatString($this->final_amount->CurrentValue)))
			$this->final_amount->CurrentValue = ConvertToFloatString($this->final_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->diesal_op_b->FormValue == $this->diesal_op_b->CurrentValue && is_numeric(ConvertToFloatString($this->diesal_op_b->CurrentValue)))
			$this->diesal_op_b->CurrentValue = ConvertToFloatString($this->diesal_op_b->CurrentValue);

		// Convert decimal values if posted back
		if ($this->diesal_required->FormValue == $this->diesal_required->CurrentValue && is_numeric(ConvertToFloatString($this->diesal_required->CurrentValue)))
			$this->diesal_required->CurrentValue = ConvertToFloatString($this->diesal_required->CurrentValue);

		// Convert decimal values if posted back
		if ($this->diesal_fill->FormValue == $this->diesal_fill->CurrentValue && is_numeric(ConvertToFloatString($this->diesal_fill->CurrentValue)))
			$this->diesal_fill->CurrentValue = ConvertToFloatString($this->diesal_fill->CurrentValue);

		// Convert decimal values if posted back
		if ($this->diesal_amount->FormValue == $this->diesal_amount->CurrentValue && is_numeric(ConvertToFloatString($this->diesal_amount->CurrentValue)))
			$this->diesal_amount->CurrentValue = ConvertToFloatString($this->diesal_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->diesal_cl_balance->FormValue == $this->diesal_cl_balance->CurrentValue && is_numeric(ConvertToFloatString($this->diesal_cl_balance->CurrentValue)))
			$this->diesal_cl_balance->CurrentValue = ConvertToFloatString($this->diesal_cl_balance->CurrentValue);

		// Convert decimal values if posted back
		if ($this->vehicle_average->FormValue == $this->vehicle_average->CurrentValue && is_numeric(ConvertToFloatString($this->vehicle_average->CurrentValue)))
			$this->vehicle_average->CurrentValue = ConvertToFloatString($this->vehicle_average->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cash_required->FormValue == $this->cash_required->CurrentValue && is_numeric(ConvertToFloatString($this->cash_required->CurrentValue)))
			$this->cash_required->CurrentValue = ConvertToFloatString($this->cash_required->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cash_op_b->FormValue == $this->cash_op_b->CurrentValue && is_numeric(ConvertToFloatString($this->cash_op_b->CurrentValue)))
			$this->cash_op_b->CurrentValue = ConvertToFloatString($this->cash_op_b->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cash_paid->FormValue == $this->cash_paid->CurrentValue && is_numeric(ConvertToFloatString($this->cash_paid->CurrentValue)))
			$this->cash_paid->CurrentValue = ConvertToFloatString($this->cash_paid->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cash_expenses->FormValue == $this->cash_expenses->CurrentValue && is_numeric(ConvertToFloatString($this->cash_expenses->CurrentValue)))
			$this->cash_expenses->CurrentValue = ConvertToFloatString($this->cash_expenses->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cash_cl_balance->FormValue == $this->cash_cl_balance->CurrentValue && is_numeric(ConvertToFloatString($this->cash_cl_balance->CurrentValue)))
			$this->cash_cl_balance->CurrentValue = ConvertToFloatString($this->cash_cl_balance->CurrentValue);

		// Convert decimal values if posted back
		if ($this->fasttag_op_b->FormValue == $this->fasttag_op_b->CurrentValue && is_numeric(ConvertToFloatString($this->fasttag_op_b->CurrentValue)))
			$this->fasttag_op_b->CurrentValue = ConvertToFloatString($this->fasttag_op_b->CurrentValue);

		// Convert decimal values if posted back
		if ($this->fasttag_recharge->FormValue == $this->fasttag_recharge->CurrentValue && is_numeric(ConvertToFloatString($this->fasttag_recharge->CurrentValue)))
			$this->fasttag_recharge->CurrentValue = ConvertToFloatString($this->fasttag_recharge->CurrentValue);

		// Convert decimal values if posted back
		if ($this->fasttag_expenses->FormValue == $this->fasttag_expenses->CurrentValue && is_numeric(ConvertToFloatString($this->fasttag_expenses->CurrentValue)))
			$this->fasttag_expenses->CurrentValue = ConvertToFloatString($this->fasttag_expenses->CurrentValue);

		// Convert decimal values if posted back
		if ($this->toll_expenses_cash->FormValue == $this->toll_expenses_cash->CurrentValue && is_numeric(ConvertToFloatString($this->toll_expenses_cash->CurrentValue)))
			$this->toll_expenses_cash->CurrentValue = ConvertToFloatString($this->toll_expenses_cash->CurrentValue);

		// Convert decimal values if posted back
		if ($this->fasttag_cl_balance->FormValue == $this->fasttag_cl_balance->CurrentValue && is_numeric(ConvertToFloatString($this->fasttag_cl_balance->CurrentValue)))
			$this->fasttag_cl_balance->CurrentValue = ConvertToFloatString($this->fasttag_cl_balance->CurrentValue);

		// Convert decimal values if posted back
		if ($this->vehicle_freight_comm->FormValue == $this->vehicle_freight_comm->CurrentValue && is_numeric(ConvertToFloatString($this->vehicle_freight_comm->CurrentValue)))
			$this->vehicle_freight_comm->CurrentValue = ConvertToFloatString($this->vehicle_freight_comm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->vehicle_freight_amount->FormValue == $this->vehicle_freight_amount->CurrentValue && is_numeric(ConvertToFloatString($this->vehicle_freight_amount->CurrentValue)))
			$this->vehicle_freight_amount->CurrentValue = ConvertToFloatString($this->vehicle_freight_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->vehicle_freight_final->FormValue == $this->vehicle_freight_final->CurrentValue && is_numeric(ConvertToFloatString($this->vehicle_freight_final->CurrentValue)))
			$this->vehicle_freight_final->CurrentValue = ConvertToFloatString($this->vehicle_freight_final->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// vehicle_type
		// vehicle
		// route
		// route_name
		// reports_to
		// buyer
		// b_consignor
		// b_consignee
		// load_date
		// load_weight
		// unload_date
		// unload_weight
		// invoice_no
		// invoice_date
		// amount
		// delivery_pod
		// status
		// days
		// driver
		// driver_name
		// agent
		// comm
		// material
		// packing_type
		// m_hsn
		// @
		// lr_no
		// km
		// freight_type
		// freight
		// ded_det
		// ded_det_remarks
		// gst_percent
		// gst_amount
		// final_amount
		// load_km
		// unload_km
		// delivery_receipt
		// delivery_docket
		// diesal_op_b
		// diesal_required
		// diesal_fill
		// diesal_amount
		// diesal_cl_balance
		// vehicle_average
		// cash_required
		// cash_op_b
		// cash_paid
		// cash_expenses
		// cash_cl_balance
		// fasttag_op_b
		// fasttag_recharge
		// fasttag_expenses
		// toll_expenses_cash
		// fasttag_cl_balance
		// remarks
		// uploads
		// consignor
		// vehicle_freight_comm
		// vehicle_freight_type
		// vehicle_freight_amount
		// vehicle_freight_final
		// operator
		// datetime
		// expenses_id

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// vehicle_type
			if (strval($this->vehicle_type->CurrentValue) <> "") {
				$this->vehicle_type->ViewValue = $this->vehicle_type->optionCaption($this->vehicle_type->CurrentValue);
			} else {
				$this->vehicle_type->ViewValue = NULL;
			}
			$this->vehicle_type->ViewCustomAttributes = "";

			// vehicle
			$this->vehicle->ViewValue = $this->vehicle->CurrentValue;
			$curVal = strval($this->vehicle->CurrentValue);
			if ($curVal <> "") {
				$this->vehicle->ViewValue = $this->vehicle->lookupCacheOption($curVal);
				if ($this->vehicle->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`status`=1 and `running_status` = 0" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->vehicle->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->vehicle->ViewValue = $this->vehicle->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->vehicle->ViewValue = $this->vehicle->CurrentValue;
					}
				}
			} else {
				$this->vehicle->ViewValue = NULL;
			}
			$this->vehicle->ViewCustomAttributes = "";

			// route
			$this->_route->ViewValue = $this->_route->CurrentValue;
			$curVal = strval($this->_route->CurrentValue);
			if ($curVal <> "") {
				$this->_route->ViewValue = $this->_route->lookupCacheOption($curVal);
				if ($this->_route->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->_route->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->_route->ViewValue = $this->_route->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->_route->ViewValue = $this->_route->CurrentValue;
					}
				}
			} else {
				$this->_route->ViewValue = NULL;
			}
			$this->_route->ViewCustomAttributes = "";

			// route_name
			$this->route_name->ViewValue = $this->route_name->CurrentValue;
			$this->route_name->ViewCustomAttributes = "";

			// reports_to
			$curVal = strval($this->reports_to->CurrentValue);
			if ($curVal <> "") {
				$this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
				if ($this->reports_to->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`activated`=1 and `userlevel`=1003";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->reports_to->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->reports_to->ViewValue = $this->reports_to->CurrentValue;
					}
				}
			} else {
				$this->reports_to->ViewValue = NULL;
			}
			$this->reports_to->ViewCustomAttributes = "";

			// buyer
			$this->buyer->ViewValue = $this->buyer->CurrentValue;
			$curVal = strval($this->buyer->CurrentValue);
			if ($curVal <> "") {
				$this->buyer->ViewValue = $this->buyer->lookupCacheOption($curVal);
				if ($this->buyer->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyer->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->buyer->ViewValue = $this->buyer->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer->ViewValue = $this->buyer->CurrentValue;
					}
				}
			} else {
				$this->buyer->ViewValue = NULL;
			}
			$this->buyer->ViewCustomAttributes = "";

			// b_consignor
			$this->b_consignor->ViewValue = $this->b_consignor->CurrentValue;
			$curVal = strval($this->b_consignor->CurrentValue);
			if ($curVal <> "") {
				$this->b_consignor->ViewValue = $this->b_consignor->lookupCacheOption($curVal);
				if ($this->b_consignor->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_consignor->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->b_consignor->ViewValue = $this->b_consignor->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->b_consignor->ViewValue = $this->b_consignor->CurrentValue;
					}
				}
			} else {
				$this->b_consignor->ViewValue = NULL;
			}
			$this->b_consignor->ViewCustomAttributes = "";

			// b_consignee
			$this->b_consignee->ViewValue = $this->b_consignee->CurrentValue;
			$curVal = strval($this->b_consignee->CurrentValue);
			if ($curVal <> "") {
				$this->b_consignee->ViewValue = $this->b_consignee->lookupCacheOption($curVal);
				if ($this->b_consignee->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_consignee->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->b_consignee->ViewValue = $this->b_consignee->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->b_consignee->ViewValue = $this->b_consignee->CurrentValue;
					}
				}
			} else {
				$this->b_consignee->ViewValue = NULL;
			}
			$this->b_consignee->ViewCustomAttributes = "";

			// load_date
			$this->load_date->ViewValue = $this->load_date->CurrentValue;
			$this->load_date->ViewValue = FormatDateTime($this->load_date->ViewValue, 1);
			$this->load_date->ViewCustomAttributes = "";

			// load_weight
			$this->load_weight->ViewValue = $this->load_weight->CurrentValue;
			$this->load_weight->ViewValue = FormatNumber($this->load_weight->ViewValue, 0, -2, -2, -2);
			$this->load_weight->ViewCustomAttributes = "";

			// unload_date
			$this->unload_date->ViewValue = $this->unload_date->CurrentValue;
			$this->unload_date->ViewValue = FormatDateTime($this->unload_date->ViewValue, 0);
			$this->unload_date->ViewCustomAttributes = "";

			// unload_weight
			$this->unload_weight->ViewValue = $this->unload_weight->CurrentValue;
			$this->unload_weight->ViewValue = FormatNumber($this->unload_weight->ViewValue, 0, -2, -2, -2);
			$this->unload_weight->ViewCustomAttributes = "";

			// invoice_no
			$this->invoice_no->ViewValue = $this->invoice_no->CurrentValue;
			$this->invoice_no->ViewValue = FormatNumber($this->invoice_no->ViewValue, 0, -2, -2, -2);
			$this->invoice_no->ViewCustomAttributes = "";

			// invoice_date
			$this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
			$this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, 0);
			$this->invoice_date->ViewCustomAttributes = "";

			// amount
			$this->amount->ViewValue = $this->amount->CurrentValue;
			$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, -2);
			$this->amount->ViewCustomAttributes = "";

			// delivery_pod
			if (strval($this->delivery_pod->CurrentValue) <> "") {
				$this->delivery_pod->ViewValue = $this->delivery_pod->optionCaption($this->delivery_pod->CurrentValue);
			} else {
				$this->delivery_pod->ViewValue = NULL;
			}
			$this->delivery_pod->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// days
			$this->days->ViewValue = $this->days->CurrentValue;
			$this->days->ViewValue = FormatNumber($this->days->ViewValue, 0, -2, -2, -2);
			$this->days->ViewCustomAttributes = "";

			// driver
			$curVal = strval($this->driver->CurrentValue);
			if ($curVal <> "") {
				$this->driver->ViewValue = $this->driver->lookupCacheOption($curVal);
				if ($this->driver->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->driver->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->driver->ViewValue = $this->driver->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->driver->ViewValue = $this->driver->CurrentValue;
					}
				}
			} else {
				$this->driver->ViewValue = NULL;
			}
			$this->driver->ViewCustomAttributes = "";

			// driver_name
			$this->driver_name->ViewValue = $this->driver_name->CurrentValue;
			$this->driver_name->ViewCustomAttributes = "";

			// agent
			if ($this->agent->VirtualValue <> "") {
				$this->agent->ViewValue = $this->agent->VirtualValue;
			} else {
				$this->agent->ViewValue = $this->agent->CurrentValue;
			$curVal = strval($this->agent->CurrentValue);
			if ($curVal <> "") {
				$this->agent->ViewValue = $this->agent->lookupCacheOption($curVal);
				if ($this->agent->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->agent->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->agent->ViewValue = $this->agent->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->agent->ViewValue = $this->agent->CurrentValue;
					}
				}
			} else {
				$this->agent->ViewValue = NULL;
			}
			}
			$this->agent->ViewCustomAttributes = "";

			// comm
			$this->comm->ViewValue = $this->comm->CurrentValue;
			$this->comm->ViewValue = FormatNumber($this->comm->ViewValue, 2, -2, -2, -2);
			$this->comm->ViewCustomAttributes = "";

			// material
			$this->material->ViewValue = $this->material->CurrentValue;
			$this->material->ViewCustomAttributes = "";

			// packing_type
			$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
			$this->packing_type->ViewCustomAttributes = "";

			// m_hsn
			$this->m_hsn->ViewValue = $this->m_hsn->CurrentValue;
			$this->m_hsn->ViewCustomAttributes = "";

			// @
			$this->_40->ViewValue = $this->_40->CurrentValue;
			$this->_40->ViewValue = FormatNumber($this->_40->ViewValue, 2, -2, -2, -2);
			$this->_40->ViewCustomAttributes = "";

			// lr_no
			$this->lr_no->ViewValue = $this->lr_no->CurrentValue;
			$this->lr_no->ViewCustomAttributes = "";

			// km
			$this->km->ViewValue = $this->km->CurrentValue;
			$this->km->ViewValue = FormatNumber($this->km->ViewValue, 2, -2, -2, -2);
			$this->km->ViewCustomAttributes = "";

			// freight_type
			if (strval($this->freight_type->CurrentValue) <> "") {
				$this->freight_type->ViewValue = $this->freight_type->optionCaption($this->freight_type->CurrentValue);
			} else {
				$this->freight_type->ViewValue = NULL;
			}
			$this->freight_type->ViewCustomAttributes = "";

			// freight
			$this->freight->ViewValue = $this->freight->CurrentValue;
			$this->freight->ViewValue = FormatNumber($this->freight->ViewValue, 2, -2, -2, -2);
			$this->freight->ViewCustomAttributes = "";

			// ded_det
			$this->ded_det->ViewValue = $this->ded_det->CurrentValue;
			$this->ded_det->ViewValue = FormatNumber($this->ded_det->ViewValue, 2, -2, -2, -2);
			$this->ded_det->ViewCustomAttributes = "";

			// ded_det_remarks
			$this->ded_det_remarks->ViewValue = $this->ded_det_remarks->CurrentValue;
			$this->ded_det_remarks->ViewCustomAttributes = "";

			// gst_percent
			$this->gst_percent->ViewValue = $this->gst_percent->CurrentValue;
			$this->gst_percent->ViewValue = FormatNumber($this->gst_percent->ViewValue, 2, -2, -2, -2);
			$this->gst_percent->ViewCustomAttributes = "";

			// gst_amount
			$this->gst_amount->ViewValue = $this->gst_amount->CurrentValue;
			$this->gst_amount->ViewValue = FormatNumber($this->gst_amount->ViewValue, 2, -2, -2, -2);
			$this->gst_amount->ViewCustomAttributes = "";

			// final_amount
			$this->final_amount->ViewValue = $this->final_amount->CurrentValue;
			$this->final_amount->ViewValue = FormatNumber($this->final_amount->ViewValue, 2, -2, -2, -2);
			$this->final_amount->ViewCustomAttributes = "";

			// load_km
			$this->load_km->ViewValue = $this->load_km->CurrentValue;
			$this->load_km->ViewValue = FormatNumber($this->load_km->ViewValue, 0, -2, -2, -2);
			$this->load_km->ViewCustomAttributes = "";

			// unload_km
			$this->unload_km->ViewValue = $this->unload_km->CurrentValue;
			$this->unload_km->ViewValue = FormatNumber($this->unload_km->ViewValue, 0, -2, -2, -2);
			$this->unload_km->ViewCustomAttributes = "";

			// delivery_receipt
			$this->delivery_receipt->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
			if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
				$this->delivery_receipt->ImageWidth = 0;
				$this->delivery_receipt->ImageHeight = 50;
				$this->delivery_receipt->ImageAlt = $this->delivery_receipt->alt();
				$this->delivery_receipt->ViewValue = $this->delivery_receipt->Upload->DbValue;
			} else {
				$this->delivery_receipt->ViewValue = "";
			}
			$this->delivery_receipt->ViewCustomAttributes = "";

			// delivery_docket
			$this->delivery_docket->ViewValue = $this->delivery_docket->CurrentValue;
			$this->delivery_docket->ViewCustomAttributes = "";

			// diesal_op_b
			$this->diesal_op_b->ViewValue = $this->diesal_op_b->CurrentValue;
			$this->diesal_op_b->ViewValue = FormatNumber($this->diesal_op_b->ViewValue, 2, -2, -2, -2);
			$this->diesal_op_b->ViewCustomAttributes = "";

			// diesal_required
			$this->diesal_required->ViewValue = $this->diesal_required->CurrentValue;
			$this->diesal_required->ViewValue = FormatNumber($this->diesal_required->ViewValue, 2, -2, -2, -2);
			$this->diesal_required->ViewCustomAttributes = "";

			// diesal_fill
			$this->diesal_fill->ViewValue = $this->diesal_fill->CurrentValue;
			$this->diesal_fill->ViewValue = FormatNumber($this->diesal_fill->ViewValue, 2, -2, -2, -2);
			$this->diesal_fill->ViewCustomAttributes = "";

			// diesal_amount
			$this->diesal_amount->ViewValue = $this->diesal_amount->CurrentValue;
			$this->diesal_amount->ViewValue = FormatNumber($this->diesal_amount->ViewValue, 2, -2, -2, -2);
			$this->diesal_amount->ViewCustomAttributes = "";

			// diesal_cl_balance
			$this->diesal_cl_balance->ViewValue = $this->diesal_cl_balance->CurrentValue;
			$this->diesal_cl_balance->ViewValue = FormatNumber($this->diesal_cl_balance->ViewValue, 2, -2, -2, -2);
			$this->diesal_cl_balance->ViewCustomAttributes = "";

			// vehicle_average
			$this->vehicle_average->ViewValue = $this->vehicle_average->CurrentValue;
			$this->vehicle_average->ViewValue = FormatNumber($this->vehicle_average->ViewValue, 2, -2, -2, -2);
			$this->vehicle_average->ViewCustomAttributes = "";

			// cash_required
			$this->cash_required->ViewValue = $this->cash_required->CurrentValue;
			$this->cash_required->ViewValue = FormatNumber($this->cash_required->ViewValue, 2, -2, -2, -2);
			$this->cash_required->ViewCustomAttributes = "";

			// cash_op_b
			$this->cash_op_b->ViewValue = $this->cash_op_b->CurrentValue;
			$this->cash_op_b->ViewValue = FormatNumber($this->cash_op_b->ViewValue, 2, -2, -2, -2);
			$this->cash_op_b->ViewCustomAttributes = "";

			// cash_paid
			$this->cash_paid->ViewValue = $this->cash_paid->CurrentValue;
			$this->cash_paid->ViewValue = FormatNumber($this->cash_paid->ViewValue, 2, -2, -2, -2);
			$this->cash_paid->ViewCustomAttributes = "";

			// cash_expenses
			$this->cash_expenses->ViewValue = $this->cash_expenses->CurrentValue;
			$this->cash_expenses->ViewValue = FormatNumber($this->cash_expenses->ViewValue, 2, -2, -2, -2);
			$this->cash_expenses->ViewCustomAttributes = "";

			// cash_cl_balance
			$this->cash_cl_balance->ViewValue = $this->cash_cl_balance->CurrentValue;
			$this->cash_cl_balance->ViewValue = FormatNumber($this->cash_cl_balance->ViewValue, 2, -2, -2, -2);
			$this->cash_cl_balance->ViewCustomAttributes = "";

			// fasttag_op_b
			$this->fasttag_op_b->ViewValue = $this->fasttag_op_b->CurrentValue;
			$this->fasttag_op_b->ViewValue = FormatNumber($this->fasttag_op_b->ViewValue, 2, -2, -2, -2);
			$this->fasttag_op_b->ViewCustomAttributes = "";

			// fasttag_recharge
			$this->fasttag_recharge->ViewValue = $this->fasttag_recharge->CurrentValue;
			$this->fasttag_recharge->ViewValue = FormatNumber($this->fasttag_recharge->ViewValue, 2, -2, -2, -2);
			$this->fasttag_recharge->ViewCustomAttributes = "";

			// fasttag_expenses
			$this->fasttag_expenses->ViewValue = $this->fasttag_expenses->CurrentValue;
			$this->fasttag_expenses->ViewValue = FormatNumber($this->fasttag_expenses->ViewValue, 2, -2, -2, -2);
			$this->fasttag_expenses->ViewCustomAttributes = "";

			// toll_expenses_cash
			$this->toll_expenses_cash->ViewValue = $this->toll_expenses_cash->CurrentValue;
			$this->toll_expenses_cash->ViewValue = FormatNumber($this->toll_expenses_cash->ViewValue, 2, -2, -2, -2);
			$this->toll_expenses_cash->ViewCustomAttributes = "";

			// fasttag_cl_balance
			$this->fasttag_cl_balance->ViewValue = $this->fasttag_cl_balance->CurrentValue;
			$this->fasttag_cl_balance->ViewValue = FormatNumber($this->fasttag_cl_balance->ViewValue, 2, -2, -2, -2);
			$this->fasttag_cl_balance->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// uploads
			$this->uploads->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->ImageWidth = 0;
				$this->uploads->ImageHeight = 50;
				$this->uploads->ImageAlt = $this->uploads->alt();
				$this->uploads->ViewValue = $this->uploads->Upload->DbValue;
			} else {
				$this->uploads->ViewValue = "";
			}
			$this->uploads->ViewCustomAttributes = "";

			// consignor
			$this->consignor->ViewValue = $this->consignor->CurrentValue;
			$curVal = strval($this->consignor->CurrentValue);
			if ($curVal <> "") {
				$this->consignor->ViewValue = $this->consignor->lookupCacheOption($curVal);
				if ($this->consignor->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->consignor->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->consignor->ViewValue = $this->consignor->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->consignor->ViewValue = $this->consignor->CurrentValue;
					}
				}
			} else {
				$this->consignor->ViewValue = NULL;
			}
			$this->consignor->ViewCustomAttributes = "";

			// vehicle_freight_comm
			$this->vehicle_freight_comm->ViewValue = $this->vehicle_freight_comm->CurrentValue;
			$this->vehicle_freight_comm->ViewValue = FormatNumber($this->vehicle_freight_comm->ViewValue, 2, -2, -2, -2);
			$this->vehicle_freight_comm->ViewCustomAttributes = "";

			// vehicle_freight_type
			if (strval($this->vehicle_freight_type->CurrentValue) <> "") {
				$this->vehicle_freight_type->ViewValue = $this->vehicle_freight_type->optionCaption($this->vehicle_freight_type->CurrentValue);
			} else {
				$this->vehicle_freight_type->ViewValue = NULL;
			}
			$this->vehicle_freight_type->ViewCustomAttributes = "";

			// vehicle_freight_amount
			$this->vehicle_freight_amount->ViewValue = $this->vehicle_freight_amount->CurrentValue;
			$this->vehicle_freight_amount->ViewValue = FormatNumber($this->vehicle_freight_amount->ViewValue, 2, -2, -2, -2);
			$this->vehicle_freight_amount->ViewCustomAttributes = "";

			// vehicle_freight_final
			$this->vehicle_freight_final->ViewValue = $this->vehicle_freight_final->CurrentValue;
			$this->vehicle_freight_final->ViewValue = FormatNumber($this->vehicle_freight_final->ViewValue, 2, -2, -2, -2);
			$this->vehicle_freight_final->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// vehicle_type
			$this->vehicle_type->LinkCustomAttributes = "";
			$this->vehicle_type->HrefValue = "";
			$this->vehicle_type->TooltipValue = "";

			// vehicle
			$this->vehicle->LinkCustomAttributes = "";
			$this->vehicle->HrefValue = "";
			$this->vehicle->TooltipValue = "";

			// route
			$this->_route->LinkCustomAttributes = "";
			$this->_route->HrefValue = "";
			$this->_route->TooltipValue = "";

			// route_name
			$this->route_name->LinkCustomAttributes = "";
			$this->route_name->HrefValue = "";
			$this->route_name->TooltipValue = "";

			// reports_to
			$this->reports_to->LinkCustomAttributes = "";
			$this->reports_to->HrefValue = "";
			$this->reports_to->TooltipValue = "";

			// buyer
			$this->buyer->LinkCustomAttributes = "";
			$this->buyer->HrefValue = "";
			$this->buyer->TooltipValue = "";

			// b_consignor
			$this->b_consignor->LinkCustomAttributes = "";
			$this->b_consignor->HrefValue = "";
			$this->b_consignor->TooltipValue = "";

			// b_consignee
			$this->b_consignee->LinkCustomAttributes = "";
			$this->b_consignee->HrefValue = "";
			$this->b_consignee->TooltipValue = "";

			// load_date
			$this->load_date->LinkCustomAttributes = "";
			$this->load_date->HrefValue = "";
			$this->load_date->TooltipValue = "";

			// load_weight
			$this->load_weight->LinkCustomAttributes = "";
			$this->load_weight->HrefValue = "";
			$this->load_weight->TooltipValue = "";

			// unload_date
			$this->unload_date->LinkCustomAttributes = "";
			$this->unload_date->HrefValue = "";
			$this->unload_date->TooltipValue = "";

			// unload_weight
			$this->unload_weight->LinkCustomAttributes = "";
			$this->unload_weight->HrefValue = "";
			$this->unload_weight->TooltipValue = "";

			// invoice_no
			$this->invoice_no->LinkCustomAttributes = "";
			$this->invoice_no->HrefValue = "";
			$this->invoice_no->TooltipValue = "";

			// invoice_date
			$this->invoice_date->LinkCustomAttributes = "";
			$this->invoice_date->HrefValue = "";
			$this->invoice_date->TooltipValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";
			$this->amount->TooltipValue = "";

			// delivery_pod
			$this->delivery_pod->LinkCustomAttributes = "";
			$this->delivery_pod->HrefValue = "";
			$this->delivery_pod->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// days
			$this->days->LinkCustomAttributes = "";
			$this->days->HrefValue = "";
			$this->days->TooltipValue = "";

			// driver
			$this->driver->LinkCustomAttributes = "";
			$this->driver->HrefValue = "";
			$this->driver->TooltipValue = "";

			// driver_name
			$this->driver_name->LinkCustomAttributes = "";
			$this->driver_name->HrefValue = "";
			$this->driver_name->TooltipValue = "";

			// agent
			$this->agent->LinkCustomAttributes = "";
			$this->agent->HrefValue = "";
			$this->agent->TooltipValue = "";

			// comm
			$this->comm->LinkCustomAttributes = "";
			$this->comm->HrefValue = "";
			$this->comm->TooltipValue = "";

			// material
			$this->material->LinkCustomAttributes = "";
			$this->material->HrefValue = "";
			$this->material->TooltipValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			$this->packing_type->HrefValue = "";
			$this->packing_type->TooltipValue = "";

			// m_hsn
			$this->m_hsn->LinkCustomAttributes = "";
			$this->m_hsn->HrefValue = "";
			$this->m_hsn->TooltipValue = "";

			// @
			$this->_40->LinkCustomAttributes = "";
			$this->_40->HrefValue = "";
			$this->_40->TooltipValue = "";

			// lr_no
			$this->lr_no->LinkCustomAttributes = "";
			$this->lr_no->HrefValue = "";
			$this->lr_no->TooltipValue = "";

			// km
			$this->km->LinkCustomAttributes = "";
			$this->km->HrefValue = "";
			$this->km->TooltipValue = "";

			// freight_type
			$this->freight_type->LinkCustomAttributes = "";
			$this->freight_type->HrefValue = "";
			$this->freight_type->TooltipValue = "";

			// freight
			$this->freight->LinkCustomAttributes = "";
			$this->freight->HrefValue = "";
			$this->freight->TooltipValue = "";

			// ded_det
			$this->ded_det->LinkCustomAttributes = "";
			$this->ded_det->HrefValue = "";
			$this->ded_det->TooltipValue = "";

			// ded_det_remarks
			$this->ded_det_remarks->LinkCustomAttributes = "";
			$this->ded_det_remarks->HrefValue = "";
			$this->ded_det_remarks->TooltipValue = "";

			// gst_percent
			$this->gst_percent->LinkCustomAttributes = "";
			$this->gst_percent->HrefValue = "";
			$this->gst_percent->TooltipValue = "";

			// gst_amount
			$this->gst_amount->LinkCustomAttributes = "";
			$this->gst_amount->HrefValue = "";
			$this->gst_amount->TooltipValue = "";

			// final_amount
			$this->final_amount->LinkCustomAttributes = "";
			$this->final_amount->HrefValue = "";
			$this->final_amount->TooltipValue = "";

			// load_km
			$this->load_km->LinkCustomAttributes = "";
			$this->load_km->HrefValue = "";
			$this->load_km->TooltipValue = "";

			// unload_km
			$this->unload_km->LinkCustomAttributes = "";
			$this->unload_km->HrefValue = "";
			$this->unload_km->TooltipValue = "";

			// delivery_receipt
			$this->delivery_receipt->LinkCustomAttributes = "";
			$this->delivery_receipt->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
			if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
				$this->delivery_receipt->HrefValue = "%u"; // Add prefix/suffix
				$this->delivery_receipt->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->delivery_receipt->HrefValue = FullUrl($this->delivery_receipt->HrefValue, "href");
			} else {
				$this->delivery_receipt->HrefValue = "";
			}
			$this->delivery_receipt->ExportHrefValue = $this->delivery_receipt->UploadPath . $this->delivery_receipt->Upload->DbValue;
			$this->delivery_receipt->TooltipValue = "";
			if ($this->delivery_receipt->UseColorbox) {
				if (EmptyValue($this->delivery_receipt->TooltipValue))
					$this->delivery_receipt->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->delivery_receipt->LinkAttrs["data-rel"] = "t_trip_info_x_delivery_receipt";
				AppendClass($this->delivery_receipt->LinkAttrs["class"], "ew-lightbox");
			}

			// delivery_docket
			$this->delivery_docket->LinkCustomAttributes = "";
			$this->delivery_docket->HrefValue = "";
			$this->delivery_docket->TooltipValue = "";

			// diesal_op_b
			$this->diesal_op_b->LinkCustomAttributes = "";
			$this->diesal_op_b->HrefValue = "";
			$this->diesal_op_b->TooltipValue = "";

			// diesal_required
			$this->diesal_required->LinkCustomAttributes = "";
			$this->diesal_required->HrefValue = "";
			$this->diesal_required->TooltipValue = "";

			// diesal_fill
			$this->diesal_fill->LinkCustomAttributes = "";
			$this->diesal_fill->HrefValue = "";
			$this->diesal_fill->TooltipValue = "";

			// diesal_amount
			$this->diesal_amount->LinkCustomAttributes = "";
			$this->diesal_amount->HrefValue = "";
			$this->diesal_amount->TooltipValue = "";

			// diesal_cl_balance
			$this->diesal_cl_balance->LinkCustomAttributes = "";
			$this->diesal_cl_balance->HrefValue = "";
			$this->diesal_cl_balance->TooltipValue = "";

			// vehicle_average
			$this->vehicle_average->LinkCustomAttributes = "";
			$this->vehicle_average->HrefValue = "";
			$this->vehicle_average->TooltipValue = "";

			// cash_required
			$this->cash_required->LinkCustomAttributes = "";
			$this->cash_required->HrefValue = "";
			$this->cash_required->TooltipValue = "";

			// cash_op_b
			$this->cash_op_b->LinkCustomAttributes = "";
			$this->cash_op_b->HrefValue = "";
			$this->cash_op_b->TooltipValue = "";

			// cash_paid
			$this->cash_paid->LinkCustomAttributes = "";
			$this->cash_paid->HrefValue = "";
			$this->cash_paid->TooltipValue = "";

			// cash_expenses
			$this->cash_expenses->LinkCustomAttributes = "";
			$this->cash_expenses->HrefValue = "";
			$this->cash_expenses->TooltipValue = "";

			// cash_cl_balance
			$this->cash_cl_balance->LinkCustomAttributes = "";
			$this->cash_cl_balance->HrefValue = "";
			$this->cash_cl_balance->TooltipValue = "";

			// fasttag_op_b
			$this->fasttag_op_b->LinkCustomAttributes = "";
			$this->fasttag_op_b->HrefValue = "";
			$this->fasttag_op_b->TooltipValue = "";

			// fasttag_recharge
			$this->fasttag_recharge->LinkCustomAttributes = "";
			$this->fasttag_recharge->HrefValue = "";
			$this->fasttag_recharge->TooltipValue = "";

			// fasttag_expenses
			$this->fasttag_expenses->LinkCustomAttributes = "";
			$this->fasttag_expenses->HrefValue = "";
			$this->fasttag_expenses->TooltipValue = "";

			// toll_expenses_cash
			$this->toll_expenses_cash->LinkCustomAttributes = "";
			$this->toll_expenses_cash->HrefValue = "";
			$this->toll_expenses_cash->TooltipValue = "";

			// fasttag_cl_balance
			$this->fasttag_cl_balance->LinkCustomAttributes = "";
			$this->fasttag_cl_balance->HrefValue = "";
			$this->fasttag_cl_balance->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// uploads
			$this->uploads->LinkCustomAttributes = "";
			$this->uploads->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->HrefValue = GetFileUploadUrl($this->uploads, $this->uploads->Upload->DbValue); // Add prefix/suffix
				$this->uploads->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
			} else {
				$this->uploads->HrefValue = "";
			}
			$this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
			$this->uploads->TooltipValue = "";
			if ($this->uploads->UseColorbox) {
				if (EmptyValue($this->uploads->TooltipValue))
					$this->uploads->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->uploads->LinkAttrs["data-rel"] = "t_trip_info_x_uploads";
				AppendClass($this->uploads->LinkAttrs["class"], "ew-lightbox");
			}

			// consignor
			$this->consignor->LinkCustomAttributes = "";
			$this->consignor->HrefValue = "";
			$this->consignor->TooltipValue = "";

			// vehicle_freight_comm
			$this->vehicle_freight_comm->LinkCustomAttributes = "";
			$this->vehicle_freight_comm->HrefValue = "";
			$this->vehicle_freight_comm->TooltipValue = "";

			// vehicle_freight_type
			$this->vehicle_freight_type->LinkCustomAttributes = "";
			$this->vehicle_freight_type->HrefValue = "";
			$this->vehicle_freight_type->TooltipValue = "";

			// vehicle_freight_amount
			$this->vehicle_freight_amount->LinkCustomAttributes = "";
			$this->vehicle_freight_amount->HrefValue = "";
			$this->vehicle_freight_amount->TooltipValue = "";

			// vehicle_freight_final
			$this->vehicle_freight_final->LinkCustomAttributes = "";
			$this->vehicle_freight_final->HrefValue = "";
			$this->vehicle_freight_final->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up detail parms based on QueryString
	protected function setupDetailParms()
	{

		// Get the keys for master table
		if (Get(TABLE_SHOW_DETAIL) !== NULL) {
			$detailTblVar = Get(TABLE_SHOW_DETAIL);
			$this->setCurrentDetailTable($detailTblVar);
		} else {
			$detailTblVar = $this->getCurrentDetailTable();
		}
		if ($detailTblVar <> "") {
			$detailTblVar = explode(",", $detailTblVar);
			if (in_array("t_expenses_o", $detailTblVar)) {
				if (!isset($GLOBALS["t_expenses_o_grid"]))
					$GLOBALS["t_expenses_o_grid"] = new t_expenses_o_grid();
				if ($GLOBALS["t_expenses_o_grid"]->DetailView) {
					$GLOBALS["t_expenses_o_grid"]->CurrentMode = "view";

					// Save current master table to detail table
					$GLOBALS["t_expenses_o_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["t_expenses_o_grid"]->setStartRecordNumber(1);
					$GLOBALS["t_expenses_o_grid"]->trip->IsDetailKey = TRUE;
					$GLOBALS["t_expenses_o_grid"]->trip->CurrentValue = $this->id->CurrentValue;
					$GLOBALS["t_expenses_o_grid"]->trip->setSessionValue($GLOBALS["t_expenses_o_grid"]->trip->CurrentValue);
				}
			}
			if (in_array("t_receipt_d", $detailTblVar)) {
				if (!isset($GLOBALS["t_receipt_d_grid"]))
					$GLOBALS["t_receipt_d_grid"] = new t_receipt_d_grid();
				if ($GLOBALS["t_receipt_d_grid"]->DetailView) {
					$GLOBALS["t_receipt_d_grid"]->CurrentMode = "view";

					// Save current master table to detail table
					$GLOBALS["t_receipt_d_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["t_receipt_d_grid"]->setStartRecordNumber(1);
					$GLOBALS["t_receipt_d_grid"]->trip->IsDetailKey = TRUE;
					$GLOBALS["t_receipt_d_grid"]->trip->CurrentValue = $this->id->CurrentValue;
					$GLOBALS["t_receipt_d_grid"]->trip->setSessionValue($GLOBALS["t_receipt_d_grid"]->trip->CurrentValue);
				}
			}
			if (in_array("t_diesal_expenses", $detailTblVar)) {
				if (!isset($GLOBALS["t_diesal_expenses_grid"]))
					$GLOBALS["t_diesal_expenses_grid"] = new t_diesal_expenses_grid();
				if ($GLOBALS["t_diesal_expenses_grid"]->DetailView) {
					$GLOBALS["t_diesal_expenses_grid"]->CurrentMode = "view";

					// Save current master table to detail table
					$GLOBALS["t_diesal_expenses_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["t_diesal_expenses_grid"]->setStartRecordNumber(1);
					$GLOBALS["t_diesal_expenses_grid"]->trip->IsDetailKey = TRUE;
					$GLOBALS["t_diesal_expenses_grid"]->trip->CurrentValue = $this->id->CurrentValue;
					$GLOBALS["t_diesal_expenses_grid"]->trip->setSessionValue($GLOBALS["t_diesal_expenses_grid"]->trip->CurrentValue);
				}
			}
			if (in_array("t_route_info", $detailTblVar)) {
				if (!isset($GLOBALS["t_route_info_grid"]))
					$GLOBALS["t_route_info_grid"] = new t_route_info_grid();
				if ($GLOBALS["t_route_info_grid"]->DetailView) {
					$GLOBALS["t_route_info_grid"]->CurrentMode = "view";

					// Save current master table to detail table
					$GLOBALS["t_route_info_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["t_route_info_grid"]->setStartRecordNumber(1);
					$GLOBALS["t_route_info_grid"]->id->IsDetailKey = TRUE;
					$GLOBALS["t_route_info_grid"]->id->CurrentValue = $this->_route->CurrentValue;
					$GLOBALS["t_route_info_grid"]->id->setSessionValue($GLOBALS["t_route_info_grid"]->id->CurrentValue);
				}
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("t_trip_infolist.php"), "", $this->TableVar, TRUE);
		$pageId = "view";
		$Breadcrumb->add("view", $pageId, $url);
	}

	// Set up multi pages
	protected function setupMultiPages()
	{
		$pages = new SubPages();
		$pages->Parent = "#" . $this->PageObjName;
		$pages->add(0);
		$pages->add(1);
		$pages->add(2);
		$pages->add(3);
		$pages->add(4);
		$pages->add(5);
		$pages->add(6);
		$pages->add(7);
		$this->MultiPages = $pages;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_vehicle":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`status`=1 and `running_status` = 0" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x__route":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_reports_to":
					$lookupFilter = function() {
						return "`activated`=1 and `userlevel`=1003";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_buyer":
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_consignor":
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_consignee":
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_driver":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_agent":
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_consignor":
					$lookupFilter = function() {
						return "`category` = 902";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_vehicle":
							break;
						case "x__route":
							break;
						case "x_reports_to":
							break;
						case "x_buyer":
							break;
						case "x_b_consignor":
							break;
						case "x_b_consignee":
							break;
						case "x_driver":
							break;
						case "x_agent":
							break;
						case "x_consignor":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
}
?>