<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class t_trip_loadslip_edit extends t_trip_loadslip
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 't_trip_loadslip';

	// Page object name
	public $PageObjName = "t_trip_loadslip_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (t_trip_loadslip)
		if (!isset($GLOBALS["t_trip_loadslip"]) || get_class($GLOBALS["t_trip_loadslip"]) == PROJECT_NAMESPACE . "t_trip_loadslip") {
			$GLOBALS["t_trip_loadslip"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["t_trip_loadslip"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 't_trip_loadslip');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $t_trip_loadslip;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($t_trip_loadslip);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "t_trip_loadslipview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;
	public $MultiPages; // Multi pages object

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("t_trip_loadsliplist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->vehicle_type->setVisibility();
		$this->vehicle->setVisibility();
		$this->_route->setVisibility();
		$this->route_name->setVisibility();
		$this->driver->setVisibility();
		$this->driver_name->setVisibility();
		$this->reports_to->setVisibility();
		$this->buyer->setVisibility();
		$this->b_consignor->setVisibility();
		$this->b_consignee->setVisibility();
		$this->agent->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Set up multi page object
		$this->setupMultiPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->vehicle);
		$this->setupLookupOptions($this->_route);
		$this->setupLookupOptions($this->driver);
		$this->setupLookupOptions($this->reports_to);
		$this->setupLookupOptions($this->buyer);
		$this->setupLookupOptions($this->b_consignor);
		$this->setupLookupOptions($this->b_consignee);
		$this->setupLookupOptions($this->agent);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("t_trip_loadsliplist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "t_trip_loadsliplist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);

		// Check field name 'vehicle_type' first before field var 'x_vehicle_type'
		$val = $CurrentForm->hasValue("vehicle_type") ? $CurrentForm->getValue("vehicle_type") : $CurrentForm->getValue("x_vehicle_type");
		if (!$this->vehicle_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->vehicle_type->Visible = FALSE; // Disable update for API request
			else
				$this->vehicle_type->setFormValue($val);
		}

		// Check field name 'vehicle' first before field var 'x_vehicle'
		$val = $CurrentForm->hasValue("vehicle") ? $CurrentForm->getValue("vehicle") : $CurrentForm->getValue("x_vehicle");
		if (!$this->vehicle->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->vehicle->Visible = FALSE; // Disable update for API request
			else
				$this->vehicle->setFormValue($val);
		}

		// Check field name 'route' first before field var 'x__route'
		$val = $CurrentForm->hasValue("route") ? $CurrentForm->getValue("route") : $CurrentForm->getValue("x__route");
		if (!$this->_route->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_route->Visible = FALSE; // Disable update for API request
			else
				$this->_route->setFormValue($val);
		}

		// Check field name 'route_name' first before field var 'x_route_name'
		$val = $CurrentForm->hasValue("route_name") ? $CurrentForm->getValue("route_name") : $CurrentForm->getValue("x_route_name");
		if (!$this->route_name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->route_name->Visible = FALSE; // Disable update for API request
			else
				$this->route_name->setFormValue($val);
		}

		// Check field name 'driver' first before field var 'x_driver'
		$val = $CurrentForm->hasValue("driver") ? $CurrentForm->getValue("driver") : $CurrentForm->getValue("x_driver");
		if (!$this->driver->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->driver->Visible = FALSE; // Disable update for API request
			else
				$this->driver->setFormValue($val);
		}

		// Check field name 'driver_name' first before field var 'x_driver_name'
		$val = $CurrentForm->hasValue("driver_name") ? $CurrentForm->getValue("driver_name") : $CurrentForm->getValue("x_driver_name");
		if (!$this->driver_name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->driver_name->Visible = FALSE; // Disable update for API request
			else
				$this->driver_name->setFormValue($val);
		}

		// Check field name 'reports_to' first before field var 'x_reports_to'
		$val = $CurrentForm->hasValue("reports_to") ? $CurrentForm->getValue("reports_to") : $CurrentForm->getValue("x_reports_to");
		if (!$this->reports_to->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->reports_to->Visible = FALSE; // Disable update for API request
			else
				$this->reports_to->setFormValue($val);
		}

		// Check field name 'buyer' first before field var 'x_buyer'
		$val = $CurrentForm->hasValue("buyer") ? $CurrentForm->getValue("buyer") : $CurrentForm->getValue("x_buyer");
		if (!$this->buyer->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer->Visible = FALSE; // Disable update for API request
			else
				$this->buyer->setFormValue($val);
		}

		// Check field name 'b_consignor' first before field var 'x_b_consignor'
		$val = $CurrentForm->hasValue("b_consignor") ? $CurrentForm->getValue("b_consignor") : $CurrentForm->getValue("x_b_consignor");
		if (!$this->b_consignor->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_consignor->Visible = FALSE; // Disable update for API request
			else
				$this->b_consignor->setFormValue($val);
		}

		// Check field name 'b_consignee' first before field var 'x_b_consignee'
		$val = $CurrentForm->hasValue("b_consignee") ? $CurrentForm->getValue("b_consignee") : $CurrentForm->getValue("x_b_consignee");
		if (!$this->b_consignee->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_consignee->Visible = FALSE; // Disable update for API request
			else
				$this->b_consignee->setFormValue($val);
		}

		// Check field name 'agent' first before field var 'x_agent'
		$val = $CurrentForm->hasValue("agent") ? $CurrentForm->getValue("agent") : $CurrentForm->getValue("x_agent");
		if (!$this->agent->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->agent->Visible = FALSE; // Disable update for API request
			else
				$this->agent->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->vehicle_type->CurrentValue = $this->vehicle_type->FormValue;
		$this->vehicle->CurrentValue = $this->vehicle->FormValue;
		$this->_route->CurrentValue = $this->_route->FormValue;
		$this->route_name->CurrentValue = $this->route_name->FormValue;
		$this->driver->CurrentValue = $this->driver->FormValue;
		$this->driver_name->CurrentValue = $this->driver_name->FormValue;
		$this->reports_to->CurrentValue = $this->reports_to->FormValue;
		$this->buyer->CurrentValue = $this->buyer->FormValue;
		$this->b_consignor->CurrentValue = $this->b_consignor->FormValue;
		$this->b_consignee->CurrentValue = $this->b_consignee->FormValue;
		$this->agent->CurrentValue = $this->agent->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->vehicle_type->setDbValue($row['vehicle_type']);
		$this->vehicle->setDbValue($row['vehicle']);
		$this->_route->setDbValue($row['route']);
		$this->route_name->setDbValue($row['route_name']);
		$this->driver->setDbValue($row['driver']);
		if (array_key_exists('EV__driver', $rs->fields)) {
			$this->driver->VirtualValue = $rs->fields('EV__driver'); // Set up virtual field value
		} else {
			$this->driver->VirtualValue = ""; // Clear value
		}
		$this->driver_name->setDbValue($row['driver_name']);
		$this->reports_to->setDbValue($row['reports_to']);
		$this->buyer->setDbValue($row['buyer']);
		$this->b_consignor->setDbValue($row['b_consignor']);
		$this->b_consignee->setDbValue($row['b_consignee']);
		$this->agent->setDbValue($row['agent']);
		if (array_key_exists('EV__agent', $rs->fields)) {
			$this->agent->VirtualValue = $rs->fields('EV__agent'); // Set up virtual field value
		} else {
			$this->agent->VirtualValue = ""; // Clear value
		}
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['vehicle_type'] = NULL;
		$row['vehicle'] = NULL;
		$row['route'] = NULL;
		$row['route_name'] = NULL;
		$row['driver'] = NULL;
		$row['driver_name'] = NULL;
		$row['reports_to'] = NULL;
		$row['buyer'] = NULL;
		$row['b_consignor'] = NULL;
		$row['b_consignee'] = NULL;
		$row['agent'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// vehicle_type
		// vehicle
		// route
		// route_name
		// driver
		// driver_name
		// reports_to
		// buyer
		// b_consignor
		// b_consignee
		// agent
		// operator
		// datetime

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// vehicle_type
			if (strval($this->vehicle_type->CurrentValue) <> "") {
				$this->vehicle_type->ViewValue = $this->vehicle_type->optionCaption($this->vehicle_type->CurrentValue);
			} else {
				$this->vehicle_type->ViewValue = NULL;
			}
			$this->vehicle_type->ViewCustomAttributes = "";

			// vehicle
			$this->vehicle->ViewValue = $this->vehicle->CurrentValue;
			$curVal = strval($this->vehicle->CurrentValue);
			if ($curVal <> "") {
				$this->vehicle->ViewValue = $this->vehicle->lookupCacheOption($curVal);
				if ($this->vehicle->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`status`=1 and `running_status` = 0" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->vehicle->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->vehicle->ViewValue = $this->vehicle->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->vehicle->ViewValue = $this->vehicle->CurrentValue;
					}
				}
			} else {
				$this->vehicle->ViewValue = NULL;
			}
			$this->vehicle->ViewCustomAttributes = "";

			// route
			$this->_route->ViewValue = $this->_route->CurrentValue;
			$curVal = strval($this->_route->CurrentValue);
			if ($curVal <> "") {
				$this->_route->ViewValue = $this->_route->lookupCacheOption($curVal);
				if ($this->_route->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->_route->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->_route->ViewValue = $this->_route->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->_route->ViewValue = $this->_route->CurrentValue;
					}
				}
			} else {
				$this->_route->ViewValue = NULL;
			}
			$this->_route->ViewCustomAttributes = "";

			// route_name
			$this->route_name->ViewValue = $this->route_name->CurrentValue;
			$this->route_name->ViewCustomAttributes = "";

			// driver
			if ($this->driver->VirtualValue <> "") {
				$this->driver->ViewValue = $this->driver->VirtualValue;
			} else {
				$this->driver->ViewValue = $this->driver->CurrentValue;
			$curVal = strval($this->driver->CurrentValue);
			if ($curVal <> "") {
				$this->driver->ViewValue = $this->driver->lookupCacheOption($curVal);
				if ($this->driver->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->driver->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->driver->ViewValue = $this->driver->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->driver->ViewValue = $this->driver->CurrentValue;
					}
				}
			} else {
				$this->driver->ViewValue = NULL;
			}
			}
			$this->driver->ViewCustomAttributes = "";

			// driver_name
			$this->driver_name->ViewValue = $this->driver_name->CurrentValue;
			$this->driver_name->ViewCustomAttributes = "";

			// reports_to
			$curVal = strval($this->reports_to->CurrentValue);
			if ($curVal <> "") {
				$this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
				if ($this->reports_to->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`activated`=1 and `userlevel`=1003";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->reports_to->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->reports_to->ViewValue = $this->reports_to->CurrentValue;
					}
				}
			} else {
				$this->reports_to->ViewValue = NULL;
			}
			$this->reports_to->ViewCustomAttributes = "";

			// buyer
			$this->buyer->ViewValue = $this->buyer->CurrentValue;
			$curVal = strval($this->buyer->CurrentValue);
			if ($curVal <> "") {
				$this->buyer->ViewValue = $this->buyer->lookupCacheOption($curVal);
				if ($this->buyer->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyer->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->buyer->ViewValue = $this->buyer->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer->ViewValue = $this->buyer->CurrentValue;
					}
				}
			} else {
				$this->buyer->ViewValue = NULL;
			}
			$this->buyer->ViewCustomAttributes = "";

			// b_consignor
			$curVal = strval($this->b_consignor->CurrentValue);
			if ($curVal <> "") {
				$this->b_consignor->ViewValue = $this->b_consignor->lookupCacheOption($curVal);
				if ($this->b_consignor->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_consignor->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->b_consignor->ViewValue = $this->b_consignor->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->b_consignor->ViewValue = $this->b_consignor->CurrentValue;
					}
				}
			} else {
				$this->b_consignor->ViewValue = NULL;
			}
			$this->b_consignor->ViewCustomAttributes = "";

			// b_consignee
			$curVal = strval($this->b_consignee->CurrentValue);
			if ($curVal <> "") {
				$this->b_consignee->ViewValue = $this->b_consignee->lookupCacheOption($curVal);
				if ($this->b_consignee->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_consignee->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->b_consignee->ViewValue = $this->b_consignee->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->b_consignee->ViewValue = $this->b_consignee->CurrentValue;
					}
				}
			} else {
				$this->b_consignee->ViewValue = NULL;
			}
			$this->b_consignee->ViewCustomAttributes = "";

			// agent
			if ($this->agent->VirtualValue <> "") {
				$this->agent->ViewValue = $this->agent->VirtualValue;
			} else {
				$this->agent->ViewValue = $this->agent->CurrentValue;
			$curVal = strval($this->agent->CurrentValue);
			if ($curVal <> "") {
				$this->agent->ViewValue = $this->agent->lookupCacheOption($curVal);
				if ($this->agent->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->agent->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->agent->ViewValue = $this->agent->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->agent->ViewValue = $this->agent->CurrentValue;
					}
				}
			} else {
				$this->agent->ViewValue = NULL;
			}
			}
			$this->agent->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// vehicle_type
			$this->vehicle_type->LinkCustomAttributes = "";
			$this->vehicle_type->HrefValue = "";
			$this->vehicle_type->TooltipValue = "";

			// vehicle
			$this->vehicle->LinkCustomAttributes = "";
			$this->vehicle->HrefValue = "";
			$this->vehicle->TooltipValue = "";

			// route
			$this->_route->LinkCustomAttributes = "";
			$this->_route->HrefValue = "";
			$this->_route->TooltipValue = "";

			// route_name
			$this->route_name->LinkCustomAttributes = "";
			$this->route_name->HrefValue = "";
			$this->route_name->TooltipValue = "";

			// driver
			$this->driver->LinkCustomAttributes = "";
			$this->driver->HrefValue = "";
			$this->driver->TooltipValue = "";

			// driver_name
			$this->driver_name->LinkCustomAttributes = "";
			$this->driver_name->HrefValue = "";
			$this->driver_name->TooltipValue = "";

			// reports_to
			$this->reports_to->LinkCustomAttributes = "";
			$this->reports_to->HrefValue = "";
			$this->reports_to->TooltipValue = "";

			// buyer
			$this->buyer->LinkCustomAttributes = "";
			$this->buyer->HrefValue = "";
			$this->buyer->TooltipValue = "";

			// b_consignor
			$this->b_consignor->LinkCustomAttributes = "";
			$this->b_consignor->HrefValue = "";
			$this->b_consignor->TooltipValue = "";

			// b_consignee
			$this->b_consignee->LinkCustomAttributes = "";
			$this->b_consignee->HrefValue = "";
			$this->b_consignee->TooltipValue = "";

			// agent
			$this->agent->LinkCustomAttributes = "";
			$this->agent->HrefValue = "";
			$this->agent->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// vehicle_type
			$this->vehicle_type->EditAttrs["class"] = "form-control";
			$this->vehicle_type->EditCustomAttributes = "";
			$this->vehicle_type->EditValue = $this->vehicle_type->options(TRUE);

			// vehicle
			$this->vehicle->EditAttrs["class"] = "form-control";
			$this->vehicle->EditCustomAttributes = "";
			$this->vehicle->EditValue = HtmlEncode($this->vehicle->CurrentValue);
			$curVal = strval($this->vehicle->CurrentValue);
			if ($curVal <> "") {
				$this->vehicle->EditValue = $this->vehicle->lookupCacheOption($curVal);
				if ($this->vehicle->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`status`=1 and `running_status` = 0" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->vehicle->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->vehicle->EditValue = $this->vehicle->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->vehicle->EditValue = HtmlEncode($this->vehicle->CurrentValue);
					}
				}
			} else {
				$this->vehicle->EditValue = NULL;
			}
			$this->vehicle->PlaceHolder = RemoveHtml($this->vehicle->caption());

			// route
			$this->_route->EditAttrs["class"] = "form-control";
			$this->_route->EditCustomAttributes = "";
			$this->_route->EditValue = HtmlEncode($this->_route->CurrentValue);
			$curVal = strval($this->_route->CurrentValue);
			if ($curVal <> "") {
				$this->_route->EditValue = $this->_route->lookupCacheOption($curVal);
				if ($this->_route->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->_route->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->_route->EditValue = $this->_route->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->_route->EditValue = HtmlEncode($this->_route->CurrentValue);
					}
				}
			} else {
				$this->_route->EditValue = NULL;
			}
			$this->_route->PlaceHolder = RemoveHtml($this->_route->caption());

			// route_name
			$this->route_name->EditAttrs["class"] = "form-control";
			$this->route_name->EditCustomAttributes = "";
			$this->route_name->EditValue = $this->route_name->CurrentValue;
			$this->route_name->ViewCustomAttributes = "";

			// driver
			$this->driver->EditAttrs["class"] = "form-control";
			$this->driver->EditCustomAttributes = 'ReadOnly';
			$this->driver->EditValue = HtmlEncode($this->driver->CurrentValue);
			$this->driver->PlaceHolder = RemoveHtml($this->driver->caption());

			// driver_name
			$this->driver_name->EditAttrs["class"] = "form-control";
			$this->driver_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->driver_name->CurrentValue = HtmlDecode($this->driver_name->CurrentValue);
			$this->driver_name->EditValue = HtmlEncode($this->driver_name->CurrentValue);
			$this->driver_name->PlaceHolder = RemoveHtml($this->driver_name->caption());

			// reports_to
			$this->reports_to->EditAttrs["class"] = "form-control";
			$this->reports_to->EditCustomAttributes = "";
			$curVal = trim(strval($this->reports_to->CurrentValue));
			if ($curVal <> "")
				$this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
			else
				$this->reports_to->ViewValue = $this->reports_to->Lookup !== NULL && is_array($this->reports_to->Lookup->Options) ? $curVal : NULL;
			if ($this->reports_to->ViewValue !== NULL) { // Load from cache
				$this->reports_to->EditValue = array_values($this->reports_to->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->reports_to->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`activated`=1 and `userlevel`=1003";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->reports_to->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->reports_to->EditValue = $arwrk;
			}

			// buyer
			$this->buyer->EditAttrs["class"] = "form-control";
			$this->buyer->EditCustomAttributes = "";
			$this->buyer->EditValue = HtmlEncode($this->buyer->CurrentValue);
			$curVal = strval($this->buyer->CurrentValue);
			if ($curVal <> "") {
				$this->buyer->EditValue = $this->buyer->lookupCacheOption($curVal);
				if ($this->buyer->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyer->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$this->buyer->EditValue = $this->buyer->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer->EditValue = HtmlEncode($this->buyer->CurrentValue);
					}
				}
			} else {
				$this->buyer->EditValue = NULL;
			}
			$this->buyer->PlaceHolder = RemoveHtml($this->buyer->caption());

			// b_consignor
			$this->b_consignor->EditCustomAttributes = "";
			$curVal = trim(strval($this->b_consignor->CurrentValue));
			if ($curVal <> "")
				$this->b_consignor->ViewValue = $this->b_consignor->lookupCacheOption($curVal);
			else
				$this->b_consignor->ViewValue = $this->b_consignor->Lookup !== NULL && is_array($this->b_consignor->Lookup->Options) ? $curVal : NULL;
			if ($this->b_consignor->ViewValue !== NULL) { // Load from cache
				$this->b_consignor->EditValue = array_values($this->b_consignor->Lookup->Options);
				if ($this->b_consignor->ViewValue == "")
					$this->b_consignor->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->b_consignor->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`category` = 902 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->b_consignor->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = HtmlEncode($rswrk->fields('df'));
					$this->b_consignor->ViewValue = $this->b_consignor->displayValue($arwrk);
				} else {
					$this->b_consignor->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->b_consignor->EditValue = $arwrk;
			}

			// b_consignee
			$this->b_consignee->EditCustomAttributes = "";
			$curVal = trim(strval($this->b_consignee->CurrentValue));
			if ($curVal <> "")
				$this->b_consignee->ViewValue = $this->b_consignee->lookupCacheOption($curVal);
			else
				$this->b_consignee->ViewValue = $this->b_consignee->Lookup !== NULL && is_array($this->b_consignee->Lookup->Options) ? $curVal : NULL;
			if ($this->b_consignee->ViewValue !== NULL) { // Load from cache
				$this->b_consignee->EditValue = array_values($this->b_consignee->Lookup->Options);
				if ($this->b_consignee->ViewValue == "")
					$this->b_consignee->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->b_consignee->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`category` = 902 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->b_consignee->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = HtmlEncode($rswrk->fields('df'));
					$this->b_consignee->ViewValue = $this->b_consignee->displayValue($arwrk);
				} else {
					$this->b_consignee->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->b_consignee->EditValue = $arwrk;
			}

			// agent
			$this->agent->EditAttrs["class"] = "form-control";
			$this->agent->EditCustomAttributes = "";
			$this->agent->EditValue = HtmlEncode($this->agent->CurrentValue);
			$curVal = strval($this->agent->CurrentValue);
			if ($curVal <> "") {
				$this->agent->EditValue = $this->agent->lookupCacheOption($curVal);
				if ($this->agent->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->agent->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$this->agent->EditValue = $this->agent->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->agent->EditValue = HtmlEncode($this->agent->CurrentValue);
					}
				}
			} else {
				$this->agent->EditValue = NULL;
			}
			$this->agent->PlaceHolder = RemoveHtml($this->agent->caption());

			// operator
			// datetime
			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// vehicle_type
			$this->vehicle_type->LinkCustomAttributes = "";
			$this->vehicle_type->HrefValue = "";

			// vehicle
			$this->vehicle->LinkCustomAttributes = "";
			$this->vehicle->HrefValue = "";

			// route
			$this->_route->LinkCustomAttributes = "";
			$this->_route->HrefValue = "";

			// route_name
			$this->route_name->LinkCustomAttributes = "";
			$this->route_name->HrefValue = "";
			$this->route_name->TooltipValue = "";

			// driver
			$this->driver->LinkCustomAttributes = "";
			$this->driver->HrefValue = "";

			// driver_name
			$this->driver_name->LinkCustomAttributes = "";
			$this->driver_name->HrefValue = "";

			// reports_to
			$this->reports_to->LinkCustomAttributes = "";
			$this->reports_to->HrefValue = "";

			// buyer
			$this->buyer->LinkCustomAttributes = "";
			$this->buyer->HrefValue = "";

			// b_consignor
			$this->b_consignor->LinkCustomAttributes = "";
			$this->b_consignor->HrefValue = "";

			// b_consignee
			$this->b_consignee->LinkCustomAttributes = "";
			$this->b_consignee->HrefValue = "";

			// agent
			$this->agent->LinkCustomAttributes = "";
			$this->agent->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->vehicle_type->Required) {
			if (!$this->vehicle_type->IsDetailKey && $this->vehicle_type->FormValue != NULL && $this->vehicle_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->vehicle_type->caption(), $this->vehicle_type->RequiredErrorMessage));
			}
		}
		if ($this->vehicle->Required) {
			if (!$this->vehicle->IsDetailKey && $this->vehicle->FormValue != NULL && $this->vehicle->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->vehicle->caption(), $this->vehicle->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->vehicle->FormValue)) {
			AddMessage($FormError, $this->vehicle->errorMessage());
		}
		if ($this->_route->Required) {
			if (!$this->_route->IsDetailKey && $this->_route->FormValue != NULL && $this->_route->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_route->caption(), $this->_route->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->_route->FormValue)) {
			AddMessage($FormError, $this->_route->errorMessage());
		}
		if ($this->route_name->Required) {
			if (!$this->route_name->IsDetailKey && $this->route_name->FormValue != NULL && $this->route_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->route_name->caption(), $this->route_name->RequiredErrorMessage));
			}
		}
		if ($this->driver->Required) {
			if (!$this->driver->IsDetailKey && $this->driver->FormValue != NULL && $this->driver->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->driver->caption(), $this->driver->RequiredErrorMessage));
			}
		}
		if ($this->driver_name->Required) {
			if (!$this->driver_name->IsDetailKey && $this->driver_name->FormValue != NULL && $this->driver_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->driver_name->caption(), $this->driver_name->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->driver_name->FormValue)) {
			AddMessage($FormError, $this->driver_name->errorMessage());
		}
		if ($this->reports_to->Required) {
			if (!$this->reports_to->IsDetailKey && $this->reports_to->FormValue != NULL && $this->reports_to->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->reports_to->caption(), $this->reports_to->RequiredErrorMessage));
			}
		}
		if ($this->buyer->Required) {
			if (!$this->buyer->IsDetailKey && $this->buyer->FormValue != NULL && $this->buyer->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer->caption(), $this->buyer->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->buyer->FormValue)) {
			AddMessage($FormError, $this->buyer->errorMessage());
		}
		if ($this->b_consignor->Required) {
			if (!$this->b_consignor->IsDetailKey && $this->b_consignor->FormValue != NULL && $this->b_consignor->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_consignor->caption(), $this->b_consignor->RequiredErrorMessage));
			}
		}
		if ($this->b_consignee->Required) {
			if (!$this->b_consignee->IsDetailKey && $this->b_consignee->FormValue != NULL && $this->b_consignee->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_consignee->caption(), $this->b_consignee->RequiredErrorMessage));
			}
		}
		if ($this->agent->Required) {
			if (!$this->agent->IsDetailKey && $this->agent->FormValue != NULL && $this->agent->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->agent->caption(), $this->agent->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// vehicle_type
			$this->vehicle_type->setDbValueDef($rsnew, $this->vehicle_type->CurrentValue, 0, $this->vehicle_type->ReadOnly);

			// vehicle
			$this->vehicle->setDbValueDef($rsnew, $this->vehicle->CurrentValue, 0, $this->vehicle->ReadOnly);

			// route
			$this->_route->setDbValueDef($rsnew, $this->_route->CurrentValue, 0, $this->_route->ReadOnly);

			// driver
			$this->driver->setDbValueDef($rsnew, $this->driver->CurrentValue, NULL, $this->driver->ReadOnly);

			// driver_name
			$this->driver_name->setDbValueDef($rsnew, $this->driver_name->CurrentValue, NULL, $this->driver_name->ReadOnly);

			// reports_to
			$this->reports_to->setDbValueDef($rsnew, $this->reports_to->CurrentValue, NULL, $this->reports_to->ReadOnly);

			// buyer
			$this->buyer->setDbValueDef($rsnew, $this->buyer->CurrentValue, 0, $this->buyer->ReadOnly);

			// b_consignor
			$this->b_consignor->setDbValueDef($rsnew, $this->b_consignor->CurrentValue, NULL, $this->b_consignor->ReadOnly);

			// b_consignee
			$this->b_consignee->setDbValueDef($rsnew, $this->b_consignee->CurrentValue, NULL, $this->b_consignee->ReadOnly);

			// agent
			$this->agent->setDbValueDef($rsnew, $this->agent->CurrentValue, NULL, $this->agent->ReadOnly);

			// operator
			$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['operator'] = &$this->operator->DbValue;

			// datetime
			$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
			$rsnew['datetime'] = &$this->datetime->DbValue;

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("t_trip_loadsliplist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Set up multi pages
	protected function setupMultiPages()
	{
		$pages = new SubPages();
		$pages->Parent = "#" . $this->PageObjName;
		$pages->add(0);
		$pages->add(1);
		$this->MultiPages = $pages;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_vehicle":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`status`=1 and `running_status` = 0" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x__route":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_driver":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_reports_to":
					$lookupFilter = function() {
						return "`activated`=1 and `userlevel`=1003";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_buyer":
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_consignor":
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_consignee":
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_agent":
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_vehicle":
							break;
						case "x__route":
							break;
						case "x_driver":
							break;
						case "x_reports_to":
							break;
						case "x_buyer":
							break;
						case "x_b_consignor":
							break;
						case "x_b_consignee":
							break;
						case "x_agent":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>