<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for t_trip_start
 */
class t_trip_start extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $vehicle_type;
	public $vehicle;
	public $_route;
	public $reports_to;
	public $vehicle_freight_type;
	public $vehicle_freight_amount;
	public $material;
	public $_40;
	public $buyer;
	public $agent;
	public $comm;
	public $load_date;
	public $load_weight;
	public $load_km;
	public $gst_percent;
	public $driver;
	public $remarks;
	public $vehicle_freight_comm;
	public $freight_type;
	public $freight;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 't_trip_start';
		$this->TableName = 't_trip_start';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`t_trip_start`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('t_trip_start', 't_trip_start', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// vehicle_type
		$this->vehicle_type = new DbField('t_trip_start', 't_trip_start', 'x_vehicle_type', 'vehicle_type', '`vehicle_type`', '`vehicle_type`', 18, -1, FALSE, '`vehicle_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->vehicle_type->Nullable = FALSE; // NOT NULL field
		$this->vehicle_type->Sortable = TRUE; // Allow sort
		$this->vehicle_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->vehicle_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->vehicle_type->Lookup = new Lookup('vehicle_type', 't_trip_start', FALSE, '', ["","","",""], [], ["x_vehicle"], [], [], [], [], '', '');
		$this->vehicle_type->OptionCount = 2;
		$this->vehicle_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['vehicle_type'] = &$this->vehicle_type;

		// vehicle
		$this->vehicle = new DbField('t_trip_start', 't_trip_start', 'x_vehicle', 'vehicle', '`vehicle`', '`vehicle`', 18, -1, FALSE, '`vehicle`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->vehicle->Nullable = FALSE; // NOT NULL field
		$this->vehicle->Required = TRUE; // Required field
		$this->vehicle->Sortable = TRUE; // Allow sort
		$this->vehicle->Lookup = new Lookup('vehicle', 'vehicle_info', FALSE, 'id', ["no","","",""], ["x_vehicle_type"], [], ["type"], ["x_type"], ["driver_name"], ["x_driver"], '`no` ASC', '');
		$this->vehicle->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['vehicle'] = &$this->vehicle;

		// route
		$this->_route = new DbField('t_trip_start', 't_trip_start', 'x__route', 'route', '`route`', '`route`', 18, -1, FALSE, '`route`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_route->Nullable = FALSE; // NOT NULL field
		$this->_route->Required = TRUE; // Required field
		$this->_route->Sortable = TRUE; // Allow sort
		$this->_route->Lookup = new Lookup('route', 't_route_info', FALSE, 'id', ["route_name","","",""], [], [], [], [], [], [], '`route_name` ASC', '');
		$this->_route->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['route'] = &$this->_route;

		// reports_to
		$this->reports_to = new DbField('t_trip_start', 't_trip_start', 'x_reports_to', 'reports_to', '`reports_to`', '`reports_to`', 18, -1, FALSE, '`reports_to`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->reports_to->Sortable = TRUE; // Allow sort
		$this->reports_to->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->reports_to->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->reports_to->Lookup = new Lookup('reports_to', 'admin', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->reports_to->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['reports_to'] = &$this->reports_to;

		// vehicle_freight_type
		$this->vehicle_freight_type = new DbField('t_trip_start', 't_trip_start', 'x_vehicle_freight_type', 'vehicle_freight_type', '`vehicle_freight_type`', '`vehicle_freight_type`', 18, -1, FALSE, '`vehicle_freight_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->vehicle_freight_type->Nullable = FALSE; // NOT NULL field
		$this->vehicle_freight_type->Sortable = TRUE; // Allow sort
		$this->vehicle_freight_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->vehicle_freight_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->vehicle_freight_type->Lookup = new Lookup('vehicle_freight_type', 't_trip_start', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->vehicle_freight_type->OptionCount = 2;
		$this->vehicle_freight_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['vehicle_freight_type'] = &$this->vehicle_freight_type;

		// vehicle_freight_amount
		$this->vehicle_freight_amount = new DbField('t_trip_start', 't_trip_start', 'x_vehicle_freight_amount', 'vehicle_freight_amount', '`vehicle_freight_amount`', '`vehicle_freight_amount`', 131, -1, FALSE, '`vehicle_freight_amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->vehicle_freight_amount->Nullable = FALSE; // NOT NULL field
		$this->vehicle_freight_amount->Sortable = TRUE; // Allow sort
		$this->vehicle_freight_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['vehicle_freight_amount'] = &$this->vehicle_freight_amount;

		// material
		$this->material = new DbField('t_trip_start', 't_trip_start', 'x_material', 'material', '`material`', '`material`', 200, -1, FALSE, '`material`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->material->Nullable = FALSE; // NOT NULL field
		$this->material->Required = TRUE; // Required field
		$this->material->Sortable = TRUE; // Allow sort
		$this->fields['material'] = &$this->material;

		// @
		$this->_40 = new DbField('t_trip_start', 't_trip_start', 'x__40', '@', '`@`', '`@`', 131, -1, FALSE, '`@`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_40->Nullable = FALSE; // NOT NULL field
		$this->_40->Required = TRUE; // Required field
		$this->_40->Sortable = TRUE; // Allow sort
		$this->_40->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['@'] = &$this->_40;

		// buyer
		$this->buyer = new DbField('t_trip_start', 't_trip_start', 'x_buyer', 'buyer', '`buyer`', '`buyer`', 18, -1, FALSE, '`buyer`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer->Nullable = FALSE; // NOT NULL field
		$this->buyer->Required = TRUE; // Required field
		$this->buyer->Sortable = TRUE; // Allow sort
		$this->buyer->Lookup = new Lookup('buyer', 'buyer', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->buyer->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['buyer'] = &$this->buyer;

		// agent
		$this->agent = new DbField('t_trip_start', 't_trip_start', 'x_agent', 'agent', '`agent`', '`agent`', 18, -1, FALSE, '`EV__agent`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->agent->Sortable = TRUE; // Allow sort
		$this->agent->Lookup = new Lookup('agent', 'buyer', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->agent->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['agent'] = &$this->agent;

		// comm
		$this->comm = new DbField('t_trip_start', 't_trip_start', 'x_comm', 'comm', '`comm`', '`comm`', 131, -1, FALSE, '`comm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->comm->Nullable = FALSE; // NOT NULL field
		$this->comm->Sortable = TRUE; // Allow sort
		$this->comm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['comm'] = &$this->comm;

		// load_date
		$this->load_date = new DbField('t_trip_start', 't_trip_start', 'x_load_date', 'load_date', '`load_date`', CastDateFieldForLike('`load_date`', 1, "DB"), 135, 1, FALSE, '`load_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->load_date->Nullable = FALSE; // NOT NULL field
		$this->load_date->Required = TRUE; // Required field
		$this->load_date->Sortable = TRUE; // Allow sort
		$this->load_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['load_date'] = &$this->load_date;

		// load_weight
		$this->load_weight = new DbField('t_trip_start', 't_trip_start', 'x_load_weight', 'load_weight', '`load_weight`', '`load_weight`', 18, -1, FALSE, '`load_weight`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->load_weight->Sortable = TRUE; // Allow sort
		$this->load_weight->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['load_weight'] = &$this->load_weight;

		// load_km
		$this->load_km = new DbField('t_trip_start', 't_trip_start', 'x_load_km', 'load_km', '`load_km`', '`load_km`', 3, -1, FALSE, '`load_km`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->load_km->Nullable = FALSE; // NOT NULL field
		$this->load_km->Required = TRUE; // Required field
		$this->load_km->Sortable = TRUE; // Allow sort
		$this->load_km->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['load_km'] = &$this->load_km;

		// gst_percent
		$this->gst_percent = new DbField('t_trip_start', 't_trip_start', 'x_gst_percent', 'gst_percent', '`gst_percent`', '`gst_percent`', 131, -1, FALSE, '`gst_percent`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->gst_percent->Nullable = FALSE; // NOT NULL field
		$this->gst_percent->Sortable = TRUE; // Allow sort
		$this->gst_percent->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['gst_percent'] = &$this->gst_percent;

		// driver
		$this->driver = new DbField('t_trip_start', 't_trip_start', 'x_driver', 'driver', '`driver`', '`driver`', 2, -1, FALSE, '`driver`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->driver->Sortable = TRUE; // Allow sort
		$this->fields['driver'] = &$this->driver;

		// remarks
		$this->remarks = new DbField('t_trip_start', 't_trip_start', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 201, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->remarks->Sortable = FALSE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// vehicle_freight_comm
		$this->vehicle_freight_comm = new DbField('t_trip_start', 't_trip_start', 'x_vehicle_freight_comm', 'vehicle_freight_comm', '`vehicle_freight_comm`', '`vehicle_freight_comm`', 131, -1, FALSE, '`vehicle_freight_comm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->vehicle_freight_comm->Nullable = FALSE; // NOT NULL field
		$this->vehicle_freight_comm->Sortable = TRUE; // Allow sort
		$this->vehicle_freight_comm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['vehicle_freight_comm'] = &$this->vehicle_freight_comm;

		// freight_type
		$this->freight_type = new DbField('t_trip_start', 't_trip_start', 'x_freight_type', 'freight_type', '`freight_type`', '`freight_type`', 18, -1, FALSE, '`freight_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->freight_type->Nullable = FALSE; // NOT NULL field
		$this->freight_type->Sortable = TRUE; // Allow sort
		$this->freight_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->freight_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->freight_type->Lookup = new Lookup('freight_type', 't_trip_start', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->freight_type->OptionCount = 2;
		$this->freight_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['freight_type'] = &$this->freight_type;

		// freight
		$this->freight = new DbField('t_trip_start', 't_trip_start', 'x_freight', 'freight', '`freight`', '`freight`', 131, -1, FALSE, '`freight`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->freight->Nullable = FALSE; // NOT NULL field
		$this->freight->Required = TRUE; // Required field
		$this->freight->Sortable = TRUE; // Allow sort
		$this->freight->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['freight'] = &$this->freight;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`t_trip_start`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, (SELECT `name` FROM `buyer` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `t_trip_start`.`agent` LIMIT 1) AS `EV__agent` FROM `t_trip_start`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() <> "")
			return TRUE;
		if ($this->agent->AdvancedSearch->SearchValue <> "" ||
			$this->agent->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->agent->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->agent->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->vehicle_type->DbValue = $row['vehicle_type'];
		$this->vehicle->DbValue = $row['vehicle'];
		$this->_route->DbValue = $row['route'];
		$this->reports_to->DbValue = $row['reports_to'];
		$this->vehicle_freight_type->DbValue = $row['vehicle_freight_type'];
		$this->vehicle_freight_amount->DbValue = $row['vehicle_freight_amount'];
		$this->material->DbValue = $row['material'];
		$this->_40->DbValue = $row['@'];
		$this->buyer->DbValue = $row['buyer'];
		$this->agent->DbValue = $row['agent'];
		$this->comm->DbValue = $row['comm'];
		$this->load_date->DbValue = $row['load_date'];
		$this->load_weight->DbValue = $row['load_weight'];
		$this->load_km->DbValue = $row['load_km'];
		$this->gst_percent->DbValue = $row['gst_percent'];
		$this->driver->DbValue = $row['driver'];
		$this->remarks->DbValue = $row['remarks'];
		$this->vehicle_freight_comm->DbValue = $row['vehicle_freight_comm'];
		$this->freight_type->DbValue = $row['freight_type'];
		$this->freight->DbValue = $row['freight'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "t_trip_startlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "t_trip_startview.php")
			return $Language->phrase("View");
		elseif ($pageName == "t_trip_startedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "t_trip_startadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "t_trip_startlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("t_trip_startview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("t_trip_startview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "t_trip_startadd.php?" . $this->getUrlParm($parm);
		else
			$url = "t_trip_startadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("t_trip_startedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("t_trip_startadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("t_trip_startdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->vehicle_type->setDbValue($rs->fields('vehicle_type'));
		$this->vehicle->setDbValue($rs->fields('vehicle'));
		$this->_route->setDbValue($rs->fields('route'));
		$this->reports_to->setDbValue($rs->fields('reports_to'));
		$this->vehicle_freight_type->setDbValue($rs->fields('vehicle_freight_type'));
		$this->vehicle_freight_amount->setDbValue($rs->fields('vehicle_freight_amount'));
		$this->material->setDbValue($rs->fields('material'));
		$this->_40->setDbValue($rs->fields('@'));
		$this->buyer->setDbValue($rs->fields('buyer'));
		$this->agent->setDbValue($rs->fields('agent'));
		$this->comm->setDbValue($rs->fields('comm'));
		$this->load_date->setDbValue($rs->fields('load_date'));
		$this->load_weight->setDbValue($rs->fields('load_weight'));
		$this->load_km->setDbValue($rs->fields('load_km'));
		$this->gst_percent->setDbValue($rs->fields('gst_percent'));
		$this->driver->setDbValue($rs->fields('driver'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->vehicle_freight_comm->setDbValue($rs->fields('vehicle_freight_comm'));
		$this->freight_type->setDbValue($rs->fields('freight_type'));
		$this->freight->setDbValue($rs->fields('freight'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// vehicle_type
		// vehicle
		// route
		// reports_to
		// vehicle_freight_type
		// vehicle_freight_amount
		// material
		// @
		// buyer
		// agent
		// comm
		// load_date
		// load_weight
		// load_km
		// gst_percent
		// driver
		// remarks
		// vehicle_freight_comm
		// freight_type
		// freight
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// vehicle_type
		if (strval($this->vehicle_type->CurrentValue) <> "") {
			$this->vehicle_type->ViewValue = $this->vehicle_type->optionCaption($this->vehicle_type->CurrentValue);
		} else {
			$this->vehicle_type->ViewValue = NULL;
		}
		$this->vehicle_type->ViewCustomAttributes = "";

		// vehicle
		$this->vehicle->ViewValue = $this->vehicle->CurrentValue;
		$curVal = strval($this->vehicle->CurrentValue);
		if ($curVal <> "") {
			$this->vehicle->ViewValue = $this->vehicle->lookupCacheOption($curVal);
			if ($this->vehicle->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`status`=1 and `running_status` = 0" : "";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->vehicle->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->vehicle->ViewValue = $this->vehicle->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->vehicle->ViewValue = $this->vehicle->CurrentValue;
				}
			}
		} else {
			$this->vehicle->ViewValue = NULL;
		}
		$this->vehicle->ViewCustomAttributes = "";

		// route
		$this->_route->ViewValue = $this->_route->CurrentValue;
		$curVal = strval($this->_route->CurrentValue);
		if ($curVal <> "") {
			$this->_route->ViewValue = $this->_route->lookupCacheOption($curVal);
			if ($this->_route->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->_route->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->_route->ViewValue = $this->_route->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->_route->ViewValue = $this->_route->CurrentValue;
				}
			}
		} else {
			$this->_route->ViewValue = NULL;
		}
		$this->_route->ViewCustomAttributes = "";

		// reports_to
		$curVal = strval($this->reports_to->CurrentValue);
		if ($curVal <> "") {
			$this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
			if ($this->reports_to->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`activated`=1 and `userlevel`=1003";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->reports_to->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->reports_to->ViewValue = $this->reports_to->CurrentValue;
				}
			}
		} else {
			$this->reports_to->ViewValue = NULL;
		}
		$this->reports_to->ViewCustomAttributes = "";

		// vehicle_freight_type
		if (strval($this->vehicle_freight_type->CurrentValue) <> "") {
			$this->vehicle_freight_type->ViewValue = $this->vehicle_freight_type->optionCaption($this->vehicle_freight_type->CurrentValue);
		} else {
			$this->vehicle_freight_type->ViewValue = NULL;
		}
		$this->vehicle_freight_type->ViewCustomAttributes = "";

		// vehicle_freight_amount
		$this->vehicle_freight_amount->ViewValue = $this->vehicle_freight_amount->CurrentValue;
		$this->vehicle_freight_amount->ViewValue = FormatNumber($this->vehicle_freight_amount->ViewValue, 2, -2, -2, -2);
		$this->vehicle_freight_amount->ViewCustomAttributes = "";

		// material
		$this->material->ViewValue = $this->material->CurrentValue;
		$this->material->ViewCustomAttributes = "";

		// @
		$this->_40->ViewValue = $this->_40->CurrentValue;
		$this->_40->ViewValue = FormatNumber($this->_40->ViewValue, 2, -2, -2, -2);
		$this->_40->ViewCustomAttributes = "";

		// buyer
		$this->buyer->ViewValue = $this->buyer->CurrentValue;
		$curVal = strval($this->buyer->CurrentValue);
		if ($curVal <> "") {
			$this->buyer->ViewValue = $this->buyer->lookupCacheOption($curVal);
			if ($this->buyer->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`category` = 902 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->buyer->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->buyer->ViewValue = $this->buyer->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyer->ViewValue = $this->buyer->CurrentValue;
				}
			}
		} else {
			$this->buyer->ViewValue = NULL;
		}
		$this->buyer->ViewCustomAttributes = "";

		// agent
		if ($this->agent->VirtualValue <> "") {
			$this->agent->ViewValue = $this->agent->VirtualValue;
		} else {
			$this->agent->ViewValue = $this->agent->CurrentValue;
		$curVal = strval($this->agent->CurrentValue);
		if ($curVal <> "") {
			$this->agent->ViewValue = $this->agent->lookupCacheOption($curVal);
			if ($this->agent->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`category` = 902 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->agent->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->agent->ViewValue = $this->agent->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->agent->ViewValue = $this->agent->CurrentValue;
				}
			}
		} else {
			$this->agent->ViewValue = NULL;
		}
		}
		$this->agent->ViewCustomAttributes = "";

		// comm
		$this->comm->ViewValue = $this->comm->CurrentValue;
		$this->comm->ViewValue = FormatNumber($this->comm->ViewValue, 2, -2, -2, -2);
		$this->comm->ViewCustomAttributes = "";

		// load_date
		$this->load_date->ViewValue = $this->load_date->CurrentValue;
		$this->load_date->ViewValue = FormatDateTime($this->load_date->ViewValue, 1);
		$this->load_date->ViewCustomAttributes = "";

		// load_weight
		$this->load_weight->ViewValue = $this->load_weight->CurrentValue;
		$this->load_weight->ViewValue = FormatNumber($this->load_weight->ViewValue, 0, -2, -2, -2);
		$this->load_weight->ViewCustomAttributes = "";

		// load_km
		$this->load_km->ViewValue = $this->load_km->CurrentValue;
		$this->load_km->ViewValue = FormatNumber($this->load_km->ViewValue, 0, -2, -2, -2);
		$this->load_km->ViewCustomAttributes = "";

		// gst_percent
		$this->gst_percent->ViewValue = $this->gst_percent->CurrentValue;
		$this->gst_percent->ViewValue = FormatNumber($this->gst_percent->ViewValue, 2, -2, -2, -2);
		$this->gst_percent->ViewCustomAttributes = "";

		// driver
		$this->driver->ViewValue = $this->driver->CurrentValue;
		$this->driver->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// vehicle_freight_comm
		$this->vehicle_freight_comm->ViewValue = $this->vehicle_freight_comm->CurrentValue;
		$this->vehicle_freight_comm->ViewValue = FormatNumber($this->vehicle_freight_comm->ViewValue, 2, -2, -2, -2);
		$this->vehicle_freight_comm->ViewCustomAttributes = "";

		// freight_type
		if (strval($this->freight_type->CurrentValue) <> "") {
			$this->freight_type->ViewValue = $this->freight_type->optionCaption($this->freight_type->CurrentValue);
		} else {
			$this->freight_type->ViewValue = NULL;
		}
		$this->freight_type->ViewCustomAttributes = "";

		// freight
		$this->freight->ViewValue = $this->freight->CurrentValue;
		$this->freight->ViewValue = FormatNumber($this->freight->ViewValue, 2, -2, -2, -2);
		$this->freight->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// vehicle_type
		$this->vehicle_type->LinkCustomAttributes = "";
		$this->vehicle_type->HrefValue = "";
		$this->vehicle_type->TooltipValue = "";

		// vehicle
		$this->vehicle->LinkCustomAttributes = "";
		$this->vehicle->HrefValue = "";
		$this->vehicle->TooltipValue = "";

		// route
		$this->_route->LinkCustomAttributes = "";
		$this->_route->HrefValue = "";
		$this->_route->TooltipValue = "";

		// reports_to
		$this->reports_to->LinkCustomAttributes = "";
		$this->reports_to->HrefValue = "";
		$this->reports_to->TooltipValue = "";

		// vehicle_freight_type
		$this->vehicle_freight_type->LinkCustomAttributes = "";
		$this->vehicle_freight_type->HrefValue = "";
		$this->vehicle_freight_type->TooltipValue = "";

		// vehicle_freight_amount
		$this->vehicle_freight_amount->LinkCustomAttributes = "";
		$this->vehicle_freight_amount->HrefValue = "";
		$this->vehicle_freight_amount->TooltipValue = "";

		// material
		$this->material->LinkCustomAttributes = "";
		$this->material->HrefValue = "";
		$this->material->TooltipValue = "";

		// @
		$this->_40->LinkCustomAttributes = "";
		$this->_40->HrefValue = "";
		$this->_40->TooltipValue = "";

		// buyer
		$this->buyer->LinkCustomAttributes = "";
		$this->buyer->HrefValue = "";
		$this->buyer->TooltipValue = "";

		// agent
		$this->agent->LinkCustomAttributes = "";
		$this->agent->HrefValue = "";
		$this->agent->TooltipValue = "";

		// comm
		$this->comm->LinkCustomAttributes = "";
		$this->comm->HrefValue = "";
		$this->comm->TooltipValue = "";

		// load_date
		$this->load_date->LinkCustomAttributes = "";
		$this->load_date->HrefValue = "";
		$this->load_date->TooltipValue = "";

		// load_weight
		$this->load_weight->LinkCustomAttributes = "";
		$this->load_weight->HrefValue = "";
		$this->load_weight->TooltipValue = "";

		// load_km
		$this->load_km->LinkCustomAttributes = "";
		$this->load_km->HrefValue = "";
		$this->load_km->TooltipValue = "";

		// gst_percent
		$this->gst_percent->LinkCustomAttributes = "";
		$this->gst_percent->HrefValue = "";
		$this->gst_percent->TooltipValue = "";

		// driver
		$this->driver->LinkCustomAttributes = "";
		$this->driver->HrefValue = "";
		$this->driver->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// vehicle_freight_comm
		$this->vehicle_freight_comm->LinkCustomAttributes = "";
		$this->vehicle_freight_comm->HrefValue = "";
		$this->vehicle_freight_comm->TooltipValue = "";

		// freight_type
		$this->freight_type->LinkCustomAttributes = "";
		$this->freight_type->HrefValue = "";
		$this->freight_type->TooltipValue = "";

		// freight
		$this->freight->LinkCustomAttributes = "";
		$this->freight->HrefValue = "";
		$this->freight->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// vehicle_type
		$this->vehicle_type->EditAttrs["class"] = "form-control";
		$this->vehicle_type->EditCustomAttributes = "";
		$this->vehicle_type->EditValue = $this->vehicle_type->options(TRUE);

		// vehicle
		$this->vehicle->EditAttrs["class"] = "form-control";
		$this->vehicle->EditCustomAttributes = "";
		$this->vehicle->EditValue = $this->vehicle->CurrentValue;
		$curVal = strval($this->vehicle->CurrentValue);
		if ($curVal <> "") {
			$this->vehicle->EditValue = $this->vehicle->lookupCacheOption($curVal);
			if ($this->vehicle->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`status`=1 and `running_status` = 0" : "";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->vehicle->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->vehicle->EditValue = $this->vehicle->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->vehicle->EditValue = $this->vehicle->CurrentValue;
				}
			}
		} else {
			$this->vehicle->EditValue = NULL;
		}
		$this->vehicle->ViewCustomAttributes = "";

		// route
		$this->_route->EditAttrs["class"] = "form-control";
		$this->_route->EditCustomAttributes = "";
		$this->_route->EditValue = $this->_route->CurrentValue;
		$this->_route->PlaceHolder = RemoveHtml($this->_route->caption());

		// reports_to
		$this->reports_to->EditAttrs["class"] = "form-control";
		$this->reports_to->EditCustomAttributes = "";

		// vehicle_freight_type
		$this->vehicle_freight_type->EditAttrs["class"] = "form-control";
		$this->vehicle_freight_type->EditCustomAttributes = "";
		$this->vehicle_freight_type->EditValue = $this->vehicle_freight_type->options(TRUE);

		// vehicle_freight_amount
		$this->vehicle_freight_amount->EditAttrs["class"] = "form-control";
		$this->vehicle_freight_amount->EditCustomAttributes = "";
		$this->vehicle_freight_amount->EditValue = $this->vehicle_freight_amount->CurrentValue;
		$this->vehicle_freight_amount->PlaceHolder = RemoveHtml($this->vehicle_freight_amount->caption());
		if (strval($this->vehicle_freight_amount->EditValue) <> "" && is_numeric($this->vehicle_freight_amount->EditValue))
			$this->vehicle_freight_amount->EditValue = FormatNumber($this->vehicle_freight_amount->EditValue, -2, -2, -2, -2);

		// material
		$this->material->EditAttrs["class"] = "form-control";
		$this->material->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->material->CurrentValue = HtmlDecode($this->material->CurrentValue);
		$this->material->EditValue = $this->material->CurrentValue;
		$this->material->PlaceHolder = RemoveHtml($this->material->caption());

		// @
		$this->_40->EditAttrs["class"] = "form-control";
		$this->_40->EditCustomAttributes = "";
		$this->_40->EditValue = $this->_40->CurrentValue;
		$this->_40->PlaceHolder = RemoveHtml($this->_40->caption());
		if (strval($this->_40->EditValue) <> "" && is_numeric($this->_40->EditValue))
			$this->_40->EditValue = FormatNumber($this->_40->EditValue, -2, -2, -2, -2);

		// buyer
		$this->buyer->EditAttrs["class"] = "form-control";
		$this->buyer->EditCustomAttributes = "";
		$this->buyer->EditValue = $this->buyer->CurrentValue;
		$this->buyer->PlaceHolder = RemoveHtml($this->buyer->caption());

		// agent
		$this->agent->EditAttrs["class"] = "form-control";
		$this->agent->EditCustomAttributes = "";
		$this->agent->EditValue = $this->agent->CurrentValue;
		$this->agent->PlaceHolder = RemoveHtml($this->agent->caption());

		// comm
		$this->comm->EditAttrs["class"] = "form-control";
		$this->comm->EditCustomAttributes = "";
		$this->comm->EditValue = $this->comm->CurrentValue;
		$this->comm->PlaceHolder = RemoveHtml($this->comm->caption());
		if (strval($this->comm->EditValue) <> "" && is_numeric($this->comm->EditValue))
			$this->comm->EditValue = FormatNumber($this->comm->EditValue, -2, -2, -2, -2);

		// load_date
		$this->load_date->EditAttrs["class"] = "form-control";
		$this->load_date->EditCustomAttributes = "";
		$this->load_date->EditValue = FormatDateTime($this->load_date->CurrentValue, 8);
		$this->load_date->PlaceHolder = RemoveHtml($this->load_date->caption());

		// load_weight
		$this->load_weight->EditAttrs["class"] = "form-control";
		$this->load_weight->EditCustomAttributes = "";
		$this->load_weight->EditValue = $this->load_weight->CurrentValue;
		$this->load_weight->PlaceHolder = RemoveHtml($this->load_weight->caption());

		// load_km
		$this->load_km->EditAttrs["class"] = "form-control";
		$this->load_km->EditCustomAttributes = "";
		$this->load_km->EditValue = $this->load_km->CurrentValue;
		$this->load_km->PlaceHolder = RemoveHtml($this->load_km->caption());

		// gst_percent
		$this->gst_percent->EditAttrs["class"] = "form-control";
		$this->gst_percent->EditCustomAttributes = "";
		$this->gst_percent->EditValue = $this->gst_percent->CurrentValue;
		$this->gst_percent->PlaceHolder = RemoveHtml($this->gst_percent->caption());
		if (strval($this->gst_percent->EditValue) <> "" && is_numeric($this->gst_percent->EditValue))
			$this->gst_percent->EditValue = FormatNumber($this->gst_percent->EditValue, -2, -2, -2, -2);

		// driver
		$this->driver->EditAttrs["class"] = "form-control";
		$this->driver->EditCustomAttributes = 'ReadOnly';
		$this->driver->EditValue = $this->driver->CurrentValue;
		$this->driver->PlaceHolder = RemoveHtml($this->driver->caption());

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// vehicle_freight_comm
		$this->vehicle_freight_comm->EditAttrs["class"] = "form-control";
		$this->vehicle_freight_comm->EditCustomAttributes = "";
		$this->vehicle_freight_comm->EditValue = $this->vehicle_freight_comm->CurrentValue;
		$this->vehicle_freight_comm->PlaceHolder = RemoveHtml($this->vehicle_freight_comm->caption());
		if (strval($this->vehicle_freight_comm->EditValue) <> "" && is_numeric($this->vehicle_freight_comm->EditValue))
			$this->vehicle_freight_comm->EditValue = FormatNumber($this->vehicle_freight_comm->EditValue, -2, -2, -2, -2);

		// freight_type
		$this->freight_type->EditAttrs["class"] = "form-control";
		$this->freight_type->EditCustomAttributes = "";
		$this->freight_type->EditValue = $this->freight_type->options(TRUE);

		// freight
		$this->freight->EditAttrs["class"] = "form-control";
		$this->freight->EditCustomAttributes = "";
		$this->freight->EditValue = $this->freight->CurrentValue;
		$this->freight->PlaceHolder = RemoveHtml($this->freight->caption());
		if (strval($this->freight->EditValue) <> "" && is_numeric($this->freight->EditValue))
			$this->freight->EditValue = FormatNumber($this->freight->EditValue, -2, -2, -2, -2);

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->vehicle_type);
					$doc->exportCaption($this->vehicle);
					$doc->exportCaption($this->_route);
					$doc->exportCaption($this->reports_to);
					$doc->exportCaption($this->vehicle_freight_type);
					$doc->exportCaption($this->vehicle_freight_amount);
					$doc->exportCaption($this->material);
					$doc->exportCaption($this->_40);
					$doc->exportCaption($this->buyer);
					$doc->exportCaption($this->agent);
					$doc->exportCaption($this->comm);
					$doc->exportCaption($this->load_date);
					$doc->exportCaption($this->load_weight);
					$doc->exportCaption($this->load_km);
					$doc->exportCaption($this->gst_percent);
					$doc->exportCaption($this->driver);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->vehicle_freight_comm);
					$doc->exportCaption($this->freight_type);
					$doc->exportCaption($this->freight);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->vehicle_type);
					$doc->exportCaption($this->vehicle);
					$doc->exportCaption($this->_route);
					$doc->exportCaption($this->reports_to);
					$doc->exportCaption($this->vehicle_freight_type);
					$doc->exportCaption($this->vehicle_freight_amount);
					$doc->exportCaption($this->material);
					$doc->exportCaption($this->_40);
					$doc->exportCaption($this->buyer);
					$doc->exportCaption($this->agent);
					$doc->exportCaption($this->comm);
					$doc->exportCaption($this->load_date);
					$doc->exportCaption($this->load_weight);
					$doc->exportCaption($this->load_km);
					$doc->exportCaption($this->gst_percent);
					$doc->exportCaption($this->driver);
					$doc->exportCaption($this->vehicle_freight_comm);
					$doc->exportCaption($this->freight_type);
					$doc->exportCaption($this->freight);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->vehicle_type);
						$doc->exportField($this->vehicle);
						$doc->exportField($this->_route);
						$doc->exportField($this->reports_to);
						$doc->exportField($this->vehicle_freight_type);
						$doc->exportField($this->vehicle_freight_amount);
						$doc->exportField($this->material);
						$doc->exportField($this->_40);
						$doc->exportField($this->buyer);
						$doc->exportField($this->agent);
						$doc->exportField($this->comm);
						$doc->exportField($this->load_date);
						$doc->exportField($this->load_weight);
						$doc->exportField($this->load_km);
						$doc->exportField($this->gst_percent);
						$doc->exportField($this->driver);
						$doc->exportField($this->remarks);
						$doc->exportField($this->vehicle_freight_comm);
						$doc->exportField($this->freight_type);
						$doc->exportField($this->freight);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->vehicle_type);
						$doc->exportField($this->vehicle);
						$doc->exportField($this->_route);
						$doc->exportField($this->reports_to);
						$doc->exportField($this->vehicle_freight_type);
						$doc->exportField($this->vehicle_freight_amount);
						$doc->exportField($this->material);
						$doc->exportField($this->_40);
						$doc->exportField($this->buyer);
						$doc->exportField($this->agent);
						$doc->exportField($this->comm);
						$doc->exportField($this->load_date);
						$doc->exportField($this->load_weight);
						$doc->exportField($this->load_km);
						$doc->exportField($this->gst_percent);
						$doc->exportField($this->driver);
						$doc->exportField($this->vehicle_freight_comm);
						$doc->exportField($this->freight_type);
						$doc->exportField($this->freight);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>