<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class t_trip_start_list extends t_trip_start
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 't_trip_start';

	// Page object name
	public $PageObjName = "t_trip_start_list";

	// Grid form hidden field names
	public $FormName = "ft_trip_startlist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (t_trip_start)
		if (!isset($GLOBALS["t_trip_start"]) || get_class($GLOBALS["t_trip_start"]) == PROJECT_NAMESPACE . "t_trip_start") {
			$GLOBALS["t_trip_start"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["t_trip_start"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->AddUrl = "t_trip_startadd.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "t_trip_startdelete.php";
		$this->MultiUpdateUrl = "t_trip_startupdate.php";
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 't_trip_start');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions();
		$this->ImportOptions->Tag = "div";
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions();
		$this->OtherOptions["addedit"]->Tag = "div";
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ew-filter-option ft_trip_startlistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $t_trip_start;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($t_trip_start);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecs = 20;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $AutoHidePageSizeSelector = AUTO_HIDE_PAGE_SIZE_SELECTOR;
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $RecCnt = 0; // Record count
	public $EditRowCnt;
	public $StartRowCnt = 1;
	public $RowCnt = 0;
	public $Attrs = array(); // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SearchError, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		} elseif (IsPost()) {
			if (Post("exporttype") !== NULL)
				$this->Export = Post("exporttype");
			$custom = Post("custom", "");
		} elseif (Get("cmd") == "json") {
			$this->Export = Get("cmd");
		} else {
			$this->setExportReturnUrl(CurrentUrl());
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined(PROJECT_NAMESPACE . "USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined(PROJECT_NAMESPACE . "USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(TABLE_GRID_ADD_ROW_COUNT, "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();

		// Setup export options
		$this->setupExportOptions();
		$this->id->setVisibility();
		$this->vehicle_type->setVisibility();
		$this->vehicle->setVisibility();
		$this->_route->Visible = FALSE;
		$this->reports_to->setVisibility();
		$this->vehicle_freight_type->setVisibility();
		$this->vehicle_freight_amount->setVisibility();
		$this->material->setVisibility();
		$this->_40->setVisibility();
		$this->buyer->setVisibility();
		$this->agent->setVisibility();
		$this->comm->setVisibility();
		$this->load_date->setVisibility();
		$this->load_weight->setVisibility();
		$this->load_km->setVisibility();
		$this->gst_percent->setVisibility();
		$this->driver->setVisibility();
		$this->remarks->Visible = FALSE;
		$this->vehicle_freight_comm->setVisibility();
		$this->freight_type->setVisibility();
		$this->freight->setVisibility();
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		$this->setupLookupOptions($this->vehicle);
		$this->setupLookupOptions($this->_route);
		$this->setupLookupOptions($this->reports_to);
		$this->setupLookupOptions($this->buyer);
		$this->setupLookupOptions($this->agent);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecs();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));
			AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->loadSearchValues(); // Get search values

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();
			if (!$this->validateSearch())
				$this->setFailureMessage($SearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();

			// Get search criteria for advanced search
			if ($SearchError == "")
				$srchAdvanced = $this->advancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();

			// Load advanced search from default
			if ($this->loadAdvancedSearchDefault()) {
				$srchAdvanced = $this->advancedSearchWhere();
			}
		}

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if (!$this->CustomExport && in_array($this->Export, array_keys($EXPORT))) {
			$this->exportData();
			$this->terminate();
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRec = 1;
			$this->DisplayRecs = $this->GridAddRowCount;
			$this->TotalRecs = $this->DisplayRecs;
			$this->StopRec = $this->DisplayRecs;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecs = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
			$this->StartRec = 1;
			if ($this->DisplayRecs <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecs = $this->TotalRecs;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRec();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecs == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecs]);
			$this->terminate(TRUE);
		}
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecs()
	{
		$wrk = Get(TABLE_REC_PER_PAGE, "");
		if ($wrk <> "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecs = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecs = -1;
				} else {
					$this->DisplayRecs = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecs); // Save to Session

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey <> "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter <> "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode($GLOBALS["COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arKeyFlds) >= 1) {
			$this->id->setFormValue($arKeyFlds[0]);
			if (!is_numeric($this->id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";

		// Load server side filters
		if (SEARCH_FILTER_OPTION == "Server" && isset($UserProfile))
			$savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "ft_trip_startlistsrch");
		$filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
		$filterList = Concat($filterList, $this->vehicle_type->AdvancedSearch->toJson(), ","); // Field vehicle_type
		$filterList = Concat($filterList, $this->vehicle->AdvancedSearch->toJson(), ","); // Field vehicle
		$filterList = Concat($filterList, $this->_route->AdvancedSearch->toJson(), ","); // Field route
		$filterList = Concat($filterList, $this->reports_to->AdvancedSearch->toJson(), ","); // Field reports_to
		$filterList = Concat($filterList, $this->vehicle_freight_type->AdvancedSearch->toJson(), ","); // Field vehicle_freight_type
		$filterList = Concat($filterList, $this->vehicle_freight_amount->AdvancedSearch->toJson(), ","); // Field vehicle_freight_amount
		$filterList = Concat($filterList, $this->material->AdvancedSearch->toJson(), ","); // Field material
		$filterList = Concat($filterList, $this->_40->AdvancedSearch->toJson(), ","); // Field @
		$filterList = Concat($filterList, $this->buyer->AdvancedSearch->toJson(), ","); // Field buyer
		$filterList = Concat($filterList, $this->agent->AdvancedSearch->toJson(), ","); // Field agent
		$filterList = Concat($filterList, $this->comm->AdvancedSearch->toJson(), ","); // Field comm
		$filterList = Concat($filterList, $this->load_date->AdvancedSearch->toJson(), ","); // Field load_date
		$filterList = Concat($filterList, $this->load_weight->AdvancedSearch->toJson(), ","); // Field load_weight
		$filterList = Concat($filterList, $this->load_km->AdvancedSearch->toJson(), ","); // Field load_km
		$filterList = Concat($filterList, $this->gst_percent->AdvancedSearch->toJson(), ","); // Field gst_percent
		$filterList = Concat($filterList, $this->driver->AdvancedSearch->toJson(), ","); // Field driver
		$filterList = Concat($filterList, $this->remarks->AdvancedSearch->toJson(), ","); // Field remarks
		$filterList = Concat($filterList, $this->vehicle_freight_comm->AdvancedSearch->toJson(), ","); // Field vehicle_freight_comm
		$filterList = Concat($filterList, $this->freight_type->AdvancedSearch->toJson(), ","); // Field freight_type
		$filterList = Concat($filterList, $this->freight->AdvancedSearch->toJson(), ","); // Field freight
		if ($this->BasicSearch->Keyword <> "") {
			$wrk = "\"" . TABLE_BASIC_SEARCH . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . TABLE_BASIC_SEARCH_TYPE . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList <> "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList <> "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList <> "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "ft_trip_startlistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field id
		$this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
		$this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
		$this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
		$this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
		$this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
		$this->id->AdvancedSearch->save();

		// Field vehicle_type
		$this->vehicle_type->AdvancedSearch->SearchValue = @$filter["x_vehicle_type"];
		$this->vehicle_type->AdvancedSearch->SearchOperator = @$filter["z_vehicle_type"];
		$this->vehicle_type->AdvancedSearch->SearchCondition = @$filter["v_vehicle_type"];
		$this->vehicle_type->AdvancedSearch->SearchValue2 = @$filter["y_vehicle_type"];
		$this->vehicle_type->AdvancedSearch->SearchOperator2 = @$filter["w_vehicle_type"];
		$this->vehicle_type->AdvancedSearch->save();

		// Field vehicle
		$this->vehicle->AdvancedSearch->SearchValue = @$filter["x_vehicle"];
		$this->vehicle->AdvancedSearch->SearchOperator = @$filter["z_vehicle"];
		$this->vehicle->AdvancedSearch->SearchCondition = @$filter["v_vehicle"];
		$this->vehicle->AdvancedSearch->SearchValue2 = @$filter["y_vehicle"];
		$this->vehicle->AdvancedSearch->SearchOperator2 = @$filter["w_vehicle"];
		$this->vehicle->AdvancedSearch->save();

		// Field route
		$this->_route->AdvancedSearch->SearchValue = @$filter["x__route"];
		$this->_route->AdvancedSearch->SearchOperator = @$filter["z__route"];
		$this->_route->AdvancedSearch->SearchCondition = @$filter["v__route"];
		$this->_route->AdvancedSearch->SearchValue2 = @$filter["y__route"];
		$this->_route->AdvancedSearch->SearchOperator2 = @$filter["w__route"];
		$this->_route->AdvancedSearch->save();

		// Field reports_to
		$this->reports_to->AdvancedSearch->SearchValue = @$filter["x_reports_to"];
		$this->reports_to->AdvancedSearch->SearchOperator = @$filter["z_reports_to"];
		$this->reports_to->AdvancedSearch->SearchCondition = @$filter["v_reports_to"];
		$this->reports_to->AdvancedSearch->SearchValue2 = @$filter["y_reports_to"];
		$this->reports_to->AdvancedSearch->SearchOperator2 = @$filter["w_reports_to"];
		$this->reports_to->AdvancedSearch->save();

		// Field vehicle_freight_type
		$this->vehicle_freight_type->AdvancedSearch->SearchValue = @$filter["x_vehicle_freight_type"];
		$this->vehicle_freight_type->AdvancedSearch->SearchOperator = @$filter["z_vehicle_freight_type"];
		$this->vehicle_freight_type->AdvancedSearch->SearchCondition = @$filter["v_vehicle_freight_type"];
		$this->vehicle_freight_type->AdvancedSearch->SearchValue2 = @$filter["y_vehicle_freight_type"];
		$this->vehicle_freight_type->AdvancedSearch->SearchOperator2 = @$filter["w_vehicle_freight_type"];
		$this->vehicle_freight_type->AdvancedSearch->save();

		// Field vehicle_freight_amount
		$this->vehicle_freight_amount->AdvancedSearch->SearchValue = @$filter["x_vehicle_freight_amount"];
		$this->vehicle_freight_amount->AdvancedSearch->SearchOperator = @$filter["z_vehicle_freight_amount"];
		$this->vehicle_freight_amount->AdvancedSearch->SearchCondition = @$filter["v_vehicle_freight_amount"];
		$this->vehicle_freight_amount->AdvancedSearch->SearchValue2 = @$filter["y_vehicle_freight_amount"];
		$this->vehicle_freight_amount->AdvancedSearch->SearchOperator2 = @$filter["w_vehicle_freight_amount"];
		$this->vehicle_freight_amount->AdvancedSearch->save();

		// Field material
		$this->material->AdvancedSearch->SearchValue = @$filter["x_material"];
		$this->material->AdvancedSearch->SearchOperator = @$filter["z_material"];
		$this->material->AdvancedSearch->SearchCondition = @$filter["v_material"];
		$this->material->AdvancedSearch->SearchValue2 = @$filter["y_material"];
		$this->material->AdvancedSearch->SearchOperator2 = @$filter["w_material"];
		$this->material->AdvancedSearch->save();

		// Field @
		$this->_40->AdvancedSearch->SearchValue = @$filter["x__40"];
		$this->_40->AdvancedSearch->SearchOperator = @$filter["z__40"];
		$this->_40->AdvancedSearch->SearchCondition = @$filter["v__40"];
		$this->_40->AdvancedSearch->SearchValue2 = @$filter["y__40"];
		$this->_40->AdvancedSearch->SearchOperator2 = @$filter["w__40"];
		$this->_40->AdvancedSearch->save();

		// Field buyer
		$this->buyer->AdvancedSearch->SearchValue = @$filter["x_buyer"];
		$this->buyer->AdvancedSearch->SearchOperator = @$filter["z_buyer"];
		$this->buyer->AdvancedSearch->SearchCondition = @$filter["v_buyer"];
		$this->buyer->AdvancedSearch->SearchValue2 = @$filter["y_buyer"];
		$this->buyer->AdvancedSearch->SearchOperator2 = @$filter["w_buyer"];
		$this->buyer->AdvancedSearch->save();

		// Field agent
		$this->agent->AdvancedSearch->SearchValue = @$filter["x_agent"];
		$this->agent->AdvancedSearch->SearchOperator = @$filter["z_agent"];
		$this->agent->AdvancedSearch->SearchCondition = @$filter["v_agent"];
		$this->agent->AdvancedSearch->SearchValue2 = @$filter["y_agent"];
		$this->agent->AdvancedSearch->SearchOperator2 = @$filter["w_agent"];
		$this->agent->AdvancedSearch->save();

		// Field comm
		$this->comm->AdvancedSearch->SearchValue = @$filter["x_comm"];
		$this->comm->AdvancedSearch->SearchOperator = @$filter["z_comm"];
		$this->comm->AdvancedSearch->SearchCondition = @$filter["v_comm"];
		$this->comm->AdvancedSearch->SearchValue2 = @$filter["y_comm"];
		$this->comm->AdvancedSearch->SearchOperator2 = @$filter["w_comm"];
		$this->comm->AdvancedSearch->save();

		// Field load_date
		$this->load_date->AdvancedSearch->SearchValue = @$filter["x_load_date"];
		$this->load_date->AdvancedSearch->SearchOperator = @$filter["z_load_date"];
		$this->load_date->AdvancedSearch->SearchCondition = @$filter["v_load_date"];
		$this->load_date->AdvancedSearch->SearchValue2 = @$filter["y_load_date"];
		$this->load_date->AdvancedSearch->SearchOperator2 = @$filter["w_load_date"];
		$this->load_date->AdvancedSearch->save();

		// Field load_weight
		$this->load_weight->AdvancedSearch->SearchValue = @$filter["x_load_weight"];
		$this->load_weight->AdvancedSearch->SearchOperator = @$filter["z_load_weight"];
		$this->load_weight->AdvancedSearch->SearchCondition = @$filter["v_load_weight"];
		$this->load_weight->AdvancedSearch->SearchValue2 = @$filter["y_load_weight"];
		$this->load_weight->AdvancedSearch->SearchOperator2 = @$filter["w_load_weight"];
		$this->load_weight->AdvancedSearch->save();

		// Field load_km
		$this->load_km->AdvancedSearch->SearchValue = @$filter["x_load_km"];
		$this->load_km->AdvancedSearch->SearchOperator = @$filter["z_load_km"];
		$this->load_km->AdvancedSearch->SearchCondition = @$filter["v_load_km"];
		$this->load_km->AdvancedSearch->SearchValue2 = @$filter["y_load_km"];
		$this->load_km->AdvancedSearch->SearchOperator2 = @$filter["w_load_km"];
		$this->load_km->AdvancedSearch->save();

		// Field gst_percent
		$this->gst_percent->AdvancedSearch->SearchValue = @$filter["x_gst_percent"];
		$this->gst_percent->AdvancedSearch->SearchOperator = @$filter["z_gst_percent"];
		$this->gst_percent->AdvancedSearch->SearchCondition = @$filter["v_gst_percent"];
		$this->gst_percent->AdvancedSearch->SearchValue2 = @$filter["y_gst_percent"];
		$this->gst_percent->AdvancedSearch->SearchOperator2 = @$filter["w_gst_percent"];
		$this->gst_percent->AdvancedSearch->save();

		// Field driver
		$this->driver->AdvancedSearch->SearchValue = @$filter["x_driver"];
		$this->driver->AdvancedSearch->SearchOperator = @$filter["z_driver"];
		$this->driver->AdvancedSearch->SearchCondition = @$filter["v_driver"];
		$this->driver->AdvancedSearch->SearchValue2 = @$filter["y_driver"];
		$this->driver->AdvancedSearch->SearchOperator2 = @$filter["w_driver"];
		$this->driver->AdvancedSearch->save();

		// Field remarks
		$this->remarks->AdvancedSearch->SearchValue = @$filter["x_remarks"];
		$this->remarks->AdvancedSearch->SearchOperator = @$filter["z_remarks"];
		$this->remarks->AdvancedSearch->SearchCondition = @$filter["v_remarks"];
		$this->remarks->AdvancedSearch->SearchValue2 = @$filter["y_remarks"];
		$this->remarks->AdvancedSearch->SearchOperator2 = @$filter["w_remarks"];
		$this->remarks->AdvancedSearch->save();

		// Field vehicle_freight_comm
		$this->vehicle_freight_comm->AdvancedSearch->SearchValue = @$filter["x_vehicle_freight_comm"];
		$this->vehicle_freight_comm->AdvancedSearch->SearchOperator = @$filter["z_vehicle_freight_comm"];
		$this->vehicle_freight_comm->AdvancedSearch->SearchCondition = @$filter["v_vehicle_freight_comm"];
		$this->vehicle_freight_comm->AdvancedSearch->SearchValue2 = @$filter["y_vehicle_freight_comm"];
		$this->vehicle_freight_comm->AdvancedSearch->SearchOperator2 = @$filter["w_vehicle_freight_comm"];
		$this->vehicle_freight_comm->AdvancedSearch->save();

		// Field freight_type
		$this->freight_type->AdvancedSearch->SearchValue = @$filter["x_freight_type"];
		$this->freight_type->AdvancedSearch->SearchOperator = @$filter["z_freight_type"];
		$this->freight_type->AdvancedSearch->SearchCondition = @$filter["v_freight_type"];
		$this->freight_type->AdvancedSearch->SearchValue2 = @$filter["y_freight_type"];
		$this->freight_type->AdvancedSearch->SearchOperator2 = @$filter["w_freight_type"];
		$this->freight_type->AdvancedSearch->save();

		// Field freight
		$this->freight->AdvancedSearch->SearchValue = @$filter["x_freight"];
		$this->freight->AdvancedSearch->SearchOperator = @$filter["z_freight"];
		$this->freight->AdvancedSearch->SearchCondition = @$filter["v_freight"];
		$this->freight->AdvancedSearch->SearchValue2 = @$filter["y_freight"];
		$this->freight->AdvancedSearch->SearchOperator2 = @$filter["w_freight"];
		$this->freight->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	protected function advancedSearchWhere($default = FALSE)
	{
		global $Security;
		$where = "";
		if (!$Security->canSearch())
			return "";
		$this->buildSearchSql($where, $this->id, $default, FALSE); // id
		$this->buildSearchSql($where, $this->vehicle_type, $default, FALSE); // vehicle_type
		$this->buildSearchSql($where, $this->vehicle, $default, FALSE); // vehicle
		$this->buildSearchSql($where, $this->_route, $default, FALSE); // route
		$this->buildSearchSql($where, $this->reports_to, $default, FALSE); // reports_to
		$this->buildSearchSql($where, $this->vehicle_freight_type, $default, FALSE); // vehicle_freight_type
		$this->buildSearchSql($where, $this->vehicle_freight_amount, $default, FALSE); // vehicle_freight_amount
		$this->buildSearchSql($where, $this->material, $default, FALSE); // material
		$this->buildSearchSql($where, $this->_40, $default, FALSE); // @
		$this->buildSearchSql($where, $this->buyer, $default, FALSE); // buyer
		$this->buildSearchSql($where, $this->agent, $default, FALSE); // agent
		$this->buildSearchSql($where, $this->comm, $default, FALSE); // comm
		$this->buildSearchSql($where, $this->load_date, $default, FALSE); // load_date
		$this->buildSearchSql($where, $this->load_weight, $default, FALSE); // load_weight
		$this->buildSearchSql($where, $this->load_km, $default, FALSE); // load_km
		$this->buildSearchSql($where, $this->gst_percent, $default, FALSE); // gst_percent
		$this->buildSearchSql($where, $this->driver, $default, FALSE); // driver
		$this->buildSearchSql($where, $this->remarks, $default, FALSE); // remarks
		$this->buildSearchSql($where, $this->vehicle_freight_comm, $default, FALSE); // vehicle_freight_comm
		$this->buildSearchSql($where, $this->freight_type, $default, FALSE); // freight_type
		$this->buildSearchSql($where, $this->freight, $default, FALSE); // freight

		// Set up search parm
		if (!$default && $where <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->id->AdvancedSearch->save(); // id
			$this->vehicle_type->AdvancedSearch->save(); // vehicle_type
			$this->vehicle->AdvancedSearch->save(); // vehicle
			$this->_route->AdvancedSearch->save(); // route
			$this->reports_to->AdvancedSearch->save(); // reports_to
			$this->vehicle_freight_type->AdvancedSearch->save(); // vehicle_freight_type
			$this->vehicle_freight_amount->AdvancedSearch->save(); // vehicle_freight_amount
			$this->material->AdvancedSearch->save(); // material
			$this->_40->AdvancedSearch->save(); // @
			$this->buyer->AdvancedSearch->save(); // buyer
			$this->agent->AdvancedSearch->save(); // agent
			$this->comm->AdvancedSearch->save(); // comm
			$this->load_date->AdvancedSearch->save(); // load_date
			$this->load_weight->AdvancedSearch->save(); // load_weight
			$this->load_km->AdvancedSearch->save(); // load_km
			$this->gst_percent->AdvancedSearch->save(); // gst_percent
			$this->driver->AdvancedSearch->save(); // driver
			$this->remarks->AdvancedSearch->save(); // remarks
			$this->vehicle_freight_comm->AdvancedSearch->save(); // vehicle_freight_comm
			$this->freight_type->AdvancedSearch->save(); // freight_type
			$this->freight->AdvancedSearch->save(); // freight
		}
		return $where;
	}

	// Build search SQL
	protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
	{
		$fldParm = $fld->Param;
		$fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
		$fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
		$fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
		$fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
		$fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
		$wrk = "";
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		if ($fldOpr == "")
			$fldOpr = "=";
		$fldOpr2 = strtoupper(trim($fldOpr2));
		if ($fldOpr2 == "")
			$fldOpr2 = "=";
		if (SEARCH_MULTI_VALUE_OPTION == 1)
			$multiValue = FALSE;
		if ($multiValue) {
			$wrk1 = ($fldVal <> "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
			$wrk2 = ($fldVal2 <> "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
			$wrk = $wrk1; // Build final SQL
			if ($wrk2 <> "")
				$wrk = ($wrk <> "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
		} else {
			$fldVal = $this->convertSearchValue($fld, $fldVal);
			$fldVal2 = $this->convertSearchValue($fld, $fldVal2);
			$wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
		}
		AddFilter($where, $wrk);
	}

	// Convert search value
	protected function convertSearchValue(&$fld, $fldVal)
	{
		if ($fldVal == NULL_VALUE || $fldVal == NOT_NULL_VALUE)
			return $fldVal;
		$value = $fldVal;
		if ($fld->DataType == DATATYPE_BOOLEAN) {
			if ($fldVal <> "")
				$value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
		} elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
			if ($fldVal <> "")
				$value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
		}
		return $value;
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->buyer, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->agent, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->remarks, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		global $BASIC_SEARCH_IGNORE_PATTERN;
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if ($BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$keyword = preg_replace($BASIC_SEARCH_IGNORE_PATTERN, "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = array($keyword);
			}
			foreach ($ar as $keyword) {
				if ($keyword <> "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == NULL_VALUE) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == NOT_NULL_VALUE) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk <> "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] <> "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql <> "") {
			if ($where <> "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		if (!$Security->canSearch())
			return "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword <> "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword <> "") {
						if ($searchStr <> "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql(array($keyword), $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, array("", "reset", "resetall")))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		if ($this->id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->vehicle_type->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->vehicle->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_route->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->reports_to->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->vehicle_freight_type->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->vehicle_freight_amount->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->material->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_40->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->buyer->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->agent->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->comm->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->load_date->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->load_weight->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->load_km->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->gst_percent->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->driver->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->remarks->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->vehicle_freight_comm->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->freight_type->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->freight->AdvancedSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();

		// Clear advanced search parameters
		$this->resetAdvancedSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Clear all advanced search parameters
	protected function resetAdvancedSearchParms()
	{
		$this->id->AdvancedSearch->unsetSession();
		$this->vehicle_type->AdvancedSearch->unsetSession();
		$this->vehicle->AdvancedSearch->unsetSession();
		$this->_route->AdvancedSearch->unsetSession();
		$this->reports_to->AdvancedSearch->unsetSession();
		$this->vehicle_freight_type->AdvancedSearch->unsetSession();
		$this->vehicle_freight_amount->AdvancedSearch->unsetSession();
		$this->material->AdvancedSearch->unsetSession();
		$this->_40->AdvancedSearch->unsetSession();
		$this->buyer->AdvancedSearch->unsetSession();
		$this->agent->AdvancedSearch->unsetSession();
		$this->comm->AdvancedSearch->unsetSession();
		$this->load_date->AdvancedSearch->unsetSession();
		$this->load_weight->AdvancedSearch->unsetSession();
		$this->load_km->AdvancedSearch->unsetSession();
		$this->gst_percent->AdvancedSearch->unsetSession();
		$this->driver->AdvancedSearch->unsetSession();
		$this->remarks->AdvancedSearch->unsetSession();
		$this->vehicle_freight_comm->AdvancedSearch->unsetSession();
		$this->freight_type->AdvancedSearch->unsetSession();
		$this->freight->AdvancedSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();

		// Restore advanced search values
		$this->id->AdvancedSearch->load();
		$this->vehicle_type->AdvancedSearch->load();
		$this->vehicle->AdvancedSearch->load();
		$this->_route->AdvancedSearch->load();
		$this->reports_to->AdvancedSearch->load();
		$this->vehicle_freight_type->AdvancedSearch->load();
		$this->vehicle_freight_amount->AdvancedSearch->load();
		$this->material->AdvancedSearch->load();
		$this->_40->AdvancedSearch->load();
		$this->buyer->AdvancedSearch->load();
		$this->agent->AdvancedSearch->load();
		$this->comm->AdvancedSearch->load();
		$this->load_date->AdvancedSearch->load();
		$this->load_weight->AdvancedSearch->load();
		$this->load_km->AdvancedSearch->load();
		$this->gst_percent->AdvancedSearch->load();
		$this->driver->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->vehicle_freight_comm->AdvancedSearch->load();
		$this->freight_type->AdvancedSearch->load();
		$this->freight->AdvancedSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for Ctrl pressed
		$ctrl = Get("ctrl") !== NULL;

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->id, $ctrl); // id
			$this->updateSort($this->vehicle_type, $ctrl); // vehicle_type
			$this->updateSort($this->vehicle, $ctrl); // vehicle
			$this->updateSort($this->reports_to, $ctrl); // reports_to
			$this->updateSort($this->vehicle_freight_type, $ctrl); // vehicle_freight_type
			$this->updateSort($this->vehicle_freight_amount, $ctrl); // vehicle_freight_amount
			$this->updateSort($this->material, $ctrl); // material
			$this->updateSort($this->_40, $ctrl); // @
			$this->updateSort($this->buyer, $ctrl); // buyer
			$this->updateSort($this->agent, $ctrl); // agent
			$this->updateSort($this->comm, $ctrl); // comm
			$this->updateSort($this->load_date, $ctrl); // load_date
			$this->updateSort($this->load_weight, $ctrl); // load_weight
			$this->updateSort($this->load_km, $ctrl); // load_km
			$this->updateSort($this->gst_percent, $ctrl); // gst_percent
			$this->updateSort($this->driver, $ctrl); // driver
			$this->updateSort($this->vehicle_freight_comm, $ctrl); // vehicle_freight_comm
			$this->updateSort($this->freight_type, $ctrl); // freight_type
			$this->updateSort($this->freight, $ctrl); // freight
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
				$this->id->setSort("DESC");
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->setSessionOrderByList($orderBy);
				$this->id->setSort("");
				$this->vehicle_type->setSort("");
				$this->vehicle->setSort("");
				$this->reports_to->setSort("");
				$this->vehicle_freight_type->setSort("");
				$this->vehicle_freight_amount->setSort("");
				$this->material->setSort("");
				$this->_40->setSort("");
				$this->buyer->setSort("");
				$this->agent->setSort("");
				$this->comm->setSort("");
				$this->load_date->setSort("");
				$this->load_weight->setSort("");
				$this->load_km->setSort("");
				$this->gst_percent->setSort("");
				$this->driver->setSort("");
				$this->vehicle_freight_comm->setSort("");
				$this->freight_type->setSort("");
				$this->freight->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canView();
		$item->OnLeft = TRUE;

		// "edit"
		$item = &$this->ListOptions->add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canEdit();
		$item->OnLeft = TRUE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew.selectAllKey(this);\">";
		$item->moveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = TRUE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = &$this->ListOptions->getItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "view"
		$opt = &$this->ListOptions->Items["view"];
		$viewcaption = HtmlTitle($Language->phrase("ViewLink"));
		if ($Security->canView()) {
			$opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode($this->ViewUrl) . "\">" . $Language->phrase("ViewLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "edit"
		$opt = &$this->ListOptions->Items["edit"];
		$editcaption = HtmlTitle($Language->phrase("EditLink"));
		if ($Security->canEdit()) {
			$opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("EditLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// Set up list action buttons
		$opt = &$this->ListOptions->getItem("listactions");
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $Language->phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = &$this->ListOptions->Items["checkbox"];
		$opt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\">";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = TRUE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"ft_trip_startlistsrch\" href=\"#\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"ft_trip_startlistsrch\" href=\"#\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({f:document.ft_trip_startlist}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->getItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter <> "" && $userAction <> "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions->Items[$userAction]->Caption;
				if (!$this->ListActions->Items[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"ft_trip_startlistsrch\">" . $Language->phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Advanced search button
		$item = &$this->SearchOptions->add("advancedsearch");
		if (IsMobile())
			$item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" href=\"t_trip_startsrch.php\">" . $Language->phrase("AdvancedSearchBtn") . "</a>";
		else
			$item->Body = "<button type=\"button\" class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-table=\"t_trip_start\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" onclick=\"ew.modalDialogShow({lnk:this,btn:'SearchBtn',url:'t_trip_startsrch.php'});\">" . $Language->phrase("AdvancedSearchBtn") . "</button>";
		$item->Visible = TRUE;

		// Search highlight button
		$item = &$this->SearchOptions->add("searchhighlight");
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-highlight active\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-toggle=\"button\" data-form=\"ft_trip_startlistsrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</button>";
		$item->Visible = ($this->SearchWhere <> "" && $this->TotalRecs > 0);

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
		global $Security;
		if (!$Security->canSearch()) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}
	}
	protected function setupListOptionsExt()
	{
		global $Security, $Language;

		// Hide detail items for dropdown if necessary
		$this->ListOptions->hideDetailItemsForDropDown();
	}
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(TABLE_BASIC_SEARCH, ""), FALSE);
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(TABLE_BASIC_SEARCH_TYPE, ""), FALSE);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue(Get("x_id", Get("id", "")));
		if ($this->id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->id->AdvancedSearch->setSearchOperator(Get("z_id", ""));

		// vehicle_type
		if (!$this->isAddOrEdit())
			$this->vehicle_type->AdvancedSearch->setSearchValue(Get("x_vehicle_type", Get("vehicle_type", "")));
		if ($this->vehicle_type->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->vehicle_type->AdvancedSearch->setSearchOperator(Get("z_vehicle_type", ""));

		// vehicle
		if (!$this->isAddOrEdit())
			$this->vehicle->AdvancedSearch->setSearchValue(Get("x_vehicle", Get("vehicle", "")));
		if ($this->vehicle->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->vehicle->AdvancedSearch->setSearchOperator(Get("z_vehicle", ""));

		// route
		if (!$this->isAddOrEdit())
			$this->_route->AdvancedSearch->setSearchValue(Get("x__route", Get("_route", "")));
		if ($this->_route->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_route->AdvancedSearch->setSearchOperator(Get("z__route", ""));

		// reports_to
		if (!$this->isAddOrEdit())
			$this->reports_to->AdvancedSearch->setSearchValue(Get("x_reports_to", Get("reports_to", "")));
		if ($this->reports_to->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->reports_to->AdvancedSearch->setSearchOperator(Get("z_reports_to", ""));

		// vehicle_freight_type
		if (!$this->isAddOrEdit())
			$this->vehicle_freight_type->AdvancedSearch->setSearchValue(Get("x_vehicle_freight_type", Get("vehicle_freight_type", "")));
		if ($this->vehicle_freight_type->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->vehicle_freight_type->AdvancedSearch->setSearchOperator(Get("z_vehicle_freight_type", ""));

		// vehicle_freight_amount
		if (!$this->isAddOrEdit())
			$this->vehicle_freight_amount->AdvancedSearch->setSearchValue(Get("x_vehicle_freight_amount", Get("vehicle_freight_amount", "")));
		if ($this->vehicle_freight_amount->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->vehicle_freight_amount->AdvancedSearch->setSearchOperator(Get("z_vehicle_freight_amount", ""));

		// material
		if (!$this->isAddOrEdit())
			$this->material->AdvancedSearch->setSearchValue(Get("x_material", Get("material", "")));
		if ($this->material->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->material->AdvancedSearch->setSearchOperator(Get("z_material", ""));

		// @
		if (!$this->isAddOrEdit())
			$this->_40->AdvancedSearch->setSearchValue(Get("x__40", Get("_40", "")));
		if ($this->_40->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_40->AdvancedSearch->setSearchOperator(Get("z__40", ""));

		// buyer
		if (!$this->isAddOrEdit())
			$this->buyer->AdvancedSearch->setSearchValue(Get("x_buyer", Get("buyer", "")));
		if ($this->buyer->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->buyer->AdvancedSearch->setSearchOperator(Get("z_buyer", ""));

		// agent
		if (!$this->isAddOrEdit())
			$this->agent->AdvancedSearch->setSearchValue(Get("x_agent", Get("agent", "")));
		if ($this->agent->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->agent->AdvancedSearch->setSearchOperator(Get("z_agent", ""));

		// comm
		if (!$this->isAddOrEdit())
			$this->comm->AdvancedSearch->setSearchValue(Get("x_comm", Get("comm", "")));
		if ($this->comm->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->comm->AdvancedSearch->setSearchOperator(Get("z_comm", ""));

		// load_date
		if (!$this->isAddOrEdit())
			$this->load_date->AdvancedSearch->setSearchValue(Get("x_load_date", Get("load_date", "")));
		if ($this->load_date->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->load_date->AdvancedSearch->setSearchOperator(Get("z_load_date", ""));

		// load_weight
		if (!$this->isAddOrEdit())
			$this->load_weight->AdvancedSearch->setSearchValue(Get("x_load_weight", Get("load_weight", "")));
		if ($this->load_weight->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->load_weight->AdvancedSearch->setSearchOperator(Get("z_load_weight", ""));

		// load_km
		if (!$this->isAddOrEdit())
			$this->load_km->AdvancedSearch->setSearchValue(Get("x_load_km", Get("load_km", "")));
		if ($this->load_km->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->load_km->AdvancedSearch->setSearchOperator(Get("z_load_km", ""));

		// gst_percent
		if (!$this->isAddOrEdit())
			$this->gst_percent->AdvancedSearch->setSearchValue(Get("x_gst_percent", Get("gst_percent", "")));
		if ($this->gst_percent->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->gst_percent->AdvancedSearch->setSearchOperator(Get("z_gst_percent", ""));

		// driver
		if (!$this->isAddOrEdit())
			$this->driver->AdvancedSearch->setSearchValue(Get("x_driver", Get("driver", "")));
		if ($this->driver->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->driver->AdvancedSearch->setSearchOperator(Get("z_driver", ""));

		// remarks
		if (!$this->isAddOrEdit())
			$this->remarks->AdvancedSearch->setSearchValue(Get("x_remarks", Get("remarks", "")));
		if ($this->remarks->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->remarks->AdvancedSearch->setSearchOperator(Get("z_remarks", ""));

		// vehicle_freight_comm
		if (!$this->isAddOrEdit())
			$this->vehicle_freight_comm->AdvancedSearch->setSearchValue(Get("x_vehicle_freight_comm", Get("vehicle_freight_comm", "")));
		if ($this->vehicle_freight_comm->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->vehicle_freight_comm->AdvancedSearch->setSearchOperator(Get("z_vehicle_freight_comm", ""));

		// freight_type
		if (!$this->isAddOrEdit())
			$this->freight_type->AdvancedSearch->setSearchValue(Get("x_freight_type", Get("freight_type", "")));
		if ($this->freight_type->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->freight_type->AdvancedSearch->setSearchOperator(Get("z_freight_type", ""));

		// freight
		if (!$this->isAddOrEdit())
			$this->freight->AdvancedSearch->setSearchValue(Get("x_freight", Get("freight", "")));
		if ($this->freight->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->freight->AdvancedSearch->setSearchOperator(Get("z_freight", ""));
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderByList())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->vehicle_type->setDbValue($row['vehicle_type']);
		$this->vehicle->setDbValue($row['vehicle']);
		$this->_route->setDbValue($row['route']);
		$this->reports_to->setDbValue($row['reports_to']);
		$this->vehicle_freight_type->setDbValue($row['vehicle_freight_type']);
		$this->vehicle_freight_amount->setDbValue($row['vehicle_freight_amount']);
		$this->material->setDbValue($row['material']);
		$this->_40->setDbValue($row['@']);
		$this->buyer->setDbValue($row['buyer']);
		$this->agent->setDbValue($row['agent']);
		if (array_key_exists('EV__agent', $rs->fields)) {
			$this->agent->VirtualValue = $rs->fields('EV__agent'); // Set up virtual field value
		} else {
			$this->agent->VirtualValue = ""; // Clear value
		}
		$this->comm->setDbValue($row['comm']);
		$this->load_date->setDbValue($row['load_date']);
		$this->load_weight->setDbValue($row['load_weight']);
		$this->load_km->setDbValue($row['load_km']);
		$this->gst_percent->setDbValue($row['gst_percent']);
		$this->driver->setDbValue($row['driver']);
		$this->remarks->setDbValue($row['remarks']);
		$this->vehicle_freight_comm->setDbValue($row['vehicle_freight_comm']);
		$this->freight_type->setDbValue($row['freight_type']);
		$this->freight->setDbValue($row['freight']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['vehicle_type'] = NULL;
		$row['vehicle'] = NULL;
		$row['route'] = NULL;
		$row['reports_to'] = NULL;
		$row['vehicle_freight_type'] = NULL;
		$row['vehicle_freight_amount'] = NULL;
		$row['material'] = NULL;
		$row['@'] = NULL;
		$row['buyer'] = NULL;
		$row['agent'] = NULL;
		$row['comm'] = NULL;
		$row['load_date'] = NULL;
		$row['load_weight'] = NULL;
		$row['load_km'] = NULL;
		$row['gst_percent'] = NULL;
		$row['driver'] = NULL;
		$row['remarks'] = NULL;
		$row['vehicle_freight_comm'] = NULL;
		$row['freight_type'] = NULL;
		$row['freight'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Convert decimal values if posted back
		if ($this->vehicle_freight_amount->FormValue == $this->vehicle_freight_amount->CurrentValue && is_numeric(ConvertToFloatString($this->vehicle_freight_amount->CurrentValue)))
			$this->vehicle_freight_amount->CurrentValue = ConvertToFloatString($this->vehicle_freight_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->_40->FormValue == $this->_40->CurrentValue && is_numeric(ConvertToFloatString($this->_40->CurrentValue)))
			$this->_40->CurrentValue = ConvertToFloatString($this->_40->CurrentValue);

		// Convert decimal values if posted back
		if ($this->comm->FormValue == $this->comm->CurrentValue && is_numeric(ConvertToFloatString($this->comm->CurrentValue)))
			$this->comm->CurrentValue = ConvertToFloatString($this->comm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->gst_percent->FormValue == $this->gst_percent->CurrentValue && is_numeric(ConvertToFloatString($this->gst_percent->CurrentValue)))
			$this->gst_percent->CurrentValue = ConvertToFloatString($this->gst_percent->CurrentValue);

		// Convert decimal values if posted back
		if ($this->vehicle_freight_comm->FormValue == $this->vehicle_freight_comm->CurrentValue && is_numeric(ConvertToFloatString($this->vehicle_freight_comm->CurrentValue)))
			$this->vehicle_freight_comm->CurrentValue = ConvertToFloatString($this->vehicle_freight_comm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->freight->FormValue == $this->freight->CurrentValue && is_numeric(ConvertToFloatString($this->freight->CurrentValue)))
			$this->freight->CurrentValue = ConvertToFloatString($this->freight->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// vehicle_type
		// vehicle
		// route
		// reports_to
		// vehicle_freight_type
		// vehicle_freight_amount
		// material
		// @
		// buyer
		// agent
		// comm
		// load_date
		// load_weight
		// load_km
		// gst_percent
		// driver
		// remarks
		// vehicle_freight_comm
		// freight_type
		// freight

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// vehicle_type
			if (strval($this->vehicle_type->CurrentValue) <> "") {
				$this->vehicle_type->ViewValue = $this->vehicle_type->optionCaption($this->vehicle_type->CurrentValue);
			} else {
				$this->vehicle_type->ViewValue = NULL;
			}
			$this->vehicle_type->ViewCustomAttributes = "";

			// vehicle
			$this->vehicle->ViewValue = $this->vehicle->CurrentValue;
			$curVal = strval($this->vehicle->CurrentValue);
			if ($curVal <> "") {
				$this->vehicle->ViewValue = $this->vehicle->lookupCacheOption($curVal);
				if ($this->vehicle->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`status`=1 and `running_status` = 0" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->vehicle->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->vehicle->ViewValue = $this->vehicle->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->vehicle->ViewValue = $this->vehicle->CurrentValue;
					}
				}
			} else {
				$this->vehicle->ViewValue = NULL;
			}
			$this->vehicle->ViewCustomAttributes = "";

			// route
			$this->_route->ViewValue = $this->_route->CurrentValue;
			$curVal = strval($this->_route->CurrentValue);
			if ($curVal <> "") {
				$this->_route->ViewValue = $this->_route->lookupCacheOption($curVal);
				if ($this->_route->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->_route->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->_route->ViewValue = $this->_route->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->_route->ViewValue = $this->_route->CurrentValue;
					}
				}
			} else {
				$this->_route->ViewValue = NULL;
			}
			$this->_route->ViewCustomAttributes = "";

			// reports_to
			$curVal = strval($this->reports_to->CurrentValue);
			if ($curVal <> "") {
				$this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
				if ($this->reports_to->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`activated`=1 and `userlevel`=1003";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->reports_to->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->reports_to->ViewValue = $this->reports_to->CurrentValue;
					}
				}
			} else {
				$this->reports_to->ViewValue = NULL;
			}
			$this->reports_to->ViewCustomAttributes = "";

			// vehicle_freight_type
			if (strval($this->vehicle_freight_type->CurrentValue) <> "") {
				$this->vehicle_freight_type->ViewValue = $this->vehicle_freight_type->optionCaption($this->vehicle_freight_type->CurrentValue);
			} else {
				$this->vehicle_freight_type->ViewValue = NULL;
			}
			$this->vehicle_freight_type->ViewCustomAttributes = "";

			// vehicle_freight_amount
			$this->vehicle_freight_amount->ViewValue = $this->vehicle_freight_amount->CurrentValue;
			$this->vehicle_freight_amount->ViewValue = FormatNumber($this->vehicle_freight_amount->ViewValue, 2, -2, -2, -2);
			$this->vehicle_freight_amount->ViewCustomAttributes = "";

			// material
			$this->material->ViewValue = $this->material->CurrentValue;
			$this->material->ViewCustomAttributes = "";

			// @
			$this->_40->ViewValue = $this->_40->CurrentValue;
			$this->_40->ViewValue = FormatNumber($this->_40->ViewValue, 2, -2, -2, -2);
			$this->_40->ViewCustomAttributes = "";

			// buyer
			$this->buyer->ViewValue = $this->buyer->CurrentValue;
			$curVal = strval($this->buyer->CurrentValue);
			if ($curVal <> "") {
				$this->buyer->ViewValue = $this->buyer->lookupCacheOption($curVal);
				if ($this->buyer->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyer->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->buyer->ViewValue = $this->buyer->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer->ViewValue = $this->buyer->CurrentValue;
					}
				}
			} else {
				$this->buyer->ViewValue = NULL;
			}
			$this->buyer->ViewCustomAttributes = "";

			// agent
			if ($this->agent->VirtualValue <> "") {
				$this->agent->ViewValue = $this->agent->VirtualValue;
			} else {
				$this->agent->ViewValue = $this->agent->CurrentValue;
			$curVal = strval($this->agent->CurrentValue);
			if ($curVal <> "") {
				$this->agent->ViewValue = $this->agent->lookupCacheOption($curVal);
				if ($this->agent->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->agent->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->agent->ViewValue = $this->agent->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->agent->ViewValue = $this->agent->CurrentValue;
					}
				}
			} else {
				$this->agent->ViewValue = NULL;
			}
			}
			$this->agent->ViewCustomAttributes = "";

			// comm
			$this->comm->ViewValue = $this->comm->CurrentValue;
			$this->comm->ViewValue = FormatNumber($this->comm->ViewValue, 2, -2, -2, -2);
			$this->comm->ViewCustomAttributes = "";

			// load_date
			$this->load_date->ViewValue = $this->load_date->CurrentValue;
			$this->load_date->ViewValue = FormatDateTime($this->load_date->ViewValue, 1);
			$this->load_date->ViewCustomAttributes = "";

			// load_weight
			$this->load_weight->ViewValue = $this->load_weight->CurrentValue;
			$this->load_weight->ViewValue = FormatNumber($this->load_weight->ViewValue, 0, -2, -2, -2);
			$this->load_weight->ViewCustomAttributes = "";

			// load_km
			$this->load_km->ViewValue = $this->load_km->CurrentValue;
			$this->load_km->ViewValue = FormatNumber($this->load_km->ViewValue, 0, -2, -2, -2);
			$this->load_km->ViewCustomAttributes = "";

			// gst_percent
			$this->gst_percent->ViewValue = $this->gst_percent->CurrentValue;
			$this->gst_percent->ViewValue = FormatNumber($this->gst_percent->ViewValue, 2, -2, -2, -2);
			$this->gst_percent->ViewCustomAttributes = "";

			// driver
			$this->driver->ViewValue = $this->driver->CurrentValue;
			$this->driver->ViewCustomAttributes = "";

			// vehicle_freight_comm
			$this->vehicle_freight_comm->ViewValue = $this->vehicle_freight_comm->CurrentValue;
			$this->vehicle_freight_comm->ViewValue = FormatNumber($this->vehicle_freight_comm->ViewValue, 2, -2, -2, -2);
			$this->vehicle_freight_comm->ViewCustomAttributes = "";

			// freight_type
			if (strval($this->freight_type->CurrentValue) <> "") {
				$this->freight_type->ViewValue = $this->freight_type->optionCaption($this->freight_type->CurrentValue);
			} else {
				$this->freight_type->ViewValue = NULL;
			}
			$this->freight_type->ViewCustomAttributes = "";

			// freight
			$this->freight->ViewValue = $this->freight->CurrentValue;
			$this->freight->ViewValue = FormatNumber($this->freight->ViewValue, 2, -2, -2, -2);
			$this->freight->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";
			if (!$this->isExport())
				$this->id->ViewValue = $this->highlightValue($this->id);

			// vehicle_type
			$this->vehicle_type->LinkCustomAttributes = "";
			$this->vehicle_type->HrefValue = "";
			$this->vehicle_type->TooltipValue = "";

			// vehicle
			$this->vehicle->LinkCustomAttributes = "";
			$this->vehicle->HrefValue = "";
			$this->vehicle->TooltipValue = "";

			// reports_to
			$this->reports_to->LinkCustomAttributes = "";
			$this->reports_to->HrefValue = "";
			$this->reports_to->TooltipValue = "";

			// vehicle_freight_type
			$this->vehicle_freight_type->LinkCustomAttributes = "";
			$this->vehicle_freight_type->HrefValue = "";
			$this->vehicle_freight_type->TooltipValue = "";

			// vehicle_freight_amount
			$this->vehicle_freight_amount->LinkCustomAttributes = "";
			$this->vehicle_freight_amount->HrefValue = "";
			$this->vehicle_freight_amount->TooltipValue = "";

			// material
			$this->material->LinkCustomAttributes = "";
			$this->material->HrefValue = "";
			$this->material->TooltipValue = "";
			if (!$this->isExport())
				$this->material->ViewValue = $this->highlightValue($this->material);

			// @
			$this->_40->LinkCustomAttributes = "";
			$this->_40->HrefValue = "";
			$this->_40->TooltipValue = "";

			// buyer
			$this->buyer->LinkCustomAttributes = "";
			$this->buyer->HrefValue = "";
			$this->buyer->TooltipValue = "";

			// agent
			$this->agent->LinkCustomAttributes = "";
			$this->agent->HrefValue = "";
			$this->agent->TooltipValue = "";

			// comm
			$this->comm->LinkCustomAttributes = "";
			$this->comm->HrefValue = "";
			$this->comm->TooltipValue = "";

			// load_date
			$this->load_date->LinkCustomAttributes = "";
			$this->load_date->HrefValue = "";
			$this->load_date->TooltipValue = "";

			// load_weight
			$this->load_weight->LinkCustomAttributes = "";
			$this->load_weight->HrefValue = "";
			$this->load_weight->TooltipValue = "";

			// load_km
			$this->load_km->LinkCustomAttributes = "";
			$this->load_km->HrefValue = "";
			$this->load_km->TooltipValue = "";

			// gst_percent
			$this->gst_percent->LinkCustomAttributes = "";
			$this->gst_percent->HrefValue = "";
			$this->gst_percent->TooltipValue = "";

			// driver
			$this->driver->LinkCustomAttributes = "";
			$this->driver->HrefValue = "";
			$this->driver->TooltipValue = "";
			if (!$this->isExport())
				$this->driver->ViewValue = $this->highlightValue($this->driver);

			// vehicle_freight_comm
			$this->vehicle_freight_comm->LinkCustomAttributes = "";
			$this->vehicle_freight_comm->HrefValue = "";
			$this->vehicle_freight_comm->TooltipValue = "";

			// freight_type
			$this->freight_type->LinkCustomAttributes = "";
			$this->freight_type->HrefValue = "";
			$this->freight_type->TooltipValue = "";

			// freight
			$this->freight->LinkCustomAttributes = "";
			$this->freight->HrefValue = "";
			$this->freight->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// vehicle_type
			$this->vehicle_type->EditAttrs["class"] = "form-control";
			$this->vehicle_type->EditCustomAttributes = "";
			$this->vehicle_type->EditValue = $this->vehicle_type->options(TRUE);

			// vehicle
			$this->vehicle->EditAttrs["class"] = "form-control";
			$this->vehicle->EditCustomAttributes = "";
			$this->vehicle->EditValue = HtmlEncode($this->vehicle->AdvancedSearch->SearchValue);
			$curVal = strval($this->vehicle->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->vehicle->EditValue = $this->vehicle->lookupCacheOption($curVal);
				if ($this->vehicle->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`status`=1 and `running_status` = 0" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->vehicle->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->vehicle->EditValue = $this->vehicle->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->vehicle->EditValue = HtmlEncode($this->vehicle->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->vehicle->EditValue = NULL;
			}
			$this->vehicle->PlaceHolder = RemoveHtml($this->vehicle->caption());

			// reports_to
			$this->reports_to->EditAttrs["class"] = "form-control";
			$this->reports_to->EditCustomAttributes = "";

			// vehicle_freight_type
			$this->vehicle_freight_type->EditAttrs["class"] = "form-control";
			$this->vehicle_freight_type->EditCustomAttributes = "";
			$this->vehicle_freight_type->EditValue = $this->vehicle_freight_type->options(TRUE);

			// vehicle_freight_amount
			$this->vehicle_freight_amount->EditAttrs["class"] = "form-control";
			$this->vehicle_freight_amount->EditCustomAttributes = "";
			$this->vehicle_freight_amount->EditValue = HtmlEncode($this->vehicle_freight_amount->AdvancedSearch->SearchValue);
			$this->vehicle_freight_amount->PlaceHolder = RemoveHtml($this->vehicle_freight_amount->caption());

			// material
			$this->material->EditAttrs["class"] = "form-control";
			$this->material->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->material->AdvancedSearch->SearchValue = HtmlDecode($this->material->AdvancedSearch->SearchValue);
			$this->material->EditValue = HtmlEncode($this->material->AdvancedSearch->SearchValue);
			$this->material->PlaceHolder = RemoveHtml($this->material->caption());

			// @
			$this->_40->EditAttrs["class"] = "form-control";
			$this->_40->EditCustomAttributes = "";
			$this->_40->EditValue = HtmlEncode($this->_40->AdvancedSearch->SearchValue);
			$this->_40->PlaceHolder = RemoveHtml($this->_40->caption());

			// buyer
			$this->buyer->EditAttrs["class"] = "form-control";
			$this->buyer->EditCustomAttributes = "";
			$this->buyer->EditValue = HtmlEncode($this->buyer->AdvancedSearch->SearchValue);
			$curVal = strval($this->buyer->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->buyer->EditValue = $this->buyer->lookupCacheOption($curVal);
				if ($this->buyer->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyer->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->buyer->EditValue = $this->buyer->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer->EditValue = HtmlEncode($this->buyer->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->buyer->EditValue = NULL;
			}
			$this->buyer->PlaceHolder = RemoveHtml($this->buyer->caption());

			// agent
			$this->agent->EditAttrs["class"] = "form-control";
			$this->agent->EditCustomAttributes = "";
			$this->agent->EditValue = HtmlEncode($this->agent->AdvancedSearch->SearchValue);
			$this->agent->PlaceHolder = RemoveHtml($this->agent->caption());

			// comm
			$this->comm->EditAttrs["class"] = "form-control";
			$this->comm->EditCustomAttributes = "";
			$this->comm->EditValue = HtmlEncode($this->comm->AdvancedSearch->SearchValue);
			$this->comm->PlaceHolder = RemoveHtml($this->comm->caption());

			// load_date
			$this->load_date->EditAttrs["class"] = "form-control";
			$this->load_date->EditCustomAttributes = "";
			$this->load_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->load_date->AdvancedSearch->SearchValue, 1), 8));
			$this->load_date->PlaceHolder = RemoveHtml($this->load_date->caption());

			// load_weight
			$this->load_weight->EditAttrs["class"] = "form-control";
			$this->load_weight->EditCustomAttributes = "";
			$this->load_weight->EditValue = HtmlEncode($this->load_weight->AdvancedSearch->SearchValue);
			$this->load_weight->PlaceHolder = RemoveHtml($this->load_weight->caption());

			// load_km
			$this->load_km->EditAttrs["class"] = "form-control";
			$this->load_km->EditCustomAttributes = "";
			$this->load_km->EditValue = HtmlEncode($this->load_km->AdvancedSearch->SearchValue);
			$this->load_km->PlaceHolder = RemoveHtml($this->load_km->caption());

			// gst_percent
			$this->gst_percent->EditAttrs["class"] = "form-control";
			$this->gst_percent->EditCustomAttributes = "";
			$this->gst_percent->EditValue = HtmlEncode($this->gst_percent->AdvancedSearch->SearchValue);
			$this->gst_percent->PlaceHolder = RemoveHtml($this->gst_percent->caption());

			// driver
			$this->driver->EditAttrs["class"] = "form-control";
			$this->driver->EditCustomAttributes = 'ReadOnly';
			$this->driver->EditValue = HtmlEncode($this->driver->AdvancedSearch->SearchValue);
			$this->driver->PlaceHolder = RemoveHtml($this->driver->caption());

			// vehicle_freight_comm
			$this->vehicle_freight_comm->EditAttrs["class"] = "form-control";
			$this->vehicle_freight_comm->EditCustomAttributes = "";
			$this->vehicle_freight_comm->EditValue = HtmlEncode($this->vehicle_freight_comm->AdvancedSearch->SearchValue);
			$this->vehicle_freight_comm->PlaceHolder = RemoveHtml($this->vehicle_freight_comm->caption());

			// freight_type
			$this->freight_type->EditAttrs["class"] = "form-control";
			$this->freight_type->EditCustomAttributes = "";
			$this->freight_type->EditValue = $this->freight_type->options(TRUE);

			// freight
			$this->freight->EditAttrs["class"] = "form-control";
			$this->freight->EditCustomAttributes = "";
			$this->freight->EditValue = HtmlEncode($this->freight->AdvancedSearch->SearchValue);
			$this->freight->PlaceHolder = RemoveHtml($this->freight->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->vehicle->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->vehicle->errorMessage());
		}
		if (!CheckInteger($this->buyer->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->buyer->errorMessage());
		}
		if (!CheckDate($this->load_date->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->load_date->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->vehicle_type->AdvancedSearch->load();
		$this->vehicle->AdvancedSearch->load();
		$this->_route->AdvancedSearch->load();
		$this->reports_to->AdvancedSearch->load();
		$this->vehicle_freight_type->AdvancedSearch->load();
		$this->vehicle_freight_amount->AdvancedSearch->load();
		$this->material->AdvancedSearch->load();
		$this->_40->AdvancedSearch->load();
		$this->buyer->AdvancedSearch->load();
		$this->agent->AdvancedSearch->load();
		$this->comm->AdvancedSearch->load();
		$this->load_date->AdvancedSearch->load();
		$this->load_weight->AdvancedSearch->load();
		$this->load_km->AdvancedSearch->load();
		$this->gst_percent->AdvancedSearch->load();
		$this->driver->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->vehicle_freight_comm->AdvancedSearch->load();
		$this->freight_type->AdvancedSearch->load();
		$this->freight->AdvancedSearch->load();
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.ft_trip_startlist,'" . $this->ExportExcelUrl . "','excel',true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.ft_trip_startlist,'" . $this->ExportWordUrl . "','word',true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"" . $this->ExportWordUrl . "\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.ft_trip_startlist,'" . $this->ExportPdfUrl . "','pdf',true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "print")) {
			return "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = FALSE;

		// Export to Html
		$item = &$this->ExportOptions->add("html");
		$item->Body = $this->getExportTag("html");
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->add("xml");
		$item->Body = $this->getExportTag("xml");
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->add("csv");
		$item->Body = $this->getExportTag("csv");
		$item->Visible = TRUE;

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$url = "";
		$item->Body = "<button id=\"emf_t_trip_start\" class=\"ew-export-link ew-email\" title=\"" . $Language->phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->phrase("ExportToEmailText") . "\" onclick=\"ew.emailDialogShow({lnk:'emf_t_trip_start',hdr:ew.language.phrase('ExportToEmailText'),f:document.ft_trip_startlist,sel:false" . $url . "});\">" . $Language->phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = TRUE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	/**
	 * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	 *
	 * @param boolean $return Return the data rather than output it
	 * @return mixed 
	 */
	public function exportData($return = FALSE)
	{
		global $Language;
		$utf8 = SameText(PROJECT_CHARSET, "utf-8");
		$selectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($selectLimit) {
			$this->TotalRecs = $this->listRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->loadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->setupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($selectLimit)
			$rs = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		$this->ExportDoc = GetExportDocument($this, "h");
		$doc = &$this->ExportDoc;
		if (!$doc)
			$this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
		if (!$rs || !$doc) {
			RemoveHeader("Content-Type"); // Remove header
			RemoveHeader("Content-Disposition");
			$this->showMessage();
			return;
		}
		if ($selectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		$doc->Text .= $header;
		$this->exportDocument($doc, $rs, $this->StartRec, $this->StopRec, "");
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		$doc->Text .= $footer;

		// Close recordset
		$rs->close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$doc->exportHeaderAndFooter();

		// Clean output buffer (without destroying output buffer)
		$buffer = ob_get_contents(); // Save the output buffer
		if (!DEBUG_ENABLED && $buffer)
			ob_clean();

		// Write debug message if enabled
		if (DEBUG_ENABLED && !$this->isExport("pdf"))
			echo GetDebugMessage();

		// Output data
		if ($this->isExport("email")) {

			// Export-to-email disabled
		} else {
			$doc->export();
			if ($return) {
				RemoveHeader("Content-Type"); // Remove header
				RemoveHeader("Content-Disposition");
				$content = ob_get_contents();
				if ($content)
					ob_clean();
				if ($buffer)
					echo $buffer; // Resume the output buffer
				return $content;
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_vehicle":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`status`=1 and `running_status` = 0" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x__route":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_reports_to":
					$lookupFilter = function() {
						return "`activated`=1 and `userlevel`=1003";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_buyer":
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_agent":
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_vehicle":
							break;
						case "x__route":
							break;
						case "x_reports_to":
							break;
						case "x_buyer":
							break;
						case "x_agent":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
}
?>