<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for test_report
 */
class test_report extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $grp;
	public $s_grp;
	public $product;
	public $ref;
	public $lot_no;
	public $dated;
	public $d_01;
	public $d_02;
	public $d_03;
	public $d_04;
	public $d_05;
	public $d_06;
	public $d_07;
	public $d_08;
	public $d_09;
	public $d_10;
	public $d_11;
	public $d_12;
	public $d_13;
	public $d_14;
	public $d_15;
	public $d_16;
	public $d_17;
	public $d_18;
	public $d_19;
	public $d_20;
	public $operator;
	public $datetime;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'test_report';
		$this->TableName = 'test_report';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`test_report`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('test_report', 'test_report', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// grp
		$this->grp = new DbField('test_report', 'test_report', 'x_grp', 'grp', '`grp`', '`grp`', 18, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->grp->Nullable = FALSE; // NOT NULL field
		$this->grp->Required = TRUE; // Required field
		$this->grp->Sortable = TRUE; // Allow sort
		$this->grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->grp->Lookup = new Lookup('grp', 'grp', FALSE, 'id', ["grp","","",""], [], ["x_s_grp"], [], [], [], [], '`grp` ASC', '');
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// s_grp
		$this->s_grp = new DbField('test_report', 'test_report', 'x_s_grp', 's_grp', '`s_grp`', '`s_grp`', 18, -1, FALSE, '`s_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->s_grp->Nullable = FALSE; // NOT NULL field
		$this->s_grp->Required = TRUE; // Required field
		$this->s_grp->Sortable = TRUE; // Allow sort
		$this->s_grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->s_grp->Lookup = new Lookup('s_grp', 'product_group', FALSE, 'id', ["product_group","","",""], ["x_grp"], ["x_product"], ["grp"], ["x_grp"], [], [], '`product_group` ASC', '');
		$this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['s_grp'] = &$this->s_grp;

		// product
		$this->product = new DbField('test_report', 'test_report', 'x_product', 'product', '`product`', '`product`', 18, -1, FALSE, '`product`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->product->Nullable = FALSE; // NOT NULL field
		$this->product->Required = TRUE; // Required field
		$this->product->Sortable = TRUE; // Allow sort
		$this->product->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->product->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->product->Lookup = new Lookup('product', 'product', FALSE, 'id', ["product","","",""], ["x_s_grp"], ["x_ref"], ["s_grp"], ["x_s_grp[]"], [], [], '`product` ASC', '');
		$this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product'] = &$this->product;

		// ref
		$this->ref = new DbField('test_report', 'test_report', 'x_ref', 'ref', '`ref`', '`ref`', 18, -1, FALSE, '`ref`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'RADIO');
		$this->ref->Nullable = FALSE; // NOT NULL field
		$this->ref->Required = TRUE; // Required field
		$this->ref->Sortable = TRUE; // Allow sort
		$this->ref->Lookup = new Lookup('ref', 'ref', FALSE, 'id', ["product_code","","",""], ["x_product"], ["x_lot_no"], ["product"], ["x_product"], [], [], '`product_code` ASC', '');
		$this->ref->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['ref'] = &$this->ref;

		// lot_no
		$this->lot_no = new DbField('test_report', 'test_report', 'x_lot_no', 'lot_no', '`lot_no`', '`lot_no`', 200, -1, FALSE, '`lot_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->lot_no->Nullable = FALSE; // NOT NULL field
		$this->lot_no->Required = TRUE; // Required field
		$this->lot_no->Sortable = TRUE; // Allow sort
		$this->fields['lot_no'] = &$this->lot_no;

		// dated
		$this->dated = new DbField('test_report', 'test_report', 'x_dated', 'dated', '`dated`', CastDateFieldForLike('`dated`', 2, "DB"), 133, 2, FALSE, '`dated`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->dated->Nullable = FALSE; // NOT NULL field
		$this->dated->Required = TRUE; // Required field
		$this->dated->Sortable = TRUE; // Allow sort
		$this->dated->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['dated'] = &$this->dated;

		// d_01
		$this->d_01 = new DbField('test_report', 'test_report', 'x_d_01', 'd_01', '`d_01`', '`d_01`', 4, -1, FALSE, '`d_01`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_01->Nullable = FALSE; // NOT NULL field
		$this->d_01->Required = TRUE; // Required field
		$this->d_01->Sortable = TRUE; // Allow sort
		$this->fields['d_01'] = &$this->d_01;

		// d_02
		$this->d_02 = new DbField('test_report', 'test_report', 'x_d_02', 'd_02', '`d_02`', '`d_02`', 4, -1, FALSE, '`d_02`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_02->Nullable = FALSE; // NOT NULL field
		$this->d_02->Required = TRUE; // Required field
		$this->d_02->Sortable = TRUE; // Allow sort
		$this->fields['d_02'] = &$this->d_02;

		// d_03
		$this->d_03 = new DbField('test_report', 'test_report', 'x_d_03', 'd_03', '`d_03`', '`d_03`', 4, -1, FALSE, '`d_03`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_03->Nullable = FALSE; // NOT NULL field
		$this->d_03->Required = TRUE; // Required field
		$this->d_03->Sortable = TRUE; // Allow sort
		$this->fields['d_03'] = &$this->d_03;

		// d_04
		$this->d_04 = new DbField('test_report', 'test_report', 'x_d_04', 'd_04', '`d_04`', '`d_04`', 4, -1, FALSE, '`d_04`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_04->Nullable = FALSE; // NOT NULL field
		$this->d_04->Required = TRUE; // Required field
		$this->d_04->Sortable = TRUE; // Allow sort
		$this->fields['d_04'] = &$this->d_04;

		// d_05
		$this->d_05 = new DbField('test_report', 'test_report', 'x_d_05', 'd_05', '`d_05`', '`d_05`', 4, -1, FALSE, '`d_05`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_05->Nullable = FALSE; // NOT NULL field
		$this->d_05->Required = TRUE; // Required field
		$this->d_05->Sortable = TRUE; // Allow sort
		$this->fields['d_05'] = &$this->d_05;

		// d_06
		$this->d_06 = new DbField('test_report', 'test_report', 'x_d_06', 'd_06', '`d_06`', '`d_06`', 4, -1, FALSE, '`d_06`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_06->Nullable = FALSE; // NOT NULL field
		$this->d_06->Required = TRUE; // Required field
		$this->d_06->Sortable = TRUE; // Allow sort
		$this->fields['d_06'] = &$this->d_06;

		// d_07
		$this->d_07 = new DbField('test_report', 'test_report', 'x_d_07', 'd_07', '`d_07`', '`d_07`', 4, -1, FALSE, '`d_07`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_07->Nullable = FALSE; // NOT NULL field
		$this->d_07->Required = TRUE; // Required field
		$this->d_07->Sortable = TRUE; // Allow sort
		$this->fields['d_07'] = &$this->d_07;

		// d_08
		$this->d_08 = new DbField('test_report', 'test_report', 'x_d_08', 'd_08', '`d_08`', '`d_08`', 4, -1, FALSE, '`d_08`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_08->Nullable = FALSE; // NOT NULL field
		$this->d_08->Required = TRUE; // Required field
		$this->d_08->Sortable = TRUE; // Allow sort
		$this->fields['d_08'] = &$this->d_08;

		// d_09
		$this->d_09 = new DbField('test_report', 'test_report', 'x_d_09', 'd_09', '`d_09`', '`d_09`', 4, -1, FALSE, '`d_09`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_09->Nullable = FALSE; // NOT NULL field
		$this->d_09->Required = TRUE; // Required field
		$this->d_09->Sortable = TRUE; // Allow sort
		$this->fields['d_09'] = &$this->d_09;

		// d_10
		$this->d_10 = new DbField('test_report', 'test_report', 'x_d_10', 'd_10', '`d_10`', '`d_10`', 4, -1, FALSE, '`d_10`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_10->Nullable = FALSE; // NOT NULL field
		$this->d_10->Required = TRUE; // Required field
		$this->d_10->Sortable = TRUE; // Allow sort
		$this->fields['d_10'] = &$this->d_10;

		// d_11
		$this->d_11 = new DbField('test_report', 'test_report', 'x_d_11', 'd_11', '`d_11`', '`d_11`', 4, -1, FALSE, '`d_11`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_11->Nullable = FALSE; // NOT NULL field
		$this->d_11->Required = TRUE; // Required field
		$this->d_11->Sortable = TRUE; // Allow sort
		$this->fields['d_11'] = &$this->d_11;

		// d_12
		$this->d_12 = new DbField('test_report', 'test_report', 'x_d_12', 'd_12', '`d_12`', '`d_12`', 4, -1, FALSE, '`d_12`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_12->Nullable = FALSE; // NOT NULL field
		$this->d_12->Required = TRUE; // Required field
		$this->d_12->Sortable = TRUE; // Allow sort
		$this->fields['d_12'] = &$this->d_12;

		// d_13
		$this->d_13 = new DbField('test_report', 'test_report', 'x_d_13', 'd_13', '`d_13`', '`d_13`', 4, -1, FALSE, '`d_13`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_13->Nullable = FALSE; // NOT NULL field
		$this->d_13->Required = TRUE; // Required field
		$this->d_13->Sortable = TRUE; // Allow sort
		$this->fields['d_13'] = &$this->d_13;

		// d_14
		$this->d_14 = new DbField('test_report', 'test_report', 'x_d_14', 'd_14', '`d_14`', '`d_14`', 4, -1, FALSE, '`d_14`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_14->Nullable = FALSE; // NOT NULL field
		$this->d_14->Required = TRUE; // Required field
		$this->d_14->Sortable = TRUE; // Allow sort
		$this->fields['d_14'] = &$this->d_14;

		// d_15
		$this->d_15 = new DbField('test_report', 'test_report', 'x_d_15', 'd_15', '`d_15`', '`d_15`', 4, -1, FALSE, '`d_15`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_15->Nullable = FALSE; // NOT NULL field
		$this->d_15->Required = TRUE; // Required field
		$this->d_15->Sortable = TRUE; // Allow sort
		$this->fields['d_15'] = &$this->d_15;

		// d_16
		$this->d_16 = new DbField('test_report', 'test_report', 'x_d_16', 'd_16', '`d_16`', '`d_16`', 4, -1, FALSE, '`d_16`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_16->Nullable = FALSE; // NOT NULL field
		$this->d_16->Required = TRUE; // Required field
		$this->d_16->Sortable = TRUE; // Allow sort
		$this->fields['d_16'] = &$this->d_16;

		// d_17
		$this->d_17 = new DbField('test_report', 'test_report', 'x_d_17', 'd_17', '`d_17`', '`d_17`', 4, -1, FALSE, '`d_17`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_17->Nullable = FALSE; // NOT NULL field
		$this->d_17->Required = TRUE; // Required field
		$this->d_17->Sortable = TRUE; // Allow sort
		$this->fields['d_17'] = &$this->d_17;

		// d_18
		$this->d_18 = new DbField('test_report', 'test_report', 'x_d_18', 'd_18', '`d_18`', '`d_18`', 4, -1, FALSE, '`d_18`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_18->Nullable = FALSE; // NOT NULL field
		$this->d_18->Required = TRUE; // Required field
		$this->d_18->Sortable = TRUE; // Allow sort
		$this->fields['d_18'] = &$this->d_18;

		// d_19
		$this->d_19 = new DbField('test_report', 'test_report', 'x_d_19', 'd_19', '`d_19`', '`d_19`', 4, -1, FALSE, '`d_19`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_19->Nullable = FALSE; // NOT NULL field
		$this->d_19->Required = TRUE; // Required field
		$this->d_19->Sortable = TRUE; // Allow sort
		$this->fields['d_19'] = &$this->d_19;

		// d_20
		$this->d_20 = new DbField('test_report', 'test_report', 'x_d_20', 'd_20', '`d_20`', '`d_20`', 4, -1, FALSE, '`d_20`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_20->Nullable = FALSE; // NOT NULL field
		$this->d_20->Required = TRUE; // Required field
		$this->d_20->Sortable = TRUE; // Allow sort
		$this->fields['d_20'] = &$this->d_20;

		// operator
		$this->operator = new DbField('test_report', 'test_report', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('test_report', 'test_report', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Nullable = FALSE; // NOT NULL field
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`test_report`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->grp->DbValue = $row['grp'];
		$this->s_grp->DbValue = $row['s_grp'];
		$this->product->DbValue = $row['product'];
		$this->ref->DbValue = $row['ref'];
		$this->lot_no->DbValue = $row['lot_no'];
		$this->dated->DbValue = $row['dated'];
		$this->d_01->DbValue = $row['d_01'];
		$this->d_02->DbValue = $row['d_02'];
		$this->d_03->DbValue = $row['d_03'];
		$this->d_04->DbValue = $row['d_04'];
		$this->d_05->DbValue = $row['d_05'];
		$this->d_06->DbValue = $row['d_06'];
		$this->d_07->DbValue = $row['d_07'];
		$this->d_08->DbValue = $row['d_08'];
		$this->d_09->DbValue = $row['d_09'];
		$this->d_10->DbValue = $row['d_10'];
		$this->d_11->DbValue = $row['d_11'];
		$this->d_12->DbValue = $row['d_12'];
		$this->d_13->DbValue = $row['d_13'];
		$this->d_14->DbValue = $row['d_14'];
		$this->d_15->DbValue = $row['d_15'];
		$this->d_16->DbValue = $row['d_16'];
		$this->d_17->DbValue = $row['d_17'];
		$this->d_18->DbValue = $row['d_18'];
		$this->d_19->DbValue = $row['d_19'];
		$this->d_20->DbValue = $row['d_20'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "test_reportlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "test_reportview.php")
			return $Language->phrase("View");
		elseif ($pageName == "test_reportedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "test_reportadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "test_reportlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("test_reportview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("test_reportview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "test_reportadd.php?" . $this->getUrlParm($parm);
		else
			$url = "test_reportadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("test_reportedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("test_reportadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("test_reportdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->s_grp->setDbValue($rs->fields('s_grp'));
		$this->product->setDbValue($rs->fields('product'));
		$this->ref->setDbValue($rs->fields('ref'));
		$this->lot_no->setDbValue($rs->fields('lot_no'));
		$this->dated->setDbValue($rs->fields('dated'));
		$this->d_01->setDbValue($rs->fields('d_01'));
		$this->d_02->setDbValue($rs->fields('d_02'));
		$this->d_03->setDbValue($rs->fields('d_03'));
		$this->d_04->setDbValue($rs->fields('d_04'));
		$this->d_05->setDbValue($rs->fields('d_05'));
		$this->d_06->setDbValue($rs->fields('d_06'));
		$this->d_07->setDbValue($rs->fields('d_07'));
		$this->d_08->setDbValue($rs->fields('d_08'));
		$this->d_09->setDbValue($rs->fields('d_09'));
		$this->d_10->setDbValue($rs->fields('d_10'));
		$this->d_11->setDbValue($rs->fields('d_11'));
		$this->d_12->setDbValue($rs->fields('d_12'));
		$this->d_13->setDbValue($rs->fields('d_13'));
		$this->d_14->setDbValue($rs->fields('d_14'));
		$this->d_15->setDbValue($rs->fields('d_15'));
		$this->d_16->setDbValue($rs->fields('d_16'));
		$this->d_17->setDbValue($rs->fields('d_17'));
		$this->d_18->setDbValue($rs->fields('d_18'));
		$this->d_19->setDbValue($rs->fields('d_19'));
		$this->d_20->setDbValue($rs->fields('d_20'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// grp
		// s_grp
		// product
		// ref
		// lot_no
		// dated
		// d_01
		// d_02
		// d_03
		// d_04
		// d_05
		// d_06
		// d_07
		// d_08
		// d_09
		// d_10
		// d_11
		// d_12
		// d_13
		// d_14
		// d_15
		// d_16
		// d_17
		// d_18
		// d_19
		// d_20
		// operator
		// datetime
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
		$this->id->ViewCustomAttributes = "";

		// grp
		$curVal = strval($this->grp->CurrentValue);
		if ($curVal <> "") {
			$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			if ($this->grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->grp->ViewValue = $this->grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->grp->ViewValue = $this->grp->CurrentValue;
				}
			}
		} else {
			$this->grp->ViewValue = NULL;
		}
		$this->grp->ViewCustomAttributes = "";

		// s_grp
		$curVal = strval($this->s_grp->CurrentValue);
		if ($curVal <> "") {
			$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			if ($this->s_grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
				}
			}
		} else {
			$this->s_grp->ViewValue = NULL;
		}
		$this->s_grp->ViewCustomAttributes = "";

		// product
		$curVal = strval($this->product->CurrentValue);
		if ($curVal <> "") {
			$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
			if ($this->product->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product->ViewValue = $this->product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product->ViewValue = $this->product->CurrentValue;
				}
			}
		} else {
			$this->product->ViewValue = NULL;
		}
		$this->product->CssClass = "font-italic";
		$this->product->ViewCustomAttributes = "";

		// ref
		$curVal = strval($this->ref->CurrentValue);
		if ($curVal <> "") {
			$this->ref->ViewValue = $this->ref->lookupCacheOption($curVal);
			if ($this->ref->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->ref->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->ref->ViewValue = $this->ref->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->ref->ViewValue = $this->ref->CurrentValue;
				}
			}
		} else {
			$this->ref->ViewValue = NULL;
		}
		$this->ref->ViewCustomAttributes = "";

		// lot_no
		$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
		$this->lot_no->ViewCustomAttributes = "";

		// dated
		$this->dated->ViewValue = $this->dated->CurrentValue;
		$this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, 2);
		$this->dated->ViewCustomAttributes = "";

		// d_01
		$this->d_01->ViewValue = $this->d_01->CurrentValue;
		$this->d_01->ViewCustomAttributes = "";

		// d_02
		$this->d_02->ViewValue = $this->d_02->CurrentValue;
		$this->d_02->ViewCustomAttributes = "";

		// d_03
		$this->d_03->ViewValue = $this->d_03->CurrentValue;
		$this->d_03->ViewCustomAttributes = "";

		// d_04
		$this->d_04->ViewValue = $this->d_04->CurrentValue;
		$this->d_04->ViewCustomAttributes = "";

		// d_05
		$this->d_05->ViewValue = $this->d_05->CurrentValue;
		$this->d_05->ViewCustomAttributes = "";

		// d_06
		$this->d_06->ViewValue = $this->d_06->CurrentValue;
		$this->d_06->ViewCustomAttributes = "";

		// d_07
		$this->d_07->ViewValue = $this->d_07->CurrentValue;
		$this->d_07->ViewCustomAttributes = "";

		// d_08
		$this->d_08->ViewValue = $this->d_08->CurrentValue;
		$this->d_08->ViewCustomAttributes = "";

		// d_09
		$this->d_09->ViewValue = $this->d_09->CurrentValue;
		$this->d_09->ViewCustomAttributes = "";

		// d_10
		$this->d_10->ViewValue = $this->d_10->CurrentValue;
		$this->d_10->ViewCustomAttributes = "";

		// d_11
		$this->d_11->ViewValue = $this->d_11->CurrentValue;
		$this->d_11->ViewCustomAttributes = "";

		// d_12
		$this->d_12->ViewValue = $this->d_12->CurrentValue;
		$this->d_12->ViewCustomAttributes = "";

		// d_13
		$this->d_13->ViewValue = $this->d_13->CurrentValue;
		$this->d_13->ViewCustomAttributes = "";

		// d_14
		$this->d_14->ViewValue = $this->d_14->CurrentValue;
		$this->d_14->ViewCustomAttributes = "";

		// d_15
		$this->d_15->ViewValue = $this->d_15->CurrentValue;
		$this->d_15->ViewCustomAttributes = "";

		// d_16
		$this->d_16->ViewValue = $this->d_16->CurrentValue;
		$this->d_16->ViewCustomAttributes = "";

		// d_17
		$this->d_17->ViewValue = $this->d_17->CurrentValue;
		$this->d_17->ViewCustomAttributes = "";

		// d_18
		$this->d_18->ViewValue = $this->d_18->CurrentValue;
		$this->d_18->ViewCustomAttributes = "";

		// d_19
		$this->d_19->ViewValue = $this->d_19->CurrentValue;
		$this->d_19->ViewCustomAttributes = "";

		// d_20
		$this->d_20->ViewValue = $this->d_20->CurrentValue;
		$this->d_20->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		$this->grp->HrefValue = "";
		$this->grp->TooltipValue = "";

		// s_grp
		$this->s_grp->LinkCustomAttributes = "";
		$this->s_grp->HrefValue = "";
		$this->s_grp->TooltipValue = "";

		// product
		$this->product->LinkCustomAttributes = "";
		$this->product->HrefValue = "";
		$this->product->TooltipValue = "";

		// ref
		$this->ref->LinkCustomAttributes = "";
		$this->ref->HrefValue = "";
		$this->ref->TooltipValue = "";

		// lot_no
		$this->lot_no->LinkCustomAttributes = "";
		$this->lot_no->HrefValue = "";
		$this->lot_no->TooltipValue = "";

		// dated
		$this->dated->LinkCustomAttributes = "";
		$this->dated->HrefValue = "";
		$this->dated->TooltipValue = "";

		// d_01
		$this->d_01->LinkCustomAttributes = "";
		$this->d_01->HrefValue = "";
		$this->d_01->TooltipValue = "";

		// d_02
		$this->d_02->LinkCustomAttributes = "";
		$this->d_02->HrefValue = "";
		$this->d_02->TooltipValue = "";

		// d_03
		$this->d_03->LinkCustomAttributes = "";
		$this->d_03->HrefValue = "";
		$this->d_03->TooltipValue = "";

		// d_04
		$this->d_04->LinkCustomAttributes = "";
		$this->d_04->HrefValue = "";
		$this->d_04->TooltipValue = "";

		// d_05
		$this->d_05->LinkCustomAttributes = "";
		$this->d_05->HrefValue = "";
		$this->d_05->TooltipValue = "";

		// d_06
		$this->d_06->LinkCustomAttributes = "";
		$this->d_06->HrefValue = "";
		$this->d_06->TooltipValue = "";

		// d_07
		$this->d_07->LinkCustomAttributes = "";
		$this->d_07->HrefValue = "";
		$this->d_07->TooltipValue = "";

		// d_08
		$this->d_08->LinkCustomAttributes = "";
		$this->d_08->HrefValue = "";
		$this->d_08->TooltipValue = "";

		// d_09
		$this->d_09->LinkCustomAttributes = "";
		$this->d_09->HrefValue = "";
		$this->d_09->TooltipValue = "";

		// d_10
		$this->d_10->LinkCustomAttributes = "";
		$this->d_10->HrefValue = "";
		$this->d_10->TooltipValue = "";

		// d_11
		$this->d_11->LinkCustomAttributes = "";
		$this->d_11->HrefValue = "";
		$this->d_11->TooltipValue = "";

		// d_12
		$this->d_12->LinkCustomAttributes = "";
		$this->d_12->HrefValue = "";
		$this->d_12->TooltipValue = "";

		// d_13
		$this->d_13->LinkCustomAttributes = "";
		$this->d_13->HrefValue = "";
		$this->d_13->TooltipValue = "";

		// d_14
		$this->d_14->LinkCustomAttributes = "";
		$this->d_14->HrefValue = "";
		$this->d_14->TooltipValue = "";

		// d_15
		$this->d_15->LinkCustomAttributes = "";
		$this->d_15->HrefValue = "";
		$this->d_15->TooltipValue = "";

		// d_16
		$this->d_16->LinkCustomAttributes = "";
		$this->d_16->HrefValue = "";
		$this->d_16->TooltipValue = "";

		// d_17
		$this->d_17->LinkCustomAttributes = "";
		$this->d_17->HrefValue = "";
		$this->d_17->TooltipValue = "";

		// d_18
		$this->d_18->LinkCustomAttributes = "";
		$this->d_18->HrefValue = "";
		$this->d_18->TooltipValue = "";

		// d_19
		$this->d_19->LinkCustomAttributes = "";
		$this->d_19->HrefValue = "";
		$this->d_19->TooltipValue = "";

		// d_20
		$this->d_20->LinkCustomAttributes = "";
		$this->d_20->HrefValue = "";
		$this->d_20->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->EditValue = FormatNumber($this->id->EditValue, 0, -2, -2, -2);
		$this->id->ViewCustomAttributes = "";

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";

		// s_grp
		$this->s_grp->EditAttrs["class"] = "form-control";
		$this->s_grp->EditCustomAttributes = "";

		// product
		$this->product->EditAttrs["class"] = "form-control";
		$this->product->EditCustomAttributes = "";

		// ref
		$this->ref->EditCustomAttributes = "";

		// lot_no
		$this->lot_no->EditAttrs["class"] = "form-control";
		$this->lot_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->lot_no->CurrentValue = HtmlDecode($this->lot_no->CurrentValue);
		$this->lot_no->EditValue = $this->lot_no->CurrentValue;
		$this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

		// dated
		$this->dated->EditAttrs["class"] = "form-control";
		$this->dated->EditCustomAttributes = "";
		$this->dated->EditValue = FormatDateTime($this->dated->CurrentValue, 2);
		$this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

		// d_01
		$this->d_01->EditAttrs["class"] = "form-control";
		$this->d_01->EditCustomAttributes = "";
		$this->d_01->EditValue = $this->d_01->CurrentValue;
		$this->d_01->PlaceHolder = RemoveHtml($this->d_01->caption());
		if (strval($this->d_01->EditValue) <> "" && is_numeric($this->d_01->EditValue))
			$this->d_01->EditValue = FormatNumber($this->d_01->EditValue, -2, -1, -2, 0);

		// d_02
		$this->d_02->EditAttrs["class"] = "form-control";
		$this->d_02->EditCustomAttributes = "";
		$this->d_02->EditValue = $this->d_02->CurrentValue;
		$this->d_02->PlaceHolder = RemoveHtml($this->d_02->caption());
		if (strval($this->d_02->EditValue) <> "" && is_numeric($this->d_02->EditValue))
			$this->d_02->EditValue = FormatNumber($this->d_02->EditValue, -2, -1, -2, 0);

		// d_03
		$this->d_03->EditAttrs["class"] = "form-control";
		$this->d_03->EditCustomAttributes = "";
		$this->d_03->EditValue = $this->d_03->CurrentValue;
		$this->d_03->PlaceHolder = RemoveHtml($this->d_03->caption());
		if (strval($this->d_03->EditValue) <> "" && is_numeric($this->d_03->EditValue))
			$this->d_03->EditValue = FormatNumber($this->d_03->EditValue, -2, -1, -2, 0);

		// d_04
		$this->d_04->EditAttrs["class"] = "form-control";
		$this->d_04->EditCustomAttributes = "";
		$this->d_04->EditValue = $this->d_04->CurrentValue;
		$this->d_04->PlaceHolder = RemoveHtml($this->d_04->caption());
		if (strval($this->d_04->EditValue) <> "" && is_numeric($this->d_04->EditValue))
			$this->d_04->EditValue = FormatNumber($this->d_04->EditValue, -2, -1, -2, 0);

		// d_05
		$this->d_05->EditAttrs["class"] = "form-control";
		$this->d_05->EditCustomAttributes = "";
		$this->d_05->EditValue = $this->d_05->CurrentValue;
		$this->d_05->PlaceHolder = RemoveHtml($this->d_05->caption());
		if (strval($this->d_05->EditValue) <> "" && is_numeric($this->d_05->EditValue))
			$this->d_05->EditValue = FormatNumber($this->d_05->EditValue, -2, -1, -2, 0);

		// d_06
		$this->d_06->EditAttrs["class"] = "form-control";
		$this->d_06->EditCustomAttributes = "";
		$this->d_06->EditValue = $this->d_06->CurrentValue;
		$this->d_06->PlaceHolder = RemoveHtml($this->d_06->caption());
		if (strval($this->d_06->EditValue) <> "" && is_numeric($this->d_06->EditValue))
			$this->d_06->EditValue = FormatNumber($this->d_06->EditValue, -2, -1, -2, 0);

		// d_07
		$this->d_07->EditAttrs["class"] = "form-control";
		$this->d_07->EditCustomAttributes = "";
		$this->d_07->EditValue = $this->d_07->CurrentValue;
		$this->d_07->PlaceHolder = RemoveHtml($this->d_07->caption());
		if (strval($this->d_07->EditValue) <> "" && is_numeric($this->d_07->EditValue))
			$this->d_07->EditValue = FormatNumber($this->d_07->EditValue, -2, -1, -2, 0);

		// d_08
		$this->d_08->EditAttrs["class"] = "form-control";
		$this->d_08->EditCustomAttributes = "";
		$this->d_08->EditValue = $this->d_08->CurrentValue;
		$this->d_08->PlaceHolder = RemoveHtml($this->d_08->caption());
		if (strval($this->d_08->EditValue) <> "" && is_numeric($this->d_08->EditValue))
			$this->d_08->EditValue = FormatNumber($this->d_08->EditValue, -2, -1, -2, 0);

		// d_09
		$this->d_09->EditAttrs["class"] = "form-control";
		$this->d_09->EditCustomAttributes = "";
		$this->d_09->EditValue = $this->d_09->CurrentValue;
		$this->d_09->PlaceHolder = RemoveHtml($this->d_09->caption());
		if (strval($this->d_09->EditValue) <> "" && is_numeric($this->d_09->EditValue))
			$this->d_09->EditValue = FormatNumber($this->d_09->EditValue, -2, -1, -2, 0);

		// d_10
		$this->d_10->EditAttrs["class"] = "form-control";
		$this->d_10->EditCustomAttributes = "";
		$this->d_10->EditValue = $this->d_10->CurrentValue;
		$this->d_10->PlaceHolder = RemoveHtml($this->d_10->caption());
		if (strval($this->d_10->EditValue) <> "" && is_numeric($this->d_10->EditValue))
			$this->d_10->EditValue = FormatNumber($this->d_10->EditValue, -2, -1, -2, 0);

		// d_11
		$this->d_11->EditAttrs["class"] = "form-control";
		$this->d_11->EditCustomAttributes = "";
		$this->d_11->EditValue = $this->d_11->CurrentValue;
		$this->d_11->PlaceHolder = RemoveHtml($this->d_11->caption());
		if (strval($this->d_11->EditValue) <> "" && is_numeric($this->d_11->EditValue))
			$this->d_11->EditValue = FormatNumber($this->d_11->EditValue, -2, -1, -2, 0);

		// d_12
		$this->d_12->EditAttrs["class"] = "form-control";
		$this->d_12->EditCustomAttributes = "";
		$this->d_12->EditValue = $this->d_12->CurrentValue;
		$this->d_12->PlaceHolder = RemoveHtml($this->d_12->caption());
		if (strval($this->d_12->EditValue) <> "" && is_numeric($this->d_12->EditValue))
			$this->d_12->EditValue = FormatNumber($this->d_12->EditValue, -2, -1, -2, 0);

		// d_13
		$this->d_13->EditAttrs["class"] = "form-control";
		$this->d_13->EditCustomAttributes = "";
		$this->d_13->EditValue = $this->d_13->CurrentValue;
		$this->d_13->PlaceHolder = RemoveHtml($this->d_13->caption());
		if (strval($this->d_13->EditValue) <> "" && is_numeric($this->d_13->EditValue))
			$this->d_13->EditValue = FormatNumber($this->d_13->EditValue, -2, -1, -2, 0);

		// d_14
		$this->d_14->EditAttrs["class"] = "form-control";
		$this->d_14->EditCustomAttributes = "";
		$this->d_14->EditValue = $this->d_14->CurrentValue;
		$this->d_14->PlaceHolder = RemoveHtml($this->d_14->caption());
		if (strval($this->d_14->EditValue) <> "" && is_numeric($this->d_14->EditValue))
			$this->d_14->EditValue = FormatNumber($this->d_14->EditValue, -2, -1, -2, 0);

		// d_15
		$this->d_15->EditAttrs["class"] = "form-control";
		$this->d_15->EditCustomAttributes = "";
		$this->d_15->EditValue = $this->d_15->CurrentValue;
		$this->d_15->PlaceHolder = RemoveHtml($this->d_15->caption());
		if (strval($this->d_15->EditValue) <> "" && is_numeric($this->d_15->EditValue))
			$this->d_15->EditValue = FormatNumber($this->d_15->EditValue, -2, -1, -2, 0);

		// d_16
		$this->d_16->EditAttrs["class"] = "form-control";
		$this->d_16->EditCustomAttributes = "";
		$this->d_16->EditValue = $this->d_16->CurrentValue;
		$this->d_16->PlaceHolder = RemoveHtml($this->d_16->caption());
		if (strval($this->d_16->EditValue) <> "" && is_numeric($this->d_16->EditValue))
			$this->d_16->EditValue = FormatNumber($this->d_16->EditValue, -2, -1, -2, 0);

		// d_17
		$this->d_17->EditAttrs["class"] = "form-control";
		$this->d_17->EditCustomAttributes = "";
		$this->d_17->EditValue = $this->d_17->CurrentValue;
		$this->d_17->PlaceHolder = RemoveHtml($this->d_17->caption());
		if (strval($this->d_17->EditValue) <> "" && is_numeric($this->d_17->EditValue))
			$this->d_17->EditValue = FormatNumber($this->d_17->EditValue, -2, -1, -2, 0);

		// d_18
		$this->d_18->EditAttrs["class"] = "form-control";
		$this->d_18->EditCustomAttributes = "";
		$this->d_18->EditValue = $this->d_18->CurrentValue;
		$this->d_18->PlaceHolder = RemoveHtml($this->d_18->caption());
		if (strval($this->d_18->EditValue) <> "" && is_numeric($this->d_18->EditValue))
			$this->d_18->EditValue = FormatNumber($this->d_18->EditValue, -2, -1, -2, 0);

		// d_19
		$this->d_19->EditAttrs["class"] = "form-control";
		$this->d_19->EditCustomAttributes = "";
		$this->d_19->EditValue = $this->d_19->CurrentValue;
		$this->d_19->PlaceHolder = RemoveHtml($this->d_19->caption());
		if (strval($this->d_19->EditValue) <> "" && is_numeric($this->d_19->EditValue))
			$this->d_19->EditValue = FormatNumber($this->d_19->EditValue, -2, -1, -2, 0);

		// d_20
		$this->d_20->EditAttrs["class"] = "form-control";
		$this->d_20->EditCustomAttributes = "";
		$this->d_20->EditValue = $this->d_20->CurrentValue;
		$this->d_20->PlaceHolder = RemoveHtml($this->d_20->caption());
		if (strval($this->d_20->EditValue) <> "" && is_numeric($this->d_20->EditValue))
			$this->d_20->EditValue = FormatNumber($this->d_20->EditValue, -2, -1, -2, 0);

		// operator
		// datetime
		// Call Row Rendered event

		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->ref);
					$doc->exportCaption($this->lot_no);
					$doc->exportCaption($this->dated);
					$doc->exportCaption($this->d_01);
					$doc->exportCaption($this->d_02);
					$doc->exportCaption($this->d_03);
					$doc->exportCaption($this->d_04);
					$doc->exportCaption($this->d_05);
					$doc->exportCaption($this->d_06);
					$doc->exportCaption($this->d_07);
					$doc->exportCaption($this->d_08);
					$doc->exportCaption($this->d_09);
					$doc->exportCaption($this->d_10);
					$doc->exportCaption($this->d_11);
					$doc->exportCaption($this->d_12);
					$doc->exportCaption($this->d_13);
					$doc->exportCaption($this->d_14);
					$doc->exportCaption($this->d_15);
					$doc->exportCaption($this->d_16);
					$doc->exportCaption($this->d_17);
					$doc->exportCaption($this->d_18);
					$doc->exportCaption($this->d_19);
					$doc->exportCaption($this->d_20);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->ref);
					$doc->exportCaption($this->lot_no);
					$doc->exportCaption($this->dated);
					$doc->exportCaption($this->d_01);
					$doc->exportCaption($this->d_02);
					$doc->exportCaption($this->d_03);
					$doc->exportCaption($this->d_04);
					$doc->exportCaption($this->d_05);
					$doc->exportCaption($this->d_06);
					$doc->exportCaption($this->d_07);
					$doc->exportCaption($this->d_08);
					$doc->exportCaption($this->d_09);
					$doc->exportCaption($this->d_10);
					$doc->exportCaption($this->d_11);
					$doc->exportCaption($this->d_12);
					$doc->exportCaption($this->d_13);
					$doc->exportCaption($this->d_14);
					$doc->exportCaption($this->d_15);
					$doc->exportCaption($this->d_16);
					$doc->exportCaption($this->d_17);
					$doc->exportCaption($this->d_18);
					$doc->exportCaption($this->d_19);
					$doc->exportCaption($this->d_20);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->ref);
						$doc->exportField($this->lot_no);
						$doc->exportField($this->dated);
						$doc->exportField($this->d_01);
						$doc->exportField($this->d_02);
						$doc->exportField($this->d_03);
						$doc->exportField($this->d_04);
						$doc->exportField($this->d_05);
						$doc->exportField($this->d_06);
						$doc->exportField($this->d_07);
						$doc->exportField($this->d_08);
						$doc->exportField($this->d_09);
						$doc->exportField($this->d_10);
						$doc->exportField($this->d_11);
						$doc->exportField($this->d_12);
						$doc->exportField($this->d_13);
						$doc->exportField($this->d_14);
						$doc->exportField($this->d_15);
						$doc->exportField($this->d_16);
						$doc->exportField($this->d_17);
						$doc->exportField($this->d_18);
						$doc->exportField($this->d_19);
						$doc->exportField($this->d_20);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->ref);
						$doc->exportField($this->lot_no);
						$doc->exportField($this->dated);
						$doc->exportField($this->d_01);
						$doc->exportField($this->d_02);
						$doc->exportField($this->d_03);
						$doc->exportField($this->d_04);
						$doc->exportField($this->d_05);
						$doc->exportField($this->d_06);
						$doc->exportField($this->d_07);
						$doc->exportField($this->d_08);
						$doc->exportField($this->d_09);
						$doc->exportField($this->d_10);
						$doc->exportField($this->d_11);
						$doc->exportField($this->d_12);
						$doc->exportField($this->d_13);
						$doc->exportField($this->d_14);
						$doc->exportField($this->d_15);
						$doc->exportField($this->d_16);
						$doc->exportField($this->d_17);
						$doc->exportField($this->d_18);
						$doc->exportField($this->d_19);
						$doc->exportField($this->d_20);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>