<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class test_report_g_add extends test_report_g
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'test_report_g';

	// Page object name
	public $PageObjName = "test_report_g_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (test_report_g)
		if (!isset($GLOBALS["test_report_g"]) || get_class($GLOBALS["test_report_g"]) == PROJECT_NAMESPACE . "test_report_g") {
			$GLOBALS["test_report_g"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["test_report_g"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'test_report_g');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $test_report_g;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($test_report_g);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "test_report_gview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("test_report_glist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->product->setVisibility();
		$this->ref->setVisibility();
		$this->lot_no->setVisibility();
		$this->dated->setVisibility();
		$this->d_01->setVisibility();
		$this->d_02->setVisibility();
		$this->d_03->setVisibility();
		$this->d_04->setVisibility();
		$this->d_05->setVisibility();
		$this->d_06->setVisibility();
		$this->d_07->setVisibility();
		$this->d_08->setVisibility();
		$this->d_09->setVisibility();
		$this->d_10->setVisibility();
		$this->d_11->setVisibility();
		$this->d_12->setVisibility();
		$this->d_13->setVisibility();
		$this->d_14->setVisibility();
		$this->d_15->setVisibility();
		$this->d_16->setVisibility();
		$this->d_17->setVisibility();
		$this->d_18->setVisibility();
		$this->d_19->setVisibility();
		$this->d_20->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->operator);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("test_report_glist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "test_report_glist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "test_report_gview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->grp->CurrentValue = NULL;
		$this->grp->OldValue = $this->grp->CurrentValue;
		$this->s_grp->CurrentValue = NULL;
		$this->s_grp->OldValue = $this->s_grp->CurrentValue;
		$this->product->CurrentValue = NULL;
		$this->product->OldValue = $this->product->CurrentValue;
		$this->ref->CurrentValue = NULL;
		$this->ref->OldValue = $this->ref->CurrentValue;
		$this->lot_no->CurrentValue = NULL;
		$this->lot_no->OldValue = $this->lot_no->CurrentValue;
		$this->dated->CurrentValue = NULL;
		$this->dated->OldValue = $this->dated->CurrentValue;
		$this->d_01->CurrentValue = NULL;
		$this->d_01->OldValue = $this->d_01->CurrentValue;
		$this->d_02->CurrentValue = NULL;
		$this->d_02->OldValue = $this->d_02->CurrentValue;
		$this->d_03->CurrentValue = NULL;
		$this->d_03->OldValue = $this->d_03->CurrentValue;
		$this->d_04->CurrentValue = NULL;
		$this->d_04->OldValue = $this->d_04->CurrentValue;
		$this->d_05->CurrentValue = NULL;
		$this->d_05->OldValue = $this->d_05->CurrentValue;
		$this->d_06->CurrentValue = NULL;
		$this->d_06->OldValue = $this->d_06->CurrentValue;
		$this->d_07->CurrentValue = NULL;
		$this->d_07->OldValue = $this->d_07->CurrentValue;
		$this->d_08->CurrentValue = NULL;
		$this->d_08->OldValue = $this->d_08->CurrentValue;
		$this->d_09->CurrentValue = NULL;
		$this->d_09->OldValue = $this->d_09->CurrentValue;
		$this->d_10->CurrentValue = NULL;
		$this->d_10->OldValue = $this->d_10->CurrentValue;
		$this->d_11->CurrentValue = NULL;
		$this->d_11->OldValue = $this->d_11->CurrentValue;
		$this->d_12->CurrentValue = NULL;
		$this->d_12->OldValue = $this->d_12->CurrentValue;
		$this->d_13->CurrentValue = NULL;
		$this->d_13->OldValue = $this->d_13->CurrentValue;
		$this->d_14->CurrentValue = NULL;
		$this->d_14->OldValue = $this->d_14->CurrentValue;
		$this->d_15->CurrentValue = NULL;
		$this->d_15->OldValue = $this->d_15->CurrentValue;
		$this->d_16->CurrentValue = NULL;
		$this->d_16->OldValue = $this->d_16->CurrentValue;
		$this->d_17->CurrentValue = NULL;
		$this->d_17->OldValue = $this->d_17->CurrentValue;
		$this->d_18->CurrentValue = NULL;
		$this->d_18->OldValue = $this->d_18->CurrentValue;
		$this->d_19->CurrentValue = NULL;
		$this->d_19->OldValue = $this->d_19->CurrentValue;
		$this->d_20->CurrentValue = NULL;
		$this->d_20->OldValue = $this->d_20->CurrentValue;
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'grp' first before field var 'x_grp'
		$val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
		if (!$this->grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->grp->Visible = FALSE; // Disable update for API request
			else
				$this->grp->setFormValue($val);
		}

		// Check field name 's_grp' first before field var 'x_s_grp'
		$val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
		if (!$this->s_grp->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->s_grp->Visible = FALSE; // Disable update for API request
			else
				$this->s_grp->setFormValue($val);
		}

		// Check field name 'product' first before field var 'x_product'
		$val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
		if (!$this->product->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product->Visible = FALSE; // Disable update for API request
			else
				$this->product->setFormValue($val);
		}

		// Check field name 'ref' first before field var 'x_ref'
		$val = $CurrentForm->hasValue("ref") ? $CurrentForm->getValue("ref") : $CurrentForm->getValue("x_ref");
		if (!$this->ref->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ref->Visible = FALSE; // Disable update for API request
			else
				$this->ref->setFormValue($val);
		}

		// Check field name 'lot_no' first before field var 'x_lot_no'
		$val = $CurrentForm->hasValue("lot_no") ? $CurrentForm->getValue("lot_no") : $CurrentForm->getValue("x_lot_no");
		if (!$this->lot_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->lot_no->Visible = FALSE; // Disable update for API request
			else
				$this->lot_no->setFormValue($val);
		}

		// Check field name 'dated' first before field var 'x_dated'
		$val = $CurrentForm->hasValue("dated") ? $CurrentForm->getValue("dated") : $CurrentForm->getValue("x_dated");
		if (!$this->dated->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->dated->Visible = FALSE; // Disable update for API request
			else
				$this->dated->setFormValue($val);
			$this->dated->CurrentValue = UnFormatDateTime($this->dated->CurrentValue, 2);
		}

		// Check field name 'd_01' first before field var 'x_d_01'
		$val = $CurrentForm->hasValue("d_01") ? $CurrentForm->getValue("d_01") : $CurrentForm->getValue("x_d_01");
		if (!$this->d_01->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_01->Visible = FALSE; // Disable update for API request
			else
				$this->d_01->setFormValue($val);
		}

		// Check field name 'd_02' first before field var 'x_d_02'
		$val = $CurrentForm->hasValue("d_02") ? $CurrentForm->getValue("d_02") : $CurrentForm->getValue("x_d_02");
		if (!$this->d_02->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_02->Visible = FALSE; // Disable update for API request
			else
				$this->d_02->setFormValue($val);
		}

		// Check field name 'd_03' first before field var 'x_d_03'
		$val = $CurrentForm->hasValue("d_03") ? $CurrentForm->getValue("d_03") : $CurrentForm->getValue("x_d_03");
		if (!$this->d_03->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_03->Visible = FALSE; // Disable update for API request
			else
				$this->d_03->setFormValue($val);
		}

		// Check field name 'd_04' first before field var 'x_d_04'
		$val = $CurrentForm->hasValue("d_04") ? $CurrentForm->getValue("d_04") : $CurrentForm->getValue("x_d_04");
		if (!$this->d_04->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_04->Visible = FALSE; // Disable update for API request
			else
				$this->d_04->setFormValue($val);
		}

		// Check field name 'd_05' first before field var 'x_d_05'
		$val = $CurrentForm->hasValue("d_05") ? $CurrentForm->getValue("d_05") : $CurrentForm->getValue("x_d_05");
		if (!$this->d_05->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_05->Visible = FALSE; // Disable update for API request
			else
				$this->d_05->setFormValue($val);
		}

		// Check field name 'd_06' first before field var 'x_d_06'
		$val = $CurrentForm->hasValue("d_06") ? $CurrentForm->getValue("d_06") : $CurrentForm->getValue("x_d_06");
		if (!$this->d_06->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_06->Visible = FALSE; // Disable update for API request
			else
				$this->d_06->setFormValue($val);
		}

		// Check field name 'd_07' first before field var 'x_d_07'
		$val = $CurrentForm->hasValue("d_07") ? $CurrentForm->getValue("d_07") : $CurrentForm->getValue("x_d_07");
		if (!$this->d_07->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_07->Visible = FALSE; // Disable update for API request
			else
				$this->d_07->setFormValue($val);
		}

		// Check field name 'd_08' first before field var 'x_d_08'
		$val = $CurrentForm->hasValue("d_08") ? $CurrentForm->getValue("d_08") : $CurrentForm->getValue("x_d_08");
		if (!$this->d_08->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_08->Visible = FALSE; // Disable update for API request
			else
				$this->d_08->setFormValue($val);
		}

		// Check field name 'd_09' first before field var 'x_d_09'
		$val = $CurrentForm->hasValue("d_09") ? $CurrentForm->getValue("d_09") : $CurrentForm->getValue("x_d_09");
		if (!$this->d_09->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_09->Visible = FALSE; // Disable update for API request
			else
				$this->d_09->setFormValue($val);
		}

		// Check field name 'd_10' first before field var 'x_d_10'
		$val = $CurrentForm->hasValue("d_10") ? $CurrentForm->getValue("d_10") : $CurrentForm->getValue("x_d_10");
		if (!$this->d_10->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_10->Visible = FALSE; // Disable update for API request
			else
				$this->d_10->setFormValue($val);
		}

		// Check field name 'd_11' first before field var 'x_d_11'
		$val = $CurrentForm->hasValue("d_11") ? $CurrentForm->getValue("d_11") : $CurrentForm->getValue("x_d_11");
		if (!$this->d_11->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_11->Visible = FALSE; // Disable update for API request
			else
				$this->d_11->setFormValue($val);
		}

		// Check field name 'd_12' first before field var 'x_d_12'
		$val = $CurrentForm->hasValue("d_12") ? $CurrentForm->getValue("d_12") : $CurrentForm->getValue("x_d_12");
		if (!$this->d_12->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_12->Visible = FALSE; // Disable update for API request
			else
				$this->d_12->setFormValue($val);
		}

		// Check field name 'd_13' first before field var 'x_d_13'
		$val = $CurrentForm->hasValue("d_13") ? $CurrentForm->getValue("d_13") : $CurrentForm->getValue("x_d_13");
		if (!$this->d_13->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_13->Visible = FALSE; // Disable update for API request
			else
				$this->d_13->setFormValue($val);
		}

		// Check field name 'd_14' first before field var 'x_d_14'
		$val = $CurrentForm->hasValue("d_14") ? $CurrentForm->getValue("d_14") : $CurrentForm->getValue("x_d_14");
		if (!$this->d_14->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_14->Visible = FALSE; // Disable update for API request
			else
				$this->d_14->setFormValue($val);
		}

		// Check field name 'd_15' first before field var 'x_d_15'
		$val = $CurrentForm->hasValue("d_15") ? $CurrentForm->getValue("d_15") : $CurrentForm->getValue("x_d_15");
		if (!$this->d_15->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_15->Visible = FALSE; // Disable update for API request
			else
				$this->d_15->setFormValue($val);
		}

		// Check field name 'd_16' first before field var 'x_d_16'
		$val = $CurrentForm->hasValue("d_16") ? $CurrentForm->getValue("d_16") : $CurrentForm->getValue("x_d_16");
		if (!$this->d_16->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_16->Visible = FALSE; // Disable update for API request
			else
				$this->d_16->setFormValue($val);
		}

		// Check field name 'd_17' first before field var 'x_d_17'
		$val = $CurrentForm->hasValue("d_17") ? $CurrentForm->getValue("d_17") : $CurrentForm->getValue("x_d_17");
		if (!$this->d_17->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_17->Visible = FALSE; // Disable update for API request
			else
				$this->d_17->setFormValue($val);
		}

		// Check field name 'd_18' first before field var 'x_d_18'
		$val = $CurrentForm->hasValue("d_18") ? $CurrentForm->getValue("d_18") : $CurrentForm->getValue("x_d_18");
		if (!$this->d_18->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_18->Visible = FALSE; // Disable update for API request
			else
				$this->d_18->setFormValue($val);
		}

		// Check field name 'd_19' first before field var 'x_d_19'
		$val = $CurrentForm->hasValue("d_19") ? $CurrentForm->getValue("d_19") : $CurrentForm->getValue("x_d_19");
		if (!$this->d_19->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_19->Visible = FALSE; // Disable update for API request
			else
				$this->d_19->setFormValue($val);
		}

		// Check field name 'd_20' first before field var 'x_d_20'
		$val = $CurrentForm->hasValue("d_20") ? $CurrentForm->getValue("d_20") : $CurrentForm->getValue("x_d_20");
		if (!$this->d_20->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_20->Visible = FALSE; // Disable update for API request
			else
				$this->d_20->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->grp->CurrentValue = $this->grp->FormValue;
		$this->s_grp->CurrentValue = $this->s_grp->FormValue;
		$this->product->CurrentValue = $this->product->FormValue;
		$this->ref->CurrentValue = $this->ref->FormValue;
		$this->lot_no->CurrentValue = $this->lot_no->FormValue;
		$this->dated->CurrentValue = $this->dated->FormValue;
		$this->dated->CurrentValue = UnFormatDateTime($this->dated->CurrentValue, 2);
		$this->d_01->CurrentValue = $this->d_01->FormValue;
		$this->d_02->CurrentValue = $this->d_02->FormValue;
		$this->d_03->CurrentValue = $this->d_03->FormValue;
		$this->d_04->CurrentValue = $this->d_04->FormValue;
		$this->d_05->CurrentValue = $this->d_05->FormValue;
		$this->d_06->CurrentValue = $this->d_06->FormValue;
		$this->d_07->CurrentValue = $this->d_07->FormValue;
		$this->d_08->CurrentValue = $this->d_08->FormValue;
		$this->d_09->CurrentValue = $this->d_09->FormValue;
		$this->d_10->CurrentValue = $this->d_10->FormValue;
		$this->d_11->CurrentValue = $this->d_11->FormValue;
		$this->d_12->CurrentValue = $this->d_12->FormValue;
		$this->d_13->CurrentValue = $this->d_13->FormValue;
		$this->d_14->CurrentValue = $this->d_14->FormValue;
		$this->d_15->CurrentValue = $this->d_15->FormValue;
		$this->d_16->CurrentValue = $this->d_16->FormValue;
		$this->d_17->CurrentValue = $this->d_17->FormValue;
		$this->d_18->CurrentValue = $this->d_18->FormValue;
		$this->d_19->CurrentValue = $this->d_19->FormValue;
		$this->d_20->CurrentValue = $this->d_20->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->product->setDbValue($row['product']);
		$this->ref->setDbValue($row['ref']);
		$this->lot_no->setDbValue($row['lot_no']);
		$this->dated->setDbValue($row['dated']);
		$this->d_01->setDbValue($row['d_01']);
		$this->d_02->setDbValue($row['d_02']);
		$this->d_03->setDbValue($row['d_03']);
		$this->d_04->setDbValue($row['d_04']);
		$this->d_05->setDbValue($row['d_05']);
		$this->d_06->setDbValue($row['d_06']);
		$this->d_07->setDbValue($row['d_07']);
		$this->d_08->setDbValue($row['d_08']);
		$this->d_09->setDbValue($row['d_09']);
		$this->d_10->setDbValue($row['d_10']);
		$this->d_11->setDbValue($row['d_11']);
		$this->d_12->setDbValue($row['d_12']);
		$this->d_13->setDbValue($row['d_13']);
		$this->d_14->setDbValue($row['d_14']);
		$this->d_15->setDbValue($row['d_15']);
		$this->d_16->setDbValue($row['d_16']);
		$this->d_17->setDbValue($row['d_17']);
		$this->d_18->setDbValue($row['d_18']);
		$this->d_19->setDbValue($row['d_19']);
		$this->d_20->setDbValue($row['d_20']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['grp'] = $this->grp->CurrentValue;
		$row['s_grp'] = $this->s_grp->CurrentValue;
		$row['product'] = $this->product->CurrentValue;
		$row['ref'] = $this->ref->CurrentValue;
		$row['lot_no'] = $this->lot_no->CurrentValue;
		$row['dated'] = $this->dated->CurrentValue;
		$row['d_01'] = $this->d_01->CurrentValue;
		$row['d_02'] = $this->d_02->CurrentValue;
		$row['d_03'] = $this->d_03->CurrentValue;
		$row['d_04'] = $this->d_04->CurrentValue;
		$row['d_05'] = $this->d_05->CurrentValue;
		$row['d_06'] = $this->d_06->CurrentValue;
		$row['d_07'] = $this->d_07->CurrentValue;
		$row['d_08'] = $this->d_08->CurrentValue;
		$row['d_09'] = $this->d_09->CurrentValue;
		$row['d_10'] = $this->d_10->CurrentValue;
		$row['d_11'] = $this->d_11->CurrentValue;
		$row['d_12'] = $this->d_12->CurrentValue;
		$row['d_13'] = $this->d_13->CurrentValue;
		$row['d_14'] = $this->d_14->CurrentValue;
		$row['d_15'] = $this->d_15->CurrentValue;
		$row['d_16'] = $this->d_16->CurrentValue;
		$row['d_17'] = $this->d_17->CurrentValue;
		$row['d_18'] = $this->d_18->CurrentValue;
		$row['d_19'] = $this->d_19->CurrentValue;
		$row['d_20'] = $this->d_20->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->d_01->FormValue == $this->d_01->CurrentValue && is_numeric(ConvertToFloatString($this->d_01->CurrentValue)))
			$this->d_01->CurrentValue = ConvertToFloatString($this->d_01->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_02->FormValue == $this->d_02->CurrentValue && is_numeric(ConvertToFloatString($this->d_02->CurrentValue)))
			$this->d_02->CurrentValue = ConvertToFloatString($this->d_02->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_03->FormValue == $this->d_03->CurrentValue && is_numeric(ConvertToFloatString($this->d_03->CurrentValue)))
			$this->d_03->CurrentValue = ConvertToFloatString($this->d_03->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_04->FormValue == $this->d_04->CurrentValue && is_numeric(ConvertToFloatString($this->d_04->CurrentValue)))
			$this->d_04->CurrentValue = ConvertToFloatString($this->d_04->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_05->FormValue == $this->d_05->CurrentValue && is_numeric(ConvertToFloatString($this->d_05->CurrentValue)))
			$this->d_05->CurrentValue = ConvertToFloatString($this->d_05->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_06->FormValue == $this->d_06->CurrentValue && is_numeric(ConvertToFloatString($this->d_06->CurrentValue)))
			$this->d_06->CurrentValue = ConvertToFloatString($this->d_06->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_07->FormValue == $this->d_07->CurrentValue && is_numeric(ConvertToFloatString($this->d_07->CurrentValue)))
			$this->d_07->CurrentValue = ConvertToFloatString($this->d_07->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_08->FormValue == $this->d_08->CurrentValue && is_numeric(ConvertToFloatString($this->d_08->CurrentValue)))
			$this->d_08->CurrentValue = ConvertToFloatString($this->d_08->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_09->FormValue == $this->d_09->CurrentValue && is_numeric(ConvertToFloatString($this->d_09->CurrentValue)))
			$this->d_09->CurrentValue = ConvertToFloatString($this->d_09->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_10->FormValue == $this->d_10->CurrentValue && is_numeric(ConvertToFloatString($this->d_10->CurrentValue)))
			$this->d_10->CurrentValue = ConvertToFloatString($this->d_10->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_11->FormValue == $this->d_11->CurrentValue && is_numeric(ConvertToFloatString($this->d_11->CurrentValue)))
			$this->d_11->CurrentValue = ConvertToFloatString($this->d_11->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_12->FormValue == $this->d_12->CurrentValue && is_numeric(ConvertToFloatString($this->d_12->CurrentValue)))
			$this->d_12->CurrentValue = ConvertToFloatString($this->d_12->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_13->FormValue == $this->d_13->CurrentValue && is_numeric(ConvertToFloatString($this->d_13->CurrentValue)))
			$this->d_13->CurrentValue = ConvertToFloatString($this->d_13->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_14->FormValue == $this->d_14->CurrentValue && is_numeric(ConvertToFloatString($this->d_14->CurrentValue)))
			$this->d_14->CurrentValue = ConvertToFloatString($this->d_14->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_15->FormValue == $this->d_15->CurrentValue && is_numeric(ConvertToFloatString($this->d_15->CurrentValue)))
			$this->d_15->CurrentValue = ConvertToFloatString($this->d_15->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_16->FormValue == $this->d_16->CurrentValue && is_numeric(ConvertToFloatString($this->d_16->CurrentValue)))
			$this->d_16->CurrentValue = ConvertToFloatString($this->d_16->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_17->FormValue == $this->d_17->CurrentValue && is_numeric(ConvertToFloatString($this->d_17->CurrentValue)))
			$this->d_17->CurrentValue = ConvertToFloatString($this->d_17->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_18->FormValue == $this->d_18->CurrentValue && is_numeric(ConvertToFloatString($this->d_18->CurrentValue)))
			$this->d_18->CurrentValue = ConvertToFloatString($this->d_18->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_19->FormValue == $this->d_19->CurrentValue && is_numeric(ConvertToFloatString($this->d_19->CurrentValue)))
			$this->d_19->CurrentValue = ConvertToFloatString($this->d_19->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_20->FormValue == $this->d_20->CurrentValue && is_numeric(ConvertToFloatString($this->d_20->CurrentValue)))
			$this->d_20->CurrentValue = ConvertToFloatString($this->d_20->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// grp
		// s_grp
		// product
		// ref
		// lot_no
		// dated
		// d_01
		// d_02
		// d_03
		// d_04
		// d_05
		// d_06
		// d_07
		// d_08
		// d_09
		// d_10
		// d_11
		// d_12
		// d_13
		// d_14
		// d_15
		// d_16
		// d_17
		// d_18
		// d_19
		// d_20
		// operator
		// datetime

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
			$this->id->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id`>100";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id`>100";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			$this->product->CssClass = "font-italic";
			$this->product->ViewCustomAttributes = "";

			// ref
			$this->ref->ViewValue = $this->ref->CurrentValue;
			$this->ref->ViewValue = FormatNumber($this->ref->ViewValue, 0, -2, -2, -2);
			$this->ref->ViewCustomAttributes = "";

			// lot_no
			$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
			$this->lot_no->ViewCustomAttributes = "";

			// dated
			$this->dated->ViewValue = $this->dated->CurrentValue;
			$this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, 2);
			$this->dated->ViewCustomAttributes = "";

			// d_01
			$this->d_01->ViewValue = $this->d_01->CurrentValue;
			$this->d_01->ViewCustomAttributes = "";

			// d_02
			$this->d_02->ViewValue = $this->d_02->CurrentValue;
			$this->d_02->ViewCustomAttributes = "";

			// d_03
			$this->d_03->ViewValue = $this->d_03->CurrentValue;
			$this->d_03->ViewCustomAttributes = "";

			// d_04
			$this->d_04->ViewValue = $this->d_04->CurrentValue;
			$this->d_04->ViewCustomAttributes = "";

			// d_05
			$this->d_05->ViewValue = $this->d_05->CurrentValue;
			$this->d_05->ViewCustomAttributes = "";

			// d_06
			$this->d_06->ViewValue = $this->d_06->CurrentValue;
			$this->d_06->ViewCustomAttributes = "";

			// d_07
			$this->d_07->ViewValue = $this->d_07->CurrentValue;
			$this->d_07->ViewCustomAttributes = "";

			// d_08
			$this->d_08->ViewValue = $this->d_08->CurrentValue;
			$this->d_08->ViewCustomAttributes = "";

			// d_09
			$this->d_09->ViewValue = $this->d_09->CurrentValue;
			$this->d_09->ViewCustomAttributes = "";

			// d_10
			$this->d_10->ViewValue = $this->d_10->CurrentValue;
			$this->d_10->ViewCustomAttributes = "";

			// d_11
			$this->d_11->ViewValue = $this->d_11->CurrentValue;
			$this->d_11->ViewCustomAttributes = "";

			// d_12
			$this->d_12->ViewValue = $this->d_12->CurrentValue;
			$this->d_12->ViewCustomAttributes = "";

			// d_13
			$this->d_13->ViewValue = $this->d_13->CurrentValue;
			$this->d_13->ViewCustomAttributes = "";

			// d_14
			$this->d_14->ViewValue = $this->d_14->CurrentValue;
			$this->d_14->ViewCustomAttributes = "";

			// d_15
			$this->d_15->ViewValue = $this->d_15->CurrentValue;
			$this->d_15->ViewCustomAttributes = "";

			// d_16
			$this->d_16->ViewValue = $this->d_16->CurrentValue;
			$this->d_16->ViewCustomAttributes = "";

			// d_17
			$this->d_17->ViewValue = $this->d_17->CurrentValue;
			$this->d_17->ViewCustomAttributes = "";

			// d_18
			$this->d_18->ViewValue = $this->d_18->CurrentValue;
			$this->d_18->ViewCustomAttributes = "";

			// d_19
			$this->d_19->ViewValue = $this->d_19->CurrentValue;
			$this->d_19->ViewCustomAttributes = "";

			// d_20
			$this->d_20->ViewValue = $this->d_20->CurrentValue;
			$this->d_20->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			$this->s_grp->HrefValue = "";
			$this->s_grp->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			$this->product->HrefValue = "";
			$this->product->TooltipValue = "";

			// ref
			$this->ref->LinkCustomAttributes = "";
			$this->ref->HrefValue = "";
			$this->ref->TooltipValue = "";

			// lot_no
			$this->lot_no->LinkCustomAttributes = "";
			$this->lot_no->HrefValue = "";
			$this->lot_no->TooltipValue = "";

			// dated
			$this->dated->LinkCustomAttributes = "";
			$this->dated->HrefValue = "";
			$this->dated->TooltipValue = "";

			// d_01
			$this->d_01->LinkCustomAttributes = "";
			$this->d_01->HrefValue = "";
			$this->d_01->TooltipValue = "";

			// d_02
			$this->d_02->LinkCustomAttributes = "";
			$this->d_02->HrefValue = "";
			$this->d_02->TooltipValue = "";

			// d_03
			$this->d_03->LinkCustomAttributes = "";
			$this->d_03->HrefValue = "";
			$this->d_03->TooltipValue = "";

			// d_04
			$this->d_04->LinkCustomAttributes = "";
			$this->d_04->HrefValue = "";
			$this->d_04->TooltipValue = "";

			// d_05
			$this->d_05->LinkCustomAttributes = "";
			$this->d_05->HrefValue = "";
			$this->d_05->TooltipValue = "";

			// d_06
			$this->d_06->LinkCustomAttributes = "";
			$this->d_06->HrefValue = "";
			$this->d_06->TooltipValue = "";

			// d_07
			$this->d_07->LinkCustomAttributes = "";
			$this->d_07->HrefValue = "";
			$this->d_07->TooltipValue = "";

			// d_08
			$this->d_08->LinkCustomAttributes = "";
			$this->d_08->HrefValue = "";
			$this->d_08->TooltipValue = "";

			// d_09
			$this->d_09->LinkCustomAttributes = "";
			$this->d_09->HrefValue = "";
			$this->d_09->TooltipValue = "";

			// d_10
			$this->d_10->LinkCustomAttributes = "";
			$this->d_10->HrefValue = "";
			$this->d_10->TooltipValue = "";

			// d_11
			$this->d_11->LinkCustomAttributes = "";
			$this->d_11->HrefValue = "";
			$this->d_11->TooltipValue = "";

			// d_12
			$this->d_12->LinkCustomAttributes = "";
			$this->d_12->HrefValue = "";
			$this->d_12->TooltipValue = "";

			// d_13
			$this->d_13->LinkCustomAttributes = "";
			$this->d_13->HrefValue = "";
			$this->d_13->TooltipValue = "";

			// d_14
			$this->d_14->LinkCustomAttributes = "";
			$this->d_14->HrefValue = "";
			$this->d_14->TooltipValue = "";

			// d_15
			$this->d_15->LinkCustomAttributes = "";
			$this->d_15->HrefValue = "";
			$this->d_15->TooltipValue = "";

			// d_16
			$this->d_16->LinkCustomAttributes = "";
			$this->d_16->HrefValue = "";
			$this->d_16->TooltipValue = "";

			// d_17
			$this->d_17->LinkCustomAttributes = "";
			$this->d_17->HrefValue = "";
			$this->d_17->TooltipValue = "";

			// d_18
			$this->d_18->LinkCustomAttributes = "";
			$this->d_18->HrefValue = "";
			$this->d_18->TooltipValue = "";

			// d_19
			$this->d_19->LinkCustomAttributes = "";
			$this->d_19->HrefValue = "";
			$this->d_19->TooltipValue = "";

			// d_20
			$this->d_20->LinkCustomAttributes = "";
			$this->d_20->HrefValue = "";
			$this->d_20->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->grp->CurrentValue));
			if ($curVal <> "")
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
			else
				$this->grp->ViewValue = $this->grp->Lookup !== NULL && is_array($this->grp->Lookup->Options) ? $curVal : NULL;
			if ($this->grp->ViewValue !== NULL) { // Load from cache
				$this->grp->EditValue = array_values($this->grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->grp->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`id`>100";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->grp->EditValue = $arwrk;
			}

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->s_grp->CurrentValue));
			if ($curVal <> "")
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			else
				$this->s_grp->ViewValue = $this->s_grp->Lookup !== NULL && is_array($this->s_grp->Lookup->Options) ? $curVal : NULL;
			if ($this->s_grp->ViewValue !== NULL) { // Load from cache
				$this->s_grp->EditValue = array_values($this->s_grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->s_grp->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`id`>100";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->s_grp->EditValue = $arwrk;
			}

			// product
			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";
			$curVal = trim(strval($this->product->CurrentValue));
			if ($curVal <> "")
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
			else
				$this->product->ViewValue = $this->product->Lookup !== NULL && is_array($this->product->Lookup->Options) ? $curVal : NULL;
			if ($this->product->ViewValue !== NULL) { // Load from cache
				$this->product->EditValue = array_values($this->product->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->product->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->product->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product->EditValue = $arwrk;
			}

			// ref
			$this->ref->EditAttrs["class"] = "form-control";
			$this->ref->EditCustomAttributes = "";
			$this->ref->EditValue = HtmlEncode($this->ref->CurrentValue);
			$this->ref->PlaceHolder = RemoveHtml($this->ref->caption());

			// lot_no
			$this->lot_no->EditAttrs["class"] = "form-control";
			$this->lot_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->lot_no->CurrentValue = HtmlDecode($this->lot_no->CurrentValue);
			$this->lot_no->EditValue = HtmlEncode($this->lot_no->CurrentValue);
			$this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

			// dated
			$this->dated->EditAttrs["class"] = "form-control";
			$this->dated->EditCustomAttributes = "";
			$this->dated->EditValue = HtmlEncode(FormatDateTime($this->dated->CurrentValue, 2));
			$this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

			// d_01
			$this->d_01->EditAttrs["class"] = "form-control";
			$this->d_01->EditCustomAttributes = "";
			$this->d_01->EditValue = HtmlEncode($this->d_01->CurrentValue);
			$this->d_01->PlaceHolder = RemoveHtml($this->d_01->caption());
			if (strval($this->d_01->EditValue) <> "" && is_numeric($this->d_01->EditValue))
				$this->d_01->EditValue = FormatNumber($this->d_01->EditValue, -2, -1, -2, 0);

			// d_02
			$this->d_02->EditAttrs["class"] = "form-control";
			$this->d_02->EditCustomAttributes = "";
			$this->d_02->EditValue = HtmlEncode($this->d_02->CurrentValue);
			$this->d_02->PlaceHolder = RemoveHtml($this->d_02->caption());
			if (strval($this->d_02->EditValue) <> "" && is_numeric($this->d_02->EditValue))
				$this->d_02->EditValue = FormatNumber($this->d_02->EditValue, -2, -1, -2, 0);

			// d_03
			$this->d_03->EditAttrs["class"] = "form-control";
			$this->d_03->EditCustomAttributes = "";
			$this->d_03->EditValue = HtmlEncode($this->d_03->CurrentValue);
			$this->d_03->PlaceHolder = RemoveHtml($this->d_03->caption());
			if (strval($this->d_03->EditValue) <> "" && is_numeric($this->d_03->EditValue))
				$this->d_03->EditValue = FormatNumber($this->d_03->EditValue, -2, -1, -2, 0);

			// d_04
			$this->d_04->EditAttrs["class"] = "form-control";
			$this->d_04->EditCustomAttributes = "";
			$this->d_04->EditValue = HtmlEncode($this->d_04->CurrentValue);
			$this->d_04->PlaceHolder = RemoveHtml($this->d_04->caption());
			if (strval($this->d_04->EditValue) <> "" && is_numeric($this->d_04->EditValue))
				$this->d_04->EditValue = FormatNumber($this->d_04->EditValue, -2, -1, -2, 0);

			// d_05
			$this->d_05->EditAttrs["class"] = "form-control";
			$this->d_05->EditCustomAttributes = "";
			$this->d_05->EditValue = HtmlEncode($this->d_05->CurrentValue);
			$this->d_05->PlaceHolder = RemoveHtml($this->d_05->caption());
			if (strval($this->d_05->EditValue) <> "" && is_numeric($this->d_05->EditValue))
				$this->d_05->EditValue = FormatNumber($this->d_05->EditValue, -2, -1, -2, 0);

			// d_06
			$this->d_06->EditAttrs["class"] = "form-control";
			$this->d_06->EditCustomAttributes = "";
			$this->d_06->EditValue = HtmlEncode($this->d_06->CurrentValue);
			$this->d_06->PlaceHolder = RemoveHtml($this->d_06->caption());
			if (strval($this->d_06->EditValue) <> "" && is_numeric($this->d_06->EditValue))
				$this->d_06->EditValue = FormatNumber($this->d_06->EditValue, -2, -1, -2, 0);

			// d_07
			$this->d_07->EditAttrs["class"] = "form-control";
			$this->d_07->EditCustomAttributes = "";
			$this->d_07->EditValue = HtmlEncode($this->d_07->CurrentValue);
			$this->d_07->PlaceHolder = RemoveHtml($this->d_07->caption());
			if (strval($this->d_07->EditValue) <> "" && is_numeric($this->d_07->EditValue))
				$this->d_07->EditValue = FormatNumber($this->d_07->EditValue, -2, -1, -2, 0);

			// d_08
			$this->d_08->EditAttrs["class"] = "form-control";
			$this->d_08->EditCustomAttributes = "";
			$this->d_08->EditValue = HtmlEncode($this->d_08->CurrentValue);
			$this->d_08->PlaceHolder = RemoveHtml($this->d_08->caption());
			if (strval($this->d_08->EditValue) <> "" && is_numeric($this->d_08->EditValue))
				$this->d_08->EditValue = FormatNumber($this->d_08->EditValue, -2, -1, -2, 0);

			// d_09
			$this->d_09->EditAttrs["class"] = "form-control";
			$this->d_09->EditCustomAttributes = "";
			$this->d_09->EditValue = HtmlEncode($this->d_09->CurrentValue);
			$this->d_09->PlaceHolder = RemoveHtml($this->d_09->caption());
			if (strval($this->d_09->EditValue) <> "" && is_numeric($this->d_09->EditValue))
				$this->d_09->EditValue = FormatNumber($this->d_09->EditValue, -2, -1, -2, 0);

			// d_10
			$this->d_10->EditAttrs["class"] = "form-control";
			$this->d_10->EditCustomAttributes = "";
			$this->d_10->EditValue = HtmlEncode($this->d_10->CurrentValue);
			$this->d_10->PlaceHolder = RemoveHtml($this->d_10->caption());
			if (strval($this->d_10->EditValue) <> "" && is_numeric($this->d_10->EditValue))
				$this->d_10->EditValue = FormatNumber($this->d_10->EditValue, -2, -1, -2, 0);

			// d_11
			$this->d_11->EditAttrs["class"] = "form-control";
			$this->d_11->EditCustomAttributes = "";
			$this->d_11->EditValue = HtmlEncode($this->d_11->CurrentValue);
			$this->d_11->PlaceHolder = RemoveHtml($this->d_11->caption());
			if (strval($this->d_11->EditValue) <> "" && is_numeric($this->d_11->EditValue))
				$this->d_11->EditValue = FormatNumber($this->d_11->EditValue, -2, -1, -2, 0);

			// d_12
			$this->d_12->EditAttrs["class"] = "form-control";
			$this->d_12->EditCustomAttributes = "";
			$this->d_12->EditValue = HtmlEncode($this->d_12->CurrentValue);
			$this->d_12->PlaceHolder = RemoveHtml($this->d_12->caption());
			if (strval($this->d_12->EditValue) <> "" && is_numeric($this->d_12->EditValue))
				$this->d_12->EditValue = FormatNumber($this->d_12->EditValue, -2, -1, -2, 0);

			// d_13
			$this->d_13->EditAttrs["class"] = "form-control";
			$this->d_13->EditCustomAttributes = "";
			$this->d_13->EditValue = HtmlEncode($this->d_13->CurrentValue);
			$this->d_13->PlaceHolder = RemoveHtml($this->d_13->caption());
			if (strval($this->d_13->EditValue) <> "" && is_numeric($this->d_13->EditValue))
				$this->d_13->EditValue = FormatNumber($this->d_13->EditValue, -2, -1, -2, 0);

			// d_14
			$this->d_14->EditAttrs["class"] = "form-control";
			$this->d_14->EditCustomAttributes = "";
			$this->d_14->EditValue = HtmlEncode($this->d_14->CurrentValue);
			$this->d_14->PlaceHolder = RemoveHtml($this->d_14->caption());
			if (strval($this->d_14->EditValue) <> "" && is_numeric($this->d_14->EditValue))
				$this->d_14->EditValue = FormatNumber($this->d_14->EditValue, -2, -1, -2, 0);

			// d_15
			$this->d_15->EditAttrs["class"] = "form-control";
			$this->d_15->EditCustomAttributes = "";
			$this->d_15->EditValue = HtmlEncode($this->d_15->CurrentValue);
			$this->d_15->PlaceHolder = RemoveHtml($this->d_15->caption());
			if (strval($this->d_15->EditValue) <> "" && is_numeric($this->d_15->EditValue))
				$this->d_15->EditValue = FormatNumber($this->d_15->EditValue, -2, -1, -2, 0);

			// d_16
			$this->d_16->EditAttrs["class"] = "form-control";
			$this->d_16->EditCustomAttributes = "";
			$this->d_16->EditValue = HtmlEncode($this->d_16->CurrentValue);
			$this->d_16->PlaceHolder = RemoveHtml($this->d_16->caption());
			if (strval($this->d_16->EditValue) <> "" && is_numeric($this->d_16->EditValue))
				$this->d_16->EditValue = FormatNumber($this->d_16->EditValue, -2, -1, -2, 0);

			// d_17
			$this->d_17->EditAttrs["class"] = "form-control";
			$this->d_17->EditCustomAttributes = "";
			$this->d_17->EditValue = HtmlEncode($this->d_17->CurrentValue);
			$this->d_17->PlaceHolder = RemoveHtml($this->d_17->caption());
			if (strval($this->d_17->EditValue) <> "" && is_numeric($this->d_17->EditValue))
				$this->d_17->EditValue = FormatNumber($this->d_17->EditValue, -2, -1, -2, 0);

			// d_18
			$this->d_18->EditAttrs["class"] = "form-control";
			$this->d_18->EditCustomAttributes = "";
			$this->d_18->EditValue = HtmlEncode($this->d_18->CurrentValue);
			$this->d_18->PlaceHolder = RemoveHtml($this->d_18->caption());
			if (strval($this->d_18->EditValue) <> "" && is_numeric($this->d_18->EditValue))
				$this->d_18->EditValue = FormatNumber($this->d_18->EditValue, -2, -1, -2, 0);

			// d_19
			$this->d_19->EditAttrs["class"] = "form-control";
			$this->d_19->EditCustomAttributes = "";
			$this->d_19->EditValue = HtmlEncode($this->d_19->CurrentValue);
			$this->d_19->PlaceHolder = RemoveHtml($this->d_19->caption());
			if (strval($this->d_19->EditValue) <> "" && is_numeric($this->d_19->EditValue))
				$this->d_19->EditValue = FormatNumber($this->d_19->EditValue, -2, -1, -2, 0);

			// d_20
			$this->d_20->EditAttrs["class"] = "form-control";
			$this->d_20->EditCustomAttributes = "";
			$this->d_20->EditValue = HtmlEncode($this->d_20->CurrentValue);
			$this->d_20->PlaceHolder = RemoveHtml($this->d_20->caption());
			if (strval($this->d_20->EditValue) <> "" && is_numeric($this->d_20->EditValue))
				$this->d_20->EditValue = FormatNumber($this->d_20->EditValue, -2, -1, -2, 0);

			// operator
			// datetime
			// Add refer script
			// grp

			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			$this->s_grp->HrefValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			$this->product->HrefValue = "";

			// ref
			$this->ref->LinkCustomAttributes = "";
			$this->ref->HrefValue = "";

			// lot_no
			$this->lot_no->LinkCustomAttributes = "";
			$this->lot_no->HrefValue = "";

			// dated
			$this->dated->LinkCustomAttributes = "";
			$this->dated->HrefValue = "";

			// d_01
			$this->d_01->LinkCustomAttributes = "";
			$this->d_01->HrefValue = "";

			// d_02
			$this->d_02->LinkCustomAttributes = "";
			$this->d_02->HrefValue = "";

			// d_03
			$this->d_03->LinkCustomAttributes = "";
			$this->d_03->HrefValue = "";

			// d_04
			$this->d_04->LinkCustomAttributes = "";
			$this->d_04->HrefValue = "";

			// d_05
			$this->d_05->LinkCustomAttributes = "";
			$this->d_05->HrefValue = "";

			// d_06
			$this->d_06->LinkCustomAttributes = "";
			$this->d_06->HrefValue = "";

			// d_07
			$this->d_07->LinkCustomAttributes = "";
			$this->d_07->HrefValue = "";

			// d_08
			$this->d_08->LinkCustomAttributes = "";
			$this->d_08->HrefValue = "";

			// d_09
			$this->d_09->LinkCustomAttributes = "";
			$this->d_09->HrefValue = "";

			// d_10
			$this->d_10->LinkCustomAttributes = "";
			$this->d_10->HrefValue = "";

			// d_11
			$this->d_11->LinkCustomAttributes = "";
			$this->d_11->HrefValue = "";

			// d_12
			$this->d_12->LinkCustomAttributes = "";
			$this->d_12->HrefValue = "";

			// d_13
			$this->d_13->LinkCustomAttributes = "";
			$this->d_13->HrefValue = "";

			// d_14
			$this->d_14->LinkCustomAttributes = "";
			$this->d_14->HrefValue = "";

			// d_15
			$this->d_15->LinkCustomAttributes = "";
			$this->d_15->HrefValue = "";

			// d_16
			$this->d_16->LinkCustomAttributes = "";
			$this->d_16->HrefValue = "";

			// d_17
			$this->d_17->LinkCustomAttributes = "";
			$this->d_17->HrefValue = "";

			// d_18
			$this->d_18->LinkCustomAttributes = "";
			$this->d_18->HrefValue = "";

			// d_19
			$this->d_19->LinkCustomAttributes = "";
			$this->d_19->HrefValue = "";

			// d_20
			$this->d_20->LinkCustomAttributes = "";
			$this->d_20->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->grp->Required) {
			if (!$this->grp->IsDetailKey && $this->grp->FormValue != NULL && $this->grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
			}
		}
		if ($this->s_grp->Required) {
			if (!$this->s_grp->IsDetailKey && $this->s_grp->FormValue != NULL && $this->s_grp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
			}
		}
		if ($this->product->Required) {
			if (!$this->product->IsDetailKey && $this->product->FormValue != NULL && $this->product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
			}
		}
		if ($this->ref->Required) {
			if (!$this->ref->IsDetailKey && $this->ref->FormValue != NULL && $this->ref->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ref->caption(), $this->ref->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->ref->FormValue)) {
			AddMessage($FormError, $this->ref->errorMessage());
		}
		if ($this->lot_no->Required) {
			if (!$this->lot_no->IsDetailKey && $this->lot_no->FormValue != NULL && $this->lot_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->lot_no->caption(), $this->lot_no->RequiredErrorMessage));
			}
		}
		if ($this->dated->Required) {
			if (!$this->dated->IsDetailKey && $this->dated->FormValue != NULL && $this->dated->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->dated->caption(), $this->dated->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->dated->FormValue)) {
			AddMessage($FormError, $this->dated->errorMessage());
		}
		if ($this->d_01->Required) {
			if (!$this->d_01->IsDetailKey && $this->d_01->FormValue != NULL && $this->d_01->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_01->caption(), $this->d_01->RequiredErrorMessage));
			}
		}
		if ($this->d_02->Required) {
			if (!$this->d_02->IsDetailKey && $this->d_02->FormValue != NULL && $this->d_02->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_02->caption(), $this->d_02->RequiredErrorMessage));
			}
		}
		if ($this->d_03->Required) {
			if (!$this->d_03->IsDetailKey && $this->d_03->FormValue != NULL && $this->d_03->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_03->caption(), $this->d_03->RequiredErrorMessage));
			}
		}
		if ($this->d_04->Required) {
			if (!$this->d_04->IsDetailKey && $this->d_04->FormValue != NULL && $this->d_04->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_04->caption(), $this->d_04->RequiredErrorMessage));
			}
		}
		if ($this->d_05->Required) {
			if (!$this->d_05->IsDetailKey && $this->d_05->FormValue != NULL && $this->d_05->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_05->caption(), $this->d_05->RequiredErrorMessage));
			}
		}
		if ($this->d_06->Required) {
			if (!$this->d_06->IsDetailKey && $this->d_06->FormValue != NULL && $this->d_06->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_06->caption(), $this->d_06->RequiredErrorMessage));
			}
		}
		if ($this->d_07->Required) {
			if (!$this->d_07->IsDetailKey && $this->d_07->FormValue != NULL && $this->d_07->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_07->caption(), $this->d_07->RequiredErrorMessage));
			}
		}
		if ($this->d_08->Required) {
			if (!$this->d_08->IsDetailKey && $this->d_08->FormValue != NULL && $this->d_08->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_08->caption(), $this->d_08->RequiredErrorMessage));
			}
		}
		if ($this->d_09->Required) {
			if (!$this->d_09->IsDetailKey && $this->d_09->FormValue != NULL && $this->d_09->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_09->caption(), $this->d_09->RequiredErrorMessage));
			}
		}
		if ($this->d_10->Required) {
			if (!$this->d_10->IsDetailKey && $this->d_10->FormValue != NULL && $this->d_10->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_10->caption(), $this->d_10->RequiredErrorMessage));
			}
		}
		if ($this->d_11->Required) {
			if (!$this->d_11->IsDetailKey && $this->d_11->FormValue != NULL && $this->d_11->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_11->caption(), $this->d_11->RequiredErrorMessage));
			}
		}
		if ($this->d_12->Required) {
			if (!$this->d_12->IsDetailKey && $this->d_12->FormValue != NULL && $this->d_12->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_12->caption(), $this->d_12->RequiredErrorMessage));
			}
		}
		if ($this->d_13->Required) {
			if (!$this->d_13->IsDetailKey && $this->d_13->FormValue != NULL && $this->d_13->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_13->caption(), $this->d_13->RequiredErrorMessage));
			}
		}
		if ($this->d_14->Required) {
			if (!$this->d_14->IsDetailKey && $this->d_14->FormValue != NULL && $this->d_14->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_14->caption(), $this->d_14->RequiredErrorMessage));
			}
		}
		if ($this->d_15->Required) {
			if (!$this->d_15->IsDetailKey && $this->d_15->FormValue != NULL && $this->d_15->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_15->caption(), $this->d_15->RequiredErrorMessage));
			}
		}
		if ($this->d_16->Required) {
			if (!$this->d_16->IsDetailKey && $this->d_16->FormValue != NULL && $this->d_16->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_16->caption(), $this->d_16->RequiredErrorMessage));
			}
		}
		if ($this->d_17->Required) {
			if (!$this->d_17->IsDetailKey && $this->d_17->FormValue != NULL && $this->d_17->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_17->caption(), $this->d_17->RequiredErrorMessage));
			}
		}
		if ($this->d_18->Required) {
			if (!$this->d_18->IsDetailKey && $this->d_18->FormValue != NULL && $this->d_18->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_18->caption(), $this->d_18->RequiredErrorMessage));
			}
		}
		if ($this->d_19->Required) {
			if (!$this->d_19->IsDetailKey && $this->d_19->FormValue != NULL && $this->d_19->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_19->caption(), $this->d_19->RequiredErrorMessage));
			}
		}
		if ($this->d_20->Required) {
			if (!$this->d_20->IsDetailKey && $this->d_20->FormValue != NULL && $this->d_20->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_20->caption(), $this->d_20->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// grp
		$this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, 0, FALSE);

		// s_grp
		$this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, 0, FALSE);

		// product
		$this->product->setDbValueDef($rsnew, $this->product->CurrentValue, 0, FALSE);

		// ref
		$this->ref->setDbValueDef($rsnew, $this->ref->CurrentValue, 0, FALSE);

		// lot_no
		$this->lot_no->setDbValueDef($rsnew, $this->lot_no->CurrentValue, "", FALSE);

		// dated
		$this->dated->setDbValueDef($rsnew, UnFormatDateTime($this->dated->CurrentValue, 2), CurrentDate(), FALSE);

		// d_01
		$this->d_01->setDbValueDef($rsnew, $this->d_01->CurrentValue, 0, FALSE);

		// d_02
		$this->d_02->setDbValueDef($rsnew, $this->d_02->CurrentValue, 0, FALSE);

		// d_03
		$this->d_03->setDbValueDef($rsnew, $this->d_03->CurrentValue, 0, FALSE);

		// d_04
		$this->d_04->setDbValueDef($rsnew, $this->d_04->CurrentValue, 0, FALSE);

		// d_05
		$this->d_05->setDbValueDef($rsnew, $this->d_05->CurrentValue, 0, FALSE);

		// d_06
		$this->d_06->setDbValueDef($rsnew, $this->d_06->CurrentValue, 0, FALSE);

		// d_07
		$this->d_07->setDbValueDef($rsnew, $this->d_07->CurrentValue, 0, FALSE);

		// d_08
		$this->d_08->setDbValueDef($rsnew, $this->d_08->CurrentValue, 0, FALSE);

		// d_09
		$this->d_09->setDbValueDef($rsnew, $this->d_09->CurrentValue, 0, FALSE);

		// d_10
		$this->d_10->setDbValueDef($rsnew, $this->d_10->CurrentValue, 0, FALSE);

		// d_11
		$this->d_11->setDbValueDef($rsnew, $this->d_11->CurrentValue, 0, FALSE);

		// d_12
		$this->d_12->setDbValueDef($rsnew, $this->d_12->CurrentValue, 0, FALSE);

		// d_13
		$this->d_13->setDbValueDef($rsnew, $this->d_13->CurrentValue, 0, FALSE);

		// d_14
		$this->d_14->setDbValueDef($rsnew, $this->d_14->CurrentValue, 0, FALSE);

		// d_15
		$this->d_15->setDbValueDef($rsnew, $this->d_15->CurrentValue, 0, FALSE);

		// d_16
		$this->d_16->setDbValueDef($rsnew, $this->d_16->CurrentValue, 0, FALSE);

		// d_17
		$this->d_17->setDbValueDef($rsnew, $this->d_17->CurrentValue, 0, FALSE);

		// d_18
		$this->d_18->setDbValueDef($rsnew, $this->d_18->CurrentValue, 0, FALSE);

		// d_19
		$this->d_19->setDbValueDef($rsnew, $this->d_19->CurrentValue, 0, FALSE);

		// d_20
		$this->d_20->setDbValueDef($rsnew, $this->d_20->CurrentValue, 0, FALSE);

		// operator
		$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
		$rsnew['operator'] = &$this->operator->DbValue;

		// datetime
		$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
		$rsnew['datetime'] = &$this->datetime->DbValue;

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("test_report_glist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_grp":
					$lookupFilter = function() {
						return "`id`>100";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`id`>100";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_grp":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>