<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class test_report_search extends test_report
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'test_report';

	// Page object name
	public $PageObjName = "test_report_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (test_report)
		if (!isset($GLOBALS["test_report"]) || get_class($GLOBALS["test_report"]) == PROJECT_NAMESPACE . "test_report") {
			$GLOBALS["test_report"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["test_report"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'test_report');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $test_report;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($test_report);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "test_reportview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("test_reportlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->product->setVisibility();
		$this->ref->setVisibility();
		$this->lot_no->setVisibility();
		$this->dated->setVisibility();
		$this->d_01->setVisibility();
		$this->d_02->setVisibility();
		$this->d_03->setVisibility();
		$this->d_04->setVisibility();
		$this->d_05->setVisibility();
		$this->d_06->setVisibility();
		$this->d_07->setVisibility();
		$this->d_08->setVisibility();
		$this->d_09->setVisibility();
		$this->d_10->setVisibility();
		$this->d_11->setVisibility();
		$this->d_12->setVisibility();
		$this->d_13->setVisibility();
		$this->d_14->setVisibility();
		$this->d_15->setVisibility();
		$this->d_16->setVisibility();
		$this->d_17->setVisibility();
		$this->d_18->setVisibility();
		$this->d_19->setVisibility();
		$this->d_20->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->ref);
		$this->setupLookupOptions($this->operator);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "test_reportlist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->grp); // grp
		$this->buildSearchUrl($srchUrl, $this->s_grp); // s_grp
		$this->buildSearchUrl($srchUrl, $this->product); // product
		$this->buildSearchUrl($srchUrl, $this->ref); // ref
		$this->buildSearchUrl($srchUrl, $this->lot_no); // lot_no
		$this->buildSearchUrl($srchUrl, $this->dated); // dated
		$this->buildSearchUrl($srchUrl, $this->d_01); // d_01
		$this->buildSearchUrl($srchUrl, $this->d_02); // d_02
		$this->buildSearchUrl($srchUrl, $this->d_03); // d_03
		$this->buildSearchUrl($srchUrl, $this->d_04); // d_04
		$this->buildSearchUrl($srchUrl, $this->d_05); // d_05
		$this->buildSearchUrl($srchUrl, $this->d_06); // d_06
		$this->buildSearchUrl($srchUrl, $this->d_07); // d_07
		$this->buildSearchUrl($srchUrl, $this->d_08); // d_08
		$this->buildSearchUrl($srchUrl, $this->d_09); // d_09
		$this->buildSearchUrl($srchUrl, $this->d_10); // d_10
		$this->buildSearchUrl($srchUrl, $this->d_11); // d_11
		$this->buildSearchUrl($srchUrl, $this->d_12); // d_12
		$this->buildSearchUrl($srchUrl, $this->d_13); // d_13
		$this->buildSearchUrl($srchUrl, $this->d_14); // d_14
		$this->buildSearchUrl($srchUrl, $this->d_15); // d_15
		$this->buildSearchUrl($srchUrl, $this->d_16); // d_16
		$this->buildSearchUrl($srchUrl, $this->d_17); // d_17
		$this->buildSearchUrl($srchUrl, $this->d_18); // d_18
		$this->buildSearchUrl($srchUrl, $this->d_19); // d_19
		$this->buildSearchUrl($srchUrl, $this->d_20); // d_20
		$this->buildSearchUrl($srchUrl, $this->operator); // operator
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// grp
		if (!$this->isAddOrEdit())
			$this->grp->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_grp"));
		$this->grp->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_grp"));

		// s_grp
		if (!$this->isAddOrEdit())
			$this->s_grp->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_s_grp"));
		$this->s_grp->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_s_grp"));

		// product
		if (!$this->isAddOrEdit())
			$this->product->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_product"));
		$this->product->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_product"));

		// ref
		if (!$this->isAddOrEdit())
			$this->ref->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_ref"));
		$this->ref->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_ref"));

		// lot_no
		if (!$this->isAddOrEdit())
			$this->lot_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_lot_no"));
		$this->lot_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_lot_no"));

		// dated
		if (!$this->isAddOrEdit())
			$this->dated->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_dated"));
		$this->dated->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_dated"));

		// d_01
		if (!$this->isAddOrEdit())
			$this->d_01->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_01"));
		$this->d_01->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_01"));

		// d_02
		if (!$this->isAddOrEdit())
			$this->d_02->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_02"));
		$this->d_02->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_02"));

		// d_03
		if (!$this->isAddOrEdit())
			$this->d_03->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_03"));
		$this->d_03->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_03"));

		// d_04
		if (!$this->isAddOrEdit())
			$this->d_04->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_04"));
		$this->d_04->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_04"));

		// d_05
		if (!$this->isAddOrEdit())
			$this->d_05->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_05"));
		$this->d_05->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_05"));

		// d_06
		if (!$this->isAddOrEdit())
			$this->d_06->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_06"));
		$this->d_06->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_06"));

		// d_07
		if (!$this->isAddOrEdit())
			$this->d_07->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_07"));
		$this->d_07->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_07"));

		// d_08
		if (!$this->isAddOrEdit())
			$this->d_08->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_08"));
		$this->d_08->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_08"));

		// d_09
		if (!$this->isAddOrEdit())
			$this->d_09->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_09"));
		$this->d_09->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_09"));

		// d_10
		if (!$this->isAddOrEdit())
			$this->d_10->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_10"));
		$this->d_10->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_10"));

		// d_11
		if (!$this->isAddOrEdit())
			$this->d_11->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_11"));
		$this->d_11->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_11"));

		// d_12
		if (!$this->isAddOrEdit())
			$this->d_12->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_12"));
		$this->d_12->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_12"));

		// d_13
		if (!$this->isAddOrEdit())
			$this->d_13->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_13"));
		$this->d_13->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_13"));

		// d_14
		if (!$this->isAddOrEdit())
			$this->d_14->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_14"));
		$this->d_14->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_14"));

		// d_15
		if (!$this->isAddOrEdit())
			$this->d_15->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_15"));
		$this->d_15->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_15"));

		// d_16
		if (!$this->isAddOrEdit())
			$this->d_16->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_16"));
		$this->d_16->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_16"));

		// d_17
		if (!$this->isAddOrEdit())
			$this->d_17->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_17"));
		$this->d_17->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_17"));

		// d_18
		if (!$this->isAddOrEdit())
			$this->d_18->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_18"));
		$this->d_18->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_18"));

		// d_19
		if (!$this->isAddOrEdit())
			$this->d_19->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_19"));
		$this->d_19->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_19"));

		// d_20
		if (!$this->isAddOrEdit())
			$this->d_20->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_20"));
		$this->d_20->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_20"));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_operator"));
		$this->operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_operator"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->d_01->FormValue == $this->d_01->CurrentValue && is_numeric(ConvertToFloatString($this->d_01->CurrentValue)))
			$this->d_01->CurrentValue = ConvertToFloatString($this->d_01->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_02->FormValue == $this->d_02->CurrentValue && is_numeric(ConvertToFloatString($this->d_02->CurrentValue)))
			$this->d_02->CurrentValue = ConvertToFloatString($this->d_02->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_03->FormValue == $this->d_03->CurrentValue && is_numeric(ConvertToFloatString($this->d_03->CurrentValue)))
			$this->d_03->CurrentValue = ConvertToFloatString($this->d_03->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_04->FormValue == $this->d_04->CurrentValue && is_numeric(ConvertToFloatString($this->d_04->CurrentValue)))
			$this->d_04->CurrentValue = ConvertToFloatString($this->d_04->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_05->FormValue == $this->d_05->CurrentValue && is_numeric(ConvertToFloatString($this->d_05->CurrentValue)))
			$this->d_05->CurrentValue = ConvertToFloatString($this->d_05->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_06->FormValue == $this->d_06->CurrentValue && is_numeric(ConvertToFloatString($this->d_06->CurrentValue)))
			$this->d_06->CurrentValue = ConvertToFloatString($this->d_06->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_07->FormValue == $this->d_07->CurrentValue && is_numeric(ConvertToFloatString($this->d_07->CurrentValue)))
			$this->d_07->CurrentValue = ConvertToFloatString($this->d_07->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_08->FormValue == $this->d_08->CurrentValue && is_numeric(ConvertToFloatString($this->d_08->CurrentValue)))
			$this->d_08->CurrentValue = ConvertToFloatString($this->d_08->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_09->FormValue == $this->d_09->CurrentValue && is_numeric(ConvertToFloatString($this->d_09->CurrentValue)))
			$this->d_09->CurrentValue = ConvertToFloatString($this->d_09->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_10->FormValue == $this->d_10->CurrentValue && is_numeric(ConvertToFloatString($this->d_10->CurrentValue)))
			$this->d_10->CurrentValue = ConvertToFloatString($this->d_10->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_11->FormValue == $this->d_11->CurrentValue && is_numeric(ConvertToFloatString($this->d_11->CurrentValue)))
			$this->d_11->CurrentValue = ConvertToFloatString($this->d_11->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_12->FormValue == $this->d_12->CurrentValue && is_numeric(ConvertToFloatString($this->d_12->CurrentValue)))
			$this->d_12->CurrentValue = ConvertToFloatString($this->d_12->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_13->FormValue == $this->d_13->CurrentValue && is_numeric(ConvertToFloatString($this->d_13->CurrentValue)))
			$this->d_13->CurrentValue = ConvertToFloatString($this->d_13->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_14->FormValue == $this->d_14->CurrentValue && is_numeric(ConvertToFloatString($this->d_14->CurrentValue)))
			$this->d_14->CurrentValue = ConvertToFloatString($this->d_14->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_15->FormValue == $this->d_15->CurrentValue && is_numeric(ConvertToFloatString($this->d_15->CurrentValue)))
			$this->d_15->CurrentValue = ConvertToFloatString($this->d_15->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_16->FormValue == $this->d_16->CurrentValue && is_numeric(ConvertToFloatString($this->d_16->CurrentValue)))
			$this->d_16->CurrentValue = ConvertToFloatString($this->d_16->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_17->FormValue == $this->d_17->CurrentValue && is_numeric(ConvertToFloatString($this->d_17->CurrentValue)))
			$this->d_17->CurrentValue = ConvertToFloatString($this->d_17->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_18->FormValue == $this->d_18->CurrentValue && is_numeric(ConvertToFloatString($this->d_18->CurrentValue)))
			$this->d_18->CurrentValue = ConvertToFloatString($this->d_18->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_19->FormValue == $this->d_19->CurrentValue && is_numeric(ConvertToFloatString($this->d_19->CurrentValue)))
			$this->d_19->CurrentValue = ConvertToFloatString($this->d_19->CurrentValue);

		// Convert decimal values if posted back
		if ($this->d_20->FormValue == $this->d_20->CurrentValue && is_numeric(ConvertToFloatString($this->d_20->CurrentValue)))
			$this->d_20->CurrentValue = ConvertToFloatString($this->d_20->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// grp
		// s_grp
		// product
		// ref
		// lot_no
		// dated
		// d_01
		// d_02
		// d_03
		// d_04
		// d_05
		// d_06
		// d_07
		// d_08
		// d_09
		// d_10
		// d_11
		// d_12
		// d_13
		// d_14
		// d_15
		// d_16
		// d_17
		// d_18
		// d_19
		// d_20
		// operator
		// datetime

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
			$this->id->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			$this->product->CssClass = "font-italic";
			$this->product->ViewCustomAttributes = "";

			// ref
			$curVal = strval($this->ref->CurrentValue);
			if ($curVal <> "") {
				$this->ref->ViewValue = $this->ref->lookupCacheOption($curVal);
				if ($this->ref->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->ref->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->ref->ViewValue = $this->ref->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->ref->ViewValue = $this->ref->CurrentValue;
					}
				}
			} else {
				$this->ref->ViewValue = NULL;
			}
			$this->ref->ViewCustomAttributes = "";

			// lot_no
			$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
			$this->lot_no->ViewCustomAttributes = "";

			// dated
			$this->dated->ViewValue = $this->dated->CurrentValue;
			$this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, 2);
			$this->dated->ViewCustomAttributes = "";

			// d_01
			$this->d_01->ViewValue = $this->d_01->CurrentValue;
			$this->d_01->ViewCustomAttributes = "";

			// d_02
			$this->d_02->ViewValue = $this->d_02->CurrentValue;
			$this->d_02->ViewCustomAttributes = "";

			// d_03
			$this->d_03->ViewValue = $this->d_03->CurrentValue;
			$this->d_03->ViewCustomAttributes = "";

			// d_04
			$this->d_04->ViewValue = $this->d_04->CurrentValue;
			$this->d_04->ViewCustomAttributes = "";

			// d_05
			$this->d_05->ViewValue = $this->d_05->CurrentValue;
			$this->d_05->ViewCustomAttributes = "";

			// d_06
			$this->d_06->ViewValue = $this->d_06->CurrentValue;
			$this->d_06->ViewCustomAttributes = "";

			// d_07
			$this->d_07->ViewValue = $this->d_07->CurrentValue;
			$this->d_07->ViewCustomAttributes = "";

			// d_08
			$this->d_08->ViewValue = $this->d_08->CurrentValue;
			$this->d_08->ViewCustomAttributes = "";

			// d_09
			$this->d_09->ViewValue = $this->d_09->CurrentValue;
			$this->d_09->ViewCustomAttributes = "";

			// d_10
			$this->d_10->ViewValue = $this->d_10->CurrentValue;
			$this->d_10->ViewCustomAttributes = "";

			// d_11
			$this->d_11->ViewValue = $this->d_11->CurrentValue;
			$this->d_11->ViewCustomAttributes = "";

			// d_12
			$this->d_12->ViewValue = $this->d_12->CurrentValue;
			$this->d_12->ViewCustomAttributes = "";

			// d_13
			$this->d_13->ViewValue = $this->d_13->CurrentValue;
			$this->d_13->ViewCustomAttributes = "";

			// d_14
			$this->d_14->ViewValue = $this->d_14->CurrentValue;
			$this->d_14->ViewCustomAttributes = "";

			// d_15
			$this->d_15->ViewValue = $this->d_15->CurrentValue;
			$this->d_15->ViewCustomAttributes = "";

			// d_16
			$this->d_16->ViewValue = $this->d_16->CurrentValue;
			$this->d_16->ViewCustomAttributes = "";

			// d_17
			$this->d_17->ViewValue = $this->d_17->CurrentValue;
			$this->d_17->ViewCustomAttributes = "";

			// d_18
			$this->d_18->ViewValue = $this->d_18->CurrentValue;
			$this->d_18->ViewCustomAttributes = "";

			// d_19
			$this->d_19->ViewValue = $this->d_19->CurrentValue;
			$this->d_19->ViewCustomAttributes = "";

			// d_20
			$this->d_20->ViewValue = $this->d_20->CurrentValue;
			$this->d_20->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			$this->s_grp->HrefValue = "";
			$this->s_grp->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			$this->product->HrefValue = "";
			$this->product->TooltipValue = "";

			// ref
			$this->ref->LinkCustomAttributes = "";
			$this->ref->HrefValue = "";
			$this->ref->TooltipValue = "";

			// lot_no
			$this->lot_no->LinkCustomAttributes = "";
			$this->lot_no->HrefValue = "";
			$this->lot_no->TooltipValue = "";

			// dated
			$this->dated->LinkCustomAttributes = "";
			$this->dated->HrefValue = "";
			$this->dated->TooltipValue = "";

			// d_01
			$this->d_01->LinkCustomAttributes = "";
			$this->d_01->HrefValue = "";
			$this->d_01->TooltipValue = "";

			// d_02
			$this->d_02->LinkCustomAttributes = "";
			$this->d_02->HrefValue = "";
			$this->d_02->TooltipValue = "";

			// d_03
			$this->d_03->LinkCustomAttributes = "";
			$this->d_03->HrefValue = "";
			$this->d_03->TooltipValue = "";

			// d_04
			$this->d_04->LinkCustomAttributes = "";
			$this->d_04->HrefValue = "";
			$this->d_04->TooltipValue = "";

			// d_05
			$this->d_05->LinkCustomAttributes = "";
			$this->d_05->HrefValue = "";
			$this->d_05->TooltipValue = "";

			// d_06
			$this->d_06->LinkCustomAttributes = "";
			$this->d_06->HrefValue = "";
			$this->d_06->TooltipValue = "";

			// d_07
			$this->d_07->LinkCustomAttributes = "";
			$this->d_07->HrefValue = "";
			$this->d_07->TooltipValue = "";

			// d_08
			$this->d_08->LinkCustomAttributes = "";
			$this->d_08->HrefValue = "";
			$this->d_08->TooltipValue = "";

			// d_09
			$this->d_09->LinkCustomAttributes = "";
			$this->d_09->HrefValue = "";
			$this->d_09->TooltipValue = "";

			// d_10
			$this->d_10->LinkCustomAttributes = "";
			$this->d_10->HrefValue = "";
			$this->d_10->TooltipValue = "";

			// d_11
			$this->d_11->LinkCustomAttributes = "";
			$this->d_11->HrefValue = "";
			$this->d_11->TooltipValue = "";

			// d_12
			$this->d_12->LinkCustomAttributes = "";
			$this->d_12->HrefValue = "";
			$this->d_12->TooltipValue = "";

			// d_13
			$this->d_13->LinkCustomAttributes = "";
			$this->d_13->HrefValue = "";
			$this->d_13->TooltipValue = "";

			// d_14
			$this->d_14->LinkCustomAttributes = "";
			$this->d_14->HrefValue = "";
			$this->d_14->TooltipValue = "";

			// d_15
			$this->d_15->LinkCustomAttributes = "";
			$this->d_15->HrefValue = "";
			$this->d_15->TooltipValue = "";

			// d_16
			$this->d_16->LinkCustomAttributes = "";
			$this->d_16->HrefValue = "";
			$this->d_16->TooltipValue = "";

			// d_17
			$this->d_17->LinkCustomAttributes = "";
			$this->d_17->HrefValue = "";
			$this->d_17->TooltipValue = "";

			// d_18
			$this->d_18->LinkCustomAttributes = "";
			$this->d_18->HrefValue = "";
			$this->d_18->TooltipValue = "";

			// d_19
			$this->d_19->LinkCustomAttributes = "";
			$this->d_19->HrefValue = "";
			$this->d_19->TooltipValue = "";

			// d_20
			$this->d_20->LinkCustomAttributes = "";
			$this->d_20->HrefValue = "";
			$this->d_20->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->grp->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->grp->AdvancedSearch->ViewValue = $this->grp->lookupCacheOption($curVal);
			else
				$this->grp->AdvancedSearch->ViewValue = $this->grp->Lookup !== NULL && is_array($this->grp->Lookup->Options) ? $curVal : NULL;
			if ($this->grp->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->grp->EditValue = array_values($this->grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->grp->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->grp->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->grp->EditValue = $arwrk;
			}

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->s_grp->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->s_grp->AdvancedSearch->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			else
				$this->s_grp->AdvancedSearch->ViewValue = $this->s_grp->Lookup !== NULL && is_array($this->s_grp->Lookup->Options) ? $curVal : NULL;
			if ($this->s_grp->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->s_grp->EditValue = array_values($this->s_grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->s_grp->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->s_grp->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->s_grp->EditValue = $arwrk;
			}

			// product
			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";
			$curVal = trim(strval($this->product->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->product->AdvancedSearch->ViewValue = $this->product->lookupCacheOption($curVal);
			else
				$this->product->AdvancedSearch->ViewValue = $this->product->Lookup !== NULL && is_array($this->product->Lookup->Options) ? $curVal : NULL;
			if ($this->product->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->product->EditValue = array_values($this->product->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->product->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->product->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product->EditValue = $arwrk;
			}

			// ref
			$this->ref->EditCustomAttributes = "";
			$curVal = trim(strval($this->ref->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->ref->AdvancedSearch->ViewValue = $this->ref->lookupCacheOption($curVal);
			else
				$this->ref->AdvancedSearch->ViewValue = $this->ref->Lookup !== NULL && is_array($this->ref->Lookup->Options) ? $curVal : NULL;
			if ($this->ref->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->ref->EditValue = array_values($this->ref->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->ref->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->ref->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->ref->EditValue = $arwrk;
			}

			// lot_no
			$this->lot_no->EditAttrs["class"] = "form-control";
			$this->lot_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->lot_no->AdvancedSearch->SearchValue = HtmlDecode($this->lot_no->AdvancedSearch->SearchValue);
			$this->lot_no->EditValue = HtmlEncode($this->lot_no->AdvancedSearch->SearchValue);
			$this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

			// dated
			$this->dated->EditAttrs["class"] = "form-control";
			$this->dated->EditCustomAttributes = "";
			$this->dated->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->dated->AdvancedSearch->SearchValue, 2), 2));
			$this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

			// d_01
			$this->d_01->EditAttrs["class"] = "form-control";
			$this->d_01->EditCustomAttributes = "";
			$this->d_01->EditValue = HtmlEncode($this->d_01->AdvancedSearch->SearchValue);
			$this->d_01->PlaceHolder = RemoveHtml($this->d_01->caption());

			// d_02
			$this->d_02->EditAttrs["class"] = "form-control";
			$this->d_02->EditCustomAttributes = "";
			$this->d_02->EditValue = HtmlEncode($this->d_02->AdvancedSearch->SearchValue);
			$this->d_02->PlaceHolder = RemoveHtml($this->d_02->caption());

			// d_03
			$this->d_03->EditAttrs["class"] = "form-control";
			$this->d_03->EditCustomAttributes = "";
			$this->d_03->EditValue = HtmlEncode($this->d_03->AdvancedSearch->SearchValue);
			$this->d_03->PlaceHolder = RemoveHtml($this->d_03->caption());

			// d_04
			$this->d_04->EditAttrs["class"] = "form-control";
			$this->d_04->EditCustomAttributes = "";
			$this->d_04->EditValue = HtmlEncode($this->d_04->AdvancedSearch->SearchValue);
			$this->d_04->PlaceHolder = RemoveHtml($this->d_04->caption());

			// d_05
			$this->d_05->EditAttrs["class"] = "form-control";
			$this->d_05->EditCustomAttributes = "";
			$this->d_05->EditValue = HtmlEncode($this->d_05->AdvancedSearch->SearchValue);
			$this->d_05->PlaceHolder = RemoveHtml($this->d_05->caption());

			// d_06
			$this->d_06->EditAttrs["class"] = "form-control";
			$this->d_06->EditCustomAttributes = "";
			$this->d_06->EditValue = HtmlEncode($this->d_06->AdvancedSearch->SearchValue);
			$this->d_06->PlaceHolder = RemoveHtml($this->d_06->caption());

			// d_07
			$this->d_07->EditAttrs["class"] = "form-control";
			$this->d_07->EditCustomAttributes = "";
			$this->d_07->EditValue = HtmlEncode($this->d_07->AdvancedSearch->SearchValue);
			$this->d_07->PlaceHolder = RemoveHtml($this->d_07->caption());

			// d_08
			$this->d_08->EditAttrs["class"] = "form-control";
			$this->d_08->EditCustomAttributes = "";
			$this->d_08->EditValue = HtmlEncode($this->d_08->AdvancedSearch->SearchValue);
			$this->d_08->PlaceHolder = RemoveHtml($this->d_08->caption());

			// d_09
			$this->d_09->EditAttrs["class"] = "form-control";
			$this->d_09->EditCustomAttributes = "";
			$this->d_09->EditValue = HtmlEncode($this->d_09->AdvancedSearch->SearchValue);
			$this->d_09->PlaceHolder = RemoveHtml($this->d_09->caption());

			// d_10
			$this->d_10->EditAttrs["class"] = "form-control";
			$this->d_10->EditCustomAttributes = "";
			$this->d_10->EditValue = HtmlEncode($this->d_10->AdvancedSearch->SearchValue);
			$this->d_10->PlaceHolder = RemoveHtml($this->d_10->caption());

			// d_11
			$this->d_11->EditAttrs["class"] = "form-control";
			$this->d_11->EditCustomAttributes = "";
			$this->d_11->EditValue = HtmlEncode($this->d_11->AdvancedSearch->SearchValue);
			$this->d_11->PlaceHolder = RemoveHtml($this->d_11->caption());

			// d_12
			$this->d_12->EditAttrs["class"] = "form-control";
			$this->d_12->EditCustomAttributes = "";
			$this->d_12->EditValue = HtmlEncode($this->d_12->AdvancedSearch->SearchValue);
			$this->d_12->PlaceHolder = RemoveHtml($this->d_12->caption());

			// d_13
			$this->d_13->EditAttrs["class"] = "form-control";
			$this->d_13->EditCustomAttributes = "";
			$this->d_13->EditValue = HtmlEncode($this->d_13->AdvancedSearch->SearchValue);
			$this->d_13->PlaceHolder = RemoveHtml($this->d_13->caption());

			// d_14
			$this->d_14->EditAttrs["class"] = "form-control";
			$this->d_14->EditCustomAttributes = "";
			$this->d_14->EditValue = HtmlEncode($this->d_14->AdvancedSearch->SearchValue);
			$this->d_14->PlaceHolder = RemoveHtml($this->d_14->caption());

			// d_15
			$this->d_15->EditAttrs["class"] = "form-control";
			$this->d_15->EditCustomAttributes = "";
			$this->d_15->EditValue = HtmlEncode($this->d_15->AdvancedSearch->SearchValue);
			$this->d_15->PlaceHolder = RemoveHtml($this->d_15->caption());

			// d_16
			$this->d_16->EditAttrs["class"] = "form-control";
			$this->d_16->EditCustomAttributes = "";
			$this->d_16->EditValue = HtmlEncode($this->d_16->AdvancedSearch->SearchValue);
			$this->d_16->PlaceHolder = RemoveHtml($this->d_16->caption());

			// d_17
			$this->d_17->EditAttrs["class"] = "form-control";
			$this->d_17->EditCustomAttributes = "";
			$this->d_17->EditValue = HtmlEncode($this->d_17->AdvancedSearch->SearchValue);
			$this->d_17->PlaceHolder = RemoveHtml($this->d_17->caption());

			// d_18
			$this->d_18->EditAttrs["class"] = "form-control";
			$this->d_18->EditCustomAttributes = "";
			$this->d_18->EditValue = HtmlEncode($this->d_18->AdvancedSearch->SearchValue);
			$this->d_18->PlaceHolder = RemoveHtml($this->d_18->caption());

			// d_19
			$this->d_19->EditAttrs["class"] = "form-control";
			$this->d_19->EditCustomAttributes = "";
			$this->d_19->EditValue = HtmlEncode($this->d_19->AdvancedSearch->SearchValue);
			$this->d_19->PlaceHolder = RemoveHtml($this->d_19->caption());

			// d_20
			$this->d_20->EditAttrs["class"] = "form-control";
			$this->d_20->EditCustomAttributes = "";
			$this->d_20->EditValue = HtmlEncode($this->d_20->AdvancedSearch->SearchValue);
			$this->d_20->PlaceHolder = RemoveHtml($this->d_20->caption());

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
			else
				$this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== NULL && is_array($this->operator->Lookup->Options) ? $curVal : NULL;
			if ($this->operator->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->operator->EditValue = array_values($this->operator->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->operator->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->operator->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->operator->EditValue = $arwrk;
			}

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckDate($this->dated->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->dated->errorMessage());
		}
		if (!CheckDate($this->datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->datetime->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->grp->AdvancedSearch->load();
		$this->s_grp->AdvancedSearch->load();
		$this->product->AdvancedSearch->load();
		$this->ref->AdvancedSearch->load();
		$this->lot_no->AdvancedSearch->load();
		$this->dated->AdvancedSearch->load();
		$this->d_01->AdvancedSearch->load();
		$this->d_02->AdvancedSearch->load();
		$this->d_03->AdvancedSearch->load();
		$this->d_04->AdvancedSearch->load();
		$this->d_05->AdvancedSearch->load();
		$this->d_06->AdvancedSearch->load();
		$this->d_07->AdvancedSearch->load();
		$this->d_08->AdvancedSearch->load();
		$this->d_09->AdvancedSearch->load();
		$this->d_10->AdvancedSearch->load();
		$this->d_11->AdvancedSearch->load();
		$this->d_12->AdvancedSearch->load();
		$this->d_13->AdvancedSearch->load();
		$this->d_14->AdvancedSearch->load();
		$this->d_15->AdvancedSearch->load();
		$this->d_16->AdvancedSearch->load();
		$this->d_17->AdvancedSearch->load();
		$this->d_18->AdvancedSearch->load();
		$this->d_19->AdvancedSearch->load();
		$this->d_20->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("test_reportlist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_grp":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_ref":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>