<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class user_search extends user
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'user';

	// Page object name
	public $PageObjName = "user_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (user)
		if (!isset($GLOBALS["user"]) || get_class($GLOBALS["user"]) == PROJECT_NAMESPACE . "user") {
			$GLOBALS["user"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["user"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'user');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $user;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($user);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "userview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("userlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->mobile->setVisibility();
		$this->user_name->setVisibility();
		$this->password->setVisibility();
		$this->name->setVisibility();
		$this->_email->setVisibility();
		$this->gst_number->setVisibility();
		$this->category->setVisibility();
		$this->last_login->setVisibility();
		$this->reg_date->setVisibility();
		$this->reg_device->setVisibility();
		$this->app_version->setVisibility();
		$this->device_id->setVisibility();
		$this->device_token_id->setVisibility();
		$this->cart_number->setVisibility();
		$this->status->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->id->setVisibility();
		$this->max_discount->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->mobile);
		$this->setupLookupOptions($this->name);
		$this->setupLookupOptions($this->category);
		$this->setupLookupOptions($this->operator);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "userlist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->mobile); // mobile
		$this->buildSearchUrl($srchUrl, $this->user_name); // user_name
		$this->buildSearchUrl($srchUrl, $this->password); // password
		$this->buildSearchUrl($srchUrl, $this->name); // name
		$this->buildSearchUrl($srchUrl, $this->_email); // email
		$this->buildSearchUrl($srchUrl, $this->gst_number); // gst_number
		$this->buildSearchUrl($srchUrl, $this->category); // category
		$this->buildSearchUrl($srchUrl, $this->last_login); // last_login
		$this->buildSearchUrl($srchUrl, $this->reg_date); // reg_date
		$this->buildSearchUrl($srchUrl, $this->reg_device); // reg_device
		$this->buildSearchUrl($srchUrl, $this->app_version); // app_version
		$this->buildSearchUrl($srchUrl, $this->device_id); // device_id
		$this->buildSearchUrl($srchUrl, $this->device_token_id); // device_token_id
		$this->buildSearchUrl($srchUrl, $this->cart_number); // cart_number
		$this->buildSearchUrl($srchUrl, $this->status); // status
		$this->buildSearchUrl($srchUrl, $this->operator); // operator
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->max_discount); // max_discount
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// mobile

		if (!$this->isAddOrEdit())
			$this->mobile->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_mobile"));
		$this->mobile->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_mobile"));

		// user_name
		if (!$this->isAddOrEdit())
			$this->user_name->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_user_name"));
		$this->user_name->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_user_name"));

		// password
		if (!$this->isAddOrEdit())
			$this->password->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_password"));
		$this->password->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_password"));

		// name
		if (!$this->isAddOrEdit())
			$this->name->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_name"));
		$this->name->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_name"));

		// email
		if (!$this->isAddOrEdit())
			$this->_email->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__email"));
		$this->_email->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__email"));

		// gst_number
		if (!$this->isAddOrEdit())
			$this->gst_number->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_gst_number"));
		$this->gst_number->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_gst_number"));

		// category
		if (!$this->isAddOrEdit())
			$this->category->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_category"));
		$this->category->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_category"));
		if (is_array($this->category->AdvancedSearch->SearchValue))
			$this->category->AdvancedSearch->SearchValue = implode(",", $this->category->AdvancedSearch->SearchValue);
		if (is_array($this->category->AdvancedSearch->SearchValue2))
			$this->category->AdvancedSearch->SearchValue2 = implode(",", $this->category->AdvancedSearch->SearchValue2);

		// last_login
		if (!$this->isAddOrEdit())
			$this->last_login->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_last_login"));
		$this->last_login->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_last_login"));

		// reg_date
		if (!$this->isAddOrEdit())
			$this->reg_date->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_reg_date"));
		$this->reg_date->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_reg_date"));

		// reg_device
		if (!$this->isAddOrEdit())
			$this->reg_device->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_reg_device"));
		$this->reg_device->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_reg_device"));

		// app_version
		if (!$this->isAddOrEdit())
			$this->app_version->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_app_version"));
		$this->app_version->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_app_version"));

		// device_id
		if (!$this->isAddOrEdit())
			$this->device_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_device_id"));
		$this->device_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_device_id"));

		// device_token_id
		if (!$this->isAddOrEdit())
			$this->device_token_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_device_token_id"));
		$this->device_token_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_device_token_id"));

		// cart_number
		if (!$this->isAddOrEdit())
			$this->cart_number->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_cart_number"));
		$this->cart_number->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_cart_number"));

		// status
		if (!$this->isAddOrEdit())
			$this->status->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_status"));
		$this->status->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_status"));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_operator"));
		$this->operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_operator"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));

		// id
		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// max_discount
		if (!$this->isAddOrEdit())
			$this->max_discount->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_max_discount"));
		$this->max_discount->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_max_discount"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->max_discount->FormValue == $this->max_discount->CurrentValue && is_numeric(ConvertToFloatString($this->max_discount->CurrentValue)))
			$this->max_discount->CurrentValue = ConvertToFloatString($this->max_discount->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// mobile
		// user_name
		// password
		// name
		// email
		// gst_number
		// category
		// last_login
		// reg_date
		// reg_device
		// app_version
		// device_id
		// device_token_id
		// cart_number
		// status
		// operator
		// datetime
		// id
		// max_discount

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// mobile
			$this->mobile->ViewValue = $this->mobile->CurrentValue;
			$arwrk = array();
			$arwrk[1] = $this->mobile->CurrentValue;
			$arwrk[2] = $this->name->CurrentValue;
			$this->mobile->ViewValue = $this->mobile->displayValue($arwrk);
			$this->mobile->ViewCustomAttributes = "";

			// user_name
			$this->user_name->ViewValue = $this->user_name->CurrentValue;
			$this->user_name->ViewCustomAttributes = "";

			// password
			$this->password->ViewValue = $this->password->CurrentValue;
			$this->password->ViewCustomAttributes = "";

			// name
			$this->name->ViewValue = $this->name->CurrentValue;
			$arwrk = array();
			$arwrk[1] = $this->name->CurrentValue;
			$arwrk[2] = $this->mobile->CurrentValue;
			$this->name->ViewValue = $this->name->displayValue($arwrk);
			$this->name->ViewCustomAttributes = "";

			// email
			$this->_email->ViewValue = $this->_email->CurrentValue;
			$this->_email->ViewCustomAttributes = "";

			// gst_number
			$this->gst_number->ViewValue = $this->gst_number->CurrentValue;
			$this->gst_number->ViewCustomAttributes = "";

			// category
			$curVal = strval($this->category->CurrentValue);
			if ($curVal <> "") {
				$this->category->ViewValue = $this->category->lookupCacheOption($curVal);
				if ($this->category->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->category->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->category->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->category->ViewValue->add($this->category->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->category->ViewValue = $this->category->CurrentValue;
					}
				}
			} else {
				$this->category->ViewValue = NULL;
			}
			$this->category->ViewCustomAttributes = "";

			// last_login
			$this->last_login->ViewValue = $this->last_login->CurrentValue;
			$this->last_login->ViewValue = FormatDateTime($this->last_login->ViewValue, 0);
			$this->last_login->ViewCustomAttributes = "";

			// reg_date
			$this->reg_date->ViewValue = $this->reg_date->CurrentValue;
			$this->reg_date->ViewValue = FormatDateTime($this->reg_date->ViewValue, 0);
			$this->reg_date->ViewCustomAttributes = "";

			// reg_device
			$this->reg_device->ViewValue = $this->reg_device->CurrentValue;
			$this->reg_device->ViewValue = FormatNumber($this->reg_device->ViewValue, 0, -2, -2, -2);
			$this->reg_device->ViewCustomAttributes = "";

			// app_version
			$this->app_version->ViewValue = $this->app_version->CurrentValue;
			$this->app_version->ViewValue = FormatNumber($this->app_version->ViewValue, 0, -2, -2, -2);
			$this->app_version->ViewCustomAttributes = "";

			// device_id
			$this->device_id->ViewValue = $this->device_id->CurrentValue;
			$this->device_id->ViewCustomAttributes = "";

			// device_token_id
			$this->device_token_id->ViewValue = $this->device_token_id->CurrentValue;
			$this->device_token_id->ViewCustomAttributes = "";

			// cart_number
			$this->cart_number->ViewValue = $this->cart_number->CurrentValue;
			$this->cart_number->ViewValue = FormatNumber($this->cart_number->ViewValue, 0, -2, -2, -2);
			$this->cart_number->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// max_discount
			$this->max_discount->ViewValue = $this->max_discount->CurrentValue;
			$this->max_discount->ViewValue = FormatNumber($this->max_discount->ViewValue, 2, -2, -2, -2);
			$this->max_discount->ViewCustomAttributes = "";

			// mobile
			$this->mobile->LinkCustomAttributes = "";
			$this->mobile->HrefValue = "";
			$this->mobile->TooltipValue = "";

			// user_name
			$this->user_name->LinkCustomAttributes = "";
			$this->user_name->HrefValue = "";
			$this->user_name->TooltipValue = "";

			// password
			$this->password->LinkCustomAttributes = "";
			$this->password->HrefValue = "";
			$this->password->TooltipValue = "";

			// name
			$this->name->LinkCustomAttributes = "";
			$this->name->HrefValue = "";
			$this->name->TooltipValue = "";

			// email
			$this->_email->LinkCustomAttributes = "";
			$this->_email->HrefValue = "";
			$this->_email->TooltipValue = "";

			// gst_number
			$this->gst_number->LinkCustomAttributes = "";
			$this->gst_number->HrefValue = "";
			$this->gst_number->TooltipValue = "";

			// category
			$this->category->LinkCustomAttributes = "";
			$this->category->HrefValue = "";
			$this->category->TooltipValue = "";

			// last_login
			$this->last_login->LinkCustomAttributes = "";
			$this->last_login->HrefValue = "";
			$this->last_login->TooltipValue = "";

			// reg_date
			$this->reg_date->LinkCustomAttributes = "";
			$this->reg_date->HrefValue = "";
			$this->reg_date->TooltipValue = "";

			// reg_device
			$this->reg_device->LinkCustomAttributes = "";
			$this->reg_device->HrefValue = "";
			$this->reg_device->TooltipValue = "";

			// app_version
			$this->app_version->LinkCustomAttributes = "";
			$this->app_version->HrefValue = "";
			$this->app_version->TooltipValue = "";

			// device_id
			$this->device_id->LinkCustomAttributes = "";
			$this->device_id->HrefValue = "";
			$this->device_id->TooltipValue = "";

			// device_token_id
			$this->device_token_id->LinkCustomAttributes = "";
			$this->device_token_id->HrefValue = "";
			$this->device_token_id->TooltipValue = "";

			// cart_number
			$this->cart_number->LinkCustomAttributes = "";
			$this->cart_number->HrefValue = "";
			$this->cart_number->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// max_discount
			$this->max_discount->LinkCustomAttributes = "";
			$this->max_discount->HrefValue = "";
			$this->max_discount->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// mobile
			$this->mobile->EditAttrs["class"] = "form-control";
			$this->mobile->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->mobile->AdvancedSearch->SearchValue = HtmlDecode($this->mobile->AdvancedSearch->SearchValue);
			$this->mobile->EditValue = HtmlEncode($this->mobile->AdvancedSearch->SearchValue);
			$arwrk = array();
			$arwrk[1] = HtmlEncode($this->mobile->CurrentValue);
			$arwrk[2] = HtmlEncode($this->name->CurrentValue);
			$this->mobile->EditValue = $this->mobile->displayValue($arwrk);
			$this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

			// user_name
			$this->user_name->EditAttrs["class"] = "form-control";
			$this->user_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->user_name->AdvancedSearch->SearchValue = HtmlDecode($this->user_name->AdvancedSearch->SearchValue);
			$this->user_name->EditValue = HtmlEncode($this->user_name->AdvancedSearch->SearchValue);
			$this->user_name->PlaceHolder = RemoveHtml($this->user_name->caption());

			// password
			$this->password->EditAttrs["class"] = "form-control";
			$this->password->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->password->AdvancedSearch->SearchValue = HtmlDecode($this->password->AdvancedSearch->SearchValue);
			$this->password->EditValue = HtmlEncode($this->password->AdvancedSearch->SearchValue);
			$this->password->PlaceHolder = RemoveHtml($this->password->caption());

			// name
			$this->name->EditAttrs["class"] = "form-control";
			$this->name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->name->AdvancedSearch->SearchValue = HtmlDecode($this->name->AdvancedSearch->SearchValue);
			$this->name->EditValue = HtmlEncode($this->name->AdvancedSearch->SearchValue);
			$arwrk = array();
			$arwrk[1] = HtmlEncode($this->name->CurrentValue);
			$arwrk[2] = HtmlEncode($this->mobile->CurrentValue);
			$this->name->EditValue = $this->name->displayValue($arwrk);
			$this->name->PlaceHolder = RemoveHtml($this->name->caption());

			// email
			$this->_email->EditAttrs["class"] = "form-control";
			$this->_email->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_email->AdvancedSearch->SearchValue = HtmlDecode($this->_email->AdvancedSearch->SearchValue);
			$this->_email->EditValue = HtmlEncode($this->_email->AdvancedSearch->SearchValue);
			$this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

			// gst_number
			$this->gst_number->EditAttrs["class"] = "form-control";
			$this->gst_number->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->gst_number->AdvancedSearch->SearchValue = HtmlDecode($this->gst_number->AdvancedSearch->SearchValue);
			$this->gst_number->EditValue = HtmlEncode($this->gst_number->AdvancedSearch->SearchValue);
			$this->gst_number->PlaceHolder = RemoveHtml($this->gst_number->caption());

			// category
			$this->category->EditCustomAttributes = "";
			$curVal = trim(strval($this->category->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->category->AdvancedSearch->ViewValue = $this->category->lookupCacheOption($curVal);
			else
				$this->category->AdvancedSearch->ViewValue = $this->category->Lookup !== NULL && is_array($this->category->Lookup->Options) ? $curVal : NULL;
			if ($this->category->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->category->EditValue = array_values($this->category->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->category->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->category->EditValue = $arwrk;
			}

			// last_login
			$this->last_login->EditAttrs["class"] = "form-control";
			$this->last_login->EditCustomAttributes = "";
			$this->last_login->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->last_login->AdvancedSearch->SearchValue, 0), 8));
			$this->last_login->PlaceHolder = RemoveHtml($this->last_login->caption());

			// reg_date
			$this->reg_date->EditAttrs["class"] = "form-control";
			$this->reg_date->EditCustomAttributes = "";
			$this->reg_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->reg_date->AdvancedSearch->SearchValue, 0), 8));
			$this->reg_date->PlaceHolder = RemoveHtml($this->reg_date->caption());

			// reg_device
			$this->reg_device->EditAttrs["class"] = "form-control";
			$this->reg_device->EditCustomAttributes = "";
			$this->reg_device->EditValue = HtmlEncode($this->reg_device->AdvancedSearch->SearchValue);
			$this->reg_device->PlaceHolder = RemoveHtml($this->reg_device->caption());

			// app_version
			$this->app_version->EditAttrs["class"] = "form-control";
			$this->app_version->EditCustomAttributes = "";
			$this->app_version->EditValue = HtmlEncode($this->app_version->AdvancedSearch->SearchValue);
			$this->app_version->PlaceHolder = RemoveHtml($this->app_version->caption());

			// device_id
			$this->device_id->EditAttrs["class"] = "form-control";
			$this->device_id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->device_id->AdvancedSearch->SearchValue = HtmlDecode($this->device_id->AdvancedSearch->SearchValue);
			$this->device_id->EditValue = HtmlEncode($this->device_id->AdvancedSearch->SearchValue);
			$this->device_id->PlaceHolder = RemoveHtml($this->device_id->caption());

			// device_token_id
			$this->device_token_id->EditAttrs["class"] = "form-control";
			$this->device_token_id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->device_token_id->AdvancedSearch->SearchValue = HtmlDecode($this->device_token_id->AdvancedSearch->SearchValue);
			$this->device_token_id->EditValue = HtmlEncode($this->device_token_id->AdvancedSearch->SearchValue);
			$this->device_token_id->PlaceHolder = RemoveHtml($this->device_token_id->caption());

			// cart_number
			$this->cart_number->EditAttrs["class"] = "form-control";
			$this->cart_number->EditCustomAttributes = "";
			$this->cart_number->EditValue = HtmlEncode($this->cart_number->AdvancedSearch->SearchValue);
			$this->cart_number->PlaceHolder = RemoveHtml($this->cart_number->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$this->operator->EditValue = HtmlEncode($this->operator->AdvancedSearch->SearchValue);
			$curVal = strval($this->operator->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->operator->EditValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->operator->EditValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->EditValue = HtmlEncode($this->operator->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->operator->EditValue = NULL;
			}
			$this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// max_discount
			$this->max_discount->EditAttrs["class"] = "form-control";
			$this->max_discount->EditCustomAttributes = "";
			$this->max_discount->EditValue = HtmlEncode($this->max_discount->AdvancedSearch->SearchValue);
			$this->max_discount->PlaceHolder = RemoveHtml($this->max_discount->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckDate($this->last_login->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->last_login->errorMessage());
		}
		if (!CheckDate($this->reg_date->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->reg_date->errorMessage());
		}
		if (!CheckInteger($this->reg_device->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->reg_device->errorMessage());
		}
		if (!CheckInteger($this->app_version->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->app_version->errorMessage());
		}
		if (!CheckInteger($this->cart_number->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->cart_number->errorMessage());
		}
		if (!CheckInteger($this->operator->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->operator->errorMessage());
		}
		if (!CheckDate($this->datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->datetime->errorMessage());
		}
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckNumber($this->max_discount->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->max_discount->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->mobile->AdvancedSearch->load();
		$this->user_name->AdvancedSearch->load();
		$this->password->AdvancedSearch->load();
		$this->name->AdvancedSearch->load();
		$this->_email->AdvancedSearch->load();
		$this->gst_number->AdvancedSearch->load();
		$this->category->AdvancedSearch->load();
		$this->last_login->AdvancedSearch->load();
		$this->reg_date->AdvancedSearch->load();
		$this->reg_device->AdvancedSearch->load();
		$this->app_version->AdvancedSearch->load();
		$this->device_id->AdvancedSearch->load();
		$this->device_token_id->AdvancedSearch->load();
		$this->cart_number->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->id->AdvancedSearch->load();
		$this->max_discount->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("userlist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_category":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_mobile":
							break;
						case "x_name":
							break;
						case "x_category":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'user');	
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>