<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for vehicle_info
 */
class vehicle_info extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $type;
	public $vehicle_owner;
	public $no;
	public $driver;
	public $driver_name;
	public $dor;
	public $km_hour;
	public $chassis_no;
	public $engine_no;
	public $load_average;
	public $unload_average;
	public $load_expenses;
	public $unload_expenses;
	public $insurance;
	public $state_tax;
	public $national_permit;
	public $pollution;
	public $fitness;
	public $other_due;
	public $status;
	public $operator;
	public $datetime;
	public $running_status;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'vehicle_info';
		$this->TableName = 'vehicle_info';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`vehicle_info`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('vehicle_info', 'vehicle_info', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// type
		$this->type = new DbField('vehicle_info', 'vehicle_info', 'x_type', 'type', '`type`', '`type`', 18, -1, FALSE, '`type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->type->Nullable = FALSE; // NOT NULL field
		$this->type->Sortable = TRUE; // Allow sort
		$this->type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->type->Lookup = new Lookup('type', 'vehicle_info', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->type->OptionCount = 2;
		$this->type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['type'] = &$this->type;

		// vehicle_owner
		$this->vehicle_owner = new DbField('vehicle_info', 'vehicle_info', 'x_vehicle_owner', 'vehicle_owner', '`vehicle_owner`', '`vehicle_owner`', 19, -1, FALSE, '`vehicle_owner`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->vehicle_owner->Sortable = TRUE; // Allow sort
		$this->vehicle_owner->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->vehicle_owner->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->vehicle_owner->Lookup = new Lookup('vehicle_owner', 'production_partner', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->vehicle_owner->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['vehicle_owner'] = &$this->vehicle_owner;

		// no
		$this->no = new DbField('vehicle_info', 'vehicle_info', 'x_no', 'no', '`no`', '`no`', 200, -1, FALSE, '`no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->no->Nullable = FALSE; // NOT NULL field
		$this->no->Required = TRUE; // Required field
		$this->no->Sortable = TRUE; // Allow sort
		$this->fields['no'] = &$this->no;

		// driver
		$this->driver = new DbField('vehicle_info', 'vehicle_info', 'x_driver', 'driver', '`driver`', '`driver`', 2, -1, FALSE, '`driver`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->driver->Sortable = FALSE; // Allow sort
		$this->driver->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->driver->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->driver->Lookup = new Lookup('driver', 't_driver_info', FALSE, 'id', ["name","mobile","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->driver->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['driver'] = &$this->driver;

		// driver_name
		$this->driver_name = new DbField('vehicle_info', 'vehicle_info', 'x_driver_name', 'driver_name', '`driver_name`', '`driver_name`', 200, -1, FALSE, '`driver_name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->driver_name->Sortable = TRUE; // Allow sort
		$this->fields['driver_name'] = &$this->driver_name;

		// dor
		$this->dor = new DbField('vehicle_info', 'vehicle_info', 'x_dor', 'dor', '`dor`', CastDateFieldForLike('`dor`', 0, "DB"), 133, 0, FALSE, '`dor`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->dor->Sortable = TRUE; // Allow sort
		$this->dor->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['dor'] = &$this->dor;

		// km_hour
		$this->km_hour = new DbField('vehicle_info', 'vehicle_info', 'x_km_hour', 'km_hour', '`km_hour`', '`km_hour`', 131, -1, FALSE, '`km_hour`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->km_hour->Sortable = TRUE; // Allow sort
		$this->km_hour->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['km_hour'] = &$this->km_hour;

		// chassis_no
		$this->chassis_no = new DbField('vehicle_info', 'vehicle_info', 'x_chassis_no', 'chassis_no', '`chassis_no`', '`chassis_no`', 200, -1, FALSE, '`chassis_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->chassis_no->Sortable = TRUE; // Allow sort
		$this->fields['chassis_no'] = &$this->chassis_no;

		// engine_no
		$this->engine_no = new DbField('vehicle_info', 'vehicle_info', 'x_engine_no', 'engine_no', '`engine_no`', '`engine_no`', 200, -1, FALSE, '`engine_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->engine_no->Sortable = TRUE; // Allow sort
		$this->fields['engine_no'] = &$this->engine_no;

		// load_average
		$this->load_average = new DbField('vehicle_info', 'vehicle_info', 'x_load_average', 'load_average', '`load_average`', '`load_average`', 131, -1, FALSE, '`load_average`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->load_average->Sortable = TRUE; // Allow sort
		$this->load_average->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['load_average'] = &$this->load_average;

		// unload_average
		$this->unload_average = new DbField('vehicle_info', 'vehicle_info', 'x_unload_average', 'unload_average', '`unload_average`', '`unload_average`', 131, -1, FALSE, '`unload_average`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->unload_average->Sortable = TRUE; // Allow sort
		$this->unload_average->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['unload_average'] = &$this->unload_average;

		// load_expenses
		$this->load_expenses = new DbField('vehicle_info', 'vehicle_info', 'x_load_expenses', 'load_expenses', '`load_expenses`', '`load_expenses`', 131, -1, FALSE, '`load_expenses`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->load_expenses->Sortable = TRUE; // Allow sort
		$this->load_expenses->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['load_expenses'] = &$this->load_expenses;

		// unload_expenses
		$this->unload_expenses = new DbField('vehicle_info', 'vehicle_info', 'x_unload_expenses', 'unload_expenses', '`unload_expenses`', '`unload_expenses`', 131, -1, FALSE, '`unload_expenses`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->unload_expenses->Sortable = TRUE; // Allow sort
		$this->unload_expenses->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['unload_expenses'] = &$this->unload_expenses;

		// insurance
		$this->insurance = new DbField('vehicle_info', 'vehicle_info', 'x_insurance', 'insurance', '`insurance`', CastDateFieldForLike('`insurance`', 0, "DB"), 133, 0, FALSE, '`insurance`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->insurance->Sortable = TRUE; // Allow sort
		$this->insurance->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['insurance'] = &$this->insurance;

		// state_tax
		$this->state_tax = new DbField('vehicle_info', 'vehicle_info', 'x_state_tax', 'state_tax', '`state_tax`', CastDateFieldForLike('`state_tax`', 0, "DB"), 133, 0, FALSE, '`state_tax`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->state_tax->Sortable = TRUE; // Allow sort
		$this->state_tax->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['state_tax'] = &$this->state_tax;

		// national_permit
		$this->national_permit = new DbField('vehicle_info', 'vehicle_info', 'x_national_permit', 'national_permit', '`national_permit`', CastDateFieldForLike('`national_permit`', 0, "DB"), 133, 0, FALSE, '`national_permit`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->national_permit->Sortable = TRUE; // Allow sort
		$this->national_permit->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['national_permit'] = &$this->national_permit;

		// pollution
		$this->pollution = new DbField('vehicle_info', 'vehicle_info', 'x_pollution', 'pollution', '`pollution`', CastDateFieldForLike('`pollution`', 0, "DB"), 133, 0, FALSE, '`pollution`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pollution->Sortable = TRUE; // Allow sort
		$this->pollution->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['pollution'] = &$this->pollution;

		// fitness
		$this->fitness = new DbField('vehicle_info', 'vehicle_info', 'x_fitness', 'fitness', '`fitness`', CastDateFieldForLike('`fitness`', 0, "DB"), 133, 0, FALSE, '`fitness`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fitness->Sortable = TRUE; // Allow sort
		$this->fitness->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['fitness'] = &$this->fitness;

		// other_due
		$this->other_due = new DbField('vehicle_info', 'vehicle_info', 'x_other_due', 'other_due', '`other_due`', CastDateFieldForLike('`other_due`', 0, "DB"), 133, 0, FALSE, '`other_due`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->other_due->Sortable = TRUE; // Allow sort
		$this->other_due->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['other_due'] = &$this->other_due;

		// status
		$this->status = new DbField('vehicle_info', 'vehicle_info', 'x_status', 'status', '`status`', '`status`', 17, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Nullable = FALSE; // NOT NULL field
		$this->status->Required = TRUE; // Required field
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->Lookup = new Lookup('status', 'vehicle_info', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->status->OptionCount = 2;
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// operator
		$this->operator = new DbField('vehicle_info', 'vehicle_info', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('vehicle_info', 'vehicle_info', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Nullable = FALSE; // NOT NULL field
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// running_status
		$this->running_status = new DbField('vehicle_info', 'vehicle_info', 'x_running_status', 'running_status', '`running_status`', '`running_status`', 18, -1, FALSE, '`running_status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->running_status->Nullable = FALSE; // NOT NULL field
		$this->running_status->Sortable = TRUE; // Allow sort
		$this->running_status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->running_status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->running_status->Lookup = new Lookup('running_status', 'vehicle_info', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->running_status->OptionCount = 2;
		$this->running_status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['running_status'] = &$this->running_status;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`vehicle_info`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->type->DbValue = $row['type'];
		$this->vehicle_owner->DbValue = $row['vehicle_owner'];
		$this->no->DbValue = $row['no'];
		$this->driver->DbValue = $row['driver'];
		$this->driver_name->DbValue = $row['driver_name'];
		$this->dor->DbValue = $row['dor'];
		$this->km_hour->DbValue = $row['km_hour'];
		$this->chassis_no->DbValue = $row['chassis_no'];
		$this->engine_no->DbValue = $row['engine_no'];
		$this->load_average->DbValue = $row['load_average'];
		$this->unload_average->DbValue = $row['unload_average'];
		$this->load_expenses->DbValue = $row['load_expenses'];
		$this->unload_expenses->DbValue = $row['unload_expenses'];
		$this->insurance->DbValue = $row['insurance'];
		$this->state_tax->DbValue = $row['state_tax'];
		$this->national_permit->DbValue = $row['national_permit'];
		$this->pollution->DbValue = $row['pollution'];
		$this->fitness->DbValue = $row['fitness'];
		$this->other_due->DbValue = $row['other_due'];
		$this->status->DbValue = $row['status'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->running_status->DbValue = $row['running_status'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "vehicle_infolist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "vehicle_infoview.php")
			return $Language->phrase("View");
		elseif ($pageName == "vehicle_infoedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "vehicle_infoadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "vehicle_infolist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("vehicle_infoview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("vehicle_infoview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "vehicle_infoadd.php?" . $this->getUrlParm($parm);
		else
			$url = "vehicle_infoadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("vehicle_infoedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("vehicle_infoadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("vehicle_infodelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->type->setDbValue($rs->fields('type'));
		$this->vehicle_owner->setDbValue($rs->fields('vehicle_owner'));
		$this->no->setDbValue($rs->fields('no'));
		$this->driver->setDbValue($rs->fields('driver'));
		$this->driver_name->setDbValue($rs->fields('driver_name'));
		$this->dor->setDbValue($rs->fields('dor'));
		$this->km_hour->setDbValue($rs->fields('km_hour'));
		$this->chassis_no->setDbValue($rs->fields('chassis_no'));
		$this->engine_no->setDbValue($rs->fields('engine_no'));
		$this->load_average->setDbValue($rs->fields('load_average'));
		$this->unload_average->setDbValue($rs->fields('unload_average'));
		$this->load_expenses->setDbValue($rs->fields('load_expenses'));
		$this->unload_expenses->setDbValue($rs->fields('unload_expenses'));
		$this->insurance->setDbValue($rs->fields('insurance'));
		$this->state_tax->setDbValue($rs->fields('state_tax'));
		$this->national_permit->setDbValue($rs->fields('national_permit'));
		$this->pollution->setDbValue($rs->fields('pollution'));
		$this->fitness->setDbValue($rs->fields('fitness'));
		$this->other_due->setDbValue($rs->fields('other_due'));
		$this->status->setDbValue($rs->fields('status'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->running_status->setDbValue($rs->fields('running_status'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// type
		// vehicle_owner
		// no
		// driver

		$this->driver->CellCssStyle = "white-space: nowrap;";

		// driver_name
		// dor
		// km_hour
		// chassis_no
		// engine_no
		// load_average
		// unload_average
		// load_expenses
		// unload_expenses
		// insurance
		// state_tax
		// national_permit
		// pollution
		// fitness
		// other_due
		// status
		// operator
		// datetime
		// running_status
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// type
		if (strval($this->type->CurrentValue) <> "") {
			$this->type->ViewValue = $this->type->optionCaption($this->type->CurrentValue);
		} else {
			$this->type->ViewValue = NULL;
		}
		$this->type->ViewCustomAttributes = "";

		// vehicle_owner
		$curVal = strval($this->vehicle_owner->CurrentValue);
		if ($curVal <> "") {
			$this->vehicle_owner->ViewValue = $this->vehicle_owner->lookupCacheOption($curVal);
			if ($this->vehicle_owner->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`category`= 902 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->vehicle_owner->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->vehicle_owner->ViewValue = $this->vehicle_owner->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->vehicle_owner->ViewValue = $this->vehicle_owner->CurrentValue;
				}
			}
		} else {
			$this->vehicle_owner->ViewValue = NULL;
		}
		$this->vehicle_owner->ViewCustomAttributes = "";

		// no
		$this->no->ViewValue = $this->no->CurrentValue;
		$this->no->ViewCustomAttributes = "";

		// driver
		$curVal = strval($this->driver->CurrentValue);
		if ($curVal <> "") {
			$this->driver->ViewValue = $this->driver->lookupCacheOption($curVal);
			if ($this->driver->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->driver->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->driver->ViewValue = $this->driver->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->driver->ViewValue = $this->driver->CurrentValue;
				}
			}
		} else {
			$this->driver->ViewValue = NULL;
		}
		$this->driver->ViewCustomAttributes = "";

		// driver_name
		$this->driver_name->ViewValue = $this->driver_name->CurrentValue;
		$this->driver_name->ViewCustomAttributes = "";

		// dor
		$this->dor->ViewValue = $this->dor->CurrentValue;
		$this->dor->ViewValue = FormatDateTime($this->dor->ViewValue, 0);
		$this->dor->ViewCustomAttributes = "";

		// km_hour
		$this->km_hour->ViewValue = $this->km_hour->CurrentValue;
		$this->km_hour->ViewValue = FormatNumber($this->km_hour->ViewValue, 2, -2, -2, -2);
		$this->km_hour->ViewCustomAttributes = "";

		// chassis_no
		$this->chassis_no->ViewValue = $this->chassis_no->CurrentValue;
		$this->chassis_no->ViewCustomAttributes = "";

		// engine_no
		$this->engine_no->ViewValue = $this->engine_no->CurrentValue;
		$this->engine_no->ViewCustomAttributes = "";

		// load_average
		$this->load_average->ViewValue = $this->load_average->CurrentValue;
		$this->load_average->ViewValue = FormatNumber($this->load_average->ViewValue, 2, -2, -2, -2);
		$this->load_average->ViewCustomAttributes = "";

		// unload_average
		$this->unload_average->ViewValue = $this->unload_average->CurrentValue;
		$this->unload_average->ViewValue = FormatNumber($this->unload_average->ViewValue, 2, -2, -2, -2);
		$this->unload_average->ViewCustomAttributes = "";

		// load_expenses
		$this->load_expenses->ViewValue = $this->load_expenses->CurrentValue;
		$this->load_expenses->ViewValue = FormatNumber($this->load_expenses->ViewValue, 2, -2, -2, -2);
		$this->load_expenses->ViewCustomAttributes = "";

		// unload_expenses
		$this->unload_expenses->ViewValue = $this->unload_expenses->CurrentValue;
		$this->unload_expenses->ViewValue = FormatNumber($this->unload_expenses->ViewValue, 2, -2, -2, -2);
		$this->unload_expenses->ViewCustomAttributes = "";

		// insurance
		$this->insurance->ViewValue = $this->insurance->CurrentValue;
		$this->insurance->ViewValue = FormatDateTime($this->insurance->ViewValue, 0);
		$this->insurance->ViewCustomAttributes = "";

		// state_tax
		$this->state_tax->ViewValue = $this->state_tax->CurrentValue;
		$this->state_tax->ViewValue = FormatDateTime($this->state_tax->ViewValue, 0);
		$this->state_tax->ViewCustomAttributes = "";

		// national_permit
		$this->national_permit->ViewValue = $this->national_permit->CurrentValue;
		$this->national_permit->ViewValue = FormatDateTime($this->national_permit->ViewValue, 0);
		$this->national_permit->ViewCustomAttributes = "";

		// pollution
		$this->pollution->ViewValue = $this->pollution->CurrentValue;
		$this->pollution->ViewValue = FormatDateTime($this->pollution->ViewValue, 0);
		$this->pollution->ViewCustomAttributes = "";

		// fitness
		$this->fitness->ViewValue = $this->fitness->CurrentValue;
		$this->fitness->ViewValue = FormatDateTime($this->fitness->ViewValue, 0);
		$this->fitness->ViewCustomAttributes = "";

		// other_due
		$this->other_due->ViewValue = $this->other_due->CurrentValue;
		$this->other_due->ViewValue = FormatDateTime($this->other_due->ViewValue, 0);
		$this->other_due->ViewCustomAttributes = "";

		// status
		if (strval($this->status->CurrentValue) <> "") {
			$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// running_status
		if (strval($this->running_status->CurrentValue) <> "") {
			$this->running_status->ViewValue = $this->running_status->optionCaption($this->running_status->CurrentValue);
		} else {
			$this->running_status->ViewValue = NULL;
		}
		$this->running_status->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// type
		$this->type->LinkCustomAttributes = "";
		$this->type->HrefValue = "";
		$this->type->TooltipValue = "";

		// vehicle_owner
		$this->vehicle_owner->LinkCustomAttributes = "";
		$this->vehicle_owner->HrefValue = "";
		$this->vehicle_owner->TooltipValue = "";

		// no
		$this->no->LinkCustomAttributes = "";
		$this->no->HrefValue = "";
		$this->no->TooltipValue = "";

		// driver
		$this->driver->LinkCustomAttributes = "";
		$this->driver->HrefValue = "";
		$this->driver->TooltipValue = "";

		// driver_name
		$this->driver_name->LinkCustomAttributes = "";
		$this->driver_name->HrefValue = "";
		$this->driver_name->TooltipValue = "";

		// dor
		$this->dor->LinkCustomAttributes = "";
		$this->dor->HrefValue = "";
		$this->dor->TooltipValue = "";

		// km_hour
		$this->km_hour->LinkCustomAttributes = "";
		$this->km_hour->HrefValue = "";
		$this->km_hour->TooltipValue = "";

		// chassis_no
		$this->chassis_no->LinkCustomAttributes = "";
		$this->chassis_no->HrefValue = "";
		$this->chassis_no->TooltipValue = "";

		// engine_no
		$this->engine_no->LinkCustomAttributes = "";
		$this->engine_no->HrefValue = "";
		$this->engine_no->TooltipValue = "";

		// load_average
		$this->load_average->LinkCustomAttributes = "";
		$this->load_average->HrefValue = "";
		$this->load_average->TooltipValue = "";

		// unload_average
		$this->unload_average->LinkCustomAttributes = "";
		$this->unload_average->HrefValue = "";
		$this->unload_average->TooltipValue = "";

		// load_expenses
		$this->load_expenses->LinkCustomAttributes = "";
		$this->load_expenses->HrefValue = "";
		$this->load_expenses->TooltipValue = "";

		// unload_expenses
		$this->unload_expenses->LinkCustomAttributes = "";
		$this->unload_expenses->HrefValue = "";
		$this->unload_expenses->TooltipValue = "";

		// insurance
		$this->insurance->LinkCustomAttributes = "";
		$this->insurance->HrefValue = "";
		$this->insurance->TooltipValue = "";

		// state_tax
		$this->state_tax->LinkCustomAttributes = "";
		$this->state_tax->HrefValue = "";
		$this->state_tax->TooltipValue = "";

		// national_permit
		$this->national_permit->LinkCustomAttributes = "";
		$this->national_permit->HrefValue = "";
		$this->national_permit->TooltipValue = "";

		// pollution
		$this->pollution->LinkCustomAttributes = "";
		$this->pollution->HrefValue = "";
		$this->pollution->TooltipValue = "";

		// fitness
		$this->fitness->LinkCustomAttributes = "";
		$this->fitness->HrefValue = "";
		$this->fitness->TooltipValue = "";

		// other_due
		$this->other_due->LinkCustomAttributes = "";
		$this->other_due->HrefValue = "";
		$this->other_due->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// running_status
		$this->running_status->LinkCustomAttributes = "";
		$this->running_status->HrefValue = "";
		$this->running_status->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// type
		$this->type->EditAttrs["class"] = "form-control";
		$this->type->EditCustomAttributes = "";
		$this->type->EditValue = $this->type->options(TRUE);

		// vehicle_owner
		$this->vehicle_owner->EditAttrs["class"] = "form-control";
		$this->vehicle_owner->EditCustomAttributes = "";

		// no
		$this->no->EditAttrs["class"] = "form-control";
		$this->no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->no->CurrentValue = HtmlDecode($this->no->CurrentValue);
		$this->no->EditValue = $this->no->CurrentValue;
		$this->no->PlaceHolder = RemoveHtml($this->no->caption());

		// driver
		$this->driver->EditAttrs["class"] = "form-control";
		$this->driver->EditCustomAttributes = "";

		// driver_name
		$this->driver_name->EditAttrs["class"] = "form-control";
		$this->driver_name->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->driver_name->CurrentValue = HtmlDecode($this->driver_name->CurrentValue);
		$this->driver_name->EditValue = $this->driver_name->CurrentValue;
		$this->driver_name->PlaceHolder = RemoveHtml($this->driver_name->caption());

		// dor
		$this->dor->EditAttrs["class"] = "form-control";
		$this->dor->EditCustomAttributes = "";
		$this->dor->EditValue = FormatDateTime($this->dor->CurrentValue, 8);
		$this->dor->PlaceHolder = RemoveHtml($this->dor->caption());

		// km_hour
		$this->km_hour->EditAttrs["class"] = "form-control";
		$this->km_hour->EditCustomAttributes = "";
		$this->km_hour->EditValue = $this->km_hour->CurrentValue;
		$this->km_hour->PlaceHolder = RemoveHtml($this->km_hour->caption());
		if (strval($this->km_hour->EditValue) <> "" && is_numeric($this->km_hour->EditValue))
			$this->km_hour->EditValue = FormatNumber($this->km_hour->EditValue, -2, -2, -2, -2);

		// chassis_no
		$this->chassis_no->EditAttrs["class"] = "form-control";
		$this->chassis_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->chassis_no->CurrentValue = HtmlDecode($this->chassis_no->CurrentValue);
		$this->chassis_no->EditValue = $this->chassis_no->CurrentValue;
		$this->chassis_no->PlaceHolder = RemoveHtml($this->chassis_no->caption());

		// engine_no
		$this->engine_no->EditAttrs["class"] = "form-control";
		$this->engine_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->engine_no->CurrentValue = HtmlDecode($this->engine_no->CurrentValue);
		$this->engine_no->EditValue = $this->engine_no->CurrentValue;
		$this->engine_no->PlaceHolder = RemoveHtml($this->engine_no->caption());

		// load_average
		$this->load_average->EditAttrs["class"] = "form-control";
		$this->load_average->EditCustomAttributes = "";
		$this->load_average->EditValue = $this->load_average->CurrentValue;
		$this->load_average->PlaceHolder = RemoveHtml($this->load_average->caption());
		if (strval($this->load_average->EditValue) <> "" && is_numeric($this->load_average->EditValue))
			$this->load_average->EditValue = FormatNumber($this->load_average->EditValue, -2, -2, -2, -2);

		// unload_average
		$this->unload_average->EditAttrs["class"] = "form-control";
		$this->unload_average->EditCustomAttributes = "";
		$this->unload_average->EditValue = $this->unload_average->CurrentValue;
		$this->unload_average->PlaceHolder = RemoveHtml($this->unload_average->caption());
		if (strval($this->unload_average->EditValue) <> "" && is_numeric($this->unload_average->EditValue))
			$this->unload_average->EditValue = FormatNumber($this->unload_average->EditValue, -2, -2, -2, -2);

		// load_expenses
		$this->load_expenses->EditAttrs["class"] = "form-control";
		$this->load_expenses->EditCustomAttributes = "";
		$this->load_expenses->EditValue = $this->load_expenses->CurrentValue;
		$this->load_expenses->PlaceHolder = RemoveHtml($this->load_expenses->caption());
		if (strval($this->load_expenses->EditValue) <> "" && is_numeric($this->load_expenses->EditValue))
			$this->load_expenses->EditValue = FormatNumber($this->load_expenses->EditValue, -2, -2, -2, -2);

		// unload_expenses
		$this->unload_expenses->EditAttrs["class"] = "form-control";
		$this->unload_expenses->EditCustomAttributes = "";
		$this->unload_expenses->EditValue = $this->unload_expenses->CurrentValue;
		$this->unload_expenses->PlaceHolder = RemoveHtml($this->unload_expenses->caption());
		if (strval($this->unload_expenses->EditValue) <> "" && is_numeric($this->unload_expenses->EditValue))
			$this->unload_expenses->EditValue = FormatNumber($this->unload_expenses->EditValue, -2, -2, -2, -2);

		// insurance
		$this->insurance->EditAttrs["class"] = "form-control";
		$this->insurance->EditCustomAttributes = "";
		$this->insurance->EditValue = FormatDateTime($this->insurance->CurrentValue, 8);
		$this->insurance->PlaceHolder = RemoveHtml($this->insurance->caption());

		// state_tax
		$this->state_tax->EditAttrs["class"] = "form-control";
		$this->state_tax->EditCustomAttributes = "";
		$this->state_tax->EditValue = FormatDateTime($this->state_tax->CurrentValue, 8);
		$this->state_tax->PlaceHolder = RemoveHtml($this->state_tax->caption());

		// national_permit
		$this->national_permit->EditAttrs["class"] = "form-control";
		$this->national_permit->EditCustomAttributes = "";
		$this->national_permit->EditValue = FormatDateTime($this->national_permit->CurrentValue, 8);
		$this->national_permit->PlaceHolder = RemoveHtml($this->national_permit->caption());

		// pollution
		$this->pollution->EditAttrs["class"] = "form-control";
		$this->pollution->EditCustomAttributes = "";
		$this->pollution->EditValue = FormatDateTime($this->pollution->CurrentValue, 8);
		$this->pollution->PlaceHolder = RemoveHtml($this->pollution->caption());

		// fitness
		$this->fitness->EditAttrs["class"] = "form-control";
		$this->fitness->EditCustomAttributes = "";
		$this->fitness->EditValue = FormatDateTime($this->fitness->CurrentValue, 8);
		$this->fitness->PlaceHolder = RemoveHtml($this->fitness->caption());

		// other_due
		$this->other_due->EditAttrs["class"] = "form-control";
		$this->other_due->EditCustomAttributes = "";
		$this->other_due->EditValue = FormatDateTime($this->other_due->CurrentValue, 8);
		$this->other_due->PlaceHolder = RemoveHtml($this->other_due->caption());

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		$this->status->EditValue = $this->status->options(TRUE);

		// operator
		// datetime
		// running_status

		$this->running_status->EditAttrs["class"] = "form-control";
		$this->running_status->EditCustomAttributes = "";
		if (strval($this->running_status->CurrentValue) <> "") {
			$this->running_status->EditValue = $this->running_status->optionCaption($this->running_status->CurrentValue);
		} else {
			$this->running_status->EditValue = NULL;
		}
		$this->running_status->ViewCustomAttributes = "";

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->type);
					$doc->exportCaption($this->vehicle_owner);
					$doc->exportCaption($this->no);
					$doc->exportCaption($this->driver_name);
					$doc->exportCaption($this->dor);
					$doc->exportCaption($this->km_hour);
					$doc->exportCaption($this->chassis_no);
					$doc->exportCaption($this->engine_no);
					$doc->exportCaption($this->load_average);
					$doc->exportCaption($this->unload_average);
					$doc->exportCaption($this->load_expenses);
					$doc->exportCaption($this->unload_expenses);
					$doc->exportCaption($this->insurance);
					$doc->exportCaption($this->state_tax);
					$doc->exportCaption($this->national_permit);
					$doc->exportCaption($this->pollution);
					$doc->exportCaption($this->fitness);
					$doc->exportCaption($this->other_due);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->running_status);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->type);
					$doc->exportCaption($this->vehicle_owner);
					$doc->exportCaption($this->no);
					$doc->exportCaption($this->driver_name);
					$doc->exportCaption($this->dor);
					$doc->exportCaption($this->km_hour);
					$doc->exportCaption($this->chassis_no);
					$doc->exportCaption($this->engine_no);
					$doc->exportCaption($this->load_average);
					$doc->exportCaption($this->unload_average);
					$doc->exportCaption($this->load_expenses);
					$doc->exportCaption($this->unload_expenses);
					$doc->exportCaption($this->insurance);
					$doc->exportCaption($this->state_tax);
					$doc->exportCaption($this->national_permit);
					$doc->exportCaption($this->pollution);
					$doc->exportCaption($this->fitness);
					$doc->exportCaption($this->other_due);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->running_status);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->type);
						$doc->exportField($this->vehicle_owner);
						$doc->exportField($this->no);
						$doc->exportField($this->driver_name);
						$doc->exportField($this->dor);
						$doc->exportField($this->km_hour);
						$doc->exportField($this->chassis_no);
						$doc->exportField($this->engine_no);
						$doc->exportField($this->load_average);
						$doc->exportField($this->unload_average);
						$doc->exportField($this->load_expenses);
						$doc->exportField($this->unload_expenses);
						$doc->exportField($this->insurance);
						$doc->exportField($this->state_tax);
						$doc->exportField($this->national_permit);
						$doc->exportField($this->pollution);
						$doc->exportField($this->fitness);
						$doc->exportField($this->other_due);
						$doc->exportField($this->status);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->running_status);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->type);
						$doc->exportField($this->vehicle_owner);
						$doc->exportField($this->no);
						$doc->exportField($this->driver_name);
						$doc->exportField($this->dor);
						$doc->exportField($this->km_hour);
						$doc->exportField($this->chassis_no);
						$doc->exportField($this->engine_no);
						$doc->exportField($this->load_average);
						$doc->exportField($this->unload_average);
						$doc->exportField($this->load_expenses);
						$doc->exportField($this->unload_expenses);
						$doc->exportField($this->insurance);
						$doc->exportField($this->state_tax);
						$doc->exportField($this->national_permit);
						$doc->exportField($this->pollution);
						$doc->exportField($this->fitness);
						$doc->exportField($this->other_due);
						$doc->exportField($this->status);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->running_status);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>