<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class vehicle_info_add extends vehicle_info
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'vehicle_info';

	// Page object name
	public $PageObjName = "vehicle_info_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (vehicle_info)
		if (!isset($GLOBALS["vehicle_info"]) || get_class($GLOBALS["vehicle_info"]) == PROJECT_NAMESPACE . "vehicle_info") {
			$GLOBALS["vehicle_info"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["vehicle_info"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'vehicle_info');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $vehicle_info;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($vehicle_info);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "vehicle_infoview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("vehicle_infolist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->type->setVisibility();
		$this->vehicle_owner->setVisibility();
		$this->no->setVisibility();
		$this->driver->setVisibility();
		$this->driver_name->setVisibility();
		$this->dor->setVisibility();
		$this->km_hour->setVisibility();
		$this->chassis_no->setVisibility();
		$this->engine_no->setVisibility();
		$this->load_average->setVisibility();
		$this->unload_average->setVisibility();
		$this->load_expenses->setVisibility();
		$this->unload_expenses->setVisibility();
		$this->insurance->setVisibility();
		$this->state_tax->setVisibility();
		$this->national_permit->setVisibility();
		$this->pollution->setVisibility();
		$this->fitness->setVisibility();
		$this->other_due->setVisibility();
		$this->status->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->running_status->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->vehicle_owner);
		$this->setupLookupOptions($this->driver);
		$this->setupLookupOptions($this->operator);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("vehicle_infolist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "vehicle_infolist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "vehicle_infoview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->type->CurrentValue = 1;
		$this->vehicle_owner->CurrentValue = NULL;
		$this->vehicle_owner->OldValue = $this->vehicle_owner->CurrentValue;
		$this->no->CurrentValue = NULL;
		$this->no->OldValue = $this->no->CurrentValue;
		$this->driver->CurrentValue = NULL;
		$this->driver->OldValue = $this->driver->CurrentValue;
		$this->driver_name->CurrentValue = NULL;
		$this->driver_name->OldValue = $this->driver_name->CurrentValue;
		$this->dor->CurrentValue = NULL;
		$this->dor->OldValue = $this->dor->CurrentValue;
		$this->km_hour->CurrentValue = 0.00;
		$this->chassis_no->CurrentValue = NULL;
		$this->chassis_no->OldValue = $this->chassis_no->CurrentValue;
		$this->engine_no->CurrentValue = NULL;
		$this->engine_no->OldValue = $this->engine_no->CurrentValue;
		$this->load_average->CurrentValue = NULL;
		$this->load_average->OldValue = $this->load_average->CurrentValue;
		$this->unload_average->CurrentValue = NULL;
		$this->unload_average->OldValue = $this->unload_average->CurrentValue;
		$this->load_expenses->CurrentValue = NULL;
		$this->load_expenses->OldValue = $this->load_expenses->CurrentValue;
		$this->unload_expenses->CurrentValue = NULL;
		$this->unload_expenses->OldValue = $this->unload_expenses->CurrentValue;
		$this->insurance->CurrentValue = NULL;
		$this->insurance->OldValue = $this->insurance->CurrentValue;
		$this->state_tax->CurrentValue = NULL;
		$this->state_tax->OldValue = $this->state_tax->CurrentValue;
		$this->national_permit->CurrentValue = NULL;
		$this->national_permit->OldValue = $this->national_permit->CurrentValue;
		$this->pollution->CurrentValue = NULL;
		$this->pollution->OldValue = $this->pollution->CurrentValue;
		$this->fitness->CurrentValue = NULL;
		$this->fitness->OldValue = $this->fitness->CurrentValue;
		$this->other_due->CurrentValue = NULL;
		$this->other_due->OldValue = $this->other_due->CurrentValue;
		$this->status->CurrentValue = 1;
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
		$this->running_status->CurrentValue = 0;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'type' first before field var 'x_type'
		$val = $CurrentForm->hasValue("type") ? $CurrentForm->getValue("type") : $CurrentForm->getValue("x_type");
		if (!$this->type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->type->Visible = FALSE; // Disable update for API request
			else
				$this->type->setFormValue($val);
		}

		// Check field name 'vehicle_owner' first before field var 'x_vehicle_owner'
		$val = $CurrentForm->hasValue("vehicle_owner") ? $CurrentForm->getValue("vehicle_owner") : $CurrentForm->getValue("x_vehicle_owner");
		if (!$this->vehicle_owner->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->vehicle_owner->Visible = FALSE; // Disable update for API request
			else
				$this->vehicle_owner->setFormValue($val);
		}

		// Check field name 'no' first before field var 'x_no'
		$val = $CurrentForm->hasValue("no") ? $CurrentForm->getValue("no") : $CurrentForm->getValue("x_no");
		if (!$this->no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->no->Visible = FALSE; // Disable update for API request
			else
				$this->no->setFormValue($val);
		}

		// Check field name 'driver' first before field var 'x_driver'
		$val = $CurrentForm->hasValue("driver") ? $CurrentForm->getValue("driver") : $CurrentForm->getValue("x_driver");
		if (!$this->driver->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->driver->Visible = FALSE; // Disable update for API request
			else
				$this->driver->setFormValue($val);
		}

		// Check field name 'driver_name' first before field var 'x_driver_name'
		$val = $CurrentForm->hasValue("driver_name") ? $CurrentForm->getValue("driver_name") : $CurrentForm->getValue("x_driver_name");
		if (!$this->driver_name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->driver_name->Visible = FALSE; // Disable update for API request
			else
				$this->driver_name->setFormValue($val);
		}

		// Check field name 'dor' first before field var 'x_dor'
		$val = $CurrentForm->hasValue("dor") ? $CurrentForm->getValue("dor") : $CurrentForm->getValue("x_dor");
		if (!$this->dor->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->dor->Visible = FALSE; // Disable update for API request
			else
				$this->dor->setFormValue($val);
			$this->dor->CurrentValue = UnFormatDateTime($this->dor->CurrentValue, 0);
		}

		// Check field name 'km_hour' first before field var 'x_km_hour'
		$val = $CurrentForm->hasValue("km_hour") ? $CurrentForm->getValue("km_hour") : $CurrentForm->getValue("x_km_hour");
		if (!$this->km_hour->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->km_hour->Visible = FALSE; // Disable update for API request
			else
				$this->km_hour->setFormValue($val);
		}

		// Check field name 'chassis_no' first before field var 'x_chassis_no'
		$val = $CurrentForm->hasValue("chassis_no") ? $CurrentForm->getValue("chassis_no") : $CurrentForm->getValue("x_chassis_no");
		if (!$this->chassis_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->chassis_no->Visible = FALSE; // Disable update for API request
			else
				$this->chassis_no->setFormValue($val);
		}

		// Check field name 'engine_no' first before field var 'x_engine_no'
		$val = $CurrentForm->hasValue("engine_no") ? $CurrentForm->getValue("engine_no") : $CurrentForm->getValue("x_engine_no");
		if (!$this->engine_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->engine_no->Visible = FALSE; // Disable update for API request
			else
				$this->engine_no->setFormValue($val);
		}

		// Check field name 'load_average' first before field var 'x_load_average'
		$val = $CurrentForm->hasValue("load_average") ? $CurrentForm->getValue("load_average") : $CurrentForm->getValue("x_load_average");
		if (!$this->load_average->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->load_average->Visible = FALSE; // Disable update for API request
			else
				$this->load_average->setFormValue($val);
		}

		// Check field name 'unload_average' first before field var 'x_unload_average'
		$val = $CurrentForm->hasValue("unload_average") ? $CurrentForm->getValue("unload_average") : $CurrentForm->getValue("x_unload_average");
		if (!$this->unload_average->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->unload_average->Visible = FALSE; // Disable update for API request
			else
				$this->unload_average->setFormValue($val);
		}

		// Check field name 'load_expenses' first before field var 'x_load_expenses'
		$val = $CurrentForm->hasValue("load_expenses") ? $CurrentForm->getValue("load_expenses") : $CurrentForm->getValue("x_load_expenses");
		if (!$this->load_expenses->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->load_expenses->Visible = FALSE; // Disable update for API request
			else
				$this->load_expenses->setFormValue($val);
		}

		// Check field name 'unload_expenses' first before field var 'x_unload_expenses'
		$val = $CurrentForm->hasValue("unload_expenses") ? $CurrentForm->getValue("unload_expenses") : $CurrentForm->getValue("x_unload_expenses");
		if (!$this->unload_expenses->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->unload_expenses->Visible = FALSE; // Disable update for API request
			else
				$this->unload_expenses->setFormValue($val);
		}

		// Check field name 'insurance' first before field var 'x_insurance'
		$val = $CurrentForm->hasValue("insurance") ? $CurrentForm->getValue("insurance") : $CurrentForm->getValue("x_insurance");
		if (!$this->insurance->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->insurance->Visible = FALSE; // Disable update for API request
			else
				$this->insurance->setFormValue($val);
			$this->insurance->CurrentValue = UnFormatDateTime($this->insurance->CurrentValue, 0);
		}

		// Check field name 'state_tax' first before field var 'x_state_tax'
		$val = $CurrentForm->hasValue("state_tax") ? $CurrentForm->getValue("state_tax") : $CurrentForm->getValue("x_state_tax");
		if (!$this->state_tax->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->state_tax->Visible = FALSE; // Disable update for API request
			else
				$this->state_tax->setFormValue($val);
			$this->state_tax->CurrentValue = UnFormatDateTime($this->state_tax->CurrentValue, 0);
		}

		// Check field name 'national_permit' first before field var 'x_national_permit'
		$val = $CurrentForm->hasValue("national_permit") ? $CurrentForm->getValue("national_permit") : $CurrentForm->getValue("x_national_permit");
		if (!$this->national_permit->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->national_permit->Visible = FALSE; // Disable update for API request
			else
				$this->national_permit->setFormValue($val);
			$this->national_permit->CurrentValue = UnFormatDateTime($this->national_permit->CurrentValue, 0);
		}

		// Check field name 'pollution' first before field var 'x_pollution'
		$val = $CurrentForm->hasValue("pollution") ? $CurrentForm->getValue("pollution") : $CurrentForm->getValue("x_pollution");
		if (!$this->pollution->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pollution->Visible = FALSE; // Disable update for API request
			else
				$this->pollution->setFormValue($val);
			$this->pollution->CurrentValue = UnFormatDateTime($this->pollution->CurrentValue, 0);
		}

		// Check field name 'fitness' first before field var 'x_fitness'
		$val = $CurrentForm->hasValue("fitness") ? $CurrentForm->getValue("fitness") : $CurrentForm->getValue("x_fitness");
		if (!$this->fitness->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->fitness->Visible = FALSE; // Disable update for API request
			else
				$this->fitness->setFormValue($val);
			$this->fitness->CurrentValue = UnFormatDateTime($this->fitness->CurrentValue, 0);
		}

		// Check field name 'other_due' first before field var 'x_other_due'
		$val = $CurrentForm->hasValue("other_due") ? $CurrentForm->getValue("other_due") : $CurrentForm->getValue("x_other_due");
		if (!$this->other_due->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->other_due->Visible = FALSE; // Disable update for API request
			else
				$this->other_due->setFormValue($val);
			$this->other_due->CurrentValue = UnFormatDateTime($this->other_due->CurrentValue, 0);
		}

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status->Visible = FALSE; // Disable update for API request
			else
				$this->status->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->type->CurrentValue = $this->type->FormValue;
		$this->vehicle_owner->CurrentValue = $this->vehicle_owner->FormValue;
		$this->no->CurrentValue = $this->no->FormValue;
		$this->driver->CurrentValue = $this->driver->FormValue;
		$this->driver_name->CurrentValue = $this->driver_name->FormValue;
		$this->dor->CurrentValue = $this->dor->FormValue;
		$this->dor->CurrentValue = UnFormatDateTime($this->dor->CurrentValue, 0);
		$this->km_hour->CurrentValue = $this->km_hour->FormValue;
		$this->chassis_no->CurrentValue = $this->chassis_no->FormValue;
		$this->engine_no->CurrentValue = $this->engine_no->FormValue;
		$this->load_average->CurrentValue = $this->load_average->FormValue;
		$this->unload_average->CurrentValue = $this->unload_average->FormValue;
		$this->load_expenses->CurrentValue = $this->load_expenses->FormValue;
		$this->unload_expenses->CurrentValue = $this->unload_expenses->FormValue;
		$this->insurance->CurrentValue = $this->insurance->FormValue;
		$this->insurance->CurrentValue = UnFormatDateTime($this->insurance->CurrentValue, 0);
		$this->state_tax->CurrentValue = $this->state_tax->FormValue;
		$this->state_tax->CurrentValue = UnFormatDateTime($this->state_tax->CurrentValue, 0);
		$this->national_permit->CurrentValue = $this->national_permit->FormValue;
		$this->national_permit->CurrentValue = UnFormatDateTime($this->national_permit->CurrentValue, 0);
		$this->pollution->CurrentValue = $this->pollution->FormValue;
		$this->pollution->CurrentValue = UnFormatDateTime($this->pollution->CurrentValue, 0);
		$this->fitness->CurrentValue = $this->fitness->FormValue;
		$this->fitness->CurrentValue = UnFormatDateTime($this->fitness->CurrentValue, 0);
		$this->other_due->CurrentValue = $this->other_due->FormValue;
		$this->other_due->CurrentValue = UnFormatDateTime($this->other_due->CurrentValue, 0);
		$this->status->CurrentValue = $this->status->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->type->setDbValue($row['type']);
		$this->vehicle_owner->setDbValue($row['vehicle_owner']);
		$this->no->setDbValue($row['no']);
		$this->driver->setDbValue($row['driver']);
		$this->driver_name->setDbValue($row['driver_name']);
		$this->dor->setDbValue($row['dor']);
		$this->km_hour->setDbValue($row['km_hour']);
		$this->chassis_no->setDbValue($row['chassis_no']);
		$this->engine_no->setDbValue($row['engine_no']);
		$this->load_average->setDbValue($row['load_average']);
		$this->unload_average->setDbValue($row['unload_average']);
		$this->load_expenses->setDbValue($row['load_expenses']);
		$this->unload_expenses->setDbValue($row['unload_expenses']);
		$this->insurance->setDbValue($row['insurance']);
		$this->state_tax->setDbValue($row['state_tax']);
		$this->national_permit->setDbValue($row['national_permit']);
		$this->pollution->setDbValue($row['pollution']);
		$this->fitness->setDbValue($row['fitness']);
		$this->other_due->setDbValue($row['other_due']);
		$this->status->setDbValue($row['status']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->running_status->setDbValue($row['running_status']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['type'] = $this->type->CurrentValue;
		$row['vehicle_owner'] = $this->vehicle_owner->CurrentValue;
		$row['no'] = $this->no->CurrentValue;
		$row['driver'] = $this->driver->CurrentValue;
		$row['driver_name'] = $this->driver_name->CurrentValue;
		$row['dor'] = $this->dor->CurrentValue;
		$row['km_hour'] = $this->km_hour->CurrentValue;
		$row['chassis_no'] = $this->chassis_no->CurrentValue;
		$row['engine_no'] = $this->engine_no->CurrentValue;
		$row['load_average'] = $this->load_average->CurrentValue;
		$row['unload_average'] = $this->unload_average->CurrentValue;
		$row['load_expenses'] = $this->load_expenses->CurrentValue;
		$row['unload_expenses'] = $this->unload_expenses->CurrentValue;
		$row['insurance'] = $this->insurance->CurrentValue;
		$row['state_tax'] = $this->state_tax->CurrentValue;
		$row['national_permit'] = $this->national_permit->CurrentValue;
		$row['pollution'] = $this->pollution->CurrentValue;
		$row['fitness'] = $this->fitness->CurrentValue;
		$row['other_due'] = $this->other_due->CurrentValue;
		$row['status'] = $this->status->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		$row['running_status'] = $this->running_status->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->km_hour->FormValue == $this->km_hour->CurrentValue && is_numeric(ConvertToFloatString($this->km_hour->CurrentValue)))
			$this->km_hour->CurrentValue = ConvertToFloatString($this->km_hour->CurrentValue);

		// Convert decimal values if posted back
		if ($this->load_average->FormValue == $this->load_average->CurrentValue && is_numeric(ConvertToFloatString($this->load_average->CurrentValue)))
			$this->load_average->CurrentValue = ConvertToFloatString($this->load_average->CurrentValue);

		// Convert decimal values if posted back
		if ($this->unload_average->FormValue == $this->unload_average->CurrentValue && is_numeric(ConvertToFloatString($this->unload_average->CurrentValue)))
			$this->unload_average->CurrentValue = ConvertToFloatString($this->unload_average->CurrentValue);

		// Convert decimal values if posted back
		if ($this->load_expenses->FormValue == $this->load_expenses->CurrentValue && is_numeric(ConvertToFloatString($this->load_expenses->CurrentValue)))
			$this->load_expenses->CurrentValue = ConvertToFloatString($this->load_expenses->CurrentValue);

		// Convert decimal values if posted back
		if ($this->unload_expenses->FormValue == $this->unload_expenses->CurrentValue && is_numeric(ConvertToFloatString($this->unload_expenses->CurrentValue)))
			$this->unload_expenses->CurrentValue = ConvertToFloatString($this->unload_expenses->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// type
		// vehicle_owner
		// no
		// driver
		// driver_name
		// dor
		// km_hour
		// chassis_no
		// engine_no
		// load_average
		// unload_average
		// load_expenses
		// unload_expenses
		// insurance
		// state_tax
		// national_permit
		// pollution
		// fitness
		// other_due
		// status
		// operator
		// datetime
		// running_status

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// type
			if (strval($this->type->CurrentValue) <> "") {
				$this->type->ViewValue = $this->type->optionCaption($this->type->CurrentValue);
			} else {
				$this->type->ViewValue = NULL;
			}
			$this->type->ViewCustomAttributes = "";

			// vehicle_owner
			$curVal = strval($this->vehicle_owner->CurrentValue);
			if ($curVal <> "") {
				$this->vehicle_owner->ViewValue = $this->vehicle_owner->lookupCacheOption($curVal);
				if ($this->vehicle_owner->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category`= 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->vehicle_owner->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->vehicle_owner->ViewValue = $this->vehicle_owner->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->vehicle_owner->ViewValue = $this->vehicle_owner->CurrentValue;
					}
				}
			} else {
				$this->vehicle_owner->ViewValue = NULL;
			}
			$this->vehicle_owner->ViewCustomAttributes = "";

			// no
			$this->no->ViewValue = $this->no->CurrentValue;
			$this->no->ViewCustomAttributes = "";

			// driver
			$curVal = strval($this->driver->CurrentValue);
			if ($curVal <> "") {
				$this->driver->ViewValue = $this->driver->lookupCacheOption($curVal);
				if ($this->driver->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->driver->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->driver->ViewValue = $this->driver->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->driver->ViewValue = $this->driver->CurrentValue;
					}
				}
			} else {
				$this->driver->ViewValue = NULL;
			}
			$this->driver->ViewCustomAttributes = "";

			// driver_name
			$this->driver_name->ViewValue = $this->driver_name->CurrentValue;
			$this->driver_name->ViewCustomAttributes = "";

			// dor
			$this->dor->ViewValue = $this->dor->CurrentValue;
			$this->dor->ViewValue = FormatDateTime($this->dor->ViewValue, 0);
			$this->dor->ViewCustomAttributes = "";

			// km_hour
			$this->km_hour->ViewValue = $this->km_hour->CurrentValue;
			$this->km_hour->ViewValue = FormatNumber($this->km_hour->ViewValue, 2, -2, -2, -2);
			$this->km_hour->ViewCustomAttributes = "";

			// chassis_no
			$this->chassis_no->ViewValue = $this->chassis_no->CurrentValue;
			$this->chassis_no->ViewCustomAttributes = "";

			// engine_no
			$this->engine_no->ViewValue = $this->engine_no->CurrentValue;
			$this->engine_no->ViewCustomAttributes = "";

			// load_average
			$this->load_average->ViewValue = $this->load_average->CurrentValue;
			$this->load_average->ViewValue = FormatNumber($this->load_average->ViewValue, 2, -2, -2, -2);
			$this->load_average->ViewCustomAttributes = "";

			// unload_average
			$this->unload_average->ViewValue = $this->unload_average->CurrentValue;
			$this->unload_average->ViewValue = FormatNumber($this->unload_average->ViewValue, 2, -2, -2, -2);
			$this->unload_average->ViewCustomAttributes = "";

			// load_expenses
			$this->load_expenses->ViewValue = $this->load_expenses->CurrentValue;
			$this->load_expenses->ViewValue = FormatNumber($this->load_expenses->ViewValue, 2, -2, -2, -2);
			$this->load_expenses->ViewCustomAttributes = "";

			// unload_expenses
			$this->unload_expenses->ViewValue = $this->unload_expenses->CurrentValue;
			$this->unload_expenses->ViewValue = FormatNumber($this->unload_expenses->ViewValue, 2, -2, -2, -2);
			$this->unload_expenses->ViewCustomAttributes = "";

			// insurance
			$this->insurance->ViewValue = $this->insurance->CurrentValue;
			$this->insurance->ViewValue = FormatDateTime($this->insurance->ViewValue, 0);
			$this->insurance->ViewCustomAttributes = "";

			// state_tax
			$this->state_tax->ViewValue = $this->state_tax->CurrentValue;
			$this->state_tax->ViewValue = FormatDateTime($this->state_tax->ViewValue, 0);
			$this->state_tax->ViewCustomAttributes = "";

			// national_permit
			$this->national_permit->ViewValue = $this->national_permit->CurrentValue;
			$this->national_permit->ViewValue = FormatDateTime($this->national_permit->ViewValue, 0);
			$this->national_permit->ViewCustomAttributes = "";

			// pollution
			$this->pollution->ViewValue = $this->pollution->CurrentValue;
			$this->pollution->ViewValue = FormatDateTime($this->pollution->ViewValue, 0);
			$this->pollution->ViewCustomAttributes = "";

			// fitness
			$this->fitness->ViewValue = $this->fitness->CurrentValue;
			$this->fitness->ViewValue = FormatDateTime($this->fitness->ViewValue, 0);
			$this->fitness->ViewCustomAttributes = "";

			// other_due
			$this->other_due->ViewValue = $this->other_due->CurrentValue;
			$this->other_due->ViewValue = FormatDateTime($this->other_due->ViewValue, 0);
			$this->other_due->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// running_status
			if (strval($this->running_status->CurrentValue) <> "") {
				$this->running_status->ViewValue = $this->running_status->optionCaption($this->running_status->CurrentValue);
			} else {
				$this->running_status->ViewValue = NULL;
			}
			$this->running_status->ViewCustomAttributes = "";

			// type
			$this->type->LinkCustomAttributes = "";
			$this->type->HrefValue = "";
			$this->type->TooltipValue = "";

			// vehicle_owner
			$this->vehicle_owner->LinkCustomAttributes = "";
			$this->vehicle_owner->HrefValue = "";
			$this->vehicle_owner->TooltipValue = "";

			// no
			$this->no->LinkCustomAttributes = "";
			$this->no->HrefValue = "";
			$this->no->TooltipValue = "";

			// driver
			$this->driver->LinkCustomAttributes = "";
			$this->driver->HrefValue = "";
			$this->driver->TooltipValue = "";

			// driver_name
			$this->driver_name->LinkCustomAttributes = "";
			$this->driver_name->HrefValue = "";
			$this->driver_name->TooltipValue = "";

			// dor
			$this->dor->LinkCustomAttributes = "";
			$this->dor->HrefValue = "";
			$this->dor->TooltipValue = "";

			// km_hour
			$this->km_hour->LinkCustomAttributes = "";
			$this->km_hour->HrefValue = "";
			$this->km_hour->TooltipValue = "";

			// chassis_no
			$this->chassis_no->LinkCustomAttributes = "";
			$this->chassis_no->HrefValue = "";
			$this->chassis_no->TooltipValue = "";

			// engine_no
			$this->engine_no->LinkCustomAttributes = "";
			$this->engine_no->HrefValue = "";
			$this->engine_no->TooltipValue = "";

			// load_average
			$this->load_average->LinkCustomAttributes = "";
			$this->load_average->HrefValue = "";
			$this->load_average->TooltipValue = "";

			// unload_average
			$this->unload_average->LinkCustomAttributes = "";
			$this->unload_average->HrefValue = "";
			$this->unload_average->TooltipValue = "";

			// load_expenses
			$this->load_expenses->LinkCustomAttributes = "";
			$this->load_expenses->HrefValue = "";
			$this->load_expenses->TooltipValue = "";

			// unload_expenses
			$this->unload_expenses->LinkCustomAttributes = "";
			$this->unload_expenses->HrefValue = "";
			$this->unload_expenses->TooltipValue = "";

			// insurance
			$this->insurance->LinkCustomAttributes = "";
			$this->insurance->HrefValue = "";
			$this->insurance->TooltipValue = "";

			// state_tax
			$this->state_tax->LinkCustomAttributes = "";
			$this->state_tax->HrefValue = "";
			$this->state_tax->TooltipValue = "";

			// national_permit
			$this->national_permit->LinkCustomAttributes = "";
			$this->national_permit->HrefValue = "";
			$this->national_permit->TooltipValue = "";

			// pollution
			$this->pollution->LinkCustomAttributes = "";
			$this->pollution->HrefValue = "";
			$this->pollution->TooltipValue = "";

			// fitness
			$this->fitness->LinkCustomAttributes = "";
			$this->fitness->HrefValue = "";
			$this->fitness->TooltipValue = "";

			// other_due
			$this->other_due->LinkCustomAttributes = "";
			$this->other_due->HrefValue = "";
			$this->other_due->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// type
			$this->type->EditAttrs["class"] = "form-control";
			$this->type->EditCustomAttributes = "";
			$this->type->EditValue = $this->type->options(TRUE);

			// vehicle_owner
			$this->vehicle_owner->EditAttrs["class"] = "form-control";
			$this->vehicle_owner->EditCustomAttributes = "";
			$curVal = trim(strval($this->vehicle_owner->CurrentValue));
			if ($curVal <> "")
				$this->vehicle_owner->ViewValue = $this->vehicle_owner->lookupCacheOption($curVal);
			else
				$this->vehicle_owner->ViewValue = $this->vehicle_owner->Lookup !== NULL && is_array($this->vehicle_owner->Lookup->Options) ? $curVal : NULL;
			if ($this->vehicle_owner->ViewValue !== NULL) { // Load from cache
				$this->vehicle_owner->EditValue = array_values($this->vehicle_owner->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->vehicle_owner->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`category`= 902 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->vehicle_owner->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->vehicle_owner->EditValue = $arwrk;
			}

			// no
			$this->no->EditAttrs["class"] = "form-control";
			$this->no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->no->CurrentValue = HtmlDecode($this->no->CurrentValue);
			$this->no->EditValue = HtmlEncode($this->no->CurrentValue);
			$this->no->PlaceHolder = RemoveHtml($this->no->caption());

			// driver
			$this->driver->EditAttrs["class"] = "form-control";
			$this->driver->EditCustomAttributes = "";
			$curVal = trim(strval($this->driver->CurrentValue));
			if ($curVal <> "")
				$this->driver->ViewValue = $this->driver->lookupCacheOption($curVal);
			else
				$this->driver->ViewValue = $this->driver->Lookup !== NULL && is_array($this->driver->Lookup->Options) ? $curVal : NULL;
			if ($this->driver->ViewValue !== NULL) { // Load from cache
				$this->driver->EditValue = array_values($this->driver->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->driver->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->driver->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->driver->EditValue = $arwrk;
			}

			// driver_name
			$this->driver_name->EditAttrs["class"] = "form-control";
			$this->driver_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->driver_name->CurrentValue = HtmlDecode($this->driver_name->CurrentValue);
			$this->driver_name->EditValue = HtmlEncode($this->driver_name->CurrentValue);
			$this->driver_name->PlaceHolder = RemoveHtml($this->driver_name->caption());

			// dor
			$this->dor->EditAttrs["class"] = "form-control";
			$this->dor->EditCustomAttributes = "";
			$this->dor->EditValue = HtmlEncode(FormatDateTime($this->dor->CurrentValue, 8));
			$this->dor->PlaceHolder = RemoveHtml($this->dor->caption());

			// km_hour
			$this->km_hour->EditAttrs["class"] = "form-control";
			$this->km_hour->EditCustomAttributes = "";
			$this->km_hour->EditValue = HtmlEncode($this->km_hour->CurrentValue);
			$this->km_hour->PlaceHolder = RemoveHtml($this->km_hour->caption());
			if (strval($this->km_hour->EditValue) <> "" && is_numeric($this->km_hour->EditValue))
				$this->km_hour->EditValue = FormatNumber($this->km_hour->EditValue, -2, -2, -2, -2);

			// chassis_no
			$this->chassis_no->EditAttrs["class"] = "form-control";
			$this->chassis_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->chassis_no->CurrentValue = HtmlDecode($this->chassis_no->CurrentValue);
			$this->chassis_no->EditValue = HtmlEncode($this->chassis_no->CurrentValue);
			$this->chassis_no->PlaceHolder = RemoveHtml($this->chassis_no->caption());

			// engine_no
			$this->engine_no->EditAttrs["class"] = "form-control";
			$this->engine_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->engine_no->CurrentValue = HtmlDecode($this->engine_no->CurrentValue);
			$this->engine_no->EditValue = HtmlEncode($this->engine_no->CurrentValue);
			$this->engine_no->PlaceHolder = RemoveHtml($this->engine_no->caption());

			// load_average
			$this->load_average->EditAttrs["class"] = "form-control";
			$this->load_average->EditCustomAttributes = "";
			$this->load_average->EditValue = HtmlEncode($this->load_average->CurrentValue);
			$this->load_average->PlaceHolder = RemoveHtml($this->load_average->caption());
			if (strval($this->load_average->EditValue) <> "" && is_numeric($this->load_average->EditValue))
				$this->load_average->EditValue = FormatNumber($this->load_average->EditValue, -2, -2, -2, -2);

			// unload_average
			$this->unload_average->EditAttrs["class"] = "form-control";
			$this->unload_average->EditCustomAttributes = "";
			$this->unload_average->EditValue = HtmlEncode($this->unload_average->CurrentValue);
			$this->unload_average->PlaceHolder = RemoveHtml($this->unload_average->caption());
			if (strval($this->unload_average->EditValue) <> "" && is_numeric($this->unload_average->EditValue))
				$this->unload_average->EditValue = FormatNumber($this->unload_average->EditValue, -2, -2, -2, -2);

			// load_expenses
			$this->load_expenses->EditAttrs["class"] = "form-control";
			$this->load_expenses->EditCustomAttributes = "";
			$this->load_expenses->EditValue = HtmlEncode($this->load_expenses->CurrentValue);
			$this->load_expenses->PlaceHolder = RemoveHtml($this->load_expenses->caption());
			if (strval($this->load_expenses->EditValue) <> "" && is_numeric($this->load_expenses->EditValue))
				$this->load_expenses->EditValue = FormatNumber($this->load_expenses->EditValue, -2, -2, -2, -2);

			// unload_expenses
			$this->unload_expenses->EditAttrs["class"] = "form-control";
			$this->unload_expenses->EditCustomAttributes = "";
			$this->unload_expenses->EditValue = HtmlEncode($this->unload_expenses->CurrentValue);
			$this->unload_expenses->PlaceHolder = RemoveHtml($this->unload_expenses->caption());
			if (strval($this->unload_expenses->EditValue) <> "" && is_numeric($this->unload_expenses->EditValue))
				$this->unload_expenses->EditValue = FormatNumber($this->unload_expenses->EditValue, -2, -2, -2, -2);

			// insurance
			$this->insurance->EditAttrs["class"] = "form-control";
			$this->insurance->EditCustomAttributes = "";
			$this->insurance->EditValue = HtmlEncode(FormatDateTime($this->insurance->CurrentValue, 8));
			$this->insurance->PlaceHolder = RemoveHtml($this->insurance->caption());

			// state_tax
			$this->state_tax->EditAttrs["class"] = "form-control";
			$this->state_tax->EditCustomAttributes = "";
			$this->state_tax->EditValue = HtmlEncode(FormatDateTime($this->state_tax->CurrentValue, 8));
			$this->state_tax->PlaceHolder = RemoveHtml($this->state_tax->caption());

			// national_permit
			$this->national_permit->EditAttrs["class"] = "form-control";
			$this->national_permit->EditCustomAttributes = "";
			$this->national_permit->EditValue = HtmlEncode(FormatDateTime($this->national_permit->CurrentValue, 8));
			$this->national_permit->PlaceHolder = RemoveHtml($this->national_permit->caption());

			// pollution
			$this->pollution->EditAttrs["class"] = "form-control";
			$this->pollution->EditCustomAttributes = "";
			$this->pollution->EditValue = HtmlEncode(FormatDateTime($this->pollution->CurrentValue, 8));
			$this->pollution->PlaceHolder = RemoveHtml($this->pollution->caption());

			// fitness
			$this->fitness->EditAttrs["class"] = "form-control";
			$this->fitness->EditCustomAttributes = "";
			$this->fitness->EditValue = HtmlEncode(FormatDateTime($this->fitness->CurrentValue, 8));
			$this->fitness->PlaceHolder = RemoveHtml($this->fitness->caption());

			// other_due
			$this->other_due->EditAttrs["class"] = "form-control";
			$this->other_due->EditCustomAttributes = "";
			$this->other_due->EditValue = HtmlEncode(FormatDateTime($this->other_due->CurrentValue, 8));
			$this->other_due->PlaceHolder = RemoveHtml($this->other_due->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// operator
			// datetime
			// Add refer script
			// type

			$this->type->LinkCustomAttributes = "";
			$this->type->HrefValue = "";

			// vehicle_owner
			$this->vehicle_owner->LinkCustomAttributes = "";
			$this->vehicle_owner->HrefValue = "";

			// no
			$this->no->LinkCustomAttributes = "";
			$this->no->HrefValue = "";

			// driver
			$this->driver->LinkCustomAttributes = "";
			$this->driver->HrefValue = "";

			// driver_name
			$this->driver_name->LinkCustomAttributes = "";
			$this->driver_name->HrefValue = "";

			// dor
			$this->dor->LinkCustomAttributes = "";
			$this->dor->HrefValue = "";

			// km_hour
			$this->km_hour->LinkCustomAttributes = "";
			$this->km_hour->HrefValue = "";

			// chassis_no
			$this->chassis_no->LinkCustomAttributes = "";
			$this->chassis_no->HrefValue = "";

			// engine_no
			$this->engine_no->LinkCustomAttributes = "";
			$this->engine_no->HrefValue = "";

			// load_average
			$this->load_average->LinkCustomAttributes = "";
			$this->load_average->HrefValue = "";

			// unload_average
			$this->unload_average->LinkCustomAttributes = "";
			$this->unload_average->HrefValue = "";

			// load_expenses
			$this->load_expenses->LinkCustomAttributes = "";
			$this->load_expenses->HrefValue = "";

			// unload_expenses
			$this->unload_expenses->LinkCustomAttributes = "";
			$this->unload_expenses->HrefValue = "";

			// insurance
			$this->insurance->LinkCustomAttributes = "";
			$this->insurance->HrefValue = "";

			// state_tax
			$this->state_tax->LinkCustomAttributes = "";
			$this->state_tax->HrefValue = "";

			// national_permit
			$this->national_permit->LinkCustomAttributes = "";
			$this->national_permit->HrefValue = "";

			// pollution
			$this->pollution->LinkCustomAttributes = "";
			$this->pollution->HrefValue = "";

			// fitness
			$this->fitness->LinkCustomAttributes = "";
			$this->fitness->HrefValue = "";

			// other_due
			$this->other_due->LinkCustomAttributes = "";
			$this->other_due->HrefValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->type->Required) {
			if (!$this->type->IsDetailKey && $this->type->FormValue != NULL && $this->type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->type->caption(), $this->type->RequiredErrorMessage));
			}
		}
		if ($this->vehicle_owner->Required) {
			if (!$this->vehicle_owner->IsDetailKey && $this->vehicle_owner->FormValue != NULL && $this->vehicle_owner->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->vehicle_owner->caption(), $this->vehicle_owner->RequiredErrorMessage));
			}
		}
		if ($this->no->Required) {
			if (!$this->no->IsDetailKey && $this->no->FormValue != NULL && $this->no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->no->caption(), $this->no->RequiredErrorMessage));
			}
		}
		if ($this->driver->Required) {
			if (!$this->driver->IsDetailKey && $this->driver->FormValue != NULL && $this->driver->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->driver->caption(), $this->driver->RequiredErrorMessage));
			}
		}
		if ($this->driver_name->Required) {
			if (!$this->driver_name->IsDetailKey && $this->driver_name->FormValue != NULL && $this->driver_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->driver_name->caption(), $this->driver_name->RequiredErrorMessage));
			}
		}
		if ($this->dor->Required) {
			if (!$this->dor->IsDetailKey && $this->dor->FormValue != NULL && $this->dor->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->dor->caption(), $this->dor->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->dor->FormValue)) {
			AddMessage($FormError, $this->dor->errorMessage());
		}
		if ($this->km_hour->Required) {
			if (!$this->km_hour->IsDetailKey && $this->km_hour->FormValue != NULL && $this->km_hour->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->km_hour->caption(), $this->km_hour->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->km_hour->FormValue)) {
			AddMessage($FormError, $this->km_hour->errorMessage());
		}
		if ($this->chassis_no->Required) {
			if (!$this->chassis_no->IsDetailKey && $this->chassis_no->FormValue != NULL && $this->chassis_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->chassis_no->caption(), $this->chassis_no->RequiredErrorMessage));
			}
		}
		if ($this->engine_no->Required) {
			if (!$this->engine_no->IsDetailKey && $this->engine_no->FormValue != NULL && $this->engine_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->engine_no->caption(), $this->engine_no->RequiredErrorMessage));
			}
		}
		if ($this->load_average->Required) {
			if (!$this->load_average->IsDetailKey && $this->load_average->FormValue != NULL && $this->load_average->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->load_average->caption(), $this->load_average->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->load_average->FormValue)) {
			AddMessage($FormError, $this->load_average->errorMessage());
		}
		if ($this->unload_average->Required) {
			if (!$this->unload_average->IsDetailKey && $this->unload_average->FormValue != NULL && $this->unload_average->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->unload_average->caption(), $this->unload_average->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->unload_average->FormValue)) {
			AddMessage($FormError, $this->unload_average->errorMessage());
		}
		if ($this->load_expenses->Required) {
			if (!$this->load_expenses->IsDetailKey && $this->load_expenses->FormValue != NULL && $this->load_expenses->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->load_expenses->caption(), $this->load_expenses->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->load_expenses->FormValue)) {
			AddMessage($FormError, $this->load_expenses->errorMessage());
		}
		if ($this->unload_expenses->Required) {
			if (!$this->unload_expenses->IsDetailKey && $this->unload_expenses->FormValue != NULL && $this->unload_expenses->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->unload_expenses->caption(), $this->unload_expenses->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->unload_expenses->FormValue)) {
			AddMessage($FormError, $this->unload_expenses->errorMessage());
		}
		if ($this->insurance->Required) {
			if (!$this->insurance->IsDetailKey && $this->insurance->FormValue != NULL && $this->insurance->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->insurance->caption(), $this->insurance->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->insurance->FormValue)) {
			AddMessage($FormError, $this->insurance->errorMessage());
		}
		if ($this->state_tax->Required) {
			if (!$this->state_tax->IsDetailKey && $this->state_tax->FormValue != NULL && $this->state_tax->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->state_tax->caption(), $this->state_tax->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->state_tax->FormValue)) {
			AddMessage($FormError, $this->state_tax->errorMessage());
		}
		if ($this->national_permit->Required) {
			if (!$this->national_permit->IsDetailKey && $this->national_permit->FormValue != NULL && $this->national_permit->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->national_permit->caption(), $this->national_permit->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->national_permit->FormValue)) {
			AddMessage($FormError, $this->national_permit->errorMessage());
		}
		if ($this->pollution->Required) {
			if (!$this->pollution->IsDetailKey && $this->pollution->FormValue != NULL && $this->pollution->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pollution->caption(), $this->pollution->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->pollution->FormValue)) {
			AddMessage($FormError, $this->pollution->errorMessage());
		}
		if ($this->fitness->Required) {
			if (!$this->fitness->IsDetailKey && $this->fitness->FormValue != NULL && $this->fitness->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->fitness->caption(), $this->fitness->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->fitness->FormValue)) {
			AddMessage($FormError, $this->fitness->errorMessage());
		}
		if ($this->other_due->Required) {
			if (!$this->other_due->IsDetailKey && $this->other_due->FormValue != NULL && $this->other_due->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->other_due->caption(), $this->other_due->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->other_due->FormValue)) {
			AddMessage($FormError, $this->other_due->errorMessage());
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->running_status->Required) {
			if (!$this->running_status->IsDetailKey && $this->running_status->FormValue != NULL && $this->running_status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->running_status->caption(), $this->running_status->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// type
		$this->type->setDbValueDef($rsnew, $this->type->CurrentValue, 0, strval($this->type->CurrentValue) == "");

		// vehicle_owner
		$this->vehicle_owner->setDbValueDef($rsnew, $this->vehicle_owner->CurrentValue, NULL, FALSE);

		// no
		$this->no->setDbValueDef($rsnew, $this->no->CurrentValue, "", FALSE);

		// driver
		$this->driver->setDbValueDef($rsnew, $this->driver->CurrentValue, NULL, FALSE);

		// driver_name
		$this->driver_name->setDbValueDef($rsnew, $this->driver_name->CurrentValue, NULL, FALSE);

		// dor
		$this->dor->setDbValueDef($rsnew, UnFormatDateTime($this->dor->CurrentValue, 0), NULL, FALSE);

		// km_hour
		$this->km_hour->setDbValueDef($rsnew, $this->km_hour->CurrentValue, NULL, strval($this->km_hour->CurrentValue) == "");

		// chassis_no
		$this->chassis_no->setDbValueDef($rsnew, $this->chassis_no->CurrentValue, NULL, FALSE);

		// engine_no
		$this->engine_no->setDbValueDef($rsnew, $this->engine_no->CurrentValue, NULL, FALSE);

		// load_average
		$this->load_average->setDbValueDef($rsnew, $this->load_average->CurrentValue, NULL, FALSE);

		// unload_average
		$this->unload_average->setDbValueDef($rsnew, $this->unload_average->CurrentValue, NULL, FALSE);

		// load_expenses
		$this->load_expenses->setDbValueDef($rsnew, $this->load_expenses->CurrentValue, NULL, FALSE);

		// unload_expenses
		$this->unload_expenses->setDbValueDef($rsnew, $this->unload_expenses->CurrentValue, NULL, FALSE);

		// insurance
		$this->insurance->setDbValueDef($rsnew, UnFormatDateTime($this->insurance->CurrentValue, 0), NULL, FALSE);

		// state_tax
		$this->state_tax->setDbValueDef($rsnew, UnFormatDateTime($this->state_tax->CurrentValue, 0), NULL, FALSE);

		// national_permit
		$this->national_permit->setDbValueDef($rsnew, UnFormatDateTime($this->national_permit->CurrentValue, 0), NULL, FALSE);

		// pollution
		$this->pollution->setDbValueDef($rsnew, UnFormatDateTime($this->pollution->CurrentValue, 0), NULL, FALSE);

		// fitness
		$this->fitness->setDbValueDef($rsnew, UnFormatDateTime($this->fitness->CurrentValue, 0), NULL, FALSE);

		// other_due
		$this->other_due->setDbValueDef($rsnew, UnFormatDateTime($this->other_due->CurrentValue, 0), NULL, FALSE);

		// status
		$this->status->setDbValueDef($rsnew, $this->status->CurrentValue, 0, strval($this->status->CurrentValue) == "");

		// operator
		$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
		$rsnew['operator'] = &$this->operator->DbValue;

		// datetime
		$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
		$rsnew['datetime'] = &$this->datetime->DbValue;

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("vehicle_infolist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_vehicle_owner":
					$lookupFilter = function() {
						return "`category`= 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_driver":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_vehicle_owner":
							break;
						case "x_driver":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>