<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class vehicle_info_addopt extends vehicle_info
{

	// Page ID
	public $PageID = "addopt";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'vehicle_info';

	// Page object name
	public $PageObjName = "vehicle_info_addopt";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (vehicle_info)
		if (!isset($GLOBALS["vehicle_info"]) || get_class($GLOBALS["vehicle_info"]) == PROJECT_NAMESPACE . "vehicle_info") {
			$GLOBALS["vehicle_info"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["vehicle_info"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'addopt');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'vehicle_info');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $vehicle_info;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($vehicle_info);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("vehicle_infolist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->type->Visible = FALSE;
		$this->vehicle_owner->Visible = FALSE;
		$this->no->setVisibility();
		$this->driver->Visible = FALSE;
		$this->driver_name->setVisibility();
		$this->dor->Visible = FALSE;
		$this->km_hour->Visible = FALSE;
		$this->chassis_no->Visible = FALSE;
		$this->engine_no->Visible = FALSE;
		$this->load_average->Visible = FALSE;
		$this->unload_average->Visible = FALSE;
		$this->load_expenses->Visible = FALSE;
		$this->unload_expenses->Visible = FALSE;
		$this->insurance->Visible = FALSE;
		$this->state_tax->Visible = FALSE;
		$this->national_permit->Visible = FALSE;
		$this->pollution->Visible = FALSE;
		$this->fitness->Visible = FALSE;
		$this->other_due->Visible = FALSE;
		$this->status->Visible = FALSE;
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->running_status->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->vehicle_owner);
		$this->setupLookupOptions($this->driver);
		$this->setupLookupOptions($this->operator);
		set_error_handler(PROJECT_NAMESPACE . "ErrorHandler");

		// Set up Breadcrumb
		//$this->setupBreadcrumb(); // Not used

		$this->loadRowValues(); // Load default values

		// Render row
		$this->RowType = ROWTYPE_ADD; // Render add type
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->type->CurrentValue = 1;
		$this->vehicle_owner->CurrentValue = NULL;
		$this->vehicle_owner->OldValue = $this->vehicle_owner->CurrentValue;
		$this->no->CurrentValue = NULL;
		$this->no->OldValue = $this->no->CurrentValue;
		$this->driver->CurrentValue = NULL;
		$this->driver->OldValue = $this->driver->CurrentValue;
		$this->driver_name->CurrentValue = NULL;
		$this->driver_name->OldValue = $this->driver_name->CurrentValue;
		$this->dor->CurrentValue = NULL;
		$this->dor->OldValue = $this->dor->CurrentValue;
		$this->km_hour->CurrentValue = 0.00;
		$this->chassis_no->CurrentValue = NULL;
		$this->chassis_no->OldValue = $this->chassis_no->CurrentValue;
		$this->engine_no->CurrentValue = NULL;
		$this->engine_no->OldValue = $this->engine_no->CurrentValue;
		$this->load_average->CurrentValue = NULL;
		$this->load_average->OldValue = $this->load_average->CurrentValue;
		$this->unload_average->CurrentValue = NULL;
		$this->unload_average->OldValue = $this->unload_average->CurrentValue;
		$this->load_expenses->CurrentValue = NULL;
		$this->load_expenses->OldValue = $this->load_expenses->CurrentValue;
		$this->unload_expenses->CurrentValue = NULL;
		$this->unload_expenses->OldValue = $this->unload_expenses->CurrentValue;
		$this->insurance->CurrentValue = NULL;
		$this->insurance->OldValue = $this->insurance->CurrentValue;
		$this->state_tax->CurrentValue = NULL;
		$this->state_tax->OldValue = $this->state_tax->CurrentValue;
		$this->national_permit->CurrentValue = NULL;
		$this->national_permit->OldValue = $this->national_permit->CurrentValue;
		$this->pollution->CurrentValue = NULL;
		$this->pollution->OldValue = $this->pollution->CurrentValue;
		$this->fitness->CurrentValue = NULL;
		$this->fitness->OldValue = $this->fitness->CurrentValue;
		$this->other_due->CurrentValue = NULL;
		$this->other_due->OldValue = $this->other_due->CurrentValue;
		$this->status->CurrentValue = 1;
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
		$this->running_status->CurrentValue = 0;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'no' first before field var 'x_no'
		$val = $CurrentForm->hasValue("no") ? $CurrentForm->getValue("no") : $CurrentForm->getValue("x_no");
		if (!$this->no->IsDetailKey) {
			$this->no->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'driver_name' first before field var 'x_driver_name'
		$val = $CurrentForm->hasValue("driver_name") ? $CurrentForm->getValue("driver_name") : $CurrentForm->getValue("x_driver_name");
		if (!$this->driver_name->IsDetailKey) {
			$this->driver_name->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			$this->operator->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			$this->datetime->setFormValue(ConvertFromUtf8($val));
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->no->CurrentValue = ConvertToUtf8($this->no->FormValue);
		$this->driver_name->CurrentValue = ConvertToUtf8($this->driver_name->FormValue);
		$this->operator->CurrentValue = ConvertToUtf8($this->operator->FormValue);
		$this->datetime->CurrentValue = ConvertToUtf8($this->datetime->FormValue);
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->type->setDbValue($row['type']);
		$this->vehicle_owner->setDbValue($row['vehicle_owner']);
		$this->no->setDbValue($row['no']);
		$this->driver->setDbValue($row['driver']);
		$this->driver_name->setDbValue($row['driver_name']);
		$this->dor->setDbValue($row['dor']);
		$this->km_hour->setDbValue($row['km_hour']);
		$this->chassis_no->setDbValue($row['chassis_no']);
		$this->engine_no->setDbValue($row['engine_no']);
		$this->load_average->setDbValue($row['load_average']);
		$this->unload_average->setDbValue($row['unload_average']);
		$this->load_expenses->setDbValue($row['load_expenses']);
		$this->unload_expenses->setDbValue($row['unload_expenses']);
		$this->insurance->setDbValue($row['insurance']);
		$this->state_tax->setDbValue($row['state_tax']);
		$this->national_permit->setDbValue($row['national_permit']);
		$this->pollution->setDbValue($row['pollution']);
		$this->fitness->setDbValue($row['fitness']);
		$this->other_due->setDbValue($row['other_due']);
		$this->status->setDbValue($row['status']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->running_status->setDbValue($row['running_status']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['type'] = $this->type->CurrentValue;
		$row['vehicle_owner'] = $this->vehicle_owner->CurrentValue;
		$row['no'] = $this->no->CurrentValue;
		$row['driver'] = $this->driver->CurrentValue;
		$row['driver_name'] = $this->driver_name->CurrentValue;
		$row['dor'] = $this->dor->CurrentValue;
		$row['km_hour'] = $this->km_hour->CurrentValue;
		$row['chassis_no'] = $this->chassis_no->CurrentValue;
		$row['engine_no'] = $this->engine_no->CurrentValue;
		$row['load_average'] = $this->load_average->CurrentValue;
		$row['unload_average'] = $this->unload_average->CurrentValue;
		$row['load_expenses'] = $this->load_expenses->CurrentValue;
		$row['unload_expenses'] = $this->unload_expenses->CurrentValue;
		$row['insurance'] = $this->insurance->CurrentValue;
		$row['state_tax'] = $this->state_tax->CurrentValue;
		$row['national_permit'] = $this->national_permit->CurrentValue;
		$row['pollution'] = $this->pollution->CurrentValue;
		$row['fitness'] = $this->fitness->CurrentValue;
		$row['other_due'] = $this->other_due->CurrentValue;
		$row['status'] = $this->status->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		$row['running_status'] = $this->running_status->CurrentValue;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// type
		// vehicle_owner
		// no
		// driver
		// driver_name
		// dor
		// km_hour
		// chassis_no
		// engine_no
		// load_average
		// unload_average
		// load_expenses
		// unload_expenses
		// insurance
		// state_tax
		// national_permit
		// pollution
		// fitness
		// other_due
		// status
		// operator
		// datetime
		// running_status

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// type
			if (strval($this->type->CurrentValue) <> "") {
				$this->type->ViewValue = $this->type->optionCaption($this->type->CurrentValue);
			} else {
				$this->type->ViewValue = NULL;
			}
			$this->type->ViewCustomAttributes = "";

			// vehicle_owner
			$curVal = strval($this->vehicle_owner->CurrentValue);
			if ($curVal <> "") {
				$this->vehicle_owner->ViewValue = $this->vehicle_owner->lookupCacheOption($curVal);
				if ($this->vehicle_owner->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category`= 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->vehicle_owner->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->vehicle_owner->ViewValue = $this->vehicle_owner->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->vehicle_owner->ViewValue = $this->vehicle_owner->CurrentValue;
					}
				}
			} else {
				$this->vehicle_owner->ViewValue = NULL;
			}
			$this->vehicle_owner->ViewCustomAttributes = "";

			// no
			$this->no->ViewValue = $this->no->CurrentValue;
			$this->no->ViewCustomAttributes = "";

			// driver_name
			$this->driver_name->ViewValue = $this->driver_name->CurrentValue;
			$this->driver_name->ViewCustomAttributes = "";

			// dor
			$this->dor->ViewValue = $this->dor->CurrentValue;
			$this->dor->ViewValue = FormatDateTime($this->dor->ViewValue, 0);
			$this->dor->ViewCustomAttributes = "";

			// km_hour
			$this->km_hour->ViewValue = $this->km_hour->CurrentValue;
			$this->km_hour->ViewValue = FormatNumber($this->km_hour->ViewValue, 2, -2, -2, -2);
			$this->km_hour->ViewCustomAttributes = "";

			// chassis_no
			$this->chassis_no->ViewValue = $this->chassis_no->CurrentValue;
			$this->chassis_no->ViewCustomAttributes = "";

			// engine_no
			$this->engine_no->ViewValue = $this->engine_no->CurrentValue;
			$this->engine_no->ViewCustomAttributes = "";

			// load_average
			$this->load_average->ViewValue = $this->load_average->CurrentValue;
			$this->load_average->ViewValue = FormatNumber($this->load_average->ViewValue, 2, -2, -2, -2);
			$this->load_average->ViewCustomAttributes = "";

			// unload_average
			$this->unload_average->ViewValue = $this->unload_average->CurrentValue;
			$this->unload_average->ViewValue = FormatNumber($this->unload_average->ViewValue, 2, -2, -2, -2);
			$this->unload_average->ViewCustomAttributes = "";

			// load_expenses
			$this->load_expenses->ViewValue = $this->load_expenses->CurrentValue;
			$this->load_expenses->ViewValue = FormatNumber($this->load_expenses->ViewValue, 2, -2, -2, -2);
			$this->load_expenses->ViewCustomAttributes = "";

			// unload_expenses
			$this->unload_expenses->ViewValue = $this->unload_expenses->CurrentValue;
			$this->unload_expenses->ViewValue = FormatNumber($this->unload_expenses->ViewValue, 2, -2, -2, -2);
			$this->unload_expenses->ViewCustomAttributes = "";

			// insurance
			$this->insurance->ViewValue = $this->insurance->CurrentValue;
			$this->insurance->ViewValue = FormatDateTime($this->insurance->ViewValue, 0);
			$this->insurance->ViewCustomAttributes = "";

			// state_tax
			$this->state_tax->ViewValue = $this->state_tax->CurrentValue;
			$this->state_tax->ViewValue = FormatDateTime($this->state_tax->ViewValue, 0);
			$this->state_tax->ViewCustomAttributes = "";

			// national_permit
			$this->national_permit->ViewValue = $this->national_permit->CurrentValue;
			$this->national_permit->ViewValue = FormatDateTime($this->national_permit->ViewValue, 0);
			$this->national_permit->ViewCustomAttributes = "";

			// pollution
			$this->pollution->ViewValue = $this->pollution->CurrentValue;
			$this->pollution->ViewValue = FormatDateTime($this->pollution->ViewValue, 0);
			$this->pollution->ViewCustomAttributes = "";

			// fitness
			$this->fitness->ViewValue = $this->fitness->CurrentValue;
			$this->fitness->ViewValue = FormatDateTime($this->fitness->ViewValue, 0);
			$this->fitness->ViewCustomAttributes = "";

			// other_due
			$this->other_due->ViewValue = $this->other_due->CurrentValue;
			$this->other_due->ViewValue = FormatDateTime($this->other_due->ViewValue, 0);
			$this->other_due->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// running_status
			if (strval($this->running_status->CurrentValue) <> "") {
				$this->running_status->ViewValue = $this->running_status->optionCaption($this->running_status->CurrentValue);
			} else {
				$this->running_status->ViewValue = NULL;
			}
			$this->running_status->ViewCustomAttributes = "";

			// no
			$this->no->LinkCustomAttributes = "";
			$this->no->HrefValue = "";
			$this->no->TooltipValue = "";

			// driver_name
			$this->driver_name->LinkCustomAttributes = "";
			$this->driver_name->HrefValue = "";
			$this->driver_name->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// no
			$this->no->EditAttrs["class"] = "form-control";
			$this->no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->no->CurrentValue = HtmlDecode($this->no->CurrentValue);
			$this->no->EditValue = HtmlEncode($this->no->CurrentValue);
			$this->no->PlaceHolder = RemoveHtml($this->no->caption());

			// driver_name
			$this->driver_name->EditAttrs["class"] = "form-control";
			$this->driver_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->driver_name->CurrentValue = HtmlDecode($this->driver_name->CurrentValue);
			$this->driver_name->EditValue = HtmlEncode($this->driver_name->CurrentValue);
			$this->driver_name->PlaceHolder = RemoveHtml($this->driver_name->caption());

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$this->operator->CurrentValue = CurrentUserID();

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->CurrentValue = FormatDateTime(CurrentDateTime(), 8);

			// Add refer script
			// no

			$this->no->LinkCustomAttributes = "";
			$this->no->HrefValue = "";

			// driver_name
			$this->driver_name->LinkCustomAttributes = "";
			$this->driver_name->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->type->Required) {
			if (!$this->type->IsDetailKey && $this->type->FormValue != NULL && $this->type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->type->caption(), $this->type->RequiredErrorMessage));
			}
		}
		if ($this->vehicle_owner->Required) {
			if (!$this->vehicle_owner->IsDetailKey && $this->vehicle_owner->FormValue != NULL && $this->vehicle_owner->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->vehicle_owner->caption(), $this->vehicle_owner->RequiredErrorMessage));
			}
		}
		if ($this->no->Required) {
			if (!$this->no->IsDetailKey && $this->no->FormValue != NULL && $this->no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->no->caption(), $this->no->RequiredErrorMessage));
			}
		}
		if ($this->driver->Required) {
			if (!$this->driver->IsDetailKey && $this->driver->FormValue != NULL && $this->driver->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->driver->caption(), $this->driver->RequiredErrorMessage));
			}
		}
		if ($this->driver_name->Required) {
			if (!$this->driver_name->IsDetailKey && $this->driver_name->FormValue != NULL && $this->driver_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->driver_name->caption(), $this->driver_name->RequiredErrorMessage));
			}
		}
		if ($this->dor->Required) {
			if (!$this->dor->IsDetailKey && $this->dor->FormValue != NULL && $this->dor->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->dor->caption(), $this->dor->RequiredErrorMessage));
			}
		}
		if ($this->km_hour->Required) {
			if (!$this->km_hour->IsDetailKey && $this->km_hour->FormValue != NULL && $this->km_hour->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->km_hour->caption(), $this->km_hour->RequiredErrorMessage));
			}
		}
		if ($this->chassis_no->Required) {
			if (!$this->chassis_no->IsDetailKey && $this->chassis_no->FormValue != NULL && $this->chassis_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->chassis_no->caption(), $this->chassis_no->RequiredErrorMessage));
			}
		}
		if ($this->engine_no->Required) {
			if (!$this->engine_no->IsDetailKey && $this->engine_no->FormValue != NULL && $this->engine_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->engine_no->caption(), $this->engine_no->RequiredErrorMessage));
			}
		}
		if ($this->load_average->Required) {
			if (!$this->load_average->IsDetailKey && $this->load_average->FormValue != NULL && $this->load_average->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->load_average->caption(), $this->load_average->RequiredErrorMessage));
			}
		}
		if ($this->unload_average->Required) {
			if (!$this->unload_average->IsDetailKey && $this->unload_average->FormValue != NULL && $this->unload_average->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->unload_average->caption(), $this->unload_average->RequiredErrorMessage));
			}
		}
		if ($this->load_expenses->Required) {
			if (!$this->load_expenses->IsDetailKey && $this->load_expenses->FormValue != NULL && $this->load_expenses->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->load_expenses->caption(), $this->load_expenses->RequiredErrorMessage));
			}
		}
		if ($this->unload_expenses->Required) {
			if (!$this->unload_expenses->IsDetailKey && $this->unload_expenses->FormValue != NULL && $this->unload_expenses->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->unload_expenses->caption(), $this->unload_expenses->RequiredErrorMessage));
			}
		}
		if ($this->insurance->Required) {
			if (!$this->insurance->IsDetailKey && $this->insurance->FormValue != NULL && $this->insurance->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->insurance->caption(), $this->insurance->RequiredErrorMessage));
			}
		}
		if ($this->state_tax->Required) {
			if (!$this->state_tax->IsDetailKey && $this->state_tax->FormValue != NULL && $this->state_tax->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->state_tax->caption(), $this->state_tax->RequiredErrorMessage));
			}
		}
		if ($this->national_permit->Required) {
			if (!$this->national_permit->IsDetailKey && $this->national_permit->FormValue != NULL && $this->national_permit->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->national_permit->caption(), $this->national_permit->RequiredErrorMessage));
			}
		}
		if ($this->pollution->Required) {
			if (!$this->pollution->IsDetailKey && $this->pollution->FormValue != NULL && $this->pollution->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pollution->caption(), $this->pollution->RequiredErrorMessage));
			}
		}
		if ($this->fitness->Required) {
			if (!$this->fitness->IsDetailKey && $this->fitness->FormValue != NULL && $this->fitness->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->fitness->caption(), $this->fitness->RequiredErrorMessage));
			}
		}
		if ($this->other_due->Required) {
			if (!$this->other_due->IsDetailKey && $this->other_due->FormValue != NULL && $this->other_due->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->other_due->caption(), $this->other_due->RequiredErrorMessage));
			}
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->running_status->Required) {
			if (!$this->running_status->IsDetailKey && $this->running_status->FormValue != NULL && $this->running_status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->running_status->caption(), $this->running_status->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// no
		$this->no->setDbValueDef($rsnew, $this->no->CurrentValue, "", FALSE);

		// driver_name
		$this->driver_name->setDbValueDef($rsnew, $this->driver_name->CurrentValue, NULL, FALSE);

		// operator
		$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
		$rsnew['operator'] = &$this->operator->DbValue;

		// datetime
		$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
		$rsnew['datetime'] = &$this->datetime->DbValue;

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("vehicle_infolist.php"), "", $this->TableVar, TRUE);
		$pageId = "addopt";
		$Breadcrumb->add("addopt", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_vehicle_owner":
					$lookupFilter = function() {
						return "`category`= 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_driver":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_vehicle_owner":
							break;
						case "x_driver":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}
}
?>