<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class vehicle_info_search extends vehicle_info
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'vehicle_info';

	// Page object name
	public $PageObjName = "vehicle_info_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (vehicle_info)
		if (!isset($GLOBALS["vehicle_info"]) || get_class($GLOBALS["vehicle_info"]) == PROJECT_NAMESPACE . "vehicle_info") {
			$GLOBALS["vehicle_info"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["vehicle_info"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'vehicle_info');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $vehicle_info;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($vehicle_info);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "vehicle_infoview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("vehicle_infolist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->type->setVisibility();
		$this->vehicle_owner->setVisibility();
		$this->no->setVisibility();
		$this->driver->setVisibility();
		$this->driver_name->setVisibility();
		$this->dor->setVisibility();
		$this->km_hour->setVisibility();
		$this->chassis_no->setVisibility();
		$this->engine_no->setVisibility();
		$this->load_average->setVisibility();
		$this->unload_average->setVisibility();
		$this->load_expenses->setVisibility();
		$this->unload_expenses->setVisibility();
		$this->insurance->setVisibility();
		$this->state_tax->setVisibility();
		$this->national_permit->setVisibility();
		$this->pollution->setVisibility();
		$this->fitness->setVisibility();
		$this->other_due->setVisibility();
		$this->status->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->running_status->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->vehicle_owner);
		$this->setupLookupOptions($this->driver);
		$this->setupLookupOptions($this->operator);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "vehicle_infolist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->type); // type
		$this->buildSearchUrl($srchUrl, $this->vehicle_owner); // vehicle_owner
		$this->buildSearchUrl($srchUrl, $this->no); // no
		$this->buildSearchUrl($srchUrl, $this->driver); // driver
		$this->buildSearchUrl($srchUrl, $this->driver_name); // driver_name
		$this->buildSearchUrl($srchUrl, $this->dor); // dor
		$this->buildSearchUrl($srchUrl, $this->km_hour); // km_hour
		$this->buildSearchUrl($srchUrl, $this->chassis_no); // chassis_no
		$this->buildSearchUrl($srchUrl, $this->engine_no); // engine_no
		$this->buildSearchUrl($srchUrl, $this->load_average); // load_average
		$this->buildSearchUrl($srchUrl, $this->unload_average); // unload_average
		$this->buildSearchUrl($srchUrl, $this->load_expenses); // load_expenses
		$this->buildSearchUrl($srchUrl, $this->unload_expenses); // unload_expenses
		$this->buildSearchUrl($srchUrl, $this->insurance); // insurance
		$this->buildSearchUrl($srchUrl, $this->state_tax); // state_tax
		$this->buildSearchUrl($srchUrl, $this->national_permit); // national_permit
		$this->buildSearchUrl($srchUrl, $this->pollution); // pollution
		$this->buildSearchUrl($srchUrl, $this->fitness); // fitness
		$this->buildSearchUrl($srchUrl, $this->other_due); // other_due
		$this->buildSearchUrl($srchUrl, $this->status); // status
		$this->buildSearchUrl($srchUrl, $this->operator); // operator
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		$this->buildSearchUrl($srchUrl, $this->running_status); // running_status
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// type
		if (!$this->isAddOrEdit())
			$this->type->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_type"));
		$this->type->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_type"));

		// vehicle_owner
		if (!$this->isAddOrEdit())
			$this->vehicle_owner->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_vehicle_owner"));
		$this->vehicle_owner->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_vehicle_owner"));

		// no
		if (!$this->isAddOrEdit())
			$this->no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_no"));
		$this->no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_no"));

		// driver
		if (!$this->isAddOrEdit())
			$this->driver->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_driver"));
		$this->driver->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_driver"));

		// driver_name
		if (!$this->isAddOrEdit())
			$this->driver_name->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_driver_name"));
		$this->driver_name->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_driver_name"));

		// dor
		if (!$this->isAddOrEdit())
			$this->dor->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_dor"));
		$this->dor->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_dor"));

		// km_hour
		if (!$this->isAddOrEdit())
			$this->km_hour->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_km_hour"));
		$this->km_hour->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_km_hour"));

		// chassis_no
		if (!$this->isAddOrEdit())
			$this->chassis_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_chassis_no"));
		$this->chassis_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_chassis_no"));

		// engine_no
		if (!$this->isAddOrEdit())
			$this->engine_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_engine_no"));
		$this->engine_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_engine_no"));

		// load_average
		if (!$this->isAddOrEdit())
			$this->load_average->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_load_average"));
		$this->load_average->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_load_average"));

		// unload_average
		if (!$this->isAddOrEdit())
			$this->unload_average->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_unload_average"));
		$this->unload_average->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_unload_average"));

		// load_expenses
		if (!$this->isAddOrEdit())
			$this->load_expenses->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_load_expenses"));
		$this->load_expenses->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_load_expenses"));

		// unload_expenses
		if (!$this->isAddOrEdit())
			$this->unload_expenses->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_unload_expenses"));
		$this->unload_expenses->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_unload_expenses"));

		// insurance
		if (!$this->isAddOrEdit())
			$this->insurance->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_insurance"));
		$this->insurance->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_insurance"));

		// state_tax
		if (!$this->isAddOrEdit())
			$this->state_tax->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_state_tax"));
		$this->state_tax->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_state_tax"));

		// national_permit
		if (!$this->isAddOrEdit())
			$this->national_permit->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_national_permit"));
		$this->national_permit->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_national_permit"));

		// pollution
		if (!$this->isAddOrEdit())
			$this->pollution->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pollution"));
		$this->pollution->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pollution"));

		// fitness
		if (!$this->isAddOrEdit())
			$this->fitness->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_fitness"));
		$this->fitness->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_fitness"));

		// other_due
		if (!$this->isAddOrEdit())
			$this->other_due->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_other_due"));
		$this->other_due->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_other_due"));

		// status
		if (!$this->isAddOrEdit())
			$this->status->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_status"));
		$this->status->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_status"));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_operator"));
		$this->operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_operator"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));

		// running_status
		if (!$this->isAddOrEdit())
			$this->running_status->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_running_status"));
		$this->running_status->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_running_status"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->km_hour->FormValue == $this->km_hour->CurrentValue && is_numeric(ConvertToFloatString($this->km_hour->CurrentValue)))
			$this->km_hour->CurrentValue = ConvertToFloatString($this->km_hour->CurrentValue);

		// Convert decimal values if posted back
		if ($this->load_average->FormValue == $this->load_average->CurrentValue && is_numeric(ConvertToFloatString($this->load_average->CurrentValue)))
			$this->load_average->CurrentValue = ConvertToFloatString($this->load_average->CurrentValue);

		// Convert decimal values if posted back
		if ($this->unload_average->FormValue == $this->unload_average->CurrentValue && is_numeric(ConvertToFloatString($this->unload_average->CurrentValue)))
			$this->unload_average->CurrentValue = ConvertToFloatString($this->unload_average->CurrentValue);

		// Convert decimal values if posted back
		if ($this->load_expenses->FormValue == $this->load_expenses->CurrentValue && is_numeric(ConvertToFloatString($this->load_expenses->CurrentValue)))
			$this->load_expenses->CurrentValue = ConvertToFloatString($this->load_expenses->CurrentValue);

		// Convert decimal values if posted back
		if ($this->unload_expenses->FormValue == $this->unload_expenses->CurrentValue && is_numeric(ConvertToFloatString($this->unload_expenses->CurrentValue)))
			$this->unload_expenses->CurrentValue = ConvertToFloatString($this->unload_expenses->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// type
		// vehicle_owner
		// no
		// driver
		// driver_name
		// dor
		// km_hour
		// chassis_no
		// engine_no
		// load_average
		// unload_average
		// load_expenses
		// unload_expenses
		// insurance
		// state_tax
		// national_permit
		// pollution
		// fitness
		// other_due
		// status
		// operator
		// datetime
		// running_status

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// type
			if (strval($this->type->CurrentValue) <> "") {
				$this->type->ViewValue = $this->type->optionCaption($this->type->CurrentValue);
			} else {
				$this->type->ViewValue = NULL;
			}
			$this->type->ViewCustomAttributes = "";

			// vehicle_owner
			$curVal = strval($this->vehicle_owner->CurrentValue);
			if ($curVal <> "") {
				$this->vehicle_owner->ViewValue = $this->vehicle_owner->lookupCacheOption($curVal);
				if ($this->vehicle_owner->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category`= 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->vehicle_owner->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->vehicle_owner->ViewValue = $this->vehicle_owner->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->vehicle_owner->ViewValue = $this->vehicle_owner->CurrentValue;
					}
				}
			} else {
				$this->vehicle_owner->ViewValue = NULL;
			}
			$this->vehicle_owner->ViewCustomAttributes = "";

			// no
			$this->no->ViewValue = $this->no->CurrentValue;
			$this->no->ViewCustomAttributes = "";

			// driver
			$curVal = strval($this->driver->CurrentValue);
			if ($curVal <> "") {
				$this->driver->ViewValue = $this->driver->lookupCacheOption($curVal);
				if ($this->driver->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->driver->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->driver->ViewValue = $this->driver->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->driver->ViewValue = $this->driver->CurrentValue;
					}
				}
			} else {
				$this->driver->ViewValue = NULL;
			}
			$this->driver->ViewCustomAttributes = "";

			// driver_name
			$this->driver_name->ViewValue = $this->driver_name->CurrentValue;
			$this->driver_name->ViewCustomAttributes = "";

			// dor
			$this->dor->ViewValue = $this->dor->CurrentValue;
			$this->dor->ViewValue = FormatDateTime($this->dor->ViewValue, 0);
			$this->dor->ViewCustomAttributes = "";

			// km_hour
			$this->km_hour->ViewValue = $this->km_hour->CurrentValue;
			$this->km_hour->ViewValue = FormatNumber($this->km_hour->ViewValue, 2, -2, -2, -2);
			$this->km_hour->ViewCustomAttributes = "";

			// chassis_no
			$this->chassis_no->ViewValue = $this->chassis_no->CurrentValue;
			$this->chassis_no->ViewCustomAttributes = "";

			// engine_no
			$this->engine_no->ViewValue = $this->engine_no->CurrentValue;
			$this->engine_no->ViewCustomAttributes = "";

			// load_average
			$this->load_average->ViewValue = $this->load_average->CurrentValue;
			$this->load_average->ViewValue = FormatNumber($this->load_average->ViewValue, 2, -2, -2, -2);
			$this->load_average->ViewCustomAttributes = "";

			// unload_average
			$this->unload_average->ViewValue = $this->unload_average->CurrentValue;
			$this->unload_average->ViewValue = FormatNumber($this->unload_average->ViewValue, 2, -2, -2, -2);
			$this->unload_average->ViewCustomAttributes = "";

			// load_expenses
			$this->load_expenses->ViewValue = $this->load_expenses->CurrentValue;
			$this->load_expenses->ViewValue = FormatNumber($this->load_expenses->ViewValue, 2, -2, -2, -2);
			$this->load_expenses->ViewCustomAttributes = "";

			// unload_expenses
			$this->unload_expenses->ViewValue = $this->unload_expenses->CurrentValue;
			$this->unload_expenses->ViewValue = FormatNumber($this->unload_expenses->ViewValue, 2, -2, -2, -2);
			$this->unload_expenses->ViewCustomAttributes = "";

			// insurance
			$this->insurance->ViewValue = $this->insurance->CurrentValue;
			$this->insurance->ViewValue = FormatDateTime($this->insurance->ViewValue, 0);
			$this->insurance->ViewCustomAttributes = "";

			// state_tax
			$this->state_tax->ViewValue = $this->state_tax->CurrentValue;
			$this->state_tax->ViewValue = FormatDateTime($this->state_tax->ViewValue, 0);
			$this->state_tax->ViewCustomAttributes = "";

			// national_permit
			$this->national_permit->ViewValue = $this->national_permit->CurrentValue;
			$this->national_permit->ViewValue = FormatDateTime($this->national_permit->ViewValue, 0);
			$this->national_permit->ViewCustomAttributes = "";

			// pollution
			$this->pollution->ViewValue = $this->pollution->CurrentValue;
			$this->pollution->ViewValue = FormatDateTime($this->pollution->ViewValue, 0);
			$this->pollution->ViewCustomAttributes = "";

			// fitness
			$this->fitness->ViewValue = $this->fitness->CurrentValue;
			$this->fitness->ViewValue = FormatDateTime($this->fitness->ViewValue, 0);
			$this->fitness->ViewCustomAttributes = "";

			// other_due
			$this->other_due->ViewValue = $this->other_due->CurrentValue;
			$this->other_due->ViewValue = FormatDateTime($this->other_due->ViewValue, 0);
			$this->other_due->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// running_status
			if (strval($this->running_status->CurrentValue) <> "") {
				$this->running_status->ViewValue = $this->running_status->optionCaption($this->running_status->CurrentValue);
			} else {
				$this->running_status->ViewValue = NULL;
			}
			$this->running_status->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// type
			$this->type->LinkCustomAttributes = "";
			$this->type->HrefValue = "";
			$this->type->TooltipValue = "";

			// vehicle_owner
			$this->vehicle_owner->LinkCustomAttributes = "";
			$this->vehicle_owner->HrefValue = "";
			$this->vehicle_owner->TooltipValue = "";

			// no
			$this->no->LinkCustomAttributes = "";
			$this->no->HrefValue = "";
			$this->no->TooltipValue = "";

			// driver
			$this->driver->LinkCustomAttributes = "";
			$this->driver->HrefValue = "";
			$this->driver->TooltipValue = "";

			// driver_name
			$this->driver_name->LinkCustomAttributes = "";
			$this->driver_name->HrefValue = "";
			$this->driver_name->TooltipValue = "";

			// dor
			$this->dor->LinkCustomAttributes = "";
			$this->dor->HrefValue = "";
			$this->dor->TooltipValue = "";

			// km_hour
			$this->km_hour->LinkCustomAttributes = "";
			$this->km_hour->HrefValue = "";
			$this->km_hour->TooltipValue = "";

			// chassis_no
			$this->chassis_no->LinkCustomAttributes = "";
			$this->chassis_no->HrefValue = "";
			$this->chassis_no->TooltipValue = "";

			// engine_no
			$this->engine_no->LinkCustomAttributes = "";
			$this->engine_no->HrefValue = "";
			$this->engine_no->TooltipValue = "";

			// load_average
			$this->load_average->LinkCustomAttributes = "";
			$this->load_average->HrefValue = "";
			$this->load_average->TooltipValue = "";

			// unload_average
			$this->unload_average->LinkCustomAttributes = "";
			$this->unload_average->HrefValue = "";
			$this->unload_average->TooltipValue = "";

			// load_expenses
			$this->load_expenses->LinkCustomAttributes = "";
			$this->load_expenses->HrefValue = "";
			$this->load_expenses->TooltipValue = "";

			// unload_expenses
			$this->unload_expenses->LinkCustomAttributes = "";
			$this->unload_expenses->HrefValue = "";
			$this->unload_expenses->TooltipValue = "";

			// insurance
			$this->insurance->LinkCustomAttributes = "";
			$this->insurance->HrefValue = "";
			$this->insurance->TooltipValue = "";

			// state_tax
			$this->state_tax->LinkCustomAttributes = "";
			$this->state_tax->HrefValue = "";
			$this->state_tax->TooltipValue = "";

			// national_permit
			$this->national_permit->LinkCustomAttributes = "";
			$this->national_permit->HrefValue = "";
			$this->national_permit->TooltipValue = "";

			// pollution
			$this->pollution->LinkCustomAttributes = "";
			$this->pollution->HrefValue = "";
			$this->pollution->TooltipValue = "";

			// fitness
			$this->fitness->LinkCustomAttributes = "";
			$this->fitness->HrefValue = "";
			$this->fitness->TooltipValue = "";

			// other_due
			$this->other_due->LinkCustomAttributes = "";
			$this->other_due->HrefValue = "";
			$this->other_due->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// running_status
			$this->running_status->LinkCustomAttributes = "";
			$this->running_status->HrefValue = "";
			$this->running_status->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// type
			$this->type->EditAttrs["class"] = "form-control";
			$this->type->EditCustomAttributes = "";
			$this->type->EditValue = $this->type->options(TRUE);

			// vehicle_owner
			$this->vehicle_owner->EditAttrs["class"] = "form-control";
			$this->vehicle_owner->EditCustomAttributes = "";
			$curVal = trim(strval($this->vehicle_owner->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->vehicle_owner->AdvancedSearch->ViewValue = $this->vehicle_owner->lookupCacheOption($curVal);
			else
				$this->vehicle_owner->AdvancedSearch->ViewValue = $this->vehicle_owner->Lookup !== NULL && is_array($this->vehicle_owner->Lookup->Options) ? $curVal : NULL;
			if ($this->vehicle_owner->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->vehicle_owner->EditValue = array_values($this->vehicle_owner->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->vehicle_owner->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`category`= 902 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->vehicle_owner->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->vehicle_owner->EditValue = $arwrk;
			}

			// no
			$this->no->EditAttrs["class"] = "form-control";
			$this->no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->no->AdvancedSearch->SearchValue = HtmlDecode($this->no->AdvancedSearch->SearchValue);
			$this->no->EditValue = HtmlEncode($this->no->AdvancedSearch->SearchValue);
			$this->no->PlaceHolder = RemoveHtml($this->no->caption());

			// driver
			$this->driver->EditAttrs["class"] = "form-control";
			$this->driver->EditCustomAttributes = "";
			$curVal = trim(strval($this->driver->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->driver->AdvancedSearch->ViewValue = $this->driver->lookupCacheOption($curVal);
			else
				$this->driver->AdvancedSearch->ViewValue = $this->driver->Lookup !== NULL && is_array($this->driver->Lookup->Options) ? $curVal : NULL;
			if ($this->driver->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->driver->EditValue = array_values($this->driver->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->driver->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->driver->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->driver->EditValue = $arwrk;
			}

			// driver_name
			$this->driver_name->EditAttrs["class"] = "form-control";
			$this->driver_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->driver_name->AdvancedSearch->SearchValue = HtmlDecode($this->driver_name->AdvancedSearch->SearchValue);
			$this->driver_name->EditValue = HtmlEncode($this->driver_name->AdvancedSearch->SearchValue);
			$this->driver_name->PlaceHolder = RemoveHtml($this->driver_name->caption());

			// dor
			$this->dor->EditAttrs["class"] = "form-control";
			$this->dor->EditCustomAttributes = "";
			$this->dor->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->dor->AdvancedSearch->SearchValue, 0), 8));
			$this->dor->PlaceHolder = RemoveHtml($this->dor->caption());

			// km_hour
			$this->km_hour->EditAttrs["class"] = "form-control";
			$this->km_hour->EditCustomAttributes = "";
			$this->km_hour->EditValue = HtmlEncode($this->km_hour->AdvancedSearch->SearchValue);
			$this->km_hour->PlaceHolder = RemoveHtml($this->km_hour->caption());

			// chassis_no
			$this->chassis_no->EditAttrs["class"] = "form-control";
			$this->chassis_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->chassis_no->AdvancedSearch->SearchValue = HtmlDecode($this->chassis_no->AdvancedSearch->SearchValue);
			$this->chassis_no->EditValue = HtmlEncode($this->chassis_no->AdvancedSearch->SearchValue);
			$this->chassis_no->PlaceHolder = RemoveHtml($this->chassis_no->caption());

			// engine_no
			$this->engine_no->EditAttrs["class"] = "form-control";
			$this->engine_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->engine_no->AdvancedSearch->SearchValue = HtmlDecode($this->engine_no->AdvancedSearch->SearchValue);
			$this->engine_no->EditValue = HtmlEncode($this->engine_no->AdvancedSearch->SearchValue);
			$this->engine_no->PlaceHolder = RemoveHtml($this->engine_no->caption());

			// load_average
			$this->load_average->EditAttrs["class"] = "form-control";
			$this->load_average->EditCustomAttributes = "";
			$this->load_average->EditValue = HtmlEncode($this->load_average->AdvancedSearch->SearchValue);
			$this->load_average->PlaceHolder = RemoveHtml($this->load_average->caption());

			// unload_average
			$this->unload_average->EditAttrs["class"] = "form-control";
			$this->unload_average->EditCustomAttributes = "";
			$this->unload_average->EditValue = HtmlEncode($this->unload_average->AdvancedSearch->SearchValue);
			$this->unload_average->PlaceHolder = RemoveHtml($this->unload_average->caption());

			// load_expenses
			$this->load_expenses->EditAttrs["class"] = "form-control";
			$this->load_expenses->EditCustomAttributes = "";
			$this->load_expenses->EditValue = HtmlEncode($this->load_expenses->AdvancedSearch->SearchValue);
			$this->load_expenses->PlaceHolder = RemoveHtml($this->load_expenses->caption());

			// unload_expenses
			$this->unload_expenses->EditAttrs["class"] = "form-control";
			$this->unload_expenses->EditCustomAttributes = "";
			$this->unload_expenses->EditValue = HtmlEncode($this->unload_expenses->AdvancedSearch->SearchValue);
			$this->unload_expenses->PlaceHolder = RemoveHtml($this->unload_expenses->caption());

			// insurance
			$this->insurance->EditAttrs["class"] = "form-control";
			$this->insurance->EditCustomAttributes = "";
			$this->insurance->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->insurance->AdvancedSearch->SearchValue, 0), 8));
			$this->insurance->PlaceHolder = RemoveHtml($this->insurance->caption());

			// state_tax
			$this->state_tax->EditAttrs["class"] = "form-control";
			$this->state_tax->EditCustomAttributes = "";
			$this->state_tax->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->state_tax->AdvancedSearch->SearchValue, 0), 8));
			$this->state_tax->PlaceHolder = RemoveHtml($this->state_tax->caption());

			// national_permit
			$this->national_permit->EditAttrs["class"] = "form-control";
			$this->national_permit->EditCustomAttributes = "";
			$this->national_permit->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->national_permit->AdvancedSearch->SearchValue, 0), 8));
			$this->national_permit->PlaceHolder = RemoveHtml($this->national_permit->caption());

			// pollution
			$this->pollution->EditAttrs["class"] = "form-control";
			$this->pollution->EditCustomAttributes = "";
			$this->pollution->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->pollution->AdvancedSearch->SearchValue, 0), 8));
			$this->pollution->PlaceHolder = RemoveHtml($this->pollution->caption());

			// fitness
			$this->fitness->EditAttrs["class"] = "form-control";
			$this->fitness->EditCustomAttributes = "";
			$this->fitness->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->fitness->AdvancedSearch->SearchValue, 0), 8));
			$this->fitness->PlaceHolder = RemoveHtml($this->fitness->caption());

			// other_due
			$this->other_due->EditAttrs["class"] = "form-control";
			$this->other_due->EditCustomAttributes = "";
			$this->other_due->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->other_due->AdvancedSearch->SearchValue, 0), 8));
			$this->other_due->PlaceHolder = RemoveHtml($this->other_due->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
			else
				$this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== NULL && is_array($this->operator->Lookup->Options) ? $curVal : NULL;
			if ($this->operator->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->operator->EditValue = array_values($this->operator->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->operator->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->operator->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->operator->EditValue = $arwrk;
			}

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// running_status
			$this->running_status->EditAttrs["class"] = "form-control";
			$this->running_status->EditCustomAttributes = "";
			$this->running_status->EditValue = $this->running_status->options(TRUE);
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckDate($this->dor->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->dor->errorMessage());
		}
		if (!CheckNumber($this->km_hour->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->km_hour->errorMessage());
		}
		if (!CheckNumber($this->load_average->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->load_average->errorMessage());
		}
		if (!CheckNumber($this->unload_average->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->unload_average->errorMessage());
		}
		if (!CheckNumber($this->load_expenses->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->load_expenses->errorMessage());
		}
		if (!CheckNumber($this->unload_expenses->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->unload_expenses->errorMessage());
		}
		if (!CheckDate($this->insurance->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->insurance->errorMessage());
		}
		if (!CheckDate($this->state_tax->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->state_tax->errorMessage());
		}
		if (!CheckDate($this->national_permit->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->national_permit->errorMessage());
		}
		if (!CheckDate($this->pollution->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->pollution->errorMessage());
		}
		if (!CheckDate($this->fitness->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->fitness->errorMessage());
		}
		if (!CheckDate($this->other_due->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->other_due->errorMessage());
		}
		if (!CheckDate($this->datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->datetime->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->type->AdvancedSearch->load();
		$this->vehicle_owner->AdvancedSearch->load();
		$this->no->AdvancedSearch->load();
		$this->driver->AdvancedSearch->load();
		$this->driver_name->AdvancedSearch->load();
		$this->dor->AdvancedSearch->load();
		$this->km_hour->AdvancedSearch->load();
		$this->chassis_no->AdvancedSearch->load();
		$this->engine_no->AdvancedSearch->load();
		$this->load_average->AdvancedSearch->load();
		$this->unload_average->AdvancedSearch->load();
		$this->load_expenses->AdvancedSearch->load();
		$this->unload_expenses->AdvancedSearch->load();
		$this->insurance->AdvancedSearch->load();
		$this->state_tax->AdvancedSearch->load();
		$this->national_permit->AdvancedSearch->load();
		$this->pollution->AdvancedSearch->load();
		$this->fitness->AdvancedSearch->load();
		$this->other_due->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->running_status->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("vehicle_infolist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_vehicle_owner":
					$lookupFilter = function() {
						return "`category`= 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_driver":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_vehicle_owner":
							break;
						case "x_driver":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>