<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for wool_import_calculator1
 */
class wool_import_calculator1 extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $rid;
	public $product_code;
	public $godown_arrival_date;
	public $net_weight;
	public $containers;
	public $packets;
	public $purchase_amount;
	public $purchase_custom_duty;
	public $s_custom_duty;
	public $port_clearing_charge;
	public $s_port_clearing_charge;
	public $cha_commission;
	public $s_cha_commission;
	public $transportation_charges;
	public $s_transportation_charges;
	public $unloading_charges;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'wool_import_calculator1';
		$this->TableName = 'wool_import_calculator1';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`wool_import_calculator1`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// rid
		$this->rid = new DbField('wool_import_calculator1', 'wool_import_calculator1', 'x_rid', 'rid', '`rid`', '`rid`', 18, -1, FALSE, '`rid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->rid->Nullable = FALSE; // NOT NULL field
		$this->rid->Required = TRUE; // Required field
		$this->rid->Sortable = TRUE; // Allow sort
		$this->rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['rid'] = &$this->rid;

		// product_code
		$this->product_code = new DbField('wool_import_calculator1', 'wool_import_calculator1', 'x_product_code', 'product_code', '`product_code`', '`product_code`', 201, -1, FALSE, '`product_code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->product_code->Sortable = TRUE; // Allow sort
		$this->fields['product_code'] = &$this->product_code;

		// godown_arrival_date
		$this->godown_arrival_date = new DbField('wool_import_calculator1', 'wool_import_calculator1', 'x_godown_arrival_date', 'godown_arrival_date', '`godown_arrival_date`', CastDateFieldForLike('`godown_arrival_date`', 0, "DB"), 135, 0, FALSE, '`godown_arrival_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->godown_arrival_date->Sortable = TRUE; // Allow sort
		$this->godown_arrival_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['godown_arrival_date'] = &$this->godown_arrival_date;

		// net_weight
		$this->net_weight = new DbField('wool_import_calculator1', 'wool_import_calculator1', 'x_net_weight', 'net_weight', '`net_weight`', '`net_weight`', 131, -1, FALSE, '`net_weight`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->net_weight->Nullable = FALSE; // NOT NULL field
		$this->net_weight->Required = TRUE; // Required field
		$this->net_weight->Sortable = TRUE; // Allow sort
		$this->net_weight->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['net_weight'] = &$this->net_weight;

		// containers
		$this->containers = new DbField('wool_import_calculator1', 'wool_import_calculator1', 'x_containers', 'containers', '`containers`', '`containers`', 131, -1, FALSE, '`containers`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->containers->Nullable = FALSE; // NOT NULL field
		$this->containers->Required = TRUE; // Required field
		$this->containers->Sortable = TRUE; // Allow sort
		$this->containers->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['containers'] = &$this->containers;

		// packets
		$this->packets = new DbField('wool_import_calculator1', 'wool_import_calculator1', 'x_packets', 'packets', '`packets`', '`packets`', 18, -1, FALSE, '`packets`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->packets->Sortable = TRUE; // Allow sort
		$this->packets->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['packets'] = &$this->packets;

		// purchase_amount
		$this->purchase_amount = new DbField('wool_import_calculator1', 'wool_import_calculator1', 'x_purchase_amount', 'purchase_amount', '`purchase_amount`', '`purchase_amount`', 131, -1, FALSE, '`purchase_amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->purchase_amount->Sortable = TRUE; // Allow sort
		$this->purchase_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['purchase_amount'] = &$this->purchase_amount;

		// purchase_custom_duty
		$this->purchase_custom_duty = new DbField('wool_import_calculator1', 'wool_import_calculator1', 'x_purchase_custom_duty', 'purchase_custom_duty', '`purchase_custom_duty`', '`purchase_custom_duty`', 200, -1, FALSE, '`purchase_custom_duty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->purchase_custom_duty->Sortable = TRUE; // Allow sort
		$this->fields['purchase_custom_duty'] = &$this->purchase_custom_duty;

		// s_custom_duty
		$this->s_custom_duty = new DbField('wool_import_calculator1', 'wool_import_calculator1', 'x_s_custom_duty', 's_custom_duty', '`s_custom_duty`', '`s_custom_duty`', 200, -1, FALSE, '`s_custom_duty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->s_custom_duty->Sortable = TRUE; // Allow sort
		$this->fields['s_custom_duty'] = &$this->s_custom_duty;

		// port_clearing_charge
		$this->port_clearing_charge = new DbField('wool_import_calculator1', 'wool_import_calculator1', 'x_port_clearing_charge', 'port_clearing_charge', '`port_clearing_charge`', '`port_clearing_charge`', 200, -1, FALSE, '`port_clearing_charge`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->port_clearing_charge->Sortable = TRUE; // Allow sort
		$this->fields['port_clearing_charge'] = &$this->port_clearing_charge;

		// s_port_clearing_charge
		$this->s_port_clearing_charge = new DbField('wool_import_calculator1', 'wool_import_calculator1', 'x_s_port_clearing_charge', 's_port_clearing_charge', '`s_port_clearing_charge`', '`s_port_clearing_charge`', 200, -1, FALSE, '`s_port_clearing_charge`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->s_port_clearing_charge->Sortable = TRUE; // Allow sort
		$this->fields['s_port_clearing_charge'] = &$this->s_port_clearing_charge;

		// cha_commission
		$this->cha_commission = new DbField('wool_import_calculator1', 'wool_import_calculator1', 'x_cha_commission', 'cha_commission', '`cha_commission`', '`cha_commission`', 200, -1, FALSE, '`cha_commission`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cha_commission->Sortable = TRUE; // Allow sort
		$this->fields['cha_commission'] = &$this->cha_commission;

		// s_cha_commission
		$this->s_cha_commission = new DbField('wool_import_calculator1', 'wool_import_calculator1', 'x_s_cha_commission', 's_cha_commission', '`s_cha_commission`', '`s_cha_commission`', 200, -1, FALSE, '`s_cha_commission`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->s_cha_commission->Sortable = TRUE; // Allow sort
		$this->fields['s_cha_commission'] = &$this->s_cha_commission;

		// transportation_charges
		$this->transportation_charges = new DbField('wool_import_calculator1', 'wool_import_calculator1', 'x_transportation_charges', 'transportation_charges', '`transportation_charges`', '`transportation_charges`', 200, -1, FALSE, '`transportation_charges`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->transportation_charges->Sortable = TRUE; // Allow sort
		$this->fields['transportation_charges'] = &$this->transportation_charges;

		// s_transportation_charges
		$this->s_transportation_charges = new DbField('wool_import_calculator1', 'wool_import_calculator1', 'x_s_transportation_charges', 's_transportation_charges', '`s_transportation_charges`', '`s_transportation_charges`', 200, -1, FALSE, '`s_transportation_charges`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->s_transportation_charges->Sortable = TRUE; // Allow sort
		$this->fields['s_transportation_charges'] = &$this->s_transportation_charges;

		// unloading_charges
		$this->unloading_charges = new DbField('wool_import_calculator1', 'wool_import_calculator1', 'x_unloading_charges', 'unloading_charges', '`unloading_charges`', '`unloading_charges`', 200, -1, FALSE, '`unloading_charges`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->unloading_charges->Sortable = TRUE; // Allow sort
		$this->fields['unloading_charges'] = &$this->unloading_charges;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`wool_import_calculator1`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->rid->DbValue = $row['rid'];
		$this->product_code->DbValue = $row['product_code'];
		$this->godown_arrival_date->DbValue = $row['godown_arrival_date'];
		$this->net_weight->DbValue = $row['net_weight'];
		$this->containers->DbValue = $row['containers'];
		$this->packets->DbValue = $row['packets'];
		$this->purchase_amount->DbValue = $row['purchase_amount'];
		$this->purchase_custom_duty->DbValue = $row['purchase_custom_duty'];
		$this->s_custom_duty->DbValue = $row['s_custom_duty'];
		$this->port_clearing_charge->DbValue = $row['port_clearing_charge'];
		$this->s_port_clearing_charge->DbValue = $row['s_port_clearing_charge'];
		$this->cha_commission->DbValue = $row['cha_commission'];
		$this->s_cha_commission->DbValue = $row['s_cha_commission'];
		$this->transportation_charges->DbValue = $row['transportation_charges'];
		$this->s_transportation_charges->DbValue = $row['s_transportation_charges'];
		$this->unloading_charges->DbValue = $row['unloading_charges'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "wool_import_calculator1list.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "wool_import_calculator1view.php")
			return $Language->phrase("View");
		elseif ($pageName == "wool_import_calculator1edit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "wool_import_calculator1add.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "wool_import_calculator1list.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("wool_import_calculator1view.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("wool_import_calculator1view.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "wool_import_calculator1add.php?" . $this->getUrlParm($parm);
		else
			$url = "wool_import_calculator1add.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("wool_import_calculator1edit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("wool_import_calculator1add.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("wool_import_calculator1delete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->rid->setDbValue($rs->fields('rid'));
		$this->product_code->setDbValue($rs->fields('product_code'));
		$this->godown_arrival_date->setDbValue($rs->fields('godown_arrival_date'));
		$this->net_weight->setDbValue($rs->fields('net_weight'));
		$this->containers->setDbValue($rs->fields('containers'));
		$this->packets->setDbValue($rs->fields('packets'));
		$this->purchase_amount->setDbValue($rs->fields('purchase_amount'));
		$this->purchase_custom_duty->setDbValue($rs->fields('purchase_custom_duty'));
		$this->s_custom_duty->setDbValue($rs->fields('s_custom_duty'));
		$this->port_clearing_charge->setDbValue($rs->fields('port_clearing_charge'));
		$this->s_port_clearing_charge->setDbValue($rs->fields('s_port_clearing_charge'));
		$this->cha_commission->setDbValue($rs->fields('cha_commission'));
		$this->s_cha_commission->setDbValue($rs->fields('s_cha_commission'));
		$this->transportation_charges->setDbValue($rs->fields('transportation_charges'));
		$this->s_transportation_charges->setDbValue($rs->fields('s_transportation_charges'));
		$this->unloading_charges->setDbValue($rs->fields('unloading_charges'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// rid
		// product_code
		// godown_arrival_date
		// net_weight
		// containers
		// packets
		// purchase_amount
		// purchase_custom_duty
		// s_custom_duty
		// port_clearing_charge
		// s_port_clearing_charge
		// cha_commission
		// s_cha_commission
		// transportation_charges
		// s_transportation_charges
		// unloading_charges
		// rid

		$this->rid->ViewValue = $this->rid->CurrentValue;
		$this->rid->ViewCustomAttributes = "";

		// product_code
		$this->product_code->ViewValue = $this->product_code->CurrentValue;
		$this->product_code->ViewCustomAttributes = "";

		// godown_arrival_date
		$this->godown_arrival_date->ViewValue = $this->godown_arrival_date->CurrentValue;
		$this->godown_arrival_date->ViewValue = FormatDateTime($this->godown_arrival_date->ViewValue, 0);
		$this->godown_arrival_date->ViewCustomAttributes = "";

		// net_weight
		$this->net_weight->ViewValue = $this->net_weight->CurrentValue;
		$this->net_weight->ViewCustomAttributes = "";

		// containers
		$this->containers->ViewValue = $this->containers->CurrentValue;
		$this->containers->ViewCustomAttributes = "";

		// packets
		$this->packets->ViewValue = $this->packets->CurrentValue;
		$this->packets->ViewCustomAttributes = "";

		// purchase_amount
		$this->purchase_amount->ViewValue = $this->purchase_amount->CurrentValue;
		$this->purchase_amount->ViewCustomAttributes = "";

		// purchase_custom_duty
		$this->purchase_custom_duty->ViewValue = $this->purchase_custom_duty->CurrentValue;
		$this->purchase_custom_duty->ViewCustomAttributes = "";

		// s_custom_duty
		$this->s_custom_duty->ViewValue = $this->s_custom_duty->CurrentValue;
		$this->s_custom_duty->ViewCustomAttributes = "";

		// port_clearing_charge
		$this->port_clearing_charge->ViewValue = $this->port_clearing_charge->CurrentValue;
		$this->port_clearing_charge->ViewCustomAttributes = "";

		// s_port_clearing_charge
		$this->s_port_clearing_charge->ViewValue = $this->s_port_clearing_charge->CurrentValue;
		$this->s_port_clearing_charge->ViewCustomAttributes = "";

		// cha_commission
		$this->cha_commission->ViewValue = $this->cha_commission->CurrentValue;
		$this->cha_commission->ViewCustomAttributes = "";

		// s_cha_commission
		$this->s_cha_commission->ViewValue = $this->s_cha_commission->CurrentValue;
		$this->s_cha_commission->ViewCustomAttributes = "";

		// transportation_charges
		$this->transportation_charges->ViewValue = $this->transportation_charges->CurrentValue;
		$this->transportation_charges->ViewCustomAttributes = "";

		// s_transportation_charges
		$this->s_transportation_charges->ViewValue = $this->s_transportation_charges->CurrentValue;
		$this->s_transportation_charges->ViewCustomAttributes = "";

		// unloading_charges
		$this->unloading_charges->ViewValue = $this->unloading_charges->CurrentValue;
		$this->unloading_charges->ViewCustomAttributes = "";

		// rid
		$this->rid->LinkCustomAttributes = "";
		if (!EmptyValue($this->rid->CurrentValue)) {
			$this->rid->HrefValue = "wool_import_calculator1list.php?x_rid=" . $this->rid->CurrentValue; // Add prefix/suffix
			$this->rid->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
		} else {
			$this->rid->HrefValue = "";
		}
		$this->rid->TooltipValue = "";

		// product_code
		$this->product_code->LinkCustomAttributes = "";
		if (!EmptyValue($this->product_code->CurrentValue)) {
			$this->product_code->HrefValue = "wool_import_calculator1list.php?x_product_code=" . $this->product_code->CurrentValue; // Add prefix/suffix
			$this->product_code->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->product_code->HrefValue = FullUrl($this->product_code->HrefValue, "href");
		} else {
			$this->product_code->HrefValue = "";
		}
		$this->product_code->TooltipValue = "";

		// godown_arrival_date
		$this->godown_arrival_date->LinkCustomAttributes = "";
		$this->godown_arrival_date->HrefValue = "";
		$this->godown_arrival_date->TooltipValue = "";

		// net_weight
		$this->net_weight->LinkCustomAttributes = "";
		$this->net_weight->HrefValue = "";
		$this->net_weight->TooltipValue = "";

		// containers
		$this->containers->LinkCustomAttributes = "";
		$this->containers->HrefValue = "";
		$this->containers->TooltipValue = "";

		// packets
		$this->packets->LinkCustomAttributes = "";
		$this->packets->HrefValue = "";
		$this->packets->TooltipValue = "";

		// purchase_amount
		$this->purchase_amount->LinkCustomAttributes = "";
		$this->purchase_amount->HrefValue = "";
		$this->purchase_amount->TooltipValue = "";

		// purchase_custom_duty
		$this->purchase_custom_duty->LinkCustomAttributes = "";
		$this->purchase_custom_duty->HrefValue = "";
		$this->purchase_custom_duty->TooltipValue = "";

		// s_custom_duty
		$this->s_custom_duty->LinkCustomAttributes = "";
		$this->s_custom_duty->HrefValue = "";
		$this->s_custom_duty->TooltipValue = "";

		// port_clearing_charge
		$this->port_clearing_charge->LinkCustomAttributes = "";
		$this->port_clearing_charge->HrefValue = "";
		$this->port_clearing_charge->TooltipValue = "";

		// s_port_clearing_charge
		$this->s_port_clearing_charge->LinkCustomAttributes = "";
		$this->s_port_clearing_charge->HrefValue = "";
		$this->s_port_clearing_charge->TooltipValue = "";

		// cha_commission
		$this->cha_commission->LinkCustomAttributes = "";
		$this->cha_commission->HrefValue = "";
		$this->cha_commission->TooltipValue = "";

		// s_cha_commission
		$this->s_cha_commission->LinkCustomAttributes = "";
		$this->s_cha_commission->HrefValue = "";
		$this->s_cha_commission->TooltipValue = "";

		// transportation_charges
		$this->transportation_charges->LinkCustomAttributes = "";
		$this->transportation_charges->HrefValue = "";
		$this->transportation_charges->TooltipValue = "";

		// s_transportation_charges
		$this->s_transportation_charges->LinkCustomAttributes = "";
		$this->s_transportation_charges->HrefValue = "";
		$this->s_transportation_charges->TooltipValue = "";

		// unloading_charges
		$this->unloading_charges->LinkCustomAttributes = "";
		$this->unloading_charges->HrefValue = "";
		$this->unloading_charges->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// rid
		$this->rid->EditAttrs["class"] = "form-control";
		$this->rid->EditCustomAttributes = "";
		$this->rid->EditValue = $this->rid->CurrentValue;
		$this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

		// product_code
		$this->product_code->EditAttrs["class"] = "form-control";
		$this->product_code->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->product_code->CurrentValue = HtmlDecode($this->product_code->CurrentValue);
		$this->product_code->EditValue = $this->product_code->CurrentValue;
		$this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

		// godown_arrival_date
		$this->godown_arrival_date->EditAttrs["class"] = "form-control";
		$this->godown_arrival_date->EditCustomAttributes = "";
		$this->godown_arrival_date->EditValue = FormatDateTime($this->godown_arrival_date->CurrentValue, 8);
		$this->godown_arrival_date->PlaceHolder = RemoveHtml($this->godown_arrival_date->caption());

		// net_weight
		$this->net_weight->EditAttrs["class"] = "form-control";
		$this->net_weight->EditCustomAttributes = "";
		$this->net_weight->EditValue = $this->net_weight->CurrentValue;
		$this->net_weight->PlaceHolder = RemoveHtml($this->net_weight->caption());
		if (strval($this->net_weight->EditValue) <> "" && is_numeric($this->net_weight->EditValue))
			$this->net_weight->EditValue = FormatNumber($this->net_weight->EditValue, -2, -1, -2, 0);

		// containers
		$this->containers->EditAttrs["class"] = "form-control";
		$this->containers->EditCustomAttributes = "";
		$this->containers->EditValue = $this->containers->CurrentValue;
		$this->containers->PlaceHolder = RemoveHtml($this->containers->caption());
		if (strval($this->containers->EditValue) <> "" && is_numeric($this->containers->EditValue))
			$this->containers->EditValue = FormatNumber($this->containers->EditValue, -2, -1, -2, 0);

		// packets
		$this->packets->EditAttrs["class"] = "form-control";
		$this->packets->EditCustomAttributes = "";
		$this->packets->EditValue = $this->packets->CurrentValue;
		$this->packets->PlaceHolder = RemoveHtml($this->packets->caption());

		// purchase_amount
		$this->purchase_amount->EditAttrs["class"] = "form-control";
		$this->purchase_amount->EditCustomAttributes = "";
		$this->purchase_amount->EditValue = $this->purchase_amount->CurrentValue;
		$this->purchase_amount->PlaceHolder = RemoveHtml($this->purchase_amount->caption());
		if (strval($this->purchase_amount->EditValue) <> "" && is_numeric($this->purchase_amount->EditValue))
			$this->purchase_amount->EditValue = FormatNumber($this->purchase_amount->EditValue, -2, -1, -2, 0);

		// purchase_custom_duty
		$this->purchase_custom_duty->EditAttrs["class"] = "form-control";
		$this->purchase_custom_duty->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->purchase_custom_duty->CurrentValue = HtmlDecode($this->purchase_custom_duty->CurrentValue);
		$this->purchase_custom_duty->EditValue = $this->purchase_custom_duty->CurrentValue;
		$this->purchase_custom_duty->PlaceHolder = RemoveHtml($this->purchase_custom_duty->caption());

		// s_custom_duty
		$this->s_custom_duty->EditAttrs["class"] = "form-control";
		$this->s_custom_duty->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->s_custom_duty->CurrentValue = HtmlDecode($this->s_custom_duty->CurrentValue);
		$this->s_custom_duty->EditValue = $this->s_custom_duty->CurrentValue;
		$this->s_custom_duty->PlaceHolder = RemoveHtml($this->s_custom_duty->caption());

		// port_clearing_charge
		$this->port_clearing_charge->EditAttrs["class"] = "form-control";
		$this->port_clearing_charge->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->port_clearing_charge->CurrentValue = HtmlDecode($this->port_clearing_charge->CurrentValue);
		$this->port_clearing_charge->EditValue = $this->port_clearing_charge->CurrentValue;
		$this->port_clearing_charge->PlaceHolder = RemoveHtml($this->port_clearing_charge->caption());

		// s_port_clearing_charge
		$this->s_port_clearing_charge->EditAttrs["class"] = "form-control";
		$this->s_port_clearing_charge->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->s_port_clearing_charge->CurrentValue = HtmlDecode($this->s_port_clearing_charge->CurrentValue);
		$this->s_port_clearing_charge->EditValue = $this->s_port_clearing_charge->CurrentValue;
		$this->s_port_clearing_charge->PlaceHolder = RemoveHtml($this->s_port_clearing_charge->caption());

		// cha_commission
		$this->cha_commission->EditAttrs["class"] = "form-control";
		$this->cha_commission->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->cha_commission->CurrentValue = HtmlDecode($this->cha_commission->CurrentValue);
		$this->cha_commission->EditValue = $this->cha_commission->CurrentValue;
		$this->cha_commission->PlaceHolder = RemoveHtml($this->cha_commission->caption());

		// s_cha_commission
		$this->s_cha_commission->EditAttrs["class"] = "form-control";
		$this->s_cha_commission->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->s_cha_commission->CurrentValue = HtmlDecode($this->s_cha_commission->CurrentValue);
		$this->s_cha_commission->EditValue = $this->s_cha_commission->CurrentValue;
		$this->s_cha_commission->PlaceHolder = RemoveHtml($this->s_cha_commission->caption());

		// transportation_charges
		$this->transportation_charges->EditAttrs["class"] = "form-control";
		$this->transportation_charges->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->transportation_charges->CurrentValue = HtmlDecode($this->transportation_charges->CurrentValue);
		$this->transportation_charges->EditValue = $this->transportation_charges->CurrentValue;
		$this->transportation_charges->PlaceHolder = RemoveHtml($this->transportation_charges->caption());

		// s_transportation_charges
		$this->s_transportation_charges->EditAttrs["class"] = "form-control";
		$this->s_transportation_charges->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->s_transportation_charges->CurrentValue = HtmlDecode($this->s_transportation_charges->CurrentValue);
		$this->s_transportation_charges->EditValue = $this->s_transportation_charges->CurrentValue;
		$this->s_transportation_charges->PlaceHolder = RemoveHtml($this->s_transportation_charges->caption());

		// unloading_charges
		$this->unloading_charges->EditAttrs["class"] = "form-control";
		$this->unloading_charges->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->unloading_charges->CurrentValue = HtmlDecode($this->unloading_charges->CurrentValue);
		$this->unloading_charges->EditValue = $this->unloading_charges->CurrentValue;
		$this->unloading_charges->PlaceHolder = RemoveHtml($this->unloading_charges->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->product_code);
					$doc->exportCaption($this->godown_arrival_date);
					$doc->exportCaption($this->net_weight);
					$doc->exportCaption($this->containers);
					$doc->exportCaption($this->packets);
					$doc->exportCaption($this->purchase_amount);
					$doc->exportCaption($this->purchase_custom_duty);
					$doc->exportCaption($this->s_custom_duty);
					$doc->exportCaption($this->port_clearing_charge);
					$doc->exportCaption($this->s_port_clearing_charge);
					$doc->exportCaption($this->cha_commission);
					$doc->exportCaption($this->s_cha_commission);
					$doc->exportCaption($this->transportation_charges);
					$doc->exportCaption($this->s_transportation_charges);
					$doc->exportCaption($this->unloading_charges);
				} else {
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->product_code);
					$doc->exportCaption($this->godown_arrival_date);
					$doc->exportCaption($this->net_weight);
					$doc->exportCaption($this->containers);
					$doc->exportCaption($this->packets);
					$doc->exportCaption($this->purchase_amount);
					$doc->exportCaption($this->purchase_custom_duty);
					$doc->exportCaption($this->s_custom_duty);
					$doc->exportCaption($this->port_clearing_charge);
					$doc->exportCaption($this->s_port_clearing_charge);
					$doc->exportCaption($this->cha_commission);
					$doc->exportCaption($this->s_cha_commission);
					$doc->exportCaption($this->transportation_charges);
					$doc->exportCaption($this->s_transportation_charges);
					$doc->exportCaption($this->unloading_charges);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->rid);
						$doc->exportField($this->product_code);
						$doc->exportField($this->godown_arrival_date);
						$doc->exportField($this->net_weight);
						$doc->exportField($this->containers);
						$doc->exportField($this->packets);
						$doc->exportField($this->purchase_amount);
						$doc->exportField($this->purchase_custom_duty);
						$doc->exportField($this->s_custom_duty);
						$doc->exportField($this->port_clearing_charge);
						$doc->exportField($this->s_port_clearing_charge);
						$doc->exportField($this->cha_commission);
						$doc->exportField($this->s_cha_commission);
						$doc->exportField($this->transportation_charges);
						$doc->exportField($this->s_transportation_charges);
						$doc->exportField($this->unloading_charges);
					} else {
						$doc->exportField($this->rid);
						$doc->exportField($this->product_code);
						$doc->exportField($this->godown_arrival_date);
						$doc->exportField($this->net_weight);
						$doc->exportField($this->containers);
						$doc->exportField($this->packets);
						$doc->exportField($this->purchase_amount);
						$doc->exportField($this->purchase_custom_duty);
						$doc->exportField($this->s_custom_duty);
						$doc->exportField($this->port_clearing_charge);
						$doc->exportField($this->s_port_clearing_charge);
						$doc->exportField($this->cha_commission);
						$doc->exportField($this->s_cha_commission);
						$doc->exportField($this->transportation_charges);
						$doc->exportField($this->s_transportation_charges);
						$doc->exportField($this->unloading_charges);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>