<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class wool_import_calculator1_search extends wool_import_calculator1
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'wool_import_calculator1';

	// Page object name
	public $PageObjName = "wool_import_calculator1_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (wool_import_calculator1)
		if (!isset($GLOBALS["wool_import_calculator1"]) || get_class($GLOBALS["wool_import_calculator1"]) == PROJECT_NAMESPACE . "wool_import_calculator1") {
			$GLOBALS["wool_import_calculator1"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["wool_import_calculator1"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'wool_import_calculator1');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $wool_import_calculator1;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($wool_import_calculator1);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "wool_import_calculator1view.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("wool_import_calculator1list.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->rid->setVisibility();
		$this->product_code->setVisibility();
		$this->godown_arrival_date->setVisibility();
		$this->net_weight->setVisibility();
		$this->containers->setVisibility();
		$this->packets->setVisibility();
		$this->purchase_amount->setVisibility();
		$this->purchase_custom_duty->setVisibility();
		$this->s_custom_duty->setVisibility();
		$this->port_clearing_charge->setVisibility();
		$this->s_port_clearing_charge->setVisibility();
		$this->cha_commission->setVisibility();
		$this->s_cha_commission->setVisibility();
		$this->transportation_charges->setVisibility();
		$this->s_transportation_charges->setVisibility();
		$this->unloading_charges->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Set up Breadcrumb

		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "wool_import_calculator1list.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->rid); // rid
		$this->buildSearchUrl($srchUrl, $this->product_code); // product_code
		$this->buildSearchUrl($srchUrl, $this->godown_arrival_date); // godown_arrival_date
		$this->buildSearchUrl($srchUrl, $this->net_weight); // net_weight
		$this->buildSearchUrl($srchUrl, $this->containers); // containers
		$this->buildSearchUrl($srchUrl, $this->packets); // packets
		$this->buildSearchUrl($srchUrl, $this->purchase_amount); // purchase_amount
		$this->buildSearchUrl($srchUrl, $this->purchase_custom_duty); // purchase_custom_duty
		$this->buildSearchUrl($srchUrl, $this->s_custom_duty); // s_custom_duty
		$this->buildSearchUrl($srchUrl, $this->port_clearing_charge); // port_clearing_charge
		$this->buildSearchUrl($srchUrl, $this->s_port_clearing_charge); // s_port_clearing_charge
		$this->buildSearchUrl($srchUrl, $this->cha_commission); // cha_commission
		$this->buildSearchUrl($srchUrl, $this->s_cha_commission); // s_cha_commission
		$this->buildSearchUrl($srchUrl, $this->transportation_charges); // transportation_charges
		$this->buildSearchUrl($srchUrl, $this->s_transportation_charges); // s_transportation_charges
		$this->buildSearchUrl($srchUrl, $this->unloading_charges); // unloading_charges
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// rid

		if (!$this->isAddOrEdit())
			$this->rid->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_rid"));
		$this->rid->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_rid"));

		// product_code
		if (!$this->isAddOrEdit())
			$this->product_code->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_product_code"));
		$this->product_code->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_product_code"));

		// godown_arrival_date
		if (!$this->isAddOrEdit())
			$this->godown_arrival_date->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_godown_arrival_date"));
		$this->godown_arrival_date->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_godown_arrival_date"));

		// net_weight
		if (!$this->isAddOrEdit())
			$this->net_weight->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_net_weight"));
		$this->net_weight->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_net_weight"));

		// containers
		if (!$this->isAddOrEdit())
			$this->containers->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_containers"));
		$this->containers->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_containers"));

		// packets
		if (!$this->isAddOrEdit())
			$this->packets->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_packets"));
		$this->packets->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_packets"));

		// purchase_amount
		if (!$this->isAddOrEdit())
			$this->purchase_amount->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_purchase_amount"));
		$this->purchase_amount->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_purchase_amount"));

		// purchase_custom_duty
		if (!$this->isAddOrEdit())
			$this->purchase_custom_duty->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_purchase_custom_duty"));
		$this->purchase_custom_duty->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_purchase_custom_duty"));

		// s_custom_duty
		if (!$this->isAddOrEdit())
			$this->s_custom_duty->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_s_custom_duty"));
		$this->s_custom_duty->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_s_custom_duty"));

		// port_clearing_charge
		if (!$this->isAddOrEdit())
			$this->port_clearing_charge->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_port_clearing_charge"));
		$this->port_clearing_charge->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_port_clearing_charge"));

		// s_port_clearing_charge
		if (!$this->isAddOrEdit())
			$this->s_port_clearing_charge->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_s_port_clearing_charge"));
		$this->s_port_clearing_charge->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_s_port_clearing_charge"));

		// cha_commission
		if (!$this->isAddOrEdit())
			$this->cha_commission->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_cha_commission"));
		$this->cha_commission->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_cha_commission"));

		// s_cha_commission
		if (!$this->isAddOrEdit())
			$this->s_cha_commission->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_s_cha_commission"));
		$this->s_cha_commission->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_s_cha_commission"));

		// transportation_charges
		if (!$this->isAddOrEdit())
			$this->transportation_charges->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_transportation_charges"));
		$this->transportation_charges->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_transportation_charges"));

		// s_transportation_charges
		if (!$this->isAddOrEdit())
			$this->s_transportation_charges->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_s_transportation_charges"));
		$this->s_transportation_charges->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_s_transportation_charges"));

		// unloading_charges
		if (!$this->isAddOrEdit())
			$this->unloading_charges->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_unloading_charges"));
		$this->unloading_charges->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_unloading_charges"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->net_weight->FormValue == $this->net_weight->CurrentValue && is_numeric(ConvertToFloatString($this->net_weight->CurrentValue)))
			$this->net_weight->CurrentValue = ConvertToFloatString($this->net_weight->CurrentValue);

		// Convert decimal values if posted back
		if ($this->containers->FormValue == $this->containers->CurrentValue && is_numeric(ConvertToFloatString($this->containers->CurrentValue)))
			$this->containers->CurrentValue = ConvertToFloatString($this->containers->CurrentValue);

		// Convert decimal values if posted back
		if ($this->purchase_amount->FormValue == $this->purchase_amount->CurrentValue && is_numeric(ConvertToFloatString($this->purchase_amount->CurrentValue)))
			$this->purchase_amount->CurrentValue = ConvertToFloatString($this->purchase_amount->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// rid
		// product_code
		// godown_arrival_date
		// net_weight
		// containers
		// packets
		// purchase_amount
		// purchase_custom_duty
		// s_custom_duty
		// port_clearing_charge
		// s_port_clearing_charge
		// cha_commission
		// s_cha_commission
		// transportation_charges
		// s_transportation_charges
		// unloading_charges

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// rid
			$this->rid->ViewValue = $this->rid->CurrentValue;
			$this->rid->ViewCustomAttributes = "";

			// product_code
			$this->product_code->ViewValue = $this->product_code->CurrentValue;
			$this->product_code->ViewCustomAttributes = "";

			// godown_arrival_date
			$this->godown_arrival_date->ViewValue = $this->godown_arrival_date->CurrentValue;
			$this->godown_arrival_date->ViewValue = FormatDateTime($this->godown_arrival_date->ViewValue, 0);
			$this->godown_arrival_date->ViewCustomAttributes = "";

			// net_weight
			$this->net_weight->ViewValue = $this->net_weight->CurrentValue;
			$this->net_weight->ViewCustomAttributes = "";

			// containers
			$this->containers->ViewValue = $this->containers->CurrentValue;
			$this->containers->ViewCustomAttributes = "";

			// packets
			$this->packets->ViewValue = $this->packets->CurrentValue;
			$this->packets->ViewCustomAttributes = "";

			// purchase_amount
			$this->purchase_amount->ViewValue = $this->purchase_amount->CurrentValue;
			$this->purchase_amount->ViewCustomAttributes = "";

			// purchase_custom_duty
			$this->purchase_custom_duty->ViewValue = $this->purchase_custom_duty->CurrentValue;
			$this->purchase_custom_duty->ViewCustomAttributes = "";

			// s_custom_duty
			$this->s_custom_duty->ViewValue = $this->s_custom_duty->CurrentValue;
			$this->s_custom_duty->ViewCustomAttributes = "";

			// port_clearing_charge
			$this->port_clearing_charge->ViewValue = $this->port_clearing_charge->CurrentValue;
			$this->port_clearing_charge->ViewCustomAttributes = "";

			// s_port_clearing_charge
			$this->s_port_clearing_charge->ViewValue = $this->s_port_clearing_charge->CurrentValue;
			$this->s_port_clearing_charge->ViewCustomAttributes = "";

			// cha_commission
			$this->cha_commission->ViewValue = $this->cha_commission->CurrentValue;
			$this->cha_commission->ViewCustomAttributes = "";

			// s_cha_commission
			$this->s_cha_commission->ViewValue = $this->s_cha_commission->CurrentValue;
			$this->s_cha_commission->ViewCustomAttributes = "";

			// transportation_charges
			$this->transportation_charges->ViewValue = $this->transportation_charges->CurrentValue;
			$this->transportation_charges->ViewCustomAttributes = "";

			// s_transportation_charges
			$this->s_transportation_charges->ViewValue = $this->s_transportation_charges->CurrentValue;
			$this->s_transportation_charges->ViewCustomAttributes = "";

			// unloading_charges
			$this->unloading_charges->ViewValue = $this->unloading_charges->CurrentValue;
			$this->unloading_charges->ViewCustomAttributes = "";

			// rid
			$this->rid->LinkCustomAttributes = "";
			if (!EmptyValue($this->rid->CurrentValue)) {
				$this->rid->HrefValue = "wool_import_calculator1list.php?x_rid=" . $this->rid->CurrentValue; // Add prefix/suffix
				$this->rid->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
			} else {
				$this->rid->HrefValue = "";
			}
			$this->rid->TooltipValue = "";

			// product_code
			$this->product_code->LinkCustomAttributes = "";
			if (!EmptyValue($this->product_code->CurrentValue)) {
				$this->product_code->HrefValue = "wool_import_calculator1list.php?x_product_code=" . $this->product_code->CurrentValue; // Add prefix/suffix
				$this->product_code->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product_code->HrefValue = FullUrl($this->product_code->HrefValue, "href");
			} else {
				$this->product_code->HrefValue = "";
			}
			$this->product_code->TooltipValue = "";

			// godown_arrival_date
			$this->godown_arrival_date->LinkCustomAttributes = "";
			$this->godown_arrival_date->HrefValue = "";
			$this->godown_arrival_date->TooltipValue = "";

			// net_weight
			$this->net_weight->LinkCustomAttributes = "";
			$this->net_weight->HrefValue = "";
			$this->net_weight->TooltipValue = "";

			// containers
			$this->containers->LinkCustomAttributes = "";
			$this->containers->HrefValue = "";
			$this->containers->TooltipValue = "";

			// packets
			$this->packets->LinkCustomAttributes = "";
			$this->packets->HrefValue = "";
			$this->packets->TooltipValue = "";

			// purchase_amount
			$this->purchase_amount->LinkCustomAttributes = "";
			$this->purchase_amount->HrefValue = "";
			$this->purchase_amount->TooltipValue = "";

			// purchase_custom_duty
			$this->purchase_custom_duty->LinkCustomAttributes = "";
			$this->purchase_custom_duty->HrefValue = "";
			$this->purchase_custom_duty->TooltipValue = "";

			// s_custom_duty
			$this->s_custom_duty->LinkCustomAttributes = "";
			$this->s_custom_duty->HrefValue = "";
			$this->s_custom_duty->TooltipValue = "";

			// port_clearing_charge
			$this->port_clearing_charge->LinkCustomAttributes = "";
			$this->port_clearing_charge->HrefValue = "";
			$this->port_clearing_charge->TooltipValue = "";

			// s_port_clearing_charge
			$this->s_port_clearing_charge->LinkCustomAttributes = "";
			$this->s_port_clearing_charge->HrefValue = "";
			$this->s_port_clearing_charge->TooltipValue = "";

			// cha_commission
			$this->cha_commission->LinkCustomAttributes = "";
			$this->cha_commission->HrefValue = "";
			$this->cha_commission->TooltipValue = "";

			// s_cha_commission
			$this->s_cha_commission->LinkCustomAttributes = "";
			$this->s_cha_commission->HrefValue = "";
			$this->s_cha_commission->TooltipValue = "";

			// transportation_charges
			$this->transportation_charges->LinkCustomAttributes = "";
			$this->transportation_charges->HrefValue = "";
			$this->transportation_charges->TooltipValue = "";

			// s_transportation_charges
			$this->s_transportation_charges->LinkCustomAttributes = "";
			$this->s_transportation_charges->HrefValue = "";
			$this->s_transportation_charges->TooltipValue = "";

			// unloading_charges
			$this->unloading_charges->LinkCustomAttributes = "";
			$this->unloading_charges->HrefValue = "";
			$this->unloading_charges->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// rid
			$this->rid->EditAttrs["class"] = "form-control";
			$this->rid->EditCustomAttributes = "";
			$this->rid->EditValue = HtmlEncode($this->rid->AdvancedSearch->SearchValue);
			$this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

			// product_code
			$this->product_code->EditAttrs["class"] = "form-control";
			$this->product_code->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->product_code->AdvancedSearch->SearchValue = HtmlDecode($this->product_code->AdvancedSearch->SearchValue);
			$this->product_code->EditValue = HtmlEncode($this->product_code->AdvancedSearch->SearchValue);
			$this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

			// godown_arrival_date
			$this->godown_arrival_date->EditAttrs["class"] = "form-control";
			$this->godown_arrival_date->EditCustomAttributes = "";
			$this->godown_arrival_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->godown_arrival_date->AdvancedSearch->SearchValue, 0), 8));
			$this->godown_arrival_date->PlaceHolder = RemoveHtml($this->godown_arrival_date->caption());

			// net_weight
			$this->net_weight->EditAttrs["class"] = "form-control";
			$this->net_weight->EditCustomAttributes = "";
			$this->net_weight->EditValue = HtmlEncode($this->net_weight->AdvancedSearch->SearchValue);
			$this->net_weight->PlaceHolder = RemoveHtml($this->net_weight->caption());

			// containers
			$this->containers->EditAttrs["class"] = "form-control";
			$this->containers->EditCustomAttributes = "";
			$this->containers->EditValue = HtmlEncode($this->containers->AdvancedSearch->SearchValue);
			$this->containers->PlaceHolder = RemoveHtml($this->containers->caption());

			// packets
			$this->packets->EditAttrs["class"] = "form-control";
			$this->packets->EditCustomAttributes = "";
			$this->packets->EditValue = HtmlEncode($this->packets->AdvancedSearch->SearchValue);
			$this->packets->PlaceHolder = RemoveHtml($this->packets->caption());

			// purchase_amount
			$this->purchase_amount->EditAttrs["class"] = "form-control";
			$this->purchase_amount->EditCustomAttributes = "";
			$this->purchase_amount->EditValue = HtmlEncode($this->purchase_amount->AdvancedSearch->SearchValue);
			$this->purchase_amount->PlaceHolder = RemoveHtml($this->purchase_amount->caption());

			// purchase_custom_duty
			$this->purchase_custom_duty->EditAttrs["class"] = "form-control";
			$this->purchase_custom_duty->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->purchase_custom_duty->AdvancedSearch->SearchValue = HtmlDecode($this->purchase_custom_duty->AdvancedSearch->SearchValue);
			$this->purchase_custom_duty->EditValue = HtmlEncode($this->purchase_custom_duty->AdvancedSearch->SearchValue);
			$this->purchase_custom_duty->PlaceHolder = RemoveHtml($this->purchase_custom_duty->caption());

			// s_custom_duty
			$this->s_custom_duty->EditAttrs["class"] = "form-control";
			$this->s_custom_duty->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->s_custom_duty->AdvancedSearch->SearchValue = HtmlDecode($this->s_custom_duty->AdvancedSearch->SearchValue);
			$this->s_custom_duty->EditValue = HtmlEncode($this->s_custom_duty->AdvancedSearch->SearchValue);
			$this->s_custom_duty->PlaceHolder = RemoveHtml($this->s_custom_duty->caption());

			// port_clearing_charge
			$this->port_clearing_charge->EditAttrs["class"] = "form-control";
			$this->port_clearing_charge->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->port_clearing_charge->AdvancedSearch->SearchValue = HtmlDecode($this->port_clearing_charge->AdvancedSearch->SearchValue);
			$this->port_clearing_charge->EditValue = HtmlEncode($this->port_clearing_charge->AdvancedSearch->SearchValue);
			$this->port_clearing_charge->PlaceHolder = RemoveHtml($this->port_clearing_charge->caption());

			// s_port_clearing_charge
			$this->s_port_clearing_charge->EditAttrs["class"] = "form-control";
			$this->s_port_clearing_charge->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->s_port_clearing_charge->AdvancedSearch->SearchValue = HtmlDecode($this->s_port_clearing_charge->AdvancedSearch->SearchValue);
			$this->s_port_clearing_charge->EditValue = HtmlEncode($this->s_port_clearing_charge->AdvancedSearch->SearchValue);
			$this->s_port_clearing_charge->PlaceHolder = RemoveHtml($this->s_port_clearing_charge->caption());

			// cha_commission
			$this->cha_commission->EditAttrs["class"] = "form-control";
			$this->cha_commission->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->cha_commission->AdvancedSearch->SearchValue = HtmlDecode($this->cha_commission->AdvancedSearch->SearchValue);
			$this->cha_commission->EditValue = HtmlEncode($this->cha_commission->AdvancedSearch->SearchValue);
			$this->cha_commission->PlaceHolder = RemoveHtml($this->cha_commission->caption());

			// s_cha_commission
			$this->s_cha_commission->EditAttrs["class"] = "form-control";
			$this->s_cha_commission->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->s_cha_commission->AdvancedSearch->SearchValue = HtmlDecode($this->s_cha_commission->AdvancedSearch->SearchValue);
			$this->s_cha_commission->EditValue = HtmlEncode($this->s_cha_commission->AdvancedSearch->SearchValue);
			$this->s_cha_commission->PlaceHolder = RemoveHtml($this->s_cha_commission->caption());

			// transportation_charges
			$this->transportation_charges->EditAttrs["class"] = "form-control";
			$this->transportation_charges->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->transportation_charges->AdvancedSearch->SearchValue = HtmlDecode($this->transportation_charges->AdvancedSearch->SearchValue);
			$this->transportation_charges->EditValue = HtmlEncode($this->transportation_charges->AdvancedSearch->SearchValue);
			$this->transportation_charges->PlaceHolder = RemoveHtml($this->transportation_charges->caption());

			// s_transportation_charges
			$this->s_transportation_charges->EditAttrs["class"] = "form-control";
			$this->s_transportation_charges->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->s_transportation_charges->AdvancedSearch->SearchValue = HtmlDecode($this->s_transportation_charges->AdvancedSearch->SearchValue);
			$this->s_transportation_charges->EditValue = HtmlEncode($this->s_transportation_charges->AdvancedSearch->SearchValue);
			$this->s_transportation_charges->PlaceHolder = RemoveHtml($this->s_transportation_charges->caption());

			// unloading_charges
			$this->unloading_charges->EditAttrs["class"] = "form-control";
			$this->unloading_charges->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->unloading_charges->AdvancedSearch->SearchValue = HtmlDecode($this->unloading_charges->AdvancedSearch->SearchValue);
			$this->unloading_charges->EditValue = HtmlEncode($this->unloading_charges->AdvancedSearch->SearchValue);
			$this->unloading_charges->PlaceHolder = RemoveHtml($this->unloading_charges->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->rid->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->rid->errorMessage());
		}
		if (!CheckDate($this->godown_arrival_date->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->godown_arrival_date->errorMessage());
		}
		if (!CheckNumber($this->net_weight->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->net_weight->errorMessage());
		}
		if (!CheckNumber($this->containers->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->containers->errorMessage());
		}
		if (!CheckInteger($this->packets->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->packets->errorMessage());
		}
		if (!CheckNumber($this->purchase_amount->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->purchase_amount->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->rid->AdvancedSearch->load();
		$this->product_code->AdvancedSearch->load();
		$this->godown_arrival_date->AdvancedSearch->load();
		$this->net_weight->AdvancedSearch->load();
		$this->containers->AdvancedSearch->load();
		$this->packets->AdvancedSearch->load();
		$this->purchase_amount->AdvancedSearch->load();
		$this->purchase_custom_duty->AdvancedSearch->load();
		$this->s_custom_duty->AdvancedSearch->load();
		$this->port_clearing_charge->AdvancedSearch->load();
		$this->s_port_clearing_charge->AdvancedSearch->load();
		$this->cha_commission->AdvancedSearch->load();
		$this->s_cha_commission->AdvancedSearch->load();
		$this->transportation_charges->AdvancedSearch->load();
		$this->s_transportation_charges->AdvancedSearch->load();
		$this->unloading_charges->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("wool_import_calculator1list.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>