<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for ww_color
 */
class ww_color extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $color;
	public $color_source;
	public $base_color;
	public $match_clariant;
	public $match_poddar;
	public $match_polyone;
	public $moq;
	public $m_stock;
	public $stock;
	public $required;
	public $ordered;
	public $pending_order;
	public $status;
	public $operator;
	public $datetime;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'ww_color';
		$this->TableName = 'ww_color';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`ww_color`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('ww_color', 'ww_color', 'x_id', 'id', '`id`', '`id`', 2, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// color
		$this->color = new DbField('ww_color', 'ww_color', 'x_color', 'color', '`color`', '`color`', 200, -1, FALSE, '`color`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->color->Required = TRUE; // Required field
		$this->color->Sortable = TRUE; // Allow sort
		$this->fields['color'] = &$this->color;

		// color_source
		$this->color_source = new DbField('ww_color', 'ww_color', 'x_color_source', 'color_source', '`color_source`', '`color_source`', 200, -1, FALSE, '`color_source`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->color_source->Required = TRUE; // Required field
		$this->color_source->Sortable = TRUE; // Allow sort
		$this->color_source->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->color_source->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->color_source->Lookup = new Lookup('color_source', 'ww_color', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->color_source->OptionCount = 3;
		$this->fields['color_source'] = &$this->color_source;

		// base_color
		$this->base_color = new DbField('ww_color', 'ww_color', 'x_base_color', 'base_color', '`base_color`', '`base_color`', 18, -1, FALSE, '`base_color`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->base_color->Nullable = FALSE; // NOT NULL field
		$this->base_color->Sortable = TRUE; // Allow sort
		$this->base_color->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->base_color->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->base_color->Lookup = new Lookup('base_color', 'ww_color', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->base_color->OptionCount = 2;
		$this->base_color->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['base_color'] = &$this->base_color;

		// match_clariant
		$this->match_clariant = new DbField('ww_color', 'ww_color', 'x_match_clariant', 'match_clariant', '`match_clariant`', '`match_clariant`', 18, -1, FALSE, '`match_clariant`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->match_clariant->Nullable = FALSE; // NOT NULL field
		$this->match_clariant->Required = TRUE; // Required field
		$this->match_clariant->Sortable = TRUE; // Allow sort
		$this->match_clariant->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->match_clariant->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->match_clariant->Lookup = new Lookup('match_clariant', 'ww_color', FALSE, 'id', ["color","","",""], [], [], [], [], [], [], '`color` ASC', '');
		$this->match_clariant->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['match_clariant'] = &$this->match_clariant;

		// match_poddar
		$this->match_poddar = new DbField('ww_color', 'ww_color', 'x_match_poddar', 'match_poddar', '`match_poddar`', '`match_poddar`', 18, -1, FALSE, '`match_poddar`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->match_poddar->Nullable = FALSE; // NOT NULL field
		$this->match_poddar->Required = TRUE; // Required field
		$this->match_poddar->Sortable = TRUE; // Allow sort
		$this->match_poddar->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->match_poddar->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->match_poddar->Lookup = new Lookup('match_poddar', 'ww_color', FALSE, 'id', ["color","","",""], [], [], [], [], [], [], '`color` ASC', '');
		$this->match_poddar->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['match_poddar'] = &$this->match_poddar;

		// match_polyone
		$this->match_polyone = new DbField('ww_color', 'ww_color', 'x_match_polyone', 'match_polyone', '`match_polyone`', '`match_polyone`', 18, -1, FALSE, '`match_polyone`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->match_polyone->Nullable = FALSE; // NOT NULL field
		$this->match_polyone->Required = TRUE; // Required field
		$this->match_polyone->Sortable = TRUE; // Allow sort
		$this->match_polyone->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->match_polyone->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->match_polyone->Lookup = new Lookup('match_polyone', 'ww_color', FALSE, 'id', ["color","","",""], [], [], [], [], [], [], '`color` ASC', '');
		$this->match_polyone->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['match_polyone'] = &$this->match_polyone;

		// moq
		$this->moq = new DbField('ww_color', 'ww_color', 'x_moq', 'moq', '`moq`', '`moq`', 4, -1, FALSE, '`moq`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->moq->Sortable = TRUE; // Allow sort
		$this->moq->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['moq'] = &$this->moq;

		// m_stock
		$this->m_stock = new DbField('ww_color', 'ww_color', 'x_m_stock', 'm_stock', '`m_stock`', '`m_stock`', 4, -1, FALSE, '`m_stock`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->m_stock->Nullable = FALSE; // NOT NULL field
		$this->m_stock->Sortable = TRUE; // Allow sort
		$this->m_stock->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['m_stock'] = &$this->m_stock;

		// stock
		$this->stock = new DbField('ww_color', 'ww_color', 'x_stock', 'stock', '`stock`', '`stock`', 4, -1, FALSE, '`stock`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->stock->Nullable = FALSE; // NOT NULL field
		$this->stock->Sortable = TRUE; // Allow sort
		$this->stock->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['stock'] = &$this->stock;

		// required
		$this->required = new DbField('ww_color', 'ww_color', 'x_required', 'required', '`required`', '`required`', 4, -1, FALSE, '`required`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->required->Nullable = FALSE; // NOT NULL field
		$this->required->Sortable = TRUE; // Allow sort
		$this->required->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['required'] = &$this->required;

		// ordered
		$this->ordered = new DbField('ww_color', 'ww_color', 'x_ordered', 'ordered', '`ordered`', '`ordered`', 4, -1, FALSE, '`ordered`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ordered->Nullable = FALSE; // NOT NULL field
		$this->ordered->Sortable = TRUE; // Allow sort
		$this->ordered->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['ordered'] = &$this->ordered;

		// pending_order
		$this->pending_order = new DbField('ww_color', 'ww_color', 'x_pending_order', 'pending_order', '`pending_order`', '`pending_order`', 4, -1, FALSE, '`pending_order`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pending_order->Nullable = FALSE; // NOT NULL field
		$this->pending_order->Sortable = TRUE; // Allow sort
		$this->pending_order->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['pending_order'] = &$this->pending_order;

		// status
		$this->status = new DbField('ww_color', 'ww_color', 'x_status', 'status', '`status`', '`status`', 18, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->Lookup = new Lookup('status', 'ww_color', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->status->OptionCount = 2;
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// operator
		$this->operator = new DbField('ww_color', 'ww_color', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('ww_color', 'ww_color', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Nullable = FALSE; // NOT NULL field
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`ww_color`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->color->DbValue = $row['color'];
		$this->color_source->DbValue = $row['color_source'];
		$this->base_color->DbValue = $row['base_color'];
		$this->match_clariant->DbValue = $row['match_clariant'];
		$this->match_poddar->DbValue = $row['match_poddar'];
		$this->match_polyone->DbValue = $row['match_polyone'];
		$this->moq->DbValue = $row['moq'];
		$this->m_stock->DbValue = $row['m_stock'];
		$this->stock->DbValue = $row['stock'];
		$this->required->DbValue = $row['required'];
		$this->ordered->DbValue = $row['ordered'];
		$this->pending_order->DbValue = $row['pending_order'];
		$this->status->DbValue = $row['status'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "ww_colorlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "ww_colorview.php")
			return $Language->phrase("View");
		elseif ($pageName == "ww_coloredit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "ww_coloradd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "ww_colorlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("ww_colorview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("ww_colorview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "ww_coloradd.php?" . $this->getUrlParm($parm);
		else
			$url = "ww_coloradd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("ww_coloredit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("ww_coloradd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("ww_colordelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->color->setDbValue($rs->fields('color'));
		$this->color_source->setDbValue($rs->fields('color_source'));
		$this->base_color->setDbValue($rs->fields('base_color'));
		$this->match_clariant->setDbValue($rs->fields('match_clariant'));
		$this->match_poddar->setDbValue($rs->fields('match_poddar'));
		$this->match_polyone->setDbValue($rs->fields('match_polyone'));
		$this->moq->setDbValue($rs->fields('moq'));
		$this->m_stock->setDbValue($rs->fields('m_stock'));
		$this->stock->setDbValue($rs->fields('stock'));
		$this->required->setDbValue($rs->fields('required'));
		$this->ordered->setDbValue($rs->fields('ordered'));
		$this->pending_order->setDbValue($rs->fields('pending_order'));
		$this->status->setDbValue($rs->fields('status'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// color
		// color_source
		// base_color
		// match_clariant
		// match_poddar
		// match_polyone
		// moq
		// m_stock
		// stock
		// required
		// ordered
		// pending_order
		// status
		// operator
		// datetime
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// color
		$this->color->ViewValue = $this->color->CurrentValue;
		$this->color->ViewCustomAttributes = "";

		// color_source
		if (strval($this->color_source->CurrentValue) <> "") {
			$this->color_source->ViewValue = $this->color_source->optionCaption($this->color_source->CurrentValue);
		} else {
			$this->color_source->ViewValue = NULL;
		}
		$this->color_source->ViewCustomAttributes = "";

		// base_color
		if (strval($this->base_color->CurrentValue) <> "") {
			$this->base_color->ViewValue = $this->base_color->optionCaption($this->base_color->CurrentValue);
		} else {
			$this->base_color->ViewValue = NULL;
		}
		$this->base_color->ViewCustomAttributes = "";

		// match_clariant
		$curVal = strval($this->match_clariant->CurrentValue);
		if ($curVal <> "") {
			$this->match_clariant->ViewValue = $this->match_clariant->lookupCacheOption($curVal);
			if ($this->match_clariant->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`color_source` = 'Clariant' or `id` = 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->match_clariant->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->match_clariant->ViewValue = $this->match_clariant->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->match_clariant->ViewValue = $this->match_clariant->CurrentValue;
				}
			}
		} else {
			$this->match_clariant->ViewValue = NULL;
		}
		$this->match_clariant->ViewCustomAttributes = "";

		// match_poddar
		$curVal = strval($this->match_poddar->CurrentValue);
		if ($curVal <> "") {
			$this->match_poddar->ViewValue = $this->match_poddar->lookupCacheOption($curVal);
			if ($this->match_poddar->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`color_source` =  'Poddar' or `id` = 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->match_poddar->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->match_poddar->ViewValue = $this->match_poddar->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->match_poddar->ViewValue = $this->match_poddar->CurrentValue;
				}
			}
		} else {
			$this->match_poddar->ViewValue = NULL;
		}
		$this->match_poddar->ViewCustomAttributes = "";

		// match_polyone
		$curVal = strval($this->match_polyone->CurrentValue);
		if ($curVal <> "") {
			$this->match_polyone->ViewValue = $this->match_polyone->lookupCacheOption($curVal);
			if ($this->match_polyone->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`color_source` =  'Polyone' or `id` = 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->match_polyone->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->match_polyone->ViewValue = $this->match_polyone->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->match_polyone->ViewValue = $this->match_polyone->CurrentValue;
				}
			}
		} else {
			$this->match_polyone->ViewValue = NULL;
		}
		$this->match_polyone->ViewCustomAttributes = "";

		// moq
		$this->moq->ViewValue = $this->moq->CurrentValue;
		$this->moq->ViewValue = FormatNumber($this->moq->ViewValue, 2, -2, -2, -2);
		$this->moq->ViewCustomAttributes = "";

		// m_stock
		$this->m_stock->ViewValue = $this->m_stock->CurrentValue;
		$this->m_stock->ViewValue = FormatNumber($this->m_stock->ViewValue, 2, -2, -2, -2);
		$this->m_stock->ViewCustomAttributes = "";

		// stock
		$this->stock->ViewValue = $this->stock->CurrentValue;
		$this->stock->ViewValue = FormatNumber($this->stock->ViewValue, 2, -2, -2, -2);
		$this->stock->ViewCustomAttributes = "";

		// required
		$this->required->ViewValue = $this->required->CurrentValue;
		$this->required->ViewValue = FormatNumber($this->required->ViewValue, 2, -2, -2, -2);
		$this->required->ViewCustomAttributes = "";

		// ordered
		$this->ordered->ViewValue = $this->ordered->CurrentValue;
		$this->ordered->ViewValue = FormatNumber($this->ordered->ViewValue, 2, -2, -2, -2);
		$this->ordered->ViewCustomAttributes = "";

		// pending_order
		$this->pending_order->ViewValue = $this->pending_order->CurrentValue;
		$this->pending_order->ViewValue = FormatNumber($this->pending_order->ViewValue, 2, -2, -2, -2);
		$this->pending_order->ViewCustomAttributes = "";

		// status
		if (strval($this->status->CurrentValue) <> "") {
			$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// operator
		$this->operator->ViewValue = $this->operator->CurrentValue;
		$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// color
		$this->color->LinkCustomAttributes = "";
		$this->color->HrefValue = "";
		$this->color->TooltipValue = "";

		// color_source
		$this->color_source->LinkCustomAttributes = "";
		$this->color_source->HrefValue = "";
		$this->color_source->TooltipValue = "";

		// base_color
		$this->base_color->LinkCustomAttributes = "";
		$this->base_color->HrefValue = "";
		$this->base_color->TooltipValue = "";

		// match_clariant
		$this->match_clariant->LinkCustomAttributes = "";
		$this->match_clariant->HrefValue = "";
		$this->match_clariant->TooltipValue = "";

		// match_poddar
		$this->match_poddar->LinkCustomAttributes = "";
		$this->match_poddar->HrefValue = "";
		$this->match_poddar->TooltipValue = "";

		// match_polyone
		$this->match_polyone->LinkCustomAttributes = "";
		$this->match_polyone->HrefValue = "";
		$this->match_polyone->TooltipValue = "";

		// moq
		$this->moq->LinkCustomAttributes = "";
		$this->moq->HrefValue = "";
		$this->moq->TooltipValue = "";

		// m_stock
		$this->m_stock->LinkCustomAttributes = "";
		$this->m_stock->HrefValue = "";
		$this->m_stock->TooltipValue = "";

		// stock
		$this->stock->LinkCustomAttributes = "";
		$this->stock->HrefValue = "";
		$this->stock->TooltipValue = "";

		// required
		$this->required->LinkCustomAttributes = "";
		$this->required->HrefValue = "";
		$this->required->TooltipValue = "";

		// ordered
		$this->ordered->LinkCustomAttributes = "";
		$this->ordered->HrefValue = "";
		$this->ordered->TooltipValue = "";

		// pending_order
		$this->pending_order->LinkCustomAttributes = "";
		$this->pending_order->HrefValue = "";
		$this->pending_order->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// color
		$this->color->EditAttrs["class"] = "form-control";
		$this->color->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->color->CurrentValue = HtmlDecode($this->color->CurrentValue);
		$this->color->EditValue = $this->color->CurrentValue;
		$this->color->PlaceHolder = RemoveHtml($this->color->caption());

		// color_source
		$this->color_source->EditAttrs["class"] = "form-control";
		$this->color_source->EditCustomAttributes = "";
		$this->color_source->EditValue = $this->color_source->options(TRUE);

		// base_color
		$this->base_color->EditAttrs["class"] = "form-control";
		$this->base_color->EditCustomAttributes = "";
		$this->base_color->EditValue = $this->base_color->options(TRUE);

		// match_clariant
		$this->match_clariant->EditAttrs["class"] = "form-control";
		$this->match_clariant->EditCustomAttributes = "";

		// match_poddar
		$this->match_poddar->EditAttrs["class"] = "form-control";
		$this->match_poddar->EditCustomAttributes = "";

		// match_polyone
		$this->match_polyone->EditAttrs["class"] = "form-control";
		$this->match_polyone->EditCustomAttributes = "";

		// moq
		$this->moq->EditAttrs["class"] = "form-control";
		$this->moq->EditCustomAttributes = "";
		$this->moq->EditValue = $this->moq->CurrentValue;
		$this->moq->PlaceHolder = RemoveHtml($this->moq->caption());
		if (strval($this->moq->EditValue) <> "" && is_numeric($this->moq->EditValue))
			$this->moq->EditValue = FormatNumber($this->moq->EditValue, -2, -2, -2, -2);

		// m_stock
		$this->m_stock->EditAttrs["class"] = "form-control";
		$this->m_stock->EditCustomAttributes = "";
		$this->m_stock->EditValue = $this->m_stock->CurrentValue;
		$this->m_stock->PlaceHolder = RemoveHtml($this->m_stock->caption());
		if (strval($this->m_stock->EditValue) <> "" && is_numeric($this->m_stock->EditValue))
			$this->m_stock->EditValue = FormatNumber($this->m_stock->EditValue, -2, -2, -2, -2);

		// stock
		$this->stock->EditAttrs["class"] = "form-control";
		$this->stock->EditCustomAttributes = "";
		$this->stock->EditValue = $this->stock->CurrentValue;
		$this->stock->PlaceHolder = RemoveHtml($this->stock->caption());
		if (strval($this->stock->EditValue) <> "" && is_numeric($this->stock->EditValue))
			$this->stock->EditValue = FormatNumber($this->stock->EditValue, -2, -2, -2, -2);

		// required
		$this->required->EditAttrs["class"] = "form-control";
		$this->required->EditCustomAttributes = "";
		$this->required->EditValue = $this->required->CurrentValue;
		$this->required->PlaceHolder = RemoveHtml($this->required->caption());
		if (strval($this->required->EditValue) <> "" && is_numeric($this->required->EditValue))
			$this->required->EditValue = FormatNumber($this->required->EditValue, -2, -2, -2, -2);

		// ordered
		$this->ordered->EditAttrs["class"] = "form-control";
		$this->ordered->EditCustomAttributes = "";
		$this->ordered->EditValue = $this->ordered->CurrentValue;
		$this->ordered->PlaceHolder = RemoveHtml($this->ordered->caption());
		if (strval($this->ordered->EditValue) <> "" && is_numeric($this->ordered->EditValue))
			$this->ordered->EditValue = FormatNumber($this->ordered->EditValue, -2, -2, -2, -2);

		// pending_order
		$this->pending_order->EditAttrs["class"] = "form-control";
		$this->pending_order->EditCustomAttributes = "";
		$this->pending_order->EditValue = $this->pending_order->CurrentValue;
		$this->pending_order->PlaceHolder = RemoveHtml($this->pending_order->caption());
		if (strval($this->pending_order->EditValue) <> "" && is_numeric($this->pending_order->EditValue))
			$this->pending_order->EditValue = FormatNumber($this->pending_order->EditValue, -2, -2, -2, -2);

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		$this->status->EditValue = $this->status->options(TRUE);

		// operator
		// datetime
		// Call Row Rendered event

		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->color);
					$doc->exportCaption($this->color_source);
					$doc->exportCaption($this->base_color);
					$doc->exportCaption($this->match_clariant);
					$doc->exportCaption($this->match_poddar);
					$doc->exportCaption($this->match_polyone);
					$doc->exportCaption($this->moq);
					$doc->exportCaption($this->m_stock);
					$doc->exportCaption($this->stock);
					$doc->exportCaption($this->required);
					$doc->exportCaption($this->ordered);
					$doc->exportCaption($this->pending_order);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->color);
					$doc->exportCaption($this->color_source);
					$doc->exportCaption($this->base_color);
					$doc->exportCaption($this->match_clariant);
					$doc->exportCaption($this->match_poddar);
					$doc->exportCaption($this->match_polyone);
					$doc->exportCaption($this->moq);
					$doc->exportCaption($this->m_stock);
					$doc->exportCaption($this->stock);
					$doc->exportCaption($this->required);
					$doc->exportCaption($this->ordered);
					$doc->exportCaption($this->pending_order);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->color);
						$doc->exportField($this->color_source);
						$doc->exportField($this->base_color);
						$doc->exportField($this->match_clariant);
						$doc->exportField($this->match_poddar);
						$doc->exportField($this->match_polyone);
						$doc->exportField($this->moq);
						$doc->exportField($this->m_stock);
						$doc->exportField($this->stock);
						$doc->exportField($this->required);
						$doc->exportField($this->ordered);
						$doc->exportField($this->pending_order);
						$doc->exportField($this->status);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->color);
						$doc->exportField($this->color_source);
						$doc->exportField($this->base_color);
						$doc->exportField($this->match_clariant);
						$doc->exportField($this->match_poddar);
						$doc->exportField($this->match_polyone);
						$doc->exportField($this->moq);
						$doc->exportField($this->m_stock);
						$doc->exportField($this->stock);
						$doc->exportField($this->required);
						$doc->exportField($this->ordered);
						$doc->exportField($this->pending_order);
						$doc->exportField($this->status);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>