<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class ww_color_edit extends ww_color
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'ww_color';

	// Page object name
	public $PageObjName = "ww_color_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (ww_color)
		if (!isset($GLOBALS["ww_color"]) || get_class($GLOBALS["ww_color"]) == PROJECT_NAMESPACE . "ww_color") {
			$GLOBALS["ww_color"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["ww_color"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'ww_color');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $ww_color;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($ww_color);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "ww_colorview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("ww_colorlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->color->setVisibility();
		$this->color_source->setVisibility();
		$this->base_color->setVisibility();
		$this->match_clariant->setVisibility();
		$this->match_poddar->setVisibility();
		$this->match_polyone->setVisibility();
		$this->moq->setVisibility();
		$this->m_stock->setVisibility();
		$this->stock->setVisibility();
		$this->required->Visible = FALSE;
		$this->ordered->Visible = FALSE;
		$this->pending_order->Visible = FALSE;
		$this->status->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->match_clariant);
		$this->setupLookupOptions($this->match_poddar);
		$this->setupLookupOptions($this->match_polyone);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("ww_colorlist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "ww_colorlist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);

		// Check field name 'color' first before field var 'x_color'
		$val = $CurrentForm->hasValue("color") ? $CurrentForm->getValue("color") : $CurrentForm->getValue("x_color");
		if (!$this->color->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->color->Visible = FALSE; // Disable update for API request
			else
				$this->color->setFormValue($val);
		}

		// Check field name 'color_source' first before field var 'x_color_source'
		$val = $CurrentForm->hasValue("color_source") ? $CurrentForm->getValue("color_source") : $CurrentForm->getValue("x_color_source");
		if (!$this->color_source->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->color_source->Visible = FALSE; // Disable update for API request
			else
				$this->color_source->setFormValue($val);
		}

		// Check field name 'base_color' first before field var 'x_base_color'
		$val = $CurrentForm->hasValue("base_color") ? $CurrentForm->getValue("base_color") : $CurrentForm->getValue("x_base_color");
		if (!$this->base_color->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->base_color->Visible = FALSE; // Disable update for API request
			else
				$this->base_color->setFormValue($val);
		}

		// Check field name 'match_clariant' first before field var 'x_match_clariant'
		$val = $CurrentForm->hasValue("match_clariant") ? $CurrentForm->getValue("match_clariant") : $CurrentForm->getValue("x_match_clariant");
		if (!$this->match_clariant->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->match_clariant->Visible = FALSE; // Disable update for API request
			else
				$this->match_clariant->setFormValue($val);
		}

		// Check field name 'match_poddar' first before field var 'x_match_poddar'
		$val = $CurrentForm->hasValue("match_poddar") ? $CurrentForm->getValue("match_poddar") : $CurrentForm->getValue("x_match_poddar");
		if (!$this->match_poddar->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->match_poddar->Visible = FALSE; // Disable update for API request
			else
				$this->match_poddar->setFormValue($val);
		}

		// Check field name 'match_polyone' first before field var 'x_match_polyone'
		$val = $CurrentForm->hasValue("match_polyone") ? $CurrentForm->getValue("match_polyone") : $CurrentForm->getValue("x_match_polyone");
		if (!$this->match_polyone->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->match_polyone->Visible = FALSE; // Disable update for API request
			else
				$this->match_polyone->setFormValue($val);
		}

		// Check field name 'moq' first before field var 'x_moq'
		$val = $CurrentForm->hasValue("moq") ? $CurrentForm->getValue("moq") : $CurrentForm->getValue("x_moq");
		if (!$this->moq->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->moq->Visible = FALSE; // Disable update for API request
			else
				$this->moq->setFormValue($val);
		}

		// Check field name 'm_stock' first before field var 'x_m_stock'
		$val = $CurrentForm->hasValue("m_stock") ? $CurrentForm->getValue("m_stock") : $CurrentForm->getValue("x_m_stock");
		if (!$this->m_stock->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_stock->Visible = FALSE; // Disable update for API request
			else
				$this->m_stock->setFormValue($val);
		}

		// Check field name 'stock' first before field var 'x_stock'
		$val = $CurrentForm->hasValue("stock") ? $CurrentForm->getValue("stock") : $CurrentForm->getValue("x_stock");
		if (!$this->stock->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->stock->Visible = FALSE; // Disable update for API request
			else
				$this->stock->setFormValue($val);
		}

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status->Visible = FALSE; // Disable update for API request
			else
				$this->status->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->color->CurrentValue = $this->color->FormValue;
		$this->color_source->CurrentValue = $this->color_source->FormValue;
		$this->base_color->CurrentValue = $this->base_color->FormValue;
		$this->match_clariant->CurrentValue = $this->match_clariant->FormValue;
		$this->match_poddar->CurrentValue = $this->match_poddar->FormValue;
		$this->match_polyone->CurrentValue = $this->match_polyone->FormValue;
		$this->moq->CurrentValue = $this->moq->FormValue;
		$this->m_stock->CurrentValue = $this->m_stock->FormValue;
		$this->stock->CurrentValue = $this->stock->FormValue;
		$this->status->CurrentValue = $this->status->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->color->setDbValue($row['color']);
		$this->color_source->setDbValue($row['color_source']);
		$this->base_color->setDbValue($row['base_color']);
		$this->match_clariant->setDbValue($row['match_clariant']);
		$this->match_poddar->setDbValue($row['match_poddar']);
		$this->match_polyone->setDbValue($row['match_polyone']);
		$this->moq->setDbValue($row['moq']);
		$this->m_stock->setDbValue($row['m_stock']);
		$this->stock->setDbValue($row['stock']);
		$this->required->setDbValue($row['required']);
		$this->ordered->setDbValue($row['ordered']);
		$this->pending_order->setDbValue($row['pending_order']);
		$this->status->setDbValue($row['status']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['color'] = NULL;
		$row['color_source'] = NULL;
		$row['base_color'] = NULL;
		$row['match_clariant'] = NULL;
		$row['match_poddar'] = NULL;
		$row['match_polyone'] = NULL;
		$row['moq'] = NULL;
		$row['m_stock'] = NULL;
		$row['stock'] = NULL;
		$row['required'] = NULL;
		$row['ordered'] = NULL;
		$row['pending_order'] = NULL;
		$row['status'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->moq->FormValue == $this->moq->CurrentValue && is_numeric(ConvertToFloatString($this->moq->CurrentValue)))
			$this->moq->CurrentValue = ConvertToFloatString($this->moq->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_stock->FormValue == $this->m_stock->CurrentValue && is_numeric(ConvertToFloatString($this->m_stock->CurrentValue)))
			$this->m_stock->CurrentValue = ConvertToFloatString($this->m_stock->CurrentValue);

		// Convert decimal values if posted back
		if ($this->stock->FormValue == $this->stock->CurrentValue && is_numeric(ConvertToFloatString($this->stock->CurrentValue)))
			$this->stock->CurrentValue = ConvertToFloatString($this->stock->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// color
		// color_source
		// base_color
		// match_clariant
		// match_poddar
		// match_polyone
		// moq
		// m_stock
		// stock
		// required
		// ordered
		// pending_order
		// status
		// operator
		// datetime

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// color
			$this->color->ViewValue = $this->color->CurrentValue;
			$this->color->ViewCustomAttributes = "";

			// color_source
			if (strval($this->color_source->CurrentValue) <> "") {
				$this->color_source->ViewValue = $this->color_source->optionCaption($this->color_source->CurrentValue);
			} else {
				$this->color_source->ViewValue = NULL;
			}
			$this->color_source->ViewCustomAttributes = "";

			// base_color
			if (strval($this->base_color->CurrentValue) <> "") {
				$this->base_color->ViewValue = $this->base_color->optionCaption($this->base_color->CurrentValue);
			} else {
				$this->base_color->ViewValue = NULL;
			}
			$this->base_color->ViewCustomAttributes = "";

			// match_clariant
			$curVal = strval($this->match_clariant->CurrentValue);
			if ($curVal <> "") {
				$this->match_clariant->ViewValue = $this->match_clariant->lookupCacheOption($curVal);
				if ($this->match_clariant->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`color_source` = 'Clariant' or `id` = 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->match_clariant->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->match_clariant->ViewValue = $this->match_clariant->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->match_clariant->ViewValue = $this->match_clariant->CurrentValue;
					}
				}
			} else {
				$this->match_clariant->ViewValue = NULL;
			}
			$this->match_clariant->ViewCustomAttributes = "";

			// match_poddar
			$curVal = strval($this->match_poddar->CurrentValue);
			if ($curVal <> "") {
				$this->match_poddar->ViewValue = $this->match_poddar->lookupCacheOption($curVal);
				if ($this->match_poddar->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`color_source` =  'Poddar' or `id` = 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->match_poddar->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->match_poddar->ViewValue = $this->match_poddar->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->match_poddar->ViewValue = $this->match_poddar->CurrentValue;
					}
				}
			} else {
				$this->match_poddar->ViewValue = NULL;
			}
			$this->match_poddar->ViewCustomAttributes = "";

			// match_polyone
			$curVal = strval($this->match_polyone->CurrentValue);
			if ($curVal <> "") {
				$this->match_polyone->ViewValue = $this->match_polyone->lookupCacheOption($curVal);
				if ($this->match_polyone->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`color_source` =  'Polyone' or `id` = 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->match_polyone->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->match_polyone->ViewValue = $this->match_polyone->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->match_polyone->ViewValue = $this->match_polyone->CurrentValue;
					}
				}
			} else {
				$this->match_polyone->ViewValue = NULL;
			}
			$this->match_polyone->ViewCustomAttributes = "";

			// moq
			$this->moq->ViewValue = $this->moq->CurrentValue;
			$this->moq->ViewValue = FormatNumber($this->moq->ViewValue, 2, -2, -2, -2);
			$this->moq->ViewCustomAttributes = "";

			// m_stock
			$this->m_stock->ViewValue = $this->m_stock->CurrentValue;
			$this->m_stock->ViewValue = FormatNumber($this->m_stock->ViewValue, 2, -2, -2, -2);
			$this->m_stock->ViewCustomAttributes = "";

			// stock
			$this->stock->ViewValue = $this->stock->CurrentValue;
			$this->stock->ViewValue = FormatNumber($this->stock->ViewValue, 2, -2, -2, -2);
			$this->stock->ViewCustomAttributes = "";

			// required
			$this->required->ViewValue = $this->required->CurrentValue;
			$this->required->ViewValue = FormatNumber($this->required->ViewValue, 2, -2, -2, -2);
			$this->required->ViewCustomAttributes = "";

			// ordered
			$this->ordered->ViewValue = $this->ordered->CurrentValue;
			$this->ordered->ViewValue = FormatNumber($this->ordered->ViewValue, 2, -2, -2, -2);
			$this->ordered->ViewCustomAttributes = "";

			// pending_order
			$this->pending_order->ViewValue = $this->pending_order->CurrentValue;
			$this->pending_order->ViewValue = FormatNumber($this->pending_order->ViewValue, 2, -2, -2, -2);
			$this->pending_order->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// color
			$this->color->LinkCustomAttributes = "";
			$this->color->HrefValue = "";
			$this->color->TooltipValue = "";

			// color_source
			$this->color_source->LinkCustomAttributes = "";
			$this->color_source->HrefValue = "";
			$this->color_source->TooltipValue = "";

			// base_color
			$this->base_color->LinkCustomAttributes = "";
			$this->base_color->HrefValue = "";
			$this->base_color->TooltipValue = "";

			// match_clariant
			$this->match_clariant->LinkCustomAttributes = "";
			$this->match_clariant->HrefValue = "";
			$this->match_clariant->TooltipValue = "";

			// match_poddar
			$this->match_poddar->LinkCustomAttributes = "";
			$this->match_poddar->HrefValue = "";
			$this->match_poddar->TooltipValue = "";

			// match_polyone
			$this->match_polyone->LinkCustomAttributes = "";
			$this->match_polyone->HrefValue = "";
			$this->match_polyone->TooltipValue = "";

			// moq
			$this->moq->LinkCustomAttributes = "";
			$this->moq->HrefValue = "";
			$this->moq->TooltipValue = "";

			// m_stock
			$this->m_stock->LinkCustomAttributes = "";
			$this->m_stock->HrefValue = "";
			$this->m_stock->TooltipValue = "";

			// stock
			$this->stock->LinkCustomAttributes = "";
			$this->stock->HrefValue = "";
			$this->stock->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// color
			$this->color->EditAttrs["class"] = "form-control";
			$this->color->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->color->CurrentValue = HtmlDecode($this->color->CurrentValue);
			$this->color->EditValue = HtmlEncode($this->color->CurrentValue);
			$this->color->PlaceHolder = RemoveHtml($this->color->caption());

			// color_source
			$this->color_source->EditAttrs["class"] = "form-control";
			$this->color_source->EditCustomAttributes = "";
			$this->color_source->EditValue = $this->color_source->options(TRUE);

			// base_color
			$this->base_color->EditAttrs["class"] = "form-control";
			$this->base_color->EditCustomAttributes = "";
			$this->base_color->EditValue = $this->base_color->options(TRUE);

			// match_clariant
			$this->match_clariant->EditAttrs["class"] = "form-control";
			$this->match_clariant->EditCustomAttributes = "";
			$curVal = trim(strval($this->match_clariant->CurrentValue));
			if ($curVal <> "")
				$this->match_clariant->ViewValue = $this->match_clariant->lookupCacheOption($curVal);
			else
				$this->match_clariant->ViewValue = $this->match_clariant->Lookup !== NULL && is_array($this->match_clariant->Lookup->Options) ? $curVal : NULL;
			if ($this->match_clariant->ViewValue !== NULL) { // Load from cache
				$this->match_clariant->EditValue = array_values($this->match_clariant->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->match_clariant->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`color_source` = 'Clariant' or `id` = 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->match_clariant->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->match_clariant->EditValue = $arwrk;
			}

			// match_poddar
			$this->match_poddar->EditAttrs["class"] = "form-control";
			$this->match_poddar->EditCustomAttributes = "";
			$curVal = trim(strval($this->match_poddar->CurrentValue));
			if ($curVal <> "")
				$this->match_poddar->ViewValue = $this->match_poddar->lookupCacheOption($curVal);
			else
				$this->match_poddar->ViewValue = $this->match_poddar->Lookup !== NULL && is_array($this->match_poddar->Lookup->Options) ? $curVal : NULL;
			if ($this->match_poddar->ViewValue !== NULL) { // Load from cache
				$this->match_poddar->EditValue = array_values($this->match_poddar->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->match_poddar->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`color_source` =  'Poddar' or `id` = 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->match_poddar->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->match_poddar->EditValue = $arwrk;
			}

			// match_polyone
			$this->match_polyone->EditAttrs["class"] = "form-control";
			$this->match_polyone->EditCustomAttributes = "";
			$curVal = trim(strval($this->match_polyone->CurrentValue));
			if ($curVal <> "")
				$this->match_polyone->ViewValue = $this->match_polyone->lookupCacheOption($curVal);
			else
				$this->match_polyone->ViewValue = $this->match_polyone->Lookup !== NULL && is_array($this->match_polyone->Lookup->Options) ? $curVal : NULL;
			if ($this->match_polyone->ViewValue !== NULL) { // Load from cache
				$this->match_polyone->EditValue = array_values($this->match_polyone->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->match_polyone->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`color_source` =  'Polyone' or `id` = 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->match_polyone->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->match_polyone->EditValue = $arwrk;
			}

			// moq
			$this->moq->EditAttrs["class"] = "form-control";
			$this->moq->EditCustomAttributes = "";
			$this->moq->EditValue = HtmlEncode($this->moq->CurrentValue);
			$this->moq->PlaceHolder = RemoveHtml($this->moq->caption());
			if (strval($this->moq->EditValue) <> "" && is_numeric($this->moq->EditValue))
				$this->moq->EditValue = FormatNumber($this->moq->EditValue, -2, -2, -2, -2);

			// m_stock
			$this->m_stock->EditAttrs["class"] = "form-control";
			$this->m_stock->EditCustomAttributes = "";
			$this->m_stock->EditValue = HtmlEncode($this->m_stock->CurrentValue);
			$this->m_stock->PlaceHolder = RemoveHtml($this->m_stock->caption());
			if (strval($this->m_stock->EditValue) <> "" && is_numeric($this->m_stock->EditValue))
				$this->m_stock->EditValue = FormatNumber($this->m_stock->EditValue, -2, -2, -2, -2);

			// stock
			$this->stock->EditAttrs["class"] = "form-control";
			$this->stock->EditCustomAttributes = "";
			$this->stock->EditValue = HtmlEncode($this->stock->CurrentValue);
			$this->stock->PlaceHolder = RemoveHtml($this->stock->caption());
			if (strval($this->stock->EditValue) <> "" && is_numeric($this->stock->EditValue))
				$this->stock->EditValue = FormatNumber($this->stock->EditValue, -2, -2, -2, -2);

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// operator
			// datetime
			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// color
			$this->color->LinkCustomAttributes = "";
			$this->color->HrefValue = "";

			// color_source
			$this->color_source->LinkCustomAttributes = "";
			$this->color_source->HrefValue = "";

			// base_color
			$this->base_color->LinkCustomAttributes = "";
			$this->base_color->HrefValue = "";

			// match_clariant
			$this->match_clariant->LinkCustomAttributes = "";
			$this->match_clariant->HrefValue = "";

			// match_poddar
			$this->match_poddar->LinkCustomAttributes = "";
			$this->match_poddar->HrefValue = "";

			// match_polyone
			$this->match_polyone->LinkCustomAttributes = "";
			$this->match_polyone->HrefValue = "";

			// moq
			$this->moq->LinkCustomAttributes = "";
			$this->moq->HrefValue = "";

			// m_stock
			$this->m_stock->LinkCustomAttributes = "";
			$this->m_stock->HrefValue = "";

			// stock
			$this->stock->LinkCustomAttributes = "";
			$this->stock->HrefValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->color->Required) {
			if (!$this->color->IsDetailKey && $this->color->FormValue != NULL && $this->color->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->color->caption(), $this->color->RequiredErrorMessage));
			}
		}
		if ($this->color_source->Required) {
			if (!$this->color_source->IsDetailKey && $this->color_source->FormValue != NULL && $this->color_source->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->color_source->caption(), $this->color_source->RequiredErrorMessage));
			}
		}
		if ($this->base_color->Required) {
			if (!$this->base_color->IsDetailKey && $this->base_color->FormValue != NULL && $this->base_color->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->base_color->caption(), $this->base_color->RequiredErrorMessage));
			}
		}
		if ($this->match_clariant->Required) {
			if (!$this->match_clariant->IsDetailKey && $this->match_clariant->FormValue != NULL && $this->match_clariant->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->match_clariant->caption(), $this->match_clariant->RequiredErrorMessage));
			}
		}
		if ($this->match_poddar->Required) {
			if (!$this->match_poddar->IsDetailKey && $this->match_poddar->FormValue != NULL && $this->match_poddar->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->match_poddar->caption(), $this->match_poddar->RequiredErrorMessage));
			}
		}
		if ($this->match_polyone->Required) {
			if (!$this->match_polyone->IsDetailKey && $this->match_polyone->FormValue != NULL && $this->match_polyone->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->match_polyone->caption(), $this->match_polyone->RequiredErrorMessage));
			}
		}
		if ($this->moq->Required) {
			if (!$this->moq->IsDetailKey && $this->moq->FormValue != NULL && $this->moq->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->moq->caption(), $this->moq->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->moq->FormValue)) {
			AddMessage($FormError, $this->moq->errorMessage());
		}
		if ($this->m_stock->Required) {
			if (!$this->m_stock->IsDetailKey && $this->m_stock->FormValue != NULL && $this->m_stock->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_stock->caption(), $this->m_stock->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_stock->FormValue)) {
			AddMessage($FormError, $this->m_stock->errorMessage());
		}
		if ($this->stock->Required) {
			if (!$this->stock->IsDetailKey && $this->stock->FormValue != NULL && $this->stock->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->stock->caption(), $this->stock->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->stock->FormValue)) {
			AddMessage($FormError, $this->stock->errorMessage());
		}
		if ($this->required->Required) {
			if (!$this->required->IsDetailKey && $this->required->FormValue != NULL && $this->required->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->required->caption(), $this->required->RequiredErrorMessage));
			}
		}
		if ($this->ordered->Required) {
			if (!$this->ordered->IsDetailKey && $this->ordered->FormValue != NULL && $this->ordered->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ordered->caption(), $this->ordered->RequiredErrorMessage));
			}
		}
		if ($this->pending_order->Required) {
			if (!$this->pending_order->IsDetailKey && $this->pending_order->FormValue != NULL && $this->pending_order->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pending_order->caption(), $this->pending_order->RequiredErrorMessage));
			}
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// color
			$this->color->setDbValueDef($rsnew, $this->color->CurrentValue, NULL, $this->color->ReadOnly);

			// color_source
			$this->color_source->setDbValueDef($rsnew, $this->color_source->CurrentValue, NULL, $this->color_source->ReadOnly);

			// base_color
			$this->base_color->setDbValueDef($rsnew, $this->base_color->CurrentValue, 0, $this->base_color->ReadOnly);

			// match_clariant
			$this->match_clariant->setDbValueDef($rsnew, $this->match_clariant->CurrentValue, 0, $this->match_clariant->ReadOnly);

			// match_poddar
			$this->match_poddar->setDbValueDef($rsnew, $this->match_poddar->CurrentValue, 0, $this->match_poddar->ReadOnly);

			// match_polyone
			$this->match_polyone->setDbValueDef($rsnew, $this->match_polyone->CurrentValue, 0, $this->match_polyone->ReadOnly);

			// moq
			$this->moq->setDbValueDef($rsnew, $this->moq->CurrentValue, NULL, $this->moq->ReadOnly);

			// m_stock
			$this->m_stock->setDbValueDef($rsnew, $this->m_stock->CurrentValue, 0, $this->m_stock->ReadOnly);

			// stock
			$this->stock->setDbValueDef($rsnew, $this->stock->CurrentValue, 0, $this->stock->ReadOnly);

			// status
			$this->status->setDbValueDef($rsnew, $this->status->CurrentValue, NULL, $this->status->ReadOnly);

			// operator
			$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['operator'] = &$this->operator->DbValue;

			// datetime
			$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
			$rsnew['datetime'] = &$this->datetime->DbValue;

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("ww_colorlist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_match_clariant":
					$lookupFilter = function() {
						return "`color_source` = 'Clariant' or `id` = 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_match_poddar":
					$lookupFilter = function() {
						return "`color_source` =  'Poddar' or `id` = 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_match_polyone":
					$lookupFilter = function() {
						return "`color_source` =  'Polyone' or `id` = 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_match_clariant":
							break;
						case "x_match_poddar":
							break;
						case "x_match_polyone":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		extract($_POST,EXTR_OVERWRITE);
		if ($x_base_color == 1)
		{
		$row = ExecuteRow("SELECT group_concat(`id`) as `id`, count(`id`) as `count` FROM `ww_color` WHERE (`id` = $x_match_clariant or `id` = $x_match_poddar or `id` = $x_match_polyone) and `id` != 0 and `base_color` = 1 and `id` != $x_id LIMIT 1");
	$_SESSION[SESSION_WARNING_MESSAGE] = '';
			if (COUNT($row['count'])>0)
			{
			$_SESSION[SESSION_WARNING_MESSAGE].= "Base Color for Match already available on ID : " .$row['id']. "<br>";
			}
			if ($_SESSION[SESSION_WARNING_MESSAGE] == '')
			{return TRUE;}
			else
			{return FALSE;}
		}
		return TRUE;
	}
}
?>