<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for ww_color_req_detailed
 */
class ww_color_req_detailed extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $yarn;
	public $consumption_forcast;
	public $p1_c_qty;
	public $p1_st;
	public $p1_clariant;
	public $p1_poddar;
	public $p1_polyone;
	public $p2_c_qty;
	public $p2_st;
	public $p2_clariant;
	public $p2_poddar;
	public $p2_polyone;
	public $p3_c_qty;
	public $p3_st;
	public $p3_clariant;
	public $p3_poddar;
	public $p3_polyone;
	public $period;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'ww_color_req_detailed';
		$this->TableName = 'ww_color_req_detailed';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`ww_color_req_detailed`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('ww_color_req_detailed', 'ww_color_req_detailed', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->fields['id'] = &$this->id;

		// yarn
		$this->yarn = new DbField('ww_color_req_detailed', 'ww_color_req_detailed', 'x_yarn', 'yarn', '`yarn`', '`yarn`', 200, -1, FALSE, '`yarn`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->yarn->Sortable = TRUE; // Allow sort
		$this->yarn->SelectMultiple = TRUE; // Multiple select
		$this->yarn->Lookup = new Lookup('yarn', 'ww_yarn', FALSE, 'id', ["yarn","","",""], [], [], [], [], [], [], '`yarn` ASC', '');
		$this->fields['yarn'] = &$this->yarn;

		// consumption_forcast
		$this->consumption_forcast = new DbField('ww_color_req_detailed', 'ww_color_req_detailed', 'x_consumption_forcast', 'consumption_forcast', '`consumption_forcast`', '`consumption_forcast`', 4, -1, FALSE, '`consumption_forcast`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->consumption_forcast->Sortable = TRUE; // Allow sort
		$this->consumption_forcast->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['consumption_forcast'] = &$this->consumption_forcast;

		// p1_c_qty
		$this->p1_c_qty = new DbField('ww_color_req_detailed', 'ww_color_req_detailed', 'x_p1_c_qty', 'p1_c_qty', '`p1_c_qty`', '`p1_c_qty`', 5, -1, FALSE, '`p1_c_qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->p1_c_qty->Sortable = TRUE; // Allow sort
		$this->p1_c_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['p1_c_qty'] = &$this->p1_c_qty;

		// p1_st
		$this->p1_st = new DbField('ww_color_req_detailed', 'ww_color_req_detailed', 'x_p1_st', 'p1_st', '`p1_st`', '`p1_st`', 2, -1, FALSE, '`p1_st`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->p1_st->Sortable = TRUE; // Allow sort
		$this->p1_st->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->p1_st->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->p1_st->Lookup = new Lookup('p1_st', 'ww_color', FALSE, 'id', ["color","","",""], [], [], [], [], [], [], '`color` ASC', '');
		$this->p1_st->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['p1_st'] = &$this->p1_st;

		// p1_clariant
		$this->p1_clariant = new DbField('ww_color_req_detailed', 'ww_color_req_detailed', 'x_p1_clariant', 'p1_clariant', '`p1_clariant`', '`p1_clariant`', 18, -1, FALSE, '`p1_clariant`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->p1_clariant->Sortable = TRUE; // Allow sort
		$this->p1_clariant->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->p1_clariant->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->p1_clariant->Lookup = new Lookup('p1_clariant', 'ww_color', FALSE, 'id', ["color","","",""], [], [], [], [], [], [], '`color` ASC', '');
		$this->p1_clariant->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['p1_clariant'] = &$this->p1_clariant;

		// p1_poddar
		$this->p1_poddar = new DbField('ww_color_req_detailed', 'ww_color_req_detailed', 'x_p1_poddar', 'p1_poddar', '`p1_poddar`', '`p1_poddar`', 18, -1, FALSE, '`p1_poddar`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->p1_poddar->Sortable = TRUE; // Allow sort
		$this->p1_poddar->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->p1_poddar->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->p1_poddar->Lookup = new Lookup('p1_poddar', 'ww_color', FALSE, 'id', ["color","","",""], [], [], [], [], [], [], '`color` ASC', '');
		$this->p1_poddar->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['p1_poddar'] = &$this->p1_poddar;

		// p1_polyone
		$this->p1_polyone = new DbField('ww_color_req_detailed', 'ww_color_req_detailed', 'x_p1_polyone', 'p1_polyone', '`p1_polyone`', '`p1_polyone`', 18, -1, FALSE, '`p1_polyone`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->p1_polyone->Sortable = TRUE; // Allow sort
		$this->p1_polyone->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->p1_polyone->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->p1_polyone->Lookup = new Lookup('p1_polyone', 'ww_color', FALSE, 'id', ["color","","",""], [], [], [], [], [], [], '`color` ASC', '');
		$this->p1_polyone->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['p1_polyone'] = &$this->p1_polyone;

		// p2_c_qty
		$this->p2_c_qty = new DbField('ww_color_req_detailed', 'ww_color_req_detailed', 'x_p2_c_qty', 'p2_c_qty', '`p2_c_qty`', '`p2_c_qty`', 5, -1, FALSE, '`p2_c_qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->p2_c_qty->Sortable = TRUE; // Allow sort
		$this->p2_c_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['p2_c_qty'] = &$this->p2_c_qty;

		// p2_st
		$this->p2_st = new DbField('ww_color_req_detailed', 'ww_color_req_detailed', 'x_p2_st', 'p2_st', '`p2_st`', '`p2_st`', 2, -1, FALSE, '`p2_st`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->p2_st->Sortable = TRUE; // Allow sort
		$this->p2_st->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->p2_st->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->p2_st->Lookup = new Lookup('p2_st', 'ww_color', FALSE, 'id', ["color","","",""], [], [], [], [], [], [], '`color` ASC', '');
		$this->p2_st->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['p2_st'] = &$this->p2_st;

		// p2_clariant
		$this->p2_clariant = new DbField('ww_color_req_detailed', 'ww_color_req_detailed', 'x_p2_clariant', 'p2_clariant', '`p2_clariant`', '`p2_clariant`', 18, -1, FALSE, '`p2_clariant`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->p2_clariant->Sortable = TRUE; // Allow sort
		$this->p2_clariant->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->p2_clariant->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->p2_clariant->Lookup = new Lookup('p2_clariant', 'ww_color', FALSE, 'id', ["color","","",""], [], [], [], [], [], [], '`color` ASC', '');
		$this->p2_clariant->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['p2_clariant'] = &$this->p2_clariant;

		// p2_poddar
		$this->p2_poddar = new DbField('ww_color_req_detailed', 'ww_color_req_detailed', 'x_p2_poddar', 'p2_poddar', '`p2_poddar`', '`p2_poddar`', 18, -1, FALSE, '`p2_poddar`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->p2_poddar->Sortable = TRUE; // Allow sort
		$this->p2_poddar->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->p2_poddar->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->p2_poddar->Lookup = new Lookup('p2_poddar', 'ww_color', FALSE, 'id', ["color","","",""], [], [], [], [], [], [], '`color` ASC', '');
		$this->p2_poddar->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['p2_poddar'] = &$this->p2_poddar;

		// p2_polyone
		$this->p2_polyone = new DbField('ww_color_req_detailed', 'ww_color_req_detailed', 'x_p2_polyone', 'p2_polyone', '`p2_polyone`', '`p2_polyone`', 18, -1, FALSE, '`p2_polyone`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->p2_polyone->Sortable = TRUE; // Allow sort
		$this->p2_polyone->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->p2_polyone->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->p2_polyone->Lookup = new Lookup('p2_polyone', 'ww_color', FALSE, 'id', ["color","","",""], [], [], [], [], [], [], '`color` ASC', '');
		$this->p2_polyone->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['p2_polyone'] = &$this->p2_polyone;

		// p3_c_qty
		$this->p3_c_qty = new DbField('ww_color_req_detailed', 'ww_color_req_detailed', 'x_p3_c_qty', 'p3_c_qty', '`p3_c_qty`', '`p3_c_qty`', 5, -1, FALSE, '`p3_c_qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->p3_c_qty->Sortable = TRUE; // Allow sort
		$this->p3_c_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['p3_c_qty'] = &$this->p3_c_qty;

		// p3_st
		$this->p3_st = new DbField('ww_color_req_detailed', 'ww_color_req_detailed', 'x_p3_st', 'p3_st', '`p3_st`', '`p3_st`', 2, -1, FALSE, '`p3_st`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->p3_st->Sortable = TRUE; // Allow sort
		$this->p3_st->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->p3_st->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->p3_st->Lookup = new Lookup('p3_st', 'ww_color_req_detailed', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->p3_st->OptionCount = 3;
		$this->fields['p3_st'] = &$this->p3_st;

		// p3_clariant
		$this->p3_clariant = new DbField('ww_color_req_detailed', 'ww_color_req_detailed', 'x_p3_clariant', 'p3_clariant', '`p3_clariant`', '`p3_clariant`', 18, -1, FALSE, '`p3_clariant`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->p3_clariant->Sortable = TRUE; // Allow sort
		$this->p3_clariant->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->p3_clariant->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->p3_clariant->Lookup = new Lookup('p3_clariant', 'ww_color', FALSE, 'id', ["color","","",""], [], [], [], [], [], [], '`color` ASC', '');
		$this->p3_clariant->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['p3_clariant'] = &$this->p3_clariant;

		// p3_poddar
		$this->p3_poddar = new DbField('ww_color_req_detailed', 'ww_color_req_detailed', 'x_p3_poddar', 'p3_poddar', '`p3_poddar`', '`p3_poddar`', 18, -1, FALSE, '`p3_poddar`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->p3_poddar->Sortable = TRUE; // Allow sort
		$this->p3_poddar->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->p3_poddar->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->p3_poddar->Lookup = new Lookup('p3_poddar', 'ww_color', FALSE, 'id', ["color","","",""], [], [], [], [], [], [], '`color` ASC', '');
		$this->p3_poddar->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['p3_poddar'] = &$this->p3_poddar;

		// p3_polyone
		$this->p3_polyone = new DbField('ww_color_req_detailed', 'ww_color_req_detailed', 'x_p3_polyone', 'p3_polyone', '`p3_polyone`', '`p3_polyone`', 18, -1, FALSE, '`p3_polyone`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->p3_polyone->Sortable = TRUE; // Allow sort
		$this->p3_polyone->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->p3_polyone->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->p3_polyone->Lookup = new Lookup('p3_polyone', 'ww_color', FALSE, 'id', ["color","","",""], [], [], [], [], [], [], '`color` ASC', '');
		$this->p3_polyone->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['p3_polyone'] = &$this->p3_polyone;

		// period
		$this->period = new DbField('ww_color_req_detailed', 'ww_color_req_detailed', 'x_period', 'period', '`period`', '`period`', 2, -1, FALSE, '`period`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->period->Sortable = TRUE; // Allow sort
		$this->period->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['period'] = &$this->period;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`ww_color_req_detailed`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` ASC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->yarn->DbValue = $row['yarn'];
		$this->consumption_forcast->DbValue = $row['consumption_forcast'];
		$this->p1_c_qty->DbValue = $row['p1_c_qty'];
		$this->p1_st->DbValue = $row['p1_st'];
		$this->p1_clariant->DbValue = $row['p1_clariant'];
		$this->p1_poddar->DbValue = $row['p1_poddar'];
		$this->p1_polyone->DbValue = $row['p1_polyone'];
		$this->p2_c_qty->DbValue = $row['p2_c_qty'];
		$this->p2_st->DbValue = $row['p2_st'];
		$this->p2_clariant->DbValue = $row['p2_clariant'];
		$this->p2_poddar->DbValue = $row['p2_poddar'];
		$this->p2_polyone->DbValue = $row['p2_polyone'];
		$this->p3_c_qty->DbValue = $row['p3_c_qty'];
		$this->p3_st->DbValue = $row['p3_st'];
		$this->p3_clariant->DbValue = $row['p3_clariant'];
		$this->p3_poddar->DbValue = $row['p3_poddar'];
		$this->p3_polyone->DbValue = $row['p3_polyone'];
		$this->period->DbValue = $row['period'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "ww_color_req_detailedlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "ww_color_req_detailedview.php")
			return $Language->phrase("View");
		elseif ($pageName == "ww_color_req_detailededit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "ww_color_req_detailedadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "ww_color_req_detailedlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("ww_color_req_detailedview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("ww_color_req_detailedview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "ww_color_req_detailedadd.php?" . $this->getUrlParm($parm);
		else
			$url = "ww_color_req_detailedadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("ww_color_req_detailededit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("ww_color_req_detailedadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("ww_color_req_detaileddelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->yarn->setDbValue($rs->fields('yarn'));
		$this->consumption_forcast->setDbValue($rs->fields('consumption_forcast'));
		$this->p1_c_qty->setDbValue($rs->fields('p1_c_qty'));
		$this->p1_st->setDbValue($rs->fields('p1_st'));
		$this->p1_clariant->setDbValue($rs->fields('p1_clariant'));
		$this->p1_poddar->setDbValue($rs->fields('p1_poddar'));
		$this->p1_polyone->setDbValue($rs->fields('p1_polyone'));
		$this->p2_c_qty->setDbValue($rs->fields('p2_c_qty'));
		$this->p2_st->setDbValue($rs->fields('p2_st'));
		$this->p2_clariant->setDbValue($rs->fields('p2_clariant'));
		$this->p2_poddar->setDbValue($rs->fields('p2_poddar'));
		$this->p2_polyone->setDbValue($rs->fields('p2_polyone'));
		$this->p3_c_qty->setDbValue($rs->fields('p3_c_qty'));
		$this->p3_st->setDbValue($rs->fields('p3_st'));
		$this->p3_clariant->setDbValue($rs->fields('p3_clariant'));
		$this->p3_poddar->setDbValue($rs->fields('p3_poddar'));
		$this->p3_polyone->setDbValue($rs->fields('p3_polyone'));
		$this->period->setDbValue($rs->fields('period'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// yarn
		// consumption_forcast
		// p1_c_qty
		// p1_st
		// p1_clariant
		// p1_poddar
		// p1_polyone
		// p2_c_qty
		// p2_st
		// p2_clariant
		// p2_poddar
		// p2_polyone
		// p3_c_qty
		// p3_st
		// p3_clariant
		// p3_poddar
		// p3_polyone
		// period
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// yarn
		$curVal = strval($this->yarn->CurrentValue);
		if ($curVal <> "") {
			$this->yarn->ViewValue = $this->yarn->lookupCacheOption($curVal);
			if ($this->yarn->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->yarn->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->yarn->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->yarn->ViewValue->add($this->yarn->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->yarn->ViewValue = $this->yarn->CurrentValue;
				}
			}
		} else {
			$this->yarn->ViewValue = NULL;
		}
		$this->yarn->ViewCustomAttributes = "";

		// consumption_forcast
		$this->consumption_forcast->ViewValue = $this->consumption_forcast->CurrentValue;
		$this->consumption_forcast->ViewValue = FormatNumber($this->consumption_forcast->ViewValue, 2, -2, -2, -2);
		$this->consumption_forcast->ViewCustomAttributes = "";

		// p1_c_qty
		$this->p1_c_qty->ViewValue = $this->p1_c_qty->CurrentValue;
		$this->p1_c_qty->ViewValue = FormatNumber($this->p1_c_qty->ViewValue, 2, -2, -2, -2);
		$this->p1_c_qty->ViewCustomAttributes = "";

		// p1_st
		$curVal = strval($this->p1_st->CurrentValue);
		if ($curVal <> "") {
			$this->p1_st->ViewValue = $this->p1_st->lookupCacheOption($curVal);
			if ($this->p1_st->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->p1_st->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->p1_st->ViewValue = $this->p1_st->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->p1_st->ViewValue = $this->p1_st->CurrentValue;
				}
			}
		} else {
			$this->p1_st->ViewValue = NULL;
		}
		$this->p1_st->ViewCustomAttributes = "";

		// p1_clariant
		$curVal = strval($this->p1_clariant->CurrentValue);
		if ($curVal <> "") {
			$this->p1_clariant->ViewValue = $this->p1_clariant->lookupCacheOption($curVal);
			if ($this->p1_clariant->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->p1_clariant->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->p1_clariant->ViewValue = $this->p1_clariant->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->p1_clariant->ViewValue = $this->p1_clariant->CurrentValue;
				}
			}
		} else {
			$this->p1_clariant->ViewValue = NULL;
		}
		$this->p1_clariant->ViewCustomAttributes = "";

		// p1_poddar
		$curVal = strval($this->p1_poddar->CurrentValue);
		if ($curVal <> "") {
			$this->p1_poddar->ViewValue = $this->p1_poddar->lookupCacheOption($curVal);
			if ($this->p1_poddar->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->p1_poddar->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->p1_poddar->ViewValue = $this->p1_poddar->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->p1_poddar->ViewValue = $this->p1_poddar->CurrentValue;
				}
			}
		} else {
			$this->p1_poddar->ViewValue = NULL;
		}
		$this->p1_poddar->ViewCustomAttributes = "";

		// p1_polyone
		$curVal = strval($this->p1_polyone->CurrentValue);
		if ($curVal <> "") {
			$this->p1_polyone->ViewValue = $this->p1_polyone->lookupCacheOption($curVal);
			if ($this->p1_polyone->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->p1_polyone->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->p1_polyone->ViewValue = $this->p1_polyone->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->p1_polyone->ViewValue = $this->p1_polyone->CurrentValue;
				}
			}
		} else {
			$this->p1_polyone->ViewValue = NULL;
		}
		$this->p1_polyone->ViewCustomAttributes = "";

		// p2_c_qty
		$this->p2_c_qty->ViewValue = $this->p2_c_qty->CurrentValue;
		$this->p2_c_qty->ViewValue = FormatNumber($this->p2_c_qty->ViewValue, 2, -2, -2, -2);
		$this->p2_c_qty->ViewCustomAttributes = "";

		// p2_st
		$curVal = strval($this->p2_st->CurrentValue);
		if ($curVal <> "") {
			$this->p2_st->ViewValue = $this->p2_st->lookupCacheOption($curVal);
			if ($this->p2_st->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->p2_st->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->p2_st->ViewValue = $this->p2_st->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->p2_st->ViewValue = $this->p2_st->CurrentValue;
				}
			}
		} else {
			$this->p2_st->ViewValue = NULL;
		}
		$this->p2_st->ViewCustomAttributes = "";

		// p2_clariant
		$curVal = strval($this->p2_clariant->CurrentValue);
		if ($curVal <> "") {
			$this->p2_clariant->ViewValue = $this->p2_clariant->lookupCacheOption($curVal);
			if ($this->p2_clariant->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->p2_clariant->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->p2_clariant->ViewValue = $this->p2_clariant->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->p2_clariant->ViewValue = $this->p2_clariant->CurrentValue;
				}
			}
		} else {
			$this->p2_clariant->ViewValue = NULL;
		}
		$this->p2_clariant->ViewCustomAttributes = "";

		// p2_poddar
		$curVal = strval($this->p2_poddar->CurrentValue);
		if ($curVal <> "") {
			$this->p2_poddar->ViewValue = $this->p2_poddar->lookupCacheOption($curVal);
			if ($this->p2_poddar->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->p2_poddar->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->p2_poddar->ViewValue = $this->p2_poddar->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->p2_poddar->ViewValue = $this->p2_poddar->CurrentValue;
				}
			}
		} else {
			$this->p2_poddar->ViewValue = NULL;
		}
		$this->p2_poddar->ViewCustomAttributes = "";

		// p2_polyone
		$curVal = strval($this->p2_polyone->CurrentValue);
		if ($curVal <> "") {
			$this->p2_polyone->ViewValue = $this->p2_polyone->lookupCacheOption($curVal);
			if ($this->p2_polyone->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->p2_polyone->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->p2_polyone->ViewValue = $this->p2_polyone->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->p2_polyone->ViewValue = $this->p2_polyone->CurrentValue;
				}
			}
		} else {
			$this->p2_polyone->ViewValue = NULL;
		}
		$this->p2_polyone->ViewCustomAttributes = "";

		// p3_c_qty
		$this->p3_c_qty->ViewValue = $this->p3_c_qty->CurrentValue;
		$this->p3_c_qty->ViewValue = FormatNumber($this->p3_c_qty->ViewValue, 2, -2, -2, -2);
		$this->p3_c_qty->ViewCustomAttributes = "";

		// p3_st
		if (strval($this->p3_st->CurrentValue) <> "") {
			$this->p3_st->ViewValue = $this->p3_st->optionCaption($this->p3_st->CurrentValue);
		} else {
			$this->p3_st->ViewValue = NULL;
		}
		$this->p3_st->ViewCustomAttributes = "";

		// p3_clariant
		$curVal = strval($this->p3_clariant->CurrentValue);
		if ($curVal <> "") {
			$this->p3_clariant->ViewValue = $this->p3_clariant->lookupCacheOption($curVal);
			if ($this->p3_clariant->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->p3_clariant->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->p3_clariant->ViewValue = $this->p3_clariant->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->p3_clariant->ViewValue = $this->p3_clariant->CurrentValue;
				}
			}
		} else {
			$this->p3_clariant->ViewValue = NULL;
		}
		$this->p3_clariant->ViewCustomAttributes = "";

		// p3_poddar
		$curVal = strval($this->p3_poddar->CurrentValue);
		if ($curVal <> "") {
			$this->p3_poddar->ViewValue = $this->p3_poddar->lookupCacheOption($curVal);
			if ($this->p3_poddar->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->p3_poddar->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->p3_poddar->ViewValue = $this->p3_poddar->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->p3_poddar->ViewValue = $this->p3_poddar->CurrentValue;
				}
			}
		} else {
			$this->p3_poddar->ViewValue = NULL;
		}
		$this->p3_poddar->ViewCustomAttributes = "";

		// p3_polyone
		$curVal = strval($this->p3_polyone->CurrentValue);
		if ($curVal <> "") {
			$this->p3_polyone->ViewValue = $this->p3_polyone->lookupCacheOption($curVal);
			if ($this->p3_polyone->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->p3_polyone->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->p3_polyone->ViewValue = $this->p3_polyone->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->p3_polyone->ViewValue = $this->p3_polyone->CurrentValue;
				}
			}
		} else {
			$this->p3_polyone->ViewValue = NULL;
		}
		$this->p3_polyone->ViewCustomAttributes = "";

		// period
		$this->period->ViewValue = $this->period->CurrentValue;
		$this->period->ViewValue = FormatNumber($this->period->ViewValue, 0, -2, -2, -2);
		$this->period->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// yarn
		$this->yarn->LinkCustomAttributes = "";
		$this->yarn->HrefValue = "";
		$this->yarn->TooltipValue = "";

		// consumption_forcast
		$this->consumption_forcast->LinkCustomAttributes = "";
		$this->consumption_forcast->HrefValue = "";
		$this->consumption_forcast->TooltipValue = "";

		// p1_c_qty
		$this->p1_c_qty->LinkCustomAttributes = "";
		$this->p1_c_qty->HrefValue = "";
		$this->p1_c_qty->TooltipValue = "";

		// p1_st
		$this->p1_st->LinkCustomAttributes = "";
		$this->p1_st->HrefValue = "";
		$this->p1_st->TooltipValue = "";

		// p1_clariant
		$this->p1_clariant->LinkCustomAttributes = "";
		$this->p1_clariant->HrefValue = "";
		$this->p1_clariant->TooltipValue = "";

		// p1_poddar
		$this->p1_poddar->LinkCustomAttributes = "";
		$this->p1_poddar->HrefValue = "";
		$this->p1_poddar->TooltipValue = "";

		// p1_polyone
		$this->p1_polyone->LinkCustomAttributes = "";
		$this->p1_polyone->HrefValue = "";
		$this->p1_polyone->TooltipValue = "";

		// p2_c_qty
		$this->p2_c_qty->LinkCustomAttributes = "";
		$this->p2_c_qty->HrefValue = "";
		$this->p2_c_qty->TooltipValue = "";

		// p2_st
		$this->p2_st->LinkCustomAttributes = "";
		$this->p2_st->HrefValue = "";
		$this->p2_st->TooltipValue = "";

		// p2_clariant
		$this->p2_clariant->LinkCustomAttributes = "";
		$this->p2_clariant->HrefValue = "";
		$this->p2_clariant->TooltipValue = "";

		// p2_poddar
		$this->p2_poddar->LinkCustomAttributes = "";
		$this->p2_poddar->HrefValue = "";
		$this->p2_poddar->TooltipValue = "";

		// p2_polyone
		$this->p2_polyone->LinkCustomAttributes = "";
		$this->p2_polyone->HrefValue = "";
		$this->p2_polyone->TooltipValue = "";

		// p3_c_qty
		$this->p3_c_qty->LinkCustomAttributes = "";
		$this->p3_c_qty->HrefValue = "";
		$this->p3_c_qty->TooltipValue = "";

		// p3_st
		$this->p3_st->LinkCustomAttributes = "";
		$this->p3_st->HrefValue = "";
		$this->p3_st->TooltipValue = "";

		// p3_clariant
		$this->p3_clariant->LinkCustomAttributes = "";
		$this->p3_clariant->HrefValue = "";
		$this->p3_clariant->TooltipValue = "";

		// p3_poddar
		$this->p3_poddar->LinkCustomAttributes = "";
		$this->p3_poddar->HrefValue = "";
		$this->p3_poddar->TooltipValue = "";

		// p3_polyone
		$this->p3_polyone->LinkCustomAttributes = "";
		$this->p3_polyone->HrefValue = "";
		$this->p3_polyone->TooltipValue = "";

		// period
		$this->period->LinkCustomAttributes = "";
		$this->period->HrefValue = "";
		$this->period->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// yarn
		$this->yarn->EditAttrs["class"] = "form-control";
		$this->yarn->EditCustomAttributes = "";

		// consumption_forcast
		$this->consumption_forcast->EditAttrs["class"] = "form-control";
		$this->consumption_forcast->EditCustomAttributes = "";
		$this->consumption_forcast->EditValue = $this->consumption_forcast->CurrentValue;
		$this->consumption_forcast->PlaceHolder = RemoveHtml($this->consumption_forcast->caption());
		if (strval($this->consumption_forcast->EditValue) <> "" && is_numeric($this->consumption_forcast->EditValue))
			$this->consumption_forcast->EditValue = FormatNumber($this->consumption_forcast->EditValue, -2, -2, -2, -2);

		// p1_c_qty
		$this->p1_c_qty->EditAttrs["class"] = "form-control";
		$this->p1_c_qty->EditCustomAttributes = "";
		$this->p1_c_qty->EditValue = $this->p1_c_qty->CurrentValue;
		$this->p1_c_qty->PlaceHolder = RemoveHtml($this->p1_c_qty->caption());
		if (strval($this->p1_c_qty->EditValue) <> "" && is_numeric($this->p1_c_qty->EditValue))
			$this->p1_c_qty->EditValue = FormatNumber($this->p1_c_qty->EditValue, -2, -2, -2, -2);

		// p1_st
		$this->p1_st->EditAttrs["class"] = "form-control";
		$this->p1_st->EditCustomAttributes = "";

		// p1_clariant
		$this->p1_clariant->EditAttrs["class"] = "form-control";
		$this->p1_clariant->EditCustomAttributes = "";

		// p1_poddar
		$this->p1_poddar->EditAttrs["class"] = "form-control";
		$this->p1_poddar->EditCustomAttributes = "";

		// p1_polyone
		$this->p1_polyone->EditAttrs["class"] = "form-control";
		$this->p1_polyone->EditCustomAttributes = "";

		// p2_c_qty
		$this->p2_c_qty->EditAttrs["class"] = "form-control";
		$this->p2_c_qty->EditCustomAttributes = "";
		$this->p2_c_qty->EditValue = $this->p2_c_qty->CurrentValue;
		$this->p2_c_qty->PlaceHolder = RemoveHtml($this->p2_c_qty->caption());
		if (strval($this->p2_c_qty->EditValue) <> "" && is_numeric($this->p2_c_qty->EditValue))
			$this->p2_c_qty->EditValue = FormatNumber($this->p2_c_qty->EditValue, -2, -2, -2, -2);

		// p2_st
		$this->p2_st->EditAttrs["class"] = "form-control";
		$this->p2_st->EditCustomAttributes = "";

		// p2_clariant
		$this->p2_clariant->EditAttrs["class"] = "form-control";
		$this->p2_clariant->EditCustomAttributes = "";

		// p2_poddar
		$this->p2_poddar->EditAttrs["class"] = "form-control";
		$this->p2_poddar->EditCustomAttributes = "";

		// p2_polyone
		$this->p2_polyone->EditAttrs["class"] = "form-control";
		$this->p2_polyone->EditCustomAttributes = "";

		// p3_c_qty
		$this->p3_c_qty->EditAttrs["class"] = "form-control";
		$this->p3_c_qty->EditCustomAttributes = "";
		$this->p3_c_qty->EditValue = $this->p3_c_qty->CurrentValue;
		$this->p3_c_qty->PlaceHolder = RemoveHtml($this->p3_c_qty->caption());
		if (strval($this->p3_c_qty->EditValue) <> "" && is_numeric($this->p3_c_qty->EditValue))
			$this->p3_c_qty->EditValue = FormatNumber($this->p3_c_qty->EditValue, -2, -2, -2, -2);

		// p3_st
		$this->p3_st->EditAttrs["class"] = "form-control";
		$this->p3_st->EditCustomAttributes = "";
		$this->p3_st->EditValue = $this->p3_st->options(TRUE);

		// p3_clariant
		$this->p3_clariant->EditAttrs["class"] = "form-control";
		$this->p3_clariant->EditCustomAttributes = "";

		// p3_poddar
		$this->p3_poddar->EditAttrs["class"] = "form-control";
		$this->p3_poddar->EditCustomAttributes = "";

		// p3_polyone
		$this->p3_polyone->EditAttrs["class"] = "form-control";
		$this->p3_polyone->EditCustomAttributes = "";

		// period
		$this->period->EditAttrs["class"] = "form-control";
		$this->period->EditCustomAttributes = "";
		$this->period->EditValue = $this->period->CurrentValue;
		$this->period->PlaceHolder = RemoveHtml($this->period->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->yarn);
					$doc->exportCaption($this->consumption_forcast);
					$doc->exportCaption($this->p1_c_qty);
					$doc->exportCaption($this->p1_st);
					$doc->exportCaption($this->p1_clariant);
					$doc->exportCaption($this->p1_poddar);
					$doc->exportCaption($this->p1_polyone);
					$doc->exportCaption($this->p2_c_qty);
					$doc->exportCaption($this->p2_st);
					$doc->exportCaption($this->p2_clariant);
					$doc->exportCaption($this->p2_poddar);
					$doc->exportCaption($this->p2_polyone);
					$doc->exportCaption($this->p3_c_qty);
					$doc->exportCaption($this->p3_st);
					$doc->exportCaption($this->p3_clariant);
					$doc->exportCaption($this->p3_poddar);
					$doc->exportCaption($this->p3_polyone);
					$doc->exportCaption($this->period);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->yarn);
					$doc->exportCaption($this->consumption_forcast);
					$doc->exportCaption($this->p1_c_qty);
					$doc->exportCaption($this->p1_st);
					$doc->exportCaption($this->p1_clariant);
					$doc->exportCaption($this->p1_poddar);
					$doc->exportCaption($this->p1_polyone);
					$doc->exportCaption($this->p2_c_qty);
					$doc->exportCaption($this->p2_st);
					$doc->exportCaption($this->p2_clariant);
					$doc->exportCaption($this->p2_poddar);
					$doc->exportCaption($this->p2_polyone);
					$doc->exportCaption($this->p3_c_qty);
					$doc->exportCaption($this->p3_st);
					$doc->exportCaption($this->p3_clariant);
					$doc->exportCaption($this->p3_poddar);
					$doc->exportCaption($this->p3_polyone);
					$doc->exportCaption($this->period);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->yarn);
						$doc->exportField($this->consumption_forcast);
						$doc->exportField($this->p1_c_qty);
						$doc->exportField($this->p1_st);
						$doc->exportField($this->p1_clariant);
						$doc->exportField($this->p1_poddar);
						$doc->exportField($this->p1_polyone);
						$doc->exportField($this->p2_c_qty);
						$doc->exportField($this->p2_st);
						$doc->exportField($this->p2_clariant);
						$doc->exportField($this->p2_poddar);
						$doc->exportField($this->p2_polyone);
						$doc->exportField($this->p3_c_qty);
						$doc->exportField($this->p3_st);
						$doc->exportField($this->p3_clariant);
						$doc->exportField($this->p3_poddar);
						$doc->exportField($this->p3_polyone);
						$doc->exportField($this->period);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->yarn);
						$doc->exportField($this->consumption_forcast);
						$doc->exportField($this->p1_c_qty);
						$doc->exportField($this->p1_st);
						$doc->exportField($this->p1_clariant);
						$doc->exportField($this->p1_poddar);
						$doc->exportField($this->p1_polyone);
						$doc->exportField($this->p2_c_qty);
						$doc->exportField($this->p2_st);
						$doc->exportField($this->p2_clariant);
						$doc->exportField($this->p2_poddar);
						$doc->exportField($this->p2_polyone);
						$doc->exportField($this->p3_c_qty);
						$doc->exportField($this->p3_st);
						$doc->exportField($this->p3_clariant);
						$doc->exportField($this->p3_poddar);
						$doc->exportField($this->p3_polyone);
						$doc->exportField($this->period);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>