<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class ww_color_req_detailed_search extends ww_color_req_detailed
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'ww_color_req_detailed';

	// Page object name
	public $PageObjName = "ww_color_req_detailed_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (ww_color_req_detailed)
		if (!isset($GLOBALS["ww_color_req_detailed"]) || get_class($GLOBALS["ww_color_req_detailed"]) == PROJECT_NAMESPACE . "ww_color_req_detailed") {
			$GLOBALS["ww_color_req_detailed"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["ww_color_req_detailed"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'ww_color_req_detailed');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $ww_color_req_detailed;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($ww_color_req_detailed);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "ww_color_req_detailedview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("ww_color_req_detailedlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->yarn->setVisibility();
		$this->consumption_forcast->setVisibility();
		$this->p1_c_qty->setVisibility();
		$this->p1_st->setVisibility();
		$this->p1_clariant->setVisibility();
		$this->p1_poddar->setVisibility();
		$this->p1_polyone->setVisibility();
		$this->p2_c_qty->setVisibility();
		$this->p2_st->setVisibility();
		$this->p2_clariant->setVisibility();
		$this->p2_poddar->setVisibility();
		$this->p2_polyone->setVisibility();
		$this->p3_c_qty->setVisibility();
		$this->p3_st->setVisibility();
		$this->p3_clariant->setVisibility();
		$this->p3_poddar->setVisibility();
		$this->p3_polyone->setVisibility();
		$this->period->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->yarn);
		$this->setupLookupOptions($this->p1_st);
		$this->setupLookupOptions($this->p1_clariant);
		$this->setupLookupOptions($this->p1_poddar);
		$this->setupLookupOptions($this->p1_polyone);
		$this->setupLookupOptions($this->p2_st);
		$this->setupLookupOptions($this->p2_clariant);
		$this->setupLookupOptions($this->p2_poddar);
		$this->setupLookupOptions($this->p2_polyone);
		$this->setupLookupOptions($this->p3_clariant);
		$this->setupLookupOptions($this->p3_poddar);
		$this->setupLookupOptions($this->p3_polyone);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "ww_color_req_detailedlist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->yarn); // yarn
		$this->buildSearchUrl($srchUrl, $this->consumption_forcast); // consumption_forcast
		$this->buildSearchUrl($srchUrl, $this->p1_c_qty); // p1_c_qty
		$this->buildSearchUrl($srchUrl, $this->p1_st); // p1_st
		$this->buildSearchUrl($srchUrl, $this->p1_clariant); // p1_clariant
		$this->buildSearchUrl($srchUrl, $this->p1_poddar); // p1_poddar
		$this->buildSearchUrl($srchUrl, $this->p1_polyone); // p1_polyone
		$this->buildSearchUrl($srchUrl, $this->p2_c_qty); // p2_c_qty
		$this->buildSearchUrl($srchUrl, $this->p2_st); // p2_st
		$this->buildSearchUrl($srchUrl, $this->p2_clariant); // p2_clariant
		$this->buildSearchUrl($srchUrl, $this->p2_poddar); // p2_poddar
		$this->buildSearchUrl($srchUrl, $this->p2_polyone); // p2_polyone
		$this->buildSearchUrl($srchUrl, $this->p3_c_qty); // p3_c_qty
		$this->buildSearchUrl($srchUrl, $this->p3_st); // p3_st
		$this->buildSearchUrl($srchUrl, $this->p3_clariant); // p3_clariant
		$this->buildSearchUrl($srchUrl, $this->p3_poddar); // p3_poddar
		$this->buildSearchUrl($srchUrl, $this->p3_polyone); // p3_polyone
		$this->buildSearchUrl($srchUrl, $this->period); // period
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// yarn
		if (!$this->isAddOrEdit())
			$this->yarn->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_yarn"));
		$this->yarn->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_yarn"));
		if (is_array($this->yarn->AdvancedSearch->SearchValue))
			$this->yarn->AdvancedSearch->SearchValue = implode(",", $this->yarn->AdvancedSearch->SearchValue);
		if (is_array($this->yarn->AdvancedSearch->SearchValue2))
			$this->yarn->AdvancedSearch->SearchValue2 = implode(",", $this->yarn->AdvancedSearch->SearchValue2);

		// consumption_forcast
		if (!$this->isAddOrEdit())
			$this->consumption_forcast->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_consumption_forcast"));
		$this->consumption_forcast->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_consumption_forcast"));

		// p1_c_qty
		if (!$this->isAddOrEdit())
			$this->p1_c_qty->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_p1_c_qty"));
		$this->p1_c_qty->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_p1_c_qty"));

		// p1_st
		if (!$this->isAddOrEdit())
			$this->p1_st->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_p1_st"));
		$this->p1_st->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_p1_st"));

		// p1_clariant
		if (!$this->isAddOrEdit())
			$this->p1_clariant->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_p1_clariant"));
		$this->p1_clariant->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_p1_clariant"));

		// p1_poddar
		if (!$this->isAddOrEdit())
			$this->p1_poddar->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_p1_poddar"));
		$this->p1_poddar->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_p1_poddar"));

		// p1_polyone
		if (!$this->isAddOrEdit())
			$this->p1_polyone->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_p1_polyone"));
		$this->p1_polyone->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_p1_polyone"));

		// p2_c_qty
		if (!$this->isAddOrEdit())
			$this->p2_c_qty->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_p2_c_qty"));
		$this->p2_c_qty->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_p2_c_qty"));

		// p2_st
		if (!$this->isAddOrEdit())
			$this->p2_st->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_p2_st"));
		$this->p2_st->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_p2_st"));

		// p2_clariant
		if (!$this->isAddOrEdit())
			$this->p2_clariant->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_p2_clariant"));
		$this->p2_clariant->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_p2_clariant"));

		// p2_poddar
		if (!$this->isAddOrEdit())
			$this->p2_poddar->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_p2_poddar"));
		$this->p2_poddar->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_p2_poddar"));

		// p2_polyone
		if (!$this->isAddOrEdit())
			$this->p2_polyone->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_p2_polyone"));
		$this->p2_polyone->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_p2_polyone"));

		// p3_c_qty
		if (!$this->isAddOrEdit())
			$this->p3_c_qty->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_p3_c_qty"));
		$this->p3_c_qty->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_p3_c_qty"));

		// p3_st
		if (!$this->isAddOrEdit())
			$this->p3_st->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_p3_st"));
		$this->p3_st->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_p3_st"));

		// p3_clariant
		if (!$this->isAddOrEdit())
			$this->p3_clariant->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_p3_clariant"));
		$this->p3_clariant->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_p3_clariant"));

		// p3_poddar
		if (!$this->isAddOrEdit())
			$this->p3_poddar->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_p3_poddar"));
		$this->p3_poddar->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_p3_poddar"));

		// p3_polyone
		if (!$this->isAddOrEdit())
			$this->p3_polyone->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_p3_polyone"));
		$this->p3_polyone->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_p3_polyone"));

		// period
		if (!$this->isAddOrEdit())
			$this->period->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_period"));
		$this->period->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_period"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->consumption_forcast->FormValue == $this->consumption_forcast->CurrentValue && is_numeric(ConvertToFloatString($this->consumption_forcast->CurrentValue)))
			$this->consumption_forcast->CurrentValue = ConvertToFloatString($this->consumption_forcast->CurrentValue);

		// Convert decimal values if posted back
		if ($this->p1_c_qty->FormValue == $this->p1_c_qty->CurrentValue && is_numeric(ConvertToFloatString($this->p1_c_qty->CurrentValue)))
			$this->p1_c_qty->CurrentValue = ConvertToFloatString($this->p1_c_qty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->p2_c_qty->FormValue == $this->p2_c_qty->CurrentValue && is_numeric(ConvertToFloatString($this->p2_c_qty->CurrentValue)))
			$this->p2_c_qty->CurrentValue = ConvertToFloatString($this->p2_c_qty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->p3_c_qty->FormValue == $this->p3_c_qty->CurrentValue && is_numeric(ConvertToFloatString($this->p3_c_qty->CurrentValue)))
			$this->p3_c_qty->CurrentValue = ConvertToFloatString($this->p3_c_qty->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// yarn
		// consumption_forcast
		// p1_c_qty
		// p1_st
		// p1_clariant
		// p1_poddar
		// p1_polyone
		// p2_c_qty
		// p2_st
		// p2_clariant
		// p2_poddar
		// p2_polyone
		// p3_c_qty
		// p3_st
		// p3_clariant
		// p3_poddar
		// p3_polyone
		// period

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// yarn
			$curVal = strval($this->yarn->CurrentValue);
			if ($curVal <> "") {
				$this->yarn->ViewValue = $this->yarn->lookupCacheOption($curVal);
				if ($this->yarn->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$sqlWrk = $this->yarn->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->yarn->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->yarn->ViewValue->add($this->yarn->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->yarn->ViewValue = $this->yarn->CurrentValue;
					}
				}
			} else {
				$this->yarn->ViewValue = NULL;
			}
			$this->yarn->ViewCustomAttributes = "";

			// consumption_forcast
			$this->consumption_forcast->ViewValue = $this->consumption_forcast->CurrentValue;
			$this->consumption_forcast->ViewValue = FormatNumber($this->consumption_forcast->ViewValue, 2, -2, -2, -2);
			$this->consumption_forcast->ViewCustomAttributes = "";

			// p1_c_qty
			$this->p1_c_qty->ViewValue = $this->p1_c_qty->CurrentValue;
			$this->p1_c_qty->ViewValue = FormatNumber($this->p1_c_qty->ViewValue, 2, -2, -2, -2);
			$this->p1_c_qty->ViewCustomAttributes = "";

			// p1_st
			$curVal = strval($this->p1_st->CurrentValue);
			if ($curVal <> "") {
				$this->p1_st->ViewValue = $this->p1_st->lookupCacheOption($curVal);
				if ($this->p1_st->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->p1_st->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->p1_st->ViewValue = $this->p1_st->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->p1_st->ViewValue = $this->p1_st->CurrentValue;
					}
				}
			} else {
				$this->p1_st->ViewValue = NULL;
			}
			$this->p1_st->ViewCustomAttributes = "";

			// p1_clariant
			$curVal = strval($this->p1_clariant->CurrentValue);
			if ($curVal <> "") {
				$this->p1_clariant->ViewValue = $this->p1_clariant->lookupCacheOption($curVal);
				if ($this->p1_clariant->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->p1_clariant->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->p1_clariant->ViewValue = $this->p1_clariant->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->p1_clariant->ViewValue = $this->p1_clariant->CurrentValue;
					}
				}
			} else {
				$this->p1_clariant->ViewValue = NULL;
			}
			$this->p1_clariant->ViewCustomAttributes = "";

			// p1_poddar
			$curVal = strval($this->p1_poddar->CurrentValue);
			if ($curVal <> "") {
				$this->p1_poddar->ViewValue = $this->p1_poddar->lookupCacheOption($curVal);
				if ($this->p1_poddar->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->p1_poddar->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->p1_poddar->ViewValue = $this->p1_poddar->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->p1_poddar->ViewValue = $this->p1_poddar->CurrentValue;
					}
				}
			} else {
				$this->p1_poddar->ViewValue = NULL;
			}
			$this->p1_poddar->ViewCustomAttributes = "";

			// p1_polyone
			$curVal = strval($this->p1_polyone->CurrentValue);
			if ($curVal <> "") {
				$this->p1_polyone->ViewValue = $this->p1_polyone->lookupCacheOption($curVal);
				if ($this->p1_polyone->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->p1_polyone->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->p1_polyone->ViewValue = $this->p1_polyone->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->p1_polyone->ViewValue = $this->p1_polyone->CurrentValue;
					}
				}
			} else {
				$this->p1_polyone->ViewValue = NULL;
			}
			$this->p1_polyone->ViewCustomAttributes = "";

			// p2_c_qty
			$this->p2_c_qty->ViewValue = $this->p2_c_qty->CurrentValue;
			$this->p2_c_qty->ViewValue = FormatNumber($this->p2_c_qty->ViewValue, 2, -2, -2, -2);
			$this->p2_c_qty->ViewCustomAttributes = "";

			// p2_st
			$curVal = strval($this->p2_st->CurrentValue);
			if ($curVal <> "") {
				$this->p2_st->ViewValue = $this->p2_st->lookupCacheOption($curVal);
				if ($this->p2_st->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->p2_st->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->p2_st->ViewValue = $this->p2_st->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->p2_st->ViewValue = $this->p2_st->CurrentValue;
					}
				}
			} else {
				$this->p2_st->ViewValue = NULL;
			}
			$this->p2_st->ViewCustomAttributes = "";

			// p2_clariant
			$curVal = strval($this->p2_clariant->CurrentValue);
			if ($curVal <> "") {
				$this->p2_clariant->ViewValue = $this->p2_clariant->lookupCacheOption($curVal);
				if ($this->p2_clariant->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->p2_clariant->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->p2_clariant->ViewValue = $this->p2_clariant->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->p2_clariant->ViewValue = $this->p2_clariant->CurrentValue;
					}
				}
			} else {
				$this->p2_clariant->ViewValue = NULL;
			}
			$this->p2_clariant->ViewCustomAttributes = "";

			// p2_poddar
			$curVal = strval($this->p2_poddar->CurrentValue);
			if ($curVal <> "") {
				$this->p2_poddar->ViewValue = $this->p2_poddar->lookupCacheOption($curVal);
				if ($this->p2_poddar->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->p2_poddar->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->p2_poddar->ViewValue = $this->p2_poddar->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->p2_poddar->ViewValue = $this->p2_poddar->CurrentValue;
					}
				}
			} else {
				$this->p2_poddar->ViewValue = NULL;
			}
			$this->p2_poddar->ViewCustomAttributes = "";

			// p2_polyone
			$curVal = strval($this->p2_polyone->CurrentValue);
			if ($curVal <> "") {
				$this->p2_polyone->ViewValue = $this->p2_polyone->lookupCacheOption($curVal);
				if ($this->p2_polyone->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->p2_polyone->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->p2_polyone->ViewValue = $this->p2_polyone->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->p2_polyone->ViewValue = $this->p2_polyone->CurrentValue;
					}
				}
			} else {
				$this->p2_polyone->ViewValue = NULL;
			}
			$this->p2_polyone->ViewCustomAttributes = "";

			// p3_c_qty
			$this->p3_c_qty->ViewValue = $this->p3_c_qty->CurrentValue;
			$this->p3_c_qty->ViewValue = FormatNumber($this->p3_c_qty->ViewValue, 2, -2, -2, -2);
			$this->p3_c_qty->ViewCustomAttributes = "";

			// p3_st
			if (strval($this->p3_st->CurrentValue) <> "") {
				$this->p3_st->ViewValue = $this->p3_st->optionCaption($this->p3_st->CurrentValue);
			} else {
				$this->p3_st->ViewValue = NULL;
			}
			$this->p3_st->ViewCustomAttributes = "";

			// p3_clariant
			$curVal = strval($this->p3_clariant->CurrentValue);
			if ($curVal <> "") {
				$this->p3_clariant->ViewValue = $this->p3_clariant->lookupCacheOption($curVal);
				if ($this->p3_clariant->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->p3_clariant->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->p3_clariant->ViewValue = $this->p3_clariant->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->p3_clariant->ViewValue = $this->p3_clariant->CurrentValue;
					}
				}
			} else {
				$this->p3_clariant->ViewValue = NULL;
			}
			$this->p3_clariant->ViewCustomAttributes = "";

			// p3_poddar
			$curVal = strval($this->p3_poddar->CurrentValue);
			if ($curVal <> "") {
				$this->p3_poddar->ViewValue = $this->p3_poddar->lookupCacheOption($curVal);
				if ($this->p3_poddar->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->p3_poddar->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->p3_poddar->ViewValue = $this->p3_poddar->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->p3_poddar->ViewValue = $this->p3_poddar->CurrentValue;
					}
				}
			} else {
				$this->p3_poddar->ViewValue = NULL;
			}
			$this->p3_poddar->ViewCustomAttributes = "";

			// p3_polyone
			$curVal = strval($this->p3_polyone->CurrentValue);
			if ($curVal <> "") {
				$this->p3_polyone->ViewValue = $this->p3_polyone->lookupCacheOption($curVal);
				if ($this->p3_polyone->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->p3_polyone->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->p3_polyone->ViewValue = $this->p3_polyone->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->p3_polyone->ViewValue = $this->p3_polyone->CurrentValue;
					}
				}
			} else {
				$this->p3_polyone->ViewValue = NULL;
			}
			$this->p3_polyone->ViewCustomAttributes = "";

			// period
			$this->period->ViewValue = $this->period->CurrentValue;
			$this->period->ViewValue = FormatNumber($this->period->ViewValue, 0, -2, -2, -2);
			$this->period->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// yarn
			$this->yarn->LinkCustomAttributes = "";
			$this->yarn->HrefValue = "";
			$this->yarn->TooltipValue = "";

			// consumption_forcast
			$this->consumption_forcast->LinkCustomAttributes = "";
			$this->consumption_forcast->HrefValue = "";
			$this->consumption_forcast->TooltipValue = "";

			// p1_c_qty
			$this->p1_c_qty->LinkCustomAttributes = "";
			$this->p1_c_qty->HrefValue = "";
			$this->p1_c_qty->TooltipValue = "";

			// p1_st
			$this->p1_st->LinkCustomAttributes = "";
			$this->p1_st->HrefValue = "";
			$this->p1_st->TooltipValue = "";

			// p1_clariant
			$this->p1_clariant->LinkCustomAttributes = "";
			$this->p1_clariant->HrefValue = "";
			$this->p1_clariant->TooltipValue = "";

			// p1_poddar
			$this->p1_poddar->LinkCustomAttributes = "";
			$this->p1_poddar->HrefValue = "";
			$this->p1_poddar->TooltipValue = "";

			// p1_polyone
			$this->p1_polyone->LinkCustomAttributes = "";
			$this->p1_polyone->HrefValue = "";
			$this->p1_polyone->TooltipValue = "";

			// p2_c_qty
			$this->p2_c_qty->LinkCustomAttributes = "";
			$this->p2_c_qty->HrefValue = "";
			$this->p2_c_qty->TooltipValue = "";

			// p2_st
			$this->p2_st->LinkCustomAttributes = "";
			$this->p2_st->HrefValue = "";
			$this->p2_st->TooltipValue = "";

			// p2_clariant
			$this->p2_clariant->LinkCustomAttributes = "";
			$this->p2_clariant->HrefValue = "";
			$this->p2_clariant->TooltipValue = "";

			// p2_poddar
			$this->p2_poddar->LinkCustomAttributes = "";
			$this->p2_poddar->HrefValue = "";
			$this->p2_poddar->TooltipValue = "";

			// p2_polyone
			$this->p2_polyone->LinkCustomAttributes = "";
			$this->p2_polyone->HrefValue = "";
			$this->p2_polyone->TooltipValue = "";

			// p3_c_qty
			$this->p3_c_qty->LinkCustomAttributes = "";
			$this->p3_c_qty->HrefValue = "";
			$this->p3_c_qty->TooltipValue = "";

			// p3_st
			$this->p3_st->LinkCustomAttributes = "";
			$this->p3_st->HrefValue = "";
			$this->p3_st->TooltipValue = "";

			// p3_clariant
			$this->p3_clariant->LinkCustomAttributes = "";
			$this->p3_clariant->HrefValue = "";
			$this->p3_clariant->TooltipValue = "";

			// p3_poddar
			$this->p3_poddar->LinkCustomAttributes = "";
			$this->p3_poddar->HrefValue = "";
			$this->p3_poddar->TooltipValue = "";

			// p3_polyone
			$this->p3_polyone->LinkCustomAttributes = "";
			$this->p3_polyone->HrefValue = "";
			$this->p3_polyone->TooltipValue = "";

			// period
			$this->period->LinkCustomAttributes = "";
			$this->period->HrefValue = "";
			$this->period->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// yarn
			$this->yarn->EditAttrs["class"] = "form-control";
			$this->yarn->EditCustomAttributes = "";
			$curVal = trim(strval($this->yarn->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->yarn->AdvancedSearch->ViewValue = $this->yarn->lookupCacheOption($curVal);
			else
				$this->yarn->AdvancedSearch->ViewValue = $this->yarn->Lookup !== NULL && is_array($this->yarn->Lookup->Options) ? $curVal : NULL;
			if ($this->yarn->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->yarn->EditValue = array_values($this->yarn->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$sqlWrk = $this->yarn->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->yarn->EditValue = $arwrk;
			}

			// consumption_forcast
			$this->consumption_forcast->EditAttrs["class"] = "form-control";
			$this->consumption_forcast->EditCustomAttributes = "";
			$this->consumption_forcast->EditValue = HtmlEncode($this->consumption_forcast->AdvancedSearch->SearchValue);
			$this->consumption_forcast->PlaceHolder = RemoveHtml($this->consumption_forcast->caption());

			// p1_c_qty
			$this->p1_c_qty->EditAttrs["class"] = "form-control";
			$this->p1_c_qty->EditCustomAttributes = "";
			$this->p1_c_qty->EditValue = HtmlEncode($this->p1_c_qty->AdvancedSearch->SearchValue);
			$this->p1_c_qty->PlaceHolder = RemoveHtml($this->p1_c_qty->caption());

			// p1_st
			$this->p1_st->EditAttrs["class"] = "form-control";
			$this->p1_st->EditCustomAttributes = "";
			$curVal = trim(strval($this->p1_st->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->p1_st->AdvancedSearch->ViewValue = $this->p1_st->lookupCacheOption($curVal);
			else
				$this->p1_st->AdvancedSearch->ViewValue = $this->p1_st->Lookup !== NULL && is_array($this->p1_st->Lookup->Options) ? $curVal : NULL;
			if ($this->p1_st->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->p1_st->EditValue = array_values($this->p1_st->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->p1_st->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->p1_st->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->p1_st->EditValue = $arwrk;
			}

			// p1_clariant
			$this->p1_clariant->EditAttrs["class"] = "form-control";
			$this->p1_clariant->EditCustomAttributes = "";
			$curVal = trim(strval($this->p1_clariant->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->p1_clariant->AdvancedSearch->ViewValue = $this->p1_clariant->lookupCacheOption($curVal);
			else
				$this->p1_clariant->AdvancedSearch->ViewValue = $this->p1_clariant->Lookup !== NULL && is_array($this->p1_clariant->Lookup->Options) ? $curVal : NULL;
			if ($this->p1_clariant->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->p1_clariant->EditValue = array_values($this->p1_clariant->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->p1_clariant->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->p1_clariant->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->p1_clariant->EditValue = $arwrk;
			}

			// p1_poddar
			$this->p1_poddar->EditAttrs["class"] = "form-control";
			$this->p1_poddar->EditCustomAttributes = "";
			$curVal = trim(strval($this->p1_poddar->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->p1_poddar->AdvancedSearch->ViewValue = $this->p1_poddar->lookupCacheOption($curVal);
			else
				$this->p1_poddar->AdvancedSearch->ViewValue = $this->p1_poddar->Lookup !== NULL && is_array($this->p1_poddar->Lookup->Options) ? $curVal : NULL;
			if ($this->p1_poddar->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->p1_poddar->EditValue = array_values($this->p1_poddar->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->p1_poddar->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->p1_poddar->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->p1_poddar->EditValue = $arwrk;
			}

			// p1_polyone
			$this->p1_polyone->EditAttrs["class"] = "form-control";
			$this->p1_polyone->EditCustomAttributes = "";
			$curVal = trim(strval($this->p1_polyone->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->p1_polyone->AdvancedSearch->ViewValue = $this->p1_polyone->lookupCacheOption($curVal);
			else
				$this->p1_polyone->AdvancedSearch->ViewValue = $this->p1_polyone->Lookup !== NULL && is_array($this->p1_polyone->Lookup->Options) ? $curVal : NULL;
			if ($this->p1_polyone->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->p1_polyone->EditValue = array_values($this->p1_polyone->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->p1_polyone->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->p1_polyone->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->p1_polyone->EditValue = $arwrk;
			}

			// p2_c_qty
			$this->p2_c_qty->EditAttrs["class"] = "form-control";
			$this->p2_c_qty->EditCustomAttributes = "";
			$this->p2_c_qty->EditValue = HtmlEncode($this->p2_c_qty->AdvancedSearch->SearchValue);
			$this->p2_c_qty->PlaceHolder = RemoveHtml($this->p2_c_qty->caption());

			// p2_st
			$this->p2_st->EditAttrs["class"] = "form-control";
			$this->p2_st->EditCustomAttributes = "";
			$curVal = trim(strval($this->p2_st->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->p2_st->AdvancedSearch->ViewValue = $this->p2_st->lookupCacheOption($curVal);
			else
				$this->p2_st->AdvancedSearch->ViewValue = $this->p2_st->Lookup !== NULL && is_array($this->p2_st->Lookup->Options) ? $curVal : NULL;
			if ($this->p2_st->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->p2_st->EditValue = array_values($this->p2_st->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->p2_st->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->p2_st->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->p2_st->EditValue = $arwrk;
			}

			// p2_clariant
			$this->p2_clariant->EditAttrs["class"] = "form-control";
			$this->p2_clariant->EditCustomAttributes = "";
			$curVal = trim(strval($this->p2_clariant->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->p2_clariant->AdvancedSearch->ViewValue = $this->p2_clariant->lookupCacheOption($curVal);
			else
				$this->p2_clariant->AdvancedSearch->ViewValue = $this->p2_clariant->Lookup !== NULL && is_array($this->p2_clariant->Lookup->Options) ? $curVal : NULL;
			if ($this->p2_clariant->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->p2_clariant->EditValue = array_values($this->p2_clariant->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->p2_clariant->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->p2_clariant->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->p2_clariant->EditValue = $arwrk;
			}

			// p2_poddar
			$this->p2_poddar->EditAttrs["class"] = "form-control";
			$this->p2_poddar->EditCustomAttributes = "";
			$curVal = trim(strval($this->p2_poddar->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->p2_poddar->AdvancedSearch->ViewValue = $this->p2_poddar->lookupCacheOption($curVal);
			else
				$this->p2_poddar->AdvancedSearch->ViewValue = $this->p2_poddar->Lookup !== NULL && is_array($this->p2_poddar->Lookup->Options) ? $curVal : NULL;
			if ($this->p2_poddar->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->p2_poddar->EditValue = array_values($this->p2_poddar->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->p2_poddar->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->p2_poddar->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->p2_poddar->EditValue = $arwrk;
			}

			// p2_polyone
			$this->p2_polyone->EditAttrs["class"] = "form-control";
			$this->p2_polyone->EditCustomAttributes = "";
			$curVal = trim(strval($this->p2_polyone->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->p2_polyone->AdvancedSearch->ViewValue = $this->p2_polyone->lookupCacheOption($curVal);
			else
				$this->p2_polyone->AdvancedSearch->ViewValue = $this->p2_polyone->Lookup !== NULL && is_array($this->p2_polyone->Lookup->Options) ? $curVal : NULL;
			if ($this->p2_polyone->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->p2_polyone->EditValue = array_values($this->p2_polyone->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->p2_polyone->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->p2_polyone->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->p2_polyone->EditValue = $arwrk;
			}

			// p3_c_qty
			$this->p3_c_qty->EditAttrs["class"] = "form-control";
			$this->p3_c_qty->EditCustomAttributes = "";
			$this->p3_c_qty->EditValue = HtmlEncode($this->p3_c_qty->AdvancedSearch->SearchValue);
			$this->p3_c_qty->PlaceHolder = RemoveHtml($this->p3_c_qty->caption());

			// p3_st
			$this->p3_st->EditAttrs["class"] = "form-control";
			$this->p3_st->EditCustomAttributes = "";
			$this->p3_st->EditValue = $this->p3_st->options(TRUE);

			// p3_clariant
			$this->p3_clariant->EditAttrs["class"] = "form-control";
			$this->p3_clariant->EditCustomAttributes = "";
			$curVal = trim(strval($this->p3_clariant->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->p3_clariant->AdvancedSearch->ViewValue = $this->p3_clariant->lookupCacheOption($curVal);
			else
				$this->p3_clariant->AdvancedSearch->ViewValue = $this->p3_clariant->Lookup !== NULL && is_array($this->p3_clariant->Lookup->Options) ? $curVal : NULL;
			if ($this->p3_clariant->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->p3_clariant->EditValue = array_values($this->p3_clariant->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->p3_clariant->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->p3_clariant->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->p3_clariant->EditValue = $arwrk;
			}

			// p3_poddar
			$this->p3_poddar->EditAttrs["class"] = "form-control";
			$this->p3_poddar->EditCustomAttributes = "";
			$curVal = trim(strval($this->p3_poddar->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->p3_poddar->AdvancedSearch->ViewValue = $this->p3_poddar->lookupCacheOption($curVal);
			else
				$this->p3_poddar->AdvancedSearch->ViewValue = $this->p3_poddar->Lookup !== NULL && is_array($this->p3_poddar->Lookup->Options) ? $curVal : NULL;
			if ($this->p3_poddar->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->p3_poddar->EditValue = array_values($this->p3_poddar->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->p3_poddar->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->p3_poddar->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->p3_poddar->EditValue = $arwrk;
			}

			// p3_polyone
			$this->p3_polyone->EditAttrs["class"] = "form-control";
			$this->p3_polyone->EditCustomAttributes = "";
			$curVal = trim(strval($this->p3_polyone->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->p3_polyone->AdvancedSearch->ViewValue = $this->p3_polyone->lookupCacheOption($curVal);
			else
				$this->p3_polyone->AdvancedSearch->ViewValue = $this->p3_polyone->Lookup !== NULL && is_array($this->p3_polyone->Lookup->Options) ? $curVal : NULL;
			if ($this->p3_polyone->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->p3_polyone->EditValue = array_values($this->p3_polyone->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->p3_polyone->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->p3_polyone->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->p3_polyone->EditValue = $arwrk;
			}

			// period
			$this->period->EditAttrs["class"] = "form-control";
			$this->period->EditCustomAttributes = "";
			$this->period->EditValue = HtmlEncode($this->period->AdvancedSearch->SearchValue);
			$this->period->PlaceHolder = RemoveHtml($this->period->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckNumber($this->consumption_forcast->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->consumption_forcast->errorMessage());
		}
		if (!CheckNumber($this->p1_c_qty->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->p1_c_qty->errorMessage());
		}
		if (!CheckNumber($this->p2_c_qty->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->p2_c_qty->errorMessage());
		}
		if (!CheckNumber($this->p3_c_qty->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->p3_c_qty->errorMessage());
		}
		if (!CheckInteger($this->period->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->period->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->yarn->AdvancedSearch->load();
		$this->consumption_forcast->AdvancedSearch->load();
		$this->p1_c_qty->AdvancedSearch->load();
		$this->p1_st->AdvancedSearch->load();
		$this->p1_clariant->AdvancedSearch->load();
		$this->p1_poddar->AdvancedSearch->load();
		$this->p1_polyone->AdvancedSearch->load();
		$this->p2_c_qty->AdvancedSearch->load();
		$this->p2_st->AdvancedSearch->load();
		$this->p2_clariant->AdvancedSearch->load();
		$this->p2_poddar->AdvancedSearch->load();
		$this->p2_polyone->AdvancedSearch->load();
		$this->p3_c_qty->AdvancedSearch->load();
		$this->p3_st->AdvancedSearch->load();
		$this->p3_clariant->AdvancedSearch->load();
		$this->p3_poddar->AdvancedSearch->load();
		$this->p3_polyone->AdvancedSearch->load();
		$this->period->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("ww_color_req_detailedlist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_yarn":
							break;
						case "x_p1_st":
							break;
						case "x_p1_clariant":
							break;
						case "x_p1_poddar":
							break;
						case "x_p1_polyone":
							break;
						case "x_p2_st":
							break;
						case "x_p2_clariant":
							break;
						case "x_p2_poddar":
							break;
						case "x_p2_polyone":
							break;
						case "x_p3_clariant":
							break;
						case "x_p3_poddar":
							break;
						case "x_p3_polyone":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>