<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class ww_color_search extends ww_color
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'ww_color';

	// Page object name
	public $PageObjName = "ww_color_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (ww_color)
		if (!isset($GLOBALS["ww_color"]) || get_class($GLOBALS["ww_color"]) == PROJECT_NAMESPACE . "ww_color") {
			$GLOBALS["ww_color"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["ww_color"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'ww_color');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $ww_color;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($ww_color);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "ww_colorview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("ww_colorlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->color->setVisibility();
		$this->color_source->setVisibility();
		$this->base_color->setVisibility();
		$this->match_clariant->setVisibility();
		$this->match_poddar->setVisibility();
		$this->match_polyone->setVisibility();
		$this->moq->setVisibility();
		$this->m_stock->setVisibility();
		$this->stock->setVisibility();
		$this->required->setVisibility();
		$this->ordered->setVisibility();
		$this->pending_order->setVisibility();
		$this->status->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->match_clariant);
		$this->setupLookupOptions($this->match_poddar);
		$this->setupLookupOptions($this->match_polyone);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "ww_colorlist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->color); // color
		$this->buildSearchUrl($srchUrl, $this->color_source); // color_source
		$this->buildSearchUrl($srchUrl, $this->base_color); // base_color
		$this->buildSearchUrl($srchUrl, $this->match_clariant); // match_clariant
		$this->buildSearchUrl($srchUrl, $this->match_poddar); // match_poddar
		$this->buildSearchUrl($srchUrl, $this->match_polyone); // match_polyone
		$this->buildSearchUrl($srchUrl, $this->moq); // moq
		$this->buildSearchUrl($srchUrl, $this->m_stock); // m_stock
		$this->buildSearchUrl($srchUrl, $this->stock); // stock
		$this->buildSearchUrl($srchUrl, $this->required); // required
		$this->buildSearchUrl($srchUrl, $this->ordered); // ordered
		$this->buildSearchUrl($srchUrl, $this->pending_order); // pending_order
		$this->buildSearchUrl($srchUrl, $this->status); // status
		$this->buildSearchUrl($srchUrl, $this->operator); // operator
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// color
		if (!$this->isAddOrEdit())
			$this->color->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_color"));
		$this->color->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_color"));

		// color_source
		if (!$this->isAddOrEdit())
			$this->color_source->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_color_source"));
		$this->color_source->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_color_source"));

		// base_color
		if (!$this->isAddOrEdit())
			$this->base_color->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_base_color"));
		$this->base_color->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_base_color"));

		// match_clariant
		if (!$this->isAddOrEdit())
			$this->match_clariant->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_match_clariant"));
		$this->match_clariant->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_match_clariant"));

		// match_poddar
		if (!$this->isAddOrEdit())
			$this->match_poddar->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_match_poddar"));
		$this->match_poddar->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_match_poddar"));

		// match_polyone
		if (!$this->isAddOrEdit())
			$this->match_polyone->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_match_polyone"));
		$this->match_polyone->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_match_polyone"));

		// moq
		if (!$this->isAddOrEdit())
			$this->moq->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_moq"));
		$this->moq->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_moq"));

		// m_stock
		if (!$this->isAddOrEdit())
			$this->m_stock->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_stock"));
		$this->m_stock->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_stock"));

		// stock
		if (!$this->isAddOrEdit())
			$this->stock->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_stock"));
		$this->stock->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_stock"));

		// required
		if (!$this->isAddOrEdit())
			$this->required->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_required"));
		$this->required->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_required"));

		// ordered
		if (!$this->isAddOrEdit())
			$this->ordered->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_ordered"));
		$this->ordered->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_ordered"));

		// pending_order
		if (!$this->isAddOrEdit())
			$this->pending_order->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pending_order"));
		$this->pending_order->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pending_order"));

		// status
		if (!$this->isAddOrEdit())
			$this->status->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_status"));
		$this->status->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_status"));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_operator"));
		$this->operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_operator"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->moq->FormValue == $this->moq->CurrentValue && is_numeric(ConvertToFloatString($this->moq->CurrentValue)))
			$this->moq->CurrentValue = ConvertToFloatString($this->moq->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_stock->FormValue == $this->m_stock->CurrentValue && is_numeric(ConvertToFloatString($this->m_stock->CurrentValue)))
			$this->m_stock->CurrentValue = ConvertToFloatString($this->m_stock->CurrentValue);

		// Convert decimal values if posted back
		if ($this->stock->FormValue == $this->stock->CurrentValue && is_numeric(ConvertToFloatString($this->stock->CurrentValue)))
			$this->stock->CurrentValue = ConvertToFloatString($this->stock->CurrentValue);

		// Convert decimal values if posted back
		if ($this->required->FormValue == $this->required->CurrentValue && is_numeric(ConvertToFloatString($this->required->CurrentValue)))
			$this->required->CurrentValue = ConvertToFloatString($this->required->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ordered->FormValue == $this->ordered->CurrentValue && is_numeric(ConvertToFloatString($this->ordered->CurrentValue)))
			$this->ordered->CurrentValue = ConvertToFloatString($this->ordered->CurrentValue);

		// Convert decimal values if posted back
		if ($this->pending_order->FormValue == $this->pending_order->CurrentValue && is_numeric(ConvertToFloatString($this->pending_order->CurrentValue)))
			$this->pending_order->CurrentValue = ConvertToFloatString($this->pending_order->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// color
		// color_source
		// base_color
		// match_clariant
		// match_poddar
		// match_polyone
		// moq
		// m_stock
		// stock
		// required
		// ordered
		// pending_order
		// status
		// operator
		// datetime

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// color
			$this->color->ViewValue = $this->color->CurrentValue;
			$this->color->ViewCustomAttributes = "";

			// color_source
			if (strval($this->color_source->CurrentValue) <> "") {
				$this->color_source->ViewValue = $this->color_source->optionCaption($this->color_source->CurrentValue);
			} else {
				$this->color_source->ViewValue = NULL;
			}
			$this->color_source->ViewCustomAttributes = "";

			// base_color
			if (strval($this->base_color->CurrentValue) <> "") {
				$this->base_color->ViewValue = $this->base_color->optionCaption($this->base_color->CurrentValue);
			} else {
				$this->base_color->ViewValue = NULL;
			}
			$this->base_color->ViewCustomAttributes = "";

			// match_clariant
			$curVal = strval($this->match_clariant->CurrentValue);
			if ($curVal <> "") {
				$this->match_clariant->ViewValue = $this->match_clariant->lookupCacheOption($curVal);
				if ($this->match_clariant->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`color_source` = 'Clariant' or `id` = 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->match_clariant->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->match_clariant->ViewValue = $this->match_clariant->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->match_clariant->ViewValue = $this->match_clariant->CurrentValue;
					}
				}
			} else {
				$this->match_clariant->ViewValue = NULL;
			}
			$this->match_clariant->ViewCustomAttributes = "";

			// match_poddar
			$curVal = strval($this->match_poddar->CurrentValue);
			if ($curVal <> "") {
				$this->match_poddar->ViewValue = $this->match_poddar->lookupCacheOption($curVal);
				if ($this->match_poddar->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`color_source` =  'Poddar' or `id` = 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->match_poddar->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->match_poddar->ViewValue = $this->match_poddar->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->match_poddar->ViewValue = $this->match_poddar->CurrentValue;
					}
				}
			} else {
				$this->match_poddar->ViewValue = NULL;
			}
			$this->match_poddar->ViewCustomAttributes = "";

			// match_polyone
			$curVal = strval($this->match_polyone->CurrentValue);
			if ($curVal <> "") {
				$this->match_polyone->ViewValue = $this->match_polyone->lookupCacheOption($curVal);
				if ($this->match_polyone->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`color_source` =  'Polyone' or `id` = 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->match_polyone->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->match_polyone->ViewValue = $this->match_polyone->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->match_polyone->ViewValue = $this->match_polyone->CurrentValue;
					}
				}
			} else {
				$this->match_polyone->ViewValue = NULL;
			}
			$this->match_polyone->ViewCustomAttributes = "";

			// moq
			$this->moq->ViewValue = $this->moq->CurrentValue;
			$this->moq->ViewValue = FormatNumber($this->moq->ViewValue, 2, -2, -2, -2);
			$this->moq->ViewCustomAttributes = "";

			// m_stock
			$this->m_stock->ViewValue = $this->m_stock->CurrentValue;
			$this->m_stock->ViewValue = FormatNumber($this->m_stock->ViewValue, 2, -2, -2, -2);
			$this->m_stock->ViewCustomAttributes = "";

			// stock
			$this->stock->ViewValue = $this->stock->CurrentValue;
			$this->stock->ViewValue = FormatNumber($this->stock->ViewValue, 2, -2, -2, -2);
			$this->stock->ViewCustomAttributes = "";

			// required
			$this->required->ViewValue = $this->required->CurrentValue;
			$this->required->ViewValue = FormatNumber($this->required->ViewValue, 2, -2, -2, -2);
			$this->required->ViewCustomAttributes = "";

			// ordered
			$this->ordered->ViewValue = $this->ordered->CurrentValue;
			$this->ordered->ViewValue = FormatNumber($this->ordered->ViewValue, 2, -2, -2, -2);
			$this->ordered->ViewCustomAttributes = "";

			// pending_order
			$this->pending_order->ViewValue = $this->pending_order->CurrentValue;
			$this->pending_order->ViewValue = FormatNumber($this->pending_order->ViewValue, 2, -2, -2, -2);
			$this->pending_order->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// color
			$this->color->LinkCustomAttributes = "";
			$this->color->HrefValue = "";
			$this->color->TooltipValue = "";

			// color_source
			$this->color_source->LinkCustomAttributes = "";
			$this->color_source->HrefValue = "";
			$this->color_source->TooltipValue = "";

			// base_color
			$this->base_color->LinkCustomAttributes = "";
			$this->base_color->HrefValue = "";
			$this->base_color->TooltipValue = "";

			// match_clariant
			$this->match_clariant->LinkCustomAttributes = "";
			$this->match_clariant->HrefValue = "";
			$this->match_clariant->TooltipValue = "";

			// match_poddar
			$this->match_poddar->LinkCustomAttributes = "";
			$this->match_poddar->HrefValue = "";
			$this->match_poddar->TooltipValue = "";

			// match_polyone
			$this->match_polyone->LinkCustomAttributes = "";
			$this->match_polyone->HrefValue = "";
			$this->match_polyone->TooltipValue = "";

			// moq
			$this->moq->LinkCustomAttributes = "";
			$this->moq->HrefValue = "";
			$this->moq->TooltipValue = "";

			// m_stock
			$this->m_stock->LinkCustomAttributes = "";
			$this->m_stock->HrefValue = "";
			$this->m_stock->TooltipValue = "";

			// stock
			$this->stock->LinkCustomAttributes = "";
			$this->stock->HrefValue = "";
			$this->stock->TooltipValue = "";

			// required
			$this->required->LinkCustomAttributes = "";
			$this->required->HrefValue = "";
			$this->required->TooltipValue = "";

			// ordered
			$this->ordered->LinkCustomAttributes = "";
			$this->ordered->HrefValue = "";
			$this->ordered->TooltipValue = "";

			// pending_order
			$this->pending_order->LinkCustomAttributes = "";
			$this->pending_order->HrefValue = "";
			$this->pending_order->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// color
			$this->color->EditAttrs["class"] = "form-control";
			$this->color->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->color->AdvancedSearch->SearchValue = HtmlDecode($this->color->AdvancedSearch->SearchValue);
			$this->color->EditValue = HtmlEncode($this->color->AdvancedSearch->SearchValue);
			$this->color->PlaceHolder = RemoveHtml($this->color->caption());

			// color_source
			$this->color_source->EditAttrs["class"] = "form-control";
			$this->color_source->EditCustomAttributes = "";
			$this->color_source->EditValue = $this->color_source->options(TRUE);

			// base_color
			$this->base_color->EditAttrs["class"] = "form-control";
			$this->base_color->EditCustomAttributes = "";
			$this->base_color->EditValue = $this->base_color->options(TRUE);

			// match_clariant
			$this->match_clariant->EditAttrs["class"] = "form-control";
			$this->match_clariant->EditCustomAttributes = "";
			$curVal = trim(strval($this->match_clariant->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->match_clariant->AdvancedSearch->ViewValue = $this->match_clariant->lookupCacheOption($curVal);
			else
				$this->match_clariant->AdvancedSearch->ViewValue = $this->match_clariant->Lookup !== NULL && is_array($this->match_clariant->Lookup->Options) ? $curVal : NULL;
			if ($this->match_clariant->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->match_clariant->EditValue = array_values($this->match_clariant->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->match_clariant->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`color_source` = 'Clariant' or `id` = 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->match_clariant->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->match_clariant->EditValue = $arwrk;
			}

			// match_poddar
			$this->match_poddar->EditAttrs["class"] = "form-control";
			$this->match_poddar->EditCustomAttributes = "";
			$curVal = trim(strval($this->match_poddar->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->match_poddar->AdvancedSearch->ViewValue = $this->match_poddar->lookupCacheOption($curVal);
			else
				$this->match_poddar->AdvancedSearch->ViewValue = $this->match_poddar->Lookup !== NULL && is_array($this->match_poddar->Lookup->Options) ? $curVal : NULL;
			if ($this->match_poddar->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->match_poddar->EditValue = array_values($this->match_poddar->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->match_poddar->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`color_source` =  'Poddar' or `id` = 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->match_poddar->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->match_poddar->EditValue = $arwrk;
			}

			// match_polyone
			$this->match_polyone->EditAttrs["class"] = "form-control";
			$this->match_polyone->EditCustomAttributes = "";
			$curVal = trim(strval($this->match_polyone->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->match_polyone->AdvancedSearch->ViewValue = $this->match_polyone->lookupCacheOption($curVal);
			else
				$this->match_polyone->AdvancedSearch->ViewValue = $this->match_polyone->Lookup !== NULL && is_array($this->match_polyone->Lookup->Options) ? $curVal : NULL;
			if ($this->match_polyone->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->match_polyone->EditValue = array_values($this->match_polyone->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->match_polyone->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`color_source` =  'Polyone' or `id` = 0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->match_polyone->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->match_polyone->EditValue = $arwrk;
			}

			// moq
			$this->moq->EditAttrs["class"] = "form-control";
			$this->moq->EditCustomAttributes = "";
			$this->moq->EditValue = HtmlEncode($this->moq->AdvancedSearch->SearchValue);
			$this->moq->PlaceHolder = RemoveHtml($this->moq->caption());

			// m_stock
			$this->m_stock->EditAttrs["class"] = "form-control";
			$this->m_stock->EditCustomAttributes = "";
			$this->m_stock->EditValue = HtmlEncode($this->m_stock->AdvancedSearch->SearchValue);
			$this->m_stock->PlaceHolder = RemoveHtml($this->m_stock->caption());

			// stock
			$this->stock->EditAttrs["class"] = "form-control";
			$this->stock->EditCustomAttributes = "";
			$this->stock->EditValue = HtmlEncode($this->stock->AdvancedSearch->SearchValue);
			$this->stock->PlaceHolder = RemoveHtml($this->stock->caption());

			// required
			$this->required->EditAttrs["class"] = "form-control";
			$this->required->EditCustomAttributes = "";
			$this->required->EditValue = HtmlEncode($this->required->AdvancedSearch->SearchValue);
			$this->required->PlaceHolder = RemoveHtml($this->required->caption());

			// ordered
			$this->ordered->EditAttrs["class"] = "form-control";
			$this->ordered->EditCustomAttributes = "";
			$this->ordered->EditValue = HtmlEncode($this->ordered->AdvancedSearch->SearchValue);
			$this->ordered->PlaceHolder = RemoveHtml($this->ordered->caption());

			// pending_order
			$this->pending_order->EditAttrs["class"] = "form-control";
			$this->pending_order->EditCustomAttributes = "";
			$this->pending_order->EditValue = HtmlEncode($this->pending_order->AdvancedSearch->SearchValue);
			$this->pending_order->PlaceHolder = RemoveHtml($this->pending_order->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$this->operator->EditValue = HtmlEncode($this->operator->AdvancedSearch->SearchValue);
			$this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckNumber($this->moq->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->moq->errorMessage());
		}
		if (!CheckNumber($this->m_stock->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_stock->errorMessage());
		}
		if (!CheckNumber($this->stock->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->stock->errorMessage());
		}
		if (!CheckNumber($this->required->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->required->errorMessage());
		}
		if (!CheckNumber($this->ordered->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->ordered->errorMessage());
		}
		if (!CheckNumber($this->pending_order->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->pending_order->errorMessage());
		}
		if (!CheckInteger($this->operator->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->operator->errorMessage());
		}
		if (!CheckDate($this->datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->datetime->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->color->AdvancedSearch->load();
		$this->color_source->AdvancedSearch->load();
		$this->base_color->AdvancedSearch->load();
		$this->match_clariant->AdvancedSearch->load();
		$this->match_poddar->AdvancedSearch->load();
		$this->match_polyone->AdvancedSearch->load();
		$this->moq->AdvancedSearch->load();
		$this->m_stock->AdvancedSearch->load();
		$this->stock->AdvancedSearch->load();
		$this->required->AdvancedSearch->load();
		$this->ordered->AdvancedSearch->load();
		$this->pending_order->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("ww_colorlist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_match_clariant":
					$lookupFilter = function() {
						return "`color_source` = 'Clariant' or `id` = 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_match_poddar":
					$lookupFilter = function() {
						return "`color_source` =  'Poddar' or `id` = 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_match_polyone":
					$lookupFilter = function() {
						return "`color_source` =  'Polyone' or `id` = 0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_match_clariant":
							break;
						case "x_match_poddar":
							break;
						case "x_match_polyone":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>