<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class ww_yarn_edit extends ww_yarn
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'ww_yarn';

	// Page object name
	public $PageObjName = "ww_yarn_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (ww_yarn)
		if (!isset($GLOBALS["ww_yarn"]) || get_class($GLOBALS["ww_yarn"]) == PROJECT_NAMESPACE . "ww_yarn") {
			$GLOBALS["ww_yarn"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["ww_yarn"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'ww_yarn');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $ww_yarn;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($ww_yarn);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "ww_yarnview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("ww_yarnlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->yarn->setVisibility();
		$this->ply_1_color->setVisibility();
		$this->ply_1_qty->setVisibility();
		$this->ply_2_color->setVisibility();
		$this->ply_2_qty->setVisibility();
		$this->ply_3_color->setVisibility();
		$this->ply_3_qty->setVisibility();
		$this->stock->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->moq->setVisibility();
		$this->m_stock->setVisibility();
		$this->required->Visible = FALSE;
		$this->ordered->Visible = FALSE;
		$this->pending_order->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->yarn);
		$this->setupLookupOptions($this->ply_1_color);
		$this->setupLookupOptions($this->ply_2_color);
		$this->setupLookupOptions($this->ply_3_color);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("ww_yarnlist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "ww_yarnlist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);

		// Check field name 'yarn' first before field var 'x_yarn'
		$val = $CurrentForm->hasValue("yarn") ? $CurrentForm->getValue("yarn") : $CurrentForm->getValue("x_yarn");
		if (!$this->yarn->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->yarn->Visible = FALSE; // Disable update for API request
			else
				$this->yarn->setFormValue($val);
		}

		// Check field name 'ply_1_color' first before field var 'x_ply_1_color'
		$val = $CurrentForm->hasValue("ply_1_color") ? $CurrentForm->getValue("ply_1_color") : $CurrentForm->getValue("x_ply_1_color");
		if (!$this->ply_1_color->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ply_1_color->Visible = FALSE; // Disable update for API request
			else
				$this->ply_1_color->setFormValue($val);
		}

		// Check field name 'ply_1_qty' first before field var 'x_ply_1_qty'
		$val = $CurrentForm->hasValue("ply_1_qty") ? $CurrentForm->getValue("ply_1_qty") : $CurrentForm->getValue("x_ply_1_qty");
		if (!$this->ply_1_qty->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ply_1_qty->Visible = FALSE; // Disable update for API request
			else
				$this->ply_1_qty->setFormValue($val);
		}

		// Check field name 'ply_2_color' first before field var 'x_ply_2_color'
		$val = $CurrentForm->hasValue("ply_2_color") ? $CurrentForm->getValue("ply_2_color") : $CurrentForm->getValue("x_ply_2_color");
		if (!$this->ply_2_color->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ply_2_color->Visible = FALSE; // Disable update for API request
			else
				$this->ply_2_color->setFormValue($val);
		}

		// Check field name 'ply_2_qty' first before field var 'x_ply_2_qty'
		$val = $CurrentForm->hasValue("ply_2_qty") ? $CurrentForm->getValue("ply_2_qty") : $CurrentForm->getValue("x_ply_2_qty");
		if (!$this->ply_2_qty->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ply_2_qty->Visible = FALSE; // Disable update for API request
			else
				$this->ply_2_qty->setFormValue($val);
		}

		// Check field name 'ply_3_color' first before field var 'x_ply_3_color'
		$val = $CurrentForm->hasValue("ply_3_color") ? $CurrentForm->getValue("ply_3_color") : $CurrentForm->getValue("x_ply_3_color");
		if (!$this->ply_3_color->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ply_3_color->Visible = FALSE; // Disable update for API request
			else
				$this->ply_3_color->setFormValue($val);
		}

		// Check field name 'ply_3_qty' first before field var 'x_ply_3_qty'
		$val = $CurrentForm->hasValue("ply_3_qty") ? $CurrentForm->getValue("ply_3_qty") : $CurrentForm->getValue("x_ply_3_qty");
		if (!$this->ply_3_qty->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ply_3_qty->Visible = FALSE; // Disable update for API request
			else
				$this->ply_3_qty->setFormValue($val);
		}

		// Check field name 'stock' first before field var 'x_stock'
		$val = $CurrentForm->hasValue("stock") ? $CurrentForm->getValue("stock") : $CurrentForm->getValue("x_stock");
		if (!$this->stock->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->stock->Visible = FALSE; // Disable update for API request
			else
				$this->stock->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'moq' first before field var 'x_moq'
		$val = $CurrentForm->hasValue("moq") ? $CurrentForm->getValue("moq") : $CurrentForm->getValue("x_moq");
		if (!$this->moq->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->moq->Visible = FALSE; // Disable update for API request
			else
				$this->moq->setFormValue($val);
		}

		// Check field name 'm_stock' first before field var 'x_m_stock'
		$val = $CurrentForm->hasValue("m_stock") ? $CurrentForm->getValue("m_stock") : $CurrentForm->getValue("x_m_stock");
		if (!$this->m_stock->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_stock->Visible = FALSE; // Disable update for API request
			else
				$this->m_stock->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->yarn->CurrentValue = $this->yarn->FormValue;
		$this->ply_1_color->CurrentValue = $this->ply_1_color->FormValue;
		$this->ply_1_qty->CurrentValue = $this->ply_1_qty->FormValue;
		$this->ply_2_color->CurrentValue = $this->ply_2_color->FormValue;
		$this->ply_2_qty->CurrentValue = $this->ply_2_qty->FormValue;
		$this->ply_3_color->CurrentValue = $this->ply_3_color->FormValue;
		$this->ply_3_qty->CurrentValue = $this->ply_3_qty->FormValue;
		$this->stock->CurrentValue = $this->stock->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		$this->moq->CurrentValue = $this->moq->FormValue;
		$this->m_stock->CurrentValue = $this->m_stock->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->yarn->setDbValue($row['yarn']);
		$this->ply_1_color->setDbValue($row['ply_1_color']);
		$this->ply_1_qty->setDbValue($row['ply_1_qty']);
		$this->ply_2_color->setDbValue($row['ply_2_color']);
		$this->ply_2_qty->setDbValue($row['ply_2_qty']);
		$this->ply_3_color->setDbValue($row['ply_3_color']);
		$this->ply_3_qty->setDbValue($row['ply_3_qty']);
		$this->stock->setDbValue($row['stock']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->moq->setDbValue($row['moq']);
		$this->m_stock->setDbValue($row['m_stock']);
		$this->required->setDbValue($row['required']);
		$this->ordered->setDbValue($row['ordered']);
		$this->pending_order->setDbValue($row['pending_order']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['yarn'] = NULL;
		$row['ply_1_color'] = NULL;
		$row['ply_1_qty'] = NULL;
		$row['ply_2_color'] = NULL;
		$row['ply_2_qty'] = NULL;
		$row['ply_3_color'] = NULL;
		$row['ply_3_qty'] = NULL;
		$row['stock'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['moq'] = NULL;
		$row['m_stock'] = NULL;
		$row['required'] = NULL;
		$row['ordered'] = NULL;
		$row['pending_order'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->ply_1_qty->FormValue == $this->ply_1_qty->CurrentValue && is_numeric(ConvertToFloatString($this->ply_1_qty->CurrentValue)))
			$this->ply_1_qty->CurrentValue = ConvertToFloatString($this->ply_1_qty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ply_2_qty->FormValue == $this->ply_2_qty->CurrentValue && is_numeric(ConvertToFloatString($this->ply_2_qty->CurrentValue)))
			$this->ply_2_qty->CurrentValue = ConvertToFloatString($this->ply_2_qty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ply_3_qty->FormValue == $this->ply_3_qty->CurrentValue && is_numeric(ConvertToFloatString($this->ply_3_qty->CurrentValue)))
			$this->ply_3_qty->CurrentValue = ConvertToFloatString($this->ply_3_qty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->stock->FormValue == $this->stock->CurrentValue && is_numeric(ConvertToFloatString($this->stock->CurrentValue)))
			$this->stock->CurrentValue = ConvertToFloatString($this->stock->CurrentValue);

		// Convert decimal values if posted back
		if ($this->moq->FormValue == $this->moq->CurrentValue && is_numeric(ConvertToFloatString($this->moq->CurrentValue)))
			$this->moq->CurrentValue = ConvertToFloatString($this->moq->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_stock->FormValue == $this->m_stock->CurrentValue && is_numeric(ConvertToFloatString($this->m_stock->CurrentValue)))
			$this->m_stock->CurrentValue = ConvertToFloatString($this->m_stock->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// yarn
		// ply_1_color
		// ply_1_qty
		// ply_2_color
		// ply_2_qty
		// ply_3_color
		// ply_3_qty
		// stock
		// operator
		// datetime
		// moq
		// m_stock
		// required
		// ordered
		// pending_order

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// yarn
			$curVal = strval($this->yarn->CurrentValue);
			if ($curVal <> "") {
				$this->yarn->ViewValue = $this->yarn->lookupCacheOption($curVal);
				if ($this->yarn->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`s_grp`= 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->yarn->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->yarn->ViewValue = $this->yarn->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->yarn->ViewValue = $this->yarn->CurrentValue;
					}
				}
			} else {
				$this->yarn->ViewValue = NULL;
			}
			$this->yarn->ViewCustomAttributes = "";

			// ply_1_color
			$curVal = strval($this->ply_1_color->CurrentValue);
			if ($curVal <> "") {
				$this->ply_1_color->ViewValue = $this->ply_1_color->lookupCacheOption($curVal);
				if ($this->ply_1_color->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `base_color` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->ply_1_color->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->ply_1_color->ViewValue = $this->ply_1_color->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->ply_1_color->ViewValue = $this->ply_1_color->CurrentValue;
					}
				}
			} else {
				$this->ply_1_color->ViewValue = NULL;
			}
			$this->ply_1_color->ViewCustomAttributes = "";

			// ply_1_qty
			$this->ply_1_qty->ViewValue = $this->ply_1_qty->CurrentValue;
			$this->ply_1_qty->ViewValue = FormatNumber($this->ply_1_qty->ViewValue, 2, -2, -2, -2);
			$this->ply_1_qty->ViewCustomAttributes = "";

			// ply_2_color
			$curVal = strval($this->ply_2_color->CurrentValue);
			if ($curVal <> "") {
				$this->ply_2_color->ViewValue = $this->ply_2_color->lookupCacheOption($curVal);
				if ($this->ply_2_color->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `base_color` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->ply_2_color->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->ply_2_color->ViewValue = $this->ply_2_color->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->ply_2_color->ViewValue = $this->ply_2_color->CurrentValue;
					}
				}
			} else {
				$this->ply_2_color->ViewValue = NULL;
			}
			$this->ply_2_color->ViewCustomAttributes = "";

			// ply_2_qty
			$this->ply_2_qty->ViewValue = $this->ply_2_qty->CurrentValue;
			$this->ply_2_qty->ViewValue = FormatNumber($this->ply_2_qty->ViewValue, 2, -2, -2, -2);
			$this->ply_2_qty->ViewCustomAttributes = "";

			// ply_3_color
			$curVal = strval($this->ply_3_color->CurrentValue);
			if ($curVal <> "") {
				$this->ply_3_color->ViewValue = $this->ply_3_color->lookupCacheOption($curVal);
				if ($this->ply_3_color->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `base_color` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->ply_3_color->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->ply_3_color->ViewValue = $this->ply_3_color->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->ply_3_color->ViewValue = $this->ply_3_color->CurrentValue;
					}
				}
			} else {
				$this->ply_3_color->ViewValue = NULL;
			}
			$this->ply_3_color->ViewCustomAttributes = "";

			// ply_3_qty
			$this->ply_3_qty->ViewValue = $this->ply_3_qty->CurrentValue;
			$this->ply_3_qty->ViewValue = FormatNumber($this->ply_3_qty->ViewValue, 2, -2, -2, -2);
			$this->ply_3_qty->ViewCustomAttributes = "";

			// stock
			$this->stock->ViewValue = $this->stock->CurrentValue;
			$this->stock->ViewValue = FormatNumber($this->stock->ViewValue, 2, -2, -2, -2);
			$this->stock->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// moq
			$this->moq->ViewValue = $this->moq->CurrentValue;
			$this->moq->ViewValue = FormatNumber($this->moq->ViewValue, 2, -2, -2, -2);
			$this->moq->ViewCustomAttributes = "";

			// m_stock
			$this->m_stock->ViewValue = $this->m_stock->CurrentValue;
			$this->m_stock->ViewValue = FormatNumber($this->m_stock->ViewValue, 2, -2, -2, -2);
			$this->m_stock->ViewCustomAttributes = "";

			// required
			$this->required->ViewValue = $this->required->CurrentValue;
			$this->required->ViewValue = FormatNumber($this->required->ViewValue, 2, -2, -2, -2);
			$this->required->ViewCustomAttributes = "";

			// ordered
			$this->ordered->ViewValue = $this->ordered->CurrentValue;
			$this->ordered->ViewValue = FormatNumber($this->ordered->ViewValue, 2, -2, -2, -2);
			$this->ordered->ViewCustomAttributes = "";

			// pending_order
			$this->pending_order->ViewValue = $this->pending_order->CurrentValue;
			$this->pending_order->ViewValue = FormatNumber($this->pending_order->ViewValue, 2, -2, -2, -2);
			$this->pending_order->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// yarn
			$this->yarn->LinkCustomAttributes = "";
			$this->yarn->HrefValue = "";
			$this->yarn->TooltipValue = "";

			// ply_1_color
			$this->ply_1_color->LinkCustomAttributes = "";
			$this->ply_1_color->HrefValue = "";
			$this->ply_1_color->TooltipValue = "";

			// ply_1_qty
			$this->ply_1_qty->LinkCustomAttributes = "";
			$this->ply_1_qty->HrefValue = "";
			$this->ply_1_qty->TooltipValue = "";

			// ply_2_color
			$this->ply_2_color->LinkCustomAttributes = "";
			$this->ply_2_color->HrefValue = "";
			$this->ply_2_color->TooltipValue = "";

			// ply_2_qty
			$this->ply_2_qty->LinkCustomAttributes = "";
			$this->ply_2_qty->HrefValue = "";
			$this->ply_2_qty->TooltipValue = "";

			// ply_3_color
			$this->ply_3_color->LinkCustomAttributes = "";
			$this->ply_3_color->HrefValue = "";
			$this->ply_3_color->TooltipValue = "";

			// ply_3_qty
			$this->ply_3_qty->LinkCustomAttributes = "";
			$this->ply_3_qty->HrefValue = "";
			$this->ply_3_qty->TooltipValue = "";

			// stock
			$this->stock->LinkCustomAttributes = "";
			$this->stock->HrefValue = "";
			$this->stock->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// moq
			$this->moq->LinkCustomAttributes = "";
			$this->moq->HrefValue = "";
			$this->moq->TooltipValue = "";

			// m_stock
			$this->m_stock->LinkCustomAttributes = "";
			$this->m_stock->HrefValue = "";
			$this->m_stock->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// yarn
			$this->yarn->EditAttrs["class"] = "form-control";
			$this->yarn->EditCustomAttributes = "";
			$curVal = trim(strval($this->yarn->CurrentValue));
			if ($curVal <> "")
				$this->yarn->ViewValue = $this->yarn->lookupCacheOption($curVal);
			else
				$this->yarn->ViewValue = $this->yarn->Lookup !== NULL && is_array($this->yarn->Lookup->Options) ? $curVal : NULL;
			if ($this->yarn->ViewValue !== NULL) { // Load from cache
				$this->yarn->EditValue = array_values($this->yarn->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->yarn->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`s_grp`= 2";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->yarn->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->yarn->EditValue = $arwrk;
			}

			// ply_1_color
			$this->ply_1_color->EditAttrs["class"] = "form-control";
			$this->ply_1_color->EditCustomAttributes = "";
			$curVal = trim(strval($this->ply_1_color->CurrentValue));
			if ($curVal <> "")
				$this->ply_1_color->ViewValue = $this->ply_1_color->lookupCacheOption($curVal);
			else
				$this->ply_1_color->ViewValue = $this->ply_1_color->Lookup !== NULL && is_array($this->ply_1_color->Lookup->Options) ? $curVal : NULL;
			if ($this->ply_1_color->ViewValue !== NULL) { // Load from cache
				$this->ply_1_color->EditValue = array_values($this->ply_1_color->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->ply_1_color->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1 and `base_color` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->ply_1_color->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->ply_1_color->EditValue = $arwrk;
			}

			// ply_1_qty
			$this->ply_1_qty->EditAttrs["class"] = "form-control";
			$this->ply_1_qty->EditCustomAttributes = "";
			$this->ply_1_qty->EditValue = HtmlEncode($this->ply_1_qty->CurrentValue);
			$this->ply_1_qty->PlaceHolder = RemoveHtml($this->ply_1_qty->caption());
			if (strval($this->ply_1_qty->EditValue) <> "" && is_numeric($this->ply_1_qty->EditValue))
				$this->ply_1_qty->EditValue = FormatNumber($this->ply_1_qty->EditValue, -2, -2, -2, -2);

			// ply_2_color
			$this->ply_2_color->EditAttrs["class"] = "form-control";
			$this->ply_2_color->EditCustomAttributes = "";
			$curVal = trim(strval($this->ply_2_color->CurrentValue));
			if ($curVal <> "")
				$this->ply_2_color->ViewValue = $this->ply_2_color->lookupCacheOption($curVal);
			else
				$this->ply_2_color->ViewValue = $this->ply_2_color->Lookup !== NULL && is_array($this->ply_2_color->Lookup->Options) ? $curVal : NULL;
			if ($this->ply_2_color->ViewValue !== NULL) { // Load from cache
				$this->ply_2_color->EditValue = array_values($this->ply_2_color->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->ply_2_color->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1 and `base_color` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->ply_2_color->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->ply_2_color->EditValue = $arwrk;
			}

			// ply_2_qty
			$this->ply_2_qty->EditAttrs["class"] = "form-control";
			$this->ply_2_qty->EditCustomAttributes = "";
			$this->ply_2_qty->EditValue = HtmlEncode($this->ply_2_qty->CurrentValue);
			$this->ply_2_qty->PlaceHolder = RemoveHtml($this->ply_2_qty->caption());
			if (strval($this->ply_2_qty->EditValue) <> "" && is_numeric($this->ply_2_qty->EditValue))
				$this->ply_2_qty->EditValue = FormatNumber($this->ply_2_qty->EditValue, -2, -2, -2, -2);

			// ply_3_color
			$this->ply_3_color->EditAttrs["class"] = "form-control";
			$this->ply_3_color->EditCustomAttributes = "";
			$curVal = trim(strval($this->ply_3_color->CurrentValue));
			if ($curVal <> "")
				$this->ply_3_color->ViewValue = $this->ply_3_color->lookupCacheOption($curVal);
			else
				$this->ply_3_color->ViewValue = $this->ply_3_color->Lookup !== NULL && is_array($this->ply_3_color->Lookup->Options) ? $curVal : NULL;
			if ($this->ply_3_color->ViewValue !== NULL) { // Load from cache
				$this->ply_3_color->EditValue = array_values($this->ply_3_color->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->ply_3_color->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1 and `base_color` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->ply_3_color->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->ply_3_color->EditValue = $arwrk;
			}

			// ply_3_qty
			$this->ply_3_qty->EditAttrs["class"] = "form-control";
			$this->ply_3_qty->EditCustomAttributes = "";
			$this->ply_3_qty->EditValue = HtmlEncode($this->ply_3_qty->CurrentValue);
			$this->ply_3_qty->PlaceHolder = RemoveHtml($this->ply_3_qty->caption());
			if (strval($this->ply_3_qty->EditValue) <> "" && is_numeric($this->ply_3_qty->EditValue))
				$this->ply_3_qty->EditValue = FormatNumber($this->ply_3_qty->EditValue, -2, -2, -2, -2);

			// stock
			$this->stock->EditAttrs["class"] = "form-control";
			$this->stock->EditCustomAttributes = "";
			$this->stock->EditValue = HtmlEncode($this->stock->CurrentValue);
			$this->stock->PlaceHolder = RemoveHtml($this->stock->caption());
			if (strval($this->stock->EditValue) <> "" && is_numeric($this->stock->EditValue))
				$this->stock->EditValue = FormatNumber($this->stock->EditValue, -2, -2, -2, -2);

			// operator
			// datetime
			// moq

			$this->moq->EditAttrs["class"] = "form-control";
			$this->moq->EditCustomAttributes = "";
			$this->moq->EditValue = HtmlEncode($this->moq->CurrentValue);
			$this->moq->PlaceHolder = RemoveHtml($this->moq->caption());
			if (strval($this->moq->EditValue) <> "" && is_numeric($this->moq->EditValue))
				$this->moq->EditValue = FormatNumber($this->moq->EditValue, -2, -2, -2, -2);

			// m_stock
			$this->m_stock->EditAttrs["class"] = "form-control";
			$this->m_stock->EditCustomAttributes = "";
			$this->m_stock->EditValue = HtmlEncode($this->m_stock->CurrentValue);
			$this->m_stock->PlaceHolder = RemoveHtml($this->m_stock->caption());
			if (strval($this->m_stock->EditValue) <> "" && is_numeric($this->m_stock->EditValue))
				$this->m_stock->EditValue = FormatNumber($this->m_stock->EditValue, -2, -2, -2, -2);

			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// yarn
			$this->yarn->LinkCustomAttributes = "";
			$this->yarn->HrefValue = "";

			// ply_1_color
			$this->ply_1_color->LinkCustomAttributes = "";
			$this->ply_1_color->HrefValue = "";

			// ply_1_qty
			$this->ply_1_qty->LinkCustomAttributes = "";
			$this->ply_1_qty->HrefValue = "";

			// ply_2_color
			$this->ply_2_color->LinkCustomAttributes = "";
			$this->ply_2_color->HrefValue = "";

			// ply_2_qty
			$this->ply_2_qty->LinkCustomAttributes = "";
			$this->ply_2_qty->HrefValue = "";

			// ply_3_color
			$this->ply_3_color->LinkCustomAttributes = "";
			$this->ply_3_color->HrefValue = "";

			// ply_3_qty
			$this->ply_3_qty->LinkCustomAttributes = "";
			$this->ply_3_qty->HrefValue = "";

			// stock
			$this->stock->LinkCustomAttributes = "";
			$this->stock->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";

			// moq
			$this->moq->LinkCustomAttributes = "";
			$this->moq->HrefValue = "";

			// m_stock
			$this->m_stock->LinkCustomAttributes = "";
			$this->m_stock->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->yarn->Required) {
			if (!$this->yarn->IsDetailKey && $this->yarn->FormValue != NULL && $this->yarn->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->yarn->caption(), $this->yarn->RequiredErrorMessage));
			}
		}
		if ($this->ply_1_color->Required) {
			if (!$this->ply_1_color->IsDetailKey && $this->ply_1_color->FormValue != NULL && $this->ply_1_color->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ply_1_color->caption(), $this->ply_1_color->RequiredErrorMessage));
			}
		}
		if ($this->ply_1_qty->Required) {
			if (!$this->ply_1_qty->IsDetailKey && $this->ply_1_qty->FormValue != NULL && $this->ply_1_qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ply_1_qty->caption(), $this->ply_1_qty->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->ply_1_qty->FormValue)) {
			AddMessage($FormError, $this->ply_1_qty->errorMessage());
		}
		if ($this->ply_2_color->Required) {
			if (!$this->ply_2_color->IsDetailKey && $this->ply_2_color->FormValue != NULL && $this->ply_2_color->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ply_2_color->caption(), $this->ply_2_color->RequiredErrorMessage));
			}
		}
		if ($this->ply_2_qty->Required) {
			if (!$this->ply_2_qty->IsDetailKey && $this->ply_2_qty->FormValue != NULL && $this->ply_2_qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ply_2_qty->caption(), $this->ply_2_qty->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->ply_2_qty->FormValue)) {
			AddMessage($FormError, $this->ply_2_qty->errorMessage());
		}
		if ($this->ply_3_color->Required) {
			if (!$this->ply_3_color->IsDetailKey && $this->ply_3_color->FormValue != NULL && $this->ply_3_color->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ply_3_color->caption(), $this->ply_3_color->RequiredErrorMessage));
			}
		}
		if ($this->ply_3_qty->Required) {
			if (!$this->ply_3_qty->IsDetailKey && $this->ply_3_qty->FormValue != NULL && $this->ply_3_qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ply_3_qty->caption(), $this->ply_3_qty->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->ply_3_qty->FormValue)) {
			AddMessage($FormError, $this->ply_3_qty->errorMessage());
		}
		if ($this->stock->Required) {
			if (!$this->stock->IsDetailKey && $this->stock->FormValue != NULL && $this->stock->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->stock->caption(), $this->stock->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->stock->FormValue)) {
			AddMessage($FormError, $this->stock->errorMessage());
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->moq->Required) {
			if (!$this->moq->IsDetailKey && $this->moq->FormValue != NULL && $this->moq->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->moq->caption(), $this->moq->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->moq->FormValue)) {
			AddMessage($FormError, $this->moq->errorMessage());
		}
		if ($this->m_stock->Required) {
			if (!$this->m_stock->IsDetailKey && $this->m_stock->FormValue != NULL && $this->m_stock->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_stock->caption(), $this->m_stock->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_stock->FormValue)) {
			AddMessage($FormError, $this->m_stock->errorMessage());
		}
		if ($this->required->Required) {
			if (!$this->required->IsDetailKey && $this->required->FormValue != NULL && $this->required->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->required->caption(), $this->required->RequiredErrorMessage));
			}
		}
		if ($this->ordered->Required) {
			if (!$this->ordered->IsDetailKey && $this->ordered->FormValue != NULL && $this->ordered->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ordered->caption(), $this->ordered->RequiredErrorMessage));
			}
		}
		if ($this->pending_order->Required) {
			if (!$this->pending_order->IsDetailKey && $this->pending_order->FormValue != NULL && $this->pending_order->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pending_order->caption(), $this->pending_order->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// yarn
			$this->yarn->setDbValueDef($rsnew, $this->yarn->CurrentValue, NULL, $this->yarn->ReadOnly);

			// ply_1_color
			$this->ply_1_color->setDbValueDef($rsnew, $this->ply_1_color->CurrentValue, NULL, $this->ply_1_color->ReadOnly);

			// ply_1_qty
			$this->ply_1_qty->setDbValueDef($rsnew, $this->ply_1_qty->CurrentValue, NULL, $this->ply_1_qty->ReadOnly);

			// ply_2_color
			$this->ply_2_color->setDbValueDef($rsnew, $this->ply_2_color->CurrentValue, NULL, $this->ply_2_color->ReadOnly);

			// ply_2_qty
			$this->ply_2_qty->setDbValueDef($rsnew, $this->ply_2_qty->CurrentValue, NULL, $this->ply_2_qty->ReadOnly);

			// ply_3_color
			$this->ply_3_color->setDbValueDef($rsnew, $this->ply_3_color->CurrentValue, NULL, $this->ply_3_color->ReadOnly);

			// ply_3_qty
			$this->ply_3_qty->setDbValueDef($rsnew, $this->ply_3_qty->CurrentValue, NULL, $this->ply_3_qty->ReadOnly);

			// stock
			$this->stock->setDbValueDef($rsnew, $this->stock->CurrentValue, 0, $this->stock->ReadOnly);

			// operator
			$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['operator'] = &$this->operator->DbValue;

			// datetime
			$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
			$rsnew['datetime'] = &$this->datetime->DbValue;

			// moq
			$this->moq->setDbValueDef($rsnew, $this->moq->CurrentValue, 0, $this->moq->ReadOnly);

			// m_stock
			$this->m_stock->setDbValueDef($rsnew, $this->m_stock->CurrentValue, 0, $this->m_stock->ReadOnly);

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("ww_yarnlist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_yarn":
					$lookupFilter = function() {
						return "`s_grp`= 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_ply_1_color":
					$lookupFilter = function() {
						return "`status`=1 and `base_color` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_ply_2_color":
					$lookupFilter = function() {
						return "`status`=1 and `base_color` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_ply_3_color":
					$lookupFilter = function() {
						return "`status`=1 and `base_color` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_yarn":
							break;
						case "x_ply_1_color":
							break;
						case "x_ply_2_color":
							break;
						case "x_ply_3_color":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>