<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$client_category_add = new client_category_add();

// Run the page
$client_category_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$client_category_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fclient_categoryadd = currentForm = new ew.Form("fclient_categoryadd", "add");

// Validate form
fclient_categoryadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($client_category_add->category->Required) { ?>
			elm = this.getElements("x" + infix + "_category");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_category->category->caption(), $client_category->category->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_category_add->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_category->grp->caption(), $client_category->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_category_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_category->status->caption(), $client_category->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_category_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_category->operator->caption(), $client_category->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_category_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_category->datetime->caption(), $client_category->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fclient_categoryadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fclient_categoryadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fclient_categoryadd.lists["x_grp"] = <?php echo $client_category_add->grp->Lookup->toClientList() ?>;
fclient_categoryadd.lists["x_grp"].options = <?php echo JsonEncode($client_category_add->grp->lookupOptions()) ?>;
fclient_categoryadd.lists["x_status"] = <?php echo $client_category_add->status->Lookup->toClientList() ?>;
fclient_categoryadd.lists["x_status"].options = <?php echo JsonEncode($client_category_add->status->options(FALSE, TRUE)) ?>;
fclient_categoryadd.lists["x_operator"] = <?php echo $client_category_add->operator->Lookup->toClientList() ?>;
fclient_categoryadd.lists["x_operator"].options = <?php echo JsonEncode($client_category_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $client_category_add->showPageHeader(); ?>
<?php
$client_category_add->showMessage();
?>
<form name="fclient_categoryadd" id="fclient_categoryadd" class="<?php echo $client_category_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($client_category_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $client_category_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="client_category">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$client_category_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($client_category->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label id="elh_client_category_category" for="x_category" class="<?php echo $client_category_add->LeftColumnClass ?>"><?php echo $client_category->category->caption() ?><?php echo ($client_category->category->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_category_add->RightColumnClass ?>"><div<?php echo $client_category->category->cellAttributes() ?>>
<span id="el_client_category_category">
<input type="text" data-table="client_category" data-field="x_category" name="x_category" id="x_category" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($client_category->category->getPlaceHolder()) ?>" value="<?php echo $client_category->category->EditValue ?>"<?php echo $client_category->category->editAttributes() ?>>
</span>
<?php echo $client_category->category->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_category->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_client_category_grp" for="x_grp" class="<?php echo $client_category_add->LeftColumnClass ?>"><?php echo $client_category->grp->caption() ?><?php echo ($client_category->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_category_add->RightColumnClass ?>"><div<?php echo $client_category->grp->cellAttributes() ?>>
<span id="el_client_category_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="client_category" data-field="x_grp" data-value-separator="<?php echo $client_category->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $client_category->grp->editAttributes() ?>>
		<?php echo $client_category->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $client_category->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $client_category->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_category->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_client_category_status" for="x_status" class="<?php echo $client_category_add->LeftColumnClass ?>"><?php echo $client_category->status->caption() ?><?php echo ($client_category->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_category_add->RightColumnClass ?>"><div<?php echo $client_category->status->cellAttributes() ?>>
<span id="el_client_category_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="client_category" data-field="x_status" data-value-separator="<?php echo $client_category->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $client_category->status->editAttributes() ?>>
		<?php echo $client_category->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $client_category->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$client_category_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $client_category_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $client_category_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$client_category_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$client_category_add->terminate();
?>