<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$client_category_addopt = new client_category_addopt();

// Run the page
$client_category_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$client_category_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fclient_categoryaddopt = currentForm = new ew.Form("fclient_categoryaddopt", "addopt");

// Validate form
fclient_categoryaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($client_category_addopt->category->Required) { ?>
			elm = this.getElements("x" + infix + "_category");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_category->category->caption(), $client_category->category->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_category_addopt->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_category->grp->caption(), $client_category->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_category_addopt->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_category->status->caption(), $client_category->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_category_addopt->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_category->operator->caption(), $client_category->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_category_addopt->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_category->datetime->caption(), $client_category->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fclient_categoryaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fclient_categoryaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fclient_categoryaddopt.lists["x_grp"] = <?php echo $client_category_addopt->grp->Lookup->toClientList() ?>;
fclient_categoryaddopt.lists["x_grp"].options = <?php echo JsonEncode($client_category_addopt->grp->lookupOptions()) ?>;
fclient_categoryaddopt.lists["x_status"] = <?php echo $client_category_addopt->status->Lookup->toClientList() ?>;
fclient_categoryaddopt.lists["x_status"].options = <?php echo JsonEncode($client_category_addopt->status->options(FALSE, TRUE)) ?>;
fclient_categoryaddopt.lists["x_operator"] = <?php echo $client_category_addopt->operator->Lookup->toClientList() ?>;
fclient_categoryaddopt.lists["x_operator"].options = <?php echo JsonEncode($client_category_addopt->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $client_category_addopt->showPageHeader(); ?>
<?php
$client_category_addopt->showMessage();
?>
<form name="fclient_categoryaddopt" id="fclient_categoryaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($client_category_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $client_category_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $client_category_addopt->TableVar ?>">
<?php if ($client_category->category->Visible) { // category ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_category"><?php echo $client_category->category->caption() ?><?php echo ($client_category->category->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="client_category" data-field="x_category" name="x_category" id="x_category" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($client_category->category->getPlaceHolder()) ?>" value="<?php echo $client_category->category->EditValue ?>"<?php echo $client_category->category->editAttributes() ?>>
<?php echo $client_category->category->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_category->grp->Visible) { // grp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_grp"><?php echo $client_category->grp->caption() ?><?php echo ($client_category->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="client_category" data-field="x_grp" data-value-separator="<?php echo $client_category->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $client_category->grp->editAttributes() ?>>
		<?php echo $client_category->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $client_category->grp->Lookup->getParamTag("p_x_grp") ?>
<?php echo $client_category->grp->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_category->status->Visible) { // status ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_status"><?php echo $client_category->status->caption() ?><?php echo ($client_category->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="client_category" data-field="x_status" data-value-separator="<?php echo $client_category->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $client_category->status->editAttributes() ?>>
		<?php echo $client_category->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $client_category->status->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_category->operator->Visible) { // operator ?>
	<input type="hidden" data-table="client_category" data-field="x_operator" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($client_category->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($client_category->datetime->Visible) { // datetime ?>
	<input type="hidden" data-table="client_category" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($client_category->datetime->CurrentValue) ?>">
	<?php if (!$client_category->datetime->ReadOnly && !$client_category->datetime->Disabled && !isset($client_category->datetime->EditAttrs["readonly"]) && !isset($client_category->datetime->EditAttrs["disabled"])) { ?>
	<script>
	ew.createDateTimePicker("fclient_categoryaddopt", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
	</script>
	<?php } ?>
<?php } ?>
</form>
<?php
$client_category_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$client_category_addopt->terminate();
?>