<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$client_category_edit = new client_category_edit();

// Run the page
$client_category_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$client_category_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fclient_categoryedit = currentForm = new ew.Form("fclient_categoryedit", "edit");

// Validate form
fclient_categoryedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($client_category_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_category->id->caption(), $client_category->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_category_edit->category->Required) { ?>
			elm = this.getElements("x" + infix + "_category");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_category->category->caption(), $client_category->category->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_category_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_category->grp->caption(), $client_category->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_category_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_category->status->caption(), $client_category->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_category_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_category->operator->caption(), $client_category->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_category_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_category->datetime->caption(), $client_category->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fclient_categoryedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fclient_categoryedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fclient_categoryedit.lists["x_grp"] = <?php echo $client_category_edit->grp->Lookup->toClientList() ?>;
fclient_categoryedit.lists["x_grp"].options = <?php echo JsonEncode($client_category_edit->grp->lookupOptions()) ?>;
fclient_categoryedit.lists["x_status"] = <?php echo $client_category_edit->status->Lookup->toClientList() ?>;
fclient_categoryedit.lists["x_status"].options = <?php echo JsonEncode($client_category_edit->status->options(FALSE, TRUE)) ?>;
fclient_categoryedit.lists["x_operator"] = <?php echo $client_category_edit->operator->Lookup->toClientList() ?>;
fclient_categoryedit.lists["x_operator"].options = <?php echo JsonEncode($client_category_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $client_category_edit->showPageHeader(); ?>
<?php
$client_category_edit->showMessage();
?>
<form name="fclient_categoryedit" id="fclient_categoryedit" class="<?php echo $client_category_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($client_category_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $client_category_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="client_category">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$client_category_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($client_category->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_client_category_id" class="<?php echo $client_category_edit->LeftColumnClass ?>"><?php echo $client_category->id->caption() ?><?php echo ($client_category->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_category_edit->RightColumnClass ?>"><div<?php echo $client_category->id->cellAttributes() ?>>
<span id="el_client_category_id">
<span<?php echo $client_category->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($client_category->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="client_category" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($client_category->id->CurrentValue) ?>">
<?php echo $client_category->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_category->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label id="elh_client_category_category" for="x_category" class="<?php echo $client_category_edit->LeftColumnClass ?>"><?php echo $client_category->category->caption() ?><?php echo ($client_category->category->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_category_edit->RightColumnClass ?>"><div<?php echo $client_category->category->cellAttributes() ?>>
<span id="el_client_category_category">
<input type="text" data-table="client_category" data-field="x_category" name="x_category" id="x_category" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($client_category->category->getPlaceHolder()) ?>" value="<?php echo $client_category->category->EditValue ?>"<?php echo $client_category->category->editAttributes() ?>>
</span>
<?php echo $client_category->category->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_category->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_client_category_grp" for="x_grp" class="<?php echo $client_category_edit->LeftColumnClass ?>"><?php echo $client_category->grp->caption() ?><?php echo ($client_category->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_category_edit->RightColumnClass ?>"><div<?php echo $client_category->grp->cellAttributes() ?>>
<span id="el_client_category_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="client_category" data-field="x_grp" data-value-separator="<?php echo $client_category->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $client_category->grp->editAttributes() ?>>
		<?php echo $client_category->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $client_category->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $client_category->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_category->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_client_category_status" for="x_status" class="<?php echo $client_category_edit->LeftColumnClass ?>"><?php echo $client_category->status->caption() ?><?php echo ($client_category->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_category_edit->RightColumnClass ?>"><div<?php echo $client_category->status->cellAttributes() ?>>
<span id="el_client_category_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="client_category" data-field="x_status" data-value-separator="<?php echo $client_category->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $client_category->status->editAttributes() ?>>
		<?php echo $client_category->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $client_category->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$client_category_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $client_category_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $client_category_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$client_category_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$client_category_edit->terminate();
?>