<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$client_category_view = new client_category_view();

// Run the page
$client_category_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$client_category_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$client_category->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fclient_categoryview = currentForm = new ew.Form("fclient_categoryview", "view");

// Form_CustomValidate event
fclient_categoryview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fclient_categoryview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fclient_categoryview.lists["x_grp"] = <?php echo $client_category_view->grp->Lookup->toClientList() ?>;
fclient_categoryview.lists["x_grp"].options = <?php echo JsonEncode($client_category_view->grp->lookupOptions()) ?>;
fclient_categoryview.lists["x_status"] = <?php echo $client_category_view->status->Lookup->toClientList() ?>;
fclient_categoryview.lists["x_status"].options = <?php echo JsonEncode($client_category_view->status->options(FALSE, TRUE)) ?>;
fclient_categoryview.lists["x_operator"] = <?php echo $client_category_view->operator->Lookup->toClientList() ?>;
fclient_categoryview.lists["x_operator"].options = <?php echo JsonEncode($client_category_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$client_category->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $client_category_view->ExportOptions->render("body") ?>
<?php $client_category_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $client_category_view->showPageHeader(); ?>
<?php
$client_category_view->showMessage();
?>
<form name="fclient_categoryview" id="fclient_categoryview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($client_category_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $client_category_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="client_category">
<input type="hidden" name="modal" value="<?php echo (int)$client_category_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($client_category->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $client_category_view->TableLeftColumnClass ?>"><span id="elh_client_category_id"><?php echo $client_category->id->caption() ?></span></td>
		<td data-name="id"<?php echo $client_category->id->cellAttributes() ?>>
<span id="el_client_category_id">
<span<?php echo $client_category->id->viewAttributes() ?>>
<?php echo $client_category->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($client_category->category->Visible) { // category ?>
	<tr id="r_category">
		<td class="<?php echo $client_category_view->TableLeftColumnClass ?>"><span id="elh_client_category_category"><?php echo $client_category->category->caption() ?></span></td>
		<td data-name="category"<?php echo $client_category->category->cellAttributes() ?>>
<span id="el_client_category_category">
<span<?php echo $client_category->category->viewAttributes() ?>>
<?php echo $client_category->category->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($client_category->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $client_category_view->TableLeftColumnClass ?>"><span id="elh_client_category_grp"><?php echo $client_category->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $client_category->grp->cellAttributes() ?>>
<span id="el_client_category_grp">
<span<?php echo $client_category->grp->viewAttributes() ?>>
<?php echo $client_category->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($client_category->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $client_category_view->TableLeftColumnClass ?>"><span id="elh_client_category_status"><?php echo $client_category->status->caption() ?></span></td>
		<td data-name="status"<?php echo $client_category->status->cellAttributes() ?>>
<span id="el_client_category_status">
<span<?php echo $client_category->status->viewAttributes() ?>>
<?php echo $client_category->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($client_category->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $client_category_view->TableLeftColumnClass ?>"><span id="elh_client_category_operator"><?php echo $client_category->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $client_category->operator->cellAttributes() ?>>
<span id="el_client_category_operator">
<span<?php echo $client_category->operator->viewAttributes() ?>>
<?php echo $client_category->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($client_category->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $client_category_view->TableLeftColumnClass ?>"><span id="elh_client_category_datetime"><?php echo $client_category->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $client_category->datetime->cellAttributes() ?>>
<span id="el_client_category_datetime">
<span<?php echo $client_category->datetime->viewAttributes() ?>>
<?php echo $client_category->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$client_category_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$client_category->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$client_category_view->terminate();
?>