<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$client_db_add = new client_db_add();

// Run the page
$client_db_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$client_db_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fclient_dbadd = currentForm = new ew.Form("fclient_dbadd", "add");

// Validate form
fclient_dbadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($client_db_add->category->Required) { ?>
			elm = this.getElements("x" + infix + "_category[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_db->category->caption(), $client_db->category->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_db_add->sub_category->Required) { ?>
			elm = this.getElements("x" + infix + "_sub_category[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_db->sub_category->caption(), $client_db->sub_category->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_db_add->lead_type->Required) { ?>
			elm = this.getElements("x" + infix + "_lead_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_db->lead_type->caption(), $client_db->lead_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_db_add->lead_by->Required) { ?>
			elm = this.getElements("x" + infix + "_lead_by");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_db->lead_by->caption(), $client_db->lead_by->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_db_add->city->Required) { ?>
			elm = this.getElements("x" + infix + "_city");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_db->city->caption(), $client_db->city->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_db_add->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_db->name->caption(), $client_db->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_db_add->mobile->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_db->mobile->caption(), $client_db->mobile->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_db_add->_email->Required) { ?>
			elm = this.getElements("x" + infix + "__email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_db->_email->caption(), $client_db->_email->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_db_add->address->Required) { ?>
			elm = this.getElements("x" + infix + "_address");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_db->address->caption(), $client_db->address->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_db_add->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_db->remarks->caption(), $client_db->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_db_add->image->Required) { ?>
			felm = this.getElements("x" + infix + "_image");
			elm = this.getElements("fn_x" + infix + "_image");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $client_db->image->caption(), $client_db->image->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_db_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_db->operator->caption(), $client_db->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_db_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_db->datetime->caption(), $client_db->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fclient_dbadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fclient_dbadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fclient_dbadd.lists["x_category[]"] = <?php echo $client_db_add->category->Lookup->toClientList() ?>;
fclient_dbadd.lists["x_category[]"].options = <?php echo JsonEncode($client_db_add->category->lookupOptions()) ?>;
fclient_dbadd.lists["x_sub_category[]"] = <?php echo $client_db_add->sub_category->Lookup->toClientList() ?>;
fclient_dbadd.lists["x_sub_category[]"].options = <?php echo JsonEncode($client_db_add->sub_category->lookupOptions()) ?>;
fclient_dbadd.lists["x_lead_type"] = <?php echo $client_db_add->lead_type->Lookup->toClientList() ?>;
fclient_dbadd.lists["x_lead_type"].options = <?php echo JsonEncode($client_db_add->lead_type->lookupOptions()) ?>;
fclient_dbadd.lists["x_city"] = <?php echo $client_db_add->city->Lookup->toClientList() ?>;
fclient_dbadd.lists["x_city"].options = <?php echo JsonEncode($client_db_add->city->lookupOptions()) ?>;
fclient_dbadd.autoSuggests["x_city"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fclient_dbadd.lists["x_name"] = <?php echo $client_db_add->name->Lookup->toClientList() ?>;
fclient_dbadd.lists["x_name"].options = <?php echo JsonEncode($client_db_add->name->lookupOptions()) ?>;
fclient_dbadd.autoSuggests["x_name"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fclient_dbadd.lists["x_mobile"] = <?php echo $client_db_add->mobile->Lookup->toClientList() ?>;
fclient_dbadd.lists["x_mobile"].options = <?php echo JsonEncode($client_db_add->mobile->lookupOptions()) ?>;
fclient_dbadd.autoSuggests["x_mobile"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fclient_dbadd.lists["x__email"] = <?php echo $client_db_add->_email->Lookup->toClientList() ?>;
fclient_dbadd.lists["x__email"].options = <?php echo JsonEncode($client_db_add->_email->lookupOptions()) ?>;
fclient_dbadd.autoSuggests["x__email"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fclient_dbadd.lists["x_operator"] = <?php echo $client_db_add->operator->Lookup->toClientList() ?>;
fclient_dbadd.lists["x_operator"].options = <?php echo JsonEncode($client_db_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $client_db_add->showPageHeader(); ?>
<?php
$client_db_add->showMessage();
?>
<form name="fclient_dbadd" id="fclient_dbadd" class="<?php echo $client_db_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($client_db_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $client_db_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="client_db">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$client_db_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($client_db->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label id="elh_client_db_category" class="<?php echo $client_db_add->LeftColumnClass ?>"><?php echo $client_db->category->caption() ?><?php echo ($client_db->category->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_db_add->RightColumnClass ?>"><div<?php echo $client_db->category->cellAttributes() ?>>
<span id="el_client_db_category">
<?php $client_db->category->EditAttrs["onclick"] = "ew.updateOptions.call(this); " . @$client_db->category->EditAttrs["onclick"]; ?>
<div id="tp_x_category" class="ew-template"><input type="checkbox" class="form-check-input" data-table="client_db" data-field="x_category" data-value-separator="<?php echo $client_db->category->displayValueSeparatorAttribute() ?>" name="x_category[]" id="x_category[]" value="{value}"<?php echo $client_db->category->editAttributes() ?>></div>
<div id="dsl_x_category" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $client_db->category->checkBoxListHtml(FALSE, "x_category[]") ?>
</div></div>
<?php echo $client_db->category->Lookup->getParamTag("p_x_category") ?>
<?php if (AllowAdd(CurrentProjectID() . "client_category") && !$client_db->category->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_category" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $client_db->category->caption() ?>" data-title="<?php echo $client_db->category->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_category[]',url:'client_categoryaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</span>
<?php echo $client_db->category->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_db->sub_category->Visible) { // sub_category ?>
	<div id="r_sub_category" class="form-group row">
		<label id="elh_client_db_sub_category" class="<?php echo $client_db_add->LeftColumnClass ?>"><?php echo $client_db->sub_category->caption() ?><?php echo ($client_db->sub_category->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_db_add->RightColumnClass ?>"><div<?php echo $client_db->sub_category->cellAttributes() ?>>
<span id="el_client_db_sub_category">
<div id="tp_x_sub_category" class="ew-template"><input type="checkbox" class="form-check-input" data-table="client_db" data-field="x_sub_category" data-value-separator="<?php echo $client_db->sub_category->displayValueSeparatorAttribute() ?>" name="x_sub_category[]" id="x_sub_category[]" value="{value}"<?php echo $client_db->sub_category->editAttributes() ?>></div>
<div id="dsl_x_sub_category" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $client_db->sub_category->checkBoxListHtml(FALSE, "x_sub_category[]") ?>
</div></div>
<?php echo $client_db->sub_category->Lookup->getParamTag("p_x_sub_category") ?>
<?php if (AllowAdd(CurrentProjectID() . "client_category") && !$client_db->sub_category->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_sub_category" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $client_db->sub_category->caption() ?>" data-title="<?php echo $client_db->sub_category->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_sub_category[]',url:'client_categoryaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</span>
<?php echo $client_db->sub_category->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_db->lead_type->Visible) { // lead_type ?>
	<div id="r_lead_type" class="form-group row">
		<label id="elh_client_db_lead_type" class="<?php echo $client_db_add->LeftColumnClass ?>"><?php echo $client_db->lead_type->caption() ?><?php echo ($client_db->lead_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_db_add->RightColumnClass ?>"><div<?php echo $client_db->lead_type->cellAttributes() ?>>
<span id="el_client_db_lead_type">
<div id="tp_x_lead_type" class="ew-template"><input type="radio" class="form-check-input" data-table="client_db" data-field="x_lead_type" data-value-separator="<?php echo $client_db->lead_type->displayValueSeparatorAttribute() ?>" name="x_lead_type" id="x_lead_type" value="{value}"<?php echo $client_db->lead_type->editAttributes() ?>></div>
<div id="dsl_x_lead_type" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $client_db->lead_type->radioButtonListHtml(FALSE, "x_lead_type") ?>
</div></div>
<?php echo $client_db->lead_type->Lookup->getParamTag("p_x_lead_type") ?>
</span>
<?php echo $client_db->lead_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_db->lead_by->Visible) { // lead_by ?>
	<div id="r_lead_by" class="form-group row">
		<label id="elh_client_db_lead_by" for="x_lead_by" class="<?php echo $client_db_add->LeftColumnClass ?>"><?php echo $client_db->lead_by->caption() ?><?php echo ($client_db->lead_by->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_db_add->RightColumnClass ?>"><div<?php echo $client_db->lead_by->cellAttributes() ?>>
<span id="el_client_db_lead_by">
<input type="text" data-table="client_db" data-field="x_lead_by" name="x_lead_by" id="x_lead_by" size="30" maxlength="92" placeholder="<?php echo HtmlEncode($client_db->lead_by->getPlaceHolder()) ?>" value="<?php echo $client_db->lead_by->EditValue ?>"<?php echo $client_db->lead_by->editAttributes() ?>>
</span>
<?php echo $client_db->lead_by->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_db->city->Visible) { // city ?>
	<div id="r_city" class="form-group row">
		<label id="elh_client_db_city" class="<?php echo $client_db_add->LeftColumnClass ?>"><?php echo $client_db->city->caption() ?><?php echo ($client_db->city->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_db_add->RightColumnClass ?>"><div<?php echo $client_db->city->cellAttributes() ?>>
<span id="el_client_db_city">
<?php
$wrkonchange = "" . trim(@$client_db->city->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$client_db->city->EditAttrs["onchange"] = "";
?>
<span id="as_x_city" class="text-nowrap" style="z-index: 8940">
	<input type="text" class="form-control" name="sv_x_city" id="sv_x_city" value="<?php echo RemoveHtml($client_db->city->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($client_db->city->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($client_db->city->getPlaceHolder()) ?>"<?php echo $client_db->city->editAttributes() ?>>
</span>
<input type="hidden" data-table="client_db" data-field="x_city" data-value-separator="<?php echo $client_db->city->displayValueSeparatorAttribute() ?>" name="x_city" id="x_city" value="<?php echo HtmlEncode($client_db->city->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fclient_dbadd.createAutoSuggest({"id":"x_city","forceSelect":false});
</script>
<?php echo $client_db->city->Lookup->getParamTag("p_x_city") ?>
</span>
<?php echo $client_db->city->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_db->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label id="elh_client_db_name" class="<?php echo $client_db_add->LeftColumnClass ?>"><?php echo $client_db->name->caption() ?><?php echo ($client_db->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_db_add->RightColumnClass ?>"><div<?php echo $client_db->name->cellAttributes() ?>>
<span id="el_client_db_name">
<?php
$wrkonchange = "" . trim(@$client_db->name->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$client_db->name->EditAttrs["onchange"] = "";
?>
<span id="as_x_name" class="text-nowrap" style="z-index: 8930">
	<input type="text" class="form-control" name="sv_x_name" id="sv_x_name" value="<?php echo RemoveHtml($client_db->name->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($client_db->name->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($client_db->name->getPlaceHolder()) ?>"<?php echo $client_db->name->editAttributes() ?>>
</span>
<input type="hidden" data-table="client_db" data-field="x_name" data-value-separator="<?php echo $client_db->name->displayValueSeparatorAttribute() ?>" name="x_name" id="x_name" value="<?php echo HtmlEncode($client_db->name->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fclient_dbadd.createAutoSuggest({"id":"x_name","forceSelect":false});
</script>
<?php echo $client_db->name->Lookup->getParamTag("p_x_name") ?>
</span>
<?php echo $client_db->name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_db->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label id="elh_client_db_mobile" class="<?php echo $client_db_add->LeftColumnClass ?>"><?php echo $client_db->mobile->caption() ?><?php echo ($client_db->mobile->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_db_add->RightColumnClass ?>"><div<?php echo $client_db->mobile->cellAttributes() ?>>
<span id="el_client_db_mobile">
<?php
$wrkonchange = "" . trim(@$client_db->mobile->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$client_db->mobile->EditAttrs["onchange"] = "";
?>
<span id="as_x_mobile" class="text-nowrap" style="z-index: 8920">
	<input type="text" class="form-control" name="sv_x_mobile" id="sv_x_mobile" value="<?php echo RemoveHtml($client_db->mobile->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($client_db->mobile->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($client_db->mobile->getPlaceHolder()) ?>"<?php echo $client_db->mobile->editAttributes() ?>>
</span>
<input type="hidden" data-table="client_db" data-field="x_mobile" data-value-separator="<?php echo $client_db->mobile->displayValueSeparatorAttribute() ?>" name="x_mobile" id="x_mobile" value="<?php echo HtmlEncode($client_db->mobile->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fclient_dbadd.createAutoSuggest({"id":"x_mobile","forceSelect":false});
</script>
<?php echo $client_db->mobile->Lookup->getParamTag("p_x_mobile") ?>
</span>
<?php echo $client_db->mobile->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_db->_email->Visible) { // email ?>
	<div id="r__email" class="form-group row">
		<label id="elh_client_db__email" class="<?php echo $client_db_add->LeftColumnClass ?>"><?php echo $client_db->_email->caption() ?><?php echo ($client_db->_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_db_add->RightColumnClass ?>"><div<?php echo $client_db->_email->cellAttributes() ?>>
<span id="el_client_db__email">
<?php
$wrkonchange = "" . trim(@$client_db->_email->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$client_db->_email->EditAttrs["onchange"] = "";
?>
<span id="as_x__email" class="text-nowrap" style="z-index: 8910">
	<input type="text" class="form-control" name="sv_x__email" id="sv_x__email" value="<?php echo RemoveHtml($client_db->_email->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($client_db->_email->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($client_db->_email->getPlaceHolder()) ?>"<?php echo $client_db->_email->editAttributes() ?>>
</span>
<input type="hidden" data-table="client_db" data-field="x__email" data-value-separator="<?php echo $client_db->_email->displayValueSeparatorAttribute() ?>" name="x__email" id="x__email" value="<?php echo HtmlEncode($client_db->_email->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fclient_dbadd.createAutoSuggest({"id":"x__email","forceSelect":false});
</script>
<?php echo $client_db->_email->Lookup->getParamTag("p_x__email") ?>
</span>
<?php echo $client_db->_email->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_db->address->Visible) { // address ?>
	<div id="r_address" class="form-group row">
		<label id="elh_client_db_address" for="x_address" class="<?php echo $client_db_add->LeftColumnClass ?>"><?php echo $client_db->address->caption() ?><?php echo ($client_db->address->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_db_add->RightColumnClass ?>"><div<?php echo $client_db->address->cellAttributes() ?>>
<span id="el_client_db_address">
<textarea data-table="client_db" data-field="x_address" name="x_address" id="x_address" cols="35" rows="4" placeholder="<?php echo HtmlEncode($client_db->address->getPlaceHolder()) ?>"<?php echo $client_db->address->editAttributes() ?>><?php echo $client_db->address->EditValue ?></textarea>
</span>
<?php echo $client_db->address->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_db->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_client_db_remarks" for="x_remarks" class="<?php echo $client_db_add->LeftColumnClass ?>"><?php echo $client_db->remarks->caption() ?><?php echo ($client_db->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_db_add->RightColumnClass ?>"><div<?php echo $client_db->remarks->cellAttributes() ?>>
<span id="el_client_db_remarks">
<textarea data-table="client_db" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="35" rows="4" placeholder="<?php echo HtmlEncode($client_db->remarks->getPlaceHolder()) ?>"<?php echo $client_db->remarks->editAttributes() ?>><?php echo $client_db->remarks->EditValue ?></textarea>
</span>
<?php echo $client_db->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_db->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label id="elh_client_db_image" class="<?php echo $client_db_add->LeftColumnClass ?>"><?php echo $client_db->image->caption() ?><?php echo ($client_db->image->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_db_add->RightColumnClass ?>"><div<?php echo $client_db->image->cellAttributes() ?>>
<span id="el_client_db_image">
<div id="fd_x_image">
<span title="<?php echo $client_db->image->title() ? $client_db->image->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($client_db->image->ReadOnly || $client_db->image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="client_db" data-field="x_image" name="x_image" id="x_image"<?php echo $client_db->image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?php echo $client_db->image->Upload->FileName ?>">
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="0">
<input type="hidden" name="fs_x_image" id= "fs_x_image" value="500">
<input type="hidden" name="fx_x_image" id= "fx_x_image" value="<?php echo $client_db->image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_image" id= "fm_x_image" value="<?php echo $client_db->image->UploadMaxFileSize ?>">
</div>
<table id="ft_x_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $client_db->image->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$client_db_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $client_db_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $client_db_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$client_db_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$client_db_add->terminate();
?>