<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$client_db_list = new client_db_list();

// Run the page
$client_db_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$client_db_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$client_db->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fclient_dblist = currentForm = new ew.Form("fclient_dblist", "list");
fclient_dblist.formKeyCountName = '<?php echo $client_db_list->FormKeyCountName ?>';

// Form_CustomValidate event
fclient_dblist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fclient_dblist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fclient_dblist.lists["x_category[]"] = <?php echo $client_db_list->category->Lookup->toClientList() ?>;
fclient_dblist.lists["x_category[]"].options = <?php echo JsonEncode($client_db_list->category->lookupOptions()) ?>;
fclient_dblist.lists["x_sub_category[]"] = <?php echo $client_db_list->sub_category->Lookup->toClientList() ?>;
fclient_dblist.lists["x_sub_category[]"].options = <?php echo JsonEncode($client_db_list->sub_category->lookupOptions()) ?>;
fclient_dblist.lists["x_lead_type"] = <?php echo $client_db_list->lead_type->Lookup->toClientList() ?>;
fclient_dblist.lists["x_lead_type"].options = <?php echo JsonEncode($client_db_list->lead_type->lookupOptions()) ?>;
fclient_dblist.lists["x_city"] = <?php echo $client_db_list->city->Lookup->toClientList() ?>;
fclient_dblist.lists["x_city"].options = <?php echo JsonEncode($client_db_list->city->lookupOptions()) ?>;
fclient_dblist.autoSuggests["x_city"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fclient_dblist.lists["x_name"] = <?php echo $client_db_list->name->Lookup->toClientList() ?>;
fclient_dblist.lists["x_name"].options = <?php echo JsonEncode($client_db_list->name->lookupOptions()) ?>;
fclient_dblist.autoSuggests["x_name"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fclient_dblist.lists["x_mobile"] = <?php echo $client_db_list->mobile->Lookup->toClientList() ?>;
fclient_dblist.lists["x_mobile"].options = <?php echo JsonEncode($client_db_list->mobile->lookupOptions()) ?>;
fclient_dblist.autoSuggests["x_mobile"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fclient_dblist.lists["x__email"] = <?php echo $client_db_list->_email->Lookup->toClientList() ?>;
fclient_dblist.lists["x__email"].options = <?php echo JsonEncode($client_db_list->_email->lookupOptions()) ?>;
fclient_dblist.autoSuggests["x__email"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fclient_dblist.lists["x_operator"] = <?php echo $client_db_list->operator->Lookup->toClientList() ?>;
fclient_dblist.lists["x_operator"].options = <?php echo JsonEncode($client_db_list->operator->lookupOptions()) ?>;

// Form object for search
var fclient_dblistsrch = currentSearchForm = new ew.Form("fclient_dblistsrch");

// Validate function for search
fclient_dblistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fclient_dblistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fclient_dblistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fclient_dblistsrch.lists["x_category[]"] = <?php echo $client_db_list->category->Lookup->toClientList() ?>;
fclient_dblistsrch.lists["x_category[]"].options = <?php echo JsonEncode($client_db_list->category->lookupOptions()) ?>;
fclient_dblistsrch.lists["x_sub_category[]"] = <?php echo $client_db_list->sub_category->Lookup->toClientList() ?>;
fclient_dblistsrch.lists["x_sub_category[]"].options = <?php echo JsonEncode($client_db_list->sub_category->lookupOptions()) ?>;

// Filters
fclient_dblistsrch.filterList = <?php echo $client_db_list->getFilterList() ?>;

// Init search panel as collapsed
fclient_dblistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$client_db->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($client_db_list->TotalRecs > 0 && $client_db_list->ExportOptions->visible()) { ?>
<?php $client_db_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($client_db_list->ImportOptions->visible()) { ?>
<?php $client_db_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($client_db_list->SearchOptions->visible()) { ?>
<?php $client_db_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($client_db_list->FilterOptions->visible()) { ?>
<?php $client_db_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$client_db_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$client_db->isExport() && !$client_db->CurrentAction) { ?>
<form name="fclient_dblistsrch" id="fclient_dblistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($client_db_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fclient_dblistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="client_db">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$client_db_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$client_db->RowType = ROWTYPE_SEARCH;

// Render row
$client_db->resetAttributes();
$client_db_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($client_db->category->Visible) { // category ?>
	<div id="xsc_category" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $client_db->category->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_category" id="z_category" value="LIKE"></span>
		<span class="ew-search-field">
<?php $client_db->category->EditAttrs["onclick"] = "ew.updateOptions.call(this); " . @$client_db->category->EditAttrs["onclick"]; ?>
<div id="tp_x_category" class="ew-template"><input type="checkbox" class="form-check-input" data-table="client_db" data-field="x_category" data-value-separator="<?php echo $client_db->category->displayValueSeparatorAttribute() ?>" name="x_category[]" id="x_category[]" value="{value}"<?php echo $client_db->category->editAttributes() ?>></div>
<div id="dsl_x_category" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $client_db->category->checkBoxListHtml(FALSE, "x_category[]") ?>
</div></div>
<?php echo $client_db->category->Lookup->getParamTag("p_x_category") ?>
</span>
	</div>
<?php } ?>
<?php if ($client_db->sub_category->Visible) { // sub_category ?>
	<div id="xsc_sub_category" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $client_db->sub_category->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_sub_category" id="z_sub_category" value="LIKE"></span>
		<span class="ew-search-field">
<div id="tp_x_sub_category" class="ew-template"><input type="checkbox" class="form-check-input" data-table="client_db" data-field="x_sub_category" data-value-separator="<?php echo $client_db->sub_category->displayValueSeparatorAttribute() ?>" name="x_sub_category[]" id="x_sub_category[]" value="{value}"<?php echo $client_db->sub_category->editAttributes() ?>></div>
<div id="dsl_x_sub_category" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $client_db->sub_category->checkBoxListHtml(FALSE, "x_sub_category[]") ?>
</div></div>
<?php echo $client_db->sub_category->Lookup->getParamTag("p_x_sub_category") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($client_db_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($client_db_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $client_db_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($client_db_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($client_db_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($client_db_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($client_db_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $client_db_list->showPageHeader(); ?>
<?php
$client_db_list->showMessage();
?>
<?php if ($client_db_list->TotalRecs > 0 || $client_db->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($client_db_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> client_db">
<?php if (!$client_db->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$client_db->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($client_db_list->Pager)) $client_db_list->Pager = new PrevNextPager($client_db_list->StartRec, $client_db_list->DisplayRecs, $client_db_list->TotalRecs, $client_db_list->AutoHidePager) ?>
<?php if ($client_db_list->Pager->RecordCount > 0 && $client_db_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($client_db_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $client_db_list->pageUrl() ?>start=<?php echo $client_db_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($client_db_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $client_db_list->pageUrl() ?>start=<?php echo $client_db_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $client_db_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($client_db_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $client_db_list->pageUrl() ?>start=<?php echo $client_db_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($client_db_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $client_db_list->pageUrl() ?>start=<?php echo $client_db_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $client_db_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($client_db_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $client_db_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $client_db_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $client_db_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($client_db_list->TotalRecs > 0 && (!$client_db_list->AutoHidePageSizeSelector || $client_db_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="client_db">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($client_db_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($client_db_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($client_db_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($client_db_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($client_db_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($client_db->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $client_db_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fclient_dblist" id="fclient_dblist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($client_db_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $client_db_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="client_db">
<div id="gmp_client_db" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($client_db_list->TotalRecs > 0 || $client_db->isGridEdit()) { ?>
<table id="tbl_client_dblist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$client_db_list->RowType = ROWTYPE_HEADER;

// Render list options
$client_db_list->renderListOptions();

// Render list options (header, left)
$client_db_list->ListOptions->render("header", "left");
?>
<?php if ($client_db->id->Visible) { // id ?>
	<?php if ($client_db->sortUrl($client_db->id) == "") { ?>
		<th data-name="id" class="<?php echo $client_db->id->headerCellClass() ?>"><div id="elh_client_db_id" class="client_db_id"><div class="ew-table-header-caption"><?php echo $client_db->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $client_db->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $client_db->SortUrl($client_db->id) ?>',2);"><div id="elh_client_db_id" class="client_db_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $client_db->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($client_db->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($client_db->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($client_db->category->Visible) { // category ?>
	<?php if ($client_db->sortUrl($client_db->category) == "") { ?>
		<th data-name="category" class="<?php echo $client_db->category->headerCellClass() ?>"><div id="elh_client_db_category" class="client_db_category"><div class="ew-table-header-caption"><?php echo $client_db->category->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="category" class="<?php echo $client_db->category->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $client_db->SortUrl($client_db->category) ?>',2);"><div id="elh_client_db_category" class="client_db_category">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $client_db->category->caption() ?></span><span class="ew-table-header-sort"><?php if ($client_db->category->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($client_db->category->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($client_db->sub_category->Visible) { // sub_category ?>
	<?php if ($client_db->sortUrl($client_db->sub_category) == "") { ?>
		<th data-name="sub_category" class="<?php echo $client_db->sub_category->headerCellClass() ?>"><div id="elh_client_db_sub_category" class="client_db_sub_category"><div class="ew-table-header-caption"><?php echo $client_db->sub_category->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sub_category" class="<?php echo $client_db->sub_category->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $client_db->SortUrl($client_db->sub_category) ?>',2);"><div id="elh_client_db_sub_category" class="client_db_sub_category">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $client_db->sub_category->caption() ?></span><span class="ew-table-header-sort"><?php if ($client_db->sub_category->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($client_db->sub_category->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($client_db->lead_type->Visible) { // lead_type ?>
	<?php if ($client_db->sortUrl($client_db->lead_type) == "") { ?>
		<th data-name="lead_type" class="<?php echo $client_db->lead_type->headerCellClass() ?>"><div id="elh_client_db_lead_type" class="client_db_lead_type"><div class="ew-table-header-caption"><?php echo $client_db->lead_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lead_type" class="<?php echo $client_db->lead_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $client_db->SortUrl($client_db->lead_type) ?>',2);"><div id="elh_client_db_lead_type" class="client_db_lead_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $client_db->lead_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($client_db->lead_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($client_db->lead_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($client_db->lead_by->Visible) { // lead_by ?>
	<?php if ($client_db->sortUrl($client_db->lead_by) == "") { ?>
		<th data-name="lead_by" class="<?php echo $client_db->lead_by->headerCellClass() ?>"><div id="elh_client_db_lead_by" class="client_db_lead_by"><div class="ew-table-header-caption"><?php echo $client_db->lead_by->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lead_by" class="<?php echo $client_db->lead_by->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $client_db->SortUrl($client_db->lead_by) ?>',2);"><div id="elh_client_db_lead_by" class="client_db_lead_by">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $client_db->lead_by->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($client_db->lead_by->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($client_db->lead_by->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($client_db->city->Visible) { // city ?>
	<?php if ($client_db->sortUrl($client_db->city) == "") { ?>
		<th data-name="city" class="<?php echo $client_db->city->headerCellClass() ?>"><div id="elh_client_db_city" class="client_db_city"><div class="ew-table-header-caption"><?php echo $client_db->city->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="city" class="<?php echo $client_db->city->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $client_db->SortUrl($client_db->city) ?>',2);"><div id="elh_client_db_city" class="client_db_city">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $client_db->city->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($client_db->city->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($client_db->city->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($client_db->name->Visible) { // name ?>
	<?php if ($client_db->sortUrl($client_db->name) == "") { ?>
		<th data-name="name" class="<?php echo $client_db->name->headerCellClass() ?>"><div id="elh_client_db_name" class="client_db_name"><div class="ew-table-header-caption"><?php echo $client_db->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $client_db->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $client_db->SortUrl($client_db->name) ?>',2);"><div id="elh_client_db_name" class="client_db_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $client_db->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($client_db->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($client_db->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($client_db->mobile->Visible) { // mobile ?>
	<?php if ($client_db->sortUrl($client_db->mobile) == "") { ?>
		<th data-name="mobile" class="<?php echo $client_db->mobile->headerCellClass() ?>"><div id="elh_client_db_mobile" class="client_db_mobile"><div class="ew-table-header-caption"><?php echo $client_db->mobile->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mobile" class="<?php echo $client_db->mobile->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $client_db->SortUrl($client_db->mobile) ?>',2);"><div id="elh_client_db_mobile" class="client_db_mobile">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $client_db->mobile->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($client_db->mobile->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($client_db->mobile->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($client_db->_email->Visible) { // email ?>
	<?php if ($client_db->sortUrl($client_db->_email) == "") { ?>
		<th data-name="_email" class="<?php echo $client_db->_email->headerCellClass() ?>"><div id="elh_client_db__email" class="client_db__email"><div class="ew-table-header-caption"><?php echo $client_db->_email->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_email" class="<?php echo $client_db->_email->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $client_db->SortUrl($client_db->_email) ?>',2);"><div id="elh_client_db__email" class="client_db__email">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $client_db->_email->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($client_db->_email->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($client_db->_email->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($client_db->address->Visible) { // address ?>
	<?php if ($client_db->sortUrl($client_db->address) == "") { ?>
		<th data-name="address" class="<?php echo $client_db->address->headerCellClass() ?>"><div id="elh_client_db_address" class="client_db_address"><div class="ew-table-header-caption"><?php echo $client_db->address->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="address" class="<?php echo $client_db->address->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $client_db->SortUrl($client_db->address) ?>',2);"><div id="elh_client_db_address" class="client_db_address">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $client_db->address->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($client_db->address->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($client_db->address->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($client_db->operator->Visible) { // operator ?>
	<?php if ($client_db->sortUrl($client_db->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $client_db->operator->headerCellClass() ?>"><div id="elh_client_db_operator" class="client_db_operator"><div class="ew-table-header-caption"><?php echo $client_db->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $client_db->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $client_db->SortUrl($client_db->operator) ?>',2);"><div id="elh_client_db_operator" class="client_db_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $client_db->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($client_db->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($client_db->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($client_db->datetime->Visible) { // datetime ?>
	<?php if ($client_db->sortUrl($client_db->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $client_db->datetime->headerCellClass() ?>"><div id="elh_client_db_datetime" class="client_db_datetime"><div class="ew-table-header-caption"><?php echo $client_db->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $client_db->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $client_db->SortUrl($client_db->datetime) ?>',2);"><div id="elh_client_db_datetime" class="client_db_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $client_db->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($client_db->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($client_db->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$client_db_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($client_db->ExportAll && $client_db->isExport()) {
	$client_db_list->StopRec = $client_db_list->TotalRecs;
} else {

	// Set the last record to display
	if ($client_db_list->TotalRecs > $client_db_list->StartRec + $client_db_list->DisplayRecs - 1)
		$client_db_list->StopRec = $client_db_list->StartRec + $client_db_list->DisplayRecs - 1;
	else
		$client_db_list->StopRec = $client_db_list->TotalRecs;
}
$client_db_list->RecCnt = $client_db_list->StartRec - 1;
if ($client_db_list->Recordset && !$client_db_list->Recordset->EOF) {
	$client_db_list->Recordset->moveFirst();
	$selectLimit = $client_db_list->UseSelectLimit;
	if (!$selectLimit && $client_db_list->StartRec > 1)
		$client_db_list->Recordset->move($client_db_list->StartRec - 1);
} elseif (!$client_db->AllowAddDeleteRow && $client_db_list->StopRec == 0) {
	$client_db_list->StopRec = $client_db->GridAddRowCount;
}

// Initialize aggregate
$client_db->RowType = ROWTYPE_AGGREGATEINIT;
$client_db->resetAttributes();
$client_db_list->renderRow();
while ($client_db_list->RecCnt < $client_db_list->StopRec) {
	$client_db_list->RecCnt++;
	if ($client_db_list->RecCnt >= $client_db_list->StartRec) {
		$client_db_list->RowCnt++;

		// Set up key count
		$client_db_list->KeyCount = $client_db_list->RowIndex;

		// Init row class and style
		$client_db->resetAttributes();
		$client_db->CssClass = "";
		if ($client_db->isGridAdd()) {
		} else {
			$client_db_list->loadRowValues($client_db_list->Recordset); // Load row values
		}
		$client_db->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$client_db->RowAttrs = array_merge($client_db->RowAttrs, array('data-rowindex'=>$client_db_list->RowCnt, 'id'=>'r' . $client_db_list->RowCnt . '_client_db', 'data-rowtype'=>$client_db->RowType));

		// Render row
		$client_db_list->renderRow();

		// Render list options
		$client_db_list->renderListOptions();
?>
	<tr<?php echo $client_db->rowAttributes() ?>>
<?php

// Render list options (body, left)
$client_db_list->ListOptions->render("body", "left", $client_db_list->RowCnt);
?>
	<?php if ($client_db->id->Visible) { // id ?>
		<td data-name="id"<?php echo $client_db->id->cellAttributes() ?>>
<span id="el<?php echo $client_db_list->RowCnt ?>_client_db_id" class="client_db_id">
<span<?php echo $client_db->id->viewAttributes() ?>>
<?php echo $client_db->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($client_db->category->Visible) { // category ?>
		<td data-name="category"<?php echo $client_db->category->cellAttributes() ?>>
<span id="el<?php echo $client_db_list->RowCnt ?>_client_db_category" class="client_db_category">
<span<?php echo $client_db->category->viewAttributes() ?>>
<?php echo $client_db->category->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($client_db->sub_category->Visible) { // sub_category ?>
		<td data-name="sub_category"<?php echo $client_db->sub_category->cellAttributes() ?>>
<span id="el<?php echo $client_db_list->RowCnt ?>_client_db_sub_category" class="client_db_sub_category">
<span<?php echo $client_db->sub_category->viewAttributes() ?>>
<?php echo $client_db->sub_category->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($client_db->lead_type->Visible) { // lead_type ?>
		<td data-name="lead_type"<?php echo $client_db->lead_type->cellAttributes() ?>>
<span id="el<?php echo $client_db_list->RowCnt ?>_client_db_lead_type" class="client_db_lead_type">
<span<?php echo $client_db->lead_type->viewAttributes() ?>>
<?php echo $client_db->lead_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($client_db->lead_by->Visible) { // lead_by ?>
		<td data-name="lead_by"<?php echo $client_db->lead_by->cellAttributes() ?>>
<span id="el<?php echo $client_db_list->RowCnt ?>_client_db_lead_by" class="client_db_lead_by">
<span<?php echo $client_db->lead_by->viewAttributes() ?>>
<?php echo $client_db->lead_by->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($client_db->city->Visible) { // city ?>
		<td data-name="city"<?php echo $client_db->city->cellAttributes() ?>>
<span id="el<?php echo $client_db_list->RowCnt ?>_client_db_city" class="client_db_city">
<span<?php echo $client_db->city->viewAttributes() ?>>
<?php echo $client_db->city->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($client_db->name->Visible) { // name ?>
		<td data-name="name"<?php echo $client_db->name->cellAttributes() ?>>
<span id="el<?php echo $client_db_list->RowCnt ?>_client_db_name" class="client_db_name">
<span<?php echo $client_db->name->viewAttributes() ?>>
<?php echo $client_db->name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($client_db->mobile->Visible) { // mobile ?>
		<td data-name="mobile"<?php echo $client_db->mobile->cellAttributes() ?>>
<span id="el<?php echo $client_db_list->RowCnt ?>_client_db_mobile" class="client_db_mobile">
<span<?php echo $client_db->mobile->viewAttributes() ?>>
<?php echo $client_db->mobile->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($client_db->_email->Visible) { // email ?>
		<td data-name="_email"<?php echo $client_db->_email->cellAttributes() ?>>
<span id="el<?php echo $client_db_list->RowCnt ?>_client_db__email" class="client_db__email">
<span<?php echo $client_db->_email->viewAttributes() ?>>
<?php echo $client_db->_email->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($client_db->address->Visible) { // address ?>
		<td data-name="address"<?php echo $client_db->address->cellAttributes() ?>>
<span id="el<?php echo $client_db_list->RowCnt ?>_client_db_address" class="client_db_address">
<span<?php echo $client_db->address->viewAttributes() ?>>
<?php echo $client_db->address->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($client_db->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $client_db->operator->cellAttributes() ?>>
<span id="el<?php echo $client_db_list->RowCnt ?>_client_db_operator" class="client_db_operator">
<span<?php echo $client_db->operator->viewAttributes() ?>>
<?php echo $client_db->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($client_db->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $client_db->datetime->cellAttributes() ?>>
<span id="el<?php echo $client_db_list->RowCnt ?>_client_db_datetime" class="client_db_datetime">
<span<?php echo $client_db->datetime->viewAttributes() ?>>
<?php echo $client_db->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$client_db_list->ListOptions->render("body", "right", $client_db_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$client_db->isGridAdd())
		$client_db_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$client_db->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($client_db_list->Recordset)
	$client_db_list->Recordset->Close();
?>
<?php if (!$client_db->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$client_db->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($client_db_list->Pager)) $client_db_list->Pager = new PrevNextPager($client_db_list->StartRec, $client_db_list->DisplayRecs, $client_db_list->TotalRecs, $client_db_list->AutoHidePager) ?>
<?php if ($client_db_list->Pager->RecordCount > 0 && $client_db_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($client_db_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $client_db_list->pageUrl() ?>start=<?php echo $client_db_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($client_db_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $client_db_list->pageUrl() ?>start=<?php echo $client_db_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $client_db_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($client_db_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $client_db_list->pageUrl() ?>start=<?php echo $client_db_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($client_db_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $client_db_list->pageUrl() ?>start=<?php echo $client_db_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $client_db_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($client_db_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $client_db_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $client_db_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $client_db_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($client_db_list->TotalRecs > 0 && (!$client_db_list->AutoHidePageSizeSelector || $client_db_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="client_db">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($client_db_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($client_db_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($client_db_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($client_db_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($client_db_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($client_db->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $client_db_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($client_db_list->TotalRecs == 0 && !$client_db->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $client_db_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$client_db_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$client_db->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$client_db->isExport()) { ?>
<script>
ew.scrollableTable("gmp_client_db", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$client_db_list->terminate();
?>