<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$client_db_search = new client_db_search();

// Run the page
$client_db_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$client_db_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($client_db_search->IsModal) { ?>
var fclient_dbsearch = currentAdvancedSearchForm = new ew.Form("fclient_dbsearch", "search");
<?php } else { ?>
var fclient_dbsearch = currentForm = new ew.Form("fclient_dbsearch", "search");
<?php } ?>

// Form_CustomValidate event
fclient_dbsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fclient_dbsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fclient_dbsearch.lists["x_category[]"] = <?php echo $client_db_search->category->Lookup->toClientList() ?>;
fclient_dbsearch.lists["x_category[]"].options = <?php echo JsonEncode($client_db_search->category->lookupOptions()) ?>;
fclient_dbsearch.lists["x_sub_category[]"] = <?php echo $client_db_search->sub_category->Lookup->toClientList() ?>;
fclient_dbsearch.lists["x_sub_category[]"].options = <?php echo JsonEncode($client_db_search->sub_category->lookupOptions()) ?>;
fclient_dbsearch.lists["x_lead_type"] = <?php echo $client_db_search->lead_type->Lookup->toClientList() ?>;
fclient_dbsearch.lists["x_lead_type"].options = <?php echo JsonEncode($client_db_search->lead_type->lookupOptions()) ?>;
fclient_dbsearch.lists["x_city"] = <?php echo $client_db_search->city->Lookup->toClientList() ?>;
fclient_dbsearch.lists["x_city"].options = <?php echo JsonEncode($client_db_search->city->lookupOptions()) ?>;
fclient_dbsearch.autoSuggests["x_city"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fclient_dbsearch.lists["x_name"] = <?php echo $client_db_search->name->Lookup->toClientList() ?>;
fclient_dbsearch.lists["x_name"].options = <?php echo JsonEncode($client_db_search->name->lookupOptions()) ?>;
fclient_dbsearch.autoSuggests["x_name"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fclient_dbsearch.lists["x_mobile"] = <?php echo $client_db_search->mobile->Lookup->toClientList() ?>;
fclient_dbsearch.lists["x_mobile"].options = <?php echo JsonEncode($client_db_search->mobile->lookupOptions()) ?>;
fclient_dbsearch.autoSuggests["x_mobile"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fclient_dbsearch.lists["x__email"] = <?php echo $client_db_search->_email->Lookup->toClientList() ?>;
fclient_dbsearch.lists["x__email"].options = <?php echo JsonEncode($client_db_search->_email->lookupOptions()) ?>;
fclient_dbsearch.autoSuggests["x__email"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fclient_dbsearch.lists["x_operator"] = <?php echo $client_db_search->operator->Lookup->toClientList() ?>;
fclient_dbsearch.lists["x_operator"].options = <?php echo JsonEncode($client_db_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fclient_dbsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($client_db->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($client_db->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $client_db_search->showPageHeader(); ?>
<?php
$client_db_search->showMessage();
?>
<form name="fclient_dbsearch" id="fclient_dbsearch" class="<?php echo $client_db_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($client_db_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $client_db_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="client_db">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$client_db_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($client_db->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $client_db_search->LeftColumnClass ?>"><span id="elh_client_db_id"><?php echo $client_db->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $client_db_search->RightColumnClass ?>"><div<?php echo $client_db->id->cellAttributes() ?>>
			<span id="el_client_db_id">
<input type="text" data-table="client_db" data-field="x_id" name="x_id" id="x_id" size="30" placeholder="<?php echo HtmlEncode($client_db->id->getPlaceHolder()) ?>" value="<?php echo $client_db->id->EditValue ?>"<?php echo $client_db->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_db->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label class="<?php echo $client_db_search->LeftColumnClass ?>"><span id="elh_client_db_category"><?php echo $client_db->category->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_category" id="z_category" value="LIKE"></span>
		</label>
		<div class="<?php echo $client_db_search->RightColumnClass ?>"><div<?php echo $client_db->category->cellAttributes() ?>>
			<span id="el_client_db_category">
<?php $client_db->category->EditAttrs["onclick"] = "ew.updateOptions.call(this); " . @$client_db->category->EditAttrs["onclick"]; ?>
<div id="tp_x_category" class="ew-template"><input type="checkbox" class="form-check-input" data-table="client_db" data-field="x_category" data-value-separator="<?php echo $client_db->category->displayValueSeparatorAttribute() ?>" name="x_category[]" id="x_category[]" value="{value}"<?php echo $client_db->category->editAttributes() ?>></div>
<div id="dsl_x_category" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $client_db->category->checkBoxListHtml(FALSE, "x_category[]") ?>
</div></div>
<?php echo $client_db->category->Lookup->getParamTag("p_x_category") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_db->sub_category->Visible) { // sub_category ?>
	<div id="r_sub_category" class="form-group row">
		<label class="<?php echo $client_db_search->LeftColumnClass ?>"><span id="elh_client_db_sub_category"><?php echo $client_db->sub_category->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_sub_category" id="z_sub_category" value="LIKE"></span>
		</label>
		<div class="<?php echo $client_db_search->RightColumnClass ?>"><div<?php echo $client_db->sub_category->cellAttributes() ?>>
			<span id="el_client_db_sub_category">
<div id="tp_x_sub_category" class="ew-template"><input type="checkbox" class="form-check-input" data-table="client_db" data-field="x_sub_category" data-value-separator="<?php echo $client_db->sub_category->displayValueSeparatorAttribute() ?>" name="x_sub_category[]" id="x_sub_category[]" value="{value}"<?php echo $client_db->sub_category->editAttributes() ?>></div>
<div id="dsl_x_sub_category" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $client_db->sub_category->checkBoxListHtml(FALSE, "x_sub_category[]") ?>
</div></div>
<?php echo $client_db->sub_category->Lookup->getParamTag("p_x_sub_category") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_db->lead_type->Visible) { // lead_type ?>
	<div id="r_lead_type" class="form-group row">
		<label class="<?php echo $client_db_search->LeftColumnClass ?>"><span id="elh_client_db_lead_type"><?php echo $client_db->lead_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_lead_type" id="z_lead_type" value="="></span>
		</label>
		<div class="<?php echo $client_db_search->RightColumnClass ?>"><div<?php echo $client_db->lead_type->cellAttributes() ?>>
			<span id="el_client_db_lead_type">
<div id="tp_x_lead_type" class="ew-template"><input type="radio" class="form-check-input" data-table="client_db" data-field="x_lead_type" data-value-separator="<?php echo $client_db->lead_type->displayValueSeparatorAttribute() ?>" name="x_lead_type" id="x_lead_type" value="{value}"<?php echo $client_db->lead_type->editAttributes() ?>></div>
<div id="dsl_x_lead_type" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $client_db->lead_type->radioButtonListHtml(FALSE, "x_lead_type") ?>
</div></div>
<?php echo $client_db->lead_type->Lookup->getParamTag("p_x_lead_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_db->lead_by->Visible) { // lead_by ?>
	<div id="r_lead_by" class="form-group row">
		<label for="x_lead_by" class="<?php echo $client_db_search->LeftColumnClass ?>"><span id="elh_client_db_lead_by"><?php echo $client_db->lead_by->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_lead_by" id="z_lead_by" value="LIKE"></span>
		</label>
		<div class="<?php echo $client_db_search->RightColumnClass ?>"><div<?php echo $client_db->lead_by->cellAttributes() ?>>
			<span id="el_client_db_lead_by">
<input type="text" data-table="client_db" data-field="x_lead_by" name="x_lead_by" id="x_lead_by" size="30" maxlength="92" placeholder="<?php echo HtmlEncode($client_db->lead_by->getPlaceHolder()) ?>" value="<?php echo $client_db->lead_by->EditValue ?>"<?php echo $client_db->lead_by->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_db->city->Visible) { // city ?>
	<div id="r_city" class="form-group row">
		<label class="<?php echo $client_db_search->LeftColumnClass ?>"><span id="elh_client_db_city"><?php echo $client_db->city->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_city" id="z_city" value="LIKE"></span>
		</label>
		<div class="<?php echo $client_db_search->RightColumnClass ?>"><div<?php echo $client_db->city->cellAttributes() ?>>
			<span id="el_client_db_city">
<?php
$wrkonchange = "" . trim(@$client_db->city->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$client_db->city->EditAttrs["onchange"] = "";
?>
<span id="as_x_city" class="text-nowrap" style="z-index: 8940">
	<input type="text" class="form-control" name="sv_x_city" id="sv_x_city" value="<?php echo RemoveHtml($client_db->city->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($client_db->city->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($client_db->city->getPlaceHolder()) ?>"<?php echo $client_db->city->editAttributes() ?>>
</span>
<input type="hidden" data-table="client_db" data-field="x_city" data-value-separator="<?php echo $client_db->city->displayValueSeparatorAttribute() ?>" name="x_city" id="x_city" value="<?php echo HtmlEncode($client_db->city->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fclient_dbsearch.createAutoSuggest({"id":"x_city","forceSelect":false});
</script>
<?php echo $client_db->city->Lookup->getParamTag("p_x_city") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_db->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label class="<?php echo $client_db_search->LeftColumnClass ?>"><span id="elh_client_db_name"><?php echo $client_db->name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $client_db_search->RightColumnClass ?>"><div<?php echo $client_db->name->cellAttributes() ?>>
			<span id="el_client_db_name">
<?php
$wrkonchange = "" . trim(@$client_db->name->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$client_db->name->EditAttrs["onchange"] = "";
?>
<span id="as_x_name" class="text-nowrap" style="z-index: 8930">
	<input type="text" class="form-control" name="sv_x_name" id="sv_x_name" value="<?php echo RemoveHtml($client_db->name->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($client_db->name->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($client_db->name->getPlaceHolder()) ?>"<?php echo $client_db->name->editAttributes() ?>>
</span>
<input type="hidden" data-table="client_db" data-field="x_name" data-value-separator="<?php echo $client_db->name->displayValueSeparatorAttribute() ?>" name="x_name" id="x_name" value="<?php echo HtmlEncode($client_db->name->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fclient_dbsearch.createAutoSuggest({"id":"x_name","forceSelect":false});
</script>
<?php echo $client_db->name->Lookup->getParamTag("p_x_name") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_db->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label class="<?php echo $client_db_search->LeftColumnClass ?>"><span id="elh_client_db_mobile"><?php echo $client_db->mobile->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_mobile" id="z_mobile" value="LIKE"></span>
		</label>
		<div class="<?php echo $client_db_search->RightColumnClass ?>"><div<?php echo $client_db->mobile->cellAttributes() ?>>
			<span id="el_client_db_mobile">
<?php
$wrkonchange = "" . trim(@$client_db->mobile->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$client_db->mobile->EditAttrs["onchange"] = "";
?>
<span id="as_x_mobile" class="text-nowrap" style="z-index: 8920">
	<input type="text" class="form-control" name="sv_x_mobile" id="sv_x_mobile" value="<?php echo RemoveHtml($client_db->mobile->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($client_db->mobile->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($client_db->mobile->getPlaceHolder()) ?>"<?php echo $client_db->mobile->editAttributes() ?>>
</span>
<input type="hidden" data-table="client_db" data-field="x_mobile" data-value-separator="<?php echo $client_db->mobile->displayValueSeparatorAttribute() ?>" name="x_mobile" id="x_mobile" value="<?php echo HtmlEncode($client_db->mobile->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fclient_dbsearch.createAutoSuggest({"id":"x_mobile","forceSelect":false});
</script>
<?php echo $client_db->mobile->Lookup->getParamTag("p_x_mobile") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_db->_email->Visible) { // email ?>
	<div id="r__email" class="form-group row">
		<label class="<?php echo $client_db_search->LeftColumnClass ?>"><span id="elh_client_db__email"><?php echo $client_db->_email->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__email" id="z__email" value="LIKE"></span>
		</label>
		<div class="<?php echo $client_db_search->RightColumnClass ?>"><div<?php echo $client_db->_email->cellAttributes() ?>>
			<span id="el_client_db__email">
<?php
$wrkonchange = "" . trim(@$client_db->_email->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$client_db->_email->EditAttrs["onchange"] = "";
?>
<span id="as_x__email" class="text-nowrap" style="z-index: 8910">
	<input type="text" class="form-control" name="sv_x__email" id="sv_x__email" value="<?php echo RemoveHtml($client_db->_email->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($client_db->_email->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($client_db->_email->getPlaceHolder()) ?>"<?php echo $client_db->_email->editAttributes() ?>>
</span>
<input type="hidden" data-table="client_db" data-field="x__email" data-value-separator="<?php echo $client_db->_email->displayValueSeparatorAttribute() ?>" name="x__email" id="x__email" value="<?php echo HtmlEncode($client_db->_email->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fclient_dbsearch.createAutoSuggest({"id":"x__email","forceSelect":false});
</script>
<?php echo $client_db->_email->Lookup->getParamTag("p_x__email") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_db->address->Visible) { // address ?>
	<div id="r_address" class="form-group row">
		<label for="x_address" class="<?php echo $client_db_search->LeftColumnClass ?>"><span id="elh_client_db_address"><?php echo $client_db->address->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_address" id="z_address" value="LIKE"></span>
		</label>
		<div class="<?php echo $client_db_search->RightColumnClass ?>"><div<?php echo $client_db->address->cellAttributes() ?>>
			<span id="el_client_db_address">
<input type="text" data-table="client_db" data-field="x_address" name="x_address" id="x_address" maxlength="192" placeholder="<?php echo HtmlEncode($client_db->address->getPlaceHolder()) ?>" value="<?php echo $client_db->address->EditValue ?>"<?php echo $client_db->address->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_db->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $client_db_search->LeftColumnClass ?>"><span id="elh_client_db_remarks"><?php echo $client_db->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $client_db_search->RightColumnClass ?>"><div<?php echo $client_db->remarks->cellAttributes() ?>>
			<span id="el_client_db_remarks">
<input type="text" data-table="client_db" data-field="x_remarks" name="x_remarks" id="x_remarks" size="35" placeholder="<?php echo HtmlEncode($client_db->remarks->getPlaceHolder()) ?>" value="<?php echo $client_db->remarks->EditValue ?>"<?php echo $client_db->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_db->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label class="<?php echo $client_db_search->LeftColumnClass ?>"><span id="elh_client_db_image"><?php echo $client_db->image->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_image" id="z_image" value="LIKE"></span>
		</label>
		<div class="<?php echo $client_db_search->RightColumnClass ?>"><div<?php echo $client_db->image->cellAttributes() ?>>
			<span id="el_client_db_image">
<input type="text" data-table="client_db" data-field="x_image" name="x_image" id="x_image" placeholder="<?php echo HtmlEncode($client_db->image->getPlaceHolder()) ?>" value="<?php echo $client_db->image->EditValue ?>"<?php echo $client_db->image->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_db->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $client_db_search->LeftColumnClass ?>"><span id="elh_client_db_operator"><?php echo $client_db->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $client_db_search->RightColumnClass ?>"><div<?php echo $client_db->operator->cellAttributes() ?>>
			<span id="el_client_db_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="client_db" data-field="x_operator" data-value-separator="<?php echo $client_db->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $client_db->operator->editAttributes() ?>>
		<?php echo $client_db->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $client_db->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_db->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $client_db_search->LeftColumnClass ?>"><span id="elh_client_db_datetime"><?php echo $client_db->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $client_db_search->RightColumnClass ?>"><div<?php echo $client_db->datetime->cellAttributes() ?>>
			<span id="el_client_db_datetime">
<input type="text" data-table="client_db" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($client_db->datetime->getPlaceHolder()) ?>" value="<?php echo $client_db->datetime->EditValue ?>"<?php echo $client_db->datetime->editAttributes() ?>>
<?php if (!$client_db->datetime->ReadOnly && !$client_db->datetime->Disabled && !isset($client_db->datetime->EditAttrs["readonly"]) && !isset($client_db->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fclient_dbsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$client_db_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $client_db_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$client_db_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$client_db_search->terminate();
?>