<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$client_hardware_data_addopt = new client_hardware_data_addopt();

// Run the page
$client_hardware_data_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$client_hardware_data_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fclient_hardware_dataaddopt = currentForm = new ew.Form("fclient_hardware_dataaddopt", "addopt");

// Validate form
fclient_hardware_dataaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($client_hardware_data_addopt->customer_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_customer_grp[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->customer_grp->caption(), $client_hardware_data->customer_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_addopt->ref->Required) { ?>
			elm = this.getElements("x" + infix + "_ref");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->ref->caption(), $client_hardware_data->ref->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_addopt->partner_id->Required) { ?>
			elm = this.getElements("x" + infix + "_partner_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->partner_id->caption(), $client_hardware_data->partner_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_addopt->name_ref->Required) { ?>
			elm = this.getElements("x" + infix + "_name_ref");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->name_ref->caption(), $client_hardware_data->name_ref->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_addopt->city_name->Required) { ?>
			elm = this.getElements("x" + infix + "_city_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->city_name->caption(), $client_hardware_data->city_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_addopt->area->Required) { ?>
			elm = this.getElements("x" + infix + "_area");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->area->caption(), $client_hardware_data->area->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_addopt->billing_name->Required) { ?>
			elm = this.getElements("x" + infix + "_billing_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->billing_name->caption(), $client_hardware_data->billing_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_addopt->address->Required) { ?>
			elm = this.getElements("x" + infix + "_address");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->address->caption(), $client_hardware_data->address->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_addopt->personal_ref->Required) { ?>
			elm = this.getElements("x" + infix + "_personal_ref[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->personal_ref->caption(), $client_hardware_data->personal_ref->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_addopt->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->grp->caption(), $client_hardware_data->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_addopt->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->s_grp->caption(), $client_hardware_data->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_addopt->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->product->caption(), $client_hardware_data->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_addopt->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->rid->caption(), $client_hardware_data->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_addopt->rid_1->Required) { ?>
			elm = this.getElements("x" + infix + "_rid_1");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->rid_1->caption(), $client_hardware_data->rid_1->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_addopt->harward_code->Required) { ?>
			elm = this.getElements("x" + infix + "_harward_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->harward_code->caption(), $client_hardware_data->harward_code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_addopt->serial_no->Required) { ?>
			elm = this.getElements("x" + infix + "_serial_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->serial_no->caption(), $client_hardware_data->serial_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_addopt->invoice_no->Required) { ?>
			elm = this.getElements("x" + infix + "_invoice_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->invoice_no->caption(), $client_hardware_data->invoice_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_addopt->invoice_date->Required) { ?>
			elm = this.getElements("x" + infix + "_invoice_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->invoice_date->caption(), $client_hardware_data->invoice_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_invoice_date");
			if (elm && !ew.checkEuroDate(elm.value))
				return this.onError(elm, "<?php echo JsEncode($client_hardware_data->invoice_date->errorMessage()) ?>");
		<?php if ($client_hardware_data_addopt->first_counter->Required) { ?>
			elm = this.getElements("x" + infix + "_first_counter");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->first_counter->caption(), $client_hardware_data->first_counter->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_first_counter");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($client_hardware_data->first_counter->errorMessage()) ?>");
		<?php if ($client_hardware_data_addopt->guarantee->Required) { ?>
			elm = this.getElements("x" + infix + "_guarantee");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->guarantee->caption(), $client_hardware_data->guarantee->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_addopt->valid_till->Required) { ?>
			elm = this.getElements("x" + infix + "_valid_till");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->valid_till->caption(), $client_hardware_data->valid_till->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_valid_till");
			if (elm && !ew.checkEuroDate(elm.value))
				return this.onError(elm, "<?php echo JsEncode($client_hardware_data->valid_till->errorMessage()) ?>");
		<?php if ($client_hardware_data_addopt->valid_till_counter->Required) { ?>
			elm = this.getElements("x" + infix + "_valid_till_counter");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->valid_till_counter->caption(), $client_hardware_data->valid_till_counter->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_valid_till_counter");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($client_hardware_data->valid_till_counter->errorMessage()) ?>");
		<?php if ($client_hardware_data_addopt->free_service->Required) { ?>
			elm = this.getElements("x" + infix + "_free_service");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->free_service->caption(), $client_hardware_data->free_service->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_free_service");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($client_hardware_data->free_service->errorMessage()) ?>");
		<?php if ($client_hardware_data_addopt->toner_life->Required) { ?>
			elm = this.getElements("x" + infix + "_toner_life");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->toner_life->caption(), $client_hardware_data->toner_life->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_toner_life");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($client_hardware_data->toner_life->errorMessage()) ?>");
		<?php if ($client_hardware_data_addopt->drum_life->Required) { ?>
			elm = this.getElements("x" + infix + "_drum_life");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->drum_life->caption(), $client_hardware_data->drum_life->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_drum_life");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($client_hardware_data->drum_life->errorMessage()) ?>");
		<?php if ($client_hardware_data_addopt->developer_life->Required) { ?>
			elm = this.getElements("x" + infix + "_developer_life");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->developer_life->caption(), $client_hardware_data->developer_life->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_developer_life");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($client_hardware_data->developer_life->errorMessage()) ?>");
		<?php if ($client_hardware_data_addopt->date_install->Required) { ?>
			elm = this.getElements("x" + infix + "_date_install");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->date_install->caption(), $client_hardware_data->date_install->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_date_install");
			if (elm && !ew.checkEuroDate(elm.value))
				return this.onError(elm, "<?php echo JsEncode($client_hardware_data->date_install->errorMessage()) ?>");
		<?php if ($client_hardware_data_addopt->date_start->Required) { ?>
			elm = this.getElements("x" + infix + "_date_start");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->date_start->caption(), $client_hardware_data->date_start->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_date_start");
			if (elm && !ew.checkEuroDate(elm.value))
				return this.onError(elm, "<?php echo JsEncode($client_hardware_data->date_start->errorMessage()) ?>");
		<?php if ($client_hardware_data_addopt->remark->Required) { ?>
			elm = this.getElements("x" + infix + "_remark");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->remark->caption(), $client_hardware_data->remark->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_addopt->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->status->caption(), $client_hardware_data->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_addopt->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->operator->caption(), $client_hardware_data->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_addopt->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->datetime->caption(), $client_hardware_data->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_addopt->copy_average_1->Required) { ?>
			elm = this.getElements("x" + infix + "_copy_average_1");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->copy_average_1->caption(), $client_hardware_data->copy_average_1->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_copy_average_1");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($client_hardware_data->copy_average_1->errorMessage()) ?>");
		<?php if ($client_hardware_data_addopt->copy_average_2->Required) { ?>
			elm = this.getElements("x" + infix + "_copy_average_2");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->copy_average_2->caption(), $client_hardware_data->copy_average_2->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_copy_average_2");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($client_hardware_data->copy_average_2->errorMessage()) ?>");
		<?php if ($client_hardware_data_addopt->copy_average_3->Required) { ?>
			elm = this.getElements("x" + infix + "_copy_average_3");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->copy_average_3->caption(), $client_hardware_data->copy_average_3->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_copy_average_3");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($client_hardware_data->copy_average_3->errorMessage()) ?>");
		<?php if ($client_hardware_data_addopt->schedule_service_type->Required) { ?>
			elm = this.getElements("x" + infix + "_schedule_service_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->schedule_service_type->caption(), $client_hardware_data->schedule_service_type->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_schedule_service_type");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($client_hardware_data->schedule_service_type->errorMessage()) ?>");
		<?php if ($client_hardware_data_addopt->schedule_service_interval_days->Required) { ?>
			elm = this.getElements("x" + infix + "_schedule_service_interval_days");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->schedule_service_interval_days->caption(), $client_hardware_data->schedule_service_interval_days->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_schedule_service_interval_days");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($client_hardware_data->schedule_service_interval_days->errorMessage()) ?>");
		<?php if ($client_hardware_data_addopt->schedule_service_updated_till->Required) { ?>
			elm = this.getElements("x" + infix + "_schedule_service_updated_till");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->schedule_service_updated_till->caption(), $client_hardware_data->schedule_service_updated_till->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_schedule_service_updated_till");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($client_hardware_data->schedule_service_updated_till->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fclient_hardware_dataaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fclient_hardware_dataaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fclient_hardware_dataaddopt.lists["x_customer_grp[]"] = <?php echo $client_hardware_data_addopt->customer_grp->Lookup->toClientList() ?>;
fclient_hardware_dataaddopt.lists["x_customer_grp[]"].options = <?php echo JsonEncode($client_hardware_data_addopt->customer_grp->lookupOptions()) ?>;
fclient_hardware_dataaddopt.lists["x_partner_id"] = <?php echo $client_hardware_data_addopt->partner_id->Lookup->toClientList() ?>;
fclient_hardware_dataaddopt.lists["x_partner_id"].options = <?php echo JsonEncode($client_hardware_data_addopt->partner_id->lookupOptions()) ?>;
fclient_hardware_dataaddopt.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fclient_hardware_dataaddopt.lists["x_area"] = <?php echo $client_hardware_data_addopt->area->Lookup->toClientList() ?>;
fclient_hardware_dataaddopt.lists["x_area"].options = <?php echo JsonEncode($client_hardware_data_addopt->area->lookupOptions()) ?>;
fclient_hardware_dataaddopt.autoSuggests["x_area"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fclient_hardware_dataaddopt.lists["x_personal_ref[]"] = <?php echo $client_hardware_data_addopt->personal_ref->Lookup->toClientList() ?>;
fclient_hardware_dataaddopt.lists["x_personal_ref[]"].options = <?php echo JsonEncode($client_hardware_data_addopt->personal_ref->lookupOptions()) ?>;
fclient_hardware_dataaddopt.lists["x_grp"] = <?php echo $client_hardware_data_addopt->grp->Lookup->toClientList() ?>;
fclient_hardware_dataaddopt.lists["x_grp"].options = <?php echo JsonEncode($client_hardware_data_addopt->grp->lookupOptions()) ?>;
fclient_hardware_dataaddopt.lists["x_s_grp"] = <?php echo $client_hardware_data_addopt->s_grp->Lookup->toClientList() ?>;
fclient_hardware_dataaddopt.lists["x_s_grp"].options = <?php echo JsonEncode($client_hardware_data_addopt->s_grp->lookupOptions()) ?>;
fclient_hardware_dataaddopt.lists["x_product"] = <?php echo $client_hardware_data_addopt->product->Lookup->toClientList() ?>;
fclient_hardware_dataaddopt.lists["x_product"].options = <?php echo JsonEncode($client_hardware_data_addopt->product->lookupOptions()) ?>;
fclient_hardware_dataaddopt.lists["x_rid"] = <?php echo $client_hardware_data_addopt->rid->Lookup->toClientList() ?>;
fclient_hardware_dataaddopt.lists["x_rid"].options = <?php echo JsonEncode($client_hardware_data_addopt->rid->lookupOptions()) ?>;
fclient_hardware_dataaddopt.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fclient_hardware_dataaddopt.lists["x_guarantee"] = <?php echo $client_hardware_data_addopt->guarantee->Lookup->toClientList() ?>;
fclient_hardware_dataaddopt.lists["x_guarantee"].options = <?php echo JsonEncode($client_hardware_data_addopt->guarantee->options(FALSE, TRUE)) ?>;
fclient_hardware_dataaddopt.lists["x_status"] = <?php echo $client_hardware_data_addopt->status->Lookup->toClientList() ?>;
fclient_hardware_dataaddopt.lists["x_status"].options = <?php echo JsonEncode($client_hardware_data_addopt->status->options(FALSE, TRUE)) ?>;
fclient_hardware_dataaddopt.lists["x_operator"] = <?php echo $client_hardware_data_addopt->operator->Lookup->toClientList() ?>;
fclient_hardware_dataaddopt.lists["x_operator"].options = <?php echo JsonEncode($client_hardware_data_addopt->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $client_hardware_data_addopt->showPageHeader(); ?>
<?php
$client_hardware_data_addopt->showMessage();
?>
<form name="fclient_hardware_dataaddopt" id="fclient_hardware_dataaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($client_hardware_data_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $client_hardware_data_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $client_hardware_data_addopt->TableVar ?>">
<?php if ($client_hardware_data->customer_grp->Visible) { // customer_grp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $client_hardware_data->customer_grp->caption() ?><?php echo ($client_hardware_data->customer_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="tp_x_customer_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="client_hardware_data" data-field="x_customer_grp" data-value-separator="<?php echo $client_hardware_data->customer_grp->displayValueSeparatorAttribute() ?>" name="x_customer_grp[]" id="x_customer_grp[]" value="{value}"<?php echo $client_hardware_data->customer_grp->editAttributes() ?>></div>
<div id="dsl_x_customer_grp" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $client_hardware_data->customer_grp->checkBoxListHtml(FALSE, "x_customer_grp[]") ?>
</div></div>
<?php echo $client_hardware_data->customer_grp->Lookup->getParamTag("p_x_customer_grp") ?>
<?php echo $client_hardware_data->customer_grp->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->ref->Visible) { // ref ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_ref"><?php echo $client_hardware_data->ref->caption() ?><?php echo ($client_hardware_data->ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="client_hardware_data" data-field="x_ref" name="x_ref" id="x_ref" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($client_hardware_data->ref->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->ref->EditValue ?>"<?php echo $client_hardware_data->ref->editAttributes() ?>>
<?php echo $client_hardware_data->ref->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->partner_id->Visible) { // partner_id ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $client_hardware_data->partner_id->caption() ?><?php echo ($client_hardware_data->partner_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php
$wrkonchange = "ew.autoFill(this);" . trim(@$client_hardware_data->partner_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$client_hardware_data->partner_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_partner_id" class="text-nowrap" style="z-index: 8960">
	<input type="text" class="form-control" name="sv_x_partner_id" id="sv_x_partner_id" value="<?php echo RemoveHtml($client_hardware_data->partner_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->partner_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($client_hardware_data->partner_id->getPlaceHolder()) ?>"<?php echo $client_hardware_data->partner_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="client_hardware_data" data-field="x_partner_id" data-value-separator="<?php echo $client_hardware_data->partner_id->displayValueSeparatorAttribute() ?>" name="x_partner_id" id="x_partner_id" value="<?php echo HtmlEncode($client_hardware_data->partner_id->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fclient_hardware_dataaddopt.createAutoSuggest({"id":"x_partner_id","forceSelect":true});
</script>
<?php echo $client_hardware_data->partner_id->Lookup->getParamTag("p_x_partner_id") ?>
<?php echo $client_hardware_data->partner_id->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->name_ref->Visible) { // name_ref ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_name_ref"><?php echo $client_hardware_data->name_ref->caption() ?><?php echo ($client_hardware_data->name_ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="client_hardware_data" data-field="x_name_ref" name="x_name_ref" id="x_name_ref" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($client_hardware_data->name_ref->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->name_ref->EditValue ?>"<?php echo $client_hardware_data->name_ref->editAttributes() ?>>
<?php echo $client_hardware_data->name_ref->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->city_name->Visible) { // city_name ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_city_name"><?php echo $client_hardware_data->city_name->caption() ?><?php echo ($client_hardware_data->city_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="client_hardware_data" data-field="x_city_name" name="x_city_name" id="x_city_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($client_hardware_data->city_name->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->city_name->EditValue ?>"<?php echo $client_hardware_data->city_name->editAttributes() ?>>
<?php echo $client_hardware_data->city_name->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->area->Visible) { // area ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $client_hardware_data->area->caption() ?><?php echo ($client_hardware_data->area->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php
$wrkonchange = "" . trim(@$client_hardware_data->area->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$client_hardware_data->area->EditAttrs["onchange"] = "";
?>
<span id="as_x_area" class="text-nowrap" style="z-index: 8930">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_area" id="sv_x_area" value="<?php echo RemoveHtml($client_hardware_data->area->EditValue) ?>" placeholder="<?php echo HtmlEncode($client_hardware_data->area->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($client_hardware_data->area->getPlaceHolder()) ?>"<?php echo $client_hardware_data->area->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($client_hardware_data->area->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_area',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($client_hardware_data->area->ReadOnly || $client_hardware_data->area->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="client_hardware_data" data-field="x_area" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $client_hardware_data->area->displayValueSeparatorAttribute() ?>" name="x_area" id="x_area" value="<?php echo HtmlEncode($client_hardware_data->area->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fclient_hardware_dataaddopt.createAutoSuggest({"id":"x_area","forceSelect":false});
</script>
<?php echo $client_hardware_data->area->Lookup->getParamTag("p_x_area") ?>
<?php echo $client_hardware_data->area->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->billing_name->Visible) { // billing_name ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_billing_name"><?php echo $client_hardware_data->billing_name->caption() ?><?php echo ($client_hardware_data->billing_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="client_hardware_data" data-field="x_billing_name" name="x_billing_name" id="x_billing_name" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->billing_name->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->billing_name->EditValue ?>"<?php echo $client_hardware_data->billing_name->editAttributes() ?>>
<?php echo $client_hardware_data->billing_name->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->address->Visible) { // address ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_address"><?php echo $client_hardware_data->address->caption() ?><?php echo ($client_hardware_data->address->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="client_hardware_data" data-field="x_address" name="x_address" id="x_address" cols="35" rows="4" placeholder="<?php echo HtmlEncode($client_hardware_data->address->getPlaceHolder()) ?>"<?php echo $client_hardware_data->address->editAttributes() ?>><?php echo $client_hardware_data->address->EditValue ?></textarea>
<?php echo $client_hardware_data->address->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->personal_ref->Visible) { // personal_ref ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $client_hardware_data->personal_ref->caption() ?><?php echo ($client_hardware_data->personal_ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_personal_ref"><?php echo strval($client_hardware_data->personal_ref->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($client_hardware_data->personal_ref->ViewValue) : $client_hardware_data->personal_ref->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($client_hardware_data->personal_ref->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($client_hardware_data->personal_ref->ReadOnly || $client_hardware_data->personal_ref->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_personal_ref[]',m:1,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $client_hardware_data->personal_ref->Lookup->getParamTag("p_x_personal_ref") ?>
<input type="hidden" data-table="client_hardware_data" data-field="x_personal_ref" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $client_hardware_data->personal_ref->displayValueSeparatorAttribute() ?>" name="x_personal_ref[]" id="x_personal_ref[]" value="<?php echo $client_hardware_data->personal_ref->CurrentValue ?>"<?php echo $client_hardware_data->personal_ref->editAttributes() ?>>
<?php echo $client_hardware_data->personal_ref->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->grp->Visible) { // grp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_grp"><?php echo $client_hardware_data->grp->caption() ?><?php echo ($client_hardware_data->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php $client_hardware_data->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$client_hardware_data->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="client_hardware_data" data-field="x_grp" data-value-separator="<?php echo $client_hardware_data->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $client_hardware_data->grp->editAttributes() ?>>
		<?php echo $client_hardware_data->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $client_hardware_data->grp->Lookup->getParamTag("p_x_grp") ?>
<?php echo $client_hardware_data->grp->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->s_grp->Visible) { // s_grp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_s_grp"><?php echo $client_hardware_data->s_grp->caption() ?><?php echo ($client_hardware_data->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php $client_hardware_data->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$client_hardware_data->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="client_hardware_data" data-field="x_s_grp" data-value-separator="<?php echo $client_hardware_data->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $client_hardware_data->s_grp->editAttributes() ?>>
		<?php echo $client_hardware_data->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $client_hardware_data->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
<?php echo $client_hardware_data->s_grp->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->product->Visible) { // product ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_product"><?php echo $client_hardware_data->product->caption() ?><?php echo ($client_hardware_data->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php $client_hardware_data->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$client_hardware_data->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="client_hardware_data" data-field="x_product" data-value-separator="<?php echo $client_hardware_data->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $client_hardware_data->product->editAttributes() ?>>
		<?php echo $client_hardware_data->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $client_hardware_data->product->Lookup->getParamTag("p_x_product") ?>
<?php echo $client_hardware_data->product->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->rid->Visible) { // rid ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $client_hardware_data->rid->caption() ?><?php echo ($client_hardware_data->rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php
$wrkonchange = "ew.autoFill(this);" . trim(@$client_hardware_data->rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$client_hardware_data->rid->EditAttrs["onchange"] = "";
?>
<span id="as_x_rid" class="text-nowrap" style="z-index: 8860">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?php echo RemoveHtml($client_hardware_data->rid->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($client_hardware_data->rid->getPlaceHolder()) ?>"<?php echo $client_hardware_data->rid->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($client_hardware_data->rid->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_rid',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($client_hardware_data->rid->ReadOnly || $client_hardware_data->rid->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="client_hardware_data" data-field="x_rid" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $client_hardware_data->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?php echo HtmlEncode($client_hardware_data->rid->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fclient_hardware_dataaddopt.createAutoSuggest({"id":"x_rid","forceSelect":true});
</script>
<?php echo $client_hardware_data->rid->Lookup->getParamTag("p_x_rid") ?>
<?php echo $client_hardware_data->rid->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->rid_1->Visible) { // rid_1 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_rid_1"><?php echo $client_hardware_data->rid_1->caption() ?><?php echo ($client_hardware_data->rid_1->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="client_hardware_data" data-field="x_rid_1" name="x_rid_1" id="x_rid_1" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($client_hardware_data->rid_1->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->rid_1->EditValue ?>"<?php echo $client_hardware_data->rid_1->editAttributes() ?>>
<?php echo $client_hardware_data->rid_1->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->harward_code->Visible) { // harward_code ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_harward_code"><?php echo $client_hardware_data->harward_code->caption() ?><?php echo ($client_hardware_data->harward_code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="client_hardware_data" data-field="x_harward_code" name="x_harward_code" id="x_harward_code" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($client_hardware_data->harward_code->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->harward_code->EditValue ?>"<?php echo $client_hardware_data->harward_code->editAttributes() ?>>
<?php echo $client_hardware_data->harward_code->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->serial_no->Visible) { // serial_no ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_serial_no"><?php echo $client_hardware_data->serial_no->caption() ?><?php echo ($client_hardware_data->serial_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="client_hardware_data" data-field="x_serial_no" name="x_serial_no" id="x_serial_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($client_hardware_data->serial_no->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->serial_no->EditValue ?>"<?php echo $client_hardware_data->serial_no->editAttributes() ?>>
<?php echo $client_hardware_data->serial_no->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->invoice_no->Visible) { // invoice_no ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_invoice_no"><?php echo $client_hardware_data->invoice_no->caption() ?><?php echo ($client_hardware_data->invoice_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="client_hardware_data" data-field="x_invoice_no" name="x_invoice_no" id="x_invoice_no" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($client_hardware_data->invoice_no->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->invoice_no->EditValue ?>"<?php echo $client_hardware_data->invoice_no->editAttributes() ?>>
<?php echo $client_hardware_data->invoice_no->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->invoice_date->Visible) { // invoice_date ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_invoice_date"><?php echo $client_hardware_data->invoice_date->caption() ?><?php echo ($client_hardware_data->invoice_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="client_hardware_data" data-field="x_invoice_date" data-format="7" name="x_invoice_date" id="x_invoice_date" placeholder="<?php echo HtmlEncode($client_hardware_data->invoice_date->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->invoice_date->EditValue ?>"<?php echo $client_hardware_data->invoice_date->editAttributes() ?>>
<?php if (!$client_hardware_data->invoice_date->ReadOnly && !$client_hardware_data->invoice_date->Disabled && !isset($client_hardware_data->invoice_date->EditAttrs["readonly"]) && !isset($client_hardware_data->invoice_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fclient_hardware_dataaddopt", "x_invoice_date", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
<?php echo $client_hardware_data->invoice_date->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->first_counter->Visible) { // first_counter ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_first_counter"><?php echo $client_hardware_data->first_counter->caption() ?><?php echo ($client_hardware_data->first_counter->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="client_hardware_data" data-field="x_first_counter" name="x_first_counter" id="x_first_counter" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->first_counter->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->first_counter->EditValue ?>"<?php echo $client_hardware_data->first_counter->editAttributes() ?>>
<?php echo $client_hardware_data->first_counter->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->guarantee->Visible) { // guarantee ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_guarantee"><?php echo $client_hardware_data->guarantee->caption() ?><?php echo ($client_hardware_data->guarantee->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="client_hardware_data" data-field="x_guarantee" data-value-separator="<?php echo $client_hardware_data->guarantee->displayValueSeparatorAttribute() ?>" id="x_guarantee" name="x_guarantee"<?php echo $client_hardware_data->guarantee->editAttributes() ?>>
		<?php echo $client_hardware_data->guarantee->selectOptionListHtml("x_guarantee") ?>
	</select>
</div>
<?php echo $client_hardware_data->guarantee->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->valid_till->Visible) { // valid_till ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_valid_till"><?php echo $client_hardware_data->valid_till->caption() ?><?php echo ($client_hardware_data->valid_till->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="client_hardware_data" data-field="x_valid_till" data-format="7" name="x_valid_till" id="x_valid_till" placeholder="<?php echo HtmlEncode($client_hardware_data->valid_till->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->valid_till->EditValue ?>"<?php echo $client_hardware_data->valid_till->editAttributes() ?>>
<?php if (!$client_hardware_data->valid_till->ReadOnly && !$client_hardware_data->valid_till->Disabled && !isset($client_hardware_data->valid_till->EditAttrs["readonly"]) && !isset($client_hardware_data->valid_till->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fclient_hardware_dataaddopt", "x_valid_till", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
<?php echo $client_hardware_data->valid_till->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->valid_till_counter->Visible) { // valid_till_counter ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_valid_till_counter"><?php echo $client_hardware_data->valid_till_counter->caption() ?><?php echo ($client_hardware_data->valid_till_counter->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="client_hardware_data" data-field="x_valid_till_counter" name="x_valid_till_counter" id="x_valid_till_counter" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->valid_till_counter->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->valid_till_counter->EditValue ?>"<?php echo $client_hardware_data->valid_till_counter->editAttributes() ?>>
<?php echo $client_hardware_data->valid_till_counter->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->free_service->Visible) { // free_service ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_free_service"><?php echo $client_hardware_data->free_service->caption() ?><?php echo ($client_hardware_data->free_service->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="client_hardware_data" data-field="x_free_service" name="x_free_service" id="x_free_service" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->free_service->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->free_service->EditValue ?>"<?php echo $client_hardware_data->free_service->editAttributes() ?>>
<?php echo $client_hardware_data->free_service->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->toner_life->Visible) { // toner_life ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_toner_life"><?php echo $client_hardware_data->toner_life->caption() ?><?php echo ($client_hardware_data->toner_life->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="client_hardware_data" data-field="x_toner_life" name="x_toner_life" id="x_toner_life" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->toner_life->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->toner_life->EditValue ?>"<?php echo $client_hardware_data->toner_life->editAttributes() ?>>
<?php echo $client_hardware_data->toner_life->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->drum_life->Visible) { // drum_life ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_drum_life"><?php echo $client_hardware_data->drum_life->caption() ?><?php echo ($client_hardware_data->drum_life->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="client_hardware_data" data-field="x_drum_life" name="x_drum_life" id="x_drum_life" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->drum_life->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->drum_life->EditValue ?>"<?php echo $client_hardware_data->drum_life->editAttributes() ?>>
<?php echo $client_hardware_data->drum_life->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->developer_life->Visible) { // developer_life ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_developer_life"><?php echo $client_hardware_data->developer_life->caption() ?><?php echo ($client_hardware_data->developer_life->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="client_hardware_data" data-field="x_developer_life" name="x_developer_life" id="x_developer_life" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->developer_life->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->developer_life->EditValue ?>"<?php echo $client_hardware_data->developer_life->editAttributes() ?>>
<?php echo $client_hardware_data->developer_life->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->date_install->Visible) { // date_install ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_date_install"><?php echo $client_hardware_data->date_install->caption() ?><?php echo ($client_hardware_data->date_install->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="client_hardware_data" data-field="x_date_install" data-format="7" name="x_date_install" id="x_date_install" placeholder="<?php echo HtmlEncode($client_hardware_data->date_install->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->date_install->EditValue ?>"<?php echo $client_hardware_data->date_install->editAttributes() ?>>
<?php if (!$client_hardware_data->date_install->ReadOnly && !$client_hardware_data->date_install->Disabled && !isset($client_hardware_data->date_install->EditAttrs["readonly"]) && !isset($client_hardware_data->date_install->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fclient_hardware_dataaddopt", "x_date_install", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
<?php echo $client_hardware_data->date_install->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->date_start->Visible) { // date_start ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_date_start"><?php echo $client_hardware_data->date_start->caption() ?><?php echo ($client_hardware_data->date_start->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="client_hardware_data" data-field="x_date_start" data-format="7" name="x_date_start" id="x_date_start" placeholder="<?php echo HtmlEncode($client_hardware_data->date_start->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->date_start->EditValue ?>"<?php echo $client_hardware_data->date_start->editAttributes() ?>>
<?php if (!$client_hardware_data->date_start->ReadOnly && !$client_hardware_data->date_start->Disabled && !isset($client_hardware_data->date_start->EditAttrs["readonly"]) && !isset($client_hardware_data->date_start->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fclient_hardware_dataaddopt", "x_date_start", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
<?php echo $client_hardware_data->date_start->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->remark->Visible) { // remark ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_remark"><?php echo $client_hardware_data->remark->caption() ?><?php echo ($client_hardware_data->remark->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="client_hardware_data" data-field="x_remark" name="x_remark" id="x_remark" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($client_hardware_data->remark->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->remark->EditValue ?>"<?php echo $client_hardware_data->remark->editAttributes() ?>>
<?php echo $client_hardware_data->remark->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->status->Visible) { // status ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_status"><?php echo $client_hardware_data->status->caption() ?><?php echo ($client_hardware_data->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="client_hardware_data" data-field="x_status" data-value-separator="<?php echo $client_hardware_data->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $client_hardware_data->status->editAttributes() ?>>
		<?php echo $client_hardware_data->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $client_hardware_data->status->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->operator->Visible) { // operator ?>
	<input type="hidden" data-table="client_hardware_data" data-field="x_operator" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($client_hardware_data->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($client_hardware_data->datetime->Visible) { // datetime ?>
	<input type="hidden" data-table="client_hardware_data" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($client_hardware_data->datetime->CurrentValue) ?>">
	<?php if (!$client_hardware_data->datetime->ReadOnly && !$client_hardware_data->datetime->Disabled && !isset($client_hardware_data->datetime->EditAttrs["readonly"]) && !isset($client_hardware_data->datetime->EditAttrs["disabled"])) { ?>
	<script>
	ew.createDateTimePicker("fclient_hardware_dataaddopt", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":7});
	</script>
	<?php } ?>
<?php } ?>
<?php if ($client_hardware_data->copy_average_1->Visible) { // copy_average_1 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_copy_average_1"><?php echo $client_hardware_data->copy_average_1->caption() ?><?php echo ($client_hardware_data->copy_average_1->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="client_hardware_data" data-field="x_copy_average_1" name="x_copy_average_1" id="x_copy_average_1" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->copy_average_1->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->copy_average_1->EditValue ?>"<?php echo $client_hardware_data->copy_average_1->editAttributes() ?>>
<?php echo $client_hardware_data->copy_average_1->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->copy_average_2->Visible) { // copy_average_2 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_copy_average_2"><?php echo $client_hardware_data->copy_average_2->caption() ?><?php echo ($client_hardware_data->copy_average_2->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="client_hardware_data" data-field="x_copy_average_2" name="x_copy_average_2" id="x_copy_average_2" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->copy_average_2->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->copy_average_2->EditValue ?>"<?php echo $client_hardware_data->copy_average_2->editAttributes() ?>>
<?php echo $client_hardware_data->copy_average_2->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->copy_average_3->Visible) { // copy_average_3 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_copy_average_3"><?php echo $client_hardware_data->copy_average_3->caption() ?><?php echo ($client_hardware_data->copy_average_3->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="client_hardware_data" data-field="x_copy_average_3" name="x_copy_average_3" id="x_copy_average_3" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->copy_average_3->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->copy_average_3->EditValue ?>"<?php echo $client_hardware_data->copy_average_3->editAttributes() ?>>
<?php echo $client_hardware_data->copy_average_3->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->schedule_service_type->Visible) { // schedule_service_type ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_schedule_service_type"><?php echo $client_hardware_data->schedule_service_type->caption() ?><?php echo ($client_hardware_data->schedule_service_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="client_hardware_data" data-field="x_schedule_service_type" name="x_schedule_service_type" id="x_schedule_service_type" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->schedule_service_type->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->schedule_service_type->EditValue ?>"<?php echo $client_hardware_data->schedule_service_type->editAttributes() ?>>
<?php echo $client_hardware_data->schedule_service_type->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->schedule_service_interval_days->Visible) { // schedule_service_interval_days ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_schedule_service_interval_days"><?php echo $client_hardware_data->schedule_service_interval_days->caption() ?><?php echo ($client_hardware_data->schedule_service_interval_days->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="client_hardware_data" data-field="x_schedule_service_interval_days" name="x_schedule_service_interval_days" id="x_schedule_service_interval_days" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->schedule_service_interval_days->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->schedule_service_interval_days->EditValue ?>"<?php echo $client_hardware_data->schedule_service_interval_days->editAttributes() ?>>
<?php echo $client_hardware_data->schedule_service_interval_days->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->schedule_service_updated_till->Visible) { // schedule_service_updated_till ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_schedule_service_updated_till"><?php echo $client_hardware_data->schedule_service_updated_till->caption() ?><?php echo ($client_hardware_data->schedule_service_updated_till->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="client_hardware_data" data-field="x_schedule_service_updated_till" name="x_schedule_service_updated_till" id="x_schedule_service_updated_till" placeholder="<?php echo HtmlEncode($client_hardware_data->schedule_service_updated_till->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->schedule_service_updated_till->EditValue ?>"<?php echo $client_hardware_data->schedule_service_updated_till->editAttributes() ?>>
<?php if (!$client_hardware_data->schedule_service_updated_till->ReadOnly && !$client_hardware_data->schedule_service_updated_till->Disabled && !isset($client_hardware_data->schedule_service_updated_till->EditAttrs["readonly"]) && !isset($client_hardware_data->schedule_service_updated_till->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fclient_hardware_dataaddopt", "x_schedule_service_updated_till", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
<?php echo $client_hardware_data->schedule_service_updated_till->CustomMsg ?></div>
	</div>
<?php } ?>
</form>
<?php
$client_hardware_data_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$client_hardware_data_addopt->terminate();
?>