<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$client_hardware_data_edit = new client_hardware_data_edit();

// Run the page
$client_hardware_data_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$client_hardware_data_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fclient_hardware_dataedit = currentForm = new ew.Form("fclient_hardware_dataedit", "edit");

// Validate form
fclient_hardware_dataedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($client_hardware_data_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->id->caption(), $client_hardware_data->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_edit->customer_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_customer_grp[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->customer_grp->caption(), $client_hardware_data->customer_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_edit->ref->Required) { ?>
			elm = this.getElements("x" + infix + "_ref");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->ref->caption(), $client_hardware_data->ref->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_edit->partner_id->Required) { ?>
			elm = this.getElements("x" + infix + "_partner_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->partner_id->caption(), $client_hardware_data->partner_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_edit->name_ref->Required) { ?>
			elm = this.getElements("x" + infix + "_name_ref");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->name_ref->caption(), $client_hardware_data->name_ref->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_edit->city_name->Required) { ?>
			elm = this.getElements("x" + infix + "_city_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->city_name->caption(), $client_hardware_data->city_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_edit->area->Required) { ?>
			elm = this.getElements("x" + infix + "_area");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->area->caption(), $client_hardware_data->area->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_edit->billing_name->Required) { ?>
			elm = this.getElements("x" + infix + "_billing_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->billing_name->caption(), $client_hardware_data->billing_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_edit->address->Required) { ?>
			elm = this.getElements("x" + infix + "_address");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->address->caption(), $client_hardware_data->address->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_edit->personal_ref->Required) { ?>
			elm = this.getElements("x" + infix + "_personal_ref[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->personal_ref->caption(), $client_hardware_data->personal_ref->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->grp->caption(), $client_hardware_data->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_edit->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->s_grp->caption(), $client_hardware_data->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_edit->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->product->caption(), $client_hardware_data->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_edit->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->rid->caption(), $client_hardware_data->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_edit->rid_1->Required) { ?>
			elm = this.getElements("x" + infix + "_rid_1");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->rid_1->caption(), $client_hardware_data->rid_1->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_edit->harward_code->Required) { ?>
			elm = this.getElements("x" + infix + "_harward_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->harward_code->caption(), $client_hardware_data->harward_code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_edit->serial_no->Required) { ?>
			elm = this.getElements("x" + infix + "_serial_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->serial_no->caption(), $client_hardware_data->serial_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_edit->invoice_no->Required) { ?>
			elm = this.getElements("x" + infix + "_invoice_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->invoice_no->caption(), $client_hardware_data->invoice_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_edit->invoice_date->Required) { ?>
			elm = this.getElements("x" + infix + "_invoice_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->invoice_date->caption(), $client_hardware_data->invoice_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_invoice_date");
			if (elm && !ew.checkEuroDate(elm.value))
				return this.onError(elm, "<?php echo JsEncode($client_hardware_data->invoice_date->errorMessage()) ?>");
		<?php if ($client_hardware_data_edit->first_counter->Required) { ?>
			elm = this.getElements("x" + infix + "_first_counter");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->first_counter->caption(), $client_hardware_data->first_counter->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_first_counter");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($client_hardware_data->first_counter->errorMessage()) ?>");
		<?php if ($client_hardware_data_edit->guarantee->Required) { ?>
			elm = this.getElements("x" + infix + "_guarantee");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->guarantee->caption(), $client_hardware_data->guarantee->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_edit->valid_till->Required) { ?>
			elm = this.getElements("x" + infix + "_valid_till");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->valid_till->caption(), $client_hardware_data->valid_till->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_valid_till");
			if (elm && !ew.checkEuroDate(elm.value))
				return this.onError(elm, "<?php echo JsEncode($client_hardware_data->valid_till->errorMessage()) ?>");
		<?php if ($client_hardware_data_edit->valid_till_counter->Required) { ?>
			elm = this.getElements("x" + infix + "_valid_till_counter");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->valid_till_counter->caption(), $client_hardware_data->valid_till_counter->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_valid_till_counter");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($client_hardware_data->valid_till_counter->errorMessage()) ?>");
		<?php if ($client_hardware_data_edit->free_service->Required) { ?>
			elm = this.getElements("x" + infix + "_free_service");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->free_service->caption(), $client_hardware_data->free_service->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_free_service");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($client_hardware_data->free_service->errorMessage()) ?>");
		<?php if ($client_hardware_data_edit->toner_life->Required) { ?>
			elm = this.getElements("x" + infix + "_toner_life");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->toner_life->caption(), $client_hardware_data->toner_life->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_toner_life");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($client_hardware_data->toner_life->errorMessage()) ?>");
		<?php if ($client_hardware_data_edit->drum_life->Required) { ?>
			elm = this.getElements("x" + infix + "_drum_life");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->drum_life->caption(), $client_hardware_data->drum_life->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_drum_life");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($client_hardware_data->drum_life->errorMessage()) ?>");
		<?php if ($client_hardware_data_edit->developer_life->Required) { ?>
			elm = this.getElements("x" + infix + "_developer_life");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->developer_life->caption(), $client_hardware_data->developer_life->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_developer_life");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($client_hardware_data->developer_life->errorMessage()) ?>");
		<?php if ($client_hardware_data_edit->date_install->Required) { ?>
			elm = this.getElements("x" + infix + "_date_install");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->date_install->caption(), $client_hardware_data->date_install->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_date_install");
			if (elm && !ew.checkEuroDate(elm.value))
				return this.onError(elm, "<?php echo JsEncode($client_hardware_data->date_install->errorMessage()) ?>");
		<?php if ($client_hardware_data_edit->date_start->Required) { ?>
			elm = this.getElements("x" + infix + "_date_start");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->date_start->caption(), $client_hardware_data->date_start->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_date_start");
			if (elm && !ew.checkEuroDate(elm.value))
				return this.onError(elm, "<?php echo JsEncode($client_hardware_data->date_start->errorMessage()) ?>");
		<?php if ($client_hardware_data_edit->remark->Required) { ?>
			elm = this.getElements("x" + infix + "_remark");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->remark->caption(), $client_hardware_data->remark->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->status->caption(), $client_hardware_data->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->operator->caption(), $client_hardware_data->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->datetime->caption(), $client_hardware_data->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($client_hardware_data_edit->copy_average_1->Required) { ?>
			elm = this.getElements("x" + infix + "_copy_average_1");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->copy_average_1->caption(), $client_hardware_data->copy_average_1->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_copy_average_1");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($client_hardware_data->copy_average_1->errorMessage()) ?>");
		<?php if ($client_hardware_data_edit->copy_average_2->Required) { ?>
			elm = this.getElements("x" + infix + "_copy_average_2");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->copy_average_2->caption(), $client_hardware_data->copy_average_2->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_copy_average_2");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($client_hardware_data->copy_average_2->errorMessage()) ?>");
		<?php if ($client_hardware_data_edit->copy_average_3->Required) { ?>
			elm = this.getElements("x" + infix + "_copy_average_3");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->copy_average_3->caption(), $client_hardware_data->copy_average_3->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_copy_average_3");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($client_hardware_data->copy_average_3->errorMessage()) ?>");
		<?php if ($client_hardware_data_edit->schedule_service_type->Required) { ?>
			elm = this.getElements("x" + infix + "_schedule_service_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->schedule_service_type->caption(), $client_hardware_data->schedule_service_type->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_schedule_service_type");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($client_hardware_data->schedule_service_type->errorMessage()) ?>");
		<?php if ($client_hardware_data_edit->schedule_service_interval_days->Required) { ?>
			elm = this.getElements("x" + infix + "_schedule_service_interval_days");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->schedule_service_interval_days->caption(), $client_hardware_data->schedule_service_interval_days->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_schedule_service_interval_days");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($client_hardware_data->schedule_service_interval_days->errorMessage()) ?>");
		<?php if ($client_hardware_data_edit->schedule_service_updated_till->Required) { ?>
			elm = this.getElements("x" + infix + "_schedule_service_updated_till");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $client_hardware_data->schedule_service_updated_till->caption(), $client_hardware_data->schedule_service_updated_till->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_schedule_service_updated_till");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($client_hardware_data->schedule_service_updated_till->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fclient_hardware_dataedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fclient_hardware_dataedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fclient_hardware_dataedit.lists["x_customer_grp[]"] = <?php echo $client_hardware_data_edit->customer_grp->Lookup->toClientList() ?>;
fclient_hardware_dataedit.lists["x_customer_grp[]"].options = <?php echo JsonEncode($client_hardware_data_edit->customer_grp->lookupOptions()) ?>;
fclient_hardware_dataedit.lists["x_partner_id"] = <?php echo $client_hardware_data_edit->partner_id->Lookup->toClientList() ?>;
fclient_hardware_dataedit.lists["x_partner_id"].options = <?php echo JsonEncode($client_hardware_data_edit->partner_id->lookupOptions()) ?>;
fclient_hardware_dataedit.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fclient_hardware_dataedit.lists["x_area"] = <?php echo $client_hardware_data_edit->area->Lookup->toClientList() ?>;
fclient_hardware_dataedit.lists["x_area"].options = <?php echo JsonEncode($client_hardware_data_edit->area->lookupOptions()) ?>;
fclient_hardware_dataedit.autoSuggests["x_area"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fclient_hardware_dataedit.lists["x_personal_ref[]"] = <?php echo $client_hardware_data_edit->personal_ref->Lookup->toClientList() ?>;
fclient_hardware_dataedit.lists["x_personal_ref[]"].options = <?php echo JsonEncode($client_hardware_data_edit->personal_ref->lookupOptions()) ?>;
fclient_hardware_dataedit.lists["x_grp"] = <?php echo $client_hardware_data_edit->grp->Lookup->toClientList() ?>;
fclient_hardware_dataedit.lists["x_grp"].options = <?php echo JsonEncode($client_hardware_data_edit->grp->lookupOptions()) ?>;
fclient_hardware_dataedit.lists["x_s_grp"] = <?php echo $client_hardware_data_edit->s_grp->Lookup->toClientList() ?>;
fclient_hardware_dataedit.lists["x_s_grp"].options = <?php echo JsonEncode($client_hardware_data_edit->s_grp->lookupOptions()) ?>;
fclient_hardware_dataedit.lists["x_product"] = <?php echo $client_hardware_data_edit->product->Lookup->toClientList() ?>;
fclient_hardware_dataedit.lists["x_product"].options = <?php echo JsonEncode($client_hardware_data_edit->product->lookupOptions()) ?>;
fclient_hardware_dataedit.lists["x_rid"] = <?php echo $client_hardware_data_edit->rid->Lookup->toClientList() ?>;
fclient_hardware_dataedit.lists["x_rid"].options = <?php echo JsonEncode($client_hardware_data_edit->rid->lookupOptions()) ?>;
fclient_hardware_dataedit.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fclient_hardware_dataedit.lists["x_guarantee"] = <?php echo $client_hardware_data_edit->guarantee->Lookup->toClientList() ?>;
fclient_hardware_dataedit.lists["x_guarantee"].options = <?php echo JsonEncode($client_hardware_data_edit->guarantee->options(FALSE, TRUE)) ?>;
fclient_hardware_dataedit.lists["x_status"] = <?php echo $client_hardware_data_edit->status->Lookup->toClientList() ?>;
fclient_hardware_dataedit.lists["x_status"].options = <?php echo JsonEncode($client_hardware_data_edit->status->options(FALSE, TRUE)) ?>;
fclient_hardware_dataedit.lists["x_operator"] = <?php echo $client_hardware_data_edit->operator->Lookup->toClientList() ?>;
fclient_hardware_dataedit.lists["x_operator"].options = <?php echo JsonEncode($client_hardware_data_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $client_hardware_data_edit->showPageHeader(); ?>
<?php
$client_hardware_data_edit->showMessage();
?>
<?php if (!$client_hardware_data_edit->IsModal) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($client_hardware_data_edit->Pager)) $client_hardware_data_edit->Pager = new PrevNextPager($client_hardware_data_edit->StartRec, $client_hardware_data_edit->DisplayRecs, $client_hardware_data_edit->TotalRecs, $client_hardware_data_edit->AutoHidePager) ?>
<?php if ($client_hardware_data_edit->Pager->RecordCount > 0 && $client_hardware_data_edit->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($client_hardware_data_edit->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $client_hardware_data_edit->pageUrl() ?>start=<?php echo $client_hardware_data_edit->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($client_hardware_data_edit->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $client_hardware_data_edit->pageUrl() ?>start=<?php echo $client_hardware_data_edit->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $client_hardware_data_edit->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($client_hardware_data_edit->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $client_hardware_data_edit->pageUrl() ?>start=<?php echo $client_hardware_data_edit->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($client_hardware_data_edit->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $client_hardware_data_edit->pageUrl() ?>start=<?php echo $client_hardware_data_edit->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $client_hardware_data_edit->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<form name="fclient_hardware_dataedit" id="fclient_hardware_dataedit" class="<?php echo $client_hardware_data_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($client_hardware_data_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $client_hardware_data_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="client_hardware_data">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$client_hardware_data_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($client_hardware_data->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_client_hardware_data_id" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->id->caption() ?><?php echo ($client_hardware_data->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->id->cellAttributes() ?>>
<span id="el_client_hardware_data_id">
<span<?php echo $client_hardware_data->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($client_hardware_data->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="client_hardware_data" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($client_hardware_data->id->CurrentValue) ?>">
<?php echo $client_hardware_data->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->customer_grp->Visible) { // customer_grp ?>
	<div id="r_customer_grp" class="form-group row">
		<label id="elh_client_hardware_data_customer_grp" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->customer_grp->caption() ?><?php echo ($client_hardware_data->customer_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->customer_grp->cellAttributes() ?>>
<span id="el_client_hardware_data_customer_grp">
<div id="tp_x_customer_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="client_hardware_data" data-field="x_customer_grp" data-value-separator="<?php echo $client_hardware_data->customer_grp->displayValueSeparatorAttribute() ?>" name="x_customer_grp[]" id="x_customer_grp[]" value="{value}"<?php echo $client_hardware_data->customer_grp->editAttributes() ?>></div>
<div id="dsl_x_customer_grp" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $client_hardware_data->customer_grp->checkBoxListHtml(FALSE, "x_customer_grp[]") ?>
</div></div>
<?php echo $client_hardware_data->customer_grp->Lookup->getParamTag("p_x_customer_grp") ?>
<?php if (AllowAdd(CurrentProjectID() . "client_category") && !$client_hardware_data->customer_grp->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_customer_grp" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $client_hardware_data->customer_grp->caption() ?>" data-title="<?php echo $client_hardware_data->customer_grp->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_customer_grp[]',url:'client_categoryaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</span>
<?php echo $client_hardware_data->customer_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->ref->Visible) { // ref ?>
	<div id="r_ref" class="form-group row">
		<label id="elh_client_hardware_data_ref" for="x_ref" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->ref->caption() ?><?php echo ($client_hardware_data->ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->ref->cellAttributes() ?>>
<span id="el_client_hardware_data_ref">
<input type="text" data-table="client_hardware_data" data-field="x_ref" name="x_ref" id="x_ref" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($client_hardware_data->ref->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->ref->EditValue ?>"<?php echo $client_hardware_data->ref->editAttributes() ?>>
</span>
<?php echo $client_hardware_data->ref->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->partner_id->Visible) { // partner_id ?>
	<div id="r_partner_id" class="form-group row">
		<label id="elh_client_hardware_data_partner_id" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->partner_id->caption() ?><?php echo ($client_hardware_data->partner_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->partner_id->cellAttributes() ?>>
<span id="el_client_hardware_data_partner_id">
<?php
$wrkonchange = "ew.autoFill(this);" . trim(@$client_hardware_data->partner_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$client_hardware_data->partner_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_partner_id" class="text-nowrap" style="z-index: 8960">
	<input type="text" class="form-control" name="sv_x_partner_id" id="sv_x_partner_id" value="<?php echo RemoveHtml($client_hardware_data->partner_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->partner_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($client_hardware_data->partner_id->getPlaceHolder()) ?>"<?php echo $client_hardware_data->partner_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="client_hardware_data" data-field="x_partner_id" data-value-separator="<?php echo $client_hardware_data->partner_id->displayValueSeparatorAttribute() ?>" name="x_partner_id" id="x_partner_id" value="<?php echo HtmlEncode($client_hardware_data->partner_id->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fclient_hardware_dataedit.createAutoSuggest({"id":"x_partner_id","forceSelect":true});
</script>
<?php echo $client_hardware_data->partner_id->Lookup->getParamTag("p_x_partner_id") ?>
</span>
<?php echo $client_hardware_data->partner_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->name_ref->Visible) { // name_ref ?>
	<div id="r_name_ref" class="form-group row">
		<label id="elh_client_hardware_data_name_ref" for="x_name_ref" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->name_ref->caption() ?><?php echo ($client_hardware_data->name_ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->name_ref->cellAttributes() ?>>
<span id="el_client_hardware_data_name_ref">
<input type="text" data-table="client_hardware_data" data-field="x_name_ref" name="x_name_ref" id="x_name_ref" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($client_hardware_data->name_ref->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->name_ref->EditValue ?>"<?php echo $client_hardware_data->name_ref->editAttributes() ?>>
</span>
<?php echo $client_hardware_data->name_ref->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->city_name->Visible) { // city_name ?>
	<div id="r_city_name" class="form-group row">
		<label id="elh_client_hardware_data_city_name" for="x_city_name" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->city_name->caption() ?><?php echo ($client_hardware_data->city_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->city_name->cellAttributes() ?>>
<span id="el_client_hardware_data_city_name">
<input type="text" data-table="client_hardware_data" data-field="x_city_name" name="x_city_name" id="x_city_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($client_hardware_data->city_name->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->city_name->EditValue ?>"<?php echo $client_hardware_data->city_name->editAttributes() ?>>
</span>
<?php echo $client_hardware_data->city_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->area->Visible) { // area ?>
	<div id="r_area" class="form-group row">
		<label id="elh_client_hardware_data_area" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->area->caption() ?><?php echo ($client_hardware_data->area->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->area->cellAttributes() ?>>
<span id="el_client_hardware_data_area">
<?php
$wrkonchange = "" . trim(@$client_hardware_data->area->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$client_hardware_data->area->EditAttrs["onchange"] = "";
?>
<span id="as_x_area" class="text-nowrap" style="z-index: 8930">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_area" id="sv_x_area" value="<?php echo RemoveHtml($client_hardware_data->area->EditValue) ?>" placeholder="<?php echo HtmlEncode($client_hardware_data->area->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($client_hardware_data->area->getPlaceHolder()) ?>"<?php echo $client_hardware_data->area->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($client_hardware_data->area->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_area',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($client_hardware_data->area->ReadOnly || $client_hardware_data->area->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="client_hardware_data" data-field="x_area" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $client_hardware_data->area->displayValueSeparatorAttribute() ?>" name="x_area" id="x_area" value="<?php echo HtmlEncode($client_hardware_data->area->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fclient_hardware_dataedit.createAutoSuggest({"id":"x_area","forceSelect":false});
</script>
<?php echo $client_hardware_data->area->Lookup->getParamTag("p_x_area") ?>
</span>
<?php echo $client_hardware_data->area->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->billing_name->Visible) { // billing_name ?>
	<div id="r_billing_name" class="form-group row">
		<label id="elh_client_hardware_data_billing_name" for="x_billing_name" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->billing_name->caption() ?><?php echo ($client_hardware_data->billing_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->billing_name->cellAttributes() ?>>
<span id="el_client_hardware_data_billing_name">
<input type="text" data-table="client_hardware_data" data-field="x_billing_name" name="x_billing_name" id="x_billing_name" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->billing_name->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->billing_name->EditValue ?>"<?php echo $client_hardware_data->billing_name->editAttributes() ?>>
</span>
<?php echo $client_hardware_data->billing_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->address->Visible) { // address ?>
	<div id="r_address" class="form-group row">
		<label id="elh_client_hardware_data_address" for="x_address" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->address->caption() ?><?php echo ($client_hardware_data->address->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->address->cellAttributes() ?>>
<span id="el_client_hardware_data_address">
<textarea data-table="client_hardware_data" data-field="x_address" name="x_address" id="x_address" cols="35" rows="4" placeholder="<?php echo HtmlEncode($client_hardware_data->address->getPlaceHolder()) ?>"<?php echo $client_hardware_data->address->editAttributes() ?>><?php echo $client_hardware_data->address->EditValue ?></textarea>
</span>
<?php echo $client_hardware_data->address->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->personal_ref->Visible) { // personal_ref ?>
	<div id="r_personal_ref" class="form-group row">
		<label id="elh_client_hardware_data_personal_ref" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->personal_ref->caption() ?><?php echo ($client_hardware_data->personal_ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->personal_ref->cellAttributes() ?>>
<span id="el_client_hardware_data_personal_ref">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_personal_ref"><?php echo strval($client_hardware_data->personal_ref->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($client_hardware_data->personal_ref->ViewValue) : $client_hardware_data->personal_ref->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($client_hardware_data->personal_ref->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($client_hardware_data->personal_ref->ReadOnly || $client_hardware_data->personal_ref->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_personal_ref[]',m:1,n:10});"><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "personal_info") && !$client_hardware_data->personal_ref->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_personal_ref" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $client_hardware_data->personal_ref->caption() ?>" data-title="<?php echo $client_hardware_data->personal_ref->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_personal_ref[]',url:'personal_infoaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
	</div>
</div>
<?php echo $client_hardware_data->personal_ref->Lookup->getParamTag("p_x_personal_ref") ?>
<input type="hidden" data-table="client_hardware_data" data-field="x_personal_ref" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $client_hardware_data->personal_ref->displayValueSeparatorAttribute() ?>" name="x_personal_ref[]" id="x_personal_ref[]" value="<?php echo $client_hardware_data->personal_ref->CurrentValue ?>"<?php echo $client_hardware_data->personal_ref->editAttributes() ?>>
</span>
<?php echo $client_hardware_data->personal_ref->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_client_hardware_data_grp" for="x_grp" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->grp->caption() ?><?php echo ($client_hardware_data->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->grp->cellAttributes() ?>>
<span id="el_client_hardware_data_grp">
<?php $client_hardware_data->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$client_hardware_data->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="client_hardware_data" data-field="x_grp" data-value-separator="<?php echo $client_hardware_data->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $client_hardware_data->grp->editAttributes() ?>>
		<?php echo $client_hardware_data->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $client_hardware_data->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $client_hardware_data->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label id="elh_client_hardware_data_s_grp" for="x_s_grp" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->s_grp->caption() ?><?php echo ($client_hardware_data->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->s_grp->cellAttributes() ?>>
<span id="el_client_hardware_data_s_grp">
<?php $client_hardware_data->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$client_hardware_data->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="client_hardware_data" data-field="x_s_grp" data-value-separator="<?php echo $client_hardware_data->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $client_hardware_data->s_grp->editAttributes() ?>>
		<?php echo $client_hardware_data->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $client_hardware_data->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
<?php echo $client_hardware_data->s_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_client_hardware_data_product" for="x_product" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->product->caption() ?><?php echo ($client_hardware_data->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->product->cellAttributes() ?>>
<span id="el_client_hardware_data_product">
<?php $client_hardware_data->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$client_hardware_data->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="client_hardware_data" data-field="x_product" data-value-separator="<?php echo $client_hardware_data->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $client_hardware_data->product->editAttributes() ?>>
		<?php echo $client_hardware_data->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $client_hardware_data->product->Lookup->getParamTag("p_x_product") ?>
</span>
<?php echo $client_hardware_data->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label id="elh_client_hardware_data_rid" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->rid->caption() ?><?php echo ($client_hardware_data->rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->rid->cellAttributes() ?>>
<span id="el_client_hardware_data_rid">
<?php
$wrkonchange = "ew.autoFill(this);" . trim(@$client_hardware_data->rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$client_hardware_data->rid->EditAttrs["onchange"] = "";
?>
<span id="as_x_rid" class="text-nowrap" style="z-index: 8860">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?php echo RemoveHtml($client_hardware_data->rid->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($client_hardware_data->rid->getPlaceHolder()) ?>"<?php echo $client_hardware_data->rid->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($client_hardware_data->rid->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_rid',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($client_hardware_data->rid->ReadOnly || $client_hardware_data->rid->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="client_hardware_data" data-field="x_rid" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $client_hardware_data->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?php echo HtmlEncode($client_hardware_data->rid->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fclient_hardware_dataedit.createAutoSuggest({"id":"x_rid","forceSelect":true});
</script>
<?php echo $client_hardware_data->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
<?php echo $client_hardware_data->rid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->rid_1->Visible) { // rid_1 ?>
	<div id="r_rid_1" class="form-group row">
		<label id="elh_client_hardware_data_rid_1" for="x_rid_1" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->rid_1->caption() ?><?php echo ($client_hardware_data->rid_1->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->rid_1->cellAttributes() ?>>
<span id="el_client_hardware_data_rid_1">
<input type="text" data-table="client_hardware_data" data-field="x_rid_1" name="x_rid_1" id="x_rid_1" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($client_hardware_data->rid_1->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->rid_1->EditValue ?>"<?php echo $client_hardware_data->rid_1->editAttributes() ?>>
</span>
<?php echo $client_hardware_data->rid_1->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->harward_code->Visible) { // harward_code ?>
	<div id="r_harward_code" class="form-group row">
		<label id="elh_client_hardware_data_harward_code" for="x_harward_code" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->harward_code->caption() ?><?php echo ($client_hardware_data->harward_code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->harward_code->cellAttributes() ?>>
<span id="el_client_hardware_data_harward_code">
<input type="text" data-table="client_hardware_data" data-field="x_harward_code" name="x_harward_code" id="x_harward_code" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($client_hardware_data->harward_code->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->harward_code->EditValue ?>"<?php echo $client_hardware_data->harward_code->editAttributes() ?>>
</span>
<?php echo $client_hardware_data->harward_code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->serial_no->Visible) { // serial_no ?>
	<div id="r_serial_no" class="form-group row">
		<label id="elh_client_hardware_data_serial_no" for="x_serial_no" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->serial_no->caption() ?><?php echo ($client_hardware_data->serial_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->serial_no->cellAttributes() ?>>
<span id="el_client_hardware_data_serial_no">
<input type="text" data-table="client_hardware_data" data-field="x_serial_no" name="x_serial_no" id="x_serial_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($client_hardware_data->serial_no->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->serial_no->EditValue ?>"<?php echo $client_hardware_data->serial_no->editAttributes() ?>>
</span>
<?php echo $client_hardware_data->serial_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->invoice_no->Visible) { // invoice_no ?>
	<div id="r_invoice_no" class="form-group row">
		<label id="elh_client_hardware_data_invoice_no" for="x_invoice_no" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->invoice_no->caption() ?><?php echo ($client_hardware_data->invoice_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->invoice_no->cellAttributes() ?>>
<span id="el_client_hardware_data_invoice_no">
<input type="text" data-table="client_hardware_data" data-field="x_invoice_no" name="x_invoice_no" id="x_invoice_no" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($client_hardware_data->invoice_no->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->invoice_no->EditValue ?>"<?php echo $client_hardware_data->invoice_no->editAttributes() ?>>
</span>
<?php echo $client_hardware_data->invoice_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->invoice_date->Visible) { // invoice_date ?>
	<div id="r_invoice_date" class="form-group row">
		<label id="elh_client_hardware_data_invoice_date" for="x_invoice_date" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->invoice_date->caption() ?><?php echo ($client_hardware_data->invoice_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->invoice_date->cellAttributes() ?>>
<span id="el_client_hardware_data_invoice_date">
<input type="text" data-table="client_hardware_data" data-field="x_invoice_date" data-format="7" name="x_invoice_date" id="x_invoice_date" placeholder="<?php echo HtmlEncode($client_hardware_data->invoice_date->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->invoice_date->EditValue ?>"<?php echo $client_hardware_data->invoice_date->editAttributes() ?>>
<?php if (!$client_hardware_data->invoice_date->ReadOnly && !$client_hardware_data->invoice_date->Disabled && !isset($client_hardware_data->invoice_date->EditAttrs["readonly"]) && !isset($client_hardware_data->invoice_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fclient_hardware_dataedit", "x_invoice_date", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
<?php echo $client_hardware_data->invoice_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->first_counter->Visible) { // first_counter ?>
	<div id="r_first_counter" class="form-group row">
		<label id="elh_client_hardware_data_first_counter" for="x_first_counter" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->first_counter->caption() ?><?php echo ($client_hardware_data->first_counter->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->first_counter->cellAttributes() ?>>
<span id="el_client_hardware_data_first_counter">
<input type="text" data-table="client_hardware_data" data-field="x_first_counter" name="x_first_counter" id="x_first_counter" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->first_counter->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->first_counter->EditValue ?>"<?php echo $client_hardware_data->first_counter->editAttributes() ?>>
</span>
<?php echo $client_hardware_data->first_counter->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->guarantee->Visible) { // guarantee ?>
	<div id="r_guarantee" class="form-group row">
		<label id="elh_client_hardware_data_guarantee" for="x_guarantee" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->guarantee->caption() ?><?php echo ($client_hardware_data->guarantee->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->guarantee->cellAttributes() ?>>
<span id="el_client_hardware_data_guarantee">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="client_hardware_data" data-field="x_guarantee" data-value-separator="<?php echo $client_hardware_data->guarantee->displayValueSeparatorAttribute() ?>" id="x_guarantee" name="x_guarantee"<?php echo $client_hardware_data->guarantee->editAttributes() ?>>
		<?php echo $client_hardware_data->guarantee->selectOptionListHtml("x_guarantee") ?>
	</select>
</div>
</span>
<?php echo $client_hardware_data->guarantee->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->valid_till->Visible) { // valid_till ?>
	<div id="r_valid_till" class="form-group row">
		<label id="elh_client_hardware_data_valid_till" for="x_valid_till" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->valid_till->caption() ?><?php echo ($client_hardware_data->valid_till->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->valid_till->cellAttributes() ?>>
<span id="el_client_hardware_data_valid_till">
<input type="text" data-table="client_hardware_data" data-field="x_valid_till" data-format="7" name="x_valid_till" id="x_valid_till" placeholder="<?php echo HtmlEncode($client_hardware_data->valid_till->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->valid_till->EditValue ?>"<?php echo $client_hardware_data->valid_till->editAttributes() ?>>
<?php if (!$client_hardware_data->valid_till->ReadOnly && !$client_hardware_data->valid_till->Disabled && !isset($client_hardware_data->valid_till->EditAttrs["readonly"]) && !isset($client_hardware_data->valid_till->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fclient_hardware_dataedit", "x_valid_till", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
<?php echo $client_hardware_data->valid_till->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->valid_till_counter->Visible) { // valid_till_counter ?>
	<div id="r_valid_till_counter" class="form-group row">
		<label id="elh_client_hardware_data_valid_till_counter" for="x_valid_till_counter" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->valid_till_counter->caption() ?><?php echo ($client_hardware_data->valid_till_counter->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->valid_till_counter->cellAttributes() ?>>
<span id="el_client_hardware_data_valid_till_counter">
<input type="text" data-table="client_hardware_data" data-field="x_valid_till_counter" name="x_valid_till_counter" id="x_valid_till_counter" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->valid_till_counter->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->valid_till_counter->EditValue ?>"<?php echo $client_hardware_data->valid_till_counter->editAttributes() ?>>
</span>
<?php echo $client_hardware_data->valid_till_counter->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->free_service->Visible) { // free_service ?>
	<div id="r_free_service" class="form-group row">
		<label id="elh_client_hardware_data_free_service" for="x_free_service" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->free_service->caption() ?><?php echo ($client_hardware_data->free_service->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->free_service->cellAttributes() ?>>
<span id="el_client_hardware_data_free_service">
<input type="text" data-table="client_hardware_data" data-field="x_free_service" name="x_free_service" id="x_free_service" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->free_service->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->free_service->EditValue ?>"<?php echo $client_hardware_data->free_service->editAttributes() ?>>
</span>
<?php echo $client_hardware_data->free_service->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->toner_life->Visible) { // toner_life ?>
	<div id="r_toner_life" class="form-group row">
		<label id="elh_client_hardware_data_toner_life" for="x_toner_life" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->toner_life->caption() ?><?php echo ($client_hardware_data->toner_life->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->toner_life->cellAttributes() ?>>
<span id="el_client_hardware_data_toner_life">
<input type="text" data-table="client_hardware_data" data-field="x_toner_life" name="x_toner_life" id="x_toner_life" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->toner_life->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->toner_life->EditValue ?>"<?php echo $client_hardware_data->toner_life->editAttributes() ?>>
</span>
<?php echo $client_hardware_data->toner_life->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->drum_life->Visible) { // drum_life ?>
	<div id="r_drum_life" class="form-group row">
		<label id="elh_client_hardware_data_drum_life" for="x_drum_life" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->drum_life->caption() ?><?php echo ($client_hardware_data->drum_life->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->drum_life->cellAttributes() ?>>
<span id="el_client_hardware_data_drum_life">
<input type="text" data-table="client_hardware_data" data-field="x_drum_life" name="x_drum_life" id="x_drum_life" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->drum_life->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->drum_life->EditValue ?>"<?php echo $client_hardware_data->drum_life->editAttributes() ?>>
</span>
<?php echo $client_hardware_data->drum_life->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->developer_life->Visible) { // developer_life ?>
	<div id="r_developer_life" class="form-group row">
		<label id="elh_client_hardware_data_developer_life" for="x_developer_life" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->developer_life->caption() ?><?php echo ($client_hardware_data->developer_life->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->developer_life->cellAttributes() ?>>
<span id="el_client_hardware_data_developer_life">
<input type="text" data-table="client_hardware_data" data-field="x_developer_life" name="x_developer_life" id="x_developer_life" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->developer_life->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->developer_life->EditValue ?>"<?php echo $client_hardware_data->developer_life->editAttributes() ?>>
</span>
<?php echo $client_hardware_data->developer_life->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->date_install->Visible) { // date_install ?>
	<div id="r_date_install" class="form-group row">
		<label id="elh_client_hardware_data_date_install" for="x_date_install" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->date_install->caption() ?><?php echo ($client_hardware_data->date_install->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->date_install->cellAttributes() ?>>
<span id="el_client_hardware_data_date_install">
<input type="text" data-table="client_hardware_data" data-field="x_date_install" data-format="7" name="x_date_install" id="x_date_install" placeholder="<?php echo HtmlEncode($client_hardware_data->date_install->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->date_install->EditValue ?>"<?php echo $client_hardware_data->date_install->editAttributes() ?>>
<?php if (!$client_hardware_data->date_install->ReadOnly && !$client_hardware_data->date_install->Disabled && !isset($client_hardware_data->date_install->EditAttrs["readonly"]) && !isset($client_hardware_data->date_install->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fclient_hardware_dataedit", "x_date_install", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
<?php echo $client_hardware_data->date_install->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->date_start->Visible) { // date_start ?>
	<div id="r_date_start" class="form-group row">
		<label id="elh_client_hardware_data_date_start" for="x_date_start" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->date_start->caption() ?><?php echo ($client_hardware_data->date_start->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->date_start->cellAttributes() ?>>
<span id="el_client_hardware_data_date_start">
<input type="text" data-table="client_hardware_data" data-field="x_date_start" data-format="7" name="x_date_start" id="x_date_start" placeholder="<?php echo HtmlEncode($client_hardware_data->date_start->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->date_start->EditValue ?>"<?php echo $client_hardware_data->date_start->editAttributes() ?>>
<?php if (!$client_hardware_data->date_start->ReadOnly && !$client_hardware_data->date_start->Disabled && !isset($client_hardware_data->date_start->EditAttrs["readonly"]) && !isset($client_hardware_data->date_start->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fclient_hardware_dataedit", "x_date_start", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
<?php echo $client_hardware_data->date_start->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->remark->Visible) { // remark ?>
	<div id="r_remark" class="form-group row">
		<label id="elh_client_hardware_data_remark" for="x_remark" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->remark->caption() ?><?php echo ($client_hardware_data->remark->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->remark->cellAttributes() ?>>
<span id="el_client_hardware_data_remark">
<input type="text" data-table="client_hardware_data" data-field="x_remark" name="x_remark" id="x_remark" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($client_hardware_data->remark->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->remark->EditValue ?>"<?php echo $client_hardware_data->remark->editAttributes() ?>>
</span>
<?php echo $client_hardware_data->remark->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_client_hardware_data_status" for="x_status" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->status->caption() ?><?php echo ($client_hardware_data->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->status->cellAttributes() ?>>
<span id="el_client_hardware_data_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="client_hardware_data" data-field="x_status" data-value-separator="<?php echo $client_hardware_data->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $client_hardware_data->status->editAttributes() ?>>
		<?php echo $client_hardware_data->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $client_hardware_data->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->copy_average_1->Visible) { // copy_average_1 ?>
	<div id="r_copy_average_1" class="form-group row">
		<label id="elh_client_hardware_data_copy_average_1" for="x_copy_average_1" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->copy_average_1->caption() ?><?php echo ($client_hardware_data->copy_average_1->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->copy_average_1->cellAttributes() ?>>
<span id="el_client_hardware_data_copy_average_1">
<input type="text" data-table="client_hardware_data" data-field="x_copy_average_1" name="x_copy_average_1" id="x_copy_average_1" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->copy_average_1->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->copy_average_1->EditValue ?>"<?php echo $client_hardware_data->copy_average_1->editAttributes() ?>>
</span>
<?php echo $client_hardware_data->copy_average_1->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->copy_average_2->Visible) { // copy_average_2 ?>
	<div id="r_copy_average_2" class="form-group row">
		<label id="elh_client_hardware_data_copy_average_2" for="x_copy_average_2" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->copy_average_2->caption() ?><?php echo ($client_hardware_data->copy_average_2->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->copy_average_2->cellAttributes() ?>>
<span id="el_client_hardware_data_copy_average_2">
<input type="text" data-table="client_hardware_data" data-field="x_copy_average_2" name="x_copy_average_2" id="x_copy_average_2" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->copy_average_2->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->copy_average_2->EditValue ?>"<?php echo $client_hardware_data->copy_average_2->editAttributes() ?>>
</span>
<?php echo $client_hardware_data->copy_average_2->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->copy_average_3->Visible) { // copy_average_3 ?>
	<div id="r_copy_average_3" class="form-group row">
		<label id="elh_client_hardware_data_copy_average_3" for="x_copy_average_3" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->copy_average_3->caption() ?><?php echo ($client_hardware_data->copy_average_3->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->copy_average_3->cellAttributes() ?>>
<span id="el_client_hardware_data_copy_average_3">
<input type="text" data-table="client_hardware_data" data-field="x_copy_average_3" name="x_copy_average_3" id="x_copy_average_3" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->copy_average_3->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->copy_average_3->EditValue ?>"<?php echo $client_hardware_data->copy_average_3->editAttributes() ?>>
</span>
<?php echo $client_hardware_data->copy_average_3->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->schedule_service_type->Visible) { // schedule_service_type ?>
	<div id="r_schedule_service_type" class="form-group row">
		<label id="elh_client_hardware_data_schedule_service_type" for="x_schedule_service_type" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->schedule_service_type->caption() ?><?php echo ($client_hardware_data->schedule_service_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->schedule_service_type->cellAttributes() ?>>
<span id="el_client_hardware_data_schedule_service_type">
<input type="text" data-table="client_hardware_data" data-field="x_schedule_service_type" name="x_schedule_service_type" id="x_schedule_service_type" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->schedule_service_type->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->schedule_service_type->EditValue ?>"<?php echo $client_hardware_data->schedule_service_type->editAttributes() ?>>
</span>
<?php echo $client_hardware_data->schedule_service_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->schedule_service_interval_days->Visible) { // schedule_service_interval_days ?>
	<div id="r_schedule_service_interval_days" class="form-group row">
		<label id="elh_client_hardware_data_schedule_service_interval_days" for="x_schedule_service_interval_days" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->schedule_service_interval_days->caption() ?><?php echo ($client_hardware_data->schedule_service_interval_days->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->schedule_service_interval_days->cellAttributes() ?>>
<span id="el_client_hardware_data_schedule_service_interval_days">
<input type="text" data-table="client_hardware_data" data-field="x_schedule_service_interval_days" name="x_schedule_service_interval_days" id="x_schedule_service_interval_days" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->schedule_service_interval_days->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->schedule_service_interval_days->EditValue ?>"<?php echo $client_hardware_data->schedule_service_interval_days->editAttributes() ?>>
</span>
<?php echo $client_hardware_data->schedule_service_interval_days->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->schedule_service_updated_till->Visible) { // schedule_service_updated_till ?>
	<div id="r_schedule_service_updated_till" class="form-group row">
		<label id="elh_client_hardware_data_schedule_service_updated_till" for="x_schedule_service_updated_till" class="<?php echo $client_hardware_data_edit->LeftColumnClass ?>"><?php echo $client_hardware_data->schedule_service_updated_till->caption() ?><?php echo ($client_hardware_data->schedule_service_updated_till->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $client_hardware_data_edit->RightColumnClass ?>"><div<?php echo $client_hardware_data->schedule_service_updated_till->cellAttributes() ?>>
<span id="el_client_hardware_data_schedule_service_updated_till">
<input type="text" data-table="client_hardware_data" data-field="x_schedule_service_updated_till" name="x_schedule_service_updated_till" id="x_schedule_service_updated_till" placeholder="<?php echo HtmlEncode($client_hardware_data->schedule_service_updated_till->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->schedule_service_updated_till->EditValue ?>"<?php echo $client_hardware_data->schedule_service_updated_till->editAttributes() ?>>
<?php if (!$client_hardware_data->schedule_service_updated_till->ReadOnly && !$client_hardware_data->schedule_service_updated_till->Disabled && !isset($client_hardware_data->schedule_service_updated_till->EditAttrs["readonly"]) && !isset($client_hardware_data->schedule_service_updated_till->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fclient_hardware_dataedit", "x_schedule_service_updated_till", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $client_hardware_data->schedule_service_updated_till->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$client_hardware_data_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $client_hardware_data_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $client_hardware_data_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$client_hardware_data_edit->IsModal) { ?>
<?php if (!isset($client_hardware_data_edit->Pager)) $client_hardware_data_edit->Pager = new PrevNextPager($client_hardware_data_edit->StartRec, $client_hardware_data_edit->DisplayRecs, $client_hardware_data_edit->TotalRecs, $client_hardware_data_edit->AutoHidePager) ?>
<?php if ($client_hardware_data_edit->Pager->RecordCount > 0 && $client_hardware_data_edit->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($client_hardware_data_edit->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $client_hardware_data_edit->pageUrl() ?>start=<?php echo $client_hardware_data_edit->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($client_hardware_data_edit->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $client_hardware_data_edit->pageUrl() ?>start=<?php echo $client_hardware_data_edit->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $client_hardware_data_edit->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($client_hardware_data_edit->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $client_hardware_data_edit->pageUrl() ?>start=<?php echo $client_hardware_data_edit->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($client_hardware_data_edit->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $client_hardware_data_edit->pageUrl() ?>start=<?php echo $client_hardware_data_edit->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $client_hardware_data_edit->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
<?php } ?>
</form>
<?php
$client_hardware_data_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$client_hardware_data_edit->terminate();
?>