<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$client_hardware_data_list = new client_hardware_data_list();

// Run the page
$client_hardware_data_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$client_hardware_data_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$client_hardware_data->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fclient_hardware_datalist = currentForm = new ew.Form("fclient_hardware_datalist", "list");
fclient_hardware_datalist.formKeyCountName = '<?php echo $client_hardware_data_list->FormKeyCountName ?>';

// Form_CustomValidate event
fclient_hardware_datalist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fclient_hardware_datalist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fclient_hardware_datalist.lists["x_partner_id"] = <?php echo $client_hardware_data_list->partner_id->Lookup->toClientList() ?>;
fclient_hardware_datalist.lists["x_partner_id"].options = <?php echo JsonEncode($client_hardware_data_list->partner_id->lookupOptions()) ?>;
fclient_hardware_datalist.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fclient_hardware_datalist.lists["x_area"] = <?php echo $client_hardware_data_list->area->Lookup->toClientList() ?>;
fclient_hardware_datalist.lists["x_area"].options = <?php echo JsonEncode($client_hardware_data_list->area->lookupOptions()) ?>;
fclient_hardware_datalist.autoSuggests["x_area"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
var fclient_hardware_datalistsrch = currentSearchForm = new ew.Form("fclient_hardware_datalistsrch");

// Validate function for search
fclient_hardware_datalistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fclient_hardware_datalistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fclient_hardware_datalistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fclient_hardware_datalistsrch.lists["x_partner_id"] = <?php echo $client_hardware_data_list->partner_id->Lookup->toClientList() ?>;
fclient_hardware_datalistsrch.lists["x_partner_id"].options = <?php echo JsonEncode($client_hardware_data_list->partner_id->lookupOptions()) ?>;
fclient_hardware_datalistsrch.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Filters
fclient_hardware_datalistsrch.filterList = <?php echo $client_hardware_data_list->getFilterList() ?>;

// Init search panel as collapsed
fclient_hardware_datalistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$client_hardware_data->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($client_hardware_data_list->TotalRecs > 0 && $client_hardware_data_list->ExportOptions->visible()) { ?>
<?php $client_hardware_data_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($client_hardware_data_list->ImportOptions->visible()) { ?>
<?php $client_hardware_data_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($client_hardware_data_list->SearchOptions->visible()) { ?>
<?php $client_hardware_data_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($client_hardware_data_list->FilterOptions->visible()) { ?>
<?php $client_hardware_data_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$client_hardware_data_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$client_hardware_data->isExport() && !$client_hardware_data->CurrentAction) { ?>
<form name="fclient_hardware_datalistsrch" id="fclient_hardware_datalistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($client_hardware_data_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fclient_hardware_datalistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="client_hardware_data">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$client_hardware_data_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$client_hardware_data->RowType = ROWTYPE_SEARCH;

// Render row
$client_hardware_data->resetAttributes();
$client_hardware_data_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($client_hardware_data->partner_id->Visible) { // partner_id ?>
	<div id="xsc_partner_id" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $client_hardware_data->partner_id->caption() ?></label>
		<span class="ew-search-operator"><select name="z_partner_id" id="z_partner_id" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($client_hardware_data->partner_id->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($client_hardware_data->partner_id->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($client_hardware_data->partner_id->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($client_hardware_data->partner_id->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($client_hardware_data->partner_id->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($client_hardware_data->partner_id->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($client_hardware_data->partner_id->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($client_hardware_data->partner_id->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($client_hardware_data->partner_id->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($client_hardware_data->partner_id->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($client_hardware_data->partner_id->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($client_hardware_data->partner_id->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($client_hardware_data->partner_id->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$client_hardware_data->partner_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$client_hardware_data->partner_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_partner_id" class="text-nowrap" style="z-index: 8960">
	<input type="text" class="form-control" name="sv_x_partner_id" id="sv_x_partner_id" value="<?php echo RemoveHtml($client_hardware_data->partner_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->partner_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($client_hardware_data->partner_id->getPlaceHolder()) ?>"<?php echo $client_hardware_data->partner_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="client_hardware_data" data-field="x_partner_id" data-value-separator="<?php echo $client_hardware_data->partner_id->displayValueSeparatorAttribute() ?>" name="x_partner_id" id="x_partner_id" value="<?php echo HtmlEncode($client_hardware_data->partner_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fclient_hardware_datalistsrch.createAutoSuggest({"id":"x_partner_id","forceSelect":false});
</script>
<?php echo $client_hardware_data->partner_id->Lookup->getParamTag("p_x_partner_id") ?>
</span>
		<span class="ew-search-cond btw1_partner_id style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_partner_id style="d-none"">
<?php
$wrkonchange = "" . trim(@$client_hardware_data->partner_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$client_hardware_data->partner_id->EditAttrs["onchange"] = "";
?>
<span id="as_y_partner_id" class="text-nowrap" style="z-index: 8960">
	<input type="text" class="form-control" name="sv_y_partner_id" id="sv_y_partner_id" value="<?php echo RemoveHtml($client_hardware_data->partner_id->EditValue2) ?>" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->partner_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($client_hardware_data->partner_id->getPlaceHolder()) ?>"<?php echo $client_hardware_data->partner_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="client_hardware_data" data-field="x_partner_id" data-value-separator="<?php echo $client_hardware_data->partner_id->displayValueSeparatorAttribute() ?>" name="y_partner_id" id="y_partner_id" value="<?php echo HtmlEncode($client_hardware_data->partner_id->AdvancedSearch->SearchValue2) ?>"<?php echo $wrkonchange ?>>
<script>
fclient_hardware_datalistsrch.createAutoSuggest({"id":"y_partner_id","forceSelect":false});
</script>
<?php echo $client_hardware_data->partner_id->Lookup->getParamTag("p_y_partner_id") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($client_hardware_data_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($client_hardware_data_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $client_hardware_data_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($client_hardware_data_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($client_hardware_data_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($client_hardware_data_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($client_hardware_data_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $client_hardware_data_list->showPageHeader(); ?>
<?php
$client_hardware_data_list->showMessage();
?>
<?php if ($client_hardware_data_list->TotalRecs > 0 || $client_hardware_data->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($client_hardware_data_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> client_hardware_data">
<?php if (!$client_hardware_data->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$client_hardware_data->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($client_hardware_data_list->Pager)) $client_hardware_data_list->Pager = new PrevNextPager($client_hardware_data_list->StartRec, $client_hardware_data_list->DisplayRecs, $client_hardware_data_list->TotalRecs, $client_hardware_data_list->AutoHidePager) ?>
<?php if ($client_hardware_data_list->Pager->RecordCount > 0 && $client_hardware_data_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($client_hardware_data_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $client_hardware_data_list->pageUrl() ?>start=<?php echo $client_hardware_data_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($client_hardware_data_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $client_hardware_data_list->pageUrl() ?>start=<?php echo $client_hardware_data_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $client_hardware_data_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($client_hardware_data_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $client_hardware_data_list->pageUrl() ?>start=<?php echo $client_hardware_data_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($client_hardware_data_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $client_hardware_data_list->pageUrl() ?>start=<?php echo $client_hardware_data_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $client_hardware_data_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($client_hardware_data_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $client_hardware_data_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $client_hardware_data_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $client_hardware_data_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($client_hardware_data_list->TotalRecs > 0 && (!$client_hardware_data_list->AutoHidePageSizeSelector || $client_hardware_data_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="client_hardware_data">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($client_hardware_data_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($client_hardware_data_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($client_hardware_data_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="ALL"<?php if ($client_hardware_data->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $client_hardware_data_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fclient_hardware_datalist" id="fclient_hardware_datalist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($client_hardware_data_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $client_hardware_data_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="client_hardware_data">
<input type="hidden" name="exporttype" id="exporttype" value="">
<div id="gmp_client_hardware_data" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($client_hardware_data_list->TotalRecs > 0 || $client_hardware_data->isGridEdit()) { ?>
<table id="tbl_client_hardware_datalist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$client_hardware_data_list->RowType = ROWTYPE_HEADER;

// Render list options
$client_hardware_data_list->renderListOptions();

// Render list options (header, left)
$client_hardware_data_list->ListOptions->render("header", "left");
?>
<?php if ($client_hardware_data->id->Visible) { // id ?>
	<?php if ($client_hardware_data->sortUrl($client_hardware_data->id) == "") { ?>
		<th data-name="id" class="<?php echo $client_hardware_data->id->headerCellClass() ?>"><div id="elh_client_hardware_data_id" class="client_hardware_data_id"><div class="ew-table-header-caption"><?php echo $client_hardware_data->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $client_hardware_data->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $client_hardware_data->SortUrl($client_hardware_data->id) ?>',1);"><div id="elh_client_hardware_data_id" class="client_hardware_data_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $client_hardware_data->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($client_hardware_data->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($client_hardware_data->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($client_hardware_data->ref->Visible) { // ref ?>
	<?php if ($client_hardware_data->sortUrl($client_hardware_data->ref) == "") { ?>
		<th data-name="ref" class="<?php echo $client_hardware_data->ref->headerCellClass() ?>"><div id="elh_client_hardware_data_ref" class="client_hardware_data_ref"><div class="ew-table-header-caption"><?php echo $client_hardware_data->ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ref" class="<?php echo $client_hardware_data->ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $client_hardware_data->SortUrl($client_hardware_data->ref) ?>',1);"><div id="elh_client_hardware_data_ref" class="client_hardware_data_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $client_hardware_data->ref->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($client_hardware_data->ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($client_hardware_data->ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($client_hardware_data->partner_id->Visible) { // partner_id ?>
	<?php if ($client_hardware_data->sortUrl($client_hardware_data->partner_id) == "") { ?>
		<th data-name="partner_id" class="<?php echo $client_hardware_data->partner_id->headerCellClass() ?>"><div id="elh_client_hardware_data_partner_id" class="client_hardware_data_partner_id"><div class="ew-table-header-caption"><?php echo $client_hardware_data->partner_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_id" class="<?php echo $client_hardware_data->partner_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $client_hardware_data->SortUrl($client_hardware_data->partner_id) ?>',1);"><div id="elh_client_hardware_data_partner_id" class="client_hardware_data_partner_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $client_hardware_data->partner_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($client_hardware_data->partner_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($client_hardware_data->partner_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($client_hardware_data->name_ref->Visible) { // name_ref ?>
	<?php if ($client_hardware_data->sortUrl($client_hardware_data->name_ref) == "") { ?>
		<th data-name="name_ref" class="<?php echo $client_hardware_data->name_ref->headerCellClass() ?>"><div id="elh_client_hardware_data_name_ref" class="client_hardware_data_name_ref"><div class="ew-table-header-caption"><?php echo $client_hardware_data->name_ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name_ref" class="<?php echo $client_hardware_data->name_ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $client_hardware_data->SortUrl($client_hardware_data->name_ref) ?>',1);"><div id="elh_client_hardware_data_name_ref" class="client_hardware_data_name_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $client_hardware_data->name_ref->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($client_hardware_data->name_ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($client_hardware_data->name_ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($client_hardware_data->city_name->Visible) { // city_name ?>
	<?php if ($client_hardware_data->sortUrl($client_hardware_data->city_name) == "") { ?>
		<th data-name="city_name" class="<?php echo $client_hardware_data->city_name->headerCellClass() ?>"><div id="elh_client_hardware_data_city_name" class="client_hardware_data_city_name"><div class="ew-table-header-caption"><?php echo $client_hardware_data->city_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="city_name" class="<?php echo $client_hardware_data->city_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $client_hardware_data->SortUrl($client_hardware_data->city_name) ?>',1);"><div id="elh_client_hardware_data_city_name" class="client_hardware_data_city_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $client_hardware_data->city_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($client_hardware_data->city_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($client_hardware_data->city_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($client_hardware_data->area->Visible) { // area ?>
	<?php if ($client_hardware_data->sortUrl($client_hardware_data->area) == "") { ?>
		<th data-name="area" class="<?php echo $client_hardware_data->area->headerCellClass() ?>"><div id="elh_client_hardware_data_area" class="client_hardware_data_area"><div class="ew-table-header-caption"><?php echo $client_hardware_data->area->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="area" class="<?php echo $client_hardware_data->area->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $client_hardware_data->SortUrl($client_hardware_data->area) ?>',1);"><div id="elh_client_hardware_data_area" class="client_hardware_data_area">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $client_hardware_data->area->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($client_hardware_data->area->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($client_hardware_data->area->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($client_hardware_data->harward_code->Visible) { // harward_code ?>
	<?php if ($client_hardware_data->sortUrl($client_hardware_data->harward_code) == "") { ?>
		<th data-name="harward_code" class="<?php echo $client_hardware_data->harward_code->headerCellClass() ?>"><div id="elh_client_hardware_data_harward_code" class="client_hardware_data_harward_code"><div class="ew-table-header-caption"><?php echo $client_hardware_data->harward_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="harward_code" class="<?php echo $client_hardware_data->harward_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $client_hardware_data->SortUrl($client_hardware_data->harward_code) ?>',1);"><div id="elh_client_hardware_data_harward_code" class="client_hardware_data_harward_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $client_hardware_data->harward_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($client_hardware_data->harward_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($client_hardware_data->harward_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($client_hardware_data->serial_no->Visible) { // serial_no ?>
	<?php if ($client_hardware_data->sortUrl($client_hardware_data->serial_no) == "") { ?>
		<th data-name="serial_no" class="<?php echo $client_hardware_data->serial_no->headerCellClass() ?>"><div id="elh_client_hardware_data_serial_no" class="client_hardware_data_serial_no"><div class="ew-table-header-caption"><?php echo $client_hardware_data->serial_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="serial_no" class="<?php echo $client_hardware_data->serial_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $client_hardware_data->SortUrl($client_hardware_data->serial_no) ?>',1);"><div id="elh_client_hardware_data_serial_no" class="client_hardware_data_serial_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $client_hardware_data->serial_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($client_hardware_data->serial_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($client_hardware_data->serial_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($client_hardware_data->date_install->Visible) { // date_install ?>
	<?php if ($client_hardware_data->sortUrl($client_hardware_data->date_install) == "") { ?>
		<th data-name="date_install" class="<?php echo $client_hardware_data->date_install->headerCellClass() ?>"><div id="elh_client_hardware_data_date_install" class="client_hardware_data_date_install"><div class="ew-table-header-caption"><?php echo $client_hardware_data->date_install->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="date_install" class="<?php echo $client_hardware_data->date_install->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $client_hardware_data->SortUrl($client_hardware_data->date_install) ?>',1);"><div id="elh_client_hardware_data_date_install" class="client_hardware_data_date_install">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $client_hardware_data->date_install->caption() ?></span><span class="ew-table-header-sort"><?php if ($client_hardware_data->date_install->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($client_hardware_data->date_install->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($client_hardware_data->remark->Visible) { // remark ?>
	<?php if ($client_hardware_data->sortUrl($client_hardware_data->remark) == "") { ?>
		<th data-name="remark" class="<?php echo $client_hardware_data->remark->headerCellClass() ?>"><div id="elh_client_hardware_data_remark" class="client_hardware_data_remark"><div class="ew-table-header-caption"><?php echo $client_hardware_data->remark->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remark" class="<?php echo $client_hardware_data->remark->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $client_hardware_data->SortUrl($client_hardware_data->remark) ?>',1);"><div id="elh_client_hardware_data_remark" class="client_hardware_data_remark">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $client_hardware_data->remark->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($client_hardware_data->remark->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($client_hardware_data->remark->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($client_hardware_data->copy_average_1->Visible) { // copy_average_1 ?>
	<?php if ($client_hardware_data->sortUrl($client_hardware_data->copy_average_1) == "") { ?>
		<th data-name="copy_average_1" class="<?php echo $client_hardware_data->copy_average_1->headerCellClass() ?>"><div id="elh_client_hardware_data_copy_average_1" class="client_hardware_data_copy_average_1"><div class="ew-table-header-caption"><?php echo $client_hardware_data->copy_average_1->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="copy_average_1" class="<?php echo $client_hardware_data->copy_average_1->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $client_hardware_data->SortUrl($client_hardware_data->copy_average_1) ?>',1);"><div id="elh_client_hardware_data_copy_average_1" class="client_hardware_data_copy_average_1">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $client_hardware_data->copy_average_1->caption() ?></span><span class="ew-table-header-sort"><?php if ($client_hardware_data->copy_average_1->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($client_hardware_data->copy_average_1->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($client_hardware_data->copy_average_2->Visible) { // copy_average_2 ?>
	<?php if ($client_hardware_data->sortUrl($client_hardware_data->copy_average_2) == "") { ?>
		<th data-name="copy_average_2" class="<?php echo $client_hardware_data->copy_average_2->headerCellClass() ?>"><div id="elh_client_hardware_data_copy_average_2" class="client_hardware_data_copy_average_2"><div class="ew-table-header-caption"><?php echo $client_hardware_data->copy_average_2->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="copy_average_2" class="<?php echo $client_hardware_data->copy_average_2->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $client_hardware_data->SortUrl($client_hardware_data->copy_average_2) ?>',1);"><div id="elh_client_hardware_data_copy_average_2" class="client_hardware_data_copy_average_2">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $client_hardware_data->copy_average_2->caption() ?></span><span class="ew-table-header-sort"><?php if ($client_hardware_data->copy_average_2->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($client_hardware_data->copy_average_2->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($client_hardware_data->copy_average_3->Visible) { // copy_average_3 ?>
	<?php if ($client_hardware_data->sortUrl($client_hardware_data->copy_average_3) == "") { ?>
		<th data-name="copy_average_3" class="<?php echo $client_hardware_data->copy_average_3->headerCellClass() ?>"><div id="elh_client_hardware_data_copy_average_3" class="client_hardware_data_copy_average_3"><div class="ew-table-header-caption"><?php echo $client_hardware_data->copy_average_3->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="copy_average_3" class="<?php echo $client_hardware_data->copy_average_3->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $client_hardware_data->SortUrl($client_hardware_data->copy_average_3) ?>',1);"><div id="elh_client_hardware_data_copy_average_3" class="client_hardware_data_copy_average_3">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $client_hardware_data->copy_average_3->caption() ?></span><span class="ew-table-header-sort"><?php if ($client_hardware_data->copy_average_3->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($client_hardware_data->copy_average_3->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($client_hardware_data->schedule_service_type->Visible) { // schedule_service_type ?>
	<?php if ($client_hardware_data->sortUrl($client_hardware_data->schedule_service_type) == "") { ?>
		<th data-name="schedule_service_type" class="<?php echo $client_hardware_data->schedule_service_type->headerCellClass() ?>"><div id="elh_client_hardware_data_schedule_service_type" class="client_hardware_data_schedule_service_type"><div class="ew-table-header-caption"><?php echo $client_hardware_data->schedule_service_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="schedule_service_type" class="<?php echo $client_hardware_data->schedule_service_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $client_hardware_data->SortUrl($client_hardware_data->schedule_service_type) ?>',1);"><div id="elh_client_hardware_data_schedule_service_type" class="client_hardware_data_schedule_service_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $client_hardware_data->schedule_service_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($client_hardware_data->schedule_service_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($client_hardware_data->schedule_service_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($client_hardware_data->schedule_service_interval_days->Visible) { // schedule_service_interval_days ?>
	<?php if ($client_hardware_data->sortUrl($client_hardware_data->schedule_service_interval_days) == "") { ?>
		<th data-name="schedule_service_interval_days" class="<?php echo $client_hardware_data->schedule_service_interval_days->headerCellClass() ?>"><div id="elh_client_hardware_data_schedule_service_interval_days" class="client_hardware_data_schedule_service_interval_days"><div class="ew-table-header-caption"><?php echo $client_hardware_data->schedule_service_interval_days->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="schedule_service_interval_days" class="<?php echo $client_hardware_data->schedule_service_interval_days->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $client_hardware_data->SortUrl($client_hardware_data->schedule_service_interval_days) ?>',1);"><div id="elh_client_hardware_data_schedule_service_interval_days" class="client_hardware_data_schedule_service_interval_days">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $client_hardware_data->schedule_service_interval_days->caption() ?></span><span class="ew-table-header-sort"><?php if ($client_hardware_data->schedule_service_interval_days->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($client_hardware_data->schedule_service_interval_days->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($client_hardware_data->schedule_service_updated_till->Visible) { // schedule_service_updated_till ?>
	<?php if ($client_hardware_data->sortUrl($client_hardware_data->schedule_service_updated_till) == "") { ?>
		<th data-name="schedule_service_updated_till" class="<?php echo $client_hardware_data->schedule_service_updated_till->headerCellClass() ?>"><div id="elh_client_hardware_data_schedule_service_updated_till" class="client_hardware_data_schedule_service_updated_till"><div class="ew-table-header-caption"><?php echo $client_hardware_data->schedule_service_updated_till->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="schedule_service_updated_till" class="<?php echo $client_hardware_data->schedule_service_updated_till->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $client_hardware_data->SortUrl($client_hardware_data->schedule_service_updated_till) ?>',1);"><div id="elh_client_hardware_data_schedule_service_updated_till" class="client_hardware_data_schedule_service_updated_till">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $client_hardware_data->schedule_service_updated_till->caption() ?></span><span class="ew-table-header-sort"><?php if ($client_hardware_data->schedule_service_updated_till->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($client_hardware_data->schedule_service_updated_till->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$client_hardware_data_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($client_hardware_data->ExportAll && $client_hardware_data->isExport()) {
	$client_hardware_data_list->StopRec = $client_hardware_data_list->TotalRecs;
} else {

	// Set the last record to display
	if ($client_hardware_data_list->TotalRecs > $client_hardware_data_list->StartRec + $client_hardware_data_list->DisplayRecs - 1)
		$client_hardware_data_list->StopRec = $client_hardware_data_list->StartRec + $client_hardware_data_list->DisplayRecs - 1;
	else
		$client_hardware_data_list->StopRec = $client_hardware_data_list->TotalRecs;
}
$client_hardware_data_list->RecCnt = $client_hardware_data_list->StartRec - 1;
if ($client_hardware_data_list->Recordset && !$client_hardware_data_list->Recordset->EOF) {
	$client_hardware_data_list->Recordset->moveFirst();
	$selectLimit = $client_hardware_data_list->UseSelectLimit;
	if (!$selectLimit && $client_hardware_data_list->StartRec > 1)
		$client_hardware_data_list->Recordset->move($client_hardware_data_list->StartRec - 1);
} elseif (!$client_hardware_data->AllowAddDeleteRow && $client_hardware_data_list->StopRec == 0) {
	$client_hardware_data_list->StopRec = $client_hardware_data->GridAddRowCount;
}

// Initialize aggregate
$client_hardware_data->RowType = ROWTYPE_AGGREGATEINIT;
$client_hardware_data->resetAttributes();
$client_hardware_data_list->renderRow();
while ($client_hardware_data_list->RecCnt < $client_hardware_data_list->StopRec) {
	$client_hardware_data_list->RecCnt++;
	if ($client_hardware_data_list->RecCnt >= $client_hardware_data_list->StartRec) {
		$client_hardware_data_list->RowCnt++;

		// Set up key count
		$client_hardware_data_list->KeyCount = $client_hardware_data_list->RowIndex;

		// Init row class and style
		$client_hardware_data->resetAttributes();
		$client_hardware_data->CssClass = "";
		if ($client_hardware_data->isGridAdd()) {
		} else {
			$client_hardware_data_list->loadRowValues($client_hardware_data_list->Recordset); // Load row values
		}
		$client_hardware_data->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$client_hardware_data->RowAttrs = array_merge($client_hardware_data->RowAttrs, array('data-rowindex'=>$client_hardware_data_list->RowCnt, 'id'=>'r' . $client_hardware_data_list->RowCnt . '_client_hardware_data', 'data-rowtype'=>$client_hardware_data->RowType));

		// Render row
		$client_hardware_data_list->renderRow();

		// Render list options
		$client_hardware_data_list->renderListOptions();
?>
	<tr<?php echo $client_hardware_data->rowAttributes() ?>>
<?php

// Render list options (body, left)
$client_hardware_data_list->ListOptions->render("body", "left", $client_hardware_data_list->RowCnt);
?>
	<?php if ($client_hardware_data->id->Visible) { // id ?>
		<td data-name="id"<?php echo $client_hardware_data->id->cellAttributes() ?>>
<span id="el<?php echo $client_hardware_data_list->RowCnt ?>_client_hardware_data_id" class="client_hardware_data_id">
<span<?php echo $client_hardware_data->id->viewAttributes() ?>>
<?php echo $client_hardware_data->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($client_hardware_data->ref->Visible) { // ref ?>
		<td data-name="ref"<?php echo $client_hardware_data->ref->cellAttributes() ?>>
<span id="el<?php echo $client_hardware_data_list->RowCnt ?>_client_hardware_data_ref" class="client_hardware_data_ref">
<span<?php echo $client_hardware_data->ref->viewAttributes() ?>>
<?php echo $client_hardware_data->ref->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($client_hardware_data->partner_id->Visible) { // partner_id ?>
		<td data-name="partner_id"<?php echo $client_hardware_data->partner_id->cellAttributes() ?>>
<span id="el<?php echo $client_hardware_data_list->RowCnt ?>_client_hardware_data_partner_id" class="client_hardware_data_partner_id">
<span<?php echo $client_hardware_data->partner_id->viewAttributes() ?>>
<?php echo $client_hardware_data->partner_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($client_hardware_data->name_ref->Visible) { // name_ref ?>
		<td data-name="name_ref"<?php echo $client_hardware_data->name_ref->cellAttributes() ?>>
<span id="el<?php echo $client_hardware_data_list->RowCnt ?>_client_hardware_data_name_ref" class="client_hardware_data_name_ref">
<span<?php echo $client_hardware_data->name_ref->viewAttributes() ?>>
<?php echo $client_hardware_data->name_ref->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($client_hardware_data->city_name->Visible) { // city_name ?>
		<td data-name="city_name"<?php echo $client_hardware_data->city_name->cellAttributes() ?>>
<span id="el<?php echo $client_hardware_data_list->RowCnt ?>_client_hardware_data_city_name" class="client_hardware_data_city_name">
<span<?php echo $client_hardware_data->city_name->viewAttributes() ?>>
<?php echo $client_hardware_data->city_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($client_hardware_data->area->Visible) { // area ?>
		<td data-name="area"<?php echo $client_hardware_data->area->cellAttributes() ?>>
<span id="el<?php echo $client_hardware_data_list->RowCnt ?>_client_hardware_data_area" class="client_hardware_data_area">
<span<?php echo $client_hardware_data->area->viewAttributes() ?>>
<?php echo $client_hardware_data->area->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($client_hardware_data->harward_code->Visible) { // harward_code ?>
		<td data-name="harward_code"<?php echo $client_hardware_data->harward_code->cellAttributes() ?>>
<span id="el<?php echo $client_hardware_data_list->RowCnt ?>_client_hardware_data_harward_code" class="client_hardware_data_harward_code">
<span<?php echo $client_hardware_data->harward_code->viewAttributes() ?>>
<?php echo $client_hardware_data->harward_code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($client_hardware_data->serial_no->Visible) { // serial_no ?>
		<td data-name="serial_no"<?php echo $client_hardware_data->serial_no->cellAttributes() ?>>
<span id="el<?php echo $client_hardware_data_list->RowCnt ?>_client_hardware_data_serial_no" class="client_hardware_data_serial_no">
<span<?php echo $client_hardware_data->serial_no->viewAttributes() ?>>
<?php echo $client_hardware_data->serial_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($client_hardware_data->date_install->Visible) { // date_install ?>
		<td data-name="date_install"<?php echo $client_hardware_data->date_install->cellAttributes() ?>>
<span id="el<?php echo $client_hardware_data_list->RowCnt ?>_client_hardware_data_date_install" class="client_hardware_data_date_install">
<span<?php echo $client_hardware_data->date_install->viewAttributes() ?>>
<?php echo $client_hardware_data->date_install->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($client_hardware_data->remark->Visible) { // remark ?>
		<td data-name="remark"<?php echo $client_hardware_data->remark->cellAttributes() ?>>
<span id="el<?php echo $client_hardware_data_list->RowCnt ?>_client_hardware_data_remark" class="client_hardware_data_remark">
<span<?php echo $client_hardware_data->remark->viewAttributes() ?>>
<?php echo $client_hardware_data->remark->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($client_hardware_data->copy_average_1->Visible) { // copy_average_1 ?>
		<td data-name="copy_average_1"<?php echo $client_hardware_data->copy_average_1->cellAttributes() ?>>
<span id="el<?php echo $client_hardware_data_list->RowCnt ?>_client_hardware_data_copy_average_1" class="client_hardware_data_copy_average_1">
<span<?php echo $client_hardware_data->copy_average_1->viewAttributes() ?>>
<?php echo $client_hardware_data->copy_average_1->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($client_hardware_data->copy_average_2->Visible) { // copy_average_2 ?>
		<td data-name="copy_average_2"<?php echo $client_hardware_data->copy_average_2->cellAttributes() ?>>
<span id="el<?php echo $client_hardware_data_list->RowCnt ?>_client_hardware_data_copy_average_2" class="client_hardware_data_copy_average_2">
<span<?php echo $client_hardware_data->copy_average_2->viewAttributes() ?>>
<?php echo $client_hardware_data->copy_average_2->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($client_hardware_data->copy_average_3->Visible) { // copy_average_3 ?>
		<td data-name="copy_average_3"<?php echo $client_hardware_data->copy_average_3->cellAttributes() ?>>
<span id="el<?php echo $client_hardware_data_list->RowCnt ?>_client_hardware_data_copy_average_3" class="client_hardware_data_copy_average_3">
<span<?php echo $client_hardware_data->copy_average_3->viewAttributes() ?>>
<?php echo $client_hardware_data->copy_average_3->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($client_hardware_data->schedule_service_type->Visible) { // schedule_service_type ?>
		<td data-name="schedule_service_type"<?php echo $client_hardware_data->schedule_service_type->cellAttributes() ?>>
<span id="el<?php echo $client_hardware_data_list->RowCnt ?>_client_hardware_data_schedule_service_type" class="client_hardware_data_schedule_service_type">
<span<?php echo $client_hardware_data->schedule_service_type->viewAttributes() ?>>
<?php echo $client_hardware_data->schedule_service_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($client_hardware_data->schedule_service_interval_days->Visible) { // schedule_service_interval_days ?>
		<td data-name="schedule_service_interval_days"<?php echo $client_hardware_data->schedule_service_interval_days->cellAttributes() ?>>
<span id="el<?php echo $client_hardware_data_list->RowCnt ?>_client_hardware_data_schedule_service_interval_days" class="client_hardware_data_schedule_service_interval_days">
<span<?php echo $client_hardware_data->schedule_service_interval_days->viewAttributes() ?>>
<?php echo $client_hardware_data->schedule_service_interval_days->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($client_hardware_data->schedule_service_updated_till->Visible) { // schedule_service_updated_till ?>
		<td data-name="schedule_service_updated_till"<?php echo $client_hardware_data->schedule_service_updated_till->cellAttributes() ?>>
<span id="el<?php echo $client_hardware_data_list->RowCnt ?>_client_hardware_data_schedule_service_updated_till" class="client_hardware_data_schedule_service_updated_till">
<span<?php echo $client_hardware_data->schedule_service_updated_till->viewAttributes() ?>>
<?php echo $client_hardware_data->schedule_service_updated_till->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$client_hardware_data_list->ListOptions->render("body", "right", $client_hardware_data_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$client_hardware_data->isGridAdd())
		$client_hardware_data_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$client_hardware_data->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($client_hardware_data_list->Recordset)
	$client_hardware_data_list->Recordset->Close();
?>
<?php if (!$client_hardware_data->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$client_hardware_data->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($client_hardware_data_list->Pager)) $client_hardware_data_list->Pager = new PrevNextPager($client_hardware_data_list->StartRec, $client_hardware_data_list->DisplayRecs, $client_hardware_data_list->TotalRecs, $client_hardware_data_list->AutoHidePager) ?>
<?php if ($client_hardware_data_list->Pager->RecordCount > 0 && $client_hardware_data_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($client_hardware_data_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $client_hardware_data_list->pageUrl() ?>start=<?php echo $client_hardware_data_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($client_hardware_data_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $client_hardware_data_list->pageUrl() ?>start=<?php echo $client_hardware_data_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $client_hardware_data_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($client_hardware_data_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $client_hardware_data_list->pageUrl() ?>start=<?php echo $client_hardware_data_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($client_hardware_data_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $client_hardware_data_list->pageUrl() ?>start=<?php echo $client_hardware_data_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $client_hardware_data_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($client_hardware_data_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $client_hardware_data_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $client_hardware_data_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $client_hardware_data_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($client_hardware_data_list->TotalRecs > 0 && (!$client_hardware_data_list->AutoHidePageSizeSelector || $client_hardware_data_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="client_hardware_data">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($client_hardware_data_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($client_hardware_data_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($client_hardware_data_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="ALL"<?php if ($client_hardware_data->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $client_hardware_data_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($client_hardware_data_list->TotalRecs == 0 && !$client_hardware_data->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $client_hardware_data_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$client_hardware_data_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$client_hardware_data->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$client_hardware_data->isExport()) { ?>
<script>
ew.scrollableTable("gmp_client_hardware_data", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$client_hardware_data_list->terminate();
?>