<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$client_hardware_data_search = new client_hardware_data_search();

// Run the page
$client_hardware_data_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$client_hardware_data_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($client_hardware_data_search->IsModal) { ?>
var fclient_hardware_datasearch = currentAdvancedSearchForm = new ew.Form("fclient_hardware_datasearch", "search");
<?php } else { ?>
var fclient_hardware_datasearch = currentForm = new ew.Form("fclient_hardware_datasearch", "search");
<?php } ?>

// Form_CustomValidate event
fclient_hardware_datasearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fclient_hardware_datasearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fclient_hardware_datasearch.lists["x_customer_grp[]"] = <?php echo $client_hardware_data_search->customer_grp->Lookup->toClientList() ?>;
fclient_hardware_datasearch.lists["x_customer_grp[]"].options = <?php echo JsonEncode($client_hardware_data_search->customer_grp->lookupOptions()) ?>;
fclient_hardware_datasearch.lists["x_partner_id"] = <?php echo $client_hardware_data_search->partner_id->Lookup->toClientList() ?>;
fclient_hardware_datasearch.lists["x_partner_id"].options = <?php echo JsonEncode($client_hardware_data_search->partner_id->lookupOptions()) ?>;
fclient_hardware_datasearch.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fclient_hardware_datasearch.lists["x_area"] = <?php echo $client_hardware_data_search->area->Lookup->toClientList() ?>;
fclient_hardware_datasearch.lists["x_area"].options = <?php echo JsonEncode($client_hardware_data_search->area->lookupOptions()) ?>;
fclient_hardware_datasearch.autoSuggests["x_area"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fclient_hardware_datasearch.lists["x_personal_ref[]"] = <?php echo $client_hardware_data_search->personal_ref->Lookup->toClientList() ?>;
fclient_hardware_datasearch.lists["x_personal_ref[]"].options = <?php echo JsonEncode($client_hardware_data_search->personal_ref->lookupOptions()) ?>;
fclient_hardware_datasearch.lists["x_guarantee"] = <?php echo $client_hardware_data_search->guarantee->Lookup->toClientList() ?>;
fclient_hardware_datasearch.lists["x_guarantee"].options = <?php echo JsonEncode($client_hardware_data_search->guarantee->options(FALSE, TRUE)) ?>;
fclient_hardware_datasearch.lists["x_status"] = <?php echo $client_hardware_data_search->status->Lookup->toClientList() ?>;
fclient_hardware_datasearch.lists["x_status"].options = <?php echo JsonEncode($client_hardware_data_search->status->options(FALSE, TRUE)) ?>;
fclient_hardware_datasearch.lists["x_operator"] = <?php echo $client_hardware_data_search->operator->Lookup->toClientList() ?>;
fclient_hardware_datasearch.lists["x_operator"].options = <?php echo JsonEncode($client_hardware_data_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fclient_hardware_datasearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($client_hardware_data->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_invoice_date");
	if (elm && !ew.checkEuroDate(elm.value))
		return this.onError(elm, "<?php echo JsEncode($client_hardware_data->invoice_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_first_counter");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($client_hardware_data->first_counter->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_valid_till");
	if (elm && !ew.checkEuroDate(elm.value))
		return this.onError(elm, "<?php echo JsEncode($client_hardware_data->valid_till->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_valid_till_counter");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($client_hardware_data->valid_till_counter->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_free_service");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($client_hardware_data->free_service->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_toner_life");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($client_hardware_data->toner_life->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_drum_life");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($client_hardware_data->drum_life->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_developer_life");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($client_hardware_data->developer_life->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_date_install");
	if (elm && !ew.checkEuroDate(elm.value))
		return this.onError(elm, "<?php echo JsEncode($client_hardware_data->date_install->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_date_start");
	if (elm && !ew.checkEuroDate(elm.value))
		return this.onError(elm, "<?php echo JsEncode($client_hardware_data->date_start->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_copy_average_1");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($client_hardware_data->copy_average_1->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_copy_average_2");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($client_hardware_data->copy_average_2->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_copy_average_3");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($client_hardware_data->copy_average_3->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_schedule_service_type");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($client_hardware_data->schedule_service_type->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_schedule_service_interval_days");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($client_hardware_data->schedule_service_interval_days->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_schedule_service_updated_till");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($client_hardware_data->schedule_service_updated_till->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $client_hardware_data_search->showPageHeader(); ?>
<?php
$client_hardware_data_search->showMessage();
?>
<form name="fclient_hardware_datasearch" id="fclient_hardware_datasearch" class="<?php echo $client_hardware_data_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($client_hardware_data_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $client_hardware_data_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="client_hardware_data">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$client_hardware_data_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($client_hardware_data->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $client_hardware_data_search->LeftColumnClass ?>"><span id="elh_client_hardware_data_id"><?php echo $client_hardware_data->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $client_hardware_data_search->RightColumnClass ?>"><div<?php echo $client_hardware_data->id->cellAttributes() ?>>
			<span id="el_client_hardware_data_id">
<input type="text" data-table="client_hardware_data" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($client_hardware_data->id->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->id->EditValue ?>"<?php echo $client_hardware_data->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->customer_grp->Visible) { // customer_grp ?>
	<div id="r_customer_grp" class="form-group row">
		<label class="<?php echo $client_hardware_data_search->LeftColumnClass ?>"><span id="elh_client_hardware_data_customer_grp"><?php echo $client_hardware_data->customer_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_customer_grp" id="z_customer_grp" value="LIKE"></span>
		</label>
		<div class="<?php echo $client_hardware_data_search->RightColumnClass ?>"><div<?php echo $client_hardware_data->customer_grp->cellAttributes() ?>>
			<span id="el_client_hardware_data_customer_grp">
<div id="tp_x_customer_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="client_hardware_data" data-field="x_customer_grp" data-value-separator="<?php echo $client_hardware_data->customer_grp->displayValueSeparatorAttribute() ?>" name="x_customer_grp[]" id="x_customer_grp[]" value="{value}"<?php echo $client_hardware_data->customer_grp->editAttributes() ?>></div>
<div id="dsl_x_customer_grp" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $client_hardware_data->customer_grp->checkBoxListHtml(FALSE, "x_customer_grp[]") ?>
</div></div>
<?php echo $client_hardware_data->customer_grp->Lookup->getParamTag("p_x_customer_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->ref->Visible) { // ref ?>
	<div id="r_ref" class="form-group row">
		<label for="x_ref" class="<?php echo $client_hardware_data_search->LeftColumnClass ?>"><span id="elh_client_hardware_data_ref"><?php echo $client_hardware_data->ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_ref" id="z_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $client_hardware_data_search->RightColumnClass ?>"><div<?php echo $client_hardware_data->ref->cellAttributes() ?>>
			<span id="el_client_hardware_data_ref">
<input type="text" data-table="client_hardware_data" data-field="x_ref" name="x_ref" id="x_ref" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($client_hardware_data->ref->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->ref->EditValue ?>"<?php echo $client_hardware_data->ref->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->partner_id->Visible) { // partner_id ?>
	<div id="r_partner_id" class="form-group row">
		<label class="<?php echo $client_hardware_data_search->LeftColumnClass ?>"><span id="elh_client_hardware_data_partner_id"><?php echo $client_hardware_data->partner_id->caption() ?></span>
		</label>
		<div class="<?php echo $client_hardware_data_search->RightColumnClass ?>"><div<?php echo $client_hardware_data->partner_id->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_partner_id" id="z_partner_id" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($client_hardware_data->partner_id->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($client_hardware_data->partner_id->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($client_hardware_data->partner_id->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($client_hardware_data->partner_id->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($client_hardware_data->partner_id->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($client_hardware_data->partner_id->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($client_hardware_data->partner_id->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($client_hardware_data->partner_id->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($client_hardware_data->partner_id->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($client_hardware_data->partner_id->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($client_hardware_data->partner_id->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($client_hardware_data->partner_id->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($client_hardware_data->partner_id->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_client_hardware_data_partner_id">
<?php
$wrkonchange = "" . trim(@$client_hardware_data->partner_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$client_hardware_data->partner_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_partner_id" class="text-nowrap" style="z-index: 8960">
	<input type="text" class="form-control" name="sv_x_partner_id" id="sv_x_partner_id" value="<?php echo RemoveHtml($client_hardware_data->partner_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->partner_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($client_hardware_data->partner_id->getPlaceHolder()) ?>"<?php echo $client_hardware_data->partner_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="client_hardware_data" data-field="x_partner_id" data-value-separator="<?php echo $client_hardware_data->partner_id->displayValueSeparatorAttribute() ?>" name="x_partner_id" id="x_partner_id" value="<?php echo HtmlEncode($client_hardware_data->partner_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fclient_hardware_datasearch.createAutoSuggest({"id":"x_partner_id","forceSelect":false});
</script>
<?php echo $client_hardware_data->partner_id->Lookup->getParamTag("p_x_partner_id") ?>
</span>
			<span class="ew-search-cond btw1_partner_id d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_client_hardware_data_partner_id" class="btw1_partner_id d-none">
<?php
$wrkonchange = "" . trim(@$client_hardware_data->partner_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$client_hardware_data->partner_id->EditAttrs["onchange"] = "";
?>
<span id="as_y_partner_id" class="text-nowrap" style="z-index: 8960">
	<input type="text" class="form-control" name="sv_y_partner_id" id="sv_y_partner_id" value="<?php echo RemoveHtml($client_hardware_data->partner_id->EditValue2) ?>" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->partner_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($client_hardware_data->partner_id->getPlaceHolder()) ?>"<?php echo $client_hardware_data->partner_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="client_hardware_data" data-field="x_partner_id" data-value-separator="<?php echo $client_hardware_data->partner_id->displayValueSeparatorAttribute() ?>" name="y_partner_id" id="y_partner_id" value="<?php echo HtmlEncode($client_hardware_data->partner_id->AdvancedSearch->SearchValue2) ?>"<?php echo $wrkonchange ?>>
<script>
fclient_hardware_datasearch.createAutoSuggest({"id":"y_partner_id","forceSelect":false});
</script>
<?php echo $client_hardware_data->partner_id->Lookup->getParamTag("p_y_partner_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->name_ref->Visible) { // name_ref ?>
	<div id="r_name_ref" class="form-group row">
		<label for="x_name_ref" class="<?php echo $client_hardware_data_search->LeftColumnClass ?>"><span id="elh_client_hardware_data_name_ref"><?php echo $client_hardware_data->name_ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name_ref" id="z_name_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $client_hardware_data_search->RightColumnClass ?>"><div<?php echo $client_hardware_data->name_ref->cellAttributes() ?>>
			<span id="el_client_hardware_data_name_ref">
<input type="text" data-table="client_hardware_data" data-field="x_name_ref" name="x_name_ref" id="x_name_ref" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($client_hardware_data->name_ref->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->name_ref->EditValue ?>"<?php echo $client_hardware_data->name_ref->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->city_name->Visible) { // city_name ?>
	<div id="r_city_name" class="form-group row">
		<label for="x_city_name" class="<?php echo $client_hardware_data_search->LeftColumnClass ?>"><span id="elh_client_hardware_data_city_name"><?php echo $client_hardware_data->city_name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_city_name" id="z_city_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $client_hardware_data_search->RightColumnClass ?>"><div<?php echo $client_hardware_data->city_name->cellAttributes() ?>>
			<span id="el_client_hardware_data_city_name">
<input type="text" data-table="client_hardware_data" data-field="x_city_name" name="x_city_name" id="x_city_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($client_hardware_data->city_name->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->city_name->EditValue ?>"<?php echo $client_hardware_data->city_name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->area->Visible) { // area ?>
	<div id="r_area" class="form-group row">
		<label class="<?php echo $client_hardware_data_search->LeftColumnClass ?>"><span id="elh_client_hardware_data_area"><?php echo $client_hardware_data->area->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_area" id="z_area" value="LIKE"></span>
		</label>
		<div class="<?php echo $client_hardware_data_search->RightColumnClass ?>"><div<?php echo $client_hardware_data->area->cellAttributes() ?>>
			<span id="el_client_hardware_data_area">
<?php
$wrkonchange = "" . trim(@$client_hardware_data->area->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$client_hardware_data->area->EditAttrs["onchange"] = "";
?>
<span id="as_x_area" class="text-nowrap" style="z-index: 8930">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_area" id="sv_x_area" value="<?php echo RemoveHtml($client_hardware_data->area->EditValue) ?>" placeholder="<?php echo HtmlEncode($client_hardware_data->area->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($client_hardware_data->area->getPlaceHolder()) ?>"<?php echo $client_hardware_data->area->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($client_hardware_data->area->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_area',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($client_hardware_data->area->ReadOnly || $client_hardware_data->area->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="client_hardware_data" data-field="x_area" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $client_hardware_data->area->displayValueSeparatorAttribute() ?>" name="x_area" id="x_area" value="<?php echo HtmlEncode($client_hardware_data->area->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fclient_hardware_datasearch.createAutoSuggest({"id":"x_area","forceSelect":false});
</script>
<?php echo $client_hardware_data->area->Lookup->getParamTag("p_x_area") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->billing_name->Visible) { // billing_name ?>
	<div id="r_billing_name" class="form-group row">
		<label for="x_billing_name" class="<?php echo $client_hardware_data_search->LeftColumnClass ?>"><span id="elh_client_hardware_data_billing_name"><?php echo $client_hardware_data->billing_name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_billing_name" id="z_billing_name" value="="></span>
		</label>
		<div class="<?php echo $client_hardware_data_search->RightColumnClass ?>"><div<?php echo $client_hardware_data->billing_name->cellAttributes() ?>>
			<span id="el_client_hardware_data_billing_name">
<input type="text" data-table="client_hardware_data" data-field="x_billing_name" name="x_billing_name" id="x_billing_name" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->billing_name->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->billing_name->EditValue ?>"<?php echo $client_hardware_data->billing_name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->address->Visible) { // address ?>
	<div id="r_address" class="form-group row">
		<label for="x_address" class="<?php echo $client_hardware_data_search->LeftColumnClass ?>"><span id="elh_client_hardware_data_address"><?php echo $client_hardware_data->address->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_address" id="z_address" value="LIKE"></span>
		</label>
		<div class="<?php echo $client_hardware_data_search->RightColumnClass ?>"><div<?php echo $client_hardware_data->address->cellAttributes() ?>>
			<span id="el_client_hardware_data_address">
<input type="text" data-table="client_hardware_data" data-field="x_address" name="x_address" id="x_address" size="35" placeholder="<?php echo HtmlEncode($client_hardware_data->address->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->address->EditValue ?>"<?php echo $client_hardware_data->address->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->personal_ref->Visible) { // personal_ref ?>
	<div id="r_personal_ref" class="form-group row">
		<label class="<?php echo $client_hardware_data_search->LeftColumnClass ?>"><span id="elh_client_hardware_data_personal_ref"><?php echo $client_hardware_data->personal_ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_personal_ref" id="z_personal_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $client_hardware_data_search->RightColumnClass ?>"><div<?php echo $client_hardware_data->personal_ref->cellAttributes() ?>>
			<span id="el_client_hardware_data_personal_ref">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_personal_ref"><?php echo strval($client_hardware_data->personal_ref->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($client_hardware_data->personal_ref->AdvancedSearch->ViewValue) : $client_hardware_data->personal_ref->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($client_hardware_data->personal_ref->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($client_hardware_data->personal_ref->ReadOnly || $client_hardware_data->personal_ref->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_personal_ref[]',m:1,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $client_hardware_data->personal_ref->Lookup->getParamTag("p_x_personal_ref") ?>
<input type="hidden" data-table="client_hardware_data" data-field="x_personal_ref" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $client_hardware_data->personal_ref->displayValueSeparatorAttribute() ?>" name="x_personal_ref[]" id="x_personal_ref[]" value="<?php echo $client_hardware_data->personal_ref->AdvancedSearch->SearchValue ?>"<?php echo $client_hardware_data->personal_ref->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->harward_code->Visible) { // harward_code ?>
	<div id="r_harward_code" class="form-group row">
		<label for="x_harward_code" class="<?php echo $client_hardware_data_search->LeftColumnClass ?>"><span id="elh_client_hardware_data_harward_code"><?php echo $client_hardware_data->harward_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_harward_code" id="z_harward_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $client_hardware_data_search->RightColumnClass ?>"><div<?php echo $client_hardware_data->harward_code->cellAttributes() ?>>
			<span id="el_client_hardware_data_harward_code">
<input type="text" data-table="client_hardware_data" data-field="x_harward_code" name="x_harward_code" id="x_harward_code" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($client_hardware_data->harward_code->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->harward_code->EditValue ?>"<?php echo $client_hardware_data->harward_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->serial_no->Visible) { // serial_no ?>
	<div id="r_serial_no" class="form-group row">
		<label for="x_serial_no" class="<?php echo $client_hardware_data_search->LeftColumnClass ?>"><span id="elh_client_hardware_data_serial_no"><?php echo $client_hardware_data->serial_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_serial_no" id="z_serial_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $client_hardware_data_search->RightColumnClass ?>"><div<?php echo $client_hardware_data->serial_no->cellAttributes() ?>>
			<span id="el_client_hardware_data_serial_no">
<input type="text" data-table="client_hardware_data" data-field="x_serial_no" name="x_serial_no" id="x_serial_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($client_hardware_data->serial_no->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->serial_no->EditValue ?>"<?php echo $client_hardware_data->serial_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->invoice_no->Visible) { // invoice_no ?>
	<div id="r_invoice_no" class="form-group row">
		<label for="x_invoice_no" class="<?php echo $client_hardware_data_search->LeftColumnClass ?>"><span id="elh_client_hardware_data_invoice_no"><?php echo $client_hardware_data->invoice_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_invoice_no" id="z_invoice_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $client_hardware_data_search->RightColumnClass ?>"><div<?php echo $client_hardware_data->invoice_no->cellAttributes() ?>>
			<span id="el_client_hardware_data_invoice_no">
<input type="text" data-table="client_hardware_data" data-field="x_invoice_no" name="x_invoice_no" id="x_invoice_no" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($client_hardware_data->invoice_no->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->invoice_no->EditValue ?>"<?php echo $client_hardware_data->invoice_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->invoice_date->Visible) { // invoice_date ?>
	<div id="r_invoice_date" class="form-group row">
		<label for="x_invoice_date" class="<?php echo $client_hardware_data_search->LeftColumnClass ?>"><span id="elh_client_hardware_data_invoice_date"><?php echo $client_hardware_data->invoice_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_invoice_date" id="z_invoice_date" value="="></span>
		</label>
		<div class="<?php echo $client_hardware_data_search->RightColumnClass ?>"><div<?php echo $client_hardware_data->invoice_date->cellAttributes() ?>>
			<span id="el_client_hardware_data_invoice_date">
<input type="text" data-table="client_hardware_data" data-field="x_invoice_date" data-format="7" name="x_invoice_date" id="x_invoice_date" placeholder="<?php echo HtmlEncode($client_hardware_data->invoice_date->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->invoice_date->EditValue ?>"<?php echo $client_hardware_data->invoice_date->editAttributes() ?>>
<?php if (!$client_hardware_data->invoice_date->ReadOnly && !$client_hardware_data->invoice_date->Disabled && !isset($client_hardware_data->invoice_date->EditAttrs["readonly"]) && !isset($client_hardware_data->invoice_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fclient_hardware_datasearch", "x_invoice_date", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->first_counter->Visible) { // first_counter ?>
	<div id="r_first_counter" class="form-group row">
		<label for="x_first_counter" class="<?php echo $client_hardware_data_search->LeftColumnClass ?>"><span id="elh_client_hardware_data_first_counter"><?php echo $client_hardware_data->first_counter->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_first_counter" id="z_first_counter" value="="></span>
		</label>
		<div class="<?php echo $client_hardware_data_search->RightColumnClass ?>"><div<?php echo $client_hardware_data->first_counter->cellAttributes() ?>>
			<span id="el_client_hardware_data_first_counter">
<input type="text" data-table="client_hardware_data" data-field="x_first_counter" name="x_first_counter" id="x_first_counter" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->first_counter->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->first_counter->EditValue ?>"<?php echo $client_hardware_data->first_counter->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->guarantee->Visible) { // guarantee ?>
	<div id="r_guarantee" class="form-group row">
		<label for="x_guarantee" class="<?php echo $client_hardware_data_search->LeftColumnClass ?>"><span id="elh_client_hardware_data_guarantee"><?php echo $client_hardware_data->guarantee->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_guarantee" id="z_guarantee" value="="></span>
		</label>
		<div class="<?php echo $client_hardware_data_search->RightColumnClass ?>"><div<?php echo $client_hardware_data->guarantee->cellAttributes() ?>>
			<span id="el_client_hardware_data_guarantee">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="client_hardware_data" data-field="x_guarantee" data-value-separator="<?php echo $client_hardware_data->guarantee->displayValueSeparatorAttribute() ?>" id="x_guarantee" name="x_guarantee"<?php echo $client_hardware_data->guarantee->editAttributes() ?>>
		<?php echo $client_hardware_data->guarantee->selectOptionListHtml("x_guarantee") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->valid_till->Visible) { // valid_till ?>
	<div id="r_valid_till" class="form-group row">
		<label for="x_valid_till" class="<?php echo $client_hardware_data_search->LeftColumnClass ?>"><span id="elh_client_hardware_data_valid_till"><?php echo $client_hardware_data->valid_till->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_valid_till" id="z_valid_till" value="="></span>
		</label>
		<div class="<?php echo $client_hardware_data_search->RightColumnClass ?>"><div<?php echo $client_hardware_data->valid_till->cellAttributes() ?>>
			<span id="el_client_hardware_data_valid_till">
<input type="text" data-table="client_hardware_data" data-field="x_valid_till" data-format="7" name="x_valid_till" id="x_valid_till" placeholder="<?php echo HtmlEncode($client_hardware_data->valid_till->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->valid_till->EditValue ?>"<?php echo $client_hardware_data->valid_till->editAttributes() ?>>
<?php if (!$client_hardware_data->valid_till->ReadOnly && !$client_hardware_data->valid_till->Disabled && !isset($client_hardware_data->valid_till->EditAttrs["readonly"]) && !isset($client_hardware_data->valid_till->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fclient_hardware_datasearch", "x_valid_till", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->valid_till_counter->Visible) { // valid_till_counter ?>
	<div id="r_valid_till_counter" class="form-group row">
		<label for="x_valid_till_counter" class="<?php echo $client_hardware_data_search->LeftColumnClass ?>"><span id="elh_client_hardware_data_valid_till_counter"><?php echo $client_hardware_data->valid_till_counter->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_valid_till_counter" id="z_valid_till_counter" value="="></span>
		</label>
		<div class="<?php echo $client_hardware_data_search->RightColumnClass ?>"><div<?php echo $client_hardware_data->valid_till_counter->cellAttributes() ?>>
			<span id="el_client_hardware_data_valid_till_counter">
<input type="text" data-table="client_hardware_data" data-field="x_valid_till_counter" name="x_valid_till_counter" id="x_valid_till_counter" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->valid_till_counter->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->valid_till_counter->EditValue ?>"<?php echo $client_hardware_data->valid_till_counter->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->free_service->Visible) { // free_service ?>
	<div id="r_free_service" class="form-group row">
		<label for="x_free_service" class="<?php echo $client_hardware_data_search->LeftColumnClass ?>"><span id="elh_client_hardware_data_free_service"><?php echo $client_hardware_data->free_service->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_free_service" id="z_free_service" value="="></span>
		</label>
		<div class="<?php echo $client_hardware_data_search->RightColumnClass ?>"><div<?php echo $client_hardware_data->free_service->cellAttributes() ?>>
			<span id="el_client_hardware_data_free_service">
<input type="text" data-table="client_hardware_data" data-field="x_free_service" name="x_free_service" id="x_free_service" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->free_service->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->free_service->EditValue ?>"<?php echo $client_hardware_data->free_service->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->toner_life->Visible) { // toner_life ?>
	<div id="r_toner_life" class="form-group row">
		<label for="x_toner_life" class="<?php echo $client_hardware_data_search->LeftColumnClass ?>"><span id="elh_client_hardware_data_toner_life"><?php echo $client_hardware_data->toner_life->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_toner_life" id="z_toner_life" value="="></span>
		</label>
		<div class="<?php echo $client_hardware_data_search->RightColumnClass ?>"><div<?php echo $client_hardware_data->toner_life->cellAttributes() ?>>
			<span id="el_client_hardware_data_toner_life">
<input type="text" data-table="client_hardware_data" data-field="x_toner_life" name="x_toner_life" id="x_toner_life" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->toner_life->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->toner_life->EditValue ?>"<?php echo $client_hardware_data->toner_life->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->drum_life->Visible) { // drum_life ?>
	<div id="r_drum_life" class="form-group row">
		<label for="x_drum_life" class="<?php echo $client_hardware_data_search->LeftColumnClass ?>"><span id="elh_client_hardware_data_drum_life"><?php echo $client_hardware_data->drum_life->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_drum_life" id="z_drum_life" value="="></span>
		</label>
		<div class="<?php echo $client_hardware_data_search->RightColumnClass ?>"><div<?php echo $client_hardware_data->drum_life->cellAttributes() ?>>
			<span id="el_client_hardware_data_drum_life">
<input type="text" data-table="client_hardware_data" data-field="x_drum_life" name="x_drum_life" id="x_drum_life" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->drum_life->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->drum_life->EditValue ?>"<?php echo $client_hardware_data->drum_life->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->developer_life->Visible) { // developer_life ?>
	<div id="r_developer_life" class="form-group row">
		<label for="x_developer_life" class="<?php echo $client_hardware_data_search->LeftColumnClass ?>"><span id="elh_client_hardware_data_developer_life"><?php echo $client_hardware_data->developer_life->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_developer_life" id="z_developer_life" value="="></span>
		</label>
		<div class="<?php echo $client_hardware_data_search->RightColumnClass ?>"><div<?php echo $client_hardware_data->developer_life->cellAttributes() ?>>
			<span id="el_client_hardware_data_developer_life">
<input type="text" data-table="client_hardware_data" data-field="x_developer_life" name="x_developer_life" id="x_developer_life" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->developer_life->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->developer_life->EditValue ?>"<?php echo $client_hardware_data->developer_life->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->date_install->Visible) { // date_install ?>
	<div id="r_date_install" class="form-group row">
		<label for="x_date_install" class="<?php echo $client_hardware_data_search->LeftColumnClass ?>"><span id="elh_client_hardware_data_date_install"><?php echo $client_hardware_data->date_install->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_date_install" id="z_date_install" value="="></span>
		</label>
		<div class="<?php echo $client_hardware_data_search->RightColumnClass ?>"><div<?php echo $client_hardware_data->date_install->cellAttributes() ?>>
			<span id="el_client_hardware_data_date_install">
<input type="text" data-table="client_hardware_data" data-field="x_date_install" data-format="7" name="x_date_install" id="x_date_install" placeholder="<?php echo HtmlEncode($client_hardware_data->date_install->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->date_install->EditValue ?>"<?php echo $client_hardware_data->date_install->editAttributes() ?>>
<?php if (!$client_hardware_data->date_install->ReadOnly && !$client_hardware_data->date_install->Disabled && !isset($client_hardware_data->date_install->EditAttrs["readonly"]) && !isset($client_hardware_data->date_install->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fclient_hardware_datasearch", "x_date_install", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->date_start->Visible) { // date_start ?>
	<div id="r_date_start" class="form-group row">
		<label for="x_date_start" class="<?php echo $client_hardware_data_search->LeftColumnClass ?>"><span id="elh_client_hardware_data_date_start"><?php echo $client_hardware_data->date_start->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_date_start" id="z_date_start" value="="></span>
		</label>
		<div class="<?php echo $client_hardware_data_search->RightColumnClass ?>"><div<?php echo $client_hardware_data->date_start->cellAttributes() ?>>
			<span id="el_client_hardware_data_date_start">
<input type="text" data-table="client_hardware_data" data-field="x_date_start" data-format="7" name="x_date_start" id="x_date_start" placeholder="<?php echo HtmlEncode($client_hardware_data->date_start->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->date_start->EditValue ?>"<?php echo $client_hardware_data->date_start->editAttributes() ?>>
<?php if (!$client_hardware_data->date_start->ReadOnly && !$client_hardware_data->date_start->Disabled && !isset($client_hardware_data->date_start->EditAttrs["readonly"]) && !isset($client_hardware_data->date_start->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fclient_hardware_datasearch", "x_date_start", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->remark->Visible) { // remark ?>
	<div id="r_remark" class="form-group row">
		<label for="x_remark" class="<?php echo $client_hardware_data_search->LeftColumnClass ?>"><span id="elh_client_hardware_data_remark"><?php echo $client_hardware_data->remark->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remark" id="z_remark" value="LIKE"></span>
		</label>
		<div class="<?php echo $client_hardware_data_search->RightColumnClass ?>"><div<?php echo $client_hardware_data->remark->cellAttributes() ?>>
			<span id="el_client_hardware_data_remark">
<input type="text" data-table="client_hardware_data" data-field="x_remark" name="x_remark" id="x_remark" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($client_hardware_data->remark->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->remark->EditValue ?>"<?php echo $client_hardware_data->remark->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $client_hardware_data_search->LeftColumnClass ?>"><span id="elh_client_hardware_data_status"><?php echo $client_hardware_data->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $client_hardware_data_search->RightColumnClass ?>"><div<?php echo $client_hardware_data->status->cellAttributes() ?>>
			<span id="el_client_hardware_data_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="client_hardware_data" data-field="x_status" data-value-separator="<?php echo $client_hardware_data->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $client_hardware_data->status->editAttributes() ?>>
		<?php echo $client_hardware_data->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $client_hardware_data_search->LeftColumnClass ?>"><span id="elh_client_hardware_data_operator"><?php echo $client_hardware_data->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $client_hardware_data_search->RightColumnClass ?>"><div<?php echo $client_hardware_data->operator->cellAttributes() ?>>
			<span id="el_client_hardware_data_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="client_hardware_data" data-field="x_operator" data-value-separator="<?php echo $client_hardware_data->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $client_hardware_data->operator->editAttributes() ?>>
		<?php echo $client_hardware_data->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $client_hardware_data->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $client_hardware_data_search->LeftColumnClass ?>"><span id="elh_client_hardware_data_datetime"><?php echo $client_hardware_data->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $client_hardware_data_search->RightColumnClass ?>"><div<?php echo $client_hardware_data->datetime->cellAttributes() ?>>
			<span id="el_client_hardware_data_datetime">
<input type="text" data-table="client_hardware_data" data-field="x_datetime" data-format="7" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($client_hardware_data->datetime->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->datetime->EditValue ?>"<?php echo $client_hardware_data->datetime->editAttributes() ?>>
<?php if (!$client_hardware_data->datetime->ReadOnly && !$client_hardware_data->datetime->Disabled && !isset($client_hardware_data->datetime->EditAttrs["readonly"]) && !isset($client_hardware_data->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fclient_hardware_datasearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->copy_average_1->Visible) { // copy_average_1 ?>
	<div id="r_copy_average_1" class="form-group row">
		<label for="x_copy_average_1" class="<?php echo $client_hardware_data_search->LeftColumnClass ?>"><span id="elh_client_hardware_data_copy_average_1"><?php echo $client_hardware_data->copy_average_1->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_copy_average_1" id="z_copy_average_1" value="="></span>
		</label>
		<div class="<?php echo $client_hardware_data_search->RightColumnClass ?>"><div<?php echo $client_hardware_data->copy_average_1->cellAttributes() ?>>
			<span id="el_client_hardware_data_copy_average_1">
<input type="text" data-table="client_hardware_data" data-field="x_copy_average_1" name="x_copy_average_1" id="x_copy_average_1" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->copy_average_1->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->copy_average_1->EditValue ?>"<?php echo $client_hardware_data->copy_average_1->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->copy_average_2->Visible) { // copy_average_2 ?>
	<div id="r_copy_average_2" class="form-group row">
		<label for="x_copy_average_2" class="<?php echo $client_hardware_data_search->LeftColumnClass ?>"><span id="elh_client_hardware_data_copy_average_2"><?php echo $client_hardware_data->copy_average_2->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_copy_average_2" id="z_copy_average_2" value="="></span>
		</label>
		<div class="<?php echo $client_hardware_data_search->RightColumnClass ?>"><div<?php echo $client_hardware_data->copy_average_2->cellAttributes() ?>>
			<span id="el_client_hardware_data_copy_average_2">
<input type="text" data-table="client_hardware_data" data-field="x_copy_average_2" name="x_copy_average_2" id="x_copy_average_2" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->copy_average_2->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->copy_average_2->EditValue ?>"<?php echo $client_hardware_data->copy_average_2->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->copy_average_3->Visible) { // copy_average_3 ?>
	<div id="r_copy_average_3" class="form-group row">
		<label for="x_copy_average_3" class="<?php echo $client_hardware_data_search->LeftColumnClass ?>"><span id="elh_client_hardware_data_copy_average_3"><?php echo $client_hardware_data->copy_average_3->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_copy_average_3" id="z_copy_average_3" value="="></span>
		</label>
		<div class="<?php echo $client_hardware_data_search->RightColumnClass ?>"><div<?php echo $client_hardware_data->copy_average_3->cellAttributes() ?>>
			<span id="el_client_hardware_data_copy_average_3">
<input type="text" data-table="client_hardware_data" data-field="x_copy_average_3" name="x_copy_average_3" id="x_copy_average_3" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->copy_average_3->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->copy_average_3->EditValue ?>"<?php echo $client_hardware_data->copy_average_3->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->schedule_service_type->Visible) { // schedule_service_type ?>
	<div id="r_schedule_service_type" class="form-group row">
		<label for="x_schedule_service_type" class="<?php echo $client_hardware_data_search->LeftColumnClass ?>"><span id="elh_client_hardware_data_schedule_service_type"><?php echo $client_hardware_data->schedule_service_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_schedule_service_type" id="z_schedule_service_type" value="="></span>
		</label>
		<div class="<?php echo $client_hardware_data_search->RightColumnClass ?>"><div<?php echo $client_hardware_data->schedule_service_type->cellAttributes() ?>>
			<span id="el_client_hardware_data_schedule_service_type">
<input type="text" data-table="client_hardware_data" data-field="x_schedule_service_type" name="x_schedule_service_type" id="x_schedule_service_type" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->schedule_service_type->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->schedule_service_type->EditValue ?>"<?php echo $client_hardware_data->schedule_service_type->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->schedule_service_interval_days->Visible) { // schedule_service_interval_days ?>
	<div id="r_schedule_service_interval_days" class="form-group row">
		<label for="x_schedule_service_interval_days" class="<?php echo $client_hardware_data_search->LeftColumnClass ?>"><span id="elh_client_hardware_data_schedule_service_interval_days"><?php echo $client_hardware_data->schedule_service_interval_days->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_schedule_service_interval_days" id="z_schedule_service_interval_days" value="="></span>
		</label>
		<div class="<?php echo $client_hardware_data_search->RightColumnClass ?>"><div<?php echo $client_hardware_data->schedule_service_interval_days->cellAttributes() ?>>
			<span id="el_client_hardware_data_schedule_service_interval_days">
<input type="text" data-table="client_hardware_data" data-field="x_schedule_service_interval_days" name="x_schedule_service_interval_days" id="x_schedule_service_interval_days" size="30" placeholder="<?php echo HtmlEncode($client_hardware_data->schedule_service_interval_days->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->schedule_service_interval_days->EditValue ?>"<?php echo $client_hardware_data->schedule_service_interval_days->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($client_hardware_data->schedule_service_updated_till->Visible) { // schedule_service_updated_till ?>
	<div id="r_schedule_service_updated_till" class="form-group row">
		<label for="x_schedule_service_updated_till" class="<?php echo $client_hardware_data_search->LeftColumnClass ?>"><span id="elh_client_hardware_data_schedule_service_updated_till"><?php echo $client_hardware_data->schedule_service_updated_till->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_schedule_service_updated_till" id="z_schedule_service_updated_till" value="="></span>
		</label>
		<div class="<?php echo $client_hardware_data_search->RightColumnClass ?>"><div<?php echo $client_hardware_data->schedule_service_updated_till->cellAttributes() ?>>
			<span id="el_client_hardware_data_schedule_service_updated_till">
<input type="text" data-table="client_hardware_data" data-field="x_schedule_service_updated_till" name="x_schedule_service_updated_till" id="x_schedule_service_updated_till" placeholder="<?php echo HtmlEncode($client_hardware_data->schedule_service_updated_till->getPlaceHolder()) ?>" value="<?php echo $client_hardware_data->schedule_service_updated_till->EditValue ?>"<?php echo $client_hardware_data->schedule_service_updated_till->editAttributes() ?>>
<?php if (!$client_hardware_data->schedule_service_updated_till->ReadOnly && !$client_hardware_data->schedule_service_updated_till->Disabled && !isset($client_hardware_data->schedule_service_updated_till->EditAttrs["readonly"]) && !isset($client_hardware_data->schedule_service_updated_till->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fclient_hardware_datasearch", "x_schedule_service_updated_till", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$client_hardware_data_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $client_hardware_data_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$client_hardware_data_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$client_hardware_data_search->terminate();
?>