<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$code_exchange_add = new code_exchange_add();

// Run the page
$code_exchange_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$code_exchange_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fcode_exchangeadd = currentForm = new ew.Form("fcode_exchangeadd", "add");

// Validate form
fcode_exchangeadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($code_exchange_add->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $code_exchange->code->caption(), $code_exchange->code->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($code_exchange->code->errorMessage()) ?>");
		<?php if ($code_exchange_add->consume_by->Required) { ?>
			elm = this.getElements("x" + infix + "_consume_by");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $code_exchange->consume_by->caption(), $code_exchange->consume_by->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_consume_by");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($code_exchange->consume_by->errorMessage()) ?>");
		<?php if ($code_exchange_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $code_exchange->operator->caption(), $code_exchange->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($code_exchange_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $code_exchange->datetime->caption(), $code_exchange->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fcode_exchangeadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcode_exchangeadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $code_exchange_add->showPageHeader(); ?>
<?php
$code_exchange_add->showMessage();
?>
<form name="fcode_exchangeadd" id="fcode_exchangeadd" class="<?php echo $code_exchange_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($code_exchange_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $code_exchange_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="code_exchange">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$code_exchange_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($code_exchange->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label id="elh_code_exchange_code" for="x_code" class="<?php echo $code_exchange_add->LeftColumnClass ?>"><?php echo $code_exchange->code->caption() ?><?php echo ($code_exchange->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $code_exchange_add->RightColumnClass ?>"><div<?php echo $code_exchange->code->cellAttributes() ?>>
<span id="el_code_exchange_code">
<input type="text" data-table="code_exchange" data-field="x_code" name="x_code" id="x_code" size="30" placeholder="<?php echo HtmlEncode($code_exchange->code->getPlaceHolder()) ?>" value="<?php echo $code_exchange->code->EditValue ?>"<?php echo $code_exchange->code->editAttributes() ?>>
</span>
<?php echo $code_exchange->code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($code_exchange->consume_by->Visible) { // consume_by ?>
	<div id="r_consume_by" class="form-group row">
		<label id="elh_code_exchange_consume_by" for="x_consume_by" class="<?php echo $code_exchange_add->LeftColumnClass ?>"><?php echo $code_exchange->consume_by->caption() ?><?php echo ($code_exchange->consume_by->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $code_exchange_add->RightColumnClass ?>"><div<?php echo $code_exchange->consume_by->cellAttributes() ?>>
<span id="el_code_exchange_consume_by">
<input type="text" data-table="code_exchange" data-field="x_consume_by" name="x_consume_by" id="x_consume_by" size="30" placeholder="<?php echo HtmlEncode($code_exchange->consume_by->getPlaceHolder()) ?>" value="<?php echo $code_exchange->consume_by->EditValue ?>"<?php echo $code_exchange->consume_by->editAttributes() ?>>
</span>
<?php echo $code_exchange->consume_by->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$code_exchange_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $code_exchange_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $code_exchange_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$code_exchange_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

		var code = $("#x_code").val();
		$.getJSON('apcajax.php?bcode_exchange='+code,function(data){
		$('#error').remove();
		$('#r_code').append('<span id="error" style="color: red">Design:'+data.Design_10D+'<BR>Size: '+data.SizeCM+'<BR>Buyer: '+data.Buyer+'<BR>Buyer PO: '+data.Buyer_PO+'<BR>Buyer Ref: '+data.Buyer_Ref+'<BR>Delivery Week: '+data.Week+'<BR>Status: '+data.item+'</span>');
		});
		var ccode = $("#x_consume_by").val();
		if ((ccode === undefined || ccode === null || ccode === '')  == false)
		{
			if (code == ccode)
				{
					alert('Same Code Can\'t be used as Consume By');
					$("#x_consume_by").val('');
				}
			else
			{
				$.getJSON('apcajax.php?bcode_exchange='+ccode,function(datacc){
				$('#error1').remove();
				$('#r_consume_by').append('<span id="error1" style="color: red">Design:'+datacc.Design_10D+'<BR>Size: '+datacc.SizeCM+'<BR>Buyer: '+datacc.Buyer+'<BR>Buyer PO: '+datacc.Buyer_PO+'<BR>Buyer Ref: '+datacc.Buyer_Ref+'<BR>Delivery Week: '+datacc.Week+'<BR>Status: '+data.item+'</span>');
			});
			}
		}
</script>
<?php include_once "footer.php" ?>
<?php
$code_exchange_add->terminate();
?>