<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$code_exchange_list = new code_exchange_list();

// Run the page
$code_exchange_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$code_exchange_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$code_exchange->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fcode_exchangelist = currentForm = new ew.Form("fcode_exchangelist", "list");
fcode_exchangelist.formKeyCountName = '<?php echo $code_exchange_list->FormKeyCountName ?>';

// Form_CustomValidate event
fcode_exchangelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcode_exchangelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var fcode_exchangelistsrch = currentSearchForm = new ew.Form("fcode_exchangelistsrch");

// Filters
fcode_exchangelistsrch.filterList = <?php echo $code_exchange_list->getFilterList() ?>;

// Init search panel as collapsed
fcode_exchangelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$code_exchange->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($code_exchange_list->TotalRecs > 0 && $code_exchange_list->ExportOptions->visible()) { ?>
<?php $code_exchange_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($code_exchange_list->ImportOptions->visible()) { ?>
<?php $code_exchange_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($code_exchange_list->SearchOptions->visible()) { ?>
<?php $code_exchange_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($code_exchange_list->FilterOptions->visible()) { ?>
<?php $code_exchange_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$code_exchange_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$code_exchange->isExport() && !$code_exchange->CurrentAction) { ?>
<form name="fcode_exchangelistsrch" id="fcode_exchangelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($code_exchange_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fcode_exchangelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="code_exchange">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($code_exchange_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($code_exchange_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $code_exchange_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($code_exchange_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($code_exchange_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($code_exchange_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($code_exchange_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $code_exchange_list->showPageHeader(); ?>
<?php
$code_exchange_list->showMessage();
?>
<?php if ($code_exchange_list->TotalRecs > 0 || $code_exchange->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($code_exchange_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> code_exchange">
<?php if (!$code_exchange->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$code_exchange->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($code_exchange_list->Pager)) $code_exchange_list->Pager = new PrevNextPager($code_exchange_list->StartRec, $code_exchange_list->DisplayRecs, $code_exchange_list->TotalRecs, $code_exchange_list->AutoHidePager) ?>
<?php if ($code_exchange_list->Pager->RecordCount > 0 && $code_exchange_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($code_exchange_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $code_exchange_list->pageUrl() ?>start=<?php echo $code_exchange_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($code_exchange_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $code_exchange_list->pageUrl() ?>start=<?php echo $code_exchange_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $code_exchange_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($code_exchange_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $code_exchange_list->pageUrl() ?>start=<?php echo $code_exchange_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($code_exchange_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $code_exchange_list->pageUrl() ?>start=<?php echo $code_exchange_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $code_exchange_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($code_exchange_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $code_exchange_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $code_exchange_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $code_exchange_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($code_exchange_list->TotalRecs > 0 && (!$code_exchange_list->AutoHidePageSizeSelector || $code_exchange_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="code_exchange">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($code_exchange_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($code_exchange_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($code_exchange_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($code_exchange_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($code_exchange_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($code_exchange->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $code_exchange_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fcode_exchangelist" id="fcode_exchangelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($code_exchange_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $code_exchange_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="code_exchange">
<div id="gmp_code_exchange" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($code_exchange_list->TotalRecs > 0 || $code_exchange->isGridEdit()) { ?>
<table id="tbl_code_exchangelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$code_exchange_list->RowType = ROWTYPE_HEADER;

// Render list options
$code_exchange_list->renderListOptions();

// Render list options (header, left)
$code_exchange_list->ListOptions->render("header", "left");
?>
<?php if ($code_exchange->id->Visible) { // id ?>
	<?php if ($code_exchange->sortUrl($code_exchange->id) == "") { ?>
		<th data-name="id" class="<?php echo $code_exchange->id->headerCellClass() ?>"><div id="elh_code_exchange_id" class="code_exchange_id"><div class="ew-table-header-caption"><?php echo $code_exchange->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $code_exchange->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $code_exchange->SortUrl($code_exchange->id) ?>',2);"><div id="elh_code_exchange_id" class="code_exchange_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $code_exchange->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($code_exchange->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($code_exchange->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($code_exchange->code->Visible) { // code ?>
	<?php if ($code_exchange->sortUrl($code_exchange->code) == "") { ?>
		<th data-name="code" class="<?php echo $code_exchange->code->headerCellClass() ?>"><div id="elh_code_exchange_code" class="code_exchange_code"><div class="ew-table-header-caption"><?php echo $code_exchange->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $code_exchange->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $code_exchange->SortUrl($code_exchange->code) ?>',2);"><div id="elh_code_exchange_code" class="code_exchange_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $code_exchange->code->caption() ?></span><span class="ew-table-header-sort"><?php if ($code_exchange->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($code_exchange->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($code_exchange->consume_by->Visible) { // consume_by ?>
	<?php if ($code_exchange->sortUrl($code_exchange->consume_by) == "") { ?>
		<th data-name="consume_by" class="<?php echo $code_exchange->consume_by->headerCellClass() ?>"><div id="elh_code_exchange_consume_by" class="code_exchange_consume_by"><div class="ew-table-header-caption"><?php echo $code_exchange->consume_by->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="consume_by" class="<?php echo $code_exchange->consume_by->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $code_exchange->SortUrl($code_exchange->consume_by) ?>',2);"><div id="elh_code_exchange_consume_by" class="code_exchange_consume_by">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $code_exchange->consume_by->caption() ?></span><span class="ew-table-header-sort"><?php if ($code_exchange->consume_by->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($code_exchange->consume_by->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($code_exchange->code_value->Visible) { // code_value ?>
	<?php if ($code_exchange->sortUrl($code_exchange->code_value) == "") { ?>
		<th data-name="code_value" class="<?php echo $code_exchange->code_value->headerCellClass() ?>"><div id="elh_code_exchange_code_value" class="code_exchange_code_value"><div class="ew-table-header-caption"><?php echo $code_exchange->code_value->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code_value" class="<?php echo $code_exchange->code_value->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $code_exchange->SortUrl($code_exchange->code_value) ?>',2);"><div id="elh_code_exchange_code_value" class="code_exchange_code_value">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $code_exchange->code_value->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($code_exchange->code_value->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($code_exchange->code_value->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($code_exchange->consume_by_value->Visible) { // consume_by_value ?>
	<?php if ($code_exchange->sortUrl($code_exchange->consume_by_value) == "") { ?>
		<th data-name="consume_by_value" class="<?php echo $code_exchange->consume_by_value->headerCellClass() ?>"><div id="elh_code_exchange_consume_by_value" class="code_exchange_consume_by_value"><div class="ew-table-header-caption"><?php echo $code_exchange->consume_by_value->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="consume_by_value" class="<?php echo $code_exchange->consume_by_value->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $code_exchange->SortUrl($code_exchange->consume_by_value) ?>',2);"><div id="elh_code_exchange_consume_by_value" class="code_exchange_consume_by_value">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $code_exchange->consume_by_value->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($code_exchange->consume_by_value->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($code_exchange->consume_by_value->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($code_exchange->operator->Visible) { // operator ?>
	<?php if ($code_exchange->sortUrl($code_exchange->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $code_exchange->operator->headerCellClass() ?>"><div id="elh_code_exchange_operator" class="code_exchange_operator"><div class="ew-table-header-caption"><?php echo $code_exchange->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $code_exchange->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $code_exchange->SortUrl($code_exchange->operator) ?>',2);"><div id="elh_code_exchange_operator" class="code_exchange_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $code_exchange->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($code_exchange->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($code_exchange->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($code_exchange->datetime->Visible) { // datetime ?>
	<?php if ($code_exchange->sortUrl($code_exchange->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $code_exchange->datetime->headerCellClass() ?>"><div id="elh_code_exchange_datetime" class="code_exchange_datetime"><div class="ew-table-header-caption"><?php echo $code_exchange->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $code_exchange->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $code_exchange->SortUrl($code_exchange->datetime) ?>',2);"><div id="elh_code_exchange_datetime" class="code_exchange_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $code_exchange->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($code_exchange->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($code_exchange->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$code_exchange_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($code_exchange->ExportAll && $code_exchange->isExport()) {
	$code_exchange_list->StopRec = $code_exchange_list->TotalRecs;
} else {

	// Set the last record to display
	if ($code_exchange_list->TotalRecs > $code_exchange_list->StartRec + $code_exchange_list->DisplayRecs - 1)
		$code_exchange_list->StopRec = $code_exchange_list->StartRec + $code_exchange_list->DisplayRecs - 1;
	else
		$code_exchange_list->StopRec = $code_exchange_list->TotalRecs;
}
$code_exchange_list->RecCnt = $code_exchange_list->StartRec - 1;
if ($code_exchange_list->Recordset && !$code_exchange_list->Recordset->EOF) {
	$code_exchange_list->Recordset->moveFirst();
	$selectLimit = $code_exchange_list->UseSelectLimit;
	if (!$selectLimit && $code_exchange_list->StartRec > 1)
		$code_exchange_list->Recordset->move($code_exchange_list->StartRec - 1);
} elseif (!$code_exchange->AllowAddDeleteRow && $code_exchange_list->StopRec == 0) {
	$code_exchange_list->StopRec = $code_exchange->GridAddRowCount;
}

// Initialize aggregate
$code_exchange->RowType = ROWTYPE_AGGREGATEINIT;
$code_exchange->resetAttributes();
$code_exchange_list->renderRow();
while ($code_exchange_list->RecCnt < $code_exchange_list->StopRec) {
	$code_exchange_list->RecCnt++;
	if ($code_exchange_list->RecCnt >= $code_exchange_list->StartRec) {
		$code_exchange_list->RowCnt++;

		// Set up key count
		$code_exchange_list->KeyCount = $code_exchange_list->RowIndex;

		// Init row class and style
		$code_exchange->resetAttributes();
		$code_exchange->CssClass = "";
		if ($code_exchange->isGridAdd()) {
		} else {
			$code_exchange_list->loadRowValues($code_exchange_list->Recordset); // Load row values
		}
		$code_exchange->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$code_exchange->RowAttrs = array_merge($code_exchange->RowAttrs, array('data-rowindex'=>$code_exchange_list->RowCnt, 'id'=>'r' . $code_exchange_list->RowCnt . '_code_exchange', 'data-rowtype'=>$code_exchange->RowType));

		// Render row
		$code_exchange_list->renderRow();

		// Render list options
		$code_exchange_list->renderListOptions();
?>
	<tr<?php echo $code_exchange->rowAttributes() ?>>
<?php

// Render list options (body, left)
$code_exchange_list->ListOptions->render("body", "left", $code_exchange_list->RowCnt);
?>
	<?php if ($code_exchange->id->Visible) { // id ?>
		<td data-name="id"<?php echo $code_exchange->id->cellAttributes() ?>>
<span id="el<?php echo $code_exchange_list->RowCnt ?>_code_exchange_id" class="code_exchange_id">
<span<?php echo $code_exchange->id->viewAttributes() ?>>
<?php echo $code_exchange->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($code_exchange->code->Visible) { // code ?>
		<td data-name="code"<?php echo $code_exchange->code->cellAttributes() ?>>
<span id="el<?php echo $code_exchange_list->RowCnt ?>_code_exchange_code" class="code_exchange_code">
<span<?php echo $code_exchange->code->viewAttributes() ?>>
<?php echo $code_exchange->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($code_exchange->consume_by->Visible) { // consume_by ?>
		<td data-name="consume_by"<?php echo $code_exchange->consume_by->cellAttributes() ?>>
<span id="el<?php echo $code_exchange_list->RowCnt ?>_code_exchange_consume_by" class="code_exchange_consume_by">
<span<?php echo $code_exchange->consume_by->viewAttributes() ?>>
<?php echo $code_exchange->consume_by->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($code_exchange->code_value->Visible) { // code_value ?>
		<td data-name="code_value"<?php echo $code_exchange->code_value->cellAttributes() ?>>
<span id="el<?php echo $code_exchange_list->RowCnt ?>_code_exchange_code_value" class="code_exchange_code_value">
<span<?php echo $code_exchange->code_value->viewAttributes() ?>>
<?php echo $code_exchange->code_value->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($code_exchange->consume_by_value->Visible) { // consume_by_value ?>
		<td data-name="consume_by_value"<?php echo $code_exchange->consume_by_value->cellAttributes() ?>>
<span id="el<?php echo $code_exchange_list->RowCnt ?>_code_exchange_consume_by_value" class="code_exchange_consume_by_value">
<span<?php echo $code_exchange->consume_by_value->viewAttributes() ?>>
<?php echo $code_exchange->consume_by_value->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($code_exchange->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $code_exchange->operator->cellAttributes() ?>>
<span id="el<?php echo $code_exchange_list->RowCnt ?>_code_exchange_operator" class="code_exchange_operator">
<span<?php echo $code_exchange->operator->viewAttributes() ?>>
<?php echo $code_exchange->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($code_exchange->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $code_exchange->datetime->cellAttributes() ?>>
<span id="el<?php echo $code_exchange_list->RowCnt ?>_code_exchange_datetime" class="code_exchange_datetime">
<span<?php echo $code_exchange->datetime->viewAttributes() ?>>
<?php echo $code_exchange->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$code_exchange_list->ListOptions->render("body", "right", $code_exchange_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$code_exchange->isGridAdd())
		$code_exchange_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$code_exchange->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($code_exchange_list->Recordset)
	$code_exchange_list->Recordset->Close();
?>
<?php if (!$code_exchange->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$code_exchange->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($code_exchange_list->Pager)) $code_exchange_list->Pager = new PrevNextPager($code_exchange_list->StartRec, $code_exchange_list->DisplayRecs, $code_exchange_list->TotalRecs, $code_exchange_list->AutoHidePager) ?>
<?php if ($code_exchange_list->Pager->RecordCount > 0 && $code_exchange_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($code_exchange_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $code_exchange_list->pageUrl() ?>start=<?php echo $code_exchange_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($code_exchange_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $code_exchange_list->pageUrl() ?>start=<?php echo $code_exchange_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $code_exchange_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($code_exchange_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $code_exchange_list->pageUrl() ?>start=<?php echo $code_exchange_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($code_exchange_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $code_exchange_list->pageUrl() ?>start=<?php echo $code_exchange_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $code_exchange_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($code_exchange_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $code_exchange_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $code_exchange_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $code_exchange_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($code_exchange_list->TotalRecs > 0 && (!$code_exchange_list->AutoHidePageSizeSelector || $code_exchange_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="code_exchange">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($code_exchange_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($code_exchange_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($code_exchange_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($code_exchange_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($code_exchange_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($code_exchange->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $code_exchange_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($code_exchange_list->TotalRecs == 0 && !$code_exchange->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $code_exchange_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$code_exchange_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$code_exchange->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$code_exchange->isExport()) { ?>
<script>
ew.scrollableTable("gmp_code_exchange", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$code_exchange_list->terminate();
?>