<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$collection_log_list = new collection_log_list();

// Run the page
$collection_log_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$collection_log_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$collection_log->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fcollection_loglist = currentForm = new ew.Form("fcollection_loglist", "list");
fcollection_loglist.formKeyCountName = '<?php echo $collection_log_list->FormKeyCountName ?>';

// Form_CustomValidate event
fcollection_loglist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcollection_loglist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcollection_loglist.lists["x_location"] = <?php echo $collection_log_list->location->Lookup->toClientList() ?>;
fcollection_loglist.lists["x_location"].options = <?php echo JsonEncode($collection_log_list->location->lookupOptions()) ?>;
fcollection_loglist.lists["x_agent"] = <?php echo $collection_log_list->agent->Lookup->toClientList() ?>;
fcollection_loglist.lists["x_agent"].options = <?php echo JsonEncode($collection_log_list->agent->lookupOptions()) ?>;
fcollection_loglist.lists["x_account_no"] = <?php echo $collection_log_list->account_no->Lookup->toClientList() ?>;
fcollection_loglist.lists["x_account_no"].options = <?php echo JsonEncode($collection_log_list->account_no->lookupOptions()) ?>;
fcollection_loglist.autoSuggests["x_account_no"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fcollection_loglist.lists["x_updated"] = <?php echo $collection_log_list->updated->Lookup->toClientList() ?>;
fcollection_loglist.lists["x_updated"].options = <?php echo JsonEncode($collection_log_list->updated->options(FALSE, TRUE)) ?>;

// Form object for search
var fcollection_loglistsrch = currentSearchForm = new ew.Form("fcollection_loglistsrch");

// Validate function for search
fcollection_loglistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_account_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($collection_log->account_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_revised_date");
	if (elm && !ew.checkEuroDate(elm.value))
		return this.onError(elm, "<?php echo JsEncode($collection_log->revised_date->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fcollection_loglistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcollection_loglistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcollection_loglistsrch.lists["x_location"] = <?php echo $collection_log_list->location->Lookup->toClientList() ?>;
fcollection_loglistsrch.lists["x_location"].options = <?php echo JsonEncode($collection_log_list->location->lookupOptions()) ?>;
fcollection_loglistsrch.lists["x_agent"] = <?php echo $collection_log_list->agent->Lookup->toClientList() ?>;
fcollection_loglistsrch.lists["x_agent"].options = <?php echo JsonEncode($collection_log_list->agent->lookupOptions()) ?>;
fcollection_loglistsrch.lists["x_account_no"] = <?php echo $collection_log_list->account_no->Lookup->toClientList() ?>;
fcollection_loglistsrch.lists["x_account_no"].options = <?php echo JsonEncode($collection_log_list->account_no->lookupOptions()) ?>;
fcollection_loglistsrch.autoSuggests["x_account_no"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fcollection_loglistsrch.lists["x_updated"] = <?php echo $collection_log_list->updated->Lookup->toClientList() ?>;
fcollection_loglistsrch.lists["x_updated"].options = <?php echo JsonEncode($collection_log_list->updated->options(FALSE, TRUE)) ?>;

// Filters
fcollection_loglistsrch.filterList = <?php echo $collection_log_list->getFilterList() ?>;

// Init search panel as collapsed
fcollection_loglistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$collection_log->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($collection_log_list->TotalRecs > 0 && $collection_log_list->ExportOptions->visible()) { ?>
<?php $collection_log_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($collection_log_list->ImportOptions->visible()) { ?>
<?php $collection_log_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($collection_log_list->SearchOptions->visible()) { ?>
<?php $collection_log_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($collection_log_list->FilterOptions->visible()) { ?>
<?php $collection_log_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$collection_log_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$collection_log->isExport() && !$collection_log->CurrentAction) { ?>
<form name="fcollection_loglistsrch" id="fcollection_loglistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($collection_log_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fcollection_loglistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="collection_log">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$collection_log_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$collection_log->RowType = ROWTYPE_SEARCH;

// Render row
$collection_log->resetAttributes();
$collection_log_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($collection_log->location->Visible) { // location ?>
	<div id="xsc_location" class="ew-cell form-group">
		<label for="x_location" class="ew-search-caption ew-label"><?php echo $collection_log->location->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="collection_log" data-field="x_location" data-value-separator="<?php echo $collection_log->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $collection_log->location->editAttributes() ?>>
		<?php echo $collection_log->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $collection_log->location->Lookup->getParamTag("p_x_location") ?>
</span>
	</div>
<?php } ?>
<?php if ($collection_log->agent->Visible) { // agent ?>
	<div id="xsc_agent" class="ew-cell form-group">
		<label for="x_agent" class="ew-search-caption ew-label"><?php echo $collection_log->agent->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_agent" id="z_agent" value="="></span>
		<span class="ew-search-field">
<?php if (!$Security->isAdmin() && $Security->isLoggedIn() && !$collection_log->userIDAllow($collection_log->CurrentAction)) { // Non system admin ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="collection_log" data-field="x_agent" data-value-separator="<?php echo $collection_log->agent->displayValueSeparatorAttribute() ?>" id="x_agent" name="x_agent"<?php echo $collection_log->agent->editAttributes() ?>>
		<?php echo $collection_log->agent->selectOptionListHtml("x_agent") ?>
	</select>
</div>
<?php echo $collection_log->agent->Lookup->getParamTag("p_x_agent") ?>
<?php } else { ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="collection_log" data-field="x_agent" data-value-separator="<?php echo $collection_log->agent->displayValueSeparatorAttribute() ?>" id="x_agent" name="x_agent"<?php echo $collection_log->agent->editAttributes() ?>>
		<?php echo $collection_log->agent->selectOptionListHtml("x_agent") ?>
	</select>
</div>
<?php echo $collection_log->agent->Lookup->getParamTag("p_x_agent") ?>
<?php } ?>
</span>
	</div>
<?php } ?>
<?php if ($collection_log->account_no->Visible) { // account_no ?>
	<div id="xsc_account_no" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $collection_log->account_no->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_account_no" id="z_account_no" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$collection_log->account_no->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$collection_log->account_no->EditAttrs["onchange"] = "";
?>
<span id="as_x_account_no" class="text-nowrap" style="z-index: 8960">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_account_no" id="sv_x_account_no" value="<?php echo RemoveHtml($collection_log->account_no->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($collection_log->account_no->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($collection_log->account_no->getPlaceHolder()) ?>"<?php echo $collection_log->account_no->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($collection_log->account_no->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_account_no',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($collection_log->account_no->ReadOnly || $collection_log->account_no->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="collection_log" data-field="x_account_no" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $collection_log->account_no->displayValueSeparatorAttribute() ?>" name="x_account_no" id="x_account_no" value="<?php echo HtmlEncode($collection_log->account_no->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcollection_loglistsrch.createAutoSuggest({"id":"x_account_no","forceSelect":true});
</script>
<?php echo $collection_log->account_no->Lookup->getParamTag("p_x_account_no") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($collection_log->revised_date->Visible) { // revised_date ?>
	<div id="xsc_revised_date" class="ew-cell form-group">
		<label for="x_revised_date" class="ew-search-caption ew-label"><?php echo $collection_log->revised_date->caption() ?></label>
		<span class="ew-search-operator"><select name="z_revised_date" id="z_revised_date" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($collection_log->revised_date->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($collection_log->revised_date->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($collection_log->revised_date->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($collection_log->revised_date->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($collection_log->revised_date->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($collection_log->revised_date->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($collection_log->revised_date->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($collection_log->revised_date->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($collection_log->revised_date->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="collection_log" data-field="x_revised_date" data-format="7" name="x_revised_date" id="x_revised_date" placeholder="<?php echo HtmlEncode($collection_log->revised_date->getPlaceHolder()) ?>" value="<?php echo $collection_log->revised_date->EditValue ?>"<?php echo $collection_log->revised_date->editAttributes() ?>>
<?php if (!$collection_log->revised_date->ReadOnly && !$collection_log->revised_date->Disabled && !isset($collection_log->revised_date->EditAttrs["readonly"]) && !isset($collection_log->revised_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fcollection_loglistsrch", "x_revised_date", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
		<span class="ew-search-cond btw1_revised_date style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_revised_date style="d-none"">
<input type="text" data-table="collection_log" data-field="x_revised_date" data-format="7" name="y_revised_date" id="y_revised_date" placeholder="<?php echo HtmlEncode($collection_log->revised_date->getPlaceHolder()) ?>" value="<?php echo $collection_log->revised_date->EditValue2 ?>"<?php echo $collection_log->revised_date->editAttributes() ?>>
<?php if (!$collection_log->revised_date->ReadOnly && !$collection_log->revised_date->Disabled && !isset($collection_log->revised_date->EditAttrs["readonly"]) && !isset($collection_log->revised_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fcollection_loglistsrch", "y_revised_date", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
<?php if ($collection_log->updated->Visible) { // updated ?>
	<div id="xsc_updated" class="ew-cell form-group">
		<label for="x_updated" class="ew-search-caption ew-label"><?php echo $collection_log->updated->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_updated" id="z_updated" value="LIKE"></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="collection_log" data-field="x_updated" data-value-separator="<?php echo $collection_log->updated->displayValueSeparatorAttribute() ?>" id="x_updated" name="x_updated"<?php echo $collection_log->updated->editAttributes() ?>>
		<?php echo $collection_log->updated->selectOptionListHtml("x_updated") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($collection_log_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($collection_log_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $collection_log_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($collection_log_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($collection_log_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($collection_log_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($collection_log_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $collection_log_list->showPageHeader(); ?>
<?php
$collection_log_list->showMessage();
?>
<?php if ($collection_log_list->TotalRecs > 0 || $collection_log->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($collection_log_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> collection_log">
<?php if (!$collection_log->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$collection_log->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($collection_log_list->Pager)) $collection_log_list->Pager = new PrevNextPager($collection_log_list->StartRec, $collection_log_list->DisplayRecs, $collection_log_list->TotalRecs, $collection_log_list->AutoHidePager) ?>
<?php if ($collection_log_list->Pager->RecordCount > 0 && $collection_log_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($collection_log_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $collection_log_list->pageUrl() ?>start=<?php echo $collection_log_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($collection_log_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $collection_log_list->pageUrl() ?>start=<?php echo $collection_log_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $collection_log_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($collection_log_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $collection_log_list->pageUrl() ?>start=<?php echo $collection_log_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($collection_log_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $collection_log_list->pageUrl() ?>start=<?php echo $collection_log_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $collection_log_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($collection_log_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $collection_log_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $collection_log_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $collection_log_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($collection_log_list->TotalRecs > 0 && (!$collection_log_list->AutoHidePageSizeSelector || $collection_log_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="collection_log">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($collection_log_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($collection_log_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($collection_log_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($collection_log_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($collection_log_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($collection_log->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $collection_log_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fcollection_loglist" id="fcollection_loglist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($collection_log_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $collection_log_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="collection_log">
<div id="gmp_collection_log" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($collection_log_list->TotalRecs > 0 || $collection_log->isGridEdit()) { ?>
<table id="tbl_collection_loglist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$collection_log_list->RowType = ROWTYPE_HEADER;

// Render list options
$collection_log_list->renderListOptions();

// Render list options (header, left)
$collection_log_list->ListOptions->render("header", "left");
?>
<?php if ($collection_log->id->Visible) { // id ?>
	<?php if ($collection_log->sortUrl($collection_log->id) == "") { ?>
		<th data-name="id" class="<?php echo $collection_log->id->headerCellClass() ?>"><div id="elh_collection_log_id" class="collection_log_id"><div class="ew-table-header-caption"><?php echo $collection_log->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $collection_log->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $collection_log->SortUrl($collection_log->id) ?>',2);"><div id="elh_collection_log_id" class="collection_log_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $collection_log->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($collection_log->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($collection_log->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($collection_log->location->Visible) { // location ?>
	<?php if ($collection_log->sortUrl($collection_log->location) == "") { ?>
		<th data-name="location" class="<?php echo $collection_log->location->headerCellClass() ?>"><div id="elh_collection_log_location" class="collection_log_location"><div class="ew-table-header-caption"><?php echo $collection_log->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $collection_log->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $collection_log->SortUrl($collection_log->location) ?>',2);"><div id="elh_collection_log_location" class="collection_log_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $collection_log->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($collection_log->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($collection_log->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($collection_log->agent->Visible) { // agent ?>
	<?php if ($collection_log->sortUrl($collection_log->agent) == "") { ?>
		<th data-name="agent" class="<?php echo $collection_log->agent->headerCellClass() ?>"><div id="elh_collection_log_agent" class="collection_log_agent"><div class="ew-table-header-caption"><?php echo $collection_log->agent->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="agent" class="<?php echo $collection_log->agent->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $collection_log->SortUrl($collection_log->agent) ?>',2);"><div id="elh_collection_log_agent" class="collection_log_agent">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $collection_log->agent->caption() ?></span><span class="ew-table-header-sort"><?php if ($collection_log->agent->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($collection_log->agent->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($collection_log->account_no->Visible) { // account_no ?>
	<?php if ($collection_log->sortUrl($collection_log->account_no) == "") { ?>
		<th data-name="account_no" class="<?php echo $collection_log->account_no->headerCellClass() ?>"><div id="elh_collection_log_account_no" class="collection_log_account_no"><div class="ew-table-header-caption"><?php echo $collection_log->account_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="account_no" class="<?php echo $collection_log->account_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $collection_log->SortUrl($collection_log->account_no) ?>',2);"><div id="elh_collection_log_account_no" class="collection_log_account_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $collection_log->account_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($collection_log->account_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($collection_log->account_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($collection_log->emi_no->Visible) { // emi_no ?>
	<?php if ($collection_log->sortUrl($collection_log->emi_no) == "") { ?>
		<th data-name="emi_no" class="<?php echo $collection_log->emi_no->headerCellClass() ?>"><div id="elh_collection_log_emi_no" class="collection_log_emi_no"><div class="ew-table-header-caption"><?php echo $collection_log->emi_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="emi_no" class="<?php echo $collection_log->emi_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $collection_log->SortUrl($collection_log->emi_no) ?>',2);"><div id="elh_collection_log_emi_no" class="collection_log_emi_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $collection_log->emi_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($collection_log->emi_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($collection_log->emi_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($collection_log->amount->Visible) { // amount ?>
	<?php if ($collection_log->sortUrl($collection_log->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $collection_log->amount->headerCellClass() ?>"><div id="elh_collection_log_amount" class="collection_log_amount"><div class="ew-table-header-caption"><?php echo $collection_log->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $collection_log->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $collection_log->SortUrl($collection_log->amount) ?>',2);"><div id="elh_collection_log_amount" class="collection_log_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $collection_log->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($collection_log->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($collection_log->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($collection_log->revised_date->Visible) { // revised_date ?>
	<?php if ($collection_log->sortUrl($collection_log->revised_date) == "") { ?>
		<th data-name="revised_date" class="<?php echo $collection_log->revised_date->headerCellClass() ?>"><div id="elh_collection_log_revised_date" class="collection_log_revised_date"><div class="ew-table-header-caption"><?php echo $collection_log->revised_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="revised_date" class="<?php echo $collection_log->revised_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $collection_log->SortUrl($collection_log->revised_date) ?>',2);"><div id="elh_collection_log_revised_date" class="collection_log_revised_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $collection_log->revised_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($collection_log->revised_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($collection_log->revised_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($collection_log->updated->Visible) { // updated ?>
	<?php if ($collection_log->sortUrl($collection_log->updated) == "") { ?>
		<th data-name="updated" class="<?php echo $collection_log->updated->headerCellClass() ?>"><div id="elh_collection_log_updated" class="collection_log_updated"><div class="ew-table-header-caption"><?php echo $collection_log->updated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="updated" class="<?php echo $collection_log->updated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $collection_log->SortUrl($collection_log->updated) ?>',2);"><div id="elh_collection_log_updated" class="collection_log_updated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $collection_log->updated->caption() ?></span><span class="ew-table-header-sort"><?php if ($collection_log->updated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($collection_log->updated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$collection_log_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($collection_log->ExportAll && $collection_log->isExport()) {
	$collection_log_list->StopRec = $collection_log_list->TotalRecs;
} else {

	// Set the last record to display
	if ($collection_log_list->TotalRecs > $collection_log_list->StartRec + $collection_log_list->DisplayRecs - 1)
		$collection_log_list->StopRec = $collection_log_list->StartRec + $collection_log_list->DisplayRecs - 1;
	else
		$collection_log_list->StopRec = $collection_log_list->TotalRecs;
}
$collection_log_list->RecCnt = $collection_log_list->StartRec - 1;
if ($collection_log_list->Recordset && !$collection_log_list->Recordset->EOF) {
	$collection_log_list->Recordset->moveFirst();
	$selectLimit = $collection_log_list->UseSelectLimit;
	if (!$selectLimit && $collection_log_list->StartRec > 1)
		$collection_log_list->Recordset->move($collection_log_list->StartRec - 1);
} elseif (!$collection_log->AllowAddDeleteRow && $collection_log_list->StopRec == 0) {
	$collection_log_list->StopRec = $collection_log->GridAddRowCount;
}

// Initialize aggregate
$collection_log->RowType = ROWTYPE_AGGREGATEINIT;
$collection_log->resetAttributes();
$collection_log_list->renderRow();
while ($collection_log_list->RecCnt < $collection_log_list->StopRec) {
	$collection_log_list->RecCnt++;
	if ($collection_log_list->RecCnt >= $collection_log_list->StartRec) {
		$collection_log_list->RowCnt++;

		// Set up key count
		$collection_log_list->KeyCount = $collection_log_list->RowIndex;

		// Init row class and style
		$collection_log->resetAttributes();
		$collection_log->CssClass = "";
		if ($collection_log->isGridAdd()) {
		} else {
			$collection_log_list->loadRowValues($collection_log_list->Recordset); // Load row values
		}
		$collection_log->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$collection_log->RowAttrs = array_merge($collection_log->RowAttrs, array('data-rowindex'=>$collection_log_list->RowCnt, 'id'=>'r' . $collection_log_list->RowCnt . '_collection_log', 'data-rowtype'=>$collection_log->RowType));

		// Render row
		$collection_log_list->renderRow();

		// Render list options
		$collection_log_list->renderListOptions();
?>
	<tr<?php echo $collection_log->rowAttributes() ?>>
<?php

// Render list options (body, left)
$collection_log_list->ListOptions->render("body", "left", $collection_log_list->RowCnt);
?>
	<?php if ($collection_log->id->Visible) { // id ?>
		<td data-name="id"<?php echo $collection_log->id->cellAttributes() ?>>
<span id="el<?php echo $collection_log_list->RowCnt ?>_collection_log_id" class="collection_log_id">
<span<?php echo $collection_log->id->viewAttributes() ?>>
<?php echo $collection_log->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($collection_log->location->Visible) { // location ?>
		<td data-name="location"<?php echo $collection_log->location->cellAttributes() ?>>
<span id="el<?php echo $collection_log_list->RowCnt ?>_collection_log_location" class="collection_log_location">
<span<?php echo $collection_log->location->viewAttributes() ?>>
<?php echo $collection_log->location->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($collection_log->agent->Visible) { // agent ?>
		<td data-name="agent"<?php echo $collection_log->agent->cellAttributes() ?>>
<span id="el<?php echo $collection_log_list->RowCnt ?>_collection_log_agent" class="collection_log_agent">
<span<?php echo $collection_log->agent->viewAttributes() ?>>
<?php echo $collection_log->agent->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($collection_log->account_no->Visible) { // account_no ?>
		<td data-name="account_no"<?php echo $collection_log->account_no->cellAttributes() ?>>
<span id="el<?php echo $collection_log_list->RowCnt ?>_collection_log_account_no" class="collection_log_account_no">
<span<?php echo $collection_log->account_no->viewAttributes() ?>>
<?php echo $collection_log->account_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($collection_log->emi_no->Visible) { // emi_no ?>
		<td data-name="emi_no"<?php echo $collection_log->emi_no->cellAttributes() ?>>
<span id="el<?php echo $collection_log_list->RowCnt ?>_collection_log_emi_no" class="collection_log_emi_no">
<span<?php echo $collection_log->emi_no->viewAttributes() ?>>
<?php echo $collection_log->emi_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($collection_log->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $collection_log->amount->cellAttributes() ?>>
<span id="el<?php echo $collection_log_list->RowCnt ?>_collection_log_amount" class="collection_log_amount">
<span<?php echo $collection_log->amount->viewAttributes() ?>>
<?php if ((!EmptyString($collection_log->amount->getViewValue())) && $collection_log->amount->linkAttributes() <> "") { ?>
<a<?php echo $collection_log->amount->linkAttributes() ?>><?php echo $collection_log->amount->getViewValue() ?></a>
<?php } else { ?>
<?php echo $collection_log->amount->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($collection_log->revised_date->Visible) { // revised_date ?>
		<td data-name="revised_date"<?php echo $collection_log->revised_date->cellAttributes() ?>>
<span id="el<?php echo $collection_log_list->RowCnt ?>_collection_log_revised_date" class="collection_log_revised_date">
<span<?php echo $collection_log->revised_date->viewAttributes() ?>>
<?php echo $collection_log->revised_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($collection_log->updated->Visible) { // updated ?>
		<td data-name="updated"<?php echo $collection_log->updated->cellAttributes() ?>>
<span id="el<?php echo $collection_log_list->RowCnt ?>_collection_log_updated" class="collection_log_updated">
<span<?php echo $collection_log->updated->viewAttributes() ?>>
<?php echo $collection_log->updated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$collection_log_list->ListOptions->render("body", "right", $collection_log_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$collection_log->isGridAdd())
		$collection_log_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$collection_log->RowType = ROWTYPE_AGGREGATE;
$collection_log->resetAttributes();
$collection_log_list->renderRow();
?>
<?php if ($collection_log_list->TotalRecs > 0 && !$collection_log->isGridAdd() && !$collection_log->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$collection_log_list->renderListOptions();

// Render list options (footer, left)
$collection_log_list->ListOptions->render("footer", "left");
?>
	<?php if ($collection_log->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $collection_log->id->footerCellClass() ?>"><span id="elf_collection_log_id" class="collection_log_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($collection_log->location->Visible) { // location ?>
		<td data-name="location" class="<?php echo $collection_log->location->footerCellClass() ?>"><span id="elf_collection_log_location" class="collection_log_location">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($collection_log->agent->Visible) { // agent ?>
		<td data-name="agent" class="<?php echo $collection_log->agent->footerCellClass() ?>"><span id="elf_collection_log_agent" class="collection_log_agent">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($collection_log->account_no->Visible) { // account_no ?>
		<td data-name="account_no" class="<?php echo $collection_log->account_no->footerCellClass() ?>"><span id="elf_collection_log_account_no" class="collection_log_account_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($collection_log->emi_no->Visible) { // emi_no ?>
		<td data-name="emi_no" class="<?php echo $collection_log->emi_no->footerCellClass() ?>"><span id="elf_collection_log_emi_no" class="collection_log_emi_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($collection_log->amount->Visible) { // amount ?>
		<td data-name="amount" class="<?php echo $collection_log->amount->footerCellClass() ?>"><span id="elf_collection_log_amount" class="collection_log_amount">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $collection_log->amount->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($collection_log->revised_date->Visible) { // revised_date ?>
		<td data-name="revised_date" class="<?php echo $collection_log->revised_date->footerCellClass() ?>"><span id="elf_collection_log_revised_date" class="collection_log_revised_date">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($collection_log->updated->Visible) { // updated ?>
		<td data-name="updated" class="<?php echo $collection_log->updated->footerCellClass() ?>"><span id="elf_collection_log_updated" class="collection_log_updated">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$collection_log_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$collection_log->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($collection_log_list->Recordset)
	$collection_log_list->Recordset->Close();
?>
<?php if (!$collection_log->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$collection_log->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($collection_log_list->Pager)) $collection_log_list->Pager = new PrevNextPager($collection_log_list->StartRec, $collection_log_list->DisplayRecs, $collection_log_list->TotalRecs, $collection_log_list->AutoHidePager) ?>
<?php if ($collection_log_list->Pager->RecordCount > 0 && $collection_log_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($collection_log_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $collection_log_list->pageUrl() ?>start=<?php echo $collection_log_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($collection_log_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $collection_log_list->pageUrl() ?>start=<?php echo $collection_log_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $collection_log_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($collection_log_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $collection_log_list->pageUrl() ?>start=<?php echo $collection_log_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($collection_log_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $collection_log_list->pageUrl() ?>start=<?php echo $collection_log_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $collection_log_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($collection_log_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $collection_log_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $collection_log_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $collection_log_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($collection_log_list->TotalRecs > 0 && (!$collection_log_list->AutoHidePageSizeSelector || $collection_log_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="collection_log">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($collection_log_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($collection_log_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($collection_log_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($collection_log_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($collection_log_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($collection_log->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $collection_log_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($collection_log_list->TotalRecs == 0 && !$collection_log->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $collection_log_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$collection_log_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$collection_log->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$collection_log->isExport()) { ?>
<script>
ew.scrollableTable("gmp_collection_log", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$collection_log_list->terminate();
?>