<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$collection_log_search = new collection_log_search();

// Run the page
$collection_log_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$collection_log_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($collection_log_search->IsModal) { ?>
var fcollection_logsearch = currentAdvancedSearchForm = new ew.Form("fcollection_logsearch", "search");
<?php } else { ?>
var fcollection_logsearch = currentForm = new ew.Form("fcollection_logsearch", "search");
<?php } ?>

// Form_CustomValidate event
fcollection_logsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcollection_logsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcollection_logsearch.lists["x_location"] = <?php echo $collection_log_search->location->Lookup->toClientList() ?>;
fcollection_logsearch.lists["x_location"].options = <?php echo JsonEncode($collection_log_search->location->lookupOptions()) ?>;
fcollection_logsearch.lists["x_agent"] = <?php echo $collection_log_search->agent->Lookup->toClientList() ?>;
fcollection_logsearch.lists["x_agent"].options = <?php echo JsonEncode($collection_log_search->agent->lookupOptions()) ?>;
fcollection_logsearch.lists["x_account_no"] = <?php echo $collection_log_search->account_no->Lookup->toClientList() ?>;
fcollection_logsearch.lists["x_account_no"].options = <?php echo JsonEncode($collection_log_search->account_no->lookupOptions()) ?>;
fcollection_logsearch.autoSuggests["x_account_no"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fcollection_logsearch.lists["x_updated"] = <?php echo $collection_log_search->updated->Lookup->toClientList() ?>;
fcollection_logsearch.lists["x_updated"].options = <?php echo JsonEncode($collection_log_search->updated->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

fcollection_logsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($collection_log->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_account_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($collection_log->account_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_emi_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($collection_log->emi_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($collection_log->amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkEuroDate(elm.value))
		return this.onError(elm, "<?php echo JsEncode($collection_log->dated->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_revised_date");
	if (elm && !ew.checkEuroDate(elm.value))
		return this.onError(elm, "<?php echo JsEncode($collection_log->revised_date->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $collection_log_search->showPageHeader(); ?>
<?php
$collection_log_search->showMessage();
?>
<form name="fcollection_logsearch" id="fcollection_logsearch" class="<?php echo $collection_log_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($collection_log_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $collection_log_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="collection_log">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$collection_log_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($collection_log->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $collection_log_search->LeftColumnClass ?>"><span id="elh_collection_log_id"><?php echo $collection_log->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $collection_log_search->RightColumnClass ?>"><div<?php echo $collection_log->id->cellAttributes() ?>>
			<span id="el_collection_log_id">
<input type="text" data-table="collection_log" data-field="x_id" name="x_id" id="x_id" size="30" placeholder="<?php echo HtmlEncode($collection_log->id->getPlaceHolder()) ?>" value="<?php echo $collection_log->id->EditValue ?>"<?php echo $collection_log->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($collection_log->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label for="x_location" class="<?php echo $collection_log_search->LeftColumnClass ?>"><span id="elh_collection_log_location"><?php echo $collection_log->location->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		</label>
		<div class="<?php echo $collection_log_search->RightColumnClass ?>"><div<?php echo $collection_log->location->cellAttributes() ?>>
			<span id="el_collection_log_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="collection_log" data-field="x_location" data-value-separator="<?php echo $collection_log->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $collection_log->location->editAttributes() ?>>
		<?php echo $collection_log->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $collection_log->location->Lookup->getParamTag("p_x_location") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($collection_log->agent->Visible) { // agent ?>
	<div id="r_agent" class="form-group row">
		<label for="x_agent" class="<?php echo $collection_log_search->LeftColumnClass ?>"><span id="elh_collection_log_agent"><?php echo $collection_log->agent->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_agent" id="z_agent" value="="></span>
		</label>
		<div class="<?php echo $collection_log_search->RightColumnClass ?>"><div<?php echo $collection_log->agent->cellAttributes() ?>>
			<span id="el_collection_log_agent">
<?php if (!$Security->isAdmin() && $Security->isLoggedIn() && !$collection_log->userIDAllow("search")) { // Non system admin ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="collection_log" data-field="x_agent" data-value-separator="<?php echo $collection_log->agent->displayValueSeparatorAttribute() ?>" id="x_agent" name="x_agent"<?php echo $collection_log->agent->editAttributes() ?>>
		<?php echo $collection_log->agent->selectOptionListHtml("x_agent") ?>
	</select>
</div>
<?php echo $collection_log->agent->Lookup->getParamTag("p_x_agent") ?>
<?php } else { ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="collection_log" data-field="x_agent" data-value-separator="<?php echo $collection_log->agent->displayValueSeparatorAttribute() ?>" id="x_agent" name="x_agent"<?php echo $collection_log->agent->editAttributes() ?>>
		<?php echo $collection_log->agent->selectOptionListHtml("x_agent") ?>
	</select>
</div>
<?php echo $collection_log->agent->Lookup->getParamTag("p_x_agent") ?>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($collection_log->account_no->Visible) { // account_no ?>
	<div id="r_account_no" class="form-group row">
		<label class="<?php echo $collection_log_search->LeftColumnClass ?>"><span id="elh_collection_log_account_no"><?php echo $collection_log->account_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_account_no" id="z_account_no" value="="></span>
		</label>
		<div class="<?php echo $collection_log_search->RightColumnClass ?>"><div<?php echo $collection_log->account_no->cellAttributes() ?>>
			<span id="el_collection_log_account_no">
<?php
$wrkonchange = "" . trim(@$collection_log->account_no->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$collection_log->account_no->EditAttrs["onchange"] = "";
?>
<span id="as_x_account_no" class="text-nowrap" style="z-index: 8960">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_account_no" id="sv_x_account_no" value="<?php echo RemoveHtml($collection_log->account_no->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($collection_log->account_no->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($collection_log->account_no->getPlaceHolder()) ?>"<?php echo $collection_log->account_no->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($collection_log->account_no->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_account_no',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($collection_log->account_no->ReadOnly || $collection_log->account_no->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="collection_log" data-field="x_account_no" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $collection_log->account_no->displayValueSeparatorAttribute() ?>" name="x_account_no" id="x_account_no" value="<?php echo HtmlEncode($collection_log->account_no->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcollection_logsearch.createAutoSuggest({"id":"x_account_no","forceSelect":true});
</script>
<?php echo $collection_log->account_no->Lookup->getParamTag("p_x_account_no") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($collection_log->emi_no->Visible) { // emi_no ?>
	<div id="r_emi_no" class="form-group row">
		<label for="x_emi_no" class="<?php echo $collection_log_search->LeftColumnClass ?>"><span id="elh_collection_log_emi_no"><?php echo $collection_log->emi_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_emi_no" id="z_emi_no" value="="></span>
		</label>
		<div class="<?php echo $collection_log_search->RightColumnClass ?>"><div<?php echo $collection_log->emi_no->cellAttributes() ?>>
			<span id="el_collection_log_emi_no">
<input type="text" data-table="collection_log" data-field="x_emi_no" name="x_emi_no" id="x_emi_no" size="30" placeholder="<?php echo HtmlEncode($collection_log->emi_no->getPlaceHolder()) ?>" value="<?php echo $collection_log->emi_no->EditValue ?>"<?php echo $collection_log->emi_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($collection_log->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label for="x_amount" class="<?php echo $collection_log_search->LeftColumnClass ?>"><span id="elh_collection_log_amount"><?php echo $collection_log->amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_amount" id="z_amount" value="="></span>
		</label>
		<div class="<?php echo $collection_log_search->RightColumnClass ?>"><div<?php echo $collection_log->amount->cellAttributes() ?>>
			<span id="el_collection_log_amount">
<input type="text" data-table="collection_log" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($collection_log->amount->getPlaceHolder()) ?>" value="<?php echo $collection_log->amount->EditValue ?>"<?php echo $collection_log->amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($collection_log->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $collection_log_search->LeftColumnClass ?>"><span id="elh_collection_log_dated"><?php echo $collection_log->dated->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_dated" id="z_dated" value="="></span>
		</label>
		<div class="<?php echo $collection_log_search->RightColumnClass ?>"><div<?php echo $collection_log->dated->cellAttributes() ?>>
			<span id="el_collection_log_dated">
<input type="text" data-table="collection_log" data-field="x_dated" data-format="7" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($collection_log->dated->getPlaceHolder()) ?>" value="<?php echo $collection_log->dated->EditValue ?>"<?php echo $collection_log->dated->editAttributes() ?>>
<?php if (!$collection_log->dated->ReadOnly && !$collection_log->dated->Disabled && !isset($collection_log->dated->EditAttrs["readonly"]) && !isset($collection_log->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fcollection_logsearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($collection_log->revised_date->Visible) { // revised_date ?>
	<div id="r_revised_date" class="form-group row">
		<label for="x_revised_date" class="<?php echo $collection_log_search->LeftColumnClass ?>"><span id="elh_collection_log_revised_date"><?php echo $collection_log->revised_date->caption() ?></span>
		</label>
		<div class="<?php echo $collection_log_search->RightColumnClass ?>"><div<?php echo $collection_log->revised_date->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_revised_date" id="z_revised_date" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($collection_log->revised_date->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($collection_log->revised_date->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($collection_log->revised_date->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($collection_log->revised_date->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($collection_log->revised_date->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($collection_log->revised_date->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($collection_log->revised_date->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($collection_log->revised_date->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($collection_log->revised_date->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_collection_log_revised_date">
<input type="text" data-table="collection_log" data-field="x_revised_date" data-format="7" name="x_revised_date" id="x_revised_date" placeholder="<?php echo HtmlEncode($collection_log->revised_date->getPlaceHolder()) ?>" value="<?php echo $collection_log->revised_date->EditValue ?>"<?php echo $collection_log->revised_date->editAttributes() ?>>
<?php if (!$collection_log->revised_date->ReadOnly && !$collection_log->revised_date->Disabled && !isset($collection_log->revised_date->EditAttrs["readonly"]) && !isset($collection_log->revised_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fcollection_logsearch", "x_revised_date", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_revised_date d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_collection_log_revised_date" class="btw1_revised_date d-none">
<input type="text" data-table="collection_log" data-field="x_revised_date" data-format="7" name="y_revised_date" id="y_revised_date" placeholder="<?php echo HtmlEncode($collection_log->revised_date->getPlaceHolder()) ?>" value="<?php echo $collection_log->revised_date->EditValue2 ?>"<?php echo $collection_log->revised_date->editAttributes() ?>>
<?php if (!$collection_log->revised_date->ReadOnly && !$collection_log->revised_date->Disabled && !isset($collection_log->revised_date->EditAttrs["readonly"]) && !isset($collection_log->revised_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fcollection_logsearch", "y_revised_date", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($collection_log->updated->Visible) { // updated ?>
	<div id="r_updated" class="form-group row">
		<label for="x_updated" class="<?php echo $collection_log_search->LeftColumnClass ?>"><span id="elh_collection_log_updated"><?php echo $collection_log->updated->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_updated" id="z_updated" value="LIKE"></span>
		</label>
		<div class="<?php echo $collection_log_search->RightColumnClass ?>"><div<?php echo $collection_log->updated->cellAttributes() ?>>
			<span id="el_collection_log_updated">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="collection_log" data-field="x_updated" data-value-separator="<?php echo $collection_log->updated->displayValueSeparatorAttribute() ?>" id="x_updated" name="x_updated"<?php echo $collection_log->updated->editAttributes() ?>>
		<?php echo $collection_log->updated->selectOptionListHtml("x_updated") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$collection_log_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $collection_log_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$collection_log_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$collection_log_search->terminate();
?>