<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$collection_log_view = new collection_log_view();

// Run the page
$collection_log_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$collection_log_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$collection_log->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fcollection_logview = currentForm = new ew.Form("fcollection_logview", "view");

// Form_CustomValidate event
fcollection_logview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcollection_logview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcollection_logview.lists["x_location"] = <?php echo $collection_log_view->location->Lookup->toClientList() ?>;
fcollection_logview.lists["x_location"].options = <?php echo JsonEncode($collection_log_view->location->lookupOptions()) ?>;
fcollection_logview.lists["x_agent"] = <?php echo $collection_log_view->agent->Lookup->toClientList() ?>;
fcollection_logview.lists["x_agent"].options = <?php echo JsonEncode($collection_log_view->agent->lookupOptions()) ?>;
fcollection_logview.lists["x_account_no"] = <?php echo $collection_log_view->account_no->Lookup->toClientList() ?>;
fcollection_logview.lists["x_account_no"].options = <?php echo JsonEncode($collection_log_view->account_no->lookupOptions()) ?>;
fcollection_logview.autoSuggests["x_account_no"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fcollection_logview.lists["x_updated"] = <?php echo $collection_log_view->updated->Lookup->toClientList() ?>;
fcollection_logview.lists["x_updated"].options = <?php echo JsonEncode($collection_log_view->updated->options(FALSE, TRUE)) ?>;
fcollection_logview.lists["x_operator"] = <?php echo $collection_log_view->operator->Lookup->toClientList() ?>;
fcollection_logview.lists["x_operator"].options = <?php echo JsonEncode($collection_log_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$collection_log->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $collection_log_view->ExportOptions->render("body") ?>
<?php $collection_log_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $collection_log_view->showPageHeader(); ?>
<?php
$collection_log_view->showMessage();
?>
<form name="fcollection_logview" id="fcollection_logview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($collection_log_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $collection_log_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="collection_log">
<input type="hidden" name="modal" value="<?php echo (int)$collection_log_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($collection_log->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $collection_log_view->TableLeftColumnClass ?>"><span id="elh_collection_log_id"><?php echo $collection_log->id->caption() ?></span></td>
		<td data-name="id"<?php echo $collection_log->id->cellAttributes() ?>>
<span id="el_collection_log_id">
<span<?php echo $collection_log->id->viewAttributes() ?>>
<?php echo $collection_log->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($collection_log->location->Visible) { // location ?>
	<tr id="r_location">
		<td class="<?php echo $collection_log_view->TableLeftColumnClass ?>"><span id="elh_collection_log_location"><?php echo $collection_log->location->caption() ?></span></td>
		<td data-name="location"<?php echo $collection_log->location->cellAttributes() ?>>
<span id="el_collection_log_location">
<span<?php echo $collection_log->location->viewAttributes() ?>>
<?php echo $collection_log->location->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($collection_log->agent->Visible) { // agent ?>
	<tr id="r_agent">
		<td class="<?php echo $collection_log_view->TableLeftColumnClass ?>"><span id="elh_collection_log_agent"><?php echo $collection_log->agent->caption() ?></span></td>
		<td data-name="agent"<?php echo $collection_log->agent->cellAttributes() ?>>
<span id="el_collection_log_agent">
<span<?php echo $collection_log->agent->viewAttributes() ?>>
<?php echo $collection_log->agent->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($collection_log->account_no->Visible) { // account_no ?>
	<tr id="r_account_no">
		<td class="<?php echo $collection_log_view->TableLeftColumnClass ?>"><span id="elh_collection_log_account_no"><?php echo $collection_log->account_no->caption() ?></span></td>
		<td data-name="account_no"<?php echo $collection_log->account_no->cellAttributes() ?>>
<span id="el_collection_log_account_no">
<span<?php echo $collection_log->account_no->viewAttributes() ?>>
<?php echo $collection_log->account_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($collection_log->emi_no->Visible) { // emi_no ?>
	<tr id="r_emi_no">
		<td class="<?php echo $collection_log_view->TableLeftColumnClass ?>"><span id="elh_collection_log_emi_no"><?php echo $collection_log->emi_no->caption() ?></span></td>
		<td data-name="emi_no"<?php echo $collection_log->emi_no->cellAttributes() ?>>
<span id="el_collection_log_emi_no">
<span<?php echo $collection_log->emi_no->viewAttributes() ?>>
<?php echo $collection_log->emi_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($collection_log->amount->Visible) { // amount ?>
	<tr id="r_amount">
		<td class="<?php echo $collection_log_view->TableLeftColumnClass ?>"><span id="elh_collection_log_amount"><?php echo $collection_log->amount->caption() ?></span></td>
		<td data-name="amount"<?php echo $collection_log->amount->cellAttributes() ?>>
<span id="el_collection_log_amount">
<span<?php echo $collection_log->amount->viewAttributes() ?>>
<?php if ((!EmptyString($collection_log->amount->getViewValue())) && $collection_log->amount->linkAttributes() <> "") { ?>
<a<?php echo $collection_log->amount->linkAttributes() ?>><?php echo $collection_log->amount->getViewValue() ?></a>
<?php } else { ?>
<?php echo $collection_log->amount->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($collection_log->dated->Visible) { // dated ?>
	<tr id="r_dated">
		<td class="<?php echo $collection_log_view->TableLeftColumnClass ?>"><span id="elh_collection_log_dated"><?php echo $collection_log->dated->caption() ?></span></td>
		<td data-name="dated"<?php echo $collection_log->dated->cellAttributes() ?>>
<span id="el_collection_log_dated">
<span<?php echo $collection_log->dated->viewAttributes() ?>>
<?php echo $collection_log->dated->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($collection_log->revised_date->Visible) { // revised_date ?>
	<tr id="r_revised_date">
		<td class="<?php echo $collection_log_view->TableLeftColumnClass ?>"><span id="elh_collection_log_revised_date"><?php echo $collection_log->revised_date->caption() ?></span></td>
		<td data-name="revised_date"<?php echo $collection_log->revised_date->cellAttributes() ?>>
<span id="el_collection_log_revised_date">
<span<?php echo $collection_log->revised_date->viewAttributes() ?>>
<?php echo $collection_log->revised_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($collection_log->updated->Visible) { // updated ?>
	<tr id="r_updated">
		<td class="<?php echo $collection_log_view->TableLeftColumnClass ?>"><span id="elh_collection_log_updated"><?php echo $collection_log->updated->caption() ?></span></td>
		<td data-name="updated"<?php echo $collection_log->updated->cellAttributes() ?>>
<span id="el_collection_log_updated">
<span<?php echo $collection_log->updated->viewAttributes() ?>>
<?php echo $collection_log->updated->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($collection_log->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $collection_log_view->TableLeftColumnClass ?>"><span id="elh_collection_log_operator"><?php echo $collection_log->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $collection_log->operator->cellAttributes() ?>>
<span id="el_collection_log_operator">
<span<?php echo $collection_log->operator->viewAttributes() ?>>
<?php echo $collection_log->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($collection_log->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $collection_log_view->TableLeftColumnClass ?>"><span id="elh_collection_log_datetime"><?php echo $collection_log->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $collection_log->datetime->cellAttributes() ?>>
<span id="el_collection_log_datetime">
<span<?php echo $collection_log->datetime->viewAttributes() ?>>
<?php echo $collection_log->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$collection_log_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$collection_log->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$collection_log_view->terminate();
?>