<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$composition_edit = new composition_edit();

// Run the page
$composition_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$composition_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fcompositionedit = currentForm = new ew.Form("fcompositionedit", "edit");

// Validate form
fcompositionedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($composition_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $composition->id->caption(), $composition->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($composition_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $composition->grp->caption(), $composition->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($composition_edit->wool->Required) { ?>
			elm = this.getElements("x" + infix + "_wool");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $composition->wool->caption(), $composition->wool->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_wool");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($composition->wool->errorMessage()) ?>");
		<?php if ($composition_edit->viscose->Required) { ?>
			elm = this.getElements("x" + infix + "_viscose");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $composition->viscose->caption(), $composition->viscose->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_viscose");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($composition->viscose->errorMessage()) ?>");
		<?php if ($composition_edit->polyester->Required) { ?>
			elm = this.getElements("x" + infix + "_polyester");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $composition->polyester->caption(), $composition->polyester->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_polyester");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($composition->polyester->errorMessage()) ?>");
		<?php if ($composition_edit->cotton->Required) { ?>
			elm = this.getElements("x" + infix + "_cotton");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $composition->cotton->caption(), $composition->cotton->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_cotton");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($composition->cotton->errorMessage()) ?>");
		<?php if ($composition_edit->jute->Required) { ?>
			elm = this.getElements("x" + infix + "_jute");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $composition->jute->caption(), $composition->jute->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_jute");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($composition->jute->errorMessage()) ?>");
		<?php if ($composition_edit->other->Required) { ?>
			elm = this.getElements("x" + infix + "_other");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $composition->other->caption(), $composition->other->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_other");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($composition->other->errorMessage()) ?>");
		<?php if ($composition_edit->other_name->Required) { ?>
			elm = this.getElements("x" + infix + "_other_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $composition->other_name->caption(), $composition->other_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($composition_edit->description_type->Required) { ?>
			elm = this.getElements("x" + infix + "_description_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $composition->description_type->caption(), $composition->description_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($composition_edit->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $composition->code->caption(), $composition->code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($composition_edit->composition->Required) { ?>
			elm = this.getElements("x" + infix + "_composition");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $composition->composition->caption(), $composition->composition->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($composition_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $composition->status->caption(), $composition->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($composition_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $composition->operator->caption(), $composition->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($composition_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $composition->datetime->caption(), $composition->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fcompositionedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcompositionedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcompositionedit.lists["x_grp"] = <?php echo $composition_edit->grp->Lookup->toClientList() ?>;
fcompositionedit.lists["x_grp"].options = <?php echo JsonEncode($composition_edit->grp->lookupOptions()) ?>;
fcompositionedit.lists["x_description_type"] = <?php echo $composition_edit->description_type->Lookup->toClientList() ?>;
fcompositionedit.lists["x_description_type"].options = <?php echo JsonEncode($composition_edit->description_type->options(FALSE, TRUE)) ?>;
fcompositionedit.lists["x_status"] = <?php echo $composition_edit->status->Lookup->toClientList() ?>;
fcompositionedit.lists["x_status"].options = <?php echo JsonEncode($composition_edit->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $composition_edit->showPageHeader(); ?>
<?php
$composition_edit->showMessage();
?>
<form name="fcompositionedit" id="fcompositionedit" class="<?php echo $composition_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($composition_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $composition_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="composition">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$composition_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($composition->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_composition_id" class="<?php echo $composition_edit->LeftColumnClass ?>"><?php echo $composition->id->caption() ?><?php echo ($composition->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $composition_edit->RightColumnClass ?>"><div<?php echo $composition->id->cellAttributes() ?>>
<span id="el_composition_id">
<span<?php echo $composition->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($composition->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="composition" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($composition->id->CurrentValue) ?>">
<?php echo $composition->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($composition->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_composition_grp" for="x_grp" class="<?php echo $composition_edit->LeftColumnClass ?>"><?php echo $composition->grp->caption() ?><?php echo ($composition->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $composition_edit->RightColumnClass ?>"><div<?php echo $composition->grp->cellAttributes() ?>>
<span id="el_composition_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="composition" data-field="x_grp" data-value-separator="<?php echo $composition->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $composition->grp->editAttributes() ?>>
		<?php echo $composition->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $composition->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $composition->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($composition->wool->Visible) { // wool ?>
	<div id="r_wool" class="form-group row">
		<label id="elh_composition_wool" for="x_wool" class="<?php echo $composition_edit->LeftColumnClass ?>"><?php echo $composition->wool->caption() ?><?php echo ($composition->wool->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $composition_edit->RightColumnClass ?>"><div<?php echo $composition->wool->cellAttributes() ?>>
<span id="el_composition_wool">
<input type="text" data-table="composition" data-field="x_wool" name="x_wool" id="x_wool" size="30" placeholder="<?php echo HtmlEncode($composition->wool->getPlaceHolder()) ?>" value="<?php echo $composition->wool->EditValue ?>"<?php echo $composition->wool->editAttributes() ?>>
</span>
<?php echo $composition->wool->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($composition->viscose->Visible) { // viscose ?>
	<div id="r_viscose" class="form-group row">
		<label id="elh_composition_viscose" for="x_viscose" class="<?php echo $composition_edit->LeftColumnClass ?>"><?php echo $composition->viscose->caption() ?><?php echo ($composition->viscose->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $composition_edit->RightColumnClass ?>"><div<?php echo $composition->viscose->cellAttributes() ?>>
<span id="el_composition_viscose">
<input type="text" data-table="composition" data-field="x_viscose" name="x_viscose" id="x_viscose" size="30" placeholder="<?php echo HtmlEncode($composition->viscose->getPlaceHolder()) ?>" value="<?php echo $composition->viscose->EditValue ?>"<?php echo $composition->viscose->editAttributes() ?>>
</span>
<?php echo $composition->viscose->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($composition->polyester->Visible) { // polyester ?>
	<div id="r_polyester" class="form-group row">
		<label id="elh_composition_polyester" for="x_polyester" class="<?php echo $composition_edit->LeftColumnClass ?>"><?php echo $composition->polyester->caption() ?><?php echo ($composition->polyester->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $composition_edit->RightColumnClass ?>"><div<?php echo $composition->polyester->cellAttributes() ?>>
<span id="el_composition_polyester">
<input type="text" data-table="composition" data-field="x_polyester" name="x_polyester" id="x_polyester" size="30" placeholder="<?php echo HtmlEncode($composition->polyester->getPlaceHolder()) ?>" value="<?php echo $composition->polyester->EditValue ?>"<?php echo $composition->polyester->editAttributes() ?>>
</span>
<?php echo $composition->polyester->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($composition->cotton->Visible) { // cotton ?>
	<div id="r_cotton" class="form-group row">
		<label id="elh_composition_cotton" for="x_cotton" class="<?php echo $composition_edit->LeftColumnClass ?>"><?php echo $composition->cotton->caption() ?><?php echo ($composition->cotton->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $composition_edit->RightColumnClass ?>"><div<?php echo $composition->cotton->cellAttributes() ?>>
<span id="el_composition_cotton">
<input type="text" data-table="composition" data-field="x_cotton" name="x_cotton" id="x_cotton" size="30" placeholder="<?php echo HtmlEncode($composition->cotton->getPlaceHolder()) ?>" value="<?php echo $composition->cotton->EditValue ?>"<?php echo $composition->cotton->editAttributes() ?>>
</span>
<?php echo $composition->cotton->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($composition->jute->Visible) { // jute ?>
	<div id="r_jute" class="form-group row">
		<label id="elh_composition_jute" for="x_jute" class="<?php echo $composition_edit->LeftColumnClass ?>"><?php echo $composition->jute->caption() ?><?php echo ($composition->jute->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $composition_edit->RightColumnClass ?>"><div<?php echo $composition->jute->cellAttributes() ?>>
<span id="el_composition_jute">
<input type="text" data-table="composition" data-field="x_jute" name="x_jute" id="x_jute" size="30" placeholder="<?php echo HtmlEncode($composition->jute->getPlaceHolder()) ?>" value="<?php echo $composition->jute->EditValue ?>"<?php echo $composition->jute->editAttributes() ?>>
</span>
<?php echo $composition->jute->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($composition->other->Visible) { // other ?>
	<div id="r_other" class="form-group row">
		<label id="elh_composition_other" for="x_other" class="<?php echo $composition_edit->LeftColumnClass ?>"><?php echo $composition->other->caption() ?><?php echo ($composition->other->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $composition_edit->RightColumnClass ?>"><div<?php echo $composition->other->cellAttributes() ?>>
<span id="el_composition_other">
<input type="text" data-table="composition" data-field="x_other" name="x_other" id="x_other" size="30" placeholder="<?php echo HtmlEncode($composition->other->getPlaceHolder()) ?>" value="<?php echo $composition->other->EditValue ?>"<?php echo $composition->other->editAttributes() ?>>
</span>
<?php echo $composition->other->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($composition->other_name->Visible) { // other_name ?>
	<div id="r_other_name" class="form-group row">
		<label id="elh_composition_other_name" for="x_other_name" class="<?php echo $composition_edit->LeftColumnClass ?>"><?php echo $composition->other_name->caption() ?><?php echo ($composition->other_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $composition_edit->RightColumnClass ?>"><div<?php echo $composition->other_name->cellAttributes() ?>>
<span id="el_composition_other_name">
<input type="text" data-table="composition" data-field="x_other_name" name="x_other_name" id="x_other_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($composition->other_name->getPlaceHolder()) ?>" value="<?php echo $composition->other_name->EditValue ?>"<?php echo $composition->other_name->editAttributes() ?>>
</span>
<?php echo $composition->other_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($composition->description_type->Visible) { // description_type ?>
	<div id="r_description_type" class="form-group row">
		<label id="elh_composition_description_type" for="x_description_type" class="<?php echo $composition_edit->LeftColumnClass ?>"><?php echo $composition->description_type->caption() ?><?php echo ($composition->description_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $composition_edit->RightColumnClass ?>"><div<?php echo $composition->description_type->cellAttributes() ?>>
<span id="el_composition_description_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="composition" data-field="x_description_type" data-value-separator="<?php echo $composition->description_type->displayValueSeparatorAttribute() ?>" id="x_description_type" name="x_description_type"<?php echo $composition->description_type->editAttributes() ?>>
		<?php echo $composition->description_type->selectOptionListHtml("x_description_type") ?>
	</select>
</div>
</span>
<?php echo $composition->description_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($composition->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label id="elh_composition_code" for="x_code" class="<?php echo $composition_edit->LeftColumnClass ?>"><?php echo $composition->code->caption() ?><?php echo ($composition->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $composition_edit->RightColumnClass ?>"><div<?php echo $composition->code->cellAttributes() ?>>
<span id="el_composition_code">
<input type="text" data-table="composition" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($composition->code->getPlaceHolder()) ?>" value="<?php echo $composition->code->EditValue ?>"<?php echo $composition->code->editAttributes() ?>>
</span>
<?php echo $composition->code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($composition->composition->Visible) { // composition ?>
	<div id="r_composition" class="form-group row">
		<label id="elh_composition_composition" for="x_composition" class="<?php echo $composition_edit->LeftColumnClass ?>"><?php echo $composition->composition->caption() ?><?php echo ($composition->composition->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $composition_edit->RightColumnClass ?>"><div<?php echo $composition->composition->cellAttributes() ?>>
<span id="el_composition_composition">
<input type="text" data-table="composition" data-field="x_composition" name="x_composition" id="x_composition" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($composition->composition->getPlaceHolder()) ?>" value="<?php echo $composition->composition->EditValue ?>"<?php echo $composition->composition->editAttributes() ?>>
</span>
<?php echo $composition->composition->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($composition->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_composition_status" for="x_status" class="<?php echo $composition_edit->LeftColumnClass ?>"><?php echo $composition->status->caption() ?><?php echo ($composition->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $composition_edit->RightColumnClass ?>"><div<?php echo $composition->status->cellAttributes() ?>>
<span id="el_composition_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="composition" data-field="x_status" data-value-separator="<?php echo $composition->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $composition->status->editAttributes() ?>>
		<?php echo $composition->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $composition->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$composition_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $composition_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $composition_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$composition_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

		var	type = $("#x_description_type").val();
			if ((type == 0) && (document.URL.includes("add")))
			{
				$("#r_composition").hide();
			}
			else if ((type == 0) && (document.URL.includes("edit")))
			{
				$("#r_composition").show();
				$("#x_composition").attr('readonly','readonly')
			}
			else
			{
				$("#r_composition").show();
				$("#x_composition").removeAttr('readonly')
			}
</script>
<?php include_once "footer.php" ?>
<?php
$composition_edit->terminate();
?>