<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$composition_list = new composition_list();

// Run the page
$composition_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$composition_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$composition->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fcompositionlist = currentForm = new ew.Form("fcompositionlist", "list");
fcompositionlist.formKeyCountName = '<?php echo $composition_list->FormKeyCountName ?>';

// Form_CustomValidate event
fcompositionlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcompositionlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcompositionlist.lists["x_grp"] = <?php echo $composition_list->grp->Lookup->toClientList() ?>;
fcompositionlist.lists["x_grp"].options = <?php echo JsonEncode($composition_list->grp->lookupOptions()) ?>;
fcompositionlist.lists["x_description_type"] = <?php echo $composition_list->description_type->Lookup->toClientList() ?>;
fcompositionlist.lists["x_description_type"].options = <?php echo JsonEncode($composition_list->description_type->options(FALSE, TRUE)) ?>;
fcompositionlist.lists["x_status"] = <?php echo $composition_list->status->Lookup->toClientList() ?>;
fcompositionlist.lists["x_status"].options = <?php echo JsonEncode($composition_list->status->options(FALSE, TRUE)) ?>;

// Form object for search
var fcompositionlistsrch = currentSearchForm = new ew.Form("fcompositionlistsrch");

// Filters
fcompositionlistsrch.filterList = <?php echo $composition_list->getFilterList() ?>;

// Init search panel as collapsed
fcompositionlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$composition->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($composition_list->TotalRecs > 0 && $composition_list->ExportOptions->visible()) { ?>
<?php $composition_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($composition_list->ImportOptions->visible()) { ?>
<?php $composition_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($composition_list->SearchOptions->visible()) { ?>
<?php $composition_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($composition_list->FilterOptions->visible()) { ?>
<?php $composition_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$composition_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$composition->isExport() && !$composition->CurrentAction) { ?>
<form name="fcompositionlistsrch" id="fcompositionlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($composition_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fcompositionlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="composition">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($composition_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($composition_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $composition_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($composition_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($composition_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($composition_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($composition_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $composition_list->showPageHeader(); ?>
<?php
$composition_list->showMessage();
?>
<?php if ($composition_list->TotalRecs > 0 || $composition->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($composition_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> composition">
<?php if (!$composition->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$composition->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($composition_list->Pager)) $composition_list->Pager = new PrevNextPager($composition_list->StartRec, $composition_list->DisplayRecs, $composition_list->TotalRecs, $composition_list->AutoHidePager) ?>
<?php if ($composition_list->Pager->RecordCount > 0 && $composition_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($composition_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $composition_list->pageUrl() ?>start=<?php echo $composition_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($composition_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $composition_list->pageUrl() ?>start=<?php echo $composition_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $composition_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($composition_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $composition_list->pageUrl() ?>start=<?php echo $composition_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($composition_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $composition_list->pageUrl() ?>start=<?php echo $composition_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $composition_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($composition_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $composition_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $composition_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $composition_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($composition_list->TotalRecs > 0 && (!$composition_list->AutoHidePageSizeSelector || $composition_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="composition">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($composition_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($composition_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($composition_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($composition_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($composition_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($composition->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $composition_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fcompositionlist" id="fcompositionlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($composition_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $composition_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="composition">
<div id="gmp_composition" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($composition_list->TotalRecs > 0 || $composition->isGridEdit()) { ?>
<table id="tbl_compositionlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$composition_list->RowType = ROWTYPE_HEADER;

// Render list options
$composition_list->renderListOptions();

// Render list options (header, left)
$composition_list->ListOptions->render("header", "left");
?>
<?php if ($composition->id->Visible) { // id ?>
	<?php if ($composition->sortUrl($composition->id) == "") { ?>
		<th data-name="id" class="<?php echo $composition->id->headerCellClass() ?>"><div id="elh_composition_id" class="composition_id"><div class="ew-table-header-caption"><?php echo $composition->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $composition->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $composition->SortUrl($composition->id) ?>',2);"><div id="elh_composition_id" class="composition_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $composition->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($composition->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($composition->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($composition->grp->Visible) { // grp ?>
	<?php if ($composition->sortUrl($composition->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $composition->grp->headerCellClass() ?>"><div id="elh_composition_grp" class="composition_grp"><div class="ew-table-header-caption"><?php echo $composition->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $composition->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $composition->SortUrl($composition->grp) ?>',2);"><div id="elh_composition_grp" class="composition_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $composition->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($composition->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($composition->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($composition->wool->Visible) { // wool ?>
	<?php if ($composition->sortUrl($composition->wool) == "") { ?>
		<th data-name="wool" class="<?php echo $composition->wool->headerCellClass() ?>"><div id="elh_composition_wool" class="composition_wool"><div class="ew-table-header-caption"><?php echo $composition->wool->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="wool" class="<?php echo $composition->wool->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $composition->SortUrl($composition->wool) ?>',2);"><div id="elh_composition_wool" class="composition_wool">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $composition->wool->caption() ?></span><span class="ew-table-header-sort"><?php if ($composition->wool->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($composition->wool->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($composition->viscose->Visible) { // viscose ?>
	<?php if ($composition->sortUrl($composition->viscose) == "") { ?>
		<th data-name="viscose" class="<?php echo $composition->viscose->headerCellClass() ?>"><div id="elh_composition_viscose" class="composition_viscose"><div class="ew-table-header-caption"><?php echo $composition->viscose->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="viscose" class="<?php echo $composition->viscose->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $composition->SortUrl($composition->viscose) ?>',2);"><div id="elh_composition_viscose" class="composition_viscose">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $composition->viscose->caption() ?></span><span class="ew-table-header-sort"><?php if ($composition->viscose->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($composition->viscose->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($composition->polyester->Visible) { // polyester ?>
	<?php if ($composition->sortUrl($composition->polyester) == "") { ?>
		<th data-name="polyester" class="<?php echo $composition->polyester->headerCellClass() ?>"><div id="elh_composition_polyester" class="composition_polyester"><div class="ew-table-header-caption"><?php echo $composition->polyester->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="polyester" class="<?php echo $composition->polyester->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $composition->SortUrl($composition->polyester) ?>',2);"><div id="elh_composition_polyester" class="composition_polyester">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $composition->polyester->caption() ?></span><span class="ew-table-header-sort"><?php if ($composition->polyester->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($composition->polyester->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($composition->cotton->Visible) { // cotton ?>
	<?php if ($composition->sortUrl($composition->cotton) == "") { ?>
		<th data-name="cotton" class="<?php echo $composition->cotton->headerCellClass() ?>"><div id="elh_composition_cotton" class="composition_cotton"><div class="ew-table-header-caption"><?php echo $composition->cotton->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cotton" class="<?php echo $composition->cotton->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $composition->SortUrl($composition->cotton) ?>',2);"><div id="elh_composition_cotton" class="composition_cotton">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $composition->cotton->caption() ?></span><span class="ew-table-header-sort"><?php if ($composition->cotton->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($composition->cotton->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($composition->jute->Visible) { // jute ?>
	<?php if ($composition->sortUrl($composition->jute) == "") { ?>
		<th data-name="jute" class="<?php echo $composition->jute->headerCellClass() ?>"><div id="elh_composition_jute" class="composition_jute"><div class="ew-table-header-caption"><?php echo $composition->jute->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jute" class="<?php echo $composition->jute->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $composition->SortUrl($composition->jute) ?>',2);"><div id="elh_composition_jute" class="composition_jute">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $composition->jute->caption() ?></span><span class="ew-table-header-sort"><?php if ($composition->jute->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($composition->jute->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($composition->other->Visible) { // other ?>
	<?php if ($composition->sortUrl($composition->other) == "") { ?>
		<th data-name="other" class="<?php echo $composition->other->headerCellClass() ?>"><div id="elh_composition_other" class="composition_other"><div class="ew-table-header-caption"><?php echo $composition->other->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="other" class="<?php echo $composition->other->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $composition->SortUrl($composition->other) ?>',2);"><div id="elh_composition_other" class="composition_other">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $composition->other->caption() ?></span><span class="ew-table-header-sort"><?php if ($composition->other->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($composition->other->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($composition->other_name->Visible) { // other_name ?>
	<?php if ($composition->sortUrl($composition->other_name) == "") { ?>
		<th data-name="other_name" class="<?php echo $composition->other_name->headerCellClass() ?>"><div id="elh_composition_other_name" class="composition_other_name"><div class="ew-table-header-caption"><?php echo $composition->other_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="other_name" class="<?php echo $composition->other_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $composition->SortUrl($composition->other_name) ?>',2);"><div id="elh_composition_other_name" class="composition_other_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $composition->other_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($composition->other_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($composition->other_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($composition->description_type->Visible) { // description_type ?>
	<?php if ($composition->sortUrl($composition->description_type) == "") { ?>
		<th data-name="description_type" class="<?php echo $composition->description_type->headerCellClass() ?>"><div id="elh_composition_description_type" class="composition_description_type"><div class="ew-table-header-caption"><?php echo $composition->description_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="description_type" class="<?php echo $composition->description_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $composition->SortUrl($composition->description_type) ?>',2);"><div id="elh_composition_description_type" class="composition_description_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $composition->description_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($composition->description_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($composition->description_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($composition->code->Visible) { // code ?>
	<?php if ($composition->sortUrl($composition->code) == "") { ?>
		<th data-name="code" class="<?php echo $composition->code->headerCellClass() ?>"><div id="elh_composition_code" class="composition_code"><div class="ew-table-header-caption"><?php echo $composition->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $composition->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $composition->SortUrl($composition->code) ?>',2);"><div id="elh_composition_code" class="composition_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $composition->code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($composition->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($composition->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($composition->composition->Visible) { // composition ?>
	<?php if ($composition->sortUrl($composition->composition) == "") { ?>
		<th data-name="composition" class="<?php echo $composition->composition->headerCellClass() ?>"><div id="elh_composition_composition" class="composition_composition"><div class="ew-table-header-caption"><?php echo $composition->composition->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="composition" class="<?php echo $composition->composition->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $composition->SortUrl($composition->composition) ?>',2);"><div id="elh_composition_composition" class="composition_composition">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $composition->composition->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($composition->composition->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($composition->composition->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($composition->status->Visible) { // status ?>
	<?php if ($composition->sortUrl($composition->status) == "") { ?>
		<th data-name="status" class="<?php echo $composition->status->headerCellClass() ?>"><div id="elh_composition_status" class="composition_status"><div class="ew-table-header-caption"><?php echo $composition->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $composition->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $composition->SortUrl($composition->status) ?>',2);"><div id="elh_composition_status" class="composition_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $composition->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($composition->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($composition->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($composition->operator->Visible) { // operator ?>
	<?php if ($composition->sortUrl($composition->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $composition->operator->headerCellClass() ?>"><div id="elh_composition_operator" class="composition_operator"><div class="ew-table-header-caption"><?php echo $composition->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $composition->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $composition->SortUrl($composition->operator) ?>',2);"><div id="elh_composition_operator" class="composition_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $composition->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($composition->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($composition->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($composition->datetime->Visible) { // datetime ?>
	<?php if ($composition->sortUrl($composition->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $composition->datetime->headerCellClass() ?>"><div id="elh_composition_datetime" class="composition_datetime"><div class="ew-table-header-caption"><?php echo $composition->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $composition->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $composition->SortUrl($composition->datetime) ?>',2);"><div id="elh_composition_datetime" class="composition_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $composition->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($composition->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($composition->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$composition_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($composition->ExportAll && $composition->isExport()) {
	$composition_list->StopRec = $composition_list->TotalRecs;
} else {

	// Set the last record to display
	if ($composition_list->TotalRecs > $composition_list->StartRec + $composition_list->DisplayRecs - 1)
		$composition_list->StopRec = $composition_list->StartRec + $composition_list->DisplayRecs - 1;
	else
		$composition_list->StopRec = $composition_list->TotalRecs;
}
$composition_list->RecCnt = $composition_list->StartRec - 1;
if ($composition_list->Recordset && !$composition_list->Recordset->EOF) {
	$composition_list->Recordset->moveFirst();
	$selectLimit = $composition_list->UseSelectLimit;
	if (!$selectLimit && $composition_list->StartRec > 1)
		$composition_list->Recordset->move($composition_list->StartRec - 1);
} elseif (!$composition->AllowAddDeleteRow && $composition_list->StopRec == 0) {
	$composition_list->StopRec = $composition->GridAddRowCount;
}

// Initialize aggregate
$composition->RowType = ROWTYPE_AGGREGATEINIT;
$composition->resetAttributes();
$composition_list->renderRow();
while ($composition_list->RecCnt < $composition_list->StopRec) {
	$composition_list->RecCnt++;
	if ($composition_list->RecCnt >= $composition_list->StartRec) {
		$composition_list->RowCnt++;

		// Set up key count
		$composition_list->KeyCount = $composition_list->RowIndex;

		// Init row class and style
		$composition->resetAttributes();
		$composition->CssClass = "";
		if ($composition->isGridAdd()) {
		} else {
			$composition_list->loadRowValues($composition_list->Recordset); // Load row values
		}
		$composition->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$composition->RowAttrs = array_merge($composition->RowAttrs, array('data-rowindex'=>$composition_list->RowCnt, 'id'=>'r' . $composition_list->RowCnt . '_composition', 'data-rowtype'=>$composition->RowType));

		// Render row
		$composition_list->renderRow();

		// Render list options
		$composition_list->renderListOptions();
?>
	<tr<?php echo $composition->rowAttributes() ?>>
<?php

// Render list options (body, left)
$composition_list->ListOptions->render("body", "left", $composition_list->RowCnt);
?>
	<?php if ($composition->id->Visible) { // id ?>
		<td data-name="id"<?php echo $composition->id->cellAttributes() ?>>
<span id="el<?php echo $composition_list->RowCnt ?>_composition_id" class="composition_id">
<span<?php echo $composition->id->viewAttributes() ?>>
<?php echo $composition->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($composition->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $composition->grp->cellAttributes() ?>>
<span id="el<?php echo $composition_list->RowCnt ?>_composition_grp" class="composition_grp">
<span<?php echo $composition->grp->viewAttributes() ?>>
<?php echo $composition->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($composition->wool->Visible) { // wool ?>
		<td data-name="wool"<?php echo $composition->wool->cellAttributes() ?>>
<span id="el<?php echo $composition_list->RowCnt ?>_composition_wool" class="composition_wool">
<span<?php echo $composition->wool->viewAttributes() ?>>
<?php echo $composition->wool->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($composition->viscose->Visible) { // viscose ?>
		<td data-name="viscose"<?php echo $composition->viscose->cellAttributes() ?>>
<span id="el<?php echo $composition_list->RowCnt ?>_composition_viscose" class="composition_viscose">
<span<?php echo $composition->viscose->viewAttributes() ?>>
<?php echo $composition->viscose->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($composition->polyester->Visible) { // polyester ?>
		<td data-name="polyester"<?php echo $composition->polyester->cellAttributes() ?>>
<span id="el<?php echo $composition_list->RowCnt ?>_composition_polyester" class="composition_polyester">
<span<?php echo $composition->polyester->viewAttributes() ?>>
<?php echo $composition->polyester->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($composition->cotton->Visible) { // cotton ?>
		<td data-name="cotton"<?php echo $composition->cotton->cellAttributes() ?>>
<span id="el<?php echo $composition_list->RowCnt ?>_composition_cotton" class="composition_cotton">
<span<?php echo $composition->cotton->viewAttributes() ?>>
<?php echo $composition->cotton->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($composition->jute->Visible) { // jute ?>
		<td data-name="jute"<?php echo $composition->jute->cellAttributes() ?>>
<span id="el<?php echo $composition_list->RowCnt ?>_composition_jute" class="composition_jute">
<span<?php echo $composition->jute->viewAttributes() ?>>
<?php echo $composition->jute->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($composition->other->Visible) { // other ?>
		<td data-name="other"<?php echo $composition->other->cellAttributes() ?>>
<span id="el<?php echo $composition_list->RowCnt ?>_composition_other" class="composition_other">
<span<?php echo $composition->other->viewAttributes() ?>>
<?php echo $composition->other->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($composition->other_name->Visible) { // other_name ?>
		<td data-name="other_name"<?php echo $composition->other_name->cellAttributes() ?>>
<span id="el<?php echo $composition_list->RowCnt ?>_composition_other_name" class="composition_other_name">
<span<?php echo $composition->other_name->viewAttributes() ?>>
<?php echo $composition->other_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($composition->description_type->Visible) { // description_type ?>
		<td data-name="description_type"<?php echo $composition->description_type->cellAttributes() ?>>
<span id="el<?php echo $composition_list->RowCnt ?>_composition_description_type" class="composition_description_type">
<span<?php echo $composition->description_type->viewAttributes() ?>>
<?php echo $composition->description_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($composition->code->Visible) { // code ?>
		<td data-name="code"<?php echo $composition->code->cellAttributes() ?>>
<span id="el<?php echo $composition_list->RowCnt ?>_composition_code" class="composition_code">
<span<?php echo $composition->code->viewAttributes() ?>>
<?php echo $composition->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($composition->composition->Visible) { // composition ?>
		<td data-name="composition"<?php echo $composition->composition->cellAttributes() ?>>
<span id="el<?php echo $composition_list->RowCnt ?>_composition_composition" class="composition_composition">
<span<?php echo $composition->composition->viewAttributes() ?>>
<?php echo $composition->composition->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($composition->status->Visible) { // status ?>
		<td data-name="status"<?php echo $composition->status->cellAttributes() ?>>
<span id="el<?php echo $composition_list->RowCnt ?>_composition_status" class="composition_status">
<span<?php echo $composition->status->viewAttributes() ?>>
<?php echo $composition->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($composition->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $composition->operator->cellAttributes() ?>>
<span id="el<?php echo $composition_list->RowCnt ?>_composition_operator" class="composition_operator">
<span<?php echo $composition->operator->viewAttributes() ?>>
<?php echo $composition->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($composition->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $composition->datetime->cellAttributes() ?>>
<span id="el<?php echo $composition_list->RowCnt ?>_composition_datetime" class="composition_datetime">
<span<?php echo $composition->datetime->viewAttributes() ?>>
<?php echo $composition->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$composition_list->ListOptions->render("body", "right", $composition_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$composition->isGridAdd())
		$composition_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$composition->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($composition_list->Recordset)
	$composition_list->Recordset->Close();
?>
<?php if (!$composition->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$composition->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($composition_list->Pager)) $composition_list->Pager = new PrevNextPager($composition_list->StartRec, $composition_list->DisplayRecs, $composition_list->TotalRecs, $composition_list->AutoHidePager) ?>
<?php if ($composition_list->Pager->RecordCount > 0 && $composition_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($composition_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $composition_list->pageUrl() ?>start=<?php echo $composition_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($composition_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $composition_list->pageUrl() ?>start=<?php echo $composition_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $composition_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($composition_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $composition_list->pageUrl() ?>start=<?php echo $composition_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($composition_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $composition_list->pageUrl() ?>start=<?php echo $composition_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $composition_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($composition_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $composition_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $composition_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $composition_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($composition_list->TotalRecs > 0 && (!$composition_list->AutoHidePageSizeSelector || $composition_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="composition">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($composition_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($composition_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($composition_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($composition_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($composition_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($composition->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $composition_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($composition_list->TotalRecs == 0 && !$composition->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $composition_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$composition_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$composition->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$composition->isExport()) { ?>
<script>
ew.scrollableTable("gmp_composition", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$composition_list->terminate();
?>