<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$composition_view = new composition_view();

// Run the page
$composition_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$composition_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$composition->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fcompositionview = currentForm = new ew.Form("fcompositionview", "view");

// Form_CustomValidate event
fcompositionview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcompositionview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcompositionview.lists["x_grp"] = <?php echo $composition_view->grp->Lookup->toClientList() ?>;
fcompositionview.lists["x_grp"].options = <?php echo JsonEncode($composition_view->grp->lookupOptions()) ?>;
fcompositionview.lists["x_description_type"] = <?php echo $composition_view->description_type->Lookup->toClientList() ?>;
fcompositionview.lists["x_description_type"].options = <?php echo JsonEncode($composition_view->description_type->options(FALSE, TRUE)) ?>;
fcompositionview.lists["x_status"] = <?php echo $composition_view->status->Lookup->toClientList() ?>;
fcompositionview.lists["x_status"].options = <?php echo JsonEncode($composition_view->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$composition->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $composition_view->ExportOptions->render("body") ?>
<?php $composition_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $composition_view->showPageHeader(); ?>
<?php
$composition_view->showMessage();
?>
<form name="fcompositionview" id="fcompositionview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($composition_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $composition_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="composition">
<input type="hidden" name="modal" value="<?php echo (int)$composition_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($composition->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $composition_view->TableLeftColumnClass ?>"><span id="elh_composition_id"><?php echo $composition->id->caption() ?></span></td>
		<td data-name="id"<?php echo $composition->id->cellAttributes() ?>>
<span id="el_composition_id">
<span<?php echo $composition->id->viewAttributes() ?>>
<?php echo $composition->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($composition->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $composition_view->TableLeftColumnClass ?>"><span id="elh_composition_grp"><?php echo $composition->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $composition->grp->cellAttributes() ?>>
<span id="el_composition_grp">
<span<?php echo $composition->grp->viewAttributes() ?>>
<?php echo $composition->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($composition->wool->Visible) { // wool ?>
	<tr id="r_wool">
		<td class="<?php echo $composition_view->TableLeftColumnClass ?>"><span id="elh_composition_wool"><?php echo $composition->wool->caption() ?></span></td>
		<td data-name="wool"<?php echo $composition->wool->cellAttributes() ?>>
<span id="el_composition_wool">
<span<?php echo $composition->wool->viewAttributes() ?>>
<?php echo $composition->wool->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($composition->viscose->Visible) { // viscose ?>
	<tr id="r_viscose">
		<td class="<?php echo $composition_view->TableLeftColumnClass ?>"><span id="elh_composition_viscose"><?php echo $composition->viscose->caption() ?></span></td>
		<td data-name="viscose"<?php echo $composition->viscose->cellAttributes() ?>>
<span id="el_composition_viscose">
<span<?php echo $composition->viscose->viewAttributes() ?>>
<?php echo $composition->viscose->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($composition->polyester->Visible) { // polyester ?>
	<tr id="r_polyester">
		<td class="<?php echo $composition_view->TableLeftColumnClass ?>"><span id="elh_composition_polyester"><?php echo $composition->polyester->caption() ?></span></td>
		<td data-name="polyester"<?php echo $composition->polyester->cellAttributes() ?>>
<span id="el_composition_polyester">
<span<?php echo $composition->polyester->viewAttributes() ?>>
<?php echo $composition->polyester->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($composition->cotton->Visible) { // cotton ?>
	<tr id="r_cotton">
		<td class="<?php echo $composition_view->TableLeftColumnClass ?>"><span id="elh_composition_cotton"><?php echo $composition->cotton->caption() ?></span></td>
		<td data-name="cotton"<?php echo $composition->cotton->cellAttributes() ?>>
<span id="el_composition_cotton">
<span<?php echo $composition->cotton->viewAttributes() ?>>
<?php echo $composition->cotton->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($composition->jute->Visible) { // jute ?>
	<tr id="r_jute">
		<td class="<?php echo $composition_view->TableLeftColumnClass ?>"><span id="elh_composition_jute"><?php echo $composition->jute->caption() ?></span></td>
		<td data-name="jute"<?php echo $composition->jute->cellAttributes() ?>>
<span id="el_composition_jute">
<span<?php echo $composition->jute->viewAttributes() ?>>
<?php echo $composition->jute->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($composition->other->Visible) { // other ?>
	<tr id="r_other">
		<td class="<?php echo $composition_view->TableLeftColumnClass ?>"><span id="elh_composition_other"><?php echo $composition->other->caption() ?></span></td>
		<td data-name="other"<?php echo $composition->other->cellAttributes() ?>>
<span id="el_composition_other">
<span<?php echo $composition->other->viewAttributes() ?>>
<?php echo $composition->other->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($composition->other_name->Visible) { // other_name ?>
	<tr id="r_other_name">
		<td class="<?php echo $composition_view->TableLeftColumnClass ?>"><span id="elh_composition_other_name"><?php echo $composition->other_name->caption() ?></span></td>
		<td data-name="other_name"<?php echo $composition->other_name->cellAttributes() ?>>
<span id="el_composition_other_name">
<span<?php echo $composition->other_name->viewAttributes() ?>>
<?php echo $composition->other_name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($composition->description_type->Visible) { // description_type ?>
	<tr id="r_description_type">
		<td class="<?php echo $composition_view->TableLeftColumnClass ?>"><span id="elh_composition_description_type"><?php echo $composition->description_type->caption() ?></span></td>
		<td data-name="description_type"<?php echo $composition->description_type->cellAttributes() ?>>
<span id="el_composition_description_type">
<span<?php echo $composition->description_type->viewAttributes() ?>>
<?php echo $composition->description_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($composition->code->Visible) { // code ?>
	<tr id="r_code">
		<td class="<?php echo $composition_view->TableLeftColumnClass ?>"><span id="elh_composition_code"><?php echo $composition->code->caption() ?></span></td>
		<td data-name="code"<?php echo $composition->code->cellAttributes() ?>>
<span id="el_composition_code">
<span<?php echo $composition->code->viewAttributes() ?>>
<?php echo $composition->code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($composition->composition->Visible) { // composition ?>
	<tr id="r_composition">
		<td class="<?php echo $composition_view->TableLeftColumnClass ?>"><span id="elh_composition_composition"><?php echo $composition->composition->caption() ?></span></td>
		<td data-name="composition"<?php echo $composition->composition->cellAttributes() ?>>
<span id="el_composition_composition">
<span<?php echo $composition->composition->viewAttributes() ?>>
<?php echo $composition->composition->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($composition->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $composition_view->TableLeftColumnClass ?>"><span id="elh_composition_status"><?php echo $composition->status->caption() ?></span></td>
		<td data-name="status"<?php echo $composition->status->cellAttributes() ?>>
<span id="el_composition_status">
<span<?php echo $composition->status->viewAttributes() ?>>
<?php echo $composition->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($composition->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $composition_view->TableLeftColumnClass ?>"><span id="elh_composition_operator"><?php echo $composition->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $composition->operator->cellAttributes() ?>>
<span id="el_composition_operator">
<span<?php echo $composition->operator->viewAttributes() ?>>
<?php echo $composition->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($composition->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $composition_view->TableLeftColumnClass ?>"><span id="elh_composition_datetime"><?php echo $composition->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $composition->datetime->cellAttributes() ?>>
<span id="el_composition_datetime">
<span<?php echo $composition->datetime->viewAttributes() ?>>
<?php echo $composition->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$composition_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$composition->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$composition_view->terminate();
?>