<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$cost_calculator_detailed_list = new cost_calculator_detailed_list();

// Run the page
$cost_calculator_detailed_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$cost_calculator_detailed_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$cost_calculator_detailed->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fcost_calculator_detailedlist = currentForm = new ew.Form("fcost_calculator_detailedlist", "list");
fcost_calculator_detailedlist.formKeyCountName = '<?php echo $cost_calculator_detailed_list->FormKeyCountName ?>';

// Form_CustomValidate event
fcost_calculator_detailedlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcost_calculator_detailedlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcost_calculator_detailedlist.lists["x_cc_id"] = <?php echo $cost_calculator_detailed_list->cc_id->Lookup->toClientList() ?>;
fcost_calculator_detailedlist.lists["x_cc_id"].options = <?php echo JsonEncode($cost_calculator_detailed_list->cc_id->lookupOptions()) ?>;
fcost_calculator_detailedlist.lists["x_rid"] = <?php echo $cost_calculator_detailed_list->rid->Lookup->toClientList() ?>;
fcost_calculator_detailedlist.lists["x_rid"].options = <?php echo JsonEncode($cost_calculator_detailed_list->rid->lookupOptions()) ?>;
fcost_calculator_detailedlist.lists["x_item"] = <?php echo $cost_calculator_detailed_list->item->Lookup->toClientList() ?>;
fcost_calculator_detailedlist.lists["x_item"].options = <?php echo JsonEncode($cost_calculator_detailed_list->item->lookupOptions()) ?>;
fcost_calculator_detailedlist.lists["x_packing_type"] = <?php echo $cost_calculator_detailed_list->packing_type->Lookup->toClientList() ?>;
fcost_calculator_detailedlist.lists["x_packing_type"].options = <?php echo JsonEncode($cost_calculator_detailed_list->packing_type->lookupOptions()) ?>;
fcost_calculator_detailedlist.lists["x_method"] = <?php echo $cost_calculator_detailed_list->method->Lookup->toClientList() ?>;
fcost_calculator_detailedlist.lists["x_method"].options = <?php echo JsonEncode($cost_calculator_detailed_list->method->lookupOptions()) ?>;
fcost_calculator_detailedlist.lists["x_process"] = <?php echo $cost_calculator_detailed_list->process->Lookup->toClientList() ?>;
fcost_calculator_detailedlist.lists["x_process"].options = <?php echo JsonEncode($cost_calculator_detailed_list->process->lookupOptions()) ?>;

// Form object for search
var fcost_calculator_detailedlistsrch = currentSearchForm = new ew.Form("fcost_calculator_detailedlistsrch");

// Filters
fcost_calculator_detailedlistsrch.filterList = <?php echo $cost_calculator_detailed_list->getFilterList() ?>;

// Init search panel as collapsed
fcost_calculator_detailedlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$cost_calculator_detailed->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($cost_calculator_detailed_list->TotalRecs > 0 && $cost_calculator_detailed_list->ExportOptions->visible()) { ?>
<?php $cost_calculator_detailed_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($cost_calculator_detailed_list->ImportOptions->visible()) { ?>
<?php $cost_calculator_detailed_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($cost_calculator_detailed_list->SearchOptions->visible()) { ?>
<?php $cost_calculator_detailed_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($cost_calculator_detailed_list->FilterOptions->visible()) { ?>
<?php $cost_calculator_detailed_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$cost_calculator_detailed_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$cost_calculator_detailed->isExport() && !$cost_calculator_detailed->CurrentAction) { ?>
<form name="fcost_calculator_detailedlistsrch" id="fcost_calculator_detailedlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($cost_calculator_detailed_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fcost_calculator_detailedlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="cost_calculator_detailed">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($cost_calculator_detailed_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($cost_calculator_detailed_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $cost_calculator_detailed_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($cost_calculator_detailed_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($cost_calculator_detailed_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($cost_calculator_detailed_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($cost_calculator_detailed_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $cost_calculator_detailed_list->showPageHeader(); ?>
<?php
$cost_calculator_detailed_list->showMessage();
?>
<?php if ($cost_calculator_detailed_list->TotalRecs > 0 || $cost_calculator_detailed->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($cost_calculator_detailed_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> cost_calculator_detailed">
<?php if (!$cost_calculator_detailed->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$cost_calculator_detailed->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($cost_calculator_detailed_list->Pager)) $cost_calculator_detailed_list->Pager = new PrevNextPager($cost_calculator_detailed_list->StartRec, $cost_calculator_detailed_list->DisplayRecs, $cost_calculator_detailed_list->TotalRecs, $cost_calculator_detailed_list->AutoHidePager) ?>
<?php if ($cost_calculator_detailed_list->Pager->RecordCount > 0 && $cost_calculator_detailed_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($cost_calculator_detailed_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $cost_calculator_detailed_list->pageUrl() ?>start=<?php echo $cost_calculator_detailed_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($cost_calculator_detailed_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $cost_calculator_detailed_list->pageUrl() ?>start=<?php echo $cost_calculator_detailed_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $cost_calculator_detailed_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($cost_calculator_detailed_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $cost_calculator_detailed_list->pageUrl() ?>start=<?php echo $cost_calculator_detailed_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($cost_calculator_detailed_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $cost_calculator_detailed_list->pageUrl() ?>start=<?php echo $cost_calculator_detailed_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $cost_calculator_detailed_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($cost_calculator_detailed_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $cost_calculator_detailed_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $cost_calculator_detailed_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $cost_calculator_detailed_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($cost_calculator_detailed_list->TotalRecs > 0 && (!$cost_calculator_detailed_list->AutoHidePageSizeSelector || $cost_calculator_detailed_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="cost_calculator_detailed">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($cost_calculator_detailed_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($cost_calculator_detailed_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($cost_calculator_detailed_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($cost_calculator_detailed_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($cost_calculator_detailed_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($cost_calculator_detailed->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $cost_calculator_detailed_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fcost_calculator_detailedlist" id="fcost_calculator_detailedlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($cost_calculator_detailed_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $cost_calculator_detailed_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="cost_calculator_detailed">
<div id="gmp_cost_calculator_detailed" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($cost_calculator_detailed_list->TotalRecs > 0 || $cost_calculator_detailed->isGridEdit()) { ?>
<table id="tbl_cost_calculator_detailedlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$cost_calculator_detailed_list->RowType = ROWTYPE_HEADER;

// Render list options
$cost_calculator_detailed_list->renderListOptions();

// Render list options (header, left)
$cost_calculator_detailed_list->ListOptions->render("header", "left");
?>
<?php if ($cost_calculator_detailed->id->Visible) { // id ?>
	<?php if ($cost_calculator_detailed->sortUrl($cost_calculator_detailed->id) == "") { ?>
		<th data-name="id" class="<?php echo $cost_calculator_detailed->id->headerCellClass() ?>"><div id="elh_cost_calculator_detailed_id" class="cost_calculator_detailed_id"><div class="ew-table-header-caption"><?php echo $cost_calculator_detailed->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $cost_calculator_detailed->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cost_calculator_detailed->SortUrl($cost_calculator_detailed->id) ?>',2);"><div id="elh_cost_calculator_detailed_id" class="cost_calculator_detailed_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cost_calculator_detailed->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($cost_calculator_detailed->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cost_calculator_detailed->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cost_calculator_detailed->cc_id->Visible) { // cc_id ?>
	<?php if ($cost_calculator_detailed->sortUrl($cost_calculator_detailed->cc_id) == "") { ?>
		<th data-name="cc_id" class="<?php echo $cost_calculator_detailed->cc_id->headerCellClass() ?>"><div id="elh_cost_calculator_detailed_cc_id" class="cost_calculator_detailed_cc_id"><div class="ew-table-header-caption"><?php echo $cost_calculator_detailed->cc_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cc_id" class="<?php echo $cost_calculator_detailed->cc_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cost_calculator_detailed->SortUrl($cost_calculator_detailed->cc_id) ?>',2);"><div id="elh_cost_calculator_detailed_cc_id" class="cost_calculator_detailed_cc_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cost_calculator_detailed->cc_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($cost_calculator_detailed->cc_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cost_calculator_detailed->cc_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cost_calculator_detailed->rid->Visible) { // rid ?>
	<?php if ($cost_calculator_detailed->sortUrl($cost_calculator_detailed->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $cost_calculator_detailed->rid->headerCellClass() ?>"><div id="elh_cost_calculator_detailed_rid" class="cost_calculator_detailed_rid"><div class="ew-table-header-caption"><?php echo $cost_calculator_detailed->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $cost_calculator_detailed->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cost_calculator_detailed->SortUrl($cost_calculator_detailed->rid) ?>',2);"><div id="elh_cost_calculator_detailed_rid" class="cost_calculator_detailed_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cost_calculator_detailed->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($cost_calculator_detailed->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cost_calculator_detailed->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cost_calculator_detailed->sqm->Visible) { // sqm ?>
	<?php if ($cost_calculator_detailed->sortUrl($cost_calculator_detailed->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $cost_calculator_detailed->sqm->headerCellClass() ?>"><div id="elh_cost_calculator_detailed_sqm" class="cost_calculator_detailed_sqm"><div class="ew-table-header-caption"><?php echo $cost_calculator_detailed->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $cost_calculator_detailed->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cost_calculator_detailed->SortUrl($cost_calculator_detailed->sqm) ?>',2);"><div id="elh_cost_calculator_detailed_sqm" class="cost_calculator_detailed_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cost_calculator_detailed->sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($cost_calculator_detailed->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cost_calculator_detailed->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cost_calculator_detailed->item->Visible) { // item ?>
	<?php if ($cost_calculator_detailed->sortUrl($cost_calculator_detailed->item) == "") { ?>
		<th data-name="item" class="<?php echo $cost_calculator_detailed->item->headerCellClass() ?>"><div id="elh_cost_calculator_detailed_item" class="cost_calculator_detailed_item"><div class="ew-table-header-caption"><?php echo $cost_calculator_detailed->item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item" class="<?php echo $cost_calculator_detailed->item->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cost_calculator_detailed->SortUrl($cost_calculator_detailed->item) ?>',2);"><div id="elh_cost_calculator_detailed_item" class="cost_calculator_detailed_item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cost_calculator_detailed->item->caption() ?></span><span class="ew-table-header-sort"><?php if ($cost_calculator_detailed->item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cost_calculator_detailed->item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cost_calculator_detailed->packing_type->Visible) { // packing_type ?>
	<?php if ($cost_calculator_detailed->sortUrl($cost_calculator_detailed->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $cost_calculator_detailed->packing_type->headerCellClass() ?>"><div id="elh_cost_calculator_detailed_packing_type" class="cost_calculator_detailed_packing_type"><div class="ew-table-header-caption"><?php echo $cost_calculator_detailed->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $cost_calculator_detailed->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cost_calculator_detailed->SortUrl($cost_calculator_detailed->packing_type) ?>',2);"><div id="elh_cost_calculator_detailed_packing_type" class="cost_calculator_detailed_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cost_calculator_detailed->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($cost_calculator_detailed->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cost_calculator_detailed->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cost_calculator_detailed->method->Visible) { // method ?>
	<?php if ($cost_calculator_detailed->sortUrl($cost_calculator_detailed->method) == "") { ?>
		<th data-name="method" class="<?php echo $cost_calculator_detailed->method->headerCellClass() ?>"><div id="elh_cost_calculator_detailed_method" class="cost_calculator_detailed_method"><div class="ew-table-header-caption"><?php echo $cost_calculator_detailed->method->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="method" class="<?php echo $cost_calculator_detailed->method->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cost_calculator_detailed->SortUrl($cost_calculator_detailed->method) ?>',2);"><div id="elh_cost_calculator_detailed_method" class="cost_calculator_detailed_method">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cost_calculator_detailed->method->caption() ?></span><span class="ew-table-header-sort"><?php if ($cost_calculator_detailed->method->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cost_calculator_detailed->method->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cost_calculator_detailed->qty->Visible) { // qty ?>
	<?php if ($cost_calculator_detailed->sortUrl($cost_calculator_detailed->qty) == "") { ?>
		<th data-name="qty" class="<?php echo $cost_calculator_detailed->qty->headerCellClass() ?>"><div id="elh_cost_calculator_detailed_qty" class="cost_calculator_detailed_qty"><div class="ew-table-header-caption"><?php echo $cost_calculator_detailed->qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="qty" class="<?php echo $cost_calculator_detailed->qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cost_calculator_detailed->SortUrl($cost_calculator_detailed->qty) ?>',2);"><div id="elh_cost_calculator_detailed_qty" class="cost_calculator_detailed_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cost_calculator_detailed->qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($cost_calculator_detailed->qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cost_calculator_detailed->qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cost_calculator_detailed->last_price->Visible) { // last_price ?>
	<?php if ($cost_calculator_detailed->sortUrl($cost_calculator_detailed->last_price) == "") { ?>
		<th data-name="last_price" class="<?php echo $cost_calculator_detailed->last_price->headerCellClass() ?>"><div id="elh_cost_calculator_detailed_last_price" class="cost_calculator_detailed_last_price"><div class="ew-table-header-caption"><?php echo $cost_calculator_detailed->last_price->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="last_price" class="<?php echo $cost_calculator_detailed->last_price->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cost_calculator_detailed->SortUrl($cost_calculator_detailed->last_price) ?>',2);"><div id="elh_cost_calculator_detailed_last_price" class="cost_calculator_detailed_last_price">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cost_calculator_detailed->last_price->caption() ?></span><span class="ew-table-header-sort"><?php if ($cost_calculator_detailed->last_price->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cost_calculator_detailed->last_price->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cost_calculator_detailed->amount->Visible) { // amount ?>
	<?php if ($cost_calculator_detailed->sortUrl($cost_calculator_detailed->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $cost_calculator_detailed->amount->headerCellClass() ?>"><div id="elh_cost_calculator_detailed_amount" class="cost_calculator_detailed_amount"><div class="ew-table-header-caption"><?php echo $cost_calculator_detailed->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $cost_calculator_detailed->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cost_calculator_detailed->SortUrl($cost_calculator_detailed->amount) ?>',2);"><div id="elh_cost_calculator_detailed_amount" class="cost_calculator_detailed_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cost_calculator_detailed->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($cost_calculator_detailed->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cost_calculator_detailed->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cost_calculator_detailed->process->Visible) { // process ?>
	<?php if ($cost_calculator_detailed->sortUrl($cost_calculator_detailed->process) == "") { ?>
		<th data-name="process" class="<?php echo $cost_calculator_detailed->process->headerCellClass() ?>"><div id="elh_cost_calculator_detailed_process" class="cost_calculator_detailed_process"><div class="ew-table-header-caption"><?php echo $cost_calculator_detailed->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $cost_calculator_detailed->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cost_calculator_detailed->SortUrl($cost_calculator_detailed->process) ?>',2);"><div id="elh_cost_calculator_detailed_process" class="cost_calculator_detailed_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cost_calculator_detailed->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($cost_calculator_detailed->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cost_calculator_detailed->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cost_calculator_detailed->w_cm->Visible) { // w_cm ?>
	<?php if ($cost_calculator_detailed->sortUrl($cost_calculator_detailed->w_cm) == "") { ?>
		<th data-name="w_cm" class="<?php echo $cost_calculator_detailed->w_cm->headerCellClass() ?>"><div id="elh_cost_calculator_detailed_w_cm" class="cost_calculator_detailed_w_cm"><div class="ew-table-header-caption"><?php echo $cost_calculator_detailed->w_cm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="w_cm" class="<?php echo $cost_calculator_detailed->w_cm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cost_calculator_detailed->SortUrl($cost_calculator_detailed->w_cm) ?>',2);"><div id="elh_cost_calculator_detailed_w_cm" class="cost_calculator_detailed_w_cm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cost_calculator_detailed->w_cm->caption() ?></span><span class="ew-table-header-sort"><?php if ($cost_calculator_detailed->w_cm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cost_calculator_detailed->w_cm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cost_calculator_detailed->l_cm->Visible) { // l_cm ?>
	<?php if ($cost_calculator_detailed->sortUrl($cost_calculator_detailed->l_cm) == "") { ?>
		<th data-name="l_cm" class="<?php echo $cost_calculator_detailed->l_cm->headerCellClass() ?>"><div id="elh_cost_calculator_detailed_l_cm" class="cost_calculator_detailed_l_cm"><div class="ew-table-header-caption"><?php echo $cost_calculator_detailed->l_cm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="l_cm" class="<?php echo $cost_calculator_detailed->l_cm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cost_calculator_detailed->SortUrl($cost_calculator_detailed->l_cm) ?>',2);"><div id="elh_cost_calculator_detailed_l_cm" class="cost_calculator_detailed_l_cm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cost_calculator_detailed->l_cm->caption() ?></span><span class="ew-table-header-sort"><?php if ($cost_calculator_detailed->l_cm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cost_calculator_detailed->l_cm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cost_calculator_detailed->description->Visible) { // description ?>
	<?php if ($cost_calculator_detailed->sortUrl($cost_calculator_detailed->description) == "") { ?>
		<th data-name="description" class="<?php echo $cost_calculator_detailed->description->headerCellClass() ?>"><div id="elh_cost_calculator_detailed_description" class="cost_calculator_detailed_description"><div class="ew-table-header-caption"><?php echo $cost_calculator_detailed->description->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="description" class="<?php echo $cost_calculator_detailed->description->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cost_calculator_detailed->SortUrl($cost_calculator_detailed->description) ?>',2);"><div id="elh_cost_calculator_detailed_description" class="cost_calculator_detailed_description">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cost_calculator_detailed->description->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($cost_calculator_detailed->description->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cost_calculator_detailed->description->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cost_calculator_detailed->overhead->Visible) { // overhead ?>
	<?php if ($cost_calculator_detailed->sortUrl($cost_calculator_detailed->overhead) == "") { ?>
		<th data-name="overhead" class="<?php echo $cost_calculator_detailed->overhead->headerCellClass() ?>"><div id="elh_cost_calculator_detailed_overhead" class="cost_calculator_detailed_overhead"><div class="ew-table-header-caption"><?php echo $cost_calculator_detailed->overhead->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="overhead" class="<?php echo $cost_calculator_detailed->overhead->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cost_calculator_detailed->SortUrl($cost_calculator_detailed->overhead) ?>',2);"><div id="elh_cost_calculator_detailed_overhead" class="cost_calculator_detailed_overhead">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cost_calculator_detailed->overhead->caption() ?></span><span class="ew-table-header-sort"><?php if ($cost_calculator_detailed->overhead->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cost_calculator_detailed->overhead->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cost_calculator_detailed->margin->Visible) { // margin ?>
	<?php if ($cost_calculator_detailed->sortUrl($cost_calculator_detailed->margin) == "") { ?>
		<th data-name="margin" class="<?php echo $cost_calculator_detailed->margin->headerCellClass() ?>"><div id="elh_cost_calculator_detailed_margin" class="cost_calculator_detailed_margin"><div class="ew-table-header-caption"><?php echo $cost_calculator_detailed->margin->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="margin" class="<?php echo $cost_calculator_detailed->margin->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cost_calculator_detailed->SortUrl($cost_calculator_detailed->margin) ?>',2);"><div id="elh_cost_calculator_detailed_margin" class="cost_calculator_detailed_margin">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cost_calculator_detailed->margin->caption() ?></span><span class="ew-table-header-sort"><?php if ($cost_calculator_detailed->margin->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cost_calculator_detailed->margin->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cost_calculator_detailed->operator->Visible) { // operator ?>
	<?php if ($cost_calculator_detailed->sortUrl($cost_calculator_detailed->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $cost_calculator_detailed->operator->headerCellClass() ?>"><div id="elh_cost_calculator_detailed_operator" class="cost_calculator_detailed_operator"><div class="ew-table-header-caption"><?php echo $cost_calculator_detailed->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $cost_calculator_detailed->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cost_calculator_detailed->SortUrl($cost_calculator_detailed->operator) ?>',2);"><div id="elh_cost_calculator_detailed_operator" class="cost_calculator_detailed_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cost_calculator_detailed->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($cost_calculator_detailed->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cost_calculator_detailed->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cost_calculator_detailed->datetime->Visible) { // datetime ?>
	<?php if ($cost_calculator_detailed->sortUrl($cost_calculator_detailed->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $cost_calculator_detailed->datetime->headerCellClass() ?>"><div id="elh_cost_calculator_detailed_datetime" class="cost_calculator_detailed_datetime"><div class="ew-table-header-caption"><?php echo $cost_calculator_detailed->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $cost_calculator_detailed->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cost_calculator_detailed->SortUrl($cost_calculator_detailed->datetime) ?>',2);"><div id="elh_cost_calculator_detailed_datetime" class="cost_calculator_detailed_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cost_calculator_detailed->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($cost_calculator_detailed->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cost_calculator_detailed->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$cost_calculator_detailed_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($cost_calculator_detailed->ExportAll && $cost_calculator_detailed->isExport()) {
	$cost_calculator_detailed_list->StopRec = $cost_calculator_detailed_list->TotalRecs;
} else {

	// Set the last record to display
	if ($cost_calculator_detailed_list->TotalRecs > $cost_calculator_detailed_list->StartRec + $cost_calculator_detailed_list->DisplayRecs - 1)
		$cost_calculator_detailed_list->StopRec = $cost_calculator_detailed_list->StartRec + $cost_calculator_detailed_list->DisplayRecs - 1;
	else
		$cost_calculator_detailed_list->StopRec = $cost_calculator_detailed_list->TotalRecs;
}
$cost_calculator_detailed_list->RecCnt = $cost_calculator_detailed_list->StartRec - 1;
if ($cost_calculator_detailed_list->Recordset && !$cost_calculator_detailed_list->Recordset->EOF) {
	$cost_calculator_detailed_list->Recordset->moveFirst();
	$selectLimit = $cost_calculator_detailed_list->UseSelectLimit;
	if (!$selectLimit && $cost_calculator_detailed_list->StartRec > 1)
		$cost_calculator_detailed_list->Recordset->move($cost_calculator_detailed_list->StartRec - 1);
} elseif (!$cost_calculator_detailed->AllowAddDeleteRow && $cost_calculator_detailed_list->StopRec == 0) {
	$cost_calculator_detailed_list->StopRec = $cost_calculator_detailed->GridAddRowCount;
}

// Initialize aggregate
$cost_calculator_detailed->RowType = ROWTYPE_AGGREGATEINIT;
$cost_calculator_detailed->resetAttributes();
$cost_calculator_detailed_list->renderRow();
while ($cost_calculator_detailed_list->RecCnt < $cost_calculator_detailed_list->StopRec) {
	$cost_calculator_detailed_list->RecCnt++;
	if ($cost_calculator_detailed_list->RecCnt >= $cost_calculator_detailed_list->StartRec) {
		$cost_calculator_detailed_list->RowCnt++;

		// Set up key count
		$cost_calculator_detailed_list->KeyCount = $cost_calculator_detailed_list->RowIndex;

		// Init row class and style
		$cost_calculator_detailed->resetAttributes();
		$cost_calculator_detailed->CssClass = "";
		if ($cost_calculator_detailed->isGridAdd()) {
		} else {
			$cost_calculator_detailed_list->loadRowValues($cost_calculator_detailed_list->Recordset); // Load row values
		}
		$cost_calculator_detailed->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$cost_calculator_detailed->RowAttrs = array_merge($cost_calculator_detailed->RowAttrs, array('data-rowindex'=>$cost_calculator_detailed_list->RowCnt, 'id'=>'r' . $cost_calculator_detailed_list->RowCnt . '_cost_calculator_detailed', 'data-rowtype'=>$cost_calculator_detailed->RowType));

		// Render row
		$cost_calculator_detailed_list->renderRow();

		// Render list options
		$cost_calculator_detailed_list->renderListOptions();
?>
	<tr<?php echo $cost_calculator_detailed->rowAttributes() ?>>
<?php

// Render list options (body, left)
$cost_calculator_detailed_list->ListOptions->render("body", "left", $cost_calculator_detailed_list->RowCnt);
?>
	<?php if ($cost_calculator_detailed->id->Visible) { // id ?>
		<td data-name="id"<?php echo $cost_calculator_detailed->id->cellAttributes() ?>>
<span id="el<?php echo $cost_calculator_detailed_list->RowCnt ?>_cost_calculator_detailed_id" class="cost_calculator_detailed_id">
<span<?php echo $cost_calculator_detailed->id->viewAttributes() ?>>
<?php echo $cost_calculator_detailed->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cost_calculator_detailed->cc_id->Visible) { // cc_id ?>
		<td data-name="cc_id"<?php echo $cost_calculator_detailed->cc_id->cellAttributes() ?>>
<span id="el<?php echo $cost_calculator_detailed_list->RowCnt ?>_cost_calculator_detailed_cc_id" class="cost_calculator_detailed_cc_id">
<span<?php echo $cost_calculator_detailed->cc_id->viewAttributes() ?>>
<?php if ((!EmptyString($cost_calculator_detailed->cc_id->getViewValue())) && $cost_calculator_detailed->cc_id->linkAttributes() <> "") { ?>
<a<?php echo $cost_calculator_detailed->cc_id->linkAttributes() ?>><?php echo $cost_calculator_detailed->cc_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $cost_calculator_detailed->cc_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($cost_calculator_detailed->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $cost_calculator_detailed->rid->cellAttributes() ?>>
<span id="el<?php echo $cost_calculator_detailed_list->RowCnt ?>_cost_calculator_detailed_rid" class="cost_calculator_detailed_rid">
<span<?php echo $cost_calculator_detailed->rid->viewAttributes() ?>>
<?php echo $cost_calculator_detailed->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cost_calculator_detailed->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $cost_calculator_detailed->sqm->cellAttributes() ?>>
<span id="el<?php echo $cost_calculator_detailed_list->RowCnt ?>_cost_calculator_detailed_sqm" class="cost_calculator_detailed_sqm">
<span<?php echo $cost_calculator_detailed->sqm->viewAttributes() ?>>
<?php echo $cost_calculator_detailed->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cost_calculator_detailed->item->Visible) { // item ?>
		<td data-name="item"<?php echo $cost_calculator_detailed->item->cellAttributes() ?>>
<span id="el<?php echo $cost_calculator_detailed_list->RowCnt ?>_cost_calculator_detailed_item" class="cost_calculator_detailed_item">
<span<?php echo $cost_calculator_detailed->item->viewAttributes() ?>>
<?php echo $cost_calculator_detailed->item->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cost_calculator_detailed->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $cost_calculator_detailed->packing_type->cellAttributes() ?>>
<span id="el<?php echo $cost_calculator_detailed_list->RowCnt ?>_cost_calculator_detailed_packing_type" class="cost_calculator_detailed_packing_type">
<span<?php echo $cost_calculator_detailed->packing_type->viewAttributes() ?>>
<?php echo $cost_calculator_detailed->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cost_calculator_detailed->method->Visible) { // method ?>
		<td data-name="method"<?php echo $cost_calculator_detailed->method->cellAttributes() ?>>
<span id="el<?php echo $cost_calculator_detailed_list->RowCnt ?>_cost_calculator_detailed_method" class="cost_calculator_detailed_method">
<span<?php echo $cost_calculator_detailed->method->viewAttributes() ?>>
<?php echo $cost_calculator_detailed->method->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cost_calculator_detailed->qty->Visible) { // qty ?>
		<td data-name="qty"<?php echo $cost_calculator_detailed->qty->cellAttributes() ?>>
<span id="el<?php echo $cost_calculator_detailed_list->RowCnt ?>_cost_calculator_detailed_qty" class="cost_calculator_detailed_qty">
<span<?php echo $cost_calculator_detailed->qty->viewAttributes() ?>>
<?php echo $cost_calculator_detailed->qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cost_calculator_detailed->last_price->Visible) { // last_price ?>
		<td data-name="last_price"<?php echo $cost_calculator_detailed->last_price->cellAttributes() ?>>
<span id="el<?php echo $cost_calculator_detailed_list->RowCnt ?>_cost_calculator_detailed_last_price" class="cost_calculator_detailed_last_price">
<span<?php echo $cost_calculator_detailed->last_price->viewAttributes() ?>>
<?php echo $cost_calculator_detailed->last_price->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cost_calculator_detailed->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $cost_calculator_detailed->amount->cellAttributes() ?>>
<span id="el<?php echo $cost_calculator_detailed_list->RowCnt ?>_cost_calculator_detailed_amount" class="cost_calculator_detailed_amount">
<span<?php echo $cost_calculator_detailed->amount->viewAttributes() ?>>
<?php echo $cost_calculator_detailed->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cost_calculator_detailed->process->Visible) { // process ?>
		<td data-name="process"<?php echo $cost_calculator_detailed->process->cellAttributes() ?>>
<span id="el<?php echo $cost_calculator_detailed_list->RowCnt ?>_cost_calculator_detailed_process" class="cost_calculator_detailed_process">
<span<?php echo $cost_calculator_detailed->process->viewAttributes() ?>>
<?php echo $cost_calculator_detailed->process->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cost_calculator_detailed->w_cm->Visible) { // w_cm ?>
		<td data-name="w_cm"<?php echo $cost_calculator_detailed->w_cm->cellAttributes() ?>>
<span id="el<?php echo $cost_calculator_detailed_list->RowCnt ?>_cost_calculator_detailed_w_cm" class="cost_calculator_detailed_w_cm">
<span<?php echo $cost_calculator_detailed->w_cm->viewAttributes() ?>>
<?php echo $cost_calculator_detailed->w_cm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cost_calculator_detailed->l_cm->Visible) { // l_cm ?>
		<td data-name="l_cm"<?php echo $cost_calculator_detailed->l_cm->cellAttributes() ?>>
<span id="el<?php echo $cost_calculator_detailed_list->RowCnt ?>_cost_calculator_detailed_l_cm" class="cost_calculator_detailed_l_cm">
<span<?php echo $cost_calculator_detailed->l_cm->viewAttributes() ?>>
<?php echo $cost_calculator_detailed->l_cm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cost_calculator_detailed->description->Visible) { // description ?>
		<td data-name="description"<?php echo $cost_calculator_detailed->description->cellAttributes() ?>>
<span id="el<?php echo $cost_calculator_detailed_list->RowCnt ?>_cost_calculator_detailed_description" class="cost_calculator_detailed_description">
<span<?php echo $cost_calculator_detailed->description->viewAttributes() ?>>
<?php echo $cost_calculator_detailed->description->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cost_calculator_detailed->overhead->Visible) { // overhead ?>
		<td data-name="overhead"<?php echo $cost_calculator_detailed->overhead->cellAttributes() ?>>
<span id="el<?php echo $cost_calculator_detailed_list->RowCnt ?>_cost_calculator_detailed_overhead" class="cost_calculator_detailed_overhead">
<span<?php echo $cost_calculator_detailed->overhead->viewAttributes() ?>>
<?php echo $cost_calculator_detailed->overhead->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cost_calculator_detailed->margin->Visible) { // margin ?>
		<td data-name="margin"<?php echo $cost_calculator_detailed->margin->cellAttributes() ?>>
<span id="el<?php echo $cost_calculator_detailed_list->RowCnt ?>_cost_calculator_detailed_margin" class="cost_calculator_detailed_margin">
<span<?php echo $cost_calculator_detailed->margin->viewAttributes() ?>>
<?php echo $cost_calculator_detailed->margin->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cost_calculator_detailed->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $cost_calculator_detailed->operator->cellAttributes() ?>>
<span id="el<?php echo $cost_calculator_detailed_list->RowCnt ?>_cost_calculator_detailed_operator" class="cost_calculator_detailed_operator">
<span<?php echo $cost_calculator_detailed->operator->viewAttributes() ?>>
<?php echo $cost_calculator_detailed->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cost_calculator_detailed->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $cost_calculator_detailed->datetime->cellAttributes() ?>>
<span id="el<?php echo $cost_calculator_detailed_list->RowCnt ?>_cost_calculator_detailed_datetime" class="cost_calculator_detailed_datetime">
<span<?php echo $cost_calculator_detailed->datetime->viewAttributes() ?>>
<?php echo $cost_calculator_detailed->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$cost_calculator_detailed_list->ListOptions->render("body", "right", $cost_calculator_detailed_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$cost_calculator_detailed->isGridAdd())
		$cost_calculator_detailed_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$cost_calculator_detailed->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($cost_calculator_detailed_list->Recordset)
	$cost_calculator_detailed_list->Recordset->Close();
?>
<?php if (!$cost_calculator_detailed->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$cost_calculator_detailed->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($cost_calculator_detailed_list->Pager)) $cost_calculator_detailed_list->Pager = new PrevNextPager($cost_calculator_detailed_list->StartRec, $cost_calculator_detailed_list->DisplayRecs, $cost_calculator_detailed_list->TotalRecs, $cost_calculator_detailed_list->AutoHidePager) ?>
<?php if ($cost_calculator_detailed_list->Pager->RecordCount > 0 && $cost_calculator_detailed_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($cost_calculator_detailed_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $cost_calculator_detailed_list->pageUrl() ?>start=<?php echo $cost_calculator_detailed_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($cost_calculator_detailed_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $cost_calculator_detailed_list->pageUrl() ?>start=<?php echo $cost_calculator_detailed_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $cost_calculator_detailed_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($cost_calculator_detailed_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $cost_calculator_detailed_list->pageUrl() ?>start=<?php echo $cost_calculator_detailed_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($cost_calculator_detailed_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $cost_calculator_detailed_list->pageUrl() ?>start=<?php echo $cost_calculator_detailed_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $cost_calculator_detailed_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($cost_calculator_detailed_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $cost_calculator_detailed_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $cost_calculator_detailed_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $cost_calculator_detailed_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($cost_calculator_detailed_list->TotalRecs > 0 && (!$cost_calculator_detailed_list->AutoHidePageSizeSelector || $cost_calculator_detailed_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="cost_calculator_detailed">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($cost_calculator_detailed_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($cost_calculator_detailed_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($cost_calculator_detailed_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($cost_calculator_detailed_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($cost_calculator_detailed_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($cost_calculator_detailed->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $cost_calculator_detailed_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($cost_calculator_detailed_list->TotalRecs == 0 && !$cost_calculator_detailed->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $cost_calculator_detailed_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$cost_calculator_detailed_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$cost_calculator_detailed->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$cost_calculator_detailed->isExport()) { ?>
<script>
ew.scrollableTable("gmp_cost_calculator_detailed", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$cost_calculator_detailed_list->terminate();
?>