<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$cost_calculator_edit = new cost_calculator_edit();

// Run the page
$cost_calculator_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$cost_calculator_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fcost_calculatoredit = currentForm = new ew.Form("fcost_calculatoredit", "edit");

// Validate form
fcost_calculatoredit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($cost_calculator_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cost_calculator->id->caption(), $cost_calculator->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cost_calculator_edit->buyer_id->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cost_calculator->buyer_id->caption(), $cost_calculator->buyer_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cost_calculator_edit->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cost_calculator->rid->caption(), $cost_calculator->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cost_calculator_edit->batch_no->Required) { ?>
			elm = this.getElements("x" + infix + "_batch_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cost_calculator->batch_no->caption(), $cost_calculator->batch_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cost_calculator_edit->price_inr->Required) { ?>
			elm = this.getElements("x" + infix + "_price_inr");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cost_calculator->price_inr->caption(), $cost_calculator->price_inr->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_price_inr");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($cost_calculator->price_inr->errorMessage()) ?>");
		<?php if ($cost_calculator_edit->shape->Required) { ?>
			elm = this.getElements("x" + infix + "_shape");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cost_calculator->shape->caption(), $cost_calculator->shape->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cost_calculator_edit->w_cm->Required) { ?>
			elm = this.getElements("x" + infix + "_w_cm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cost_calculator->w_cm->caption(), $cost_calculator->w_cm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_w_cm");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($cost_calculator->w_cm->errorMessage()) ?>");
		<?php if ($cost_calculator_edit->l_cm->Required) { ?>
			elm = this.getElements("x" + infix + "_l_cm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cost_calculator->l_cm->caption(), $cost_calculator->l_cm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_l_cm");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($cost_calculator->l_cm->errorMessage()) ?>");
		<?php if ($cost_calculator_edit->bom_percent->Required) { ?>
			elm = this.getElements("x" + infix + "_bom_percent");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cost_calculator->bom_percent->caption(), $cost_calculator->bom_percent->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_bom_percent");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($cost_calculator->bom_percent->errorMessage()) ?>");
		<?php if ($cost_calculator_edit->process_percent->Required) { ?>
			elm = this.getElements("x" + infix + "_process_percent");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cost_calculator->process_percent->caption(), $cost_calculator->process_percent->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_process_percent");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($cost_calculator->process_percent->errorMessage()) ?>");
		<?php if ($cost_calculator_edit->other_sqm->Required) { ?>
			elm = this.getElements("x" + infix + "_other_sqm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cost_calculator->other_sqm->caption(), $cost_calculator->other_sqm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_other_sqm");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($cost_calculator->other_sqm->errorMessage()) ?>");
		<?php if ($cost_calculator_edit->margin_percent->Required) { ?>
			elm = this.getElements("x" + infix + "_margin_percent");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cost_calculator->margin_percent->caption(), $cost_calculator->margin_percent->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_margin_percent");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($cost_calculator->margin_percent->errorMessage()) ?>");
		<?php if ($cost_calculator_edit->price->Required) { ?>
			elm = this.getElements("x" + infix + "_price");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cost_calculator->price->caption(), $cost_calculator->price->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_price");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($cost_calculator->price->errorMessage()) ?>");
		<?php if ($cost_calculator_edit->currency->Required) { ?>
			elm = this.getElements("x" + infix + "_currency");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cost_calculator->currency->caption(), $cost_calculator->currency->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cost_calculator_edit->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cost_calculator->dated->caption(), $cost_calculator->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($cost_calculator->dated->errorMessage()) ?>");
		<?php if ($cost_calculator_edit->packing_type->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cost_calculator->packing_type->caption(), $cost_calculator->packing_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cost_calculator_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cost_calculator->operator->caption(), $cost_calculator->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cost_calculator_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cost_calculator->datetime->caption(), $cost_calculator->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fcost_calculatoredit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcost_calculatoredit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcost_calculatoredit.lists["x_buyer_id"] = <?php echo $cost_calculator_edit->buyer_id->Lookup->toClientList() ?>;
fcost_calculatoredit.lists["x_buyer_id"].options = <?php echo JsonEncode($cost_calculator_edit->buyer_id->lookupOptions()) ?>;
fcost_calculatoredit.lists["x_rid"] = <?php echo $cost_calculator_edit->rid->Lookup->toClientList() ?>;
fcost_calculatoredit.lists["x_rid"].options = <?php echo JsonEncode($cost_calculator_edit->rid->lookupOptions()) ?>;
fcost_calculatoredit.lists["x_batch_no"] = <?php echo $cost_calculator_edit->batch_no->Lookup->toClientList() ?>;
fcost_calculatoredit.lists["x_batch_no"].options = <?php echo JsonEncode($cost_calculator_edit->batch_no->lookupOptions()) ?>;
fcost_calculatoredit.lists["x_shape"] = <?php echo $cost_calculator_edit->shape->Lookup->toClientList() ?>;
fcost_calculatoredit.lists["x_shape"].options = <?php echo JsonEncode($cost_calculator_edit->shape->lookupOptions()) ?>;
fcost_calculatoredit.lists["x_currency"] = <?php echo $cost_calculator_edit->currency->Lookup->toClientList() ?>;
fcost_calculatoredit.lists["x_currency"].options = <?php echo JsonEncode($cost_calculator_edit->currency->lookupOptions()) ?>;
fcost_calculatoredit.lists["x_packing_type"] = <?php echo $cost_calculator_edit->packing_type->Lookup->toClientList() ?>;
fcost_calculatoredit.lists["x_packing_type"].options = <?php echo JsonEncode($cost_calculator_edit->packing_type->lookupOptions()) ?>;
fcost_calculatoredit.lists["x_operator"] = <?php echo $cost_calculator_edit->operator->Lookup->toClientList() ?>;
fcost_calculatoredit.lists["x_operator"].options = <?php echo JsonEncode($cost_calculator_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $cost_calculator_edit->showPageHeader(); ?>
<?php
$cost_calculator_edit->showMessage();
?>
<form name="fcost_calculatoredit" id="fcost_calculatoredit" class="<?php echo $cost_calculator_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($cost_calculator_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $cost_calculator_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="cost_calculator">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$cost_calculator_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($cost_calculator->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_cost_calculator_id" class="<?php echo $cost_calculator_edit->LeftColumnClass ?>"><?php echo $cost_calculator->id->caption() ?><?php echo ($cost_calculator->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cost_calculator_edit->RightColumnClass ?>"><div<?php echo $cost_calculator->id->cellAttributes() ?>>
<span id="el_cost_calculator_id">
<span<?php echo $cost_calculator->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cost_calculator->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="cost_calculator" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($cost_calculator->id->CurrentValue) ?>">
<?php echo $cost_calculator->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($cost_calculator->buyer_id->Visible) { // buyer_id ?>
	<div id="r_buyer_id" class="form-group row">
		<label id="elh_cost_calculator_buyer_id" for="x_buyer_id" class="<?php echo $cost_calculator_edit->LeftColumnClass ?>"><?php echo $cost_calculator->buyer_id->caption() ?><?php echo ($cost_calculator->buyer_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cost_calculator_edit->RightColumnClass ?>"><div<?php echo $cost_calculator->buyer_id->cellAttributes() ?>>
<span id="el_cost_calculator_buyer_id">
<span<?php echo $cost_calculator->buyer_id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cost_calculator->buyer_id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="cost_calculator" data-field="x_buyer_id" name="x_buyer_id" id="x_buyer_id" value="<?php echo HtmlEncode($cost_calculator->buyer_id->CurrentValue) ?>">
<?php echo $cost_calculator->buyer_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($cost_calculator->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label id="elh_cost_calculator_rid" for="x_rid" class="<?php echo $cost_calculator_edit->LeftColumnClass ?>"><?php echo $cost_calculator->rid->caption() ?><?php echo ($cost_calculator->rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cost_calculator_edit->RightColumnClass ?>"><div<?php echo $cost_calculator->rid->cellAttributes() ?>>
<span id="el_cost_calculator_rid">
<span<?php echo $cost_calculator->rid->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cost_calculator->rid->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="cost_calculator" data-field="x_rid" name="x_rid" id="x_rid" value="<?php echo HtmlEncode($cost_calculator->rid->CurrentValue) ?>">
<?php echo $cost_calculator->rid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($cost_calculator->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label id="elh_cost_calculator_batch_no" for="x_batch_no" class="<?php echo $cost_calculator_edit->LeftColumnClass ?>"><?php echo $cost_calculator->batch_no->caption() ?><?php echo ($cost_calculator->batch_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cost_calculator_edit->RightColumnClass ?>"><div<?php echo $cost_calculator->batch_no->cellAttributes() ?>>
<span id="el_cost_calculator_batch_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cost_calculator" data-field="x_batch_no" data-value-separator="<?php echo $cost_calculator->batch_no->displayValueSeparatorAttribute() ?>" id="x_batch_no" name="x_batch_no"<?php echo $cost_calculator->batch_no->editAttributes() ?>>
		<?php echo $cost_calculator->batch_no->selectOptionListHtml("x_batch_no") ?>
	</select>
</div>
<?php echo $cost_calculator->batch_no->Lookup->getParamTag("p_x_batch_no") ?>
</span>
<?php echo $cost_calculator->batch_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($cost_calculator->price_inr->Visible) { // price_inr ?>
	<div id="r_price_inr" class="form-group row">
		<label id="elh_cost_calculator_price_inr" for="x_price_inr" class="<?php echo $cost_calculator_edit->LeftColumnClass ?>"><?php echo $cost_calculator->price_inr->caption() ?><?php echo ($cost_calculator->price_inr->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cost_calculator_edit->RightColumnClass ?>"><div<?php echo $cost_calculator->price_inr->cellAttributes() ?>>
<span id="el_cost_calculator_price_inr">
<input type="text" data-table="cost_calculator" data-field="x_price_inr" name="x_price_inr" id="x_price_inr" size="30" placeholder="<?php echo HtmlEncode($cost_calculator->price_inr->getPlaceHolder()) ?>" value="<?php echo $cost_calculator->price_inr->EditValue ?>"<?php echo $cost_calculator->price_inr->editAttributes() ?>>
</span>
<?php echo $cost_calculator->price_inr->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($cost_calculator->shape->Visible) { // shape ?>
	<div id="r_shape" class="form-group row">
		<label id="elh_cost_calculator_shape" for="x_shape" class="<?php echo $cost_calculator_edit->LeftColumnClass ?>"><?php echo $cost_calculator->shape->caption() ?><?php echo ($cost_calculator->shape->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cost_calculator_edit->RightColumnClass ?>"><div<?php echo $cost_calculator->shape->cellAttributes() ?>>
<span id="el_cost_calculator_shape">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cost_calculator" data-field="x_shape" data-value-separator="<?php echo $cost_calculator->shape->displayValueSeparatorAttribute() ?>" id="x_shape" name="x_shape"<?php echo $cost_calculator->shape->editAttributes() ?>>
		<?php echo $cost_calculator->shape->selectOptionListHtml("x_shape") ?>
	</select>
</div>
<?php echo $cost_calculator->shape->Lookup->getParamTag("p_x_shape") ?>
</span>
<?php echo $cost_calculator->shape->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($cost_calculator->w_cm->Visible) { // w_cm ?>
	<div id="r_w_cm" class="form-group row">
		<label id="elh_cost_calculator_w_cm" for="x_w_cm" class="<?php echo $cost_calculator_edit->LeftColumnClass ?>"><?php echo $cost_calculator->w_cm->caption() ?><?php echo ($cost_calculator->w_cm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cost_calculator_edit->RightColumnClass ?>"><div<?php echo $cost_calculator->w_cm->cellAttributes() ?>>
<span id="el_cost_calculator_w_cm">
<input type="text" data-table="cost_calculator" data-field="x_w_cm" name="x_w_cm" id="x_w_cm" size="30" placeholder="<?php echo HtmlEncode($cost_calculator->w_cm->getPlaceHolder()) ?>" value="<?php echo $cost_calculator->w_cm->EditValue ?>"<?php echo $cost_calculator->w_cm->editAttributes() ?>>
</span>
<?php echo $cost_calculator->w_cm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($cost_calculator->l_cm->Visible) { // l_cm ?>
	<div id="r_l_cm" class="form-group row">
		<label id="elh_cost_calculator_l_cm" for="x_l_cm" class="<?php echo $cost_calculator_edit->LeftColumnClass ?>"><?php echo $cost_calculator->l_cm->caption() ?><?php echo ($cost_calculator->l_cm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cost_calculator_edit->RightColumnClass ?>"><div<?php echo $cost_calculator->l_cm->cellAttributes() ?>>
<span id="el_cost_calculator_l_cm">
<input type="text" data-table="cost_calculator" data-field="x_l_cm" name="x_l_cm" id="x_l_cm" size="30" placeholder="<?php echo HtmlEncode($cost_calculator->l_cm->getPlaceHolder()) ?>" value="<?php echo $cost_calculator->l_cm->EditValue ?>"<?php echo $cost_calculator->l_cm->editAttributes() ?>>
</span>
<?php echo $cost_calculator->l_cm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($cost_calculator->bom_percent->Visible) { // bom_percent ?>
	<div id="r_bom_percent" class="form-group row">
		<label id="elh_cost_calculator_bom_percent" for="x_bom_percent" class="<?php echo $cost_calculator_edit->LeftColumnClass ?>"><?php echo $cost_calculator->bom_percent->caption() ?><?php echo ($cost_calculator->bom_percent->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cost_calculator_edit->RightColumnClass ?>"><div<?php echo $cost_calculator->bom_percent->cellAttributes() ?>>
<span id="el_cost_calculator_bom_percent">
<input type="text" data-table="cost_calculator" data-field="x_bom_percent" name="x_bom_percent" id="x_bom_percent" size="30" placeholder="<?php echo HtmlEncode($cost_calculator->bom_percent->getPlaceHolder()) ?>" value="<?php echo $cost_calculator->bom_percent->EditValue ?>"<?php echo $cost_calculator->bom_percent->editAttributes() ?>>
</span>
<?php echo $cost_calculator->bom_percent->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($cost_calculator->process_percent->Visible) { // process_percent ?>
	<div id="r_process_percent" class="form-group row">
		<label id="elh_cost_calculator_process_percent" for="x_process_percent" class="<?php echo $cost_calculator_edit->LeftColumnClass ?>"><?php echo $cost_calculator->process_percent->caption() ?><?php echo ($cost_calculator->process_percent->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cost_calculator_edit->RightColumnClass ?>"><div<?php echo $cost_calculator->process_percent->cellAttributes() ?>>
<span id="el_cost_calculator_process_percent">
<input type="text" data-table="cost_calculator" data-field="x_process_percent" name="x_process_percent" id="x_process_percent" size="30" placeholder="<?php echo HtmlEncode($cost_calculator->process_percent->getPlaceHolder()) ?>" value="<?php echo $cost_calculator->process_percent->EditValue ?>"<?php echo $cost_calculator->process_percent->editAttributes() ?>>
</span>
<?php echo $cost_calculator->process_percent->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($cost_calculator->other_sqm->Visible) { // other_sqm ?>
	<div id="r_other_sqm" class="form-group row">
		<label id="elh_cost_calculator_other_sqm" for="x_other_sqm" class="<?php echo $cost_calculator_edit->LeftColumnClass ?>"><?php echo $cost_calculator->other_sqm->caption() ?><?php echo ($cost_calculator->other_sqm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cost_calculator_edit->RightColumnClass ?>"><div<?php echo $cost_calculator->other_sqm->cellAttributes() ?>>
<span id="el_cost_calculator_other_sqm">
<input type="text" data-table="cost_calculator" data-field="x_other_sqm" name="x_other_sqm" id="x_other_sqm" size="30" placeholder="<?php echo HtmlEncode($cost_calculator->other_sqm->getPlaceHolder()) ?>" value="<?php echo $cost_calculator->other_sqm->EditValue ?>"<?php echo $cost_calculator->other_sqm->editAttributes() ?>>
</span>
<?php echo $cost_calculator->other_sqm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($cost_calculator->margin_percent->Visible) { // margin_percent ?>
	<div id="r_margin_percent" class="form-group row">
		<label id="elh_cost_calculator_margin_percent" for="x_margin_percent" class="<?php echo $cost_calculator_edit->LeftColumnClass ?>"><?php echo $cost_calculator->margin_percent->caption() ?><?php echo ($cost_calculator->margin_percent->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cost_calculator_edit->RightColumnClass ?>"><div<?php echo $cost_calculator->margin_percent->cellAttributes() ?>>
<span id="el_cost_calculator_margin_percent">
<input type="text" data-table="cost_calculator" data-field="x_margin_percent" name="x_margin_percent" id="x_margin_percent" size="30" placeholder="<?php echo HtmlEncode($cost_calculator->margin_percent->getPlaceHolder()) ?>" value="<?php echo $cost_calculator->margin_percent->EditValue ?>"<?php echo $cost_calculator->margin_percent->editAttributes() ?>>
</span>
<?php echo $cost_calculator->margin_percent->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($cost_calculator->price->Visible) { // price ?>
	<div id="r_price" class="form-group row">
		<label id="elh_cost_calculator_price" for="x_price" class="<?php echo $cost_calculator_edit->LeftColumnClass ?>"><?php echo $cost_calculator->price->caption() ?><?php echo ($cost_calculator->price->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cost_calculator_edit->RightColumnClass ?>"><div<?php echo $cost_calculator->price->cellAttributes() ?>>
<span id="el_cost_calculator_price">
<input type="text" data-table="cost_calculator" data-field="x_price" name="x_price" id="x_price" size="30" placeholder="<?php echo HtmlEncode($cost_calculator->price->getPlaceHolder()) ?>" value="<?php echo $cost_calculator->price->EditValue ?>"<?php echo $cost_calculator->price->editAttributes() ?>>
</span>
<?php echo $cost_calculator->price->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($cost_calculator->currency->Visible) { // currency ?>
	<div id="r_currency" class="form-group row">
		<label id="elh_cost_calculator_currency" for="x_currency" class="<?php echo $cost_calculator_edit->LeftColumnClass ?>"><?php echo $cost_calculator->currency->caption() ?><?php echo ($cost_calculator->currency->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cost_calculator_edit->RightColumnClass ?>"><div<?php echo $cost_calculator->currency->cellAttributes() ?>>
<span id="el_cost_calculator_currency">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cost_calculator" data-field="x_currency" data-value-separator="<?php echo $cost_calculator->currency->displayValueSeparatorAttribute() ?>" id="x_currency" name="x_currency"<?php echo $cost_calculator->currency->editAttributes() ?>>
		<?php echo $cost_calculator->currency->selectOptionListHtml("x_currency") ?>
	</select>
</div>
<?php echo $cost_calculator->currency->Lookup->getParamTag("p_x_currency") ?>
</span>
<?php echo $cost_calculator->currency->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($cost_calculator->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_cost_calculator_dated" for="x_dated" class="<?php echo $cost_calculator_edit->LeftColumnClass ?>"><?php echo $cost_calculator->dated->caption() ?><?php echo ($cost_calculator->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cost_calculator_edit->RightColumnClass ?>"><div<?php echo $cost_calculator->dated->cellAttributes() ?>>
<span id="el_cost_calculator_dated">
<input type="text" data-table="cost_calculator" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($cost_calculator->dated->getPlaceHolder()) ?>" value="<?php echo $cost_calculator->dated->EditValue ?>"<?php echo $cost_calculator->dated->editAttributes() ?>>
<?php if (!$cost_calculator->dated->ReadOnly && !$cost_calculator->dated->Disabled && !isset($cost_calculator->dated->EditAttrs["readonly"]) && !isset($cost_calculator->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fcost_calculatoredit", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $cost_calculator->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($cost_calculator->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label id="elh_cost_calculator_packing_type" for="x_packing_type" class="<?php echo $cost_calculator_edit->LeftColumnClass ?>"><?php echo $cost_calculator->packing_type->caption() ?><?php echo ($cost_calculator->packing_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cost_calculator_edit->RightColumnClass ?>"><div<?php echo $cost_calculator->packing_type->cellAttributes() ?>>
<span id="el_cost_calculator_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cost_calculator" data-field="x_packing_type" data-value-separator="<?php echo $cost_calculator->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $cost_calculator->packing_type->editAttributes() ?>>
		<?php echo $cost_calculator->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $cost_calculator->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
<?php echo $cost_calculator->packing_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$cost_calculator_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $cost_calculator_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $cost_calculator_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$cost_calculator_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$cost_calculator_edit->terminate();
?>