<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$cost_calculator_list = new cost_calculator_list();

// Run the page
$cost_calculator_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$cost_calculator_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$cost_calculator->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fcost_calculatorlist = currentForm = new ew.Form("fcost_calculatorlist", "list");
fcost_calculatorlist.formKeyCountName = '<?php echo $cost_calculator_list->FormKeyCountName ?>';

// Form_CustomValidate event
fcost_calculatorlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcost_calculatorlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcost_calculatorlist.lists["x_buyer_id"] = <?php echo $cost_calculator_list->buyer_id->Lookup->toClientList() ?>;
fcost_calculatorlist.lists["x_buyer_id"].options = <?php echo JsonEncode($cost_calculator_list->buyer_id->lookupOptions()) ?>;
fcost_calculatorlist.lists["x_rid"] = <?php echo $cost_calculator_list->rid->Lookup->toClientList() ?>;
fcost_calculatorlist.lists["x_rid"].options = <?php echo JsonEncode($cost_calculator_list->rid->lookupOptions()) ?>;
fcost_calculatorlist.lists["x_batch_no"] = <?php echo $cost_calculator_list->batch_no->Lookup->toClientList() ?>;
fcost_calculatorlist.lists["x_batch_no"].options = <?php echo JsonEncode($cost_calculator_list->batch_no->lookupOptions()) ?>;
fcost_calculatorlist.lists["x_shape"] = <?php echo $cost_calculator_list->shape->Lookup->toClientList() ?>;
fcost_calculatorlist.lists["x_shape"].options = <?php echo JsonEncode($cost_calculator_list->shape->lookupOptions()) ?>;
fcost_calculatorlist.lists["x_currency"] = <?php echo $cost_calculator_list->currency->Lookup->toClientList() ?>;
fcost_calculatorlist.lists["x_currency"].options = <?php echo JsonEncode($cost_calculator_list->currency->lookupOptions()) ?>;
fcost_calculatorlist.lists["x_packing_type"] = <?php echo $cost_calculator_list->packing_type->Lookup->toClientList() ?>;
fcost_calculatorlist.lists["x_packing_type"].options = <?php echo JsonEncode($cost_calculator_list->packing_type->lookupOptions()) ?>;

// Form object for search
var fcost_calculatorlistsrch = currentSearchForm = new ew.Form("fcost_calculatorlistsrch");

// Validate function for search
fcost_calculatorlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fcost_calculatorlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcost_calculatorlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcost_calculatorlistsrch.lists["x_buyer_id"] = <?php echo $cost_calculator_list->buyer_id->Lookup->toClientList() ?>;
fcost_calculatorlistsrch.lists["x_buyer_id"].options = <?php echo JsonEncode($cost_calculator_list->buyer_id->lookupOptions()) ?>;
fcost_calculatorlistsrch.lists["x_rid"] = <?php echo $cost_calculator_list->rid->Lookup->toClientList() ?>;
fcost_calculatorlistsrch.lists["x_rid"].options = <?php echo JsonEncode($cost_calculator_list->rid->lookupOptions()) ?>;

// Filters
fcost_calculatorlistsrch.filterList = <?php echo $cost_calculator_list->getFilterList() ?>;

// Init search panel as collapsed
fcost_calculatorlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$cost_calculator->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($cost_calculator_list->TotalRecs > 0 && $cost_calculator_list->ExportOptions->visible()) { ?>
<?php $cost_calculator_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($cost_calculator_list->ImportOptions->visible()) { ?>
<?php $cost_calculator_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($cost_calculator_list->SearchOptions->visible()) { ?>
<?php $cost_calculator_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($cost_calculator_list->FilterOptions->visible()) { ?>
<?php $cost_calculator_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$cost_calculator_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$cost_calculator->isExport() && !$cost_calculator->CurrentAction) { ?>
<form name="fcost_calculatorlistsrch" id="fcost_calculatorlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($cost_calculator_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fcost_calculatorlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="cost_calculator">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$cost_calculator_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$cost_calculator->RowType = ROWTYPE_SEARCH;

// Render row
$cost_calculator->resetAttributes();
$cost_calculator_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($cost_calculator->buyer_id->Visible) { // buyer_id ?>
	<div id="xsc_buyer_id" class="ew-cell form-group">
		<label for="x_buyer_id" class="ew-search-caption ew-label"><?php echo $cost_calculator->buyer_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer_id" id="z_buyer_id" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cost_calculator" data-field="x_buyer_id" data-value-separator="<?php echo $cost_calculator->buyer_id->displayValueSeparatorAttribute() ?>" id="x_buyer_id" name="x_buyer_id"<?php echo $cost_calculator->buyer_id->editAttributes() ?>>
		<?php echo $cost_calculator->buyer_id->selectOptionListHtml("x_buyer_id") ?>
	</select>
</div>
<?php echo $cost_calculator->buyer_id->Lookup->getParamTag("p_x_buyer_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($cost_calculator->rid->Visible) { // rid ?>
	<div id="xsc_rid" class="ew-cell form-group">
		<label for="x_rid" class="ew-search-caption ew-label"><?php echo $cost_calculator->rid->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="cost_calculator" data-field="x_rid" name="x_rid" id="x_rid" size="30" placeholder="<?php echo HtmlEncode($cost_calculator->rid->getPlaceHolder()) ?>" value="<?php echo $cost_calculator->rid->EditValue ?>"<?php echo $cost_calculator->rid->editAttributes() ?>>
<?php echo $cost_calculator->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($cost_calculator_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($cost_calculator_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $cost_calculator_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($cost_calculator_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($cost_calculator_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($cost_calculator_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($cost_calculator_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $cost_calculator_list->showPageHeader(); ?>
<?php
$cost_calculator_list->showMessage();
?>
<?php if ($cost_calculator_list->TotalRecs > 0 || $cost_calculator->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($cost_calculator_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> cost_calculator">
<?php if (!$cost_calculator->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$cost_calculator->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($cost_calculator_list->Pager)) $cost_calculator_list->Pager = new PrevNextPager($cost_calculator_list->StartRec, $cost_calculator_list->DisplayRecs, $cost_calculator_list->TotalRecs, $cost_calculator_list->AutoHidePager) ?>
<?php if ($cost_calculator_list->Pager->RecordCount > 0 && $cost_calculator_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($cost_calculator_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $cost_calculator_list->pageUrl() ?>start=<?php echo $cost_calculator_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($cost_calculator_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $cost_calculator_list->pageUrl() ?>start=<?php echo $cost_calculator_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $cost_calculator_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($cost_calculator_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $cost_calculator_list->pageUrl() ?>start=<?php echo $cost_calculator_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($cost_calculator_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $cost_calculator_list->pageUrl() ?>start=<?php echo $cost_calculator_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $cost_calculator_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($cost_calculator_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $cost_calculator_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $cost_calculator_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $cost_calculator_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($cost_calculator_list->TotalRecs > 0 && (!$cost_calculator_list->AutoHidePageSizeSelector || $cost_calculator_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="cost_calculator">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($cost_calculator_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($cost_calculator_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($cost_calculator_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($cost_calculator_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($cost_calculator_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($cost_calculator->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $cost_calculator_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fcost_calculatorlist" id="fcost_calculatorlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($cost_calculator_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $cost_calculator_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="cost_calculator">
<div id="gmp_cost_calculator" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($cost_calculator_list->TotalRecs > 0 || $cost_calculator->isGridEdit()) { ?>
<table id="tbl_cost_calculatorlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$cost_calculator_list->RowType = ROWTYPE_HEADER;

// Render list options
$cost_calculator_list->renderListOptions();

// Render list options (header, left)
$cost_calculator_list->ListOptions->render("header", "left");
?>
<?php if ($cost_calculator->buyer_id->Visible) { // buyer_id ?>
	<?php if ($cost_calculator->sortUrl($cost_calculator->buyer_id) == "") { ?>
		<th data-name="buyer_id" class="<?php echo $cost_calculator->buyer_id->headerCellClass() ?>"><div id="elh_cost_calculator_buyer_id" class="cost_calculator_buyer_id"><div class="ew-table-header-caption"><?php echo $cost_calculator->buyer_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_id" class="<?php echo $cost_calculator->buyer_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cost_calculator->SortUrl($cost_calculator->buyer_id) ?>',2);"><div id="elh_cost_calculator_buyer_id" class="cost_calculator_buyer_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cost_calculator->buyer_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($cost_calculator->buyer_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cost_calculator->buyer_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cost_calculator->rid->Visible) { // rid ?>
	<?php if ($cost_calculator->sortUrl($cost_calculator->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $cost_calculator->rid->headerCellClass() ?>"><div id="elh_cost_calculator_rid" class="cost_calculator_rid"><div class="ew-table-header-caption"><?php echo $cost_calculator->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $cost_calculator->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cost_calculator->SortUrl($cost_calculator->rid) ?>',2);"><div id="elh_cost_calculator_rid" class="cost_calculator_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cost_calculator->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($cost_calculator->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cost_calculator->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cost_calculator->batch_no->Visible) { // batch_no ?>
	<?php if ($cost_calculator->sortUrl($cost_calculator->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $cost_calculator->batch_no->headerCellClass() ?>"><div id="elh_cost_calculator_batch_no" class="cost_calculator_batch_no"><div class="ew-table-header-caption"><?php echo $cost_calculator->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $cost_calculator->batch_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cost_calculator->SortUrl($cost_calculator->batch_no) ?>',2);"><div id="elh_cost_calculator_batch_no" class="cost_calculator_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cost_calculator->batch_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($cost_calculator->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cost_calculator->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cost_calculator->price_inr->Visible) { // price_inr ?>
	<?php if ($cost_calculator->sortUrl($cost_calculator->price_inr) == "") { ?>
		<th data-name="price_inr" class="<?php echo $cost_calculator->price_inr->headerCellClass() ?>"><div id="elh_cost_calculator_price_inr" class="cost_calculator_price_inr"><div class="ew-table-header-caption"><?php echo $cost_calculator->price_inr->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price_inr" class="<?php echo $cost_calculator->price_inr->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cost_calculator->SortUrl($cost_calculator->price_inr) ?>',2);"><div id="elh_cost_calculator_price_inr" class="cost_calculator_price_inr">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cost_calculator->price_inr->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($cost_calculator->price_inr->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cost_calculator->price_inr->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cost_calculator->shape->Visible) { // shape ?>
	<?php if ($cost_calculator->sortUrl($cost_calculator->shape) == "") { ?>
		<th data-name="shape" class="<?php echo $cost_calculator->shape->headerCellClass() ?>"><div id="elh_cost_calculator_shape" class="cost_calculator_shape"><div class="ew-table-header-caption"><?php echo $cost_calculator->shape->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="shape" class="<?php echo $cost_calculator->shape->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cost_calculator->SortUrl($cost_calculator->shape) ?>',2);"><div id="elh_cost_calculator_shape" class="cost_calculator_shape">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cost_calculator->shape->caption() ?></span><span class="ew-table-header-sort"><?php if ($cost_calculator->shape->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cost_calculator->shape->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cost_calculator->w_cm->Visible) { // w_cm ?>
	<?php if ($cost_calculator->sortUrl($cost_calculator->w_cm) == "") { ?>
		<th data-name="w_cm" class="<?php echo $cost_calculator->w_cm->headerCellClass() ?>"><div id="elh_cost_calculator_w_cm" class="cost_calculator_w_cm"><div class="ew-table-header-caption"><?php echo $cost_calculator->w_cm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="w_cm" class="<?php echo $cost_calculator->w_cm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cost_calculator->SortUrl($cost_calculator->w_cm) ?>',2);"><div id="elh_cost_calculator_w_cm" class="cost_calculator_w_cm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cost_calculator->w_cm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($cost_calculator->w_cm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cost_calculator->w_cm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cost_calculator->l_cm->Visible) { // l_cm ?>
	<?php if ($cost_calculator->sortUrl($cost_calculator->l_cm) == "") { ?>
		<th data-name="l_cm" class="<?php echo $cost_calculator->l_cm->headerCellClass() ?>"><div id="elh_cost_calculator_l_cm" class="cost_calculator_l_cm"><div class="ew-table-header-caption"><?php echo $cost_calculator->l_cm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="l_cm" class="<?php echo $cost_calculator->l_cm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cost_calculator->SortUrl($cost_calculator->l_cm) ?>',2);"><div id="elh_cost_calculator_l_cm" class="cost_calculator_l_cm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cost_calculator->l_cm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($cost_calculator->l_cm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cost_calculator->l_cm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cost_calculator->bom_percent->Visible) { // bom_percent ?>
	<?php if ($cost_calculator->sortUrl($cost_calculator->bom_percent) == "") { ?>
		<th data-name="bom_percent" class="<?php echo $cost_calculator->bom_percent->headerCellClass() ?>"><div id="elh_cost_calculator_bom_percent" class="cost_calculator_bom_percent"><div class="ew-table-header-caption"><?php echo $cost_calculator->bom_percent->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="bom_percent" class="<?php echo $cost_calculator->bom_percent->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cost_calculator->SortUrl($cost_calculator->bom_percent) ?>',2);"><div id="elh_cost_calculator_bom_percent" class="cost_calculator_bom_percent">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cost_calculator->bom_percent->caption() ?></span><span class="ew-table-header-sort"><?php if ($cost_calculator->bom_percent->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cost_calculator->bom_percent->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cost_calculator->process_percent->Visible) { // process_percent ?>
	<?php if ($cost_calculator->sortUrl($cost_calculator->process_percent) == "") { ?>
		<th data-name="process_percent" class="<?php echo $cost_calculator->process_percent->headerCellClass() ?>"><div id="elh_cost_calculator_process_percent" class="cost_calculator_process_percent"><div class="ew-table-header-caption"><?php echo $cost_calculator->process_percent->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process_percent" class="<?php echo $cost_calculator->process_percent->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cost_calculator->SortUrl($cost_calculator->process_percent) ?>',2);"><div id="elh_cost_calculator_process_percent" class="cost_calculator_process_percent">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cost_calculator->process_percent->caption() ?></span><span class="ew-table-header-sort"><?php if ($cost_calculator->process_percent->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cost_calculator->process_percent->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cost_calculator->other_sqm->Visible) { // other_sqm ?>
	<?php if ($cost_calculator->sortUrl($cost_calculator->other_sqm) == "") { ?>
		<th data-name="other_sqm" class="<?php echo $cost_calculator->other_sqm->headerCellClass() ?>"><div id="elh_cost_calculator_other_sqm" class="cost_calculator_other_sqm"><div class="ew-table-header-caption"><?php echo $cost_calculator->other_sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="other_sqm" class="<?php echo $cost_calculator->other_sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cost_calculator->SortUrl($cost_calculator->other_sqm) ?>',2);"><div id="elh_cost_calculator_other_sqm" class="cost_calculator_other_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cost_calculator->other_sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($cost_calculator->other_sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cost_calculator->other_sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cost_calculator->margin_percent->Visible) { // margin_percent ?>
	<?php if ($cost_calculator->sortUrl($cost_calculator->margin_percent) == "") { ?>
		<th data-name="margin_percent" class="<?php echo $cost_calculator->margin_percent->headerCellClass() ?>"><div id="elh_cost_calculator_margin_percent" class="cost_calculator_margin_percent"><div class="ew-table-header-caption"><?php echo $cost_calculator->margin_percent->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="margin_percent" class="<?php echo $cost_calculator->margin_percent->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cost_calculator->SortUrl($cost_calculator->margin_percent) ?>',2);"><div id="elh_cost_calculator_margin_percent" class="cost_calculator_margin_percent">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cost_calculator->margin_percent->caption() ?></span><span class="ew-table-header-sort"><?php if ($cost_calculator->margin_percent->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cost_calculator->margin_percent->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cost_calculator->price->Visible) { // price ?>
	<?php if ($cost_calculator->sortUrl($cost_calculator->price) == "") { ?>
		<th data-name="price" class="<?php echo $cost_calculator->price->headerCellClass() ?>"><div id="elh_cost_calculator_price" class="cost_calculator_price"><div class="ew-table-header-caption"><?php echo $cost_calculator->price->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price" class="<?php echo $cost_calculator->price->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cost_calculator->SortUrl($cost_calculator->price) ?>',2);"><div id="elh_cost_calculator_price" class="cost_calculator_price">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cost_calculator->price->caption() ?></span><span class="ew-table-header-sort"><?php if ($cost_calculator->price->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cost_calculator->price->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cost_calculator->currency->Visible) { // currency ?>
	<?php if ($cost_calculator->sortUrl($cost_calculator->currency) == "") { ?>
		<th data-name="currency" class="<?php echo $cost_calculator->currency->headerCellClass() ?>"><div id="elh_cost_calculator_currency" class="cost_calculator_currency"><div class="ew-table-header-caption"><?php echo $cost_calculator->currency->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="currency" class="<?php echo $cost_calculator->currency->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cost_calculator->SortUrl($cost_calculator->currency) ?>',2);"><div id="elh_cost_calculator_currency" class="cost_calculator_currency">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cost_calculator->currency->caption() ?></span><span class="ew-table-header-sort"><?php if ($cost_calculator->currency->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cost_calculator->currency->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cost_calculator->dated->Visible) { // dated ?>
	<?php if ($cost_calculator->sortUrl($cost_calculator->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $cost_calculator->dated->headerCellClass() ?>"><div id="elh_cost_calculator_dated" class="cost_calculator_dated"><div class="ew-table-header-caption"><?php echo $cost_calculator->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $cost_calculator->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cost_calculator->SortUrl($cost_calculator->dated) ?>',2);"><div id="elh_cost_calculator_dated" class="cost_calculator_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cost_calculator->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($cost_calculator->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cost_calculator->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cost_calculator->packing_type->Visible) { // packing_type ?>
	<?php if ($cost_calculator->sortUrl($cost_calculator->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $cost_calculator->packing_type->headerCellClass() ?>"><div id="elh_cost_calculator_packing_type" class="cost_calculator_packing_type"><div class="ew-table-header-caption"><?php echo $cost_calculator->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $cost_calculator->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cost_calculator->SortUrl($cost_calculator->packing_type) ?>',2);"><div id="elh_cost_calculator_packing_type" class="cost_calculator_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cost_calculator->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($cost_calculator->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cost_calculator->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$cost_calculator_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($cost_calculator->ExportAll && $cost_calculator->isExport()) {
	$cost_calculator_list->StopRec = $cost_calculator_list->TotalRecs;
} else {

	// Set the last record to display
	if ($cost_calculator_list->TotalRecs > $cost_calculator_list->StartRec + $cost_calculator_list->DisplayRecs - 1)
		$cost_calculator_list->StopRec = $cost_calculator_list->StartRec + $cost_calculator_list->DisplayRecs - 1;
	else
		$cost_calculator_list->StopRec = $cost_calculator_list->TotalRecs;
}
$cost_calculator_list->RecCnt = $cost_calculator_list->StartRec - 1;
if ($cost_calculator_list->Recordset && !$cost_calculator_list->Recordset->EOF) {
	$cost_calculator_list->Recordset->moveFirst();
	$selectLimit = $cost_calculator_list->UseSelectLimit;
	if (!$selectLimit && $cost_calculator_list->StartRec > 1)
		$cost_calculator_list->Recordset->move($cost_calculator_list->StartRec - 1);
} elseif (!$cost_calculator->AllowAddDeleteRow && $cost_calculator_list->StopRec == 0) {
	$cost_calculator_list->StopRec = $cost_calculator->GridAddRowCount;
}

// Initialize aggregate
$cost_calculator->RowType = ROWTYPE_AGGREGATEINIT;
$cost_calculator->resetAttributes();
$cost_calculator_list->renderRow();
while ($cost_calculator_list->RecCnt < $cost_calculator_list->StopRec) {
	$cost_calculator_list->RecCnt++;
	if ($cost_calculator_list->RecCnt >= $cost_calculator_list->StartRec) {
		$cost_calculator_list->RowCnt++;

		// Set up key count
		$cost_calculator_list->KeyCount = $cost_calculator_list->RowIndex;

		// Init row class and style
		$cost_calculator->resetAttributes();
		$cost_calculator->CssClass = "";
		if ($cost_calculator->isGridAdd()) {
		} else {
			$cost_calculator_list->loadRowValues($cost_calculator_list->Recordset); // Load row values
		}
		$cost_calculator->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$cost_calculator->RowAttrs = array_merge($cost_calculator->RowAttrs, array('data-rowindex'=>$cost_calculator_list->RowCnt, 'id'=>'r' . $cost_calculator_list->RowCnt . '_cost_calculator', 'data-rowtype'=>$cost_calculator->RowType));

		// Render row
		$cost_calculator_list->renderRow();

		// Render list options
		$cost_calculator_list->renderListOptions();
?>
	<tr<?php echo $cost_calculator->rowAttributes() ?>>
<?php

// Render list options (body, left)
$cost_calculator_list->ListOptions->render("body", "left", $cost_calculator_list->RowCnt);
?>
	<?php if ($cost_calculator->buyer_id->Visible) { // buyer_id ?>
		<td data-name="buyer_id"<?php echo $cost_calculator->buyer_id->cellAttributes() ?>>
<span id="el<?php echo $cost_calculator_list->RowCnt ?>_cost_calculator_buyer_id" class="cost_calculator_buyer_id">
<span<?php echo $cost_calculator->buyer_id->viewAttributes() ?>>
<?php echo $cost_calculator->buyer_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cost_calculator->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $cost_calculator->rid->cellAttributes() ?>>
<span id="el<?php echo $cost_calculator_list->RowCnt ?>_cost_calculator_rid" class="cost_calculator_rid">
<span<?php echo $cost_calculator->rid->viewAttributes() ?>>
<?php echo $cost_calculator->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cost_calculator->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $cost_calculator->batch_no->cellAttributes() ?>>
<span id="el<?php echo $cost_calculator_list->RowCnt ?>_cost_calculator_batch_no" class="cost_calculator_batch_no">
<span<?php echo $cost_calculator->batch_no->viewAttributes() ?>>
<?php if ((!EmptyString($cost_calculator->batch_no->getViewValue())) && $cost_calculator->batch_no->linkAttributes() <> "") { ?>
<a<?php echo $cost_calculator->batch_no->linkAttributes() ?>><?php echo $cost_calculator->batch_no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $cost_calculator->batch_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($cost_calculator->price_inr->Visible) { // price_inr ?>
		<td data-name="price_inr"<?php echo $cost_calculator->price_inr->cellAttributes() ?>>
<span id="el<?php echo $cost_calculator_list->RowCnt ?>_cost_calculator_price_inr" class="cost_calculator_price_inr">
<span<?php echo $cost_calculator->price_inr->viewAttributes() ?>>
<?php if ((!EmptyString($cost_calculator->price_inr->getViewValue())) && $cost_calculator->price_inr->linkAttributes() <> "") { ?>
<a<?php echo $cost_calculator->price_inr->linkAttributes() ?>><?php echo $cost_calculator->price_inr->getViewValue() ?></a>
<?php } else { ?>
<?php echo $cost_calculator->price_inr->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($cost_calculator->shape->Visible) { // shape ?>
		<td data-name="shape"<?php echo $cost_calculator->shape->cellAttributes() ?>>
<span id="el<?php echo $cost_calculator_list->RowCnt ?>_cost_calculator_shape" class="cost_calculator_shape">
<span<?php echo $cost_calculator->shape->viewAttributes() ?>>
<?php echo $cost_calculator->shape->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cost_calculator->w_cm->Visible) { // w_cm ?>
		<td data-name="w_cm"<?php echo $cost_calculator->w_cm->cellAttributes() ?>>
<span id="el<?php echo $cost_calculator_list->RowCnt ?>_cost_calculator_w_cm" class="cost_calculator_w_cm">
<span<?php echo $cost_calculator->w_cm->viewAttributes() ?>>
<?php echo $cost_calculator->w_cm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cost_calculator->l_cm->Visible) { // l_cm ?>
		<td data-name="l_cm"<?php echo $cost_calculator->l_cm->cellAttributes() ?>>
<span id="el<?php echo $cost_calculator_list->RowCnt ?>_cost_calculator_l_cm" class="cost_calculator_l_cm">
<span<?php echo $cost_calculator->l_cm->viewAttributes() ?>>
<?php echo $cost_calculator->l_cm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cost_calculator->bom_percent->Visible) { // bom_percent ?>
		<td data-name="bom_percent"<?php echo $cost_calculator->bom_percent->cellAttributes() ?>>
<span id="el<?php echo $cost_calculator_list->RowCnt ?>_cost_calculator_bom_percent" class="cost_calculator_bom_percent">
<span<?php echo $cost_calculator->bom_percent->viewAttributes() ?>>
<?php echo $cost_calculator->bom_percent->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cost_calculator->process_percent->Visible) { // process_percent ?>
		<td data-name="process_percent"<?php echo $cost_calculator->process_percent->cellAttributes() ?>>
<span id="el<?php echo $cost_calculator_list->RowCnt ?>_cost_calculator_process_percent" class="cost_calculator_process_percent">
<span<?php echo $cost_calculator->process_percent->viewAttributes() ?>>
<?php echo $cost_calculator->process_percent->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cost_calculator->other_sqm->Visible) { // other_sqm ?>
		<td data-name="other_sqm"<?php echo $cost_calculator->other_sqm->cellAttributes() ?>>
<span id="el<?php echo $cost_calculator_list->RowCnt ?>_cost_calculator_other_sqm" class="cost_calculator_other_sqm">
<span<?php echo $cost_calculator->other_sqm->viewAttributes() ?>>
<?php echo $cost_calculator->other_sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cost_calculator->margin_percent->Visible) { // margin_percent ?>
		<td data-name="margin_percent"<?php echo $cost_calculator->margin_percent->cellAttributes() ?>>
<span id="el<?php echo $cost_calculator_list->RowCnt ?>_cost_calculator_margin_percent" class="cost_calculator_margin_percent">
<span<?php echo $cost_calculator->margin_percent->viewAttributes() ?>>
<?php echo $cost_calculator->margin_percent->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cost_calculator->price->Visible) { // price ?>
		<td data-name="price"<?php echo $cost_calculator->price->cellAttributes() ?>>
<span id="el<?php echo $cost_calculator_list->RowCnt ?>_cost_calculator_price" class="cost_calculator_price">
<span<?php echo $cost_calculator->price->viewAttributes() ?>>
<?php echo $cost_calculator->price->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cost_calculator->currency->Visible) { // currency ?>
		<td data-name="currency"<?php echo $cost_calculator->currency->cellAttributes() ?>>
<span id="el<?php echo $cost_calculator_list->RowCnt ?>_cost_calculator_currency" class="cost_calculator_currency">
<span<?php echo $cost_calculator->currency->viewAttributes() ?>>
<?php echo $cost_calculator->currency->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cost_calculator->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $cost_calculator->dated->cellAttributes() ?>>
<span id="el<?php echo $cost_calculator_list->RowCnt ?>_cost_calculator_dated" class="cost_calculator_dated">
<span<?php echo $cost_calculator->dated->viewAttributes() ?>>
<?php echo $cost_calculator->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cost_calculator->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $cost_calculator->packing_type->cellAttributes() ?>>
<span id="el<?php echo $cost_calculator_list->RowCnt ?>_cost_calculator_packing_type" class="cost_calculator_packing_type">
<span<?php echo $cost_calculator->packing_type->viewAttributes() ?>>
<?php echo $cost_calculator->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$cost_calculator_list->ListOptions->render("body", "right", $cost_calculator_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$cost_calculator->isGridAdd())
		$cost_calculator_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$cost_calculator->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($cost_calculator_list->Recordset)
	$cost_calculator_list->Recordset->Close();
?>
<?php if (!$cost_calculator->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$cost_calculator->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($cost_calculator_list->Pager)) $cost_calculator_list->Pager = new PrevNextPager($cost_calculator_list->StartRec, $cost_calculator_list->DisplayRecs, $cost_calculator_list->TotalRecs, $cost_calculator_list->AutoHidePager) ?>
<?php if ($cost_calculator_list->Pager->RecordCount > 0 && $cost_calculator_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($cost_calculator_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $cost_calculator_list->pageUrl() ?>start=<?php echo $cost_calculator_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($cost_calculator_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $cost_calculator_list->pageUrl() ?>start=<?php echo $cost_calculator_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $cost_calculator_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($cost_calculator_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $cost_calculator_list->pageUrl() ?>start=<?php echo $cost_calculator_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($cost_calculator_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $cost_calculator_list->pageUrl() ?>start=<?php echo $cost_calculator_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $cost_calculator_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($cost_calculator_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $cost_calculator_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $cost_calculator_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $cost_calculator_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($cost_calculator_list->TotalRecs > 0 && (!$cost_calculator_list->AutoHidePageSizeSelector || $cost_calculator_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="cost_calculator">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($cost_calculator_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($cost_calculator_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($cost_calculator_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($cost_calculator_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($cost_calculator_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($cost_calculator->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $cost_calculator_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($cost_calculator_list->TotalRecs == 0 && !$cost_calculator->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $cost_calculator_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$cost_calculator_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$cost_calculator->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$cost_calculator->isExport()) { ?>
<script>
ew.scrollableTable("gmp_cost_calculator", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$cost_calculator_list->terminate();
?>