<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$cost_calculator_search = new cost_calculator_search();

// Run the page
$cost_calculator_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$cost_calculator_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($cost_calculator_search->IsModal) { ?>
var fcost_calculatorsearch = currentAdvancedSearchForm = new ew.Form("fcost_calculatorsearch", "search");
<?php } else { ?>
var fcost_calculatorsearch = currentForm = new ew.Form("fcost_calculatorsearch", "search");
<?php } ?>

// Form_CustomValidate event
fcost_calculatorsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcost_calculatorsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcost_calculatorsearch.lists["x_buyer_id"] = <?php echo $cost_calculator_search->buyer_id->Lookup->toClientList() ?>;
fcost_calculatorsearch.lists["x_buyer_id"].options = <?php echo JsonEncode($cost_calculator_search->buyer_id->lookupOptions()) ?>;
fcost_calculatorsearch.lists["x_rid"] = <?php echo $cost_calculator_search->rid->Lookup->toClientList() ?>;
fcost_calculatorsearch.lists["x_rid"].options = <?php echo JsonEncode($cost_calculator_search->rid->lookupOptions()) ?>;
fcost_calculatorsearch.lists["x_batch_no"] = <?php echo $cost_calculator_search->batch_no->Lookup->toClientList() ?>;
fcost_calculatorsearch.lists["x_batch_no"].options = <?php echo JsonEncode($cost_calculator_search->batch_no->lookupOptions()) ?>;
fcost_calculatorsearch.lists["x_shape"] = <?php echo $cost_calculator_search->shape->Lookup->toClientList() ?>;
fcost_calculatorsearch.lists["x_shape"].options = <?php echo JsonEncode($cost_calculator_search->shape->lookupOptions()) ?>;
fcost_calculatorsearch.lists["x_currency"] = <?php echo $cost_calculator_search->currency->Lookup->toClientList() ?>;
fcost_calculatorsearch.lists["x_currency"].options = <?php echo JsonEncode($cost_calculator_search->currency->lookupOptions()) ?>;
fcost_calculatorsearch.lists["x_packing_type"] = <?php echo $cost_calculator_search->packing_type->Lookup->toClientList() ?>;
fcost_calculatorsearch.lists["x_packing_type"].options = <?php echo JsonEncode($cost_calculator_search->packing_type->lookupOptions()) ?>;
fcost_calculatorsearch.lists["x_operator"] = <?php echo $cost_calculator_search->operator->Lookup->toClientList() ?>;
fcost_calculatorsearch.lists["x_operator"].options = <?php echo JsonEncode($cost_calculator_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fcost_calculatorsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($cost_calculator->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_price_inr");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($cost_calculator->price_inr->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_w_cm");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($cost_calculator->w_cm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_l_cm");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($cost_calculator->l_cm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_bom_percent");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($cost_calculator->bom_percent->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_process_percent");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($cost_calculator->process_percent->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_other_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($cost_calculator->other_sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_margin_percent");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($cost_calculator->margin_percent->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_price");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($cost_calculator->price->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($cost_calculator->dated->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($cost_calculator->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $cost_calculator_search->showPageHeader(); ?>
<?php
$cost_calculator_search->showMessage();
?>
<form name="fcost_calculatorsearch" id="fcost_calculatorsearch" class="<?php echo $cost_calculator_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($cost_calculator_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $cost_calculator_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="cost_calculator">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$cost_calculator_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($cost_calculator->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $cost_calculator_search->LeftColumnClass ?>"><span id="elh_cost_calculator_id"><?php echo $cost_calculator->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $cost_calculator_search->RightColumnClass ?>"><div<?php echo $cost_calculator->id->cellAttributes() ?>>
			<span id="el_cost_calculator_id">
<input type="text" data-table="cost_calculator" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($cost_calculator->id->getPlaceHolder()) ?>" value="<?php echo $cost_calculator->id->EditValue ?>"<?php echo $cost_calculator->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($cost_calculator->buyer_id->Visible) { // buyer_id ?>
	<div id="r_buyer_id" class="form-group row">
		<label for="x_buyer_id" class="<?php echo $cost_calculator_search->LeftColumnClass ?>"><span id="elh_cost_calculator_buyer_id"><?php echo $cost_calculator->buyer_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer_id" id="z_buyer_id" value="="></span>
		</label>
		<div class="<?php echo $cost_calculator_search->RightColumnClass ?>"><div<?php echo $cost_calculator->buyer_id->cellAttributes() ?>>
			<span id="el_cost_calculator_buyer_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cost_calculator" data-field="x_buyer_id" data-value-separator="<?php echo $cost_calculator->buyer_id->displayValueSeparatorAttribute() ?>" id="x_buyer_id" name="x_buyer_id"<?php echo $cost_calculator->buyer_id->editAttributes() ?>>
		<?php echo $cost_calculator->buyer_id->selectOptionListHtml("x_buyer_id") ?>
	</select>
</div>
<?php echo $cost_calculator->buyer_id->Lookup->getParamTag("p_x_buyer_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($cost_calculator->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label for="x_rid" class="<?php echo $cost_calculator_search->LeftColumnClass ?>"><span id="elh_cost_calculator_rid"><?php echo $cost_calculator->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		</label>
		<div class="<?php echo $cost_calculator_search->RightColumnClass ?>"><div<?php echo $cost_calculator->rid->cellAttributes() ?>>
			<span id="el_cost_calculator_rid">
<input type="text" data-table="cost_calculator" data-field="x_rid" name="x_rid" id="x_rid" size="30" placeholder="<?php echo HtmlEncode($cost_calculator->rid->getPlaceHolder()) ?>" value="<?php echo $cost_calculator->rid->EditValue ?>"<?php echo $cost_calculator->rid->editAttributes() ?>>
<?php echo $cost_calculator->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($cost_calculator->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label for="x_batch_no" class="<?php echo $cost_calculator_search->LeftColumnClass ?>"><span id="elh_cost_calculator_batch_no"><?php echo $cost_calculator->batch_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_batch_no" id="z_batch_no" value="="></span>
		</label>
		<div class="<?php echo $cost_calculator_search->RightColumnClass ?>"><div<?php echo $cost_calculator->batch_no->cellAttributes() ?>>
			<span id="el_cost_calculator_batch_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cost_calculator" data-field="x_batch_no" data-value-separator="<?php echo $cost_calculator->batch_no->displayValueSeparatorAttribute() ?>" id="x_batch_no" name="x_batch_no"<?php echo $cost_calculator->batch_no->editAttributes() ?>>
		<?php echo $cost_calculator->batch_no->selectOptionListHtml("x_batch_no") ?>
	</select>
</div>
<?php echo $cost_calculator->batch_no->Lookup->getParamTag("p_x_batch_no") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($cost_calculator->price_inr->Visible) { // price_inr ?>
	<div id="r_price_inr" class="form-group row">
		<label for="x_price_inr" class="<?php echo $cost_calculator_search->LeftColumnClass ?>"><span id="elh_cost_calculator_price_inr"><?php echo $cost_calculator->price_inr->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_price_inr" id="z_price_inr" value="="></span>
		</label>
		<div class="<?php echo $cost_calculator_search->RightColumnClass ?>"><div<?php echo $cost_calculator->price_inr->cellAttributes() ?>>
			<span id="el_cost_calculator_price_inr">
<input type="text" data-table="cost_calculator" data-field="x_price_inr" name="x_price_inr" id="x_price_inr" size="30" placeholder="<?php echo HtmlEncode($cost_calculator->price_inr->getPlaceHolder()) ?>" value="<?php echo $cost_calculator->price_inr->EditValue ?>"<?php echo $cost_calculator->price_inr->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($cost_calculator->shape->Visible) { // shape ?>
	<div id="r_shape" class="form-group row">
		<label for="x_shape" class="<?php echo $cost_calculator_search->LeftColumnClass ?>"><span id="elh_cost_calculator_shape"><?php echo $cost_calculator->shape->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_shape" id="z_shape" value="="></span>
		</label>
		<div class="<?php echo $cost_calculator_search->RightColumnClass ?>"><div<?php echo $cost_calculator->shape->cellAttributes() ?>>
			<span id="el_cost_calculator_shape">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cost_calculator" data-field="x_shape" data-value-separator="<?php echo $cost_calculator->shape->displayValueSeparatorAttribute() ?>" id="x_shape" name="x_shape"<?php echo $cost_calculator->shape->editAttributes() ?>>
		<?php echo $cost_calculator->shape->selectOptionListHtml("x_shape") ?>
	</select>
</div>
<?php echo $cost_calculator->shape->Lookup->getParamTag("p_x_shape") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($cost_calculator->w_cm->Visible) { // w_cm ?>
	<div id="r_w_cm" class="form-group row">
		<label for="x_w_cm" class="<?php echo $cost_calculator_search->LeftColumnClass ?>"><span id="elh_cost_calculator_w_cm"><?php echo $cost_calculator->w_cm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_w_cm" id="z_w_cm" value="="></span>
		</label>
		<div class="<?php echo $cost_calculator_search->RightColumnClass ?>"><div<?php echo $cost_calculator->w_cm->cellAttributes() ?>>
			<span id="el_cost_calculator_w_cm">
<input type="text" data-table="cost_calculator" data-field="x_w_cm" name="x_w_cm" id="x_w_cm" size="30" placeholder="<?php echo HtmlEncode($cost_calculator->w_cm->getPlaceHolder()) ?>" value="<?php echo $cost_calculator->w_cm->EditValue ?>"<?php echo $cost_calculator->w_cm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($cost_calculator->l_cm->Visible) { // l_cm ?>
	<div id="r_l_cm" class="form-group row">
		<label for="x_l_cm" class="<?php echo $cost_calculator_search->LeftColumnClass ?>"><span id="elh_cost_calculator_l_cm"><?php echo $cost_calculator->l_cm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_l_cm" id="z_l_cm" value="="></span>
		</label>
		<div class="<?php echo $cost_calculator_search->RightColumnClass ?>"><div<?php echo $cost_calculator->l_cm->cellAttributes() ?>>
			<span id="el_cost_calculator_l_cm">
<input type="text" data-table="cost_calculator" data-field="x_l_cm" name="x_l_cm" id="x_l_cm" size="30" placeholder="<?php echo HtmlEncode($cost_calculator->l_cm->getPlaceHolder()) ?>" value="<?php echo $cost_calculator->l_cm->EditValue ?>"<?php echo $cost_calculator->l_cm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($cost_calculator->bom_percent->Visible) { // bom_percent ?>
	<div id="r_bom_percent" class="form-group row">
		<label for="x_bom_percent" class="<?php echo $cost_calculator_search->LeftColumnClass ?>"><span id="elh_cost_calculator_bom_percent"><?php echo $cost_calculator->bom_percent->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_bom_percent" id="z_bom_percent" value="="></span>
		</label>
		<div class="<?php echo $cost_calculator_search->RightColumnClass ?>"><div<?php echo $cost_calculator->bom_percent->cellAttributes() ?>>
			<span id="el_cost_calculator_bom_percent">
<input type="text" data-table="cost_calculator" data-field="x_bom_percent" name="x_bom_percent" id="x_bom_percent" size="30" placeholder="<?php echo HtmlEncode($cost_calculator->bom_percent->getPlaceHolder()) ?>" value="<?php echo $cost_calculator->bom_percent->EditValue ?>"<?php echo $cost_calculator->bom_percent->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($cost_calculator->process_percent->Visible) { // process_percent ?>
	<div id="r_process_percent" class="form-group row">
		<label for="x_process_percent" class="<?php echo $cost_calculator_search->LeftColumnClass ?>"><span id="elh_cost_calculator_process_percent"><?php echo $cost_calculator->process_percent->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process_percent" id="z_process_percent" value="="></span>
		</label>
		<div class="<?php echo $cost_calculator_search->RightColumnClass ?>"><div<?php echo $cost_calculator->process_percent->cellAttributes() ?>>
			<span id="el_cost_calculator_process_percent">
<input type="text" data-table="cost_calculator" data-field="x_process_percent" name="x_process_percent" id="x_process_percent" size="30" placeholder="<?php echo HtmlEncode($cost_calculator->process_percent->getPlaceHolder()) ?>" value="<?php echo $cost_calculator->process_percent->EditValue ?>"<?php echo $cost_calculator->process_percent->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($cost_calculator->other_sqm->Visible) { // other_sqm ?>
	<div id="r_other_sqm" class="form-group row">
		<label for="x_other_sqm" class="<?php echo $cost_calculator_search->LeftColumnClass ?>"><span id="elh_cost_calculator_other_sqm"><?php echo $cost_calculator->other_sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_other_sqm" id="z_other_sqm" value="="></span>
		</label>
		<div class="<?php echo $cost_calculator_search->RightColumnClass ?>"><div<?php echo $cost_calculator->other_sqm->cellAttributes() ?>>
			<span id="el_cost_calculator_other_sqm">
<input type="text" data-table="cost_calculator" data-field="x_other_sqm" name="x_other_sqm" id="x_other_sqm" size="30" placeholder="<?php echo HtmlEncode($cost_calculator->other_sqm->getPlaceHolder()) ?>" value="<?php echo $cost_calculator->other_sqm->EditValue ?>"<?php echo $cost_calculator->other_sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($cost_calculator->margin_percent->Visible) { // margin_percent ?>
	<div id="r_margin_percent" class="form-group row">
		<label for="x_margin_percent" class="<?php echo $cost_calculator_search->LeftColumnClass ?>"><span id="elh_cost_calculator_margin_percent"><?php echo $cost_calculator->margin_percent->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_margin_percent" id="z_margin_percent" value="="></span>
		</label>
		<div class="<?php echo $cost_calculator_search->RightColumnClass ?>"><div<?php echo $cost_calculator->margin_percent->cellAttributes() ?>>
			<span id="el_cost_calculator_margin_percent">
<input type="text" data-table="cost_calculator" data-field="x_margin_percent" name="x_margin_percent" id="x_margin_percent" size="30" placeholder="<?php echo HtmlEncode($cost_calculator->margin_percent->getPlaceHolder()) ?>" value="<?php echo $cost_calculator->margin_percent->EditValue ?>"<?php echo $cost_calculator->margin_percent->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($cost_calculator->price->Visible) { // price ?>
	<div id="r_price" class="form-group row">
		<label for="x_price" class="<?php echo $cost_calculator_search->LeftColumnClass ?>"><span id="elh_cost_calculator_price"><?php echo $cost_calculator->price->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_price" id="z_price" value="="></span>
		</label>
		<div class="<?php echo $cost_calculator_search->RightColumnClass ?>"><div<?php echo $cost_calculator->price->cellAttributes() ?>>
			<span id="el_cost_calculator_price">
<input type="text" data-table="cost_calculator" data-field="x_price" name="x_price" id="x_price" size="30" placeholder="<?php echo HtmlEncode($cost_calculator->price->getPlaceHolder()) ?>" value="<?php echo $cost_calculator->price->EditValue ?>"<?php echo $cost_calculator->price->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($cost_calculator->currency->Visible) { // currency ?>
	<div id="r_currency" class="form-group row">
		<label for="x_currency" class="<?php echo $cost_calculator_search->LeftColumnClass ?>"><span id="elh_cost_calculator_currency"><?php echo $cost_calculator->currency->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_currency" id="z_currency" value="="></span>
		</label>
		<div class="<?php echo $cost_calculator_search->RightColumnClass ?>"><div<?php echo $cost_calculator->currency->cellAttributes() ?>>
			<span id="el_cost_calculator_currency">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cost_calculator" data-field="x_currency" data-value-separator="<?php echo $cost_calculator->currency->displayValueSeparatorAttribute() ?>" id="x_currency" name="x_currency"<?php echo $cost_calculator->currency->editAttributes() ?>>
		<?php echo $cost_calculator->currency->selectOptionListHtml("x_currency") ?>
	</select>
</div>
<?php echo $cost_calculator->currency->Lookup->getParamTag("p_x_currency") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($cost_calculator->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $cost_calculator_search->LeftColumnClass ?>"><span id="elh_cost_calculator_dated"><?php echo $cost_calculator->dated->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_dated" id="z_dated" value="="></span>
		</label>
		<div class="<?php echo $cost_calculator_search->RightColumnClass ?>"><div<?php echo $cost_calculator->dated->cellAttributes() ?>>
			<span id="el_cost_calculator_dated">
<input type="text" data-table="cost_calculator" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($cost_calculator->dated->getPlaceHolder()) ?>" value="<?php echo $cost_calculator->dated->EditValue ?>"<?php echo $cost_calculator->dated->editAttributes() ?>>
<?php if (!$cost_calculator->dated->ReadOnly && !$cost_calculator->dated->Disabled && !isset($cost_calculator->dated->EditAttrs["readonly"]) && !isset($cost_calculator->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fcost_calculatorsearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($cost_calculator->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $cost_calculator_search->LeftColumnClass ?>"><span id="elh_cost_calculator_packing_type"><?php echo $cost_calculator->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $cost_calculator_search->RightColumnClass ?>"><div<?php echo $cost_calculator->packing_type->cellAttributes() ?>>
			<span id="el_cost_calculator_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cost_calculator" data-field="x_packing_type" data-value-separator="<?php echo $cost_calculator->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $cost_calculator->packing_type->editAttributes() ?>>
		<?php echo $cost_calculator->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $cost_calculator->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($cost_calculator->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $cost_calculator_search->LeftColumnClass ?>"><span id="elh_cost_calculator_operator"><?php echo $cost_calculator->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $cost_calculator_search->RightColumnClass ?>"><div<?php echo $cost_calculator->operator->cellAttributes() ?>>
			<span id="el_cost_calculator_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cost_calculator" data-field="x_operator" data-value-separator="<?php echo $cost_calculator->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $cost_calculator->operator->editAttributes() ?>>
		<?php echo $cost_calculator->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $cost_calculator->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($cost_calculator->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $cost_calculator_search->LeftColumnClass ?>"><span id="elh_cost_calculator_datetime"><?php echo $cost_calculator->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $cost_calculator_search->RightColumnClass ?>"><div<?php echo $cost_calculator->datetime->cellAttributes() ?>>
			<span id="el_cost_calculator_datetime">
<input type="text" data-table="cost_calculator" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($cost_calculator->datetime->getPlaceHolder()) ?>" value="<?php echo $cost_calculator->datetime->EditValue ?>"<?php echo $cost_calculator->datetime->editAttributes() ?>>
<?php if (!$cost_calculator->datetime->ReadOnly && !$cost_calculator->datetime->Disabled && !isset($cost_calculator->datetime->EditAttrs["readonly"]) && !isset($cost_calculator->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fcost_calculatorsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$cost_calculator_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $cost_calculator_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$cost_calculator_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$cost_calculator_search->terminate();
?>