<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$csv_import_add = new csv_import_add();

// Run the page
$csv_import_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$csv_import_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fcsv_importadd = currentForm = new ew.Form("fcsv_importadd", "add");

// Validate form
fcsv_importadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($csv_import_add->csv_import->Required) { ?>
			elm = this.getElements("x" + infix + "_csv_import");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $csv_import->csv_import->caption(), $csv_import->csv_import->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fcsv_importadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcsv_importadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $csv_import_add->showPageHeader(); ?>
<?php
$csv_import_add->showMessage();
?>
<form name="fcsv_importadd" id="fcsv_importadd" class="<?php echo $csv_import_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($csv_import_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $csv_import_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="csv_import">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$csv_import_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($csv_import->csv_import->Visible) { // csv_import ?>
	<div id="r_csv_import" class="form-group row">
		<label id="elh_csv_import_csv_import" for="x_csv_import" class="<?php echo $csv_import_add->LeftColumnClass ?>"><?php echo $csv_import->csv_import->caption() ?><?php echo ($csv_import->csv_import->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $csv_import_add->RightColumnClass ?>"><div<?php echo $csv_import->csv_import->cellAttributes() ?>>
<span id="el_csv_import_csv_import">
<textarea data-table="csv_import" data-field="x_csv_import" name="x_csv_import" id="x_csv_import" cols="35" rows="4" placeholder="<?php echo HtmlEncode($csv_import->csv_import->getPlaceHolder()) ?>"<?php echo $csv_import->csv_import->editAttributes() ?>><?php echo $csv_import->csv_import->EditValue ?></textarea>
</span>
<?php echo $csv_import->csv_import->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$csv_import_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $csv_import_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $csv_import_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$csv_import_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$csv_import_add->terminate();
?>