<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$csv_import_edit = new csv_import_edit();

// Run the page
$csv_import_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$csv_import_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fcsv_importedit = currentForm = new ew.Form("fcsv_importedit", "edit");

// Validate form
fcsv_importedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($csv_import_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $csv_import->id->caption(), $csv_import->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($csv_import_edit->csv_import->Required) { ?>
			elm = this.getElements("x" + infix + "_csv_import");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $csv_import->csv_import->caption(), $csv_import->csv_import->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fcsv_importedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcsv_importedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $csv_import_edit->showPageHeader(); ?>
<?php
$csv_import_edit->showMessage();
?>
<form name="fcsv_importedit" id="fcsv_importedit" class="<?php echo $csv_import_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($csv_import_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $csv_import_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="csv_import">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$csv_import_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($csv_import->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_csv_import_id" class="<?php echo $csv_import_edit->LeftColumnClass ?>"><?php echo $csv_import->id->caption() ?><?php echo ($csv_import->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $csv_import_edit->RightColumnClass ?>"><div<?php echo $csv_import->id->cellAttributes() ?>>
<span id="el_csv_import_id">
<span<?php echo $csv_import->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($csv_import->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="csv_import" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($csv_import->id->CurrentValue) ?>">
<?php echo $csv_import->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($csv_import->csv_import->Visible) { // csv_import ?>
	<div id="r_csv_import" class="form-group row">
		<label id="elh_csv_import_csv_import" for="x_csv_import" class="<?php echo $csv_import_edit->LeftColumnClass ?>"><?php echo $csv_import->csv_import->caption() ?><?php echo ($csv_import->csv_import->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $csv_import_edit->RightColumnClass ?>"><div<?php echo $csv_import->csv_import->cellAttributes() ?>>
<span id="el_csv_import_csv_import">
<textarea data-table="csv_import" data-field="x_csv_import" name="x_csv_import" id="x_csv_import" cols="35" rows="4" placeholder="<?php echo HtmlEncode($csv_import->csv_import->getPlaceHolder()) ?>"<?php echo $csv_import->csv_import->editAttributes() ?>><?php echo $csv_import->csv_import->EditValue ?></textarea>
</span>
<?php echo $csv_import->csv_import->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$csv_import_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $csv_import_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $csv_import_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$csv_import_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$csv_import_edit->terminate();
?>