<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$csv_import_list = new csv_import_list();

// Run the page
$csv_import_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$csv_import_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$csv_import->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fcsv_importlist = currentForm = new ew.Form("fcsv_importlist", "list");
fcsv_importlist.formKeyCountName = '<?php echo $csv_import_list->FormKeyCountName ?>';

// Form_CustomValidate event
fcsv_importlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcsv_importlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var fcsv_importlistsrch = currentSearchForm = new ew.Form("fcsv_importlistsrch");

// Filters
fcsv_importlistsrch.filterList = <?php echo $csv_import_list->getFilterList() ?>;

// Init search panel as collapsed
fcsv_importlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$csv_import->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($csv_import_list->TotalRecs > 0 && $csv_import_list->ExportOptions->visible()) { ?>
<?php $csv_import_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($csv_import_list->ImportOptions->visible()) { ?>
<?php $csv_import_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($csv_import_list->SearchOptions->visible()) { ?>
<?php $csv_import_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($csv_import_list->FilterOptions->visible()) { ?>
<?php $csv_import_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$csv_import_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$csv_import->isExport() && !$csv_import->CurrentAction) { ?>
<form name="fcsv_importlistsrch" id="fcsv_importlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($csv_import_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fcsv_importlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="csv_import">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($csv_import_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($csv_import_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $csv_import_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($csv_import_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($csv_import_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($csv_import_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($csv_import_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $csv_import_list->showPageHeader(); ?>
<?php
$csv_import_list->showMessage();
?>
<?php if ($csv_import_list->TotalRecs > 0 || $csv_import->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($csv_import_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> csv_import">
<?php if (!$csv_import->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$csv_import->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($csv_import_list->Pager)) $csv_import_list->Pager = new PrevNextPager($csv_import_list->StartRec, $csv_import_list->DisplayRecs, $csv_import_list->TotalRecs, $csv_import_list->AutoHidePager) ?>
<?php if ($csv_import_list->Pager->RecordCount > 0 && $csv_import_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($csv_import_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $csv_import_list->pageUrl() ?>start=<?php echo $csv_import_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($csv_import_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $csv_import_list->pageUrl() ?>start=<?php echo $csv_import_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $csv_import_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($csv_import_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $csv_import_list->pageUrl() ?>start=<?php echo $csv_import_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($csv_import_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $csv_import_list->pageUrl() ?>start=<?php echo $csv_import_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $csv_import_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($csv_import_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $csv_import_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $csv_import_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $csv_import_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($csv_import_list->TotalRecs > 0 && (!$csv_import_list->AutoHidePageSizeSelector || $csv_import_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="csv_import">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($csv_import_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($csv_import_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($csv_import_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($csv_import_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($csv_import_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($csv_import->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $csv_import_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fcsv_importlist" id="fcsv_importlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($csv_import_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $csv_import_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="csv_import">
<div id="gmp_csv_import" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($csv_import_list->TotalRecs > 0 || $csv_import->isGridEdit()) { ?>
<table id="tbl_csv_importlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$csv_import_list->RowType = ROWTYPE_HEADER;

// Render list options
$csv_import_list->renderListOptions();

// Render list options (header, left)
$csv_import_list->ListOptions->render("header", "left");
?>
<?php if ($csv_import->id->Visible) { // id ?>
	<?php if ($csv_import->sortUrl($csv_import->id) == "") { ?>
		<th data-name="id" class="<?php echo $csv_import->id->headerCellClass() ?>"><div id="elh_csv_import_id" class="csv_import_id"><div class="ew-table-header-caption"><?php echo $csv_import->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $csv_import->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $csv_import->SortUrl($csv_import->id) ?>',2);"><div id="elh_csv_import_id" class="csv_import_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $csv_import->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($csv_import->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($csv_import->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($csv_import->csv_import->Visible) { // csv_import ?>
	<?php if ($csv_import->sortUrl($csv_import->csv_import) == "") { ?>
		<th data-name="csv_import" class="<?php echo $csv_import->csv_import->headerCellClass() ?>"><div id="elh_csv_import_csv_import" class="csv_import_csv_import"><div class="ew-table-header-caption"><?php echo $csv_import->csv_import->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="csv_import" class="<?php echo $csv_import->csv_import->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $csv_import->SortUrl($csv_import->csv_import) ?>',2);"><div id="elh_csv_import_csv_import" class="csv_import_csv_import">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $csv_import->csv_import->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($csv_import->csv_import->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($csv_import->csv_import->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$csv_import_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($csv_import->ExportAll && $csv_import->isExport()) {
	$csv_import_list->StopRec = $csv_import_list->TotalRecs;
} else {

	// Set the last record to display
	if ($csv_import_list->TotalRecs > $csv_import_list->StartRec + $csv_import_list->DisplayRecs - 1)
		$csv_import_list->StopRec = $csv_import_list->StartRec + $csv_import_list->DisplayRecs - 1;
	else
		$csv_import_list->StopRec = $csv_import_list->TotalRecs;
}
$csv_import_list->RecCnt = $csv_import_list->StartRec - 1;
if ($csv_import_list->Recordset && !$csv_import_list->Recordset->EOF) {
	$csv_import_list->Recordset->moveFirst();
	$selectLimit = $csv_import_list->UseSelectLimit;
	if (!$selectLimit && $csv_import_list->StartRec > 1)
		$csv_import_list->Recordset->move($csv_import_list->StartRec - 1);
} elseif (!$csv_import->AllowAddDeleteRow && $csv_import_list->StopRec == 0) {
	$csv_import_list->StopRec = $csv_import->GridAddRowCount;
}

// Initialize aggregate
$csv_import->RowType = ROWTYPE_AGGREGATEINIT;
$csv_import->resetAttributes();
$csv_import_list->renderRow();
while ($csv_import_list->RecCnt < $csv_import_list->StopRec) {
	$csv_import_list->RecCnt++;
	if ($csv_import_list->RecCnt >= $csv_import_list->StartRec) {
		$csv_import_list->RowCnt++;

		// Set up key count
		$csv_import_list->KeyCount = $csv_import_list->RowIndex;

		// Init row class and style
		$csv_import->resetAttributes();
		$csv_import->CssClass = "";
		if ($csv_import->isGridAdd()) {
		} else {
			$csv_import_list->loadRowValues($csv_import_list->Recordset); // Load row values
		}
		$csv_import->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$csv_import->RowAttrs = array_merge($csv_import->RowAttrs, array('data-rowindex'=>$csv_import_list->RowCnt, 'id'=>'r' . $csv_import_list->RowCnt . '_csv_import', 'data-rowtype'=>$csv_import->RowType));

		// Render row
		$csv_import_list->renderRow();

		// Render list options
		$csv_import_list->renderListOptions();
?>
	<tr<?php echo $csv_import->rowAttributes() ?>>
<?php

// Render list options (body, left)
$csv_import_list->ListOptions->render("body", "left", $csv_import_list->RowCnt);
?>
	<?php if ($csv_import->id->Visible) { // id ?>
		<td data-name="id"<?php echo $csv_import->id->cellAttributes() ?>>
<span id="el<?php echo $csv_import_list->RowCnt ?>_csv_import_id" class="csv_import_id">
<span<?php echo $csv_import->id->viewAttributes() ?>>
<?php echo $csv_import->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($csv_import->csv_import->Visible) { // csv_import ?>
		<td data-name="csv_import"<?php echo $csv_import->csv_import->cellAttributes() ?>>
<span id="el<?php echo $csv_import_list->RowCnt ?>_csv_import_csv_import" class="csv_import_csv_import">
<span<?php echo $csv_import->csv_import->viewAttributes() ?>>
<?php echo $csv_import->csv_import->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$csv_import_list->ListOptions->render("body", "right", $csv_import_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$csv_import->isGridAdd())
		$csv_import_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$csv_import->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($csv_import_list->Recordset)
	$csv_import_list->Recordset->Close();
?>
<?php if (!$csv_import->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$csv_import->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($csv_import_list->Pager)) $csv_import_list->Pager = new PrevNextPager($csv_import_list->StartRec, $csv_import_list->DisplayRecs, $csv_import_list->TotalRecs, $csv_import_list->AutoHidePager) ?>
<?php if ($csv_import_list->Pager->RecordCount > 0 && $csv_import_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($csv_import_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $csv_import_list->pageUrl() ?>start=<?php echo $csv_import_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($csv_import_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $csv_import_list->pageUrl() ?>start=<?php echo $csv_import_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $csv_import_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($csv_import_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $csv_import_list->pageUrl() ?>start=<?php echo $csv_import_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($csv_import_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $csv_import_list->pageUrl() ?>start=<?php echo $csv_import_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $csv_import_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($csv_import_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $csv_import_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $csv_import_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $csv_import_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($csv_import_list->TotalRecs > 0 && (!$csv_import_list->AutoHidePageSizeSelector || $csv_import_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="csv_import">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($csv_import_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($csv_import_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($csv_import_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($csv_import_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($csv_import_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($csv_import->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $csv_import_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($csv_import_list->TotalRecs == 0 && !$csv_import->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $csv_import_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$csv_import_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$csv_import->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$csv_import->isExport()) { ?>
<script>
ew.scrollableTable("gmp_csv_import", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$csv_import_list->terminate();
?>