<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$csv_import_view = new csv_import_view();

// Run the page
$csv_import_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$csv_import_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$csv_import->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fcsv_importview = currentForm = new ew.Form("fcsv_importview", "view");

// Form_CustomValidate event
fcsv_importview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcsv_importview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$csv_import->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $csv_import_view->ExportOptions->render("body") ?>
<?php $csv_import_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $csv_import_view->showPageHeader(); ?>
<?php
$csv_import_view->showMessage();
?>
<form name="fcsv_importview" id="fcsv_importview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($csv_import_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $csv_import_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="csv_import">
<input type="hidden" name="modal" value="<?php echo (int)$csv_import_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($csv_import->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $csv_import_view->TableLeftColumnClass ?>"><span id="elh_csv_import_id"><?php echo $csv_import->id->caption() ?></span></td>
		<td data-name="id"<?php echo $csv_import->id->cellAttributes() ?>>
<span id="el_csv_import_id">
<span<?php echo $csv_import->id->viewAttributes() ?>>
<?php echo $csv_import->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($csv_import->csv_import->Visible) { // csv_import ?>
	<tr id="r_csv_import">
		<td class="<?php echo $csv_import_view->TableLeftColumnClass ?>"><span id="elh_csv_import_csv_import"><?php echo $csv_import->csv_import->caption() ?></span></td>
		<td data-name="csv_import"<?php echo $csv_import->csv_import->cellAttributes() ?>>
<span id="el_csv_import_csv_import">
<span<?php echo $csv_import->csv_import->viewAttributes() ?>>
<?php echo $csv_import->csv_import->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$csv_import_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$csv_import->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$csv_import_view->terminate();
?>