<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$currency_addopt = new currency_addopt();

// Run the page
$currency_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$currency_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fcurrencyaddopt = currentForm = new ew.Form("fcurrencyaddopt", "addopt");

// Validate form
fcurrencyaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($currency_addopt->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $currency->name->caption(), $currency->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($currency_addopt->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $currency->code->caption(), $currency->code->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){3,3}$/))
				return this.onError(elm, "<?php echo JsEncode($currency->code->errorMessage()) ?>");
		<?php if ($currency_addopt->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $currency->status->caption(), $currency->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($currency_addopt->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $currency->operator->caption(), $currency->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($currency_addopt->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $currency->datetime->caption(), $currency->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($currency_addopt->symbol->Required) { ?>
			elm = this.getElements("x" + infix + "_symbol");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $currency->symbol->caption(), $currency->symbol->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($currency_addopt->default_currency->Required) { ?>
			elm = this.getElements("x" + infix + "_default_currency");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $currency->default_currency->caption(), $currency->default_currency->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($currency_addopt->exchange_inr->Required) { ?>
			elm = this.getElements("x" + infix + "_exchange_inr");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $currency->exchange_inr->caption(), $currency->exchange_inr->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_exchange_inr");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($currency->exchange_inr->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fcurrencyaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcurrencyaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcurrencyaddopt.lists["x_status"] = <?php echo $currency_addopt->status->Lookup->toClientList() ?>;
fcurrencyaddopt.lists["x_status"].options = <?php echo JsonEncode($currency_addopt->status->options(FALSE, TRUE)) ?>;
fcurrencyaddopt.lists["x_operator"] = <?php echo $currency_addopt->operator->Lookup->toClientList() ?>;
fcurrencyaddopt.lists["x_operator"].options = <?php echo JsonEncode($currency_addopt->operator->lookupOptions()) ?>;
fcurrencyaddopt.lists["x_default_currency"] = <?php echo $currency_addopt->default_currency->Lookup->toClientList() ?>;
fcurrencyaddopt.lists["x_default_currency"].options = <?php echo JsonEncode($currency_addopt->default_currency->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $currency_addopt->showPageHeader(); ?>
<?php
$currency_addopt->showMessage();
?>
<form name="fcurrencyaddopt" id="fcurrencyaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($currency_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $currency_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $currency_addopt->TableVar ?>">
<?php if ($currency->name->Visible) { // name ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_name"><?php echo $currency->name->caption() ?><?php echo ($currency->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="currency" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($currency->name->getPlaceHolder()) ?>" value="<?php echo $currency->name->EditValue ?>"<?php echo $currency->name->editAttributes() ?>>
<?php echo $currency->name->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($currency->code->Visible) { // code ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_code"><?php echo $currency->code->caption() ?><?php echo ($currency->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="currency" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($currency->code->getPlaceHolder()) ?>" value="<?php echo $currency->code->EditValue ?>"<?php echo $currency->code->editAttributes() ?>>
<?php echo $currency->code->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($currency->status->Visible) { // status ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_status"><?php echo $currency->status->caption() ?><?php echo ($currency->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="currency" data-field="x_status" data-value-separator="<?php echo $currency->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $currency->status->editAttributes() ?>>
		<?php echo $currency->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $currency->status->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($currency->operator->Visible) { // operator ?>
	<input type="hidden" data-table="currency" data-field="x_operator" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($currency->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($currency->datetime->Visible) { // datetime ?>
	<input type="hidden" data-table="currency" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($currency->datetime->CurrentValue) ?>">
	<?php if (!$currency->datetime->ReadOnly && !$currency->datetime->Disabled && !isset($currency->datetime->EditAttrs["readonly"]) && !isset($currency->datetime->EditAttrs["disabled"])) { ?>
	<script>
	ew.createDateTimePicker("fcurrencyaddopt", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
	</script>
	<?php } ?>
<?php } ?>
<?php if ($currency->symbol->Visible) { // symbol ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_symbol"><?php echo $currency->symbol->caption() ?><?php echo ($currency->symbol->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="currency" data-field="x_symbol" name="x_symbol" id="x_symbol" size="30" maxlength="5" placeholder="<?php echo HtmlEncode($currency->symbol->getPlaceHolder()) ?>" value="<?php echo $currency->symbol->EditValue ?>"<?php echo $currency->symbol->editAttributes() ?>>
<?php echo $currency->symbol->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($currency->default_currency->Visible) { // default_currency ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_default_currency"><?php echo $currency->default_currency->caption() ?><?php echo ($currency->default_currency->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="currency" data-field="x_default_currency" data-value-separator="<?php echo $currency->default_currency->displayValueSeparatorAttribute() ?>" id="x_default_currency" name="x_default_currency"<?php echo $currency->default_currency->editAttributes() ?>>
		<?php echo $currency->default_currency->selectOptionListHtml("x_default_currency") ?>
	</select>
</div>
<?php echo $currency->default_currency->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($currency->exchange_inr->Visible) { // exchange_inr ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_exchange_inr"><?php echo $currency->exchange_inr->caption() ?><?php echo ($currency->exchange_inr->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="currency" data-field="x_exchange_inr" name="x_exchange_inr" id="x_exchange_inr" size="30" placeholder="<?php echo HtmlEncode($currency->exchange_inr->getPlaceHolder()) ?>" value="<?php echo $currency->exchange_inr->EditValue ?>"<?php echo $currency->exchange_inr->editAttributes() ?>>
<?php echo $currency->exchange_inr->CustomMsg ?></div>
	</div>
<?php } ?>
</form>
<?php
$currency_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$currency_addopt->terminate();
?>