<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$currency_delete = new currency_delete();

// Run the page
$currency_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$currency_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var fcurrencydelete = currentForm = new ew.Form("fcurrencydelete", "delete");

// Form_CustomValidate event
fcurrencydelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcurrencydelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcurrencydelete.lists["x_status"] = <?php echo $currency_delete->status->Lookup->toClientList() ?>;
fcurrencydelete.lists["x_status"].options = <?php echo JsonEncode($currency_delete->status->options(FALSE, TRUE)) ?>;
fcurrencydelete.lists["x_operator"] = <?php echo $currency_delete->operator->Lookup->toClientList() ?>;
fcurrencydelete.lists["x_operator"].options = <?php echo JsonEncode($currency_delete->operator->lookupOptions()) ?>;
fcurrencydelete.lists["x_default_currency"] = <?php echo $currency_delete->default_currency->Lookup->toClientList() ?>;
fcurrencydelete.lists["x_default_currency"].options = <?php echo JsonEncode($currency_delete->default_currency->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $currency_delete->showPageHeader(); ?>
<?php
$currency_delete->showMessage();
?>
<form name="fcurrencydelete" id="fcurrencydelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($currency_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $currency_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="currency">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($currency_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($currency->id->Visible) { // id ?>
		<th class="<?php echo $currency->id->headerCellClass() ?>"><span id="elh_currency_id" class="currency_id"><?php echo $currency->id->caption() ?></span></th>
<?php } ?>
<?php if ($currency->name->Visible) { // name ?>
		<th class="<?php echo $currency->name->headerCellClass() ?>"><span id="elh_currency_name" class="currency_name"><?php echo $currency->name->caption() ?></span></th>
<?php } ?>
<?php if ($currency->code->Visible) { // code ?>
		<th class="<?php echo $currency->code->headerCellClass() ?>"><span id="elh_currency_code" class="currency_code"><?php echo $currency->code->caption() ?></span></th>
<?php } ?>
<?php if ($currency->status->Visible) { // status ?>
		<th class="<?php echo $currency->status->headerCellClass() ?>"><span id="elh_currency_status" class="currency_status"><?php echo $currency->status->caption() ?></span></th>
<?php } ?>
<?php if ($currency->operator->Visible) { // operator ?>
		<th class="<?php echo $currency->operator->headerCellClass() ?>"><span id="elh_currency_operator" class="currency_operator"><?php echo $currency->operator->caption() ?></span></th>
<?php } ?>
<?php if ($currency->datetime->Visible) { // datetime ?>
		<th class="<?php echo $currency->datetime->headerCellClass() ?>"><span id="elh_currency_datetime" class="currency_datetime"><?php echo $currency->datetime->caption() ?></span></th>
<?php } ?>
<?php if ($currency->symbol->Visible) { // symbol ?>
		<th class="<?php echo $currency->symbol->headerCellClass() ?>"><span id="elh_currency_symbol" class="currency_symbol"><?php echo $currency->symbol->caption() ?></span></th>
<?php } ?>
<?php if ($currency->default_currency->Visible) { // default_currency ?>
		<th class="<?php echo $currency->default_currency->headerCellClass() ?>"><span id="elh_currency_default_currency" class="currency_default_currency"><?php echo $currency->default_currency->caption() ?></span></th>
<?php } ?>
<?php if ($currency->exchange_inr->Visible) { // exchange_inr ?>
		<th class="<?php echo $currency->exchange_inr->headerCellClass() ?>"><span id="elh_currency_exchange_inr" class="currency_exchange_inr"><?php echo $currency->exchange_inr->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$currency_delete->RecCnt = 0;
$i = 0;
while (!$currency_delete->Recordset->EOF) {
	$currency_delete->RecCnt++;
	$currency_delete->RowCnt++;

	// Set row properties
	$currency->resetAttributes();
	$currency->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$currency_delete->loadRowValues($currency_delete->Recordset);

	// Render row
	$currency_delete->renderRow();
?>
	<tr<?php echo $currency->rowAttributes() ?>>
<?php if ($currency->id->Visible) { // id ?>
		<td<?php echo $currency->id->cellAttributes() ?>>
<span id="el<?php echo $currency_delete->RowCnt ?>_currency_id" class="currency_id">
<span<?php echo $currency->id->viewAttributes() ?>>
<?php echo $currency->id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($currency->name->Visible) { // name ?>
		<td<?php echo $currency->name->cellAttributes() ?>>
<span id="el<?php echo $currency_delete->RowCnt ?>_currency_name" class="currency_name">
<span<?php echo $currency->name->viewAttributes() ?>>
<?php echo $currency->name->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($currency->code->Visible) { // code ?>
		<td<?php echo $currency->code->cellAttributes() ?>>
<span id="el<?php echo $currency_delete->RowCnt ?>_currency_code" class="currency_code">
<span<?php echo $currency->code->viewAttributes() ?>>
<?php echo $currency->code->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($currency->status->Visible) { // status ?>
		<td<?php echo $currency->status->cellAttributes() ?>>
<span id="el<?php echo $currency_delete->RowCnt ?>_currency_status" class="currency_status">
<span<?php echo $currency->status->viewAttributes() ?>>
<?php echo $currency->status->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($currency->operator->Visible) { // operator ?>
		<td<?php echo $currency->operator->cellAttributes() ?>>
<span id="el<?php echo $currency_delete->RowCnt ?>_currency_operator" class="currency_operator">
<span<?php echo $currency->operator->viewAttributes() ?>>
<?php echo $currency->operator->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($currency->datetime->Visible) { // datetime ?>
		<td<?php echo $currency->datetime->cellAttributes() ?>>
<span id="el<?php echo $currency_delete->RowCnt ?>_currency_datetime" class="currency_datetime">
<span<?php echo $currency->datetime->viewAttributes() ?>>
<?php echo $currency->datetime->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($currency->symbol->Visible) { // symbol ?>
		<td<?php echo $currency->symbol->cellAttributes() ?>>
<span id="el<?php echo $currency_delete->RowCnt ?>_currency_symbol" class="currency_symbol">
<span<?php echo $currency->symbol->viewAttributes() ?>>
<?php echo $currency->symbol->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($currency->default_currency->Visible) { // default_currency ?>
		<td<?php echo $currency->default_currency->cellAttributes() ?>>
<span id="el<?php echo $currency_delete->RowCnt ?>_currency_default_currency" class="currency_default_currency">
<span<?php echo $currency->default_currency->viewAttributes() ?>>
<?php echo $currency->default_currency->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($currency->exchange_inr->Visible) { // exchange_inr ?>
		<td<?php echo $currency->exchange_inr->cellAttributes() ?>>
<span id="el<?php echo $currency_delete->RowCnt ?>_currency_exchange_inr" class="currency_exchange_inr">
<span<?php echo $currency->exchange_inr->viewAttributes() ?>>
<?php echo $currency->exchange_inr->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$currency_delete->Recordset->moveNext();
}
$currency_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $currency_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$currency_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$currency_delete->terminate();
?>