<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$currency_edit = new currency_edit();

// Run the page
$currency_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$currency_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fcurrencyedit = currentForm = new ew.Form("fcurrencyedit", "edit");

// Validate form
fcurrencyedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($currency_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $currency->id->caption(), $currency->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($currency_edit->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $currency->name->caption(), $currency->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($currency_edit->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $currency->code->caption(), $currency->code->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){3,3}$/))
				return this.onError(elm, "<?php echo JsEncode($currency->code->errorMessage()) ?>");
		<?php if ($currency_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $currency->status->caption(), $currency->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($currency_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $currency->operator->caption(), $currency->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($currency_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $currency->datetime->caption(), $currency->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($currency_edit->symbol->Required) { ?>
			elm = this.getElements("x" + infix + "_symbol");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $currency->symbol->caption(), $currency->symbol->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($currency_edit->default_currency->Required) { ?>
			elm = this.getElements("x" + infix + "_default_currency");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $currency->default_currency->caption(), $currency->default_currency->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($currency_edit->exchange_inr->Required) { ?>
			elm = this.getElements("x" + infix + "_exchange_inr");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $currency->exchange_inr->caption(), $currency->exchange_inr->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_exchange_inr");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($currency->exchange_inr->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fcurrencyedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcurrencyedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcurrencyedit.lists["x_status"] = <?php echo $currency_edit->status->Lookup->toClientList() ?>;
fcurrencyedit.lists["x_status"].options = <?php echo JsonEncode($currency_edit->status->options(FALSE, TRUE)) ?>;
fcurrencyedit.lists["x_operator"] = <?php echo $currency_edit->operator->Lookup->toClientList() ?>;
fcurrencyedit.lists["x_operator"].options = <?php echo JsonEncode($currency_edit->operator->lookupOptions()) ?>;
fcurrencyedit.lists["x_default_currency"] = <?php echo $currency_edit->default_currency->Lookup->toClientList() ?>;
fcurrencyedit.lists["x_default_currency"].options = <?php echo JsonEncode($currency_edit->default_currency->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $currency_edit->showPageHeader(); ?>
<?php
$currency_edit->showMessage();
?>
<form name="fcurrencyedit" id="fcurrencyedit" class="<?php echo $currency_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($currency_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $currency_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="currency">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$currency_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($currency->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_currency_id" class="<?php echo $currency_edit->LeftColumnClass ?>"><?php echo $currency->id->caption() ?><?php echo ($currency->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $currency_edit->RightColumnClass ?>"><div<?php echo $currency->id->cellAttributes() ?>>
<span id="el_currency_id">
<span<?php echo $currency->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($currency->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="currency" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($currency->id->CurrentValue) ?>">
<?php echo $currency->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($currency->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label id="elh_currency_name" for="x_name" class="<?php echo $currency_edit->LeftColumnClass ?>"><?php echo $currency->name->caption() ?><?php echo ($currency->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $currency_edit->RightColumnClass ?>"><div<?php echo $currency->name->cellAttributes() ?>>
<span id="el_currency_name">
<input type="text" data-table="currency" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($currency->name->getPlaceHolder()) ?>" value="<?php echo $currency->name->EditValue ?>"<?php echo $currency->name->editAttributes() ?>>
</span>
<?php echo $currency->name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($currency->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label id="elh_currency_code" for="x_code" class="<?php echo $currency_edit->LeftColumnClass ?>"><?php echo $currency->code->caption() ?><?php echo ($currency->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $currency_edit->RightColumnClass ?>"><div<?php echo $currency->code->cellAttributes() ?>>
<span id="el_currency_code">
<input type="text" data-table="currency" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($currency->code->getPlaceHolder()) ?>" value="<?php echo $currency->code->EditValue ?>"<?php echo $currency->code->editAttributes() ?>>
</span>
<?php echo $currency->code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($currency->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_currency_status" for="x_status" class="<?php echo $currency_edit->LeftColumnClass ?>"><?php echo $currency->status->caption() ?><?php echo ($currency->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $currency_edit->RightColumnClass ?>"><div<?php echo $currency->status->cellAttributes() ?>>
<span id="el_currency_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="currency" data-field="x_status" data-value-separator="<?php echo $currency->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $currency->status->editAttributes() ?>>
		<?php echo $currency->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $currency->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($currency->symbol->Visible) { // symbol ?>
	<div id="r_symbol" class="form-group row">
		<label id="elh_currency_symbol" for="x_symbol" class="<?php echo $currency_edit->LeftColumnClass ?>"><?php echo $currency->symbol->caption() ?><?php echo ($currency->symbol->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $currency_edit->RightColumnClass ?>"><div<?php echo $currency->symbol->cellAttributes() ?>>
<span id="el_currency_symbol">
<input type="text" data-table="currency" data-field="x_symbol" name="x_symbol" id="x_symbol" size="30" maxlength="5" placeholder="<?php echo HtmlEncode($currency->symbol->getPlaceHolder()) ?>" value="<?php echo $currency->symbol->EditValue ?>"<?php echo $currency->symbol->editAttributes() ?>>
</span>
<?php echo $currency->symbol->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($currency->default_currency->Visible) { // default_currency ?>
	<div id="r_default_currency" class="form-group row">
		<label id="elh_currency_default_currency" for="x_default_currency" class="<?php echo $currency_edit->LeftColumnClass ?>"><?php echo $currency->default_currency->caption() ?><?php echo ($currency->default_currency->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $currency_edit->RightColumnClass ?>"><div<?php echo $currency->default_currency->cellAttributes() ?>>
<span id="el_currency_default_currency">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="currency" data-field="x_default_currency" data-value-separator="<?php echo $currency->default_currency->displayValueSeparatorAttribute() ?>" id="x_default_currency" name="x_default_currency"<?php echo $currency->default_currency->editAttributes() ?>>
		<?php echo $currency->default_currency->selectOptionListHtml("x_default_currency") ?>
	</select>
</div>
</span>
<?php echo $currency->default_currency->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($currency->exchange_inr->Visible) { // exchange_inr ?>
	<div id="r_exchange_inr" class="form-group row">
		<label id="elh_currency_exchange_inr" for="x_exchange_inr" class="<?php echo $currency_edit->LeftColumnClass ?>"><?php echo $currency->exchange_inr->caption() ?><?php echo ($currency->exchange_inr->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $currency_edit->RightColumnClass ?>"><div<?php echo $currency->exchange_inr->cellAttributes() ?>>
<span id="el_currency_exchange_inr">
<input type="text" data-table="currency" data-field="x_exchange_inr" name="x_exchange_inr" id="x_exchange_inr" size="30" placeholder="<?php echo HtmlEncode($currency->exchange_inr->getPlaceHolder()) ?>" value="<?php echo $currency->exchange_inr->EditValue ?>"<?php echo $currency->exchange_inr->editAttributes() ?>>
</span>
<?php echo $currency->exchange_inr->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$currency_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $currency_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $currency_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$currency_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$currency_edit->terminate();
?>